/*
 * Decompiled with CFR 0.152.
 */
package asemon.cm;

import asemon.Asemon;
import asemon.cm.CounterTableModel;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.TabularCntrPanel;
import asemon.hostmon.HostMonitor;
import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.hostmon.MonitorMpstat;
import asemon.hostmon.MonitorUserDefined;
import asemon.hostmon.MonitorVmstat;
import asemon.hostmon.OsTable;
import asemon.hostmon.SshConnection;
import asemon.utils.Configuration;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class CounterModelHostMonitor
extends CountersModel {
    private static Logger _logger = Logger.getLogger(CounterModelHostMonitor.class);
    private static final long serialVersionUID = 1L;
    private Timestamp _thisSamplingTime = null;
    private HostMonitor _hostMonitor = null;
    private OsTable _osSampleTable = null;
    private int _hostMonType = 0;
    public static final int HOSTMON_IOSTAT = 1;
    public static final int HOSTMON_VMSTAT = 2;
    public static final int HOSTMON_MPSTAT = 3;
    public static final int HOSTMON_UD_CLASS = 4;
    private String _udModuleName = null;
    private boolean _localInit = false;
    private DefaultTableModel _offlineValues = null;
    private HostMonitorMetaData _offlineMetadata = null;
    private HostMonitorMetaData[] _offlineMetadataArr = null;

    public CounterModelHostMonitor(String name, int type, String udModuleName, boolean systemCm) {
        super.setName(name);
        super.setSystemCm(systemCm);
        this._udModuleName = udModuleName;
        this._hostMonType = type;
        this.checkInConstructor();
        this.setDataSource(1);
        super.loadProps();
        this.setDataInitialized(false);
    }

    @Override
    public void init(Connection conn) throws Exception {
        this.localInit();
    }

    private void localInit() throws Exception {
        if (Asemon.getCounterCollector().isHostMonConnected()) {
            SshConnection sshConn = Asemon.getCounterCollector().getHostMonConnection();
            if (this._hostMonType == 1) {
                this._hostMonitor = MonitorIo.createMonitor(sshConn, false);
            } else if (this._hostMonType == 2) {
                this._hostMonitor = MonitorVmstat.createMonitor(sshConn, false);
            } else if (this._hostMonType == 3) {
                this._hostMonitor = MonitorMpstat.createMonitor(sshConn, false);
            } else if (this._hostMonType == 4) {
                Configuration conf = null;
                conf = Asemon.hasGUI() ? Configuration.getCombinedConfiguration() : Configuration.getInstance("PCS");
                if (conf == null) {
                    throw new Exception("No Configuration can be found.");
                }
                this._hostMonitor = new MonitorUserDefined(conf, this._udModuleName, sshConn, false);
            } else {
                throw new Exception("Unsupported HOSTMON_TYPE of '" + this._hostMonType + "'.");
            }
            this.setClientProperty("HostMonitor", this._hostMonitor);
            this._localInit = true;
        }
    }

    @Override
    public int getColumnCount() {
        if (this._offlineValues != null) {
            return this._offlineValues.getColumnCount();
        }
        int c = 0;
        if (this.isDataInitialized() && this._osSampleTable != null) {
            c = this._osSampleTable.getColumnCount();
        }
        return c;
    }

    @Override
    public String getColumnName(int col) {
        if (this._offlineValues != null) {
            return this._offlineValues.getColumnName(col);
        }
        if (this.isDataInitialized() && this._osSampleTable != null) {
            return this._osSampleTable.getColumnName(col);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this._offlineValues != null) {
            return this._offlineValues.getRowCount();
        }
        int c = 0;
        if (this.isDataInitialized() && this._osSampleTable != null) {
            c = this._osSampleTable.getRowCount();
        }
        return c;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this._offlineValues != null) {
            return this._offlineValues.getValueAt(row, col);
        }
        if (this.isDataInitialized() && this._osSampleTable != null) {
            return this._osSampleTable.getValueAt(row, col);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int findColumn(String colName) {
        if (this._offlineValues != null) {
            return this._offlineValues.findColumn(colName);
        }
        if (this.isDataInitialized() && this._osSampleTable != null) {
            return this._osSampleTable.findColumn(colName);
        }
        return -1;
    }

    @Override
    public List<List<Object>> getDataCollection(int whatData) {
        if (this._osSampleTable == null) {
            return null;
        }
        ArrayList<List<Object>> table = new ArrayList<List<Object>>();
        int rowCount = this._osSampleTable.getRowCount();
        int colCount = this._osSampleTable.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int c = 0; c < colCount; ++c) {
                row.add(this._osSampleTable.getValueAt(r, c));
            }
            table.add(row);
        }
        return table;
    }

    @Override
    public synchronized List<String> getColNames(int whatData) {
        if (this._osSampleTable == null) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        int colCount = this._osSampleTable.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            data.add(this._osSampleTable.getColumnName(c));
        }
        return data;
    }

    @Override
    public void setColumnNames(int type, List<String> cols) {
        if (this._offlineMetadataArr == null) {
            if (this._hostMonType == 1) {
                this._offlineMetadataArr = MonitorIo.createOfflineMetaData();
            } else if (this._hostMonType == 2) {
                this._offlineMetadataArr = MonitorVmstat.createOfflineMetaData();
            } else if (this._hostMonType == 3) {
                this._offlineMetadataArr = MonitorMpstat.createOfflineMetaData();
            } else if (this._hostMonType == 4) {
                this._offlineMetadataArr = MonitorUserDefined.createOfflineMetaData(this._udModuleName);
            }
            this._offlineMetadata = null;
            for (HostMonitorMetaData md : this._offlineMetadataArr) {
                if (!cols.containsAll(md.getColumnNames())) continue;
                this._offlineMetadata = md;
            }
            if (this._offlineMetadata != null) {
                _logger.info((Object)("Setting Offline Meta Data to use '" + this._offlineMetadata.getTableName() + "'."));
            } else {
                _logger.info((Object)("Can't find a Offline Meta Data structure for columns: " + cols));
            }
        }
        this._offlineValues = new DefaultTableModel(new Vector<String>(cols), 0);
    }

    @Override
    public void setValueAt(int type, Object value, int row, int col) {
        if (type != 1) {
            return;
        }
        if (this._offlineValues == null) {
            return;
        }
        if (row >= this._offlineValues.getRowCount()) {
            this._offlineValues.setRowCount(row + 1);
        }
        this._offlineValues.setValueAt(value, row, col);
    }

    @Override
    public String getToolTipTextOnTableColumn(String colname) {
        if (this._offlineMetadata != null) {
            return this._offlineMetadata.getDescription(colname);
        }
        if (this._osSampleTable != null) {
            return this._osSampleTable.getMetaData().getDescription(colname);
        }
        return super.getToolTipTextOnTableColumn(colname);
    }

    @Override
    public boolean discardDiffPctHighlighterOnAbsTable() {
        return false;
    }

    @Override
    public boolean isDiffCalcEnabled() {
        return false;
    }

    @Override
    public boolean isDiffColumn(int index) {
        return false;
    }

    @Override
    public boolean isPctColumn(int index) {
        int column = index + 1;
        if (this._offlineMetadata != null) {
            return this._offlineMetadata.isPctColumn(column);
        }
        if (this._osSampleTable != null) {
            return this._osSampleTable.getMetaData().isPctColumn(column);
        }
        return false;
    }

    @Override
    public void localCalculation(SamplingCnt prevSample, SamplingCnt newSample, SamplingCnt diffData) {
    }

    @Override
    protected CounterTableModel getCounterDataAbs() {
        return this._osSampleTable;
    }

    @Override
    protected CounterTableModel getCounterDataDiff() {
        return null;
    }

    @Override
    protected CounterTableModel getCounterDataRate() {
        return null;
    }

    @Override
    public boolean hasAbsData() {
        return this._osSampleTable != null;
    }

    @Override
    public boolean hasDiffData() {
        return false;
    }

    @Override
    public boolean hasRateData() {
        return false;
    }

    @Override
    public boolean isPersistCountersAbsEnabled() {
        return true;
    }

    @Override
    public boolean isPersistCountersAbsEditable() {
        return false;
    }

    @Override
    public boolean isPersistCountersDiffEnabled() {
        return false;
    }

    @Override
    public boolean isPersistCountersDiffEditable() {
        return false;
    }

    @Override
    public boolean isPersistCountersRateEnabled() {
        return false;
    }

    @Override
    public boolean isPersistCountersRateEditable() {
        return false;
    }

    @Override
    public synchronized Timestamp getTimestamp() {
        return this._thisSamplingTime;
    }

    @Override
    protected int refreshGetData(Connection conn) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Entering refresh() method for " + this.getName()));
        }
        if (!this._localInit) {
            this.localInit();
        }
        if (this._hostMonitor == null) {
            return -1;
        }
        if (this._hostMonitor.isPaused()) {
            _logger.info((Object)("The Host Monitor module '" + this._hostMonitor.getModuleName() + "' is paused."));
        }
        if (!this._hostMonitor.isRunning() && !this._hostMonitor.isPaused() && this._hostMonitor.isOsCommandStreaming()) {
            this._hostMonitor.start();
        }
        OsTable tmpOsSampleTable = this._hostMonitor.isOsCommandStreaming() ? this._hostMonitor.getSummaryTable() : this._hostMonitor.executeAndParse();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("OUTPUT Table from '" + this._hostMonitor.getModuleName() + "':\n" + tmpOsSampleTable.toTableString()));
        }
        this.setResultSetMetaData(tmpOsSampleTable.getMetaData());
        Exception exception = this._hostMonitor.getException();
        if (exception != null) {
            this.setSampleException(exception);
        }
        int rowsFetched = tmpOsSampleTable.getRowCount();
        this.setDataInitialized(true);
        this._thisSamplingTime = new Timestamp(System.currentTimeMillis());
        this.setSampleTime(this._thisSamplingTime);
        this.setSampleInterval(tmpOsSampleTable.getSampleSpanTime());
        if (!Asemon.hasGUI()) {
            this._osSampleTable = tmpOsSampleTable;
            if (!this.isInitialized()) {
                _logger.debug((Object)(this.getName() + ":------doFireTableStructureChanged------"));
                this.fireTableStructureChanged();
                this.setInitialized(true);
            }
            this.updateGraphData();
        } else {
            final OsTable fTmpOsSampleTable = tmpOsSampleTable;
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    CounterModelHostMonitor.this._osSampleTable = fTmpOsSampleTable;
                    CounterModelHostMonitor.this.beginGuiRefresh();
                    if (!CounterModelHostMonitor.this.isInitialized()) {
                        _logger.debug((Object)(CounterModelHostMonitor.this.getName() + ":------doFireTableStructureChanged------"));
                        CounterModelHostMonitor.this.fireTableStructureChanged();
                        CounterModelHostMonitor.this.setInitialized(true);
                    }
                    if (CounterModelHostMonitor.this.getTabPanel() != null && !CounterModelHostMonitor.this.getTabPanel().isTableInitialized()) {
                        _logger.debug((Object)(CounterModelHostMonitor.this.getName() + ":------doFireTableStructureChanged------"));
                        CounterModelHostMonitor.this.fireTableStructureChanged();
                        CounterModelHostMonitor.this.getTabPanel().adjustTableColumnWidth();
                    } else {
                        _logger.debug((Object)(CounterModelHostMonitor.this.getName() + ":-fireTableDataChanged-"));
                        CounterModelHostMonitor.this.fireTableDataChanged();
                    }
                    CounterModelHostMonitor.this.updateGraphData();
                    CounterModelHostMonitor.this.endGuiRefresh();
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(doWork);
            } else {
                doWork.run();
            }
        }
        return rowsFetched;
    }

    @Override
    public void clearForRead() {
    }

    @Override
    public void close() {
        this._localInit = false;
        if (this._hostMonitor != null) {
            this._hostMonitor.shutdown();
        }
        this._hostMonitor = null;
        this.setClientProperty("HostMonitor", this._hostMonitor);
    }

    @Override
    public void clear() {
        this.clear(100);
    }

    @Override
    public synchronized void clear(int clearLevel) {
        this.setInitialized(false);
        this._offlineValues = null;
        this._offlineMetadata = null;
        this._offlineMetadataArr = null;
        this.setValidSampleData(false);
        this._osSampleTable = null;
        this._thisSamplingTime = null;
        this.setTimeInfo(null, null, null, 0L);
        TabularCntrPanel tabPanel = this.getTabPanel();
        if (tabPanel != null) {
            tabPanel.reset();
        }
        this.fireTableStructureChanged();
    }
}

