/*
 * Decompiled with CFR 0.152.
 */
package asemon.cm;

import asemon.cm.CounterTableModel;
import asemon.cm.CountersModel;
import asemon.utils.AseConnectionUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class SamplingCnt
extends CounterTableModel {
    private static Logger _logger = Logger.getLogger(SamplingCnt.class);
    private static final long serialVersionUID = 4786911833477005253L;
    private boolean _negativeDiffCountersToZero = true;
    protected String _name = null;
    private String[] _diffColNames = null;
    private List<String> _colNames = null;
    private List<Integer> _colSqlType = null;
    private List<String> _colSqlTypeName = null;
    private List<String> _colClassName = null;
    private boolean[] _colIsPk = null;
    private int[] _pkPosArray = null;
    private List<List<Object>> _rows = null;
    private ArrayList<String> _rowidToKey = null;
    private HashMap<String, Integer> _keysToRowid = null;
    private HashMap<String, Integer> _pkDupCountMap = null;
    public Timestamp samplingTime;
    public long interval = 0L;
    int _pos_msgAsColValue = -1;

    public SamplingCnt(String name, boolean negativeDiffCountersToZero, String[] diffColNames) {
        this._name = name;
        this._negativeDiffCountersToZero = negativeDiffCountersToZero;
        this._diffColNames = diffColNames;
    }

    private SamplingCnt(SamplingCnt sc, boolean cloneRows, String name) {
        this._name = name;
        this._keysToRowid = sc._keysToRowid;
        this._colNames = sc._colNames;
        this._colSqlType = sc._colSqlType;
        this._colSqlTypeName = sc._colSqlTypeName;
        this._colClassName = sc._colClassName;
        this._colIsPk = sc._colIsPk;
        this._pkPosArray = sc._pkPosArray;
        this._rowidToKey = sc._rowidToKey;
        this.samplingTime = sc.samplingTime;
        this.interval = sc.interval;
        this._negativeDiffCountersToZero = sc._negativeDiffCountersToZero;
        this._diffColNames = sc._diffColNames;
        if (cloneRows) {
            this._rows = new ArrayList<List<Object>>(sc._rows);
        } else {
            this._keysToRowid = new HashMap();
            this._rowidToKey = new ArrayList();
            this._rows = new ArrayList<List<Object>>();
        }
    }

    @Override
    public int getRowCount() {
        return this._rows == null ? 0 : this._rows.size();
    }

    @Override
    public int getColumnCount() {
        return this._colNames == null ? 0 : this._colNames.size();
    }

    @Override
    public String getColumnName(int colid) {
        if (this._colNames == null || colid < 0 || colid >= this.getColumnCount()) {
            return null;
        }
        return this._colNames.get(colid);
    }

    @Override
    public Class<?> getColumnClass(int colid) {
        Class clazz;
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        Object o = this.getValueAt(0, colid);
        Class clazz2 = clazz = o != null ? o.getClass() : Object.class;
        if (o instanceof Timestamp) {
            return Object.class;
        }
        return clazz;
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this._rows == null || row < 0 || col < 0) {
            return null;
        }
        if (row >= this._rows.size()) {
            System.out.print(";");
            if (_logger.isDebugEnabled()) {
                try {
                    this._rows.get(row);
                }
                catch (IndexOutOfBoundsException e) {
                    _logger.debug((Object)("ERROR Accessing: getValueAt(row=" + row + ", col=" + col + "), SamplingCnt.name=" + this._name + ", model.size()=" + this._rows.size() + ", Thread='" + Thread.currentThread().getName() + "', Exception=" + e), (Throwable)e);
                }
            }
            return null;
        }
        try {
            return this._rows.get(row).get(col);
        }
        catch (IndexOutOfBoundsException e) {
            _logger.warn((Object)(this._name + ": getValueAt(row=" + row + ", col=" + col + "): _rows.size()=" + this._rows.size() + ", SamplingCnt.name=" + this._name + ", Thread='" + Thread.currentThread().getName() + "', returning NULL, IndexOutOfBoundsException... " + e.getMessage()));
        }
        catch (NullPointerException e) {
            _logger.warn((Object)(this._name + ": getValueAt(row=" + row + ", col=" + col + "): SamplingCnt.name=" + this._name + ", Thread='" + Thread.currentThread().getName() + "', returning NULL, NullPointerException... " + e.getMessage()));
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        List<Object> r;
        if (this._rows == null) {
            this._rows = new ArrayList<List<Object>>();
        }
        if (row >= this._rows.size()) {
            for (int i = this._rows.size(); i <= row; ++i) {
                this._rows.add(new ArrayList(this.getColumnCount()));
            }
        }
        if (col >= (r = this._rows.get(row)).size()) {
            for (int i = r.size(); i <= col; ++i) {
                r.add("-empty-");
            }
        }
        r.set(col, value);
    }

    public String getName() {
        return this._name;
    }

    public void setColumnNames(List<String> cols) {
        this._colNames = new ArrayList<String>(cols);
    }

    @Override
    public List<String> getColNames() {
        return this._colNames;
    }

    public int getColId(String colName) {
        if (this._colNames == null) {
            return -1;
        }
        return this._colNames.indexOf(colName);
    }

    public String getColClassName(int colId) {
        return this._colClassName.get(colId);
    }

    public int getColSqlType(int colId) {
        return this._colSqlType.get(colId);
    }

    public String getColSqlTypeName(int colId) {
        return this._colSqlTypeName.get(colId);
    }

    @Override
    public String getPkValue(int row) {
        return this._rowidToKey.get(row);
    }

    @Override
    public int getRowNumberForPkValue(String pkStr) {
        Integer i = this._keysToRowid.get(pkStr);
        if (i == null && (i = this._keysToRowid.get(pkStr + ":")) == null) {
            return -1;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this._name + ": getRowNumberForPkValue(pk='" + pkStr + "'), returns=" + i));
        }
        return i;
    }

    public boolean isColPartOfPk(int colId) {
        if (this._colIsPk == null) {
            return false;
        }
        if (colId < 0 || colId > this.getColumnCount()) {
            return false;
        }
        return this._colIsPk[colId];
    }

    private void checkWarnings(Statement st) throws SQLException {
        boolean hasWarning = false;
        StringBuilder sb = new StringBuilder();
        try {
            for (SQLWarning w = st.getWarnings(); w != null; w = w.getNextWarning()) {
                String sqlState = w.getSQLState();
                if (sqlState != null && sqlState.equals("010P4")) continue;
                hasWarning = true;
                String wStr = w.toString();
                if (wStr == null) {
                    hasWarning = false;
                    continue;
                }
                if (wStr.trim().equals("")) {
                    hasWarning = false;
                    continue;
                }
                wStr = "AseMsgNum=" + w.getErrorCode() + ", " + w.toString();
                _logger.warn((Object)("SamplingCnt(" + this._name + ").Warning : " + wStr));
                sb.append(wStr).append("\n");
            }
        }
        catch (SQLException ex) {
            _logger.warn((Object)("SamplingCnt(" + this._name + ").getWarnings : " + ex));
            ex.printStackTrace();
        }
        if (hasWarning) {
            throw new SQLException("SQL Warning in(" + this._name + ") Messages: " + sb);
        }
    }

    private Object fixNullValue(int col) {
        if (this._colSqlType == null) {
            _logger.error((Object)"colSqlType are null, this should not happen.");
            return new Object();
        }
        int objSqlType = this._colSqlType.get(col - 1);
        switch (objSqlType) {
            case -7: {
                return new Boolean(false);
            }
            case -6: {
                return new Byte(Byte.parseByte("0"));
            }
            case 5: {
                return new Short(Short.parseShort("0"));
            }
            case 4: {
                return new Integer(0);
            }
            case -5: {
                return new Long(0L);
            }
            case 6: {
                return new Float(0.0f);
            }
            case 7: {
                return new Float(0.0f);
            }
            case 8: {
                return new Double(0.0);
            }
            case 2: {
                return new BigDecimal(0);
            }
            case 3: {
                return new BigDecimal(0);
            }
            case 1: {
                return "";
            }
            case 12: {
                return "";
            }
            case -1: {
                return "";
            }
            case 91: {
                return new Date(0L);
            }
            case 92: {
                return new Time(0L);
            }
            case 93: {
                return new Timestamp(0L);
            }
            case -2: {
                return new byte[0];
            }
            case -3: {
                return new byte[0];
            }
            case -4: {
                return new byte[0];
            }
            case 0: {
                return null;
            }
            case 1111: {
                return null;
            }
            case 2000: {
                return new Object();
            }
            case 2001: {
                return "-DISTINCT-";
            }
            case 2002: {
                return "-STRUCT-";
            }
            case 2003: {
                return "-ARRAY-";
            }
            case 2004: {
                return "";
            }
            case 2005: {
                return "";
            }
            case 2006: {
                return "-REF-";
            }
            case 70: {
                return "-DATALINK-";
            }
            case 16: {
                return new Boolean(false);
            }
        }
        _logger.error((Object)"Unknow SQL datatype, when translating a NULL value.");
        return new Object();
    }

    public boolean getCnt(CountersModel cm, Connection conn, String sql, List<String> pkList) throws SQLException {
        int queryTimeout = cm.getQueryTimeout();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this._name + ": queryTimeout=" + queryTimeout));
        }
        try {
            String sendSql = "select getdate() \n" + sql;
            Statement stmnt = conn.createStatement();
            stmnt.setQueryTimeout(queryTimeout);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("QUERY_TIMEOUT=" + queryTimeout + ", for SampleCnt='" + this._name + "'."));
            }
            this._rows = new ArrayList<List<Object>>();
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Sending SQL: " + sendSql));
            }
            int rsNum = 0;
            int rowsAffected = 0;
            boolean hasRs = stmnt.execute(sendSql);
            this.checkWarnings(stmnt);
            do {
                if (hasRs) {
                    ResultSet rs = stmnt.getResultSet();
                    this.checkWarnings(stmnt);
                    if (rsNum == 0) {
                        while (rs.next()) {
                            this.samplingTime = rs.getTimestamp(1);
                        }
                    } else {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        if (!cm.hasResultSetMetaData()) {
                            cm.setResultSetMetaData(rsmd);
                        }
                        if (this.readResultset(rs, rsmd, pkList, rsNum)) {
                            rs.close();
                        }
                        this.checkWarnings(stmnt);
                    }
                    ++rsNum;
                }
                if ((rowsAffected = stmnt.getUpdateCount()) >= 0) {
                    // empty if block
                }
                hasRs = stmnt.getMoreResults();
                _logger.trace((Object)("--hasRs=" + hasRs + ", rsNum=" + rsNum + ", rowsAffected=" + rowsAffected));
            } while (hasRs || rowsAffected != -1);
            this.checkWarnings(stmnt);
            stmnt.close();
            return true;
        }
        catch (SQLException sqlEx) {
            _logger.warn((Object)("SamplingCnt(" + this._name + ").getCnt : " + sqlEx.getErrorCode() + " " + sqlEx.getMessage() + ". SQL: " + sql), (Throwable)sqlEx);
            if (sqlEx.toString().indexOf("SocketTimeoutException") > 0) {
                _logger.info((Object)("QueryTimeout in '" + this._name + "', with query timeout '" + queryTimeout + "'. This can be changed with the config option '" + this._name + ".queryTimeout=seconds' in the config file."));
            }
            throw sqlEx;
        }
    }

    private boolean readResultset(ResultSet rs, ResultSetMetaData rsmd, List<String> pkList, int rsNum) throws SQLException {
        if (this._colNames == null) {
            int i;
            this._colNames = new ArrayList<String>();
            this._colSqlType = new ArrayList<Integer>();
            this._colSqlTypeName = new ArrayList<String>();
            this._colClassName = new ArrayList<String>();
            int colCount = rsmd.getColumnCount();
            this._colIsPk = new boolean[colCount];
            this._keysToRowid = new HashMap();
            this._rowidToKey = new ArrayList();
            LinkedList<Integer> tmpPkPos = new LinkedList<Integer>();
            for (i = 1; i <= colCount; ++i) {
                String colname = rsmd.getColumnLabel(i);
                this._colNames.add(colname);
                this._colSqlType.add(new Integer(rsmd.getColumnType(i)));
                this._colSqlTypeName.add(rsmd.getColumnTypeName(i));
                this._colClassName.add(rsmd.getColumnClassName(i));
                this._colIsPk[i - 1] = false;
                if (pkList != null && pkList.size() > 0) {
                    if (pkList.contains(colname)) {
                        this._colIsPk[i - 1] = true;
                    }
                    if (pkList.contains(Integer.toString(i))) {
                        this._colIsPk[i - 1] = true;
                    }
                    if (this._colIsPk[i - 1]) {
                        tmpPkPos.add(new Integer(i));
                    }
                }
                if (!"msgAsColValue".equals(colname)) continue;
                this._pos_msgAsColValue = i;
            }
            if (pkList != null && pkList.size() != tmpPkPos.size()) {
                throw new RuntimeException("sample, can't find all the primary keys in the ResultSet. pkList='" + pkList + "', _colNames='" + this._colNames + "', tmpPkPos='" + tmpPkPos + "'.");
            }
            this._pkPosArray = new int[tmpPkPos.size()];
            for (i = 0; i < tmpPkPos.size(); ++i) {
                this._pkPosArray[i] = (Integer)tmpPkPos.get(i);
            }
            tmpPkPos = null;
        } else {
            int cols = rsmd.getColumnCount();
            if (this.getColumnCount() != cols) {
                _logger.error((Object)("ResultSet number " + rsNum + " has " + cols + " while it was expected to have " + this.getColumnCount() + ". Skipping this result set."));
                rs.close();
                return false;
            }
            for (int i = 1; i <= cols; ++i) {
                String newType;
                String oldType = this._colClassName.get(i - 1);
                if (oldType.equals(newType = rsmd.getColumnClassName(i))) continue;
                _logger.error((Object)("ResultSet number " + rsNum + " column number " + i + " has SQL datatype " + newType + ", while we expected datatype " + oldType + ".  Skipping this result set."));
                rs.close();
                return false;
            }
        }
        int rsRowNum = 0;
        _logger.debug((Object)"---");
        while (rs.next()) {
            Integer intObj;
            StringBuilder key = new StringBuilder();
            ArrayList<Object> row = new ArrayList<Object>();
            int colCount = this.getColumnCount();
            String msgAsColValue = "";
            SQLWarning sqlwInRs = rs.getWarnings();
            if (sqlwInRs != null) {
                if (this._pos_msgAsColValue >= 0) {
                    msgAsColValue = AseConnectionUtils.getSqlWarningMsgs(sqlwInRs);
                } else {
                    _logger.warn((Object)("Received a Msg while reading the resultset from '" + this.getName() + "', This could be mapped to a column by using a column name 'msgAsColValue' in the SELECT statement. Right now it's discarded. The message text: " + AseConnectionUtils.getSqlWarningMsgs(sqlwInRs)));
                }
            }
            for (int i = 1; i <= colCount; ++i) {
                Object val = rs.getObject(i);
                if (rsRowNum == 0 && _logger.isTraceEnabled()) {
                    _logger.trace((Object)("READ_RESULTSET(rsnum " + rsNum + ", row 0): col=" + i + ", colName=" + (this._colNames.get(i - 1) + "                                   ").substring(0, 25) + ", ObjectType=" + (val == null ? "NULL-VALUE" : val.getClass().getName())));
                }
                if (val == null) {
                    val = this.fixNullValue(i);
                }
                if (this._pos_msgAsColValue == i) {
                    val = msgAsColValue;
                }
                row.add(val);
                if (this._colIsPk == null || !this._colIsPk[i - 1]) continue;
                if (val != null) {
                    key.append(val).append(":");
                    continue;
                }
                _logger.warn((Object)("Key containes NULL value, rsNum=" + rsNum + ", row=" + rsRowNum + ", col=" + i + "."));
            }
            if (_logger.isTraceEnabled()) {
                for (int c = 0; c < colCount; ++c) {
                    _logger.trace((Object)("   > rsNum=" + rsNum + ", rsRowNum=" + rsRowNum + ", getRowCount()=" + this.getRowCount() + ", c=" + c + ", className='" + row.get(c).getClass().getName() + "', value=" + row.get(c)));
                }
            }
            String keyStr = key.toString();
            if (pkList != null && (intObj = this._keysToRowid.get(keyStr)) != null) {
                Integer dupMergeCount;
                List<Object> curRow = this.getRow(keyStr);
                int dupMergeCountPos = this.findColumn("dupMergeCount");
                int dupRowCountPos = this.findColumn("dupRowCount");
                int pkDuplicateAction = 0;
                if (dupRowCountPos >= 0) {
                    pkDuplicateAction = 2;
                }
                if (dupMergeCountPos >= 0) {
                    pkDuplicateAction = 1;
                }
                if (pkDuplicateAction != 0 && this._diffColNames == null) {
                    _logger.error((Object)("Duplicate key in '" + this._name + "', pkDuplicateAction=" + pkDuplicateAction + ", BUT _diffColNames is null, this should never happen."));
                    continue;
                }
                if (pkDuplicateAction == 0) {
                    _logger.error((Object)("Duplicate key in '" + this._name + "', a row for the key '" + key + "' already exists. CurrentRow='" + curRow + "'. NewRow='" + row + "'."));
                    continue;
                }
                if (this._pkDupCountMap == null) {
                    this._pkDupCountMap = new HashMap();
                }
                dupMergeCount = (dupMergeCount = this._pkDupCountMap.get(keyStr)) == null ? new Integer(1) : new Integer(dupMergeCount + 1);
                this._pkDupCountMap.put(keyStr, dupMergeCount);
                if (pkDuplicateAction == 1) {
                    curRow.set(dupMergeCountPos, dupMergeCount);
                } else {
                    row.set(dupRowCountPos, dupMergeCount);
                }
                if (pkDuplicateAction == 1) {
                    for (String diffColName : this._diffColNames) {
                        int diffCollNamePos = this.findColumn(diffColName);
                        Number prevColVal = (Number)curRow.get(diffCollNamePos);
                        Number thisColVal = (Number)row.get(diffCollNamePos);
                        Number mergeColVal = this.mergeColumnValue(prevColVal, thisColVal);
                        curRow.set(diffCollNamePos, mergeColVal);
                        if (!_logger.isTraceEnabled()) continue;
                        _logger.trace((Object)("   >> MERGE for key='" + key + "', rowId=" + intObj + ", colName='" + diffColName + "', colPos=" + diffCollNamePos + ", prevValue=" + prevColVal + ", thisVal=" + thisColVal + ", mergedVal=" + mergeColVal + "."));
                    }
                    _logger.trace((Object)"   >> MERGE continue and red next row from ResultSet.");
                    continue;
                }
                if (pkDuplicateAction == 2) {
                    _logger.error((Object)("Duplicate key in '" + this._name + "', pkDuplicateAction=2 IS NOT IMPLEMENTED."));
                    continue;
                }
            }
            if (pkList != null) {
                this._keysToRowid.put(keyStr, new Integer(this.getRowCount()));
                this._rowidToKey.add(keyStr);
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("   >> key='" + key + "', rowId=" + this.getRowCount() + ", _rowidToKey.addPos=" + (this._rowidToKey.size() - 1)));
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("   >> rowAdded: rowId=" + this.getRowCount() + ", key=" + key + ", row=" + row));
            }
            this._rows.add(row);
            ++rsRowNum;
        }
        return true;
    }

    public void newRowIds() {
        this._keysToRowid = new HashMap();
        this._rowidToKey = new ArrayList();
        for (int r = 0; r < this._rows.size(); ++r) {
            List<Object> row = this._rows.get(r);
            StringBuilder key = new StringBuilder();
            int colCount = this.getColumnCount();
            for (int c = 0; c < colCount; ++c) {
                Object val;
                if (this._colIsPk == null || !this._colIsPk[c] || (val = row.get(c)) == null) continue;
                key.append(val).append(":");
            }
            if (this._colIsPk == null) continue;
            String keyStr = key.toString();
            this._keysToRowid.put(keyStr, new Integer(r));
            this._rowidToKey.add(keyStr);
        }
    }

    public boolean addRow(List<Object> row) {
        Integer io;
        if (row == null) {
            return false;
        }
        int colCount = this.getColumnCount();
        if (row.size() != colCount) {
            throw new IndexOutOfBoundsException("The number of columns in current structure is " + colCount + ", while the row we attempt to add has " + row.size() + " columns.");
        }
        StringBuilder key = new StringBuilder();
        for (int c = 0; c < colCount; ++c) {
            Object val = row.get(c);
            if (val == null) {
                val = this.fixNullValue(c);
                row.set(c, val);
            }
            if (this._colIsPk == null || !this._colIsPk[c]) continue;
            if (val != null) {
                key.append(val).append(":");
                continue;
            }
            _logger.warn((Object)("Key containes NULL value, row=" + this.getRowCount() + ", col=" + c + "."));
        }
        String keyStr = key.toString();
        if (this._colIsPk != null && (io = this._keysToRowid.get(keyStr)) != null) {
            List<Object> curRow = this.getRow(keyStr);
            _logger.error((Object)("Duplicate key in '" + this._name + "', a row for the key '" + key + "' already exists. CurrentRow='" + curRow + "'. NewRow='" + row + "'."));
            return false;
        }
        this._rows.add(row);
        int rowId = this._rows.size() - 1;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this._name + ": addRow(): rowId=" + rowId + ", key=" + key + ", row=" + row));
        }
        if (this._colIsPk != null) {
            this._keysToRowid.put(keyStr, new Integer(this.getRowCount()));
            this._rowidToKey.add(keyStr);
        }
        return true;
    }

    public void remove(String key) {
        this.removeRow(key);
    }

    public void removeRow(String key) {
        int row = this.getRowNumberForPkValue(key);
        this.removeRow(row);
    }

    public synchronized void removeRow(int rowId) {
        int maxRowId = this._rows.size() - 1;
        String key = this._rowidToKey.get(rowId);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this._name + ": removeRow(rowId=" + rowId + "): key=" + key));
        }
        this._rows.remove(rowId);
        this._rowidToKey.remove(rowId);
        this._keysToRowid.remove(key);
        if (rowId < maxRowId) {
            for (int r = rowId; r < this._rows.size(); ++r) {
                key = this._rowidToKey.get(r);
                this._keysToRowid.put(key, new Integer(r));
            }
        }
    }

    public synchronized void removeAllRows() {
        if (this._rows != null) {
            this._rows.clear();
        }
        if (this._rowidToKey != null) {
            this._rowidToKey.clear();
        }
        if (this._keysToRowid != null) {
            this._keysToRowid.clear();
        }
    }

    public void setPk(String key, int row) {
        this._keysToRowid.put(key, new Integer(row));
        while (this._rowidToKey.size() <= row) {
            this._rowidToKey.add("-setPk:uninitialized-");
        }
        this._rowidToKey.set(row, key);
    }

    public List<List<Object>> getDataCollection() {
        return this._rows;
    }

    public List<Object> getRow(String key) {
        int row = this.getRowNumberForPkValue(key);
        if (row == -1) {
            return null;
        }
        return this.getRow(row);
    }

    public List<Object> getRow(int row) {
        return this._rows.get(row);
    }

    public static SamplingCnt computeRatePerSec(SamplingCnt diff, boolean[] isDiffCol, boolean[] isPctCol) {
        SamplingCnt rate = new SamplingCnt(diff, false, diff._name + "-rate");
        for (int rowId = 0; rowId < diff.getRowCount(); ++rowId) {
            List<Object> diffRow = diff.getRow(rowId);
            ArrayList<Object> newRow = new ArrayList<Object>();
            for (int i = 0; i < diff.getColumnCount(); ++i) {
                Object originObject;
                Object newObject = originObject = diffRow.get(i);
                if (!isPctCol[i] && isDiffCol[i]) {
                    double val = 0.0;
                    if (diff.interval == 0L) {
                        newObject = "N/A";
                    }
                    if (originObject instanceof Number) {
                        val = originObject instanceof Number ? ((Number)originObject).doubleValue() : Double.parseDouble(originObject.toString());
                        val = val * 1000.0 / (double)diff.interval;
                        BigDecimal newVal = new BigDecimal(val).setScale(1, 6);
                        newObject = newVal;
                    } else {
                        String colName = diff.getColumnName(i);
                        _logger.warn((Object)("CounterSampleSetName='" + diff._name + "', className='" + originObject.getClass().getName() + "' columns can't be 'rate' calculated. colName='" + colName + "', originObject='" + originObject + "', keeping this object."));
                        newObject = originObject;
                    }
                }
                newRow.add(newObject);
            }
            rate.addRow(newRow);
        }
        return rate;
    }

    public static SamplingCnt computeDiffCnt(SamplingCnt oldSample, SamplingCnt newSample, List<Integer> deletedRows, List<String> pkList, boolean[] isDiffCol) {
        SamplingCnt diffCnt = new SamplingCnt(newSample, false, newSample._name + "-diff");
        long newTsMilli = newSample.samplingTime.getTime();
        long oldTsMilli = oldSample.samplingTime.getTime();
        int newTsNano = newSample.samplingTime.getNanos();
        int oldTsNano = oldSample.samplingTime.getNanos();
        diffCnt.interval = newTsMilli - newTsMilli / 1000L * 1000L == (long)(newTsNano / 1000000) ? newTsMilli - oldTsMilli : newTsMilli - oldTsMilli + (long)((newTsNano - oldTsNano) / 1000000);
        if (diffCnt._colIsPk == null) {
            List<Object> oldRow = oldSample._rows.get(0);
            List<Object> newRow = newSample._rows.get(0);
            ArrayList<Integer> diffRow = new ArrayList<Integer>();
            for (int i = 0; i < newSample.getColumnCount(); ++i) {
                diffRow.add(new Integer((Integer)newRow.get(i) - (Integer)oldRow.get(i)));
            }
            diffCnt._rows.add(diffRow);
            return diffCnt;
        }
        boolean[] oldSampleAccessArr = new boolean[oldSample.getRowCount()];
        for (int newRowId = 0; newRowId < newSample.getRowCount(); ++newRowId) {
            int i;
            List<Object> newRow = newSample.getRow(newRowId);
            ArrayList<Object> diffRow = new ArrayList<Object>();
            String newPk = newSample.getPkValue(newRowId);
            int oldRowId = oldSample.getRowNumberForPkValue(newPk);
            if (oldRowId != -1) {
                if (oldRowId >= 0 && oldRowId < oldSampleAccessArr.length) {
                    oldSampleAccessArr[oldRowId] = true;
                }
                List<Object> oldRow = oldSample.getRow(oldRowId);
                for (i = 0; i < newSample.getColumnCount(); ++i) {
                    if (!isDiffCol[i]) {
                        diffRow.add(newRow.get(i));
                        continue;
                    }
                    Object oldRowObj = oldRow.get(i);
                    Object newRowObj = newRow.get(i);
                    String colName = newSample.getColumnName(i);
                    if (newRowObj instanceof Number) {
                        Number diffValue = SamplingCnt.diffColumnValue((Number)oldRowObj, (Number)newRowObj, diffCnt._negativeDiffCountersToZero, newSample._name, colName);
                        diffRow.add(diffValue);
                        continue;
                    }
                    _logger.warn((Object)("CounterSampleSetName='" + newSample._name + "', className='" + newRowObj.getClass().getName() + "' columns can't be 'diff' calculated. colName='" + colName + "', key='" + newPk + "', oldObj='" + oldRowObj + "', newObj='" + newRowObj + "'."));
                    diffRow.add(newRowObj);
                }
            } else {
                for (i = 0; i < newSample.getColumnCount(); ++i) {
                    diffRow.add(newRow.get(i));
                }
            }
            diffCnt.addRow(diffRow);
        }
        if (deletedRows != null) {
            for (int i = 0; i < oldSampleAccessArr.length; ++i) {
                if (oldSampleAccessArr[i]) continue;
                deletedRows.add(i);
            }
        }
        return diffCnt;
    }

    private static Number diffColumnValue(Number prevColVal, Number newColVal, boolean negativeDiffCountersToZero, String counterSetName, String colName) {
        Number diffColVal = null;
        if (newColVal instanceof BigDecimal) {
            diffColVal = new BigDecimal(newColVal.doubleValue() - prevColVal.doubleValue());
            if (diffColVal.doubleValue() < 0.0 && negativeDiffCountersToZero) {
                diffColVal = new BigDecimal(0);
            }
        } else if (newColVal instanceof Byte) {
            diffColVal = new Byte((byte)(newColVal.byteValue() - prevColVal.byteValue()));
            if (diffColVal.intValue() < 0 && negativeDiffCountersToZero) {
                diffColVal = new Byte("0");
            }
        } else if (newColVal instanceof Double) {
            diffColVal = new Double(newColVal.doubleValue() - prevColVal.doubleValue());
            if (diffColVal.doubleValue() < 0.0 && negativeDiffCountersToZero) {
                diffColVal = new Double(0.0);
            }
        } else if (newColVal instanceof Float) {
            diffColVal = new Float(newColVal.floatValue() - prevColVal.floatValue());
            if (diffColVal.floatValue() < 0.0f && negativeDiffCountersToZero) {
                diffColVal = new Float(0.0f);
            }
        } else if (newColVal instanceof Integer) {
            diffColVal = new Integer(newColVal.intValue() - prevColVal.intValue());
            if (diffColVal.intValue() < 0 && negativeDiffCountersToZero) {
                diffColVal = new Integer(0);
            }
        } else if (newColVal instanceof Long) {
            diffColVal = new Long(newColVal.longValue() - prevColVal.longValue());
            if (diffColVal.longValue() < 0L && negativeDiffCountersToZero) {
                diffColVal = new Long(0L);
            }
        } else if (newColVal instanceof Short) {
            diffColVal = new Short((short)(newColVal.shortValue() - prevColVal.shortValue()));
            if (diffColVal.shortValue() < 0 && negativeDiffCountersToZero) {
                diffColVal = new Short("0");
            }
        } else if (newColVal instanceof AtomicInteger) {
            diffColVal = new AtomicInteger(newColVal.intValue() - prevColVal.intValue());
            if (diffColVal.intValue() < 0 && negativeDiffCountersToZero) {
                diffColVal = new AtomicInteger(0);
            }
        } else if (newColVal instanceof AtomicLong) {
            diffColVal = new AtomicLong(newColVal.longValue() - prevColVal.longValue());
            if (diffColVal.longValue() < 0L && negativeDiffCountersToZero) {
                diffColVal = new AtomicLong(0L);
            }
        } else {
            _logger.warn((Object)(counterSetName + ": failure in diffColumnValue(colName='" + colName + "', prevColVal='" + prevColVal + "', newColVal='" + newColVal + "'), with prevColVal='" + prevColVal.getClass().getName() + "', newColVal='" + newColVal.getClass().getName() + "'. Returning the new value instead."));
            return newColVal;
        }
        return diffColVal;
    }

    private Number mergeColumnValue(Number prevColVal, Number thisColVal) {
        Number mergeColVal = null;
        if (thisColVal instanceof BigDecimal) {
            mergeColVal = new BigDecimal(prevColVal.doubleValue() + thisColVal.doubleValue());
        } else if (thisColVal instanceof Byte) {
            mergeColVal = new Byte((byte)(prevColVal.byteValue() + thisColVal.byteValue()));
        } else if (thisColVal instanceof Double) {
            mergeColVal = new Double(prevColVal.doubleValue() + thisColVal.doubleValue());
        } else if (thisColVal instanceof Float) {
            mergeColVal = new Float(prevColVal.floatValue() + thisColVal.floatValue());
        } else if (thisColVal instanceof Integer) {
            mergeColVal = new Integer(prevColVal.intValue() + thisColVal.intValue());
        } else if (thisColVal instanceof Long) {
            mergeColVal = new Long(prevColVal.longValue() + thisColVal.longValue());
        } else if (thisColVal instanceof Short) {
            mergeColVal = new Short((short)(prevColVal.shortValue() + thisColVal.shortValue()));
        } else if (thisColVal instanceof AtomicInteger) {
            mergeColVal = new AtomicInteger(prevColVal.intValue() + thisColVal.intValue());
        } else if (thisColVal instanceof AtomicLong) {
            mergeColVal = new AtomicLong(prevColVal.longValue() + thisColVal.longValue());
        } else {
            _logger.warn((Object)(this._name + ": failure in mergeColumnValue(prevColVal='" + prevColVal + "', thisColVal='" + thisColVal + "'), with prevColVal='" + prevColVal.getClass().getName() + "', thisColVal='" + thisColVal.getClass().getName() + "'. Returning the origin value instead."));
            return prevColVal;
        }
        return mergeColVal;
    }

    public static boolean isDiffAllowedForDatatype(String datatype) {
        boolean enabled = false;
        if ("tinyint".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("unsigned smallint".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("smallint".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("unsigned int".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("int".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("unsigned bigint".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("bigint".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("decimal".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("numeric".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("float".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("real".equalsIgnoreCase(datatype)) {
            enabled = true;
        } else if ("double precision".equalsIgnoreCase(datatype)) {
            enabled = true;
        }
        return enabled;
    }
}

