/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Version;
import asemon.gui.AseMessageHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.SwingUtils;
import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.PropertyConfigurator;

public class AsePlanViewer
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 3859509683688523815L;
    private final String SHOW_SQL_PANEL = "Show SQL";
    private final String HIDE_SQL_PANEL = "Hide SQL";
    private Connection _conn = null;
    private String _sql = null;
    private List<String> _plan = null;
    private boolean _hasPlan = false;
    private JPanel _sqlPanel = null;
    private JPanel _planPanel = null;
    private JPanel _butPanel = null;
    private JButton _toggleSql_but = new JButton("Hide SQL");
    private JButton _close_but = new JButton("Close");
    private AseMessageHandler _aseMsg = new AseMessageHandler();

    public AsePlanViewer(Connection conn, String sql) {
        super("Plan Viewer");
        this._conn = conn;
        this._sql = sql;
        ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)this._aseMsg);
        this._planPanel = this.getPlanViewer();
        if (this._planPanel != null) {
            this._sqlPanel = SwingUtils.createPanel("Sql Text (Outer panel)", true);
            this._sqlPanel.setLayout((LayoutManager)new MigLayout());
            JTextArea sqlText = new JTextArea();
            sqlText.setText(this._sql);
            sqlText.setEditable(false);
            sqlText.setOpaque(false);
            this._sqlPanel.add((Component)sqlText, "grow, push, wrap");
            this._butPanel = SwingUtils.createPanel("Buttons", false);
            this._butPanel.setLayout((LayoutManager)new MigLayout());
            this._butPanel.add((Component)this._toggleSql_but, "left");
            this._butPanel.add((Component)this._close_but, "push, right");
            this._toggleSql_but.addActionListener(this);
            this._close_but.addActionListener(this);
            Container contentPane = this.getContentPane();
            contentPane.setLayout((LayoutManager)new MigLayout());
            contentPane.add((Component)this._sqlPanel, "dock north, hidemode 3, gap 5 5 5 5");
            contentPane.add((Component)this._planPanel, "dock center");
            contentPane.add((Component)this._butPanel, "dock south");
            this.pack();
            this.setSize(900, 900);
            this.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._toggleSql_but.equals(source)) {
            if (this._toggleSql_but.getText().equals("Show SQL")) {
                this._sqlPanel.setVisible(true);
                this._toggleSql_but.setText("Hide SQL");
            } else {
                this._sqlPanel.setVisible(false);
                this._toggleSql_but.setText("Show SQL");
            }
        }
        if (this._close_but.equals(source)) {
            this.dispose();
        }
    }

    protected JPanel getPlanViewer() {
        if (this.getPlan()) {
            StringBuffer stringbuffer = new StringBuffer(256);
            String s = System.getProperty("line.separator");
            int planSize = this._plan.size();
            for (int i = 1; i < planSize; ++i) {
                stringbuffer.append(this._plan.get(i));
                stringbuffer.append(s);
            }
            try {
                ASEPlanViewer view = new ASEPlanViewer(this._conn);
                JPanel panel = view.getPanel();
                view.generatePlan(stringbuffer, new StringBuffer(this._plan.get(0)));
                return panel;
            }
            catch (UnsupportedClassVersionError e) {
                SwingUtils.showErrorMessage("ASE Plan Viewer", "Problems loading the ASE Plan Viewer.\nI'm guessing you're running a JVM that is earlier than 6.0\nSo please upgrade the JVM to atleast version 6 and try again.", e);
            }
            catch (Exception e) {
                SwingUtils.showErrorMessage("ASE Plan Viewer", "Problems loading the ASE Plan Viewer", e);
            }
        }
        return null;
    }

    private boolean getPlan() {
        Statement statement = null;
        ResultSet resultset = null;
        int saveTextSize = 32768;
        try {
            statement = this._conn.createStatement();
            resultset = statement.executeQuery("select @@textsize");
            if (resultset.next()) {
                saveTextSize = resultset.getInt(1);
            }
            if (saveTextSize < 0x6500000) {
                statement.executeQuery("set textsize 105906176");
            }
            statement.executeUpdate("set plan for show_execio_xml to message on");
            statement.executeUpdate("set nodata on");
            statement.executeUpdate("set showplan on");
            this._aseMsg.startIntercepting();
            StringBuffer stringbuffer = new StringBuffer();
            String[] as = this._sql.split("\n");
            for (int j = 0; j < as.length; ++j) {
                if (as[j].trim().toLowerCase().equals("go")) {
                    stringbuffer.append(" \n");
                    continue;
                }
                stringbuffer.append(as[j]).append(" \n");
            }
            statement.execute(stringbuffer.toString());
            while (statement.getMoreResults() || statement.getUpdateCount() != -1) {
            }
            String s = this._aseMsg.stopIntercepting();
            this._plan = new ArrayList<String>();
            this._plan.add(s);
            statement.executeUpdate("set showplan off");
            statement.executeUpdate("set nodata off");
            resultset = statement.executeQuery("select showplan_in_xml(0)");
            while (resultset.next()) {
                String s1 = resultset.getString(1);
                if (s1 == null || s1.trim().length() == 0) continue;
                this._plan.add(s1);
            }
            statement.executeUpdate("set plan for show_execio_xml off");
            if (saveTextSize < 0x6500000) {
                statement.executeUpdate("set textsize " + saveTextSize);
            }
            this._hasPlan = true;
        }
        catch (SQLException e) {
            this._plan = null;
            this._hasPlan = false;
        }
        return this._hasPlan;
    }

    public static void main(String[] args) throws Exception {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "TRACE, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Connection conn = AseConnectionFactory.getConnection("goransxp", 5000, null, "sa", "", Version.getAppName() + "-AsePlanViewer", null);
        String sql = "select * from sybsystemprocs..sysobjects order by crdate \nselect * from sybsystemprocs..syscomments \nexec sp_help";
        new AsePlanViewer(conn, sql);
    }
}

