/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.gui.LineNumberedBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LineNumberedPaper
extends JTextArea {
    private static final long serialVersionUID = -4712451085091820083L;
    public static int RIGHT_JUSTIFY = 0;
    public static int LEFT_JUSTIFY = 1;
    private int lineNumberJustification = RIGHT_JUSTIFY;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Line Numbers...");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridLayout(0, 2));
        int[] justified = new int[]{LineNumberedBorder.LEFT_JUSTIFY, LineNumberedBorder.RIGHT_JUSTIFY};
        String[] labels = new String[]{"Left Justified", "Right Justified"};
        for (int idx = 0; idx < labels.length; ++idx) {
            LineNumberedPaper lnp = new LineNumberedPaper(10, 10);
            lnp.setLineNumberJustification(justified[idx]);
            JPanel subpanel = new JPanel(new BorderLayout());
            subpanel.add((Component)new JLabel(labels[idx]), "North");
            subpanel.add((Component)new JScrollPane(lnp), "Center");
            contentPane.add(subpanel);
        }
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public LineNumberedPaper(int rows, int cols) {
        super(rows, cols);
        this.setOpaque(false);
    }

    @Override
    public Insets getInsets() {
        return this.getInsets(new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getInsets(Insets insets) {
        insets = super.getInsets(insets);
        insets.left += this.lineNumberWidth();
        return insets;
    }

    public int getLineNumberJustification() {
        return this.lineNumberJustification;
    }

    public void setLineNumberJustification(int justify) {
        if (justify == RIGHT_JUSTIFY || justify == LEFT_JUSTIFY) {
            this.lineNumberJustification = justify;
        }
    }

    private int lineNumberWidth() {
        int lineCount = Math.max(this.getRows(), this.getLineCount() + 1);
        return this.getFontMetrics(this.getFont()).stringWidth(lineCount + " ");
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (clip.x < insets.left) {
            FontMetrics fm = g.getFontMetrics();
            int fontHeight = fm.getHeight();
            int y = fm.getAscent() + insets.top;
            int startingLineNumber = (clip.y + insets.top) / fontHeight + 1;
            if (y < clip.y) {
                y = startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
            }
            int yend = y + clip.height + fontHeight;
            int lnxstart = insets.left;
            if (this.lineNumberJustification == LEFT_JUSTIFY) {
                lnxstart -= this.lineNumberWidth();
            }
            g.setColor(this.getForeground());
            int length = ("" + Math.max(this.getRows(), this.getLineCount() + 1)).length();
            while (y < yend) {
                if (this.lineNumberJustification == LEFT_JUSTIFY) {
                    g.drawString(startingLineNumber + " ", lnxstart, y);
                } else {
                    String label = this.padLabel(startingLineNumber, length, true);
                    g.drawString(label, insets.left - fm.stringWidth(label), y);
                }
                y += fontHeight;
                ++startingLineNumber;
            }
        }
        super.paintComponent(g);
    }

    private String padLabel(int lineNumber, int length, boolean addSpace) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineNumber);
        for (int count = length - buffer.length(); count > 0; --count) {
            buffer.insert(0, ' ');
        }
        if (addSpace) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

