/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.gui.Log4jLogRecord;
import java.sql.Timestamp;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;

public class Log4jTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2152458182894425275L;
    private LinkedList<Log4jLogRecord> _records = new LinkedList();
    private int _maxRecords = 500;

    public void setMaxRecords(int max) {
        this._maxRecords = max;
    }

    public int getMaxRecords() {
        return this._maxRecords;
    }

    public void addMessage(Log4jLogRecord record) {
        this._records.add(record);
        this.fireTableRowsInserted(this._records.size() - 1, this._records.size() - 1);
        if (this._records.size() > this._maxRecords) {
            this._records.removeFirst();
            this.fireTableRowsDeleted(0, 0);
        }
    }

    public Log4jLogRecord getRecord(int row) {
        return this._records.get(row);
    }

    public void clear() {
        this._records.clear();
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Long.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return Boolean.class;
            }
            case 7: {
                return String.class;
            }
        }
        return super.getColumnClass(col);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Seq";
            }
            case 1: {
                return "Time";
            }
            case 2: {
                return "Level";
            }
            case 3: {
                return "Thread Name";
            }
            case 4: {
                return "Class Name";
            }
            case 5: {
                return "Location";
            }
            case 6: {
                return "Thrown";
            }
            case 7: {
                return "Message";
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this._records.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Log4jLogRecord r = this._records.get(row);
        switch (col) {
            case 0: {
                return Long.toString(r.getSequenceNumber());
            }
            case 1: {
                return new Timestamp(r.getMillis());
            }
            case 2: {
                return r.getLevel();
            }
            case 3: {
                return r.getThreadDescription();
            }
            case 4: {
                return r.getCategory();
            }
            case 5: {
                return r.getLocation();
            }
            case 6: {
                return new Boolean(r.getThrownStackTrace() != null);
            }
            case 7: {
                return r.getMessage();
            }
        }
        return null;
    }
}

