/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.gui.GuiLogAppender;
import asemon.gui.Log4jLogRecord;
import asemon.gui.Log4jTableModel;
import asemon.gui.swing.JColorComboBox;
import asemon.gui.swing.RowFilterValueAndLogLevel;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LogLevel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class Log4jViewer
extends JFrame
implements ActionListener,
TableModelListener {
    private static Logger _logger = Logger.getLogger(Log4jViewer.class);
    private static final long serialVersionUID = 4578428349487389745L;
    private static final Color LOG_LEVEL_COLOR_FATAL = Color.BLUE;
    private static final Color LOG_LEVEL_COLOR_ERROR = Color.RED;
    private static final Color LOG_LEVEL_COLOR_WARN = new Color(255, 204, 0);
    private static final Color LOG_LEVEL_COLOR_INFO = Color.BLACK;
    private static final Color LOG_LEVEL_COLOR_DEBUG = Color.GRAY;
    private static final Color LOG_LEVEL_COLOR_TRACE = Color.LIGHT_GRAY;
    private JFrame _owner = null;
    private JPanel _filterPanel;
    private JLabel _filterLevel_lbl = new JLabel("Show Level");
    private JRadioButton _filterTrace_rb = new JRadioButton("Trace", true);
    private JRadioButton _filterDebug_rb = new JRadioButton("Debug", true);
    private JRadioButton _filterInfo_rb = new JRadioButton("Info", true);
    private JRadioButton _filterWarn_rb = new JRadioButton("Warning", true);
    private JRadioButton _filterError_rb = new JRadioButton("Error", true);
    private JRadioButton _filterFatal_rb = new JRadioButton("Fatal", true);
    private JLabel _filterThreadName_lbl = new JLabel("Thread Name");
    private JTextField _filterThreadName_tf = new JTextField();
    private JLabel _filterClassName_lbl = new JLabel("Class Name");
    private JTextField _filterClassName_tf = new JTextField();
    private JLabel _filterMessage_lbl = new JLabel("Message");
    private JTextField _filterMessage_tf = new JTextField();
    private JCheckBox _filterUseFilter_cb = new JCheckBox("Filters are used", true);
    private JPanel _optionsPanel;
    private JCheckBox _optionTail_cb = new JCheckBox("Move to last log entry when new are entered.", true);
    private LogLevelDialog _logLevelDialog = null;
    private JButton _logLevel_but = new JButton("Set log level");
    private JButton _clearAll_but = new JButton("Clear all log records");
    private JButton _test_but = new JButton("Log Test records");
    private JLabel _maxLogRecords_lbl = new JLabel("Max log records");
    private JSpinner _maxLogRecords_sp = null;
    private SpinnerNumberModel _maxLogRecords_spm = null;
    private Log4jTableModel _log4jTableModel = null;
    private JXTable _dataTable = null;
    private JPopupMenu _tablePopupMenu = null;
    private RowFilterValueAndLogLevel _tableValAndLogLevelRowFilter = null;
    private boolean _tableRowFilterIsSet = false;
    private Highlighter[] _highlitersLogLevelAtColId_1 = new Highlighter[]{new HighlighterLogLevel(new LogLevelPredicate(1, "FATAL"), LOG_LEVEL_COLOR_FATAL), new HighlighterLogLevel(new LogLevelPredicate(1, "ERROR"), LOG_LEVEL_COLOR_ERROR), new HighlighterLogLevel(new LogLevelPredicate(1, "WARN"), LOG_LEVEL_COLOR_WARN), new HighlighterLogLevel(new LogLevelPredicate(1, "INFO"), LOG_LEVEL_COLOR_INFO), new HighlighterLogLevel(new LogLevelPredicate(1, "DEBUG"), LOG_LEVEL_COLOR_DEBUG), new HighlighterLogLevel(new LogLevelPredicate(1, "TRACE"), LOG_LEVEL_COLOR_TRACE)};
    private Highlighter[] _highlitersLogLevelAtColId_2 = new Highlighter[]{new HighlighterLogLevel(new LogLevelPredicate(2, "FATAL"), LOG_LEVEL_COLOR_FATAL), new HighlighterLogLevel(new LogLevelPredicate(2, "ERROR"), LOG_LEVEL_COLOR_ERROR), new HighlighterLogLevel(new LogLevelPredicate(2, "WARN"), LOG_LEVEL_COLOR_WARN), new HighlighterLogLevel(new LogLevelPredicate(2, "INFO"), LOG_LEVEL_COLOR_INFO), new HighlighterLogLevel(new LogLevelPredicate(2, "DEBUG"), LOG_LEVEL_COLOR_DEBUG), new HighlighterLogLevel(new LogLevelPredicate(2, "TRACE"), LOG_LEVEL_COLOR_TRACE)};

    public Log4jViewer(JFrame owner) {
        this._owner = owner;
        this._log4jTableModel = GuiLogAppender.getTableModel();
        this.initComponents();
    }

    @Override
    public void setVisible(boolean b) {
        this._test_but.setVisible(false);
        if (b) {
            this._dataTable.packAll();
            if (_logger.isDebugEnabled()) {
                this._test_but.setVisible(true);
            }
        }
        super.setVisible(b);
    }

    protected void initComponents() {
        if (this._owner != null) {
            this.setIconImage(this._owner.getIconImage());
        }
        this.setTitle("Log4j - Log and Trace view");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createTopPanel(), "North");
        panel.add((Component)this.createTablePanel(), "Center");
        this.loadProps();
        this.setContentPane(panel);
        this.initComponentActions();
    }

    private JPanel createTopPanel() {
        JPanel panel = SwingUtils.createPanel("Top", false);
        panel.setLayout((LayoutManager)new MigLayout("ins 3 10 3 3", "", ""));
        this._filterPanel = this.createFilterPanel();
        this._optionsPanel = this.createOptionsPanel();
        panel.add((Component)this._filterPanel, "top, grow");
        panel.add((Component)this._optionsPanel, "top, grow");
        return panel;
    }

    private JPanel createFilterPanel() {
        JPanel panel = SwingUtils.createPanel("Filter", true);
        panel.setLayout((LayoutManager)new MigLayout("ins 0 5 0 5", "", ""));
        this._filterLevel_lbl.setToolTipText("Show following errorlevels in the table.");
        this._filterFatal_rb.setToolTipText("Show FATAL messages in the table.");
        this._filterError_rb.setToolTipText("Show ERROR messages in the table.");
        this._filterWarn_rb.setToolTipText("Show WARNING messages in the table.");
        this._filterInfo_rb.setToolTipText("Show INFORMATIONAL messages in the table.");
        this._filterDebug_rb.setToolTipText("Show DEBUG messages in the table.");
        this._filterTrace_rb.setToolTipText("Show TRACE messages in the table.");
        this._filterThreadName_lbl.setToolTipText("Show only these thread names in the tabel (regexp can be used)");
        this._filterThreadName_tf.setToolTipText("Show only these thread names in the tabel (regexp can be used)");
        this._filterClassName_lbl.setToolTipText("Show only these class names in the tabel (regexp can be used)");
        this._filterClassName_tf.setToolTipText("Show only these class names in the tabel (regexp can be used)");
        this._filterMessage_lbl.setToolTipText("Show only these messages in the tabel (regexp can be used)");
        this._filterMessage_tf.setToolTipText("Show only these messages in the tabel (regexp can be used)");
        panel.add((Component)this._filterUseFilter_cb, "span");
        panel.add((Component)this._filterLevel_lbl, "");
        panel.add((Component)this._filterFatal_rb, "split 99");
        panel.add((Component)this._filterError_rb, "");
        panel.add((Component)this._filterWarn_rb, "");
        panel.add((Component)this._filterInfo_rb, "");
        panel.add((Component)this._filterDebug_rb, "");
        panel.add((Component)this._filterTrace_rb, "wrap");
        panel.add((Component)this._filterThreadName_lbl, "");
        panel.add((Component)this._filterThreadName_tf, "grow, wrap");
        panel.add((Component)this._filterClassName_lbl, "");
        panel.add((Component)this._filterClassName_tf, "grow, wrap");
        panel.add((Component)this._filterMessage_lbl, "");
        panel.add((Component)this._filterMessage_tf, "grow, wrap");
        panel.add((Component)this._filterUseFilter_cb, "span");
        return panel;
    }

    private JPanel createOptionsPanel() {
        JPanel panel = SwingUtils.createPanel("Options", true);
        panel.setLayout((LayoutManager)new MigLayout("ins 0 5 0 5", "", ""));
        this._maxLogRecords_spm = new SpinnerNumberModel(this._log4jTableModel.getMaxRecords(), 1, Integer.MAX_VALUE, 50);
        this._maxLogRecords_sp = new JSpinner(this._maxLogRecords_spm);
        this._optionTail_cb.setToolTipText("Move to the last record in the table when new log records are added.");
        this._maxLogRecords_lbl.setToolTipText("How many record should the table hold.");
        this._maxLogRecords_sp.setToolTipText("How many record should the table hold.");
        this._test_but.setToolTipText("Generate one log record for each log level. This Button will only be visible when we are in log level DEBUG.");
        this._logLevel_but.setToolTipText("Open a dialog where you can change log level for classes that has registered themself with log4j.");
        this._clearAll_but.setToolTipText("Clear all records from the table.");
        panel.add((Component)this._optionTail_cb, "wrap");
        panel.add((Component)this._maxLogRecords_lbl, "split");
        panel.add((Component)this._maxLogRecords_sp, "wrap");
        panel.add((Component)this._test_but, "wrap");
        panel.add((Component)this._logLevel_but, "bottom, left, push, split");
        panel.add((Component)this._clearAll_but, "bottom, right, push, wrap");
        return panel;
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout(new BorderLayout());
        this._log4jTableModel.addTableModelListener(this);
        this._dataTable = new JXTable(){
            private static final long serialVersionUID = 0L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                if (row >= 0) {
                    row = super.convertRowIndexToModel(row);
                    TableModel model = this.getModel();
                    if (model instanceof Log4jTableModel) {
                        Log4jLogRecord l = ((Log4jTableModel)model).getRecord(row);
                        tip = l.getToolTipText();
                    }
                }
                return tip;
            }
        };
        this._dataTable.setModel((TableModel)GuiLogAppender.getTableModel());
        this._dataTable.setSelectionMode(0);
        this._dataTable.setAutoResizeMode(0);
        this._dataTable.packAll();
        this._dataTable.setSortable(true);
        this._dataTable.setColumnControlVisible(true);
        this._dataTable.setHighlighters(this._highlitersLogLevelAtColId_2);
        this._tablePopupMenu = this.createDataTablePopupMenu();
        this._dataTable.setComponentPopupMenu(this._tablePopupMenu);
        JScrollPane scroll = new JScrollPane((Component)this._dataTable);
        this._tableValAndLogLevelRowFilter = new RowFilterValueAndLogLevel((JTable)this._dataTable);
        panel.add((Component)scroll, "Center");
        return panel;
    }

    public JPopupMenu getDataTablePopupMenu() {
        return this._tablePopupMenu;
    }

    public JPopupMenu createDataTablePopupMenu() {
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (_logger.isDebugEnabled()) {
            this._test_but.setVisible(true);
        }
        if (this._optionTail_cb.isSelected()) {
            this.showLastTableRow();
        }
    }

    public void showLastTableRow() {
        int colId = this._log4jTableModel.findColumn("Message");
        colId = colId > 0 ? colId - 1 : 0;
        this.showCell(this._dataTable.getRowCount() - 1, colId, true);
    }

    public void showCell(int row, int column, boolean selectTheRow) {
        if (row < 0 || column < 0) {
            return;
        }
        Rectangle rect = this._dataTable.getCellRect(row, column, true);
        this._dataTable.scrollRectToVisible(rect);
        if (selectTheRow) {
            this._dataTable.clearSelection();
            this._dataTable.setRowSelectionInterval(row, row);
        }
    }

    private void initComponentActions() {
        this._filterFatal_rb.addActionListener(this);
        this._filterError_rb.addActionListener(this);
        this._filterWarn_rb.addActionListener(this);
        this._filterInfo_rb.addActionListener(this);
        this._filterDebug_rb.addActionListener(this);
        this._filterTrace_rb.addActionListener(this);
        this._filterThreadName_tf.addActionListener(this);
        this._filterClassName_tf.addActionListener(this);
        this._filterMessage_tf.addActionListener(this);
        this._filterUseFilter_cb.addActionListener(this);
        this._optionTail_cb.addActionListener(this);
        this._test_but.addActionListener(this);
        this._logLevel_but.addActionListener(this);
        this._clearAll_but.addActionListener(this);
        this._maxLogRecords_sp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int records = Log4jViewer.this._maxLogRecords_spm.getNumber().intValue();
                Log4jViewer.this._log4jTableModel.setMaxRecords(records);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Log4jViewer.this.saveProps();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._filterFatal_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterError_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterWarn_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterInfo_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterDebug_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterTrace_rb.equals(source)) {
            this.setFilter();
        }
        if (this._filterThreadName_tf.equals(source)) {
            this.setFilter();
        }
        if (this._filterClassName_tf.equals(source)) {
            this.setFilter();
        }
        if (this._filterMessage_tf.equals(source)) {
            this.setFilter();
        }
        if (this._filterUseFilter_cb.equals(source)) {
            this.setFilter();
        }
        if (this._optionTail_cb.equals(source)) {
            _logger.debug((Object)("CHECKBOX: TAIL = " + this._optionTail_cb.isSelected()));
            if (this._log4jTableModel != null) {
                this._log4jTableModel.fireTableDataChanged();
            }
        }
        if (this._logLevel_but.equals(source)) {
            if (this._logLevelDialog == null) {
                this._logLevelDialog = new LogLevelDialog(this);
            }
            this._logLevelDialog.setVisible(true);
        }
        if (this._clearAll_but.equals(source)) {
            GuiLogAppender.getTableModel().clear();
        }
        if (this._test_but.equals(source)) {
            _logger.fatal((Object)"FATAL TEST message with a stacktrace.", (Throwable)new Exception("FATAL TEST"));
            _logger.error((Object)"ERROR TEST message with a stacktrace.", (Throwable)new Exception("ERROR TEST"));
            _logger.warn((Object)"WARN  TEST message.");
            _logger.info((Object)"INFO  TEST message.");
            _logger.debug((Object)"DEBUG TEST message.");
            _logger.trace((Object)"TRACE TEST message.");
        }
    }

    private void setFilter() {
        _logger.trace((Object)"setFilter() was called");
        _logger.debug((Object)("CHECKBOX: USE-FILTER = " + this._filterUseFilter_cb.isSelected()));
        if (!this._filterUseFilter_cb.isSelected()) {
            this._tableValAndLogLevelRowFilter.resetFilter();
            return;
        }
        String threadName = this._filterThreadName_tf.getText();
        String className = this._filterClassName_tf.getText();
        String message = this._filterMessage_tf.getText();
        int level = 0;
        if (this._filterFatal_rb.isSelected()) {
            level |= 1;
        }
        if (this._filterError_rb.isSelected()) {
            level |= 2;
        }
        if (this._filterWarn_rb.isSelected()) {
            level |= 4;
        }
        if (this._filterInfo_rb.isSelected()) {
            level |= 8;
        }
        if (this._filterDebug_rb.isSelected()) {
            level |= 0x10;
        }
        if (this._filterTrace_rb.isSelected()) {
            level |= 0x20;
        }
        _logger.debug((Object)("FILTER: threadName='" + threadName + "', className='" + className + "', message=" + message + "."));
        if (this._tableValAndLogLevelRowFilter == null || threadName == null || className == null || message == null) {
            return;
        }
        if (!this._tableRowFilterIsSet) {
            this._tableRowFilterIsSet = true;
            _logger.debug((Object)"No table filter was priviously set, so lets set it now.");
            this._dataTable.setRowFilter((RowFilter)this._tableValAndLogLevelRowFilter);
        }
        int levelColId = this._log4jTableModel.findColumn("Level");
        int threadNameColId = this._log4jTableModel.findColumn("Thread Name");
        int classNameColId = this._log4jTableModel.findColumn("Class Name");
        int messageColId = this._log4jTableModel.findColumn("Message");
        this._tableValAndLogLevelRowFilter.setFilterColId(levelColId, threadNameColId, classNameColId, messageColId);
        this._tableValAndLogLevelRowFilter.setFilter(level, threadName, className, message);
    }

    public LogLevel getLogLevelForRow(int row) {
        int levelColId = this._log4jTableModel.findColumn("Level");
        return (LogLevel)this._dataTable.getValueAt(row, levelColId);
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        String base = "logWindow.";
        if (conf != null) {
            conf.setProperty(base + "window.width", this.getSize().width);
            conf.setProperty(base + "window.height", this.getSize().height);
            conf.setProperty(base + "window.pos.x", this.getLocationOnScreen().x);
            conf.setProperty(base + "window.pos.y", this.getLocationOnScreen().y);
            conf.save();
        }
    }

    private void loadProps() {
        int width = -1;
        int height = -1;
        int x = -1;
        int y = -1;
        Configuration conf = Configuration.getCombinedConfiguration();
        String base = "logWindow.";
        if (conf == null) {
            return;
        }
        int defWidth = 3 * Toolkit.getDefaultToolkit().getScreenSize().width / 4;
        int defHeight = 3 * Toolkit.getDefaultToolkit().getScreenSize().height / 4;
        width = conf.getIntProperty(base + "window.width", defWidth);
        height = conf.getIntProperty(base + "window.height", defHeight);
        x = conf.getIntProperty(base + "window.pos.x", -1);
        y = conf.getIntProperty(base + "window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            SwingUtils.centerWindow(this);
        }
    }

    private class LogLevelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8311230082363270019L;
        private static final int CLASS_NAME_COL_POS = 0;
        private static final int LEVEL_COL_POS = 1;
        private ArrayList<Log4jClass> _rows = new ArrayList();
        private String[] _cols = new String[]{"Class Name", "Level"};

        private LogLevelTableModel() {
        }

        public void clear() {
            this._rows.clear();
            this.fireTableDataChanged();
        }

        public void addRows(Log4jClass c) {
            this._rows.add(c);
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this._cols[col];
        }

        @Override
        public int getColumnCount() {
            return this._cols.length;
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Log4jClass r = this._rows.get(row);
            switch (col) {
                case 0: {
                    return r._className;
                }
                case 1: {
                    return r;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            _logger.trace((Object)("row=" + row + ", col=" + col + ", obj='" + obj.getClass().getName() + "', obj.toString='" + obj + "'."));
            Log4jClass r = this._rows.get(row);
            switch (col) {
                case 1: {
                    r._level = obj.toString();
                }
            }
            this.fireTableCellUpdated(row, 1);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 1) {
                return Log4jClass.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }
    }

    private class Log4jClass {
        protected String _className = "";
        protected Level _levelObj = null;
        protected String _level = "";
        protected String _originalLevel = "";

        public Log4jClass(String className, Level level) {
            this._className = className;
            this._levelObj = level;
            this._level = level.toString();
            this._originalLevel = level.toString();
        }

        public String toString() {
            return this._level;
        }
    }

    private class LogLevelDialog
    extends JDialog
    implements ActionListener,
    TableModelListener {
        private static final long serialVersionUID = 8370470094367910481L;
        private JFrame _owner;
        private String[] _logLevels;
        private Color[] _logLevelsColors;
        private LogLevelTableModel _tm;
        private JLabel _allToLevel_lbl;
        private JColorComboBox _allToLevel_cb;
        private JButton _ok;
        private JButton _cancel;
        private JButton _apply;
        private JXTable _dataTable;

        private LogLevelDialog(JFrame frame) {
            super(frame);
            this._owner = null;
            this._logLevels = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
            this._logLevelsColors = new Color[]{LOG_LEVEL_COLOR_FATAL, LOG_LEVEL_COLOR_ERROR, LOG_LEVEL_COLOR_WARN, LOG_LEVEL_COLOR_INFO, LOG_LEVEL_COLOR_DEBUG, LOG_LEVEL_COLOR_TRACE};
            this._tm = new LogLevelTableModel();
            this._allToLevel_lbl = new JLabel("Set level for all classes to");
            this._allToLevel_cb = new JColorComboBox(2, this._logLevelsColors, this._logLevels);
            this._ok = new JButton("OK");
            this._cancel = new JButton("Cancel");
            this._apply = new JButton("Apply");
            this._dataTable = new JXTable();
            this._owner = frame;
            this.refreshData();
            this.setContentPane(this.createTablePanel());
            int width = 400;
            int height = 600;
            this.setSize(width, height);
            SwingUtils.setLocationNearTopLeft(this._owner, this, 40, 40);
            this.setVisible(true);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.refreshData();
            }
            super.setVisible(b);
        }

        private void refreshData() {
            this._tm.clear();
            ArrayList<Logger> logList = Collections.list(LogManager.getCurrentLoggers());
            Collections.sort(logList, new LogSorter());
            for (Logger logger : logList) {
                this._tm.addRows(new Log4jClass(logger.getName(), logger.getEffectiveLevel()));
            }
            this._dataTable.packAll();
            this._apply.setEnabled(false);
        }

        private JPanel createTablePanel() {
            this.setTitle("Log4j - Set log levels");
            JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
            panel.setLayout((LayoutManager)new MigLayout("ins 0", "", ""));
            this._tm.addTableModelListener(this);
            this._dataTable.setModel((TableModel)this._tm);
            this._dataTable.packAll();
            this._dataTable.setSortable(true);
            this._dataTable.setColumnControlVisible(true);
            this._dataTable.setHighlighters(Log4jViewer.this._highlitersLogLevelAtColId_1);
            this._dataTable.setDefaultEditor(Log4jClass.class, (TableCellEditor)new DefaultCellEditor(new JColorComboBox(2, this._logLevelsColors, this._logLevels)));
            this._dataTable.setDefaultRenderer(Log4jClass.class, (TableCellRenderer)new DefaultTableCellRenderer());
            JScrollPane scroll = new JScrollPane((Component)this._dataTable);
            panel.add((Component)scroll, "grow, push, height 100%, wrap 15");
            panel.add((Component)this._allToLevel_lbl, "align right, split");
            panel.add((Component)this._allToLevel_cb, "gapright 15, wrap 15");
            panel.add((Component)this._ok, "tag ok,     split");
            panel.add((Component)this._cancel, "tag cancel, split");
            panel.add((Component)this._apply, "tag apply,  gapright 15, wrap 15");
            this._allToLevel_cb.addActionListener(this);
            this._ok.addActionListener(this);
            this._cancel.addActionListener(this);
            this._apply.addActionListener(this);
            return panel;
        }

        private void apply() {
            for (int r = 0; r < this._tm.getRowCount(); ++r) {
                Log4jClass l = (Log4jClass)this._tm.getValueAt(r, 1);
                if (l._originalLevel.equals(l._level)) continue;
                _logger.info((Object)("Setting new Level for '" + l._className + "' from '" + l._originalLevel + "', to '" + l._level + "'."));
                Logger logger = LogManager.exists((String)l._className);
                if (logger == null) {
                    _logger.error((Object)("Class name '" + l._className + "' cant be found, check available with: log4j get"));
                    return;
                }
                if ("TRACE".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.TRACE);
                    continue;
                }
                if ("DEBUG".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.DEBUG);
                    continue;
                }
                if ("INFO".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.INFO);
                    continue;
                }
                if ("WARN".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.WARN);
                    continue;
                }
                if ("ERROR".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.ERROR);
                    continue;
                }
                if ("FATAL".equalsIgnoreCase(l._level)) {
                    logger.setLevel(Level.FATAL);
                    continue;
                }
                logger.setLevel(Level.DEBUG);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this._allToLevel_cb.equals(source)) {
                Object obj = this._allToLevel_cb.getSelectedItem();
                for (int r = 0; r < this._tm.getRowCount(); ++r) {
                    this._tm.setValueAt(obj, r, 1);
                }
            }
            if (this._ok.equals(source)) {
                this.apply();
                this.setVisible(false);
            }
            if (this._cancel.equals(source)) {
                this.setVisible(false);
            }
            if (this._apply.equals(source)) {
                this.apply();
                this.refreshData();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int type = e.getType();
            int column = e.getColumn();
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            _logger.debug((Object)("TableModelEvent: type=" + type + ", column=" + column + ", firstRow=" + firstRow + ", lastRow=" + lastRow));
            if (column >= 0) {
                this._apply.setEnabled(true);
            }
        }
    }

    private class LogSorter
    implements Comparator<Logger> {
        private LogSorter() {
        }

        @Override
        public int compare(Logger o1, Logger o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class HighlighterLogLevel
    extends AbstractHighlighter {
        Color _color = null;

        public HighlighterLogLevel(HighlightPredicate predicate, Color color) {
            super(predicate);
            this._color = color;
        }

        protected Component doHighlight(Component comp, ComponentAdapter adapter) {
            comp.setForeground(this._color);
            return comp;
        }
    }

    private class LogLevelPredicate
    implements HighlightPredicate {
        int _logLevelColId = -1;
        String _logLevelStr = "";

        public LogLevelPredicate(int logLevelColId, String logLevelStr) {
            this._logLevelColId = logLevelColId;
            this._logLevelStr = logLevelStr;
        }

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            Object value = adapter.getFilteredValueAt(adapter.row, this._logLevelColId);
            if (value != null) {
                value = value.toString();
            }
            boolean ret = this._logLevelStr.equals(value);
            return ret;
        }
    }
}

