/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.AseConfig;
import asemon.AseConfigText;
import asemon.Asemon;
import asemon.GetCounters;
import asemon.GetCountersGui;
import asemon.MonTablesDictionary;
import asemon.ProcessDetailFrame;
import asemon.Version;
import asemon.check.CheckForUpdates;
import asemon.cm.CountersModel;
import asemon.cm.sql.VersionInfo;
import asemon.gui.AboutBox;
import asemon.gui.AseConfigViewDialog;
import asemon.gui.AseMonitoringConfigDialog;
import asemon.gui.ConnectionDialog;
import asemon.gui.GuiLogAppender;
import asemon.gui.Log4jViewer;
import asemon.gui.OfflineSessionVeiwer;
import asemon.gui.ParameterDialog;
import asemon.gui.QueryWindow;
import asemon.gui.SummaryPanel;
import asemon.gui.TabularCntrPanel;
import asemon.gui.TcpConfigDialog;
import asemon.gui.TrendGraph;
import asemon.gui.TrendGraphPanelReorderDialog;
import asemon.gui.swing.AbstractComponentDecorator;
import asemon.gui.swing.GTabbedPane;
import asemon.gui.swing.GTabbedPaneViewDialog;
import asemon.gui.swing.Screenshot;
import asemon.gui.wizard.WizardOffline;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.pcs.InMemoryCounterHandler;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistReader;
import asemon.pcs.PersistentCounterHandler;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.Memory;
import asemon.utils.PropPropEntry;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LogLevel;

public class MainFrame
extends JFrame
implements ActionListener,
ChangeListener,
TableModelListener,
GTabbedPane.TabOrderAndVisibilityListener {
    private static final long serialVersionUID = 8984251025337127843L;
    private static Logger _logger = Logger.getLogger(MainFrame.class);
    public static final int ST_CONNECT = 1;
    public static final int ST_OFFLINE_CONNECT = 2;
    public static final int ST_DISCONNECT = 3;
    public static final int ST_STATUS_FIELD = 4;
    public static final int ST_STATUS2_FIELD = 5;
    public static final int ST_MEMORY = 6;
    private static final String ST_DEFAULT_STATUS_FIELD = "Not Connected";
    private static final String ST_DEFAULT_STATUS2_FIELD = "";
    private static final String ST_DEFAULT_SERVER_NAME = "ASENAME (host:port)";
    private static final String ST_DEFAULT_SERVER_LISTENERS = "ASE Server listens on address";
    public static final String ACTION_CONNECT = "CONNECT";
    public static final String ACTION_DISCONNECT = "DISCONNECT";
    public static final String ACTION_EXIT = "EXIT";
    public static final String ACTION_OPEN_LOG_VIEW = "OPEN_LOG_VIEW";
    public static final String ACTION_OPEN_OFFLINE_SESSION_VIEW = "OPEN_OFFLINE_SESSION_VIEW";
    public static final String ACTION_TOGGLE_AUTO_RESIZE_PC_TABLES = "TOGGLE_AUTO_RESIZE_PC_TABLES";
    public static final String ACTION_OPEN_REFRESH_RATE = "OPEN_REFRESH_RATE";
    public static final String ACTION_OPEN_COUNTER_TAB_VIEW = "OPEN_COUNTER_TAB_VIEW";
    public static final String ACTION_OPEN_GRAPH_GRAPH_VIEW = "OPEN_GRAPH_GRAPH_VIEW";
    public static final String ACTION_OPEN_ASE_CONFIG_MON = "OPEN_ASE_CONFIG_MON";
    public static final String ACTION_OPEN_ASE_CONFIG_VIEW = "ACTION_OPEN_ASE_CONFIG_VIEW";
    public static final String ACTION_OPEN_TCP_PANEL_CONFIG = "OPEN_TCP_PANEL_CONFIG";
    public static final String ACTION_OPEN_CAPTURE_SQL = "OPEN_CAPTURE_SQL";
    public static final String ACTION_OPEN_SQL_QUERY_WIN = "OPEN_SQL_QUERY_WIN";
    public static final String ACTION_OPEN_LOCK_TOOL = "OPEN_LOCK_TOOL";
    public static final String ACTION_OPEN_WIZARD_OFFLINE = "OPEN_WIZARD_OFFLINE";
    public static final String ACTION_OPEN_WIZARD_UDCM = "OPEN_WIZARD_UDCM";
    public static final String ACTION_GARBAGE_COLLECT = "GARBAGE_COLLECT";
    public static final String ACTION_OPEN_ABOUT = "OPEN_ABOUT";
    public static final String ACTION_VIEW_STORAGE = "ACTION_VIEW_STORAGE";
    public static final String ACTION_REFRESH_NOW = "REFRESH_NOW";
    public static final String ACTION_GOTO_BLOCKED_TAB = "GOTO_BLOCKED_TAB";
    public static final String ACTION_GOTO_DATABASE_TAB = "GOTO_DATABASE_TAB";
    public static final String ACTION_OUT_OF_MEMORY = "OUT_OF_MEMORY";
    public static final String ACTION_SCREENSHOT = "SCREENSHOT";
    public static final String ACTION_SAMPLING_PAUSE = "SAMPLING_PAUSE";
    public static final String ACTION_SAMPLING_PLAY = "SAMPLING_PLAY";
    public static final String ACTION_TAB_SELECTOR = "TAB_SELECTOR";
    private PersistContainer _currentPc = null;
    private JToolBar _toolbar = new JToolBar();
    private JCheckBox _viewStorage_chk = new JCheckBox();
    private JSlider _readSlider = new JSlider();
    private ReadTsWatermark _readTsWatermark = null;
    private Timer _readSelectionTimer = new Timer(100, new ReadSelectionTimerAction(this));
    private JSlider _offlineSlider = new JSlider();
    private ReadTsWatermark _offlineTsWatermark = null;
    private Timer _offlineSelectionTimer = new Timer(100, new OfflineSelectionTimerAction(this));
    private JComboBox _workspace_cbx = new JComboBox();
    private JMenuBar _main_mb = new JMenuBar();
    private JMenu _file_m = new JMenu("File");
    private JMenuItem _connect_mi = new JMenuItem("Connect...");
    private JMenuItem _disconnect_mi = new JMenuItem("Disconnect");
    private JMenuItem _exit_mi = new JMenuItem("Exit");
    private JMenu _view_m = new JMenu("View");
    private JMenuItem _logView_mi = new JMenuItem("Open Log Window...");
    private JMenuItem _offlineSessionsView_mi = new JMenuItem("Offline Sessions Window...");
    private JMenu _preferences_m = new JMenu("Preferences");
    private JMenuItem _refreshRate_mi = new JMenuItem("Refresh Rate...");
    private JCheckBoxMenuItem _autoResizePcTable_mi = new JCheckBoxMenuItem("Auto Resize Column Width in Performance Counter Tables", false);
    private JMenuItem _aseMonConf_mi = new JMenuItem("Configure ASE for Monitoring...");
    private JMenuItem _aseConfigView_mi = new JMenuItem("View ASE Configuration...");
    private JMenuItem _tcpSettingsConf_mi = new JMenuItem("Change 'Counter Table' Parameters...");
    private JMenuItem _counterTabView_mi = new JMenuItem("Change 'Tab Titles' Order and Visibility...");
    private JMenuItem _graphView_mi = new JMenuItem("Change 'Graph' Order and Visibility...");
    private static JMenu _graphs_m = new JMenu("Active Graphs");
    private JMenu _tools_m = new JMenu("Tools");
    private JMenuItem _captureSql_mi = new JMenuItem("Capture SQL...");
    private JMenu _preDefinedSql_m = null;
    private JMenuItem _sqlQuery_mi = new JMenuItem("SQL Query Window...");
    private JMenuItem _createOffline_mi = new JMenuItem("Create 'Offline Session' Wizard...");
    private JMenuItem _wizardCrUdCm_mi = new JMenuItem("Create 'User Defined Counter' Wizard...");
    private JMenuItem _doGc_mi = new JMenuItem("Java Garbage Collection");
    private JMenu _help_m = new JMenu("Help");
    private JMenuItem _about_mi = new JMenuItem("About");
    private static GTabbedPane _mainTabbedPane = new GTabbedPane();
    private JPanel _statusPanel = new JPanel();
    private JButton _blockAlert_but = new JButton();
    private JButton _fullTranlogAlert_but = new JButton();
    private JButton _refreshNow_but = new JButton();
    private JButton _samplePause_but = new JButton();
    private JButton _samplePauseTb_but = new JButton();
    private JButton _samplePlay_but = new JButton();
    private JButton _samplePlayTb_but = new JButton();
    private JButton _gcNow_but = new JButton();
    private static JLabel _statusStatus = new JLabel("Not Connected");
    private static JLabel _statusStatus2 = new JLabel("");
    private static JLabel _statusServerName = new JLabel("ASENAME (host:port)");
    private static JLabel _statusServerListeners = new JLabel("ASE Server listens on address");
    private static JLabel _statusMemory = new JLabel("JVM Memory Usage");
    private static MainFrame _instance = null;
    private static Log4jViewer _logView = null;
    private static Connection _offlineConn = null;
    private static long _lastOfflineIsClosedCheck = 0L;
    private static long _lastOfflineIsClosedRefreshTime = 1200L;
    private static OfflineSessionVeiwer _offlineView = null;
    private static int _refreshInterval = 10;
    private static int _refreshNoGuiInterval = 60;
    private static long _guiInitTime = 0L;
    private static String _offlineSamplePeriod = null;
    private static boolean _isSamplingPaused = false;
    private static Map<String, TabularCntrPanel> _TcpMap = new HashMap<String, TabularCntrPanel>();
    private static SummaryPanel _summaryPanel = new SummaryPanel();
    private static TabularCntrPanel _currentPanel = null;
    private static HashMap<String, String> _udTooltipMap = new HashMap();
    private List<Timestamp> _offlineTsList = new ArrayList<Timestamp>();

    public static int getRefreshInterval() {
        return _refreshInterval;
    }

    public static int getRefreshIntervalNoGui() {
        return _refreshNoGuiInterval;
    }

    public MainFrame() {
        _instance = this;
        this.initComponents();
        this.loadProps();
    }

    public static MainFrame getInstance() {
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(MainFrame inst) {
        _instance = inst;
    }

    @Override
    public void setVisible(boolean visible) {
        _guiInitTime = System.currentTimeMillis();
        super.setVisible(visible);
    }

    protected void initComponents() {
        this.setTitle("Asemon");
        ImageIcon icon = SwingUtils.readImageIcon(Version.class, "images/asemon_icon.gif");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.setTitle("Asemon - This DEVELOPMENT VERSION will NOT work after '" + df.format(Version.DEV_VERSION_EXPIRE_DATE) + "', then you will have to download a later version.");
        if (Asemon.hasDevVersionExpired()) {
            this.setTitle("Asemon - In Development Version, \"time to live date\" has EXPIRED, only 'Persistent Counter Storage - READ' is enabled.");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._connect_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/connect16.gif"));
        this._disconnect_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/disconnect16.gif"));
        this._exit_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/close.gif"));
        this._logView_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/log_viewer.gif"));
        this._offlineSessionsView_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/offline_sessions_view.png"));
        this._autoResizePcTable_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/auto_resize_table_columns.png"));
        this._refreshRate_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/refresh_rate.png"));
        this._aseMonConf_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/config_ase_mon.png"));
        this._aseConfigView_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/config_ase_view.png"));
        this._tcpSettingsConf_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/tcp_settings_conf.png"));
        this._counterTabView_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/counter_tab_view.gif"));
        this._graphView_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/graph.png"));
        _graphs_m.setIcon(SwingUtils.readImageIcon(Version.class, "images/summary_tab.png"));
        this._captureSql_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/capture_sql_tool.gif"));
        this._sqlQuery_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/sql_query_window.png"));
        this._createOffline_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/pcs_write_16.png"));
        this._wizardCrUdCm_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/ud_counter_activity.png"));
        this._about_mi.setIcon(SwingUtils.readImageIcon(Version.class, "images/about.png"));
        this.setJMenuBar(this._main_mb);
        this._main_mb.add(this._file_m);
        this._main_mb.add(this._view_m);
        this._main_mb.add(this._tools_m);
        this._main_mb.add(this._help_m);
        this._file_m.add(this._connect_mi);
        this._file_m.add(this._disconnect_mi);
        this._file_m.add(this._exit_mi);
        this._view_m.add(this._logView_mi);
        this._view_m.add(this._offlineSessionsView_mi);
        this._view_m.add(this._preferences_m);
        this._preferences_m.add(this._autoResizePcTable_mi);
        this._preferences_m.add(this._refreshRate_mi);
        this._view_m.add(this._aseMonConf_mi);
        this._view_m.add(this._aseConfigView_mi);
        this._view_m.add(this._tcpSettingsConf_mi);
        this._view_m.add(this._counterTabView_mi);
        this._view_m.add(this._graphView_mi);
        this._view_m.add(_graphs_m);
        this._tools_m.add(this._captureSql_mi);
        this._preDefinedSql_m = this.createPredefinedSqlMenu();
        if (this._preDefinedSql_m != null) {
            this._tools_m.add(this._preDefinedSql_m);
        }
        this._tools_m.add(this._sqlQuery_mi);
        this._tools_m.add(this._createOffline_mi);
        this._tools_m.add(this._wizardCrUdCm_mi);
        this._tools_m.add(this._doGc_mi);
        this._help_m.add(this._about_mi);
        this._connect_mi.setActionCommand(ACTION_CONNECT);
        this._disconnect_mi.setActionCommand(ACTION_DISCONNECT);
        this._exit_mi.setActionCommand(ACTION_EXIT);
        this._logView_mi.setActionCommand(ACTION_OPEN_LOG_VIEW);
        this._offlineSessionsView_mi.setActionCommand(ACTION_OPEN_OFFLINE_SESSION_VIEW);
        this._autoResizePcTable_mi.setActionCommand(ACTION_TOGGLE_AUTO_RESIZE_PC_TABLES);
        this._refreshRate_mi.setActionCommand(ACTION_OPEN_REFRESH_RATE);
        this._aseMonConf_mi.setActionCommand(ACTION_OPEN_ASE_CONFIG_MON);
        this._aseConfigView_mi.setActionCommand(ACTION_OPEN_ASE_CONFIG_VIEW);
        this._tcpSettingsConf_mi.setActionCommand(ACTION_OPEN_TCP_PANEL_CONFIG);
        this._counterTabView_mi.setActionCommand(ACTION_OPEN_COUNTER_TAB_VIEW);
        this._graphView_mi.setActionCommand(ACTION_OPEN_GRAPH_GRAPH_VIEW);
        this._captureSql_mi.setActionCommand(ACTION_OPEN_CAPTURE_SQL);
        this._sqlQuery_mi.setActionCommand(ACTION_OPEN_SQL_QUERY_WIN);
        this._createOffline_mi.setActionCommand(ACTION_OPEN_WIZARD_OFFLINE);
        this._wizardCrUdCm_mi.setActionCommand(ACTION_OPEN_WIZARD_UDCM);
        this._doGc_mi.setActionCommand(ACTION_GARBAGE_COLLECT);
        this._about_mi.setActionCommand(ACTION_OPEN_ABOUT);
        this._connect_mi.addActionListener(this);
        this._disconnect_mi.addActionListener(this);
        this._exit_mi.addActionListener(this);
        this._logView_mi.addActionListener(this);
        this._offlineSessionsView_mi.addActionListener(this);
        this._autoResizePcTable_mi.addActionListener(this);
        this._refreshRate_mi.addActionListener(this);
        this._aseMonConf_mi.addActionListener(this);
        this._aseConfigView_mi.addActionListener(this);
        this._tcpSettingsConf_mi.addActionListener(this);
        this._counterTabView_mi.addActionListener(this);
        this._graphView_mi.addActionListener(this);
        this._captureSql_mi.addActionListener(this);
        this._sqlQuery_mi.addActionListener(this);
        this._createOffline_mi.addActionListener(this);
        this._wizardCrUdCm_mi.addActionListener(this);
        this._doGc_mi.addActionListener(this);
        this._about_mi.addActionListener(this);
        this._file_m.setMnemonic(70);
        this._view_m.setMnemonic(86);
        this._tools_m.setMnemonic(84);
        this._help_m.setMnemonic(72);
        this._connect_mi.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this._disconnect_mi.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this._sqlQuery_mi.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this._logView_mi.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this._tcpSettingsConf_mi.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        JButton connect = SwingUtils.makeToolbarButton(Version.class, "connect16.gif", ACTION_CONNECT, this, "Connect to a ASE", "Connect");
        JButton disConnect = SwingUtils.makeToolbarButton(Version.class, "disconnect16.gif", ACTION_DISCONNECT, this, "Close the ASE Connection", "Disconnect");
        JButton screenshot = SwingUtils.makeToolbarButton(Version.class, "screenshot.png", ACTION_SCREENSHOT, this, "Take a screenshot of the application", "Screenshot");
        this._samplePauseTb_but = SwingUtils.makeToolbarButton(Version.class, "sample_pause.png", ACTION_SAMPLING_PAUSE, this, "Pause ALL sampling activity", "Pause");
        this._samplePlayTb_but = SwingUtils.makeToolbarButton(Version.class, "sample_play.png", ACTION_SAMPLING_PLAY, this, "Continue to sample...", "Pause");
        this._samplePlayTb_but.setVisible(false);
        JButton tabSelectorNoSort = SwingUtils.makeToolbarButton(Version.class, "tab_selector_no_sort.gif", ACTION_TAB_SELECTOR, this, "Activate a specific tab", "Activate Tab");
        final JPopupMenu tabSelectorNoSortPopupMenu = new JPopupMenu();
        tabSelectorNoSortPopupMenu.add(new JMenuItem("No Tab's is Visible"));
        tabSelectorNoSort.setComponentPopupMenu(tabSelectorNoSortPopupMenu);
        tabSelectorNoSortPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                tabSelectorNoSortPopupMenu.removeAll();
                ArrayList<String> tabStrList = new ArrayList<String>();
                for (int t = 0; t < _mainTabbedPane.getTabCount(); ++t) {
                    tabStrList.add(_mainTabbedPane.getTitleAt(t));
                }
                for (String name : tabStrList) {
                    int tabIndex = _mainTabbedPane.indexOfTab(name);
                    JMenuItem mi = new JMenuItem();
                    mi.setText(_mainTabbedPane.getTitleAt(tabIndex));
                    mi.setIcon(_mainTabbedPane.getIconAt(tabIndex));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Object o = e.getSource();
                            if (o instanceof JMenuItem) {
                                JMenuItem mi = (JMenuItem)o;
                                String tabName = mi.getText();
                                int tabIndex = _mainTabbedPane.indexOfTab(tabName);
                                _mainTabbedPane.setSelectedIndex(tabIndex);
                            }
                        }
                    });
                    tabSelectorNoSortPopupMenu.add(mi);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JButton tabSelectorSorted = SwingUtils.makeToolbarButton(Version.class, "tab_selector_sorted.gif", ACTION_TAB_SELECTOR, this, "Activate a specific tab (sorted by name)", "Activate Tab");
        final JPopupMenu tabSelectorSortedPopupMenu = new JPopupMenu();
        tabSelectorSortedPopupMenu.add(new JMenuItem("No Tab's is Visible"));
        tabSelectorSorted.setComponentPopupMenu(tabSelectorSortedPopupMenu);
        tabSelectorSortedPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                tabSelectorSortedPopupMenu.removeAll();
                ArrayList<String> tabStrList = new ArrayList<String>();
                for (int t = 0; t < _mainTabbedPane.getTabCount(); ++t) {
                    tabStrList.add(_mainTabbedPane.getTitleAt(t));
                }
                Collections.sort(tabStrList);
                for (String name : tabStrList) {
                    int tabIndex = _mainTabbedPane.indexOfTab(name);
                    JMenuItem mi = new JMenuItem();
                    mi.setText(_mainTabbedPane.getTitleAt(tabIndex));
                    mi.setIcon(_mainTabbedPane.getIconAt(tabIndex));
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Object o = e.getSource();
                            if (o instanceof JMenuItem) {
                                JMenuItem mi = (JMenuItem)o;
                                String tabName = mi.getText();
                                int tabIndex = _mainTabbedPane.indexOfTab(tabName);
                                _mainTabbedPane.setSelectedIndex(tabIndex);
                            }
                        }
                    });
                    tabSelectorSortedPopupMenu.add(mi);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this._viewStorage_chk.setIcon(SwingUtils.readImageIcon(Version.class, "images/read_storage.png"));
        this._viewStorage_chk.setSelectedIcon(SwingUtils.readImageIcon(Version.class, "images/read_storage_minus.png"));
        this._viewStorage_chk.setToolTipText("View Counters that are stored in memory for a while...");
        this._toolbar.setLayout((LayoutManager)new MigLayout("insets 0 0 0 3", ST_DEFAULT_STATUS2_FIELD, ST_DEFAULT_STATUS2_FIELD));
        this._toolbar.add(connect);
        this._toolbar.add(disConnect);
        this._toolbar.add(screenshot);
        this._toolbar.add((Component)this._samplePauseTb_but, "hidemode 3");
        this._toolbar.add((Component)this._samplePlayTb_but, "hidemode 3");
        this._toolbar.add(tabSelectorNoSort);
        this._toolbar.add(tabSelectorSorted);
        this._workspace_cbx.addItem("ASE");
        this._workspace_cbx.addItem("IQ");
        this._workspace_cbx.addItem("RS");
        this._workspace_cbx.setToolTipText("NOT SUPPORTED NOW: What workspace would you like to use.");
        this._viewStorage_chk.setActionCommand(ACTION_VIEW_STORAGE);
        this._viewStorage_chk.addActionListener(this);
        this._toolbar.add((Component)new JSeparator(1), "grow");
        this._toolbar.add(this._viewStorage_chk);
        this._toolbar.add((Component)this._readSlider, "push, grow, hidemode 3");
        this._toolbar.add((Component)this._offlineSlider, "push, grow, hidemode 3");
        this._readTsWatermark = new ReadTsWatermark(this._readSlider, "empty");
        this._readSlider.setVisible(this._viewStorage_chk.isSelected());
        this._readSlider.setMinimum(0);
        this._readSlider.setMaximum(0);
        this._readSlider.setPaintLabels(true);
        this._readSlider.setPaintTicks(true);
        this._readSlider.setPaintTrack(true);
        this._readSlider.setMajorTickSpacing(10);
        this._readSlider.setMinorTickSpacing(1);
        this._readSlider.addChangeListener(this);
        this._offlineTsWatermark = new ReadTsWatermark(this._offlineSlider, "empty");
        this._offlineSlider.setVisible(false);
        this._offlineSlider.setMinimum(0);
        this._offlineSlider.setMaximum(0);
        this._offlineSlider.setPaintLabels(true);
        this._offlineSlider.setPaintTicks(true);
        this._offlineSlider.setPaintTrack(true);
        this._offlineSlider.setMajorTickSpacing(10);
        this._offlineSlider.setMinorTickSpacing(1);
        this._offlineSlider.addChangeListener(this);
        this._blockAlert_but.setToolTipText("<html>You have SPID(s) that <b>blocks</b> other SPID(s) from working. Click here to the 'Blocking' tab to find out more.</html>");
        this._fullTranlogAlert_but.setToolTipText("<html>The Transaction log in one/several databases are <b>full</b> other SPID(s) are probably <b>blocked</b> by this. Click here to the 'Database' tab to find out more.</html>");
        this._refreshNow_but.setToolTipText("Abort the \"sleep for next refresh\" and make a new refresh of data NOW.");
        this._samplePause_but.setToolTipText("Pause ALL sampling activity.");
        this._samplePlay_but.setToolTipText("Continue to sample counters again.");
        this._gcNow_but.setToolTipText("Do Java Garbage Collection.");
        _statusStatus.setToolTipText("What are we doing or waiting for.");
        _statusStatus2.setToolTipText("What are we doing or waiting for.");
        _statusServerName.setToolTipText("<html>The local name of the ASE Server, as named in the interfaces or sql.ini file.<BR>Also show the HOST:PORT, which we are connected to.</html>");
        _statusServerListeners.setToolTipText("<html>This is the network listeners the ASE Servers listens to.<BR>This is good to see if we connect via SSH tunnels or other proxy functionality.<br>The format is netlibdriver: HOST PORT, next entry...</html>");
        _statusMemory.setToolTipText("How much memory does the JVM consume for the moment.");
        this._blockAlert_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/block_lock_alert.png"));
        this._blockAlert_but.setText(ST_DEFAULT_STATUS2_FIELD);
        this._blockAlert_but.setContentAreaFilled(false);
        this._blockAlert_but.setMargin(new Insets(0, 0, 0, 0));
        this._blockAlert_but.addActionListener(this);
        this._blockAlert_but.setActionCommand(ACTION_GOTO_BLOCKED_TAB);
        this._blockAlert_but.setVisible(false);
        this._fullTranlogAlert_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/full_translog_alert.png"));
        this._fullTranlogAlert_but.setText(ST_DEFAULT_STATUS2_FIELD);
        this._fullTranlogAlert_but.setContentAreaFilled(false);
        this._fullTranlogAlert_but.setMargin(new Insets(0, 0, 0, 0));
        this._fullTranlogAlert_but.addActionListener(this);
        this._fullTranlogAlert_but.setActionCommand(ACTION_GOTO_DATABASE_TAB);
        this._fullTranlogAlert_but.setVisible(false);
        this._refreshNow_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/refresh_now.png"));
        this._refreshNow_but.setText(null);
        this._refreshNow_but.setContentAreaFilled(false);
        this._refreshNow_but.setMargin(new Insets(0, 0, 0, 0));
        this._refreshNow_but.addActionListener(this);
        this._refreshNow_but.setActionCommand(ACTION_REFRESH_NOW);
        this._samplePause_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/sample_pause.png"));
        this._samplePause_but.setText(null);
        this._samplePause_but.setContentAreaFilled(false);
        this._samplePause_but.setMargin(new Insets(0, 0, 0, 0));
        this._samplePause_but.addActionListener(this);
        this._samplePause_but.setActionCommand(ACTION_SAMPLING_PAUSE);
        this._samplePause_but.setVisible(true);
        this._samplePlay_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/sample_play.png"));
        this._samplePlay_but.setText(null);
        this._samplePlay_but.setContentAreaFilled(false);
        this._samplePlay_but.setMargin(new Insets(0, 0, 0, 0));
        this._samplePlay_but.addActionListener(this);
        this._samplePlay_but.setActionCommand(ACTION_SAMPLING_PLAY);
        this._samplePlay_but.setVisible(false);
        this._gcNow_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/gc_now.png"));
        this._gcNow_but.setText(null);
        this._gcNow_but.setContentAreaFilled(false);
        this._gcNow_but.setMargin(new Insets(0, 0, 0, 0));
        this._gcNow_but.addActionListener(this);
        this._gcNow_but.setActionCommand(ACTION_GARBAGE_COLLECT);
        this._statusPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 10"));
        this._statusPanel.add((Component)this._refreshNow_but, ST_DEFAULT_STATUS2_FIELD);
        this._statusPanel.add((Component)this._samplePause_but, "hidemode 3");
        this._statusPanel.add((Component)this._samplePlay_but, "hidemode 3");
        this._statusPanel.add((Component)this._blockAlert_but, "hidemode 3");
        this._statusPanel.add((Component)this._fullTranlogAlert_but, "hidemode 3");
        this._statusPanel.add((Component)_statusStatus, "gaptop 3, gapbottom 5, grow, push");
        this._statusPanel.add((Component)_statusStatus2, ST_DEFAULT_STATUS2_FIELD);
        this._statusPanel.add((Component)new JSeparator(1), "grow");
        this._statusPanel.add((Component)_statusServerName, "right");
        this._statusPanel.add((Component)new JSeparator(1), "grow");
        this._statusPanel.add((Component)_statusServerListeners, "right");
        this._statusPanel.add((Component)new JSeparator(1), "grow");
        this._statusPanel.add((Component)_statusMemory, "right");
        this._statusPanel.add((Component)this._gcNow_but, "right");
        contentPane.add((Component)this._toolbar, "North");
        contentPane.add((Component)_mainTabbedPane, "Center");
        contentPane.add((Component)this._statusPanel, "South");
        _mainTabbedPane.setTabLayoutPolicy(0);
        _mainTabbedPane.addChangeListener(this);
        _mainTabbedPane.setTabOrderAndVisibilityListener(this);
        ImageIcon summaryIcon = SwingUtils.readImageIcon(Version.class, "images/summary_tab.png");
        _mainTabbedPane.addTab("Summary", summaryIcon, _summaryPanel, "Trend Graphs");
        if (GuiLogAppender.getTableModel() != null) {
            GuiLogAppender.getTableModel().addTableModelListener(this);
        }
        this.setDefaultMenuMode();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int answer;
                MainFrame.this.saveProps();
                MainFrame.this.saveTcpProps();
                if (Asemon.getCounterCollector().isMonConnected() && (answer = AseMonitoringConfigDialog.onExit(_instance, Asemon.getCounterCollector().getMonConnection())) > 0) {
                    return;
                }
                MainFrame.terminateConnection();
                CheckForUpdates.sendCounterUsageInfoNoBlock();
                System.exit(0);
            }
        });
    }

    private void setDefaultMenuMode() {
        this._autoResizePcTable_mi.setEnabled(true);
        this._refreshRate_mi.setEnabled(true);
        this._aseMonConf_mi.setEnabled(true);
        this._aseConfigView_mi.setEnabled(true);
        this._tcpSettingsConf_mi.setEnabled(true);
        this._counterTabView_mi.setEnabled(true);
        this._graphView_mi.setEnabled(true);
        _graphs_m.setEnabled(true);
        this._captureSql_mi.setEnabled(true);
        if (this._preDefinedSql_m != null) {
            this._preDefinedSql_m.setEnabled(true);
        }
        this._sqlQuery_mi.setEnabled(true);
        this._createOffline_mi.setEnabled(true);
        this._wizardCrUdCm_mi.setEnabled(true);
        this._offlineSessionsView_mi.setEnabled(false);
    }

    private void setOfflineMenuMode() {
        this._autoResizePcTable_mi.setEnabled(true);
        this._refreshRate_mi.setEnabled(false);
        this._aseMonConf_mi.setEnabled(false);
        this._aseConfigView_mi.setEnabled(true);
        this._tcpSettingsConf_mi.setEnabled(true);
        this._counterTabView_mi.setEnabled(true);
        this._graphView_mi.setEnabled(true);
        _graphs_m.setEnabled(true);
        this._captureSql_mi.setEnabled(false);
        if (this._preDefinedSql_m != null) {
            this._preDefinedSql_m.setEnabled(false);
        }
        this._sqlQuery_mi.setEnabled(false);
        this._createOffline_mi.setEnabled(false);
        this._wizardCrUdCm_mi.setEnabled(false);
        this._offlineSessionsView_mi.setEnabled(true);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (_guiInitTime == 0L) {
            return;
        }
        if (_logView == null) {
            _logView = new Log4jViewer(_instance);
        }
        try {
            LogLevel logLevel = _logView.getLogLevelForRow(e.getLastRow());
            if (logLevel != null && !logLevel.encompasses(LogLevel.WARN) && !_logView.isVisible()) {
                _logView.setVisible(true);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTabbedPane tabPane;
        String toTabName;
        Object source = e.getSource();
        String actionCmd = e.getActionCommand();
        _logger.debug((Object)("ACTION '" + actionCmd + "'."));
        if (ACTION_CONNECT.equals(actionCmd)) {
            this.action_connect(e);
        }
        if (ACTION_DISCONNECT.equals(actionCmd)) {
            this.action_disconnect(e);
        }
        if (ACTION_EXIT.equals(actionCmd)) {
            this.action_exit(e);
        }
        if (ACTION_OPEN_LOG_VIEW.equals(actionCmd)) {
            MainFrame.openLogViewer();
        }
        if (ACTION_OPEN_OFFLINE_SESSION_VIEW.equals(actionCmd)) {
            MainFrame.openOfflineSessionView(true);
        }
        if (ACTION_TOGGLE_AUTO_RESIZE_PC_TABLES.equals(actionCmd)) {
            this.action_toggleAutoResizePcTables(e);
        }
        if (ACTION_OPEN_REFRESH_RATE.equals(actionCmd)) {
            this.action_refreshRate(e);
        }
        if (ACTION_OPEN_COUNTER_TAB_VIEW.equals(actionCmd)) {
            this.action_counterTabView(e);
        }
        if (ACTION_OPEN_GRAPH_GRAPH_VIEW.equals(actionCmd)) {
            this.action_openGraphViewDialog(e);
        }
        if (ACTION_OPEN_ASE_CONFIG_MON.equals(actionCmd)) {
            AseMonitoringConfigDialog.showDialog(this, Asemon.getCounterCollector().getMonConnection(), -1);
        }
        if (ACTION_OPEN_ASE_CONFIG_VIEW.equals(actionCmd)) {
            AseConfigViewDialog.showDialog(this);
        }
        if (ACTION_OPEN_TCP_PANEL_CONFIG.equals(actionCmd)) {
            TcpConfigDialog.showDialog(_instance);
        }
        if (ACTION_OPEN_CAPTURE_SQL.equals(actionCmd)) {
            new ProcessDetailFrame(-1);
        }
        if (ACTION_OPEN_SQL_QUERY_WIN.equals(actionCmd)) {
            try {
                if (!Asemon.getCounterCollector().isMonConnected(true, true)) {
                    SwingUtils.showInfoMessage(MainFrame.getInstance(), "Not connected", "Not yet connected to a server.");
                    return;
                }
                Connection conn = AseConnectionFactory.getConnection(null, Version.getAppName() + "-QueryWindow", null);
                QueryWindow qf = new QueryWindow(conn, true, QueryWindow.WindowType.JFRAME);
                qf.openTheWindow();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problems open SQL Query Window\n" + ex.getMessage(), "Error", 0);
            }
        }
        if (ACTION_OPEN_LOCK_TOOL.equals(actionCmd)) {
            // empty if block
        }
        if (ACTION_OPEN_WIZARD_OFFLINE.equals(actionCmd)) {
            new WizardOffline();
        }
        if (ACTION_OPEN_WIZARD_UDCM.equals(actionCmd)) {
            new WizardUserDefinedCm();
        }
        if (ACTION_GARBAGE_COLLECT.equals(actionCmd)) {
            System.gc();
            MainFrame.setStatus(6);
        }
        if (ACTION_OPEN_ABOUT.equals(actionCmd)) {
            this.action_about(e);
        }
        if (ACTION_VIEW_STORAGE.equals(actionCmd)) {
            if (MainFrame.isOfflineConnected()) {
                MainFrame.openOfflineSessionView(false);
                this._viewStorage_chk.setSelected(false);
                return;
            }
            for (TabularCntrPanel tcp : _TcpMap.values()) {
                _logger.trace((Object)("ACTION_VIEW_STORAGE: setTail(" + this._viewStorage_chk.isSelected() + "), '" + tcp.getPanelName() + "'."));
                if (this._viewStorage_chk.isSelected()) {
                    InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
                    if (this._currentPc == null && imch != null) {
                        this._currentPc = imch.getRight();
                    }
                    CountersModel cm = null;
                    if (imch != null) {
                        cm = this._currentPc.getCm(tcp.getName());
                    }
                    tcp.setDisplayCm(cm, false);
                    continue;
                }
                tcp.setDisplayCm(null, true);
            }
            this._readSlider.setVisible(this._viewStorage_chk.isSelected());
        }
        if (ACTION_REFRESH_NOW.equals(actionCmd)) {
            _logger.debug((Object)"called: ACTION_REFRESH_NOW");
            GetCounters getCnt = Asemon.getCounterCollector();
            if (getCnt != null) {
                getCnt.doInterrupt();
            }
        }
        if (ACTION_GOTO_BLOCKED_TAB.equals(actionCmd)) {
            _logger.debug((Object)"called: ACTION_GOTO_BLOCKED_TAB");
            toTabName = "Blocking";
            tabPane = MainFrame.getTabbedPane();
            if (tabPane != null) {
                tabPane.setSelectedIndex(tabPane.indexOfTab(toTabName));
            }
        }
        if (ACTION_GOTO_DATABASE_TAB.equals(actionCmd)) {
            _logger.debug((Object)"called: ACTION_GOTO_DATABASE_TAB");
            toTabName = "Databases";
            tabPane = MainFrame.getTabbedPane();
            if (tabPane != null) {
                tabPane.setSelectedIndex(tabPane.indexOfTab(toTabName));
            }
        }
        if (ACTION_OUT_OF_MEMORY.equals(actionCmd)) {
            _logger.debug((Object)"called: ACTION_OUT_OF_MEMORY");
            InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
            imch.clear(true);
            System.gc();
            int maxConfigMemInMB = (int)Runtime.getRuntime().maxMemory() / 1024 / 1024;
            int mbLeftAfterGc = Memory.getMemoryLeftInMB();
            JOptionPane optionPane = new JOptionPane("Sorry, out-of-memory. \n\nI have cleared the In Memory Counter History! \nThis will hopefully get us going again. \n\nNote: you can raise the memory parameter -Xmx###m in the " + Version.getAppName() + " start script.\n" + "Current max memory setting seems to be around " + maxConfigMemInMB + " MB.\n" + "After Garbage Collection, you now have " + mbLeftAfterGc + " free MB.", 1);
            JDialog dialog = optionPane.createDialog(this, "out-of-memory");
            dialog.setModal(false);
            dialog.setVisible(true);
            MainFrame.setStatus(6);
        }
        if (ACTION_SCREENSHOT.equals(actionCmd)) {
            String fileList = ST_DEFAULT_STATUS2_FIELD;
            String extraInfo = Version.getAppName() + ", Version: " + Version.getVersionStr();
            String main = Screenshot.windowScreenshot(this, Version.APP_STORE_DIR, "asemon.main", true, extraInfo);
            fileList = fileList + main;
            for (CountersModel cm : GetCounters.getCmList()) {
                GTabbedPane gtp;
                JTabbedPane tp;
                if (cm == null || cm.getTabPanel() == null || !((tp = MainFrame.getTabbedPane()) instanceof GTabbedPane) || !(gtp = (GTabbedPane)tp).isTabUnDocked(cm.getDisplayName())) continue;
                JFrame frame = gtp.getTabUnDockedFrame(cm.getDisplayName());
                String fn = Screenshot.windowScreenshot(frame, Version.APP_STORE_DIR, "asemon." + cm.getName(), true, extraInfo);
                fileList = fileList + "\n" + fn;
            }
            JOptionPane.showMessageDialog(this, "Screenshot was captured. \n\nThe file(s) was stored as: \n" + fileList + "\n" + "\n" + ST_DEFAULT_STATUS2_FIELD, "Screenshot captured", 1);
        }
        if (ACTION_SAMPLING_PAUSE.equals(actionCmd)) {
            _isSamplingPaused = true;
            this._samplePause_but.setVisible(!_isSamplingPaused);
            this._samplePauseTb_but.setVisible(!_isSamplingPaused);
            this._samplePlay_but.setVisible(_isSamplingPaused);
            this._samplePlayTb_but.setVisible(_isSamplingPaused);
            GetCounters.getInstance().doInterrupt();
        }
        if (ACTION_SAMPLING_PLAY.equals(actionCmd)) {
            _isSamplingPaused = false;
            this._samplePause_but.setVisible(!_isSamplingPaused);
            this._samplePauseTb_but.setVisible(!_isSamplingPaused);
            this._samplePlay_but.setVisible(_isSamplingPaused);
            this._samplePlayTb_but.setVisible(_isSamplingPaused);
            GetCounters.getInstance().doInterrupt();
        }
        if (ACTION_TAB_SELECTOR.equals(actionCmd) && source instanceof JButton) {
            JButton but = (JButton)source;
            JPopupMenu pm = but.getComponentPopupMenu();
            pm.show(but, 14, 14);
            pm.setLocation(MouseInfo.getPointerInfo().getLocation());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(_mainTabbedPane)) {
            int selectedTab = _mainTabbedPane.getSelectedIndex();
            if (selectedTab < 0) {
                return;
            }
            String currentTab = _mainTabbedPane.getTitleAt(selectedTab);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("state changed for pannel named '" + currentTab + "'."));
            }
            for (TabularCntrPanel tcp : _TcpMap.values()) {
                if (!currentTab.equals(tcp.getPanelName())) continue;
                _currentPanel = tcp;
                _currentPanel.tabSelected();
                break;
            }
            if (_currentPanel != null) {
                _currentPanel.setWatermark();
            }
            if (_currentPanel != null && Asemon.getCounterCollector().getMonConnection() != null && _currentPanel.getCm() != null && !_currentPanel.getCm().isDataInitialized()) {
                GetCounters.setWaitEvent("data to be initialization in the panel '" + _currentPanel.getPanelName() + "'...");
            }
        }
        if (source instanceof InMemoryCounterHandler) {
            InMemoryCounterHandler imch;
            _logger.trace((Object)"MainFrame.stateChanged().InMemoryCounterHandler");
            if (this._viewStorage_chk.isSelected()) {
                // empty if block
            }
            if ((imch = InMemoryCounterHandler.getInstance()) != null) {
                PersistContainer pcRight = imch.getRight();
                PersistContainer pcLeft = imch.getLeft();
                if (pcRight == null) {
                    return;
                }
                if (pcLeft == null) {
                    return;
                }
                int size = imch.getSize() - 1;
                this._readSlider.setMaximum(size);
                Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
                String leftStr = SimpleDateFormat.getTimeInstance().format(pcLeft.getMainSampleTime());
                String rightStr = SimpleDateFormat.getTimeInstance().format(pcRight.getMainSampleTime());
                ((Dictionary)dict).put(new Integer(0), new JLabel(leftStr));
                ((Dictionary)dict).put(new Integer(size), new JLabel(rightStr));
                this._readSlider.setLabelTable(dict);
                _logger.trace((Object)("MainFrame.stateChanged().InMemoryCounterHandler: dict = " + dict));
                int imchIndex = imch.indexOf(this._currentPc);
                if (imchIndex >= 0) {
                    int sliderIndex = this._readSlider.getValue();
                    if (sliderIndex != imchIndex) {
                        _logger.trace((Object)("MOVING: setting slider to '" + imchIndex + "', from '" + sliderIndex + "'."));
                        this._readSlider.setValue(imchIndex);
                    }
                } else {
                    _logger.trace((Object)("AGED-OUT: SETTING SLIDER TO MAX " + (imch.getSize() - 1)));
                    this._readSlider.setValue(imch.getSize() - 1);
                }
            }
        }
        if (source.equals(this._readSlider)) {
            InMemoryCounterHandler imch;
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("ReadSlider: getValueIsAdjusting=" + this._readSlider.getValueIsAdjusting() + ", value=" + this._readSlider.getValue() + ", min=" + this._readSlider.getMinimum() + ", max=" + this._readSlider.getMaximum() + ", CangeEvent=" + e));
            }
            if (this._viewStorage_chk.isSelected() && (imch = InMemoryCounterHandler.getInstance()) != null) {
                int listPos = this._readSlider.getValue();
                Timestamp ts = imch.getTs(listPos);
                this._readTsWatermark.setWatermarkText(ts == null ? "-" : ts.toString());
                if (!this._readSlider.getValueIsAdjusting()) {
                    if (this._readSelectionTimer.isRunning()) {
                        this._readSelectionTimer.restart();
                    } else {
                        this._readSelectionTimer.start();
                    }
                }
            }
        }
        if (source.equals(this._offlineSlider)) {
            int listPos;
            Timestamp ts;
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("OfflineSlider: getValueIsAdjusting=" + this._offlineSlider.getValueIsAdjusting() + ", value=" + this._offlineSlider.getValue() + ", min=" + this._offlineSlider.getMinimum() + ", max=" + this._offlineSlider.getMaximum() + ", CangeEvent=" + e));
            }
            this._offlineTsWatermark.setWatermarkText((ts = this._offlineTsList.get(listPos = this._offlineSlider.getValue())) == null ? "-" : ts.toString());
            if (!this._offlineSlider.getValueIsAdjusting() && ts != null) {
                if (this._offlineSelectionTimer.isRunning()) {
                    this._offlineSelectionTimer.restart();
                } else {
                    this._offlineSelectionTimer.start();
                }
            }
        }
        if (source instanceof PersistReader) {
            _logger.trace((Object)"MainFrame.stateChanged().PersistReader");
            PersistReader reader = PersistReader.getInstance();
            if (reader != null) {
                // empty if block
            }
        }
    }

    private void readSliderMoveToCurrentTs() {
        InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
        if (imch == null) {
            return;
        }
        int listPos = this._readSlider.getValue();
        Timestamp ts = imch.getTs(listPos);
        this._readTsWatermark.setWatermarkText(ts == null ? "-" : ts.toString());
        if (ts == null) {
            return;
        }
        PersistContainer pc = imch.get(listPos);
        if (this._currentPc != null && !this._currentPc.equals(pc)) {
            this._currentPc = pc;
            if (this._currentPc != null) {
                CountersModel summaryCm = this._currentPc.getCm("CMsummary");
                if (summaryCm != null) {
                    MainFrame.setSummaryData(summaryCm);
                }
                for (TabularCntrPanel tcp : _TcpMap.values()) {
                    CountersModel cm;
                    boolean directAccess = false;
                    if (directAccess) {
                        CountersModel cm2 = this._currentPc.getCm(tcp.getName());
                        tcp.setDisplayCm(cm2, false);
                        continue;
                    }
                    CountersModel inMemCm = this._currentPc.getCm(tcp.getName());
                    tcp.setInMemHistSampleTime(inMemCm, ts);
                    if (_mainTabbedPane.isTabUnDocked(tcp.getPanelName())) {
                        tcp.tabSelected();
                    }
                    if (_currentPanel != null) {
                        _currentPanel.tabSelected();
                    }
                    if ((cm = tcp.getCm()) == null || !cm.hasTrendGraph()) continue;
                    for (TrendGraph tg : cm.getTrendGraphs().values()) {
                        tg.setTimeLineMarker(ts);
                    }
                }
                if (summaryCm != null && summaryCm.hasTrendGraph()) {
                    for (TrendGraph tg : summaryCm.getTrendGraphs().values()) {
                        tg.setTimeLineMarker(ts);
                    }
                }
            }
        }
        this._currentPc = pc;
    }

    private void offlineSliderMoveToCurrentTs() {
        int listPos = this._offlineSlider.getValue();
        Timestamp ts = this._offlineTsList.get(listPos);
        this._offlineTsWatermark.setWatermarkText(ts == null ? "-" : ts.toString());
        if (ts == null) {
            return;
        }
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            return;
        }
        reader.setCurrentSampleTime(ts);
        reader.loadSummaryCm(ts);
        if (_offlineView != null) {
            _offlineView.setCurrentSampleTimeView(ts);
        }
        for (TabularCntrPanel tcp : _TcpMap.values()) {
            CountersModel cm;
            tcp.setOfflineSampleTime(ts);
            if (_mainTabbedPane.isTabUnDocked(tcp.getPanelName())) {
                tcp.tabSelected();
            }
            if (_currentPanel != null) {
                _currentPanel.tabSelected();
            }
            if (!(cm = tcp.getCm()).hasTrendGraph()) continue;
            for (TrendGraph tg : cm.getTrendGraphs().values()) {
                tg.setTimeLineMarker(ts);
            }
        }
        CountersModel summaryCm = GetCounters.getCmByName("CMsummary");
        if (summaryCm != null && summaryCm.hasTrendGraph()) {
            for (TrendGraph tg : summaryCm.getTrendGraphs().values()) {
                tg.setTimeLineMarker(ts);
            }
        }
    }

    private boolean isNull(String str) {
        if (str == null) {
            return true;
        }
        return str.equals("null");
    }

    public void action_connect(ActionEvent e) {
        int connType;
        Object source = e.getSource();
        String action = e.getActionCommand();
        if (Asemon.getCounterCollector().isMonConnected()) {
            SwingUtils.showInfoMessage(this, "ASE - connect", "Connection already opened, Please close the connection first...");
            return;
        }
        boolean checkAseCfg = true;
        boolean showAseTab = true;
        boolean showAseOptions = true;
        boolean showHostmonTab = true;
        boolean showPcsTab = true;
        boolean showOfflineTab = true;
        if (Asemon.hasDevVersionExpired()) {
            checkAseCfg = true;
            showAseTab = false;
            showAseOptions = true;
            showHostmonTab = false;
            showPcsTab = false;
            showOfflineTab = true;
        }
        ConnectionDialog connDialog = new ConnectionDialog(this, checkAseCfg, showAseTab, showAseOptions, showHostmonTab, showPcsTab, showOfflineTab);
        if (source instanceof GetCountersGui && showAseTab) {
            if (action != null && action.startsWith("conn.onStartup")) {
                try {
                    _logger.debug((Object)action);
                    PropPropEntry ppe = new PropPropEntry(action);
                    String key = "conn.onStartup";
                    if (!this.isNull(ppe.getProperty(key, "aseUsername"))) {
                        connDialog.setAseUsername(ppe.getProperty(key, "aseUsername"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "asePassword"))) {
                        connDialog.setAsePassword(ppe.getProperty(key, "asePassword"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "aseServer"))) {
                        connDialog.setAseServer(ppe.getProperty(key, "aseServer"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "sshUsername"))) {
                        connDialog.setSshUsername(ppe.getProperty(key, "sshUsername"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "sshPassword"))) {
                        connDialog.setSshPassword(ppe.getProperty(key, "sshPassword"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "sshHostname"))) {
                        connDialog.setSshHostname(ppe.getProperty(key, "sshHostname"));
                    }
                    if (!this.isNull(ppe.getProperty(key, "sshPort"))) {
                        connDialog.setSshPort(ppe.getProperty(key, "sshPort"));
                    }
                    connDialog.actionPerformed(new ActionEvent(this, 0, "OK"));
                }
                catch (Exception ex) {
                    _logger.warn((Object)ex.getMessage());
                }
            }
        } else {
            connDialog.setVisible(true);
            connDialog.dispose();
        }
        if ((connType = connDialog.getConnectionType()) == 0) {
            return;
        }
        if (connType == 1) {
            if (Asemon.hasDevVersionExpired()) {
                throw new RuntimeException("AseMon DEV Version has expired, can't connect to a ASE. only 'PCS - Read mode' is available.");
            }
            Asemon.getCounterCollector().setMonConnection(connDialog.getAseConn());
            Asemon.getCounterCollector().setHostMonConnection(connDialog.getSshConn());
            if (Asemon.getCounterCollector().isMonConnected()) {
                AseConfig aseCfg;
                MainFrame.setStatus(1);
                if (!MonTablesDictionary.getInstance().isInitialized()) {
                    MonTablesDictionary.getInstance().initialize(Asemon.getCounterCollector().getMonConnection(), true);
                    GetCounters.initExtraMonTablesDictionary();
                }
                if (!(aseCfg = AseConfig.getInstance()).isInitialized()) {
                    aseCfg.initialize(Asemon.getCounterCollector().getMonConnection(), true, false, null);
                }
                AseConfigText.initializeAll(Asemon.getCounterCollector().getMonConnection(), true, false, null);
                GetCounters getCnt = Asemon.getCounterCollector();
                if (getCnt != null) {
                    getCnt.enableRefresh();
                }
                CheckForUpdates.sendConnectInfoNoBlock();
            }
        }
        if (connType == 2) {
            _summaryPanel.setLocalServerName("Offline-read");
            MainFrame.setStatus(2);
            this.setOfflineMenuMode();
            MainFrame.setOfflineConnection(connDialog.getOfflineConn());
            if (MainFrame.getOfflineConnection() != null) {
                if (!PersistReader.hasInstance()) {
                    PersistReader reader = new PersistReader(MainFrame.getOfflineConnection());
                    PersistReader.setInstance(reader);
                }
                MainFrame.openOfflineSessionView(true);
                MonTablesDictionary.getInstance().initializeMonTabColHelper(MainFrame.getOfflineConnection(), true);
                GetCounters.initExtraMonTablesDictionary();
                AseConfig.getInstance().initialize(MainFrame.getOfflineConnection(), true, true, null);
                AseConfigText.initializeAll(MainFrame.getOfflineConnection(), true, true, null);
            }
        }
    }

    private void action_disconnect(ActionEvent e) {
        AseConnectionFactory.reset();
        MainFrame.terminateConnection();
        if (PersistentCounterHandler.hasInstance()) {
            PersistentCounterHandler.getInstance().stop();
        }
        if (PersistReader.hasInstance()) {
            PersistReader.getInstance().shutdown();
            PersistReader.setInstance(null);
        }
        AseConfig.reset();
        AseConfigText.reset();
    }

    private void action_exit(ActionEvent e) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void action_toggleAutoResizePcTables(ActionEvent e) {
        this.saveProps();
    }

    private void action_refreshRate(ActionEvent e) {
        String key1 = "Refresh Rate";
        LinkedHashMap<String, String> in = new LinkedHashMap<String, String>();
        in.put(key1, Integer.toString(_refreshInterval));
        Map<String, String> results = ParameterDialog.showParameterDialog(this, "Refresh Interval", in, false);
        if (results != null) {
            _refreshInterval = Integer.parseInt(results.get(key1));
            this.saveProps();
        }
    }

    private void action_counterTabView(ActionEvent e) {
        int ret = GTabbedPaneViewDialog.showDialog(this, _mainTabbedPane);
        if (ret == 0) {
            // empty if block
        }
    }

    private void action_openGraphViewDialog(ActionEvent e) {
        int ret = TrendGraphPanelReorderDialog.showDialog(this, SummaryPanel.getInstance().getGraphPanel());
        if (ret == 0) {
            // empty if block
        }
    }

    private void action_about(ActionEvent e) {
        AboutBox dlg = new AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    public Timestamp getCurrentSliderTs() {
        InMemoryCounterHandler imch;
        if (this._offlineSlider.isVisible()) {
            int listPos = this._offlineSlider.getValue();
            return this._offlineTsList.get(listPos);
        }
        if (this._readSlider.isVisible() && (imch = InMemoryCounterHandler.getInstance()) != null) {
            int listPos = this._readSlider.getValue();
            return imch.getTs(listPos);
        }
        return null;
    }

    public void resetOfflineSlider() {
        this._offlineTsList = new ArrayList<Timestamp>();
    }

    public void addOfflineSliderEntry(Timestamp ts) {
        this._offlineTsList.add(ts);
        int size = this._offlineTsList.size() - 1;
        this._offlineSlider.setMaximum(size);
        Timestamp left = this._offlineTsList.get(0);
        Timestamp right = this._offlineTsList.get(size);
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        String leftStr = SimpleDateFormat.getTimeInstance().format(left);
        String rightStr = SimpleDateFormat.getTimeInstance().format(right);
        ((Dictionary)dict).put(new Integer(0), new JLabel(leftStr));
        ((Dictionary)dict).put(new Integer(size), new JLabel(rightStr));
        this._offlineSlider.setLabelTable(dict);
        this._offlineSlider.setVisible(true);
    }

    public void addOfflineSliderEntryList(List<Timestamp> list) {
        this._offlineTsList = list == null ? new ArrayList<Timestamp>(1) : list;
        int size = this._offlineTsList.size() - 1;
        this._offlineSlider.setMaximum(size);
        Timestamp left = this._offlineTsList.get(0);
        Timestamp right = this._offlineTsList.get(size);
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        String leftStr = SimpleDateFormat.getTimeInstance().format(left);
        String rightStr = SimpleDateFormat.getTimeInstance().format(right);
        ((Dictionary)dict).put(new Integer(0), new JLabel(leftStr));
        ((Dictionary)dict).put(new Integer(size), new JLabel(rightStr));
        this._offlineSlider.setLabelTable(dict);
        this._offlineSlider.setVisible(true);
    }

    public void setTimeLinePoint(long time) {
        this.setTimeLinePoint(new Timestamp(time));
    }

    public void setTimeLinePoint(Timestamp ts) {
        if (!this._viewStorage_chk.isSelected()) {
            this._viewStorage_chk.doClick();
        }
        if (MainFrame.isOfflineConnected()) {
            if (this._offlineTsList == null) {
                return;
            }
            int sliderPos = -1;
            Timestamp smallerTs = null;
            Timestamp largerTs = null;
            for (int i = 0; i < this._offlineTsList.size(); ++i) {
                long b;
                Timestamp indexTs = this._offlineTsList.get(i);
                if (indexTs == null) continue;
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("CHECK ts='" + ts + "', indexTs='" + indexTs + "'."));
                }
                if (i == 0 && ts.before(indexTs)) {
                    sliderPos = i;
                    if (!_logger.isTraceEnabled()) break;
                    _logger.trace((Object)("--->>> TS is SMALLER than first index entry: sliderPos='" + sliderPos + "', ts='" + ts + "', indexTs='" + indexTs + "'."));
                    break;
                }
                if (ts.equals(indexTs)) {
                    sliderPos = i;
                    if (!_logger.isTraceEnabled()) break;
                    _logger.trace((Object)("--->>> FOUND EXACT MATCH: ts='" + ts + "', indexTs='" + indexTs + "'."));
                    break;
                }
                if (indexTs.before(ts)) {
                    sliderPos = i;
                    smallerTs = indexTs;
                } else if (largerTs == null) {
                    largerTs = indexTs;
                }
                if (smallerTs == null || largerTs == null) continue;
                long a = ts.getTime() - smallerTs.getTime();
                Timestamp closeEnough = a < (b = largerTs.getTime() - ts.getTime()) ? smallerTs : largerTs;
                sliderPos = this._offlineTsList.indexOf(closeEnough);
                if (!_logger.isTraceEnabled()) break;
                _logger.trace((Object)("--->>> CLOSE ENOUGH: ts='" + ts + "', indexTs='" + indexTs + "', sliderPos='" + sliderPos + "', closeEnough='" + closeEnough + "', smallerTs='" + smallerTs + "', largerTs='" + largerTs + "', a='" + a + "', b='" + b + "'."));
                break;
            }
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("_offlineSlider.setValue(" + sliderPos + "); and NOTIFY LISTENERS"));
            }
            if (sliderPos >= 0) {
                this._offlineSlider.setValue(sliderPos);
            }
        } else {
            InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
            if (imch != null) {
                _logger.trace((Object)("MainFrame.setTimeLinePoint(): Ts=" + ts));
                int index = imch.indexOf(ts);
                if (index >= 0) {
                    int sliderPos = index;
                    _logger.trace((Object)("MainFrame.setTimeLinePoint(): index=" + index + ", sliderPos=" + sliderPos));
                    this._readSlider.setValue(sliderPos);
                }
            }
        }
    }

    public static void terminateConnection() {
        _logger.info((Object)"Starting a thread that will do disconnect after this sample session is finnished.");
        Thread terminateConnectionTask = new Thread(){

            @Override
            public void run() {
                GetCounters getCnt = Asemon.getCounterCollector();
                if (getCnt != null) {
                    getCnt.disableRefresh();
                    while (true) {
                        if (!getCnt.isRefreshingCounters()) {
                            _logger.info((Object)"Clearing components...");
                            getCnt.clearComponents();
                            break;
                        }
                        _logger.info((Object)"Waiting for GetCounters to stop before I can: Clearing components...");
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                }
                for (CountersModel cm : GetCounters.getCmList()) {
                    cm.close();
                }
                Asemon.getCounterCollector().closeMonConnection();
                Asemon.getCounterCollector().closeHostMonConnection();
                MainFrame.closeOfflineConnection();
                if (_offlineView != null) {
                    _offlineView.setVisible(false);
                    _offlineView.dispose();
                    _offlineView = null;
                }
                MainFrame.setStatus(3);
                _logger.info((Object)"The disconnect thread is ending.");
            }
        };
        terminateConnectionTask.setName("terminateConnectionTask");
        terminateConnectionTask.setDaemon(true);
        terminateConnectionTask.start();
    }

    public static void addTcp(TabularCntrPanel tcp) {
        if (!Asemon.hasGUI()) {
            return;
        }
        _mainTabbedPane.addTab(tcp.getPanelName(), tcp.getIcon(), tcp, tcp.getCm().getDescription());
        _TcpMap.put(tcp.getPanelName(), tcp);
    }

    public static JTabbedPane getTabbedPane() {
        if (!Asemon.hasGUI()) {
            return null;
        }
        return _mainTabbedPane;
    }

    public static void addGraphViewMenu(JMenuItem mi) {
        _graphs_m.add(mi);
    }

    public void setBlockingLocks(boolean visible, int blockCount) {
        if (blockCount > 0) {
            this._blockAlert_but.setText(blockCount + " Blocked SPID's, ");
        } else {
            this._blockAlert_but.setText(ST_DEFAULT_STATUS2_FIELD);
        }
        this._blockAlert_but.setVisible(visible);
    }

    public void setFullTransactionLog(boolean visible, int fullCount) {
        if (fullCount > 0) {
            this._fullTranlogAlert_but.setText(fullCount + " DB Log(s) are full, ");
        } else {
            this._fullTranlogAlert_but.setText(ST_DEFAULT_STATUS2_FIELD);
        }
        this._fullTranlogAlert_but.setVisible(visible);
    }

    public JMenu createPredefinedSqlMenu() {
        _logger.debug((Object)"createPredefinedSqlMenu(): called.");
        JMenu menu = new JMenu("Predefined SQL Statements");
        menu.setIcon(SwingUtils.readImageIcon(Version.class, "images/pre_defined_sql_statement.png"));
        Configuration systmp = new Configuration();
        systmp.setProperty("system.predefined.sql.01.name", "List unused indexes in all databases.");
        systmp.setProperty("system.predefined.sql.01.execute", "exec sp_list_unused_indexes");
        systmp.setProperty("system.predefined.sql.01.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.01.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.01.install.procName", "sp_list_unused_indexes");
        systmp.setProperty("system.predefined.sql.01.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.01.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.01.install.scriptName", "sp_list_unused_indexes.sql");
        systmp.setProperty("system.predefined.sql.01.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.02.name", "sp_whoisw - Who Is Working (list SPID's that are doing stuff).");
        systmp.setProperty("system.predefined.sql.02.execute", "exec sp_whoisw");
        systmp.setProperty("system.predefined.sql.02.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.02.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.02.install.procName", "sp_whoisw");
        systmp.setProperty("system.predefined.sql.02.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.02.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.02.install.scriptName", "sp_whoisw.sql");
        systmp.setProperty("system.predefined.sql.02.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.03.name", "sp_whoisb - Who Is Blocking (list info about SPID's taht are blocking other SPID's from running).");
        systmp.setProperty("system.predefined.sql.03.execute", "exec sp_whoisb");
        systmp.setProperty("system.predefined.sql.03.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.03.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.03.install.procName", "sp_whoisb");
        systmp.setProperty("system.predefined.sql.03.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.03.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.03.install.scriptName", "sp_whoisb.sql");
        systmp.setProperty("system.predefined.sql.03.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.04.name", "sp_opentran - List information about the SPID that is holding the oldest open transaction (using syslogshold).");
        systmp.setProperty("system.predefined.sql.04.execute", "exec sp_opentran");
        systmp.setProperty("system.predefined.sql.04.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.04.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.04.install.procName", "sp_opentran");
        systmp.setProperty("system.predefined.sql.04.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.04.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.04.install.scriptName", "sp_opentran.sql");
        systmp.setProperty("system.predefined.sql.04.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.05.name", "sp_lock2 - More or less the same as sp_lock, but uses 'table name' instead of 'table id'.");
        systmp.setProperty("system.predefined.sql.05.execute", "exec sp_lock2");
        systmp.setProperty("system.predefined.sql.05.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.05.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.05.install.procName", "sp_lock2");
        systmp.setProperty("system.predefined.sql.05.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.05.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.05.install.scriptName", "sp_lock2.sql");
        systmp.setProperty("system.predefined.sql.05.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.06.name", "sp_locksum - Prints number of locks each SPID has.");
        systmp.setProperty("system.predefined.sql.06.execute", "exec sp_locksum");
        systmp.setProperty("system.predefined.sql.06.install.needsVersion", "0");
        systmp.setProperty("system.predefined.sql.06.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.06.install.procName", "sp_locksum");
        systmp.setProperty("system.predefined.sql.06.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.06.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.06.install.scriptName", "ssp_locksum.sqlp_.sql");
        systmp.setProperty("system.predefined.sql.06.install.needsRole", "sa_role");
        systmp.setProperty("system.predefined.sql.07.name", "sp_spaceused2 - List space and row used by each table in the current database");
        systmp.setProperty("system.predefined.sql.07.execute", "exec sp_spaceused2");
        systmp.setProperty("system.predefined.sql.07.install.needsVersion", "15000");
        systmp.setProperty("system.predefined.sql.07.install.dbname", "sybsystemprocs");
        systmp.setProperty("system.predefined.sql.07.install.procName", "sp_spaceused2");
        systmp.setProperty("system.predefined.sql.07.install.procDateThreshold", "2011-04-14");
        systmp.setProperty("system.predefined.sql.07.install.scriptLocation", VersionInfo.class.getName());
        systmp.setProperty("system.predefined.sql.07.install.scriptName", "sp_spaceused2.sql");
        systmp.setProperty("system.predefined.sql.07.install.needsRole", "sa_role");
        MainFrame.createPredefinedSqlMenu(menu, "system.predefined.sql.", systmp);
        MainFrame.createPredefinedSqlMenu(menu, "user.predefined.sql.", null);
        if (menu.getMenuComponentCount() == 0) {
            _logger.warn((Object)("No Menuitems has been assigned for the '" + menu.getText() + "'."));
            return null;
        }
        return menu;
    }

    private static JMenu createPredefinedSqlMenu(JMenu menu, String prefix, Configuration conf) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cant be null.");
        }
        if (prefix.trim().equals(ST_DEFAULT_STATUS2_FIELD)) {
            throw new IllegalArgumentException("prefix cant be empty.");
        }
        if (!(prefix = prefix.trim()).endsWith(".")) {
            prefix = prefix + ".";
        }
        if (conf == null) {
            conf = Configuration.getCombinedConfiguration();
        }
        _logger.debug((Object)("createMenu(): prefix='" + prefix + "'."));
        if (menu == null) {
            menu = new JMenu();
        }
        boolean firstAdd = true;
        for (String prefixStr : conf.getUniqueSubKeys(prefix, true)) {
            _logger.debug((Object)("createPredefinedSqlMenu(): found prefix '" + prefixStr + "'."));
            String menuItemName = conf.getProperty(prefixStr + ".name");
            final String sqlStr = conf.getProperty(prefixStr + ".execute");
            final int needsVersion = conf.getIntProperty(prefixStr + ".install.needsVersion", 0);
            final String dbname = conf.getProperty(prefixStr + ".install.dbname");
            final String procName = conf.getProperty(prefixStr + ".install.procName");
            String procDateThreshStr = conf.getProperty(prefixStr + ".install.procDateThreshold");
            String scriptLocationStr = conf.getProperty(prefixStr + ".install.scriptLocation");
            final String scriptName = conf.getProperty(prefixStr + ".install.scriptName");
            final String needsRole = conf.getProperty(prefixStr + ".install.needsRole");
            if (menuItemName == null) {
                _logger.warn((Object)("Missing property '" + prefixStr + ".name'"));
                continue;
            }
            if (sqlStr == null) {
                _logger.warn((Object)("Missing property '" + prefixStr + ".execute'"));
                continue;
            }
            boolean tmpDoCheckCreate = false;
            if (dbname != null) {
                tmpDoCheckCreate = true;
                String missing = ST_DEFAULT_STATUS2_FIELD;
                if (procName == null) {
                    missing = missing + prefixStr + ".install.procName, ";
                }
                if (procDateThreshStr == null) {
                    missing = missing + prefixStr + ".install.procDateThreshold, ";
                }
                if (scriptName == null) {
                    missing = missing + prefixStr + ".install.scriptName, ";
                }
                if (!missing.equals(ST_DEFAULT_STATUS2_FIELD)) {
                    _logger.warn((Object)("Missing property '" + missing + "'."));
                    continue;
                }
            }
            final boolean doCheckCreate = tmpDoCheckCreate;
            Class<?> tmpScriptLocation = null;
            if (scriptLocationStr != null) {
                try {
                    tmpScriptLocation = Class.forName(scriptLocationStr);
                }
                catch (ClassNotFoundException e) {
                    _logger.warn((Object)("Property " + prefixStr + ".install.scriptLocation, contained '" + scriptLocationStr + "', the class can't be loaded. This should be a classname in asemon.jar, If it's a path name you want to specify, please use the property '" + prefixStr + ".install.scriptName' instead."));
                    continue;
                }
            }
            final Class<?> scriptLocation = tmpScriptLocation;
            Date tmpProcDateThreshold = null;
            if (procDateThreshStr != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    tmpProcDateThreshold = sdf.parse(procDateThreshStr);
                }
                catch (ParseException e) {
                    _logger.warn((Object)("Property " + prefixStr + ".install.procDateThreshold, contained '" + procDateThreshStr + "', Problems parsing the string, it should look like 'yyyy-MM-dd'."));
                    continue;
                }
            }
            final Date procDateThreshold = tmpProcDateThreshold;
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Connection conn = null;
                    try {
                        if (!Asemon.getCounterCollector().isMonConnected(true, true)) {
                            SwingUtils.showInfoMessage(MainFrame.getInstance(), "Not connected", "Not yet connected to a server.");
                            return;
                        }
                        conn = AseConnectionFactory.getConnection(null, "asemon-PreDefinedSql", null);
                        if (doCheckCreate) {
                            AseConnectionUtils.checkCreateStoredProc(conn, needsVersion, dbname, procName, procDateThreshold, scriptLocation, scriptName, needsRole);
                        }
                        QueryWindow qf = new QueryWindow(conn, sqlStr, true, QueryWindow.WindowType.JFRAME);
                        qf.openTheWindow();
                    }
                    catch (Throwable t) {
                        String msg = "Problems when checking/creating the procedure";
                        if (conn == null) {
                            msg = "Problems when getting a database connection";
                        }
                        SwingUtils.showErrorMessage("Problems executing Predefined SQL statement", msg + "\n\n" + t.getMessage(), t);
                    }
                }
            };
            JMenuItem menuItem = new JMenuItem(menuItemName);
            menuItem.addActionListener(action);
            if (firstAdd) {
                firstAdd = false;
                if (menu.getMenuComponentCount() > 0) {
                    menu.addSeparator();
                }
            }
            menu.add(menuItem);
        }
        return menu;
    }

    public static boolean isOfflineConnected() {
        if (_offlineConn == null) {
            return false;
        }
        long diff = System.currentTimeMillis() - _lastOfflineIsClosedCheck;
        if (diff < _lastOfflineIsClosedRefreshTime) {
            return true;
        }
        try {
            if (_offlineConn.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        _lastOfflineIsClosedCheck = System.currentTimeMillis();
        return true;
    }

    public static void setOfflineConnection(Connection conn) {
        _offlineConn = conn;
    }

    public static Connection getOfflineConnection() {
        return _offlineConn;
    }

    public static void closeOfflineConnection() {
        try {
            if (MainFrame.isOfflineConnected()) {
                _offlineConn.close();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Offline connection closed");
                }
            }
        }
        catch (SQLException ev) {
            _logger.error((Object)"Closing Offline connection", (Throwable)ev);
        }
        _offlineConn = null;
    }

    public static Component getActiveTab() {
        return _mainTabbedPane.getSelectedComponent();
    }

    public static void clearSummaryData() {
        _summaryPanel.clearSummaryData();
    }

    public static void setSummaryData(CountersModel cm) {
        _summaryPanel.setSummaryData(cm);
    }

    public static SummaryPanel getSummaryPanel() {
        return _summaryPanel;
    }

    public static void setOfflineSamplePeriodText(String str) {
        _offlineSamplePeriod = str;
    }

    public static String getOfflineSamplePeriodText() {
        return _offlineSamplePeriod;
    }

    public static String getStatus(int type) {
        if (type == 1) {
            return _statusServerName.getText();
        }
        if (type == 2) {
            return "off-line-connect";
        }
        if (type == 3) {
            return _statusServerName.getText();
        }
        if (type == 4) {
            return _statusStatus.getText();
        }
        if (type == 5) {
            return _statusStatus2.getText();
        }
        if (type == 6) {
            return _statusMemory.getText();
        }
        return ST_DEFAULT_STATUS2_FIELD;
    }

    public static void setStatus(int type) {
        MainFrame.setStatus(type, null);
    }

    public static void setStatus(int type, String param) {
        if (type == 2) {
            if (MainFrame.isOfflineConnected()) {
                _statusStatus.setText("Offline...");
                _statusStatus2.setText(ST_DEFAULT_STATUS2_FIELD);
                _statusServerName.setText("Offline-read");
                _statusServerListeners.setText("Offline-read");
                _summaryPanel.setLocalServerName("Offline-read");
                SummaryPanel.getInstance().setWatermark();
            } else {
                type = 3;
            }
        } else if (type == 1) {
            if (Asemon.getCounterCollector().isMonConnected()) {
                _statusStatus.setText("Just Connected...");
                _statusStatus2.setText(ST_DEFAULT_STATUS2_FIELD);
                _statusServerName.setText(AseConnectionFactory.getServer() + " (" + AseConnectionFactory.getHostPortStr() + ")");
                Connection conn = Asemon.getCounterCollector().getMonConnection();
                if (AseConnectionUtils.hasRole(conn, "sa_role")) {
                    _statusServerListeners.setText(AseConnectionUtils.getListeners(conn, true, true, _instance));
                } else {
                    _statusServerListeners.setText("Need 'sa_role' to get listeners.");
                }
                _summaryPanel.setLocalServerName(_statusServerName.getText());
                SummaryPanel.getInstance().setWatermark();
            } else {
                type = 3;
            }
        }
        if (type == 3) {
            _statusServerName.setText(ST_DEFAULT_SERVER_NAME);
            _statusServerListeners.setText(ST_DEFAULT_SERVER_LISTENERS);
            _statusStatus.setText(ST_DEFAULT_STATUS_FIELD);
            _statusStatus2.setText(ST_DEFAULT_STATUS2_FIELD);
            _summaryPanel.setLocalServerName(ST_DEFAULT_STATUS2_FIELD);
            SummaryPanel.getInstance().setWatermark();
            for (TabularCntrPanel tcp : _TcpMap.values()) {
                tcp.setWatermark();
            }
        }
        if (type == 4) {
            _statusStatus.setText(param);
        }
        if (type == 5) {
            _statusStatus2.setText(param);
        }
        if (type == 6) {
            _statusMemory.setText("Memory: Used " + Memory.getUsedMemoryInMB() + " MB, Free " + Memory.getMemoryLeftInMB() + " MB");
        }
    }

    public static void openLogViewer() {
        if (_logView == null) {
            _logView = new Log4jViewer(_instance);
        }
        _logView.setVisible(true);
    }

    public static void openOfflineSessionView(boolean doSetVisible) {
        if (_offlineView == null) {
            _offlineView = new OfflineSessionVeiwer(MainFrame.getInstance());
            PersistReader reader = PersistReader.getInstance();
            if (reader != null) {
                reader.addNotificationListener(_offlineView);
            }
            doSetVisible = true;
        }
        if (doSetVisible) {
            _offlineView.setVisible(true);
        }
    }

    public static String getUserDefinedToolTip(String cmName, String colName) {
        String sql = _udTooltipMap.get(cmName + "." + colName);
        if (sql == null) {
            sql = _udTooltipMap.get(colName);
        }
        if (sql == null && "SPID".equalsIgnoreCase(colName)) {
            sql = "select  MP.SPID,  MP.Login,  MP.DBName,  MP.Application,  MP.Command,  MP.SecondsWaiting,  MP.SecondsConnected ,  MP.WaitEventID,  WaitEventDescription = (select W.Description from monWaitEventInfo W where W.WaitEventID = MP.WaitEventID),  MP.BlockingSPID,  procname = (select object_name(sp.id,sp.dbid) from master..sysprocesses sp where sp.spid = MP.SPID),  MP.BatchID,  MP.LineNumber,  MP.BlockingXLOID,  MP.MasterTransactionID from monProcess MP  where MP.SPID = ? ";
        }
        return sql;
    }

    public static boolean isSamplingPaused() {
        return _isSamplingPaused;
    }

    public static boolean isInMemoryViewOn() {
        return MainFrame._instance._viewStorage_chk.isSelected();
    }

    public void loadTabOrderAndVisibility() {
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        String orderAndVisibility = tmpConf.getProperty("main.tab.orderAndVisibility");
        if (orderAndVisibility != null) {
            _logger.info((Object)("Loading TabbedPane 'Tab Titles' order and visibility using property 'main.tab.orderAndVisibility', which looks like '" + orderAndVisibility + "'."));
            _logger.info((Object)("To change/remove the sorting use the menu 'Counter Tab View'. OR to get rid of this sorting simply delete the entry 'main.tab.orderAndVisibility' in the file '" + tmpConf.getFilename() + "'."));
            _mainTabbedPane.setTabOrderAndVisibility(orderAndVisibility);
        }
    }

    @Override
    public void saveTabOrderAndVisibility(String tabOptions) {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        if (tmpConf != null) {
            _logger.info((Object)("Saving TabbedPane 'Tab Titles' order and visibility using property 'main.tab.orderAndVisibility', which looks like '" + tabOptions + "'."));
            tmpConf.setProperty("main.tab.orderAndVisibility", tabOptions);
            tmpConf.save();
        }
    }

    @Override
    public void removeTabOrderAndVisibility() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        _logger.info((Object)("Removing the ordering and visibility entry 'main.tab.orderAndVisibility' in the file '" + tmpConf.getFilename() + "'."));
        tmpConf.remove("main.tab.orderAndVisibility");
        tmpConf.save();
    }

    private void saveTcpProps() {
        for (TabularCntrPanel tcp : _TcpMap.values()) {
            tcp.saveProps();
        }
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        tmpConf.setProperty("main.refresh.interval", _refreshInterval);
        tmpConf.setProperty("nogui.sleepTime", _refreshNoGuiInterval);
        tmpConf.setProperty("TabularCntrPanel.autoAdjustTableColumnWidth", this._autoResizePcTable_mi.isSelected());
        tmpConf.setProperty("window.width", this.getSize().width);
        tmpConf.setProperty("window.height", this.getSize().height);
        if (this.isVisible()) {
            tmpConf.setProperty("window.pos.x", this.getLocationOnScreen().x);
            tmpConf.setProperty("window.pos.y", this.getLocationOnScreen().y);
        }
        MainFrame.getSummaryPanel().saveLayoutProps();
        tmpConf.save();
    }

    private void loadProps() {
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        int width = tmpConf.getIntProperty("window.width", 1000);
        int height = tmpConf.getIntProperty("window.height", 700);
        int winPosX = tmpConf.getIntProperty("window.pos.x", -1);
        int winPosY = tmpConf.getIntProperty("window.pos.y", -1);
        this.setSize(width, height);
        if (winPosX == -1 && winPosY == -1) {
            _logger.debug((Object)"Open main window in center of screen.");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        } else {
            _logger.debug((Object)"Open main window in last known position.");
            this.setLocation(winPosX, winPosY);
        }
        _refreshInterval = tmpConf.getIntProperty("main.refresh.interval", _refreshInterval);
        _refreshNoGuiInterval = tmpConf.getIntProperty("nogui.sleepTime", _refreshNoGuiInterval);
        boolean bool = tmpConf.getBooleanProperty("TabularCntrPanel.autoAdjustTableColumnWidth", this._autoResizePcTable_mi.isSelected());
        this._autoResizePcTable_mi.setSelected(bool);
    }

    static {
        Configuration conf = Configuration.getCombinedConfiguration();
        if (conf != null) {
            // empty if block
        }
        String prefix = "table.tooltip.";
        for (String key : conf.getKeys(prefix)) {
            String val = conf.getProperty(key);
            String name = key.substring(prefix.length());
            _logger.debug((Object)("Adding UD Cell Tooltip for colName='" + name + "', SQL='" + val + "'."));
            _udTooltipMap.put(name, val);
        }
    }

    private class OfflineSelectionTimerAction
    implements ActionListener {
        private MainFrame _mainframe = null;

        OfflineSelectionTimerAction(MainFrame mf) {
            this._mainframe = mf;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            this._mainframe.offlineSliderMoveToCurrentTs();
            this._mainframe._offlineSelectionTimer.stop();
        }
    }

    private class ReadSelectionTimerAction
    implements ActionListener {
        private MainFrame _mainframe = null;

        ReadSelectionTimerAction(MainFrame mf) {
            this._mainframe = mf;
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            this._mainframe.readSliderMoveToCurrentTs();
            this._mainframe._readSelectionTimer.stop();
        }
    }

    private class ReadTsWatermark
    extends AbstractComponentDecorator {
        private String _text;
        private Graphics2D g;
        private Rectangle r;
        private JLabel lbl;

        public ReadTsWatermark(JComponent target, String text) {
            super(target);
            this._text = MainFrame.ST_DEFAULT_STATUS2_FIELD;
            this.g = null;
            this.r = null;
            this.lbl = new JLabel();
            if (text != null) {
                this._text = text;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._text == null || this._text != null && this._text.equals(MainFrame.ST_DEFAULT_STATUS2_FIELD)) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g.setFont(this.lbl.getFont());
            FontMetrics fm = this.g.getFontMetrics();
            int strWidth = fm.stringWidth(this._text);
            int xPos = (this.r.width - strWidth) / 2;
            int yPos = this.r.height - 5;
            this.g.drawString(this._text, xPos, yPos);
        }

        public void setWatermarkText(String text) {
            this._text = text;
            _logger.debug((Object)("setWatermarkText: to '" + this._text + "'."));
            this.repaint();
        }
    }
}

