/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.GetCounters;
import asemon.cm.CountersModel;
import asemon.pcs.PersistReader;
import asemon.utils.StringUtil;
import asemon.utils.TimeUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class OfflineSessionModel
extends AbstractTreeTableModel {
    private static Logger _logger = Logger.getLogger(OfflineSessionModel.class);
    private ArrayList<SessionLevel> _sessions = new ArrayList();
    private int _dayLevelCount = 1;
    private int _hourLevelCount = 1;
    private int _minuteLevelCount = 10;
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private boolean _showCmCounterInfoColumns = false;
    private List<String> _cmShortNameSumCols = new ArrayList<String>();
    private List<String> _cmLongNameSumCols = new ArrayList<String>();
    private Map<Timestamp, PersistReader.SampleCmCounterInfo> _xxx_sampleCmCounterInfoMap = null;

    public OfflineSessionModel(boolean showCmCounterInfoColumns) {
        this._showCmCounterInfoColumns = showCmCounterInfoColumns;
    }

    private void printTree() {
        for (SessionLevel session : this._sessions) {
            System.out.println("-> " + session.toString());
            this.printTree(session, 1);
        }
    }

    private void printTree(SessionLevel sl, int incCount) {
        for (int i = 0; i < sl.getChildCount(); ++i) {
            Object o = sl.getChild(i);
            if (!(o instanceof SessionLevel)) continue;
            SessionLevel child = (SessionLevel)o;
            System.out.println(StringUtil.replicate(" +", incCount) + " > " + child.toString());
            if (child.getChildCount() <= 0) continue;
            this.printTree(child, incCount + 1);
        }
    }

    public List<Object> getObjectPathForSampleTime(Timestamp ts) {
        ArrayList<Object> objectPath = new ArrayList<Object>();
        for (SessionLevel sl : this._sessions) {
            if (ts.getTime() < sl._startTime.getTime() || ts.getTime() > sl._endTime.getTime()) continue;
            _logger.debug((Object)("#### FOUND: " + sl));
            this.getObjectPathForSampleTime(objectPath, sl, ts);
        }
        return objectPath;
    }

    private void getObjectPathForSampleTime(ArrayList<Object> objectPath, SessionLevel sl, Timestamp ts) {
        for (int i = 0; i < sl.getChildCount(); ++i) {
            Timestamp sampleTime;
            Object o = sl.getChild(i);
            if (o instanceof SessionLevel) {
                SessionLevel child = (SessionLevel)o;
                if (ts.getTime() < child._startTime.getTime() || ts.getTime() > child._endTime.getTime() || child.getChildCount() <= 0) continue;
                _logger.debug((Object)(" >>> FOUND: " + child));
                objectPath.add(child);
                this.getObjectPathForSampleTime(objectPath, child, ts);
                continue;
            }
            if (!(o instanceof Timestamp) || (sampleTime = (Timestamp)o).getTime() != ts.getTime()) continue;
            _logger.debug((Object)("  == FOUND: " + ts));
            objectPath.add(sampleTime);
        }
    }

    public void setDayLevelCount(int count) {
        this._dayLevelCount = count;
    }

    public void setHourLevelCount(int count) {
        this._hourLevelCount = count;
    }

    public void setMinuteLevelCount(int count) {
        this._minuteLevelCount = count;
    }

    public int getDayLevelCount() {
        return this._dayLevelCount;
    }

    public int getHourLevelCount() {
        return this._hourLevelCount;
    }

    public int getMinuteLevelCount() {
        return this._minuteLevelCount;
    }

    private void addCmNameSumCols(Map<String, PersistReader.CmNameSum> cmNameSumMap) {
        for (String cmName : cmNameSumMap.keySet()) {
            if (this._cmShortNameSumCols.contains(cmName)) continue;
            this._cmShortNameSumCols.add(cmName);
        }
    }

    private void fixCmNameSumColsOrder() {
        ArrayList<String> spillList = new ArrayList<String>(this._cmShortNameSumCols);
        ArrayList<String> new_cmShortNameSumCols = new ArrayList<String>();
        ArrayList<String> new_cmLongNameSumCols = new ArrayList<String>();
        for (CountersModel cm : GetCounters.getCmList()) {
            String shortCmName = cm.getName();
            String longCmName = cm.getDisplayName();
            if (!spillList.contains(shortCmName)) continue;
            spillList.remove(shortCmName);
            new_cmShortNameSumCols.add(shortCmName);
            new_cmLongNameSumCols.add(longCmName);
        }
        for (String spill : spillList) {
            new_cmShortNameSumCols.add(spill);
            new_cmLongNameSumCols.add(spill);
        }
        this._cmShortNameSumCols = new_cmShortNameSumCols;
        this._cmLongNameSumCols = new_cmLongNameSumCols;
    }

    public void init(List<PersistReader.SessionInfo> sessionList) {
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        if (sessionList == null) {
            sessionList = reader.getSessionList();
        }
        for (PersistReader.SessionInfo sessionInfo : sessionList) {
            Map<String, PersistReader.CmNameSum> sessionSamplesCmNameSumMap;
            SessionLevel sessionLevel = new SessionLevel(sessionInfo._sessionId, sessionInfo._sessionId, sessionInfo._lastSampleTime, sessionInfo._numOfSamples);
            this._sessions.add(sessionLevel);
            List<Timestamp> sessionSamples = sessionInfo._sampleList;
            Map<Timestamp, PersistReader.SampleCmCounterInfo> sampleCmCounterInfoMap = sessionInfo._sampleCmCounterInfoMap;
            if (sessionSamples == null) {
                sessionSamples = reader.getSessionSamplesList(sessionInfo._sessionId);
            }
            if (this._showCmCounterInfoColumns && sampleCmCounterInfoMap == null) {
                sampleCmCounterInfoMap = reader.getSessionSampleCmCounterInfoMap(sessionInfo._sessionId);
            }
            this._xxx_sampleCmCounterInfoMap = sampleCmCounterInfoMap;
            if (sessionSamples != null && sessionSamples.size() > 0) {
                sessionLevel.addAllSamples(sessionSamples);
                sessionLevel.makeBabies();
            }
            if ((sessionSamplesCmNameSumMap = sessionInfo._sampleCmNameSumMap) == null) {
                sessionSamplesCmNameSumMap = reader.getSessionSampleCmNameSumMap(sessionInfo._sessionId);
            }
            if (sessionSamplesCmNameSumMap == null) continue;
            this.addCmNameSumCols(sessionSamplesCmNameSumMap);
        }
        this.fixCmNameSumColsOrder();
        if (_logger.isDebugEnabled()) {
            this.printTree();
        }
    }

    public Object getChild(Object parent, int index) {
        _logger.debug((Object)("getChildCount(parent='" + parent + "', index='" + index + "')"));
        if (parent instanceof List) {
            return this._sessions.get(index);
        }
        if (parent instanceof SessionLevel) {
            return ((SessionLevel)parent).getChild(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        _logger.debug((Object)("getChildCount(parent='" + parent + "')"));
        if (parent instanceof SessionLevel) {
            return ((SessionLevel)parent).getChildCount();
        }
        if (parent instanceof List) {
            return this._sessions.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return 5 + (this._showCmCounterInfoColumns ? this._cmLongNameSumCols.size() : 0);
    }

    public String getColumnName(int column) {
        _logger.debug((Object)("getColumnName(column='" + column + "')"));
        if (column == 0) {
            return "Sessions";
        }
        if (column == 1) {
            return "Start Time";
        }
        if (column == 2) {
            return "End Time";
        }
        if (column == 3) {
            return "Duration";
        }
        if (column == 4) {
            return "Samples";
        }
        if (this._showCmCounterInfoColumns) {
            return this._cmLongNameSumCols.get(column - 5);
        }
        return super.getColumnName(column);
    }

    public Class<?> getColumnClass(int column) {
        _logger.debug((Object)("getColumnClass(column='" + column + "')"));
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return super.getColumnClass(column);
    }

    public Object getValueAt(Object node, int column) {
        _logger.debug((Object)("getValueAt(node='" + node + "', column='" + column + "')"));
        if (node instanceof SessionLevel) {
            SessionLevel rec = (SessionLevel)node;
            switch (column) {
                case 0: {
                    return rec;
                }
                case 1: {
                    return rec.getStartTime() != null ? this._sdf.format(rec.getStartTime()) : "none";
                }
                case 2: {
                    return rec.getEndTime() != null ? this._sdf.format(rec.getEndTime()) : "none";
                }
                case 3: {
                    return rec.getDuration();
                }
                case 4: {
                    return new Integer(rec.getDisplayChildCount());
                }
            }
        }
        if (node instanceof Timestamp && column == 0) {
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    return node;
                }
                case 2: {
                    return "-";
                }
                case 3: {
                    return "1 sample";
                }
                case 4: {
                    return null;
                }
            }
        }
        if (column > 4) {
            Timestamp ts = null;
            if (node instanceof SessionLevel) {
                ts = ((SessionLevel)node).getStartTime();
            }
            if (node instanceof Timestamp) {
                ts = (Timestamp)node;
            }
            if (ts == null) {
                return null;
            }
            String colName = this.getColumnName(column);
            int colIndex = this._cmLongNameSumCols.indexOf(colName);
            if (colIndex < 0) {
                return null;
            }
            String shortCmName = this._cmShortNameSumCols.get(colIndex);
            if (this._xxx_sampleCmCounterInfoMap != null) {
                PersistReader.SampleCmCounterInfo scmci = null;
                scmci = node instanceof SessionLevel ? ((SessionLevel)node).getSummaryCmCounterInfo() : this._xxx_sampleCmCounterInfoMap.get(ts);
                if (scmci == null) {
                    return "---";
                }
                PersistReader.CmCounterInfo cmci = scmci._ciMap.get(shortCmName);
                if (cmci == null) {
                    return "---";
                }
                if (cmci._absRows == cmci._diffRows && cmci._absRows == cmci._rateRows) {
                    if (cmci._absRows == 0) {
                        return "---";
                    }
                    return Integer.toString(cmci._absRows);
                }
                return cmci._absRows + "-" + cmci._diffRows + "-" + cmci._rateRows;
            }
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        _logger.debug((Object)("getIndexOfChild(parent='" + parent + "', child='" + child + "'.)"));
        if (!(parent instanceof SessionLevel) || child instanceof SessionLevel) {
            // empty if block
        }
        return -1;
    }

    public Object getRoot() {
        _logger.debug((Object)"getRoot()");
        return this._sessions;
    }

    public boolean isLeaf(Object node) {
        _logger.debug((Object)("isLeaf(node='" + node + "')"));
        if (node instanceof SessionLevel) {
            return false;
        }
        return !(node instanceof List);
    }

    protected class MinuteLevel
    extends SessionLevel {
        private int _atHour;
        private int _atMinute;

        MinuteLevel() {
            this._atHour = 0;
            this._atMinute = 0;
        }

        @Override
        public String toString() {
            return "MinuteLevel(startTime='" + this._startTime + "', endTime='" + this._endTime + "', periodStartTime='" + this._periodStartTime + "', periodEndTime='" + this._periodEndTime + "', numOfSamples='" + this._numOfSamples + "'";
        }

        @Override
        public String getDisplayString() {
            if (OfflineSessionModel.this._hourLevelCount == 1) {
                return "Minute " + this._atMinute * OfflineSessionModel.this._minuteLevelCount + " - " + (this._atMinute + 1) * OfflineSessionModel.this._minuteLevelCount;
            }
            return this._atHour + ", Minute " + this._atMinute * OfflineSessionModel.this._minuteLevelCount + " - " + (this._atMinute + 1) * OfflineSessionModel.this._minuteLevelCount;
        }

        @Override
        public void setPeriodStartTime() {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(this._startTime.getTime());
            this._atHour = cal.get(11);
            this._atMinute = cal.get(12) / OfflineSessionModel.this._minuteLevelCount;
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, this._atMinute * OfflineSessionModel.this._minuteLevelCount);
            this._periodStartTime = new Timestamp(cal.getTimeInMillis());
            this._periodEndTime = new Timestamp(cal.getTimeInMillis() + (long)(60000 * OfflineSessionModel.this._minuteLevelCount));
        }

        @Override
        public boolean isWithinPeriod(Timestamp ts) {
            long minutes = (ts.getTime() - this._periodStartTime.getTime()) / 1000L / 60L;
            return minutes < (long)OfflineSessionModel.this._minuteLevelCount;
        }
    }

    protected class HourLevel
    extends SessionLevel {
        private int _atHour;

        HourLevel() {
            this._atHour = 0;
        }

        @Override
        public String toString() {
            return "HourLevel(startTime='" + this._startTime + "', endTime='" + this._endTime + "', periodStartTime='" + this._periodStartTime + "', periodEndTime='" + this._periodEndTime + "', numOfSamples='" + this._numOfSamples + "'";
        }

        @Override
        public String getDisplayString() {
            if (OfflineSessionModel.this._hourLevelCount == 1) {
                return "Hour " + this._atHour * OfflineSessionModel.this._hourLevelCount;
            }
            return "Hour " + this._atHour * OfflineSessionModel.this._hourLevelCount + " - " + (this._atHour + 1) * OfflineSessionModel.this._hourLevelCount;
        }

        @Override
        public void setPeriodStartTime() {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(this._startTime.getTime());
            this._atHour = cal.get(11) / OfflineSessionModel.this._hourLevelCount;
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, this._atHour * OfflineSessionModel.this._hourLevelCount);
            this._periodStartTime = new Timestamp(cal.getTimeInMillis());
            this._periodEndTime = new Timestamp(cal.getTimeInMillis() + (long)(3600000 * OfflineSessionModel.this._hourLevelCount));
        }

        @Override
        public boolean isWithinPeriod(Timestamp ts) {
            long hours = (ts.getTime() - this._periodStartTime.getTime()) / 1000L / 60L / 60L;
            return hours < (long)OfflineSessionModel.this._hourLevelCount;
        }
    }

    protected class DayLevel
    extends SessionLevel {
        private int _atDay;

        DayLevel() {
            this._atDay = 0;
        }

        @Override
        public String toString() {
            return "DayLevel(startTime='" + this._startTime + "', endTime='" + this._endTime + "', periodStartTime='" + this._periodStartTime + "', periodEndTime='" + this._periodEndTime + "', numOfSamples='" + this._numOfSamples + "'";
        }

        @Override
        public String getDisplayString() {
            return "Day " + this._atDay * OfflineSessionModel.this._dayLevelCount;
        }

        @Override
        public void setPeriodStartTime() {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(this._startTime.getTime());
            this._atDay = cal.get(5) / OfflineSessionModel.this._dayLevelCount;
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            cal.set(5, this._atDay * OfflineSessionModel.this._dayLevelCount);
            this._periodStartTime = new Timestamp(cal.getTimeInMillis());
            this._periodEndTime = new Timestamp(cal.getTimeInMillis() + (long)(86400000 * OfflineSessionModel.this._dayLevelCount));
        }

        @Override
        public boolean isWithinPeriod(Timestamp ts) {
            long days = (ts.getTime() - this._periodStartTime.getTime()) / 1000L / 60L / 60L / 24L;
            return days < (long)OfflineSessionModel.this._dayLevelCount;
        }
    }

    protected class SessionLevel {
        PersistReader.SampleCmCounterInfo _summaryCmCounterInfo = null;
        Timestamp _sampleId = null;
        Timestamp _periodStartTime = null;
        Timestamp _periodEndTime = null;
        Timestamp _startTime = null;
        Timestamp _endTime = null;
        int _numOfSamples = 0;
        String _duration = "";
        ArrayList<Object> _children = new ArrayList();
        ArrayList<Timestamp> _allSamples = new ArrayList();

        public PersistReader.SampleCmCounterInfo getSummaryCmCounterInfo() {
            return this._summaryCmCounterInfo;
        }

        public void setSummaryCmCounterInfo(PersistReader.SampleCmCounterInfo summaryCmCounterInfo) {
            this._summaryCmCounterInfo = summaryCmCounterInfo;
        }

        SessionLevel() {
        }

        SessionLevel(Timestamp sampleId, Timestamp startTime, Timestamp endTime, int numOfSamples) {
            this.setSampleId(sampleId);
            this.setStartTime(startTime);
            this.setEndTime(endTime);
            this.setDisplayChildCount(numOfSamples);
            this.setDuration();
            _logger.debug((Object)("new SessionLevel(startTime='" + this._startTime + "', endTime='" + this._endTime + "', duration='" + this._duration + "', numOfSamples='" + this._numOfSamples + "')"));
        }

        public Timestamp getSampleId() {
            return this._sampleId;
        }

        public Timestamp getStartTime() {
            return this._startTime;
        }

        public Timestamp getEndTime() {
            return this._endTime;
        }

        public int getDisplayChildCount() {
            return this._numOfSamples;
        }

        public String getDuration() {
            return this._duration;
        }

        public void setSampleId(Timestamp sampleId) {
            this._sampleId = sampleId;
        }

        public void setStartTime(Timestamp startTime) {
            this._startTime = startTime;
            this.setPeriodStartTime();
        }

        public void setEndTime(Timestamp endTime) {
            this._endTime = endTime;
            this.setDuration();
            this.setDisplayChildCount();
        }

        public void setDisplayChildCount(int count) {
            this._numOfSamples = count;
        }

        public void setDisplayChildCount() {
            this._numOfSamples = 0;
            for (Object o : this._children) {
                if (o instanceof SessionLevel) {
                    SessionLevel s = (SessionLevel)o;
                    s.setDisplayChildCount();
                    this._numOfSamples += s.getDisplayChildCount();
                    continue;
                }
                ++this._numOfSamples;
            }
        }

        public void setDuration() {
            this._duration = this._startTime != null && this._endTime != null ? TimeUtils.msToTimeStr(this.getDurationFormatstr(), this._endTime.getTime() - this._startTime.getTime()) : "";
        }

        public String getDurationFormatstr() {
            return "%HH:%MM:%SS";
        }

        public String getDisplayString() {
            return this.getDuration();
        }

        public void setPeriodStartTime() {
            this._periodStartTime = this._startTime;
        }

        public void setPeriodEndTime() {
            this._periodEndTime = this._endTime;
        }

        public Timestamp getPeriodStartTime() {
            return this._periodStartTime != null ? this._periodStartTime : this._startTime;
        }

        public Timestamp getPeriodEndTime() {
            return this._periodEndTime != null ? this._periodEndTime : this._endTime;
        }

        private void addAllSamples(List<Timestamp> sampleList) {
            this._allSamples.addAll(sampleList);
        }

        public void addChild(SessionLevel level) {
            this._children.add(level);
        }

        public void addChild(Timestamp sample) {
            this._children.add(sample);
        }

        private void makeBabies() {
            DayLevel dayLevel = new DayLevel();
            HourLevel hourLevel = new HourLevel();
            MinuteLevel minuteLevel = new MinuteLevel();
            if (this._allSamples.size() == 0) {
                return;
            }
            Timestamp firstTs = this._allSamples.get(0);
            PersistReader.SampleCmCounterInfo allLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, firstTs);
            PersistReader.SampleCmCounterInfo dayLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, firstTs);
            PersistReader.SampleCmCounterInfo hourLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, firstTs);
            PersistReader.SampleCmCounterInfo minuteLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, firstTs);
            dayLevel.setSampleId(this._sampleId);
            hourLevel.setSampleId(this._sampleId);
            minuteLevel.setSampleId(this._sampleId);
            dayLevel.setStartTime(firstTs);
            hourLevel.setStartTime(firstTs);
            minuteLevel.setStartTime(firstTs);
            this.addChild(dayLevel);
            dayLevel.addChild(hourLevel);
            hourLevel.addChild(minuteLevel);
            for (int i = 0; i < this._allSamples.size(); ++i) {
                Timestamp prevTs = this._allSamples.get(i > 0 ? i - 1 : 0);
                Timestamp currTs = this._allSamples.get(i);
                if (!dayLevel.isWithinPeriod(currTs)) {
                    dayLevel.setEndTime(prevTs);
                    if (OfflineSessionModel.this._showCmCounterInfoColumns) {
                        dayLevel.setSummaryCmCounterInfo(dayLevelScmci);
                        dayLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, currTs);
                    }
                    dayLevel = new DayLevel();
                    dayLevel.setSampleId(this._sampleId);
                    dayLevel.setStartTime(currTs);
                    this.addChild(dayLevel);
                }
                if (!hourLevel.isWithinPeriod(currTs)) {
                    hourLevel.setEndTime(prevTs);
                    if (OfflineSessionModel.this._showCmCounterInfoColumns) {
                        hourLevel.setSummaryCmCounterInfo(hourLevelScmci);
                        hourLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, currTs);
                    }
                    hourLevel = new HourLevel();
                    hourLevel.setSampleId(this._sampleId);
                    hourLevel.setStartTime(currTs);
                    dayLevel.addChild(hourLevel);
                }
                if (!minuteLevel.isWithinPeriod(currTs)) {
                    minuteLevel.setEndTime(prevTs);
                    if (OfflineSessionModel.this._showCmCounterInfoColumns) {
                        minuteLevel.setSummaryCmCounterInfo(minuteLevelScmci);
                        minuteLevelScmci = new PersistReader.SampleCmCounterInfo(firstTs, currTs);
                    }
                    minuteLevel = new MinuteLevel();
                    minuteLevel.setSampleId(this._sampleId);
                    minuteLevel.setStartTime(currTs);
                    hourLevel.addChild(minuteLevel);
                }
                if (OfflineSessionModel.this._showCmCounterInfoColumns) {
                    PersistReader.SampleCmCounterInfo scmci = (PersistReader.SampleCmCounterInfo)OfflineSessionModel.this._xxx_sampleCmCounterInfoMap.get(currTs);
                    allLevelScmci.merge(scmci);
                    dayLevelScmci.merge(scmci);
                    hourLevelScmci.merge(scmci);
                    minuteLevelScmci.merge(scmci);
                }
                minuteLevel.addChild(currTs);
            }
            Timestamp lastTs = this._allSamples.get(this._allSamples.size() - 1);
            minuteLevel.setEndTime(lastTs);
            hourLevel.setEndTime(lastTs);
            dayLevel.setEndTime(lastTs);
            if (OfflineSessionModel.this._showCmCounterInfoColumns) {
                this.setSummaryCmCounterInfo(allLevelScmci);
                dayLevel.setSummaryCmCounterInfo(dayLevelScmci);
                hourLevel.setSummaryCmCounterInfo(hourLevelScmci);
                minuteLevel.setSummaryCmCounterInfo(minuteLevelScmci);
            }
        }

        public int getChildCount() {
            return this._children.size();
        }

        public Object getChild(int index) {
            if (index < this._children.size()) {
                Object o = this._children.get(index);
                if (o == null) {
                    return "-----NULL----";
                }
                return o;
            }
            return "Problems: index=" + index + ", _children.size()=" + this._children.size();
        }

        public String toString() {
            return "SessionLevel(startTime='" + this._startTime + "', endTime='" + this._endTime + "', periodStartTime='" + this._periodStartTime + "', periodEndTime='" + this._periodEndTime + "', numOfSamples='" + this._numOfSamples + "'";
        }

        public boolean isWithinPeriod(Timestamp ts) {
            return true;
        }
    }
}

