/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.AseConfig;
import asemon.AseConfigText;
import asemon.Version;
import asemon.gui.AseConfigViewDialog;
import asemon.gui.OfflineSessionModel;
import asemon.gui.swing.AbstractComponentDecorator;
import asemon.pcs.PersistReader;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class OfflineSessionVeiwer
extends JFrame
implements ActionListener,
PersistReader.INotificationListener {
    private static Logger _logger = Logger.getLogger(OfflineSessionVeiwer.class);
    private static final long serialVersionUID = -113668702537883167L;
    private static final Color TAB_CMNAMESUM_COL_BG = new Color(240, 240, 240);
    private Frame _owner = null;
    private OfflineSessionModel _model = null;
    private JXTreeTable _treeTable = null;
    private JPopupMenu _tablePopupMenu = null;
    private JLabel _day_lbl = new JLabel("Day");
    private JLabel _hour_lbl = new JLabel("Hour");
    private JLabel _minute_lbl = new JLabel("Minute");
    private JComboBox _day_cbx = new JComboBox<String>(new String[]{"1"});
    private JComboBox _hour_cbx = new JComboBox<String>(new String[]{"1", "2", "3", "4", "6", "12"});
    private JComboBox _minute_cbx = new JComboBox<String>(new String[]{"1", "2", "5", "10", "15", "20", "30"});
    private int _dayLevel = 1;
    private int _hourLevel = 1;
    private int _minuteLevel = 10;
    private JButton _refresh_but = new JButton("Refresh");
    private JCheckBox _showCounterInfo_chk = new JCheckBox("Show Counter Info", false);
    private JCheckBox _linkSliderTree_chk = new JCheckBox("Link Slider with Tree", true);
    private JLabel _status_lbl = new JLabel("");
    private JButton _show_but = new JButton("Show");
    private Watermark _watermark = null;
    private int _colSessionsPrefSize = 250;
    private int _colSessionsActSize = 250;
    private Timestamp _currentPeriodStartTime = null;
    private Timestamp _currentPeriodEndTime = null;
    Highlighter[] _highliters = new Highlighter[]{new CmSummaryFieldHighlighter(new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.column > 4;
        }
    })};

    public OfflineSessionVeiwer(Frame owner) {
        this._owner = owner;
        this.initComponents();
    }

    protected void initComponents() {
        if (this._owner != null) {
            this.setIconImage(this._owner.getIconImage());
        }
        this.setTitle("Offline Session Viewer");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "", ""));
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.createTopPanel(), "North");
        panel.add((Component)this.createTablePanel(), "Center");
        panel.add((Component)this.createBottomPanel(), "South");
        this.loadProps();
        this.setSomeValuesToModel();
        this.refreshTable(false);
        this.setContentPane(panel);
        this.initComponentActions();
    }

    private JPanel createTopPanel() {
        JPanel panel = SwingUtils.createPanel("Top", false);
        panel.setLayout((LayoutManager)new MigLayout("ins 3 10 3 3", "", ""));
        this._refresh_but.setToolTipText("Refresh the sessions list from the database.");
        this._showCounterInfo_chk.setToolTipText("<html>Show how many rows each individual Performance Counter Sample has.<br>This is presented to the right hand side.<br><b>NOTE:</b> Not yet implemented.</html>");
        panel.add((Component)this._day_lbl, "");
        panel.add((Component)this._day_cbx, "");
        panel.add((Component)this._hour_lbl, "gap 10");
        panel.add((Component)this._hour_cbx, "");
        panel.add((Component)this._minute_lbl, "gap 10");
        panel.add((Component)this._minute_cbx, "");
        panel.add((Component)new JLabel(""), "grow, push, right");
        panel.add((Component)this._showCounterInfo_chk, "");
        panel.add((Component)this._refresh_but, "");
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel panel = SwingUtils.createPanel("Bottom", false);
        panel.setLayout((LayoutManager)new MigLayout("ins 3 10 3 3", "", ""));
        this._linkSliderTree_chk.setToolTipText("<html>When you click on the view-slider or graph-content, to position what data to view.<br>Make the selected timestamp node visible in the tree view as well.</html>");
        this._show_but.setToolTipText("Show the selected sample period in the summary graphs.");
        panel.add((Component)this._status_lbl, "grow, push, left");
        panel.add((Component)new JLabel(""), "grow, push, right");
        panel.add((Component)this._linkSliderTree_chk, "");
        panel.add((Component)this._show_but, "");
        return panel;
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout(new BorderLayout());
        this._treeTable = new JXTreeTable(){
            private static final long serialVersionUID = 0L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                if (row >= 0) {
                    row = super.convertRowIndexToModel(row);
                }
                return tip;
            }
        };
        this._model = new OfflineSessionModel(this._showCounterInfo_chk.isSelected());
        this._treeTable.setTreeTableModel((TreeTableModel)this._model);
        this._treeTable.setTreeCellRenderer((TreeCellRenderer)new IconRenderer());
        this._treeTable.setHighlighters(this._highliters);
        this._treeTable.setSelectionMode(0);
        this._treeTable.setAutoResizeMode(0);
        this._treeTable.packAll();
        this._treeTable.setSortable(true);
        this._treeTable.setColumnControlVisible(true);
        this._treeTable.addKeyListener((KeyListener)new TreeTableNavigationEnhancer(this._treeTable));
        this._treeTable.getColumnModel().getColumn(0).setWidth(250);
        this._tablePopupMenu = this.createDataTablePopupMenu();
        this._treeTable.setComponentPopupMenu(this._tablePopupMenu);
        JScrollPane scroll = new JScrollPane((Component)this._treeTable);
        this._watermark = new Watermark(scroll, "");
        panel.add((Component)scroll, "Center");
        return panel;
    }

    public JPopupMenu getDataTablePopupMenu() {
        return this._tablePopupMenu;
    }

    public JPopupMenu createDataTablePopupMenu() {
        _logger.debug((Object)"createDataTablePopupMenu(): called.");
        JPopupMenu popup = new JPopupMenu();
        JMenuItem show = new JMenuItem("Show");
        JMenuItem cfgView = new JMenuItem("View ASE Configuration...");
        JMenuItem pcsDbInfo = new JMenuItem(Version.getAppName() + " Version that persisted this session...");
        popup.add(show);
        popup.add(cfgView);
        popup.add(pcsDbInfo);
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineSessionVeiwer.this.doActionShow();
            }
        });
        cfgView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineSessionVeiwer.this.doActionShowAseConfig();
            }
        });
        pcsDbInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineSessionVeiwer.this.doActionShowPcsDbInfo();
            }
        });
        if (popup.getComponentCount() == 0) {
            _logger.warn((Object)"No PopupMenu has been assigned for the data table in the panel.");
            return null;
        }
        return popup;
    }

    @Override
    public void setWatermark(String text) {
        this.setWatermarkText(text);
    }

    @Override
    public void setStatusText(String status) {
        this._status_lbl.setText(status);
    }

    @Override
    public void setSessionList(List<PersistReader.SessionInfo> sessionList) {
        this.refreshTable(sessionList);
    }

    private void setLevelCbx() {
        this._day_cbx.setSelectedItem("" + this._dayLevel);
        this._hour_cbx.setSelectedItem("" + this._hourLevel);
        this._minute_cbx.setSelectedItem("" + this._minuteLevel);
    }

    private void getLevelCbx() {
        this._dayLevel = Integer.parseInt(this._day_cbx.getSelectedItem().toString());
        this._hourLevel = Integer.parseInt(this._hour_cbx.getSelectedItem().toString());
        this._minuteLevel = Integer.parseInt(this._minute_cbx.getSelectedItem().toString());
    }

    private void readSomeValuesFromModel() {
        this._dayLevel = this._model.getDayLevelCount();
        this._hourLevel = this._model.getHourLevelCount();
        this._minuteLevel = this._model.getMinuteLevelCount();
    }

    private void setSomeValuesToModel() {
        this._model.setDayLevelCount(this._dayLevel);
        this._model.setHourLevelCount(this._hourLevel);
        this._model.setMinuteLevelCount(this._minuteLevel);
    }

    private void refreshTable(boolean saveGuiStuff) {
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        reader.loadSessions();
    }

    private void refreshTable(List<PersistReader.SessionInfo> sessionList) {
        this.refreshTable(this.isVisible(), sessionList);
    }

    private void refreshTable(boolean saveGuiStuff, List<PersistReader.SessionInfo> sessionList) {
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        this.setSomeValuesToModel();
        if (saveGuiStuff && this._treeTable.getRowCount() > 0) {
            this._colSessionsPrefSize = this._treeTable.getColumnModel().getColumn(0).getPreferredWidth();
            this._colSessionsActSize = this._treeTable.getColumnModel().getColumn(0).getWidth();
            this.getLevelCbx();
            this.saveProps();
        }
        this._model = new OfflineSessionModel(this._showCounterInfo_chk.isSelected());
        this.setSomeValuesToModel();
        this._model.init(sessionList);
        this._treeTable.setTreeTableModel((TreeTableModel)this._model);
        this._treeTable.packAll();
        this._treeTable.getColumnModel().getColumn(0).setPreferredWidth(this._colSessionsPrefSize);
        this._treeTable.getColumnModel().getColumn(0).setWidth(this._colSessionsActSize);
        this.setFocus();
    }

    private void setFocus() {
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                OfflineSessionVeiwer.this._treeTable.requestFocus();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
    }

    private void initComponentActions() {
        this.readSomeValuesFromModel();
        this._day_cbx.addActionListener(this);
        this._hour_cbx.addActionListener(this);
        this._minute_cbx.addActionListener(this);
        this._refresh_but.addActionListener(this);
        this._show_but.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OfflineSessionVeiwer.this.saveProps();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._day_cbx.equals(source)) {
            this.refreshTable(true);
        }
        if (this._hour_cbx.equals(source)) {
            this.refreshTable(true);
        }
        if (this._minute_cbx.equals(source)) {
            this.refreshTable(true);
        }
        if (this._refresh_but.equals(source)) {
            this.refreshTable(true);
        }
        if (this._show_but.equals(source)) {
            this.doActionShow();
        }
    }

    private void loadSessionLevel(PersistReader reader, OfflineSessionModel.SessionLevel sl) {
        reader.loadSessionGraphs(sl.getSampleId(), sl.getPeriodStartTime(), sl.getPeriodEndTime(), sl._numOfSamples);
        reader.loadTimelineSlider(sl.getSampleId(), sl.getPeriodStartTime(), sl.getPeriodEndTime());
        this._currentPeriodStartTime = sl.getPeriodStartTime();
        this._currentPeriodEndTime = sl.getPeriodEndTime();
        AseConfig.getInstance().initialize(reader.getConnection(), true, true, sl.getPeriodStartTime());
        AseConfigText.initializeAll(reader.getConnection(), true, true, sl.getPeriodStartTime());
    }

    public void doActionShow() {
        int row = this._treeTable.getSelectedRow();
        Object o = this._treeTable.getValueAt(row, 0);
        _logger.info((Object)("SHOW_BUT was pressed, currentRow=" + row + ", value='" + o + "'."));
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        if (o instanceof OfflineSessionModel.SessionLevel) {
            OfflineSessionModel.SessionLevel sl = (OfflineSessionModel.SessionLevel)o;
            this.loadSessionLevel(reader, sl);
        } else if (o instanceof Timestamp) {
            Object parentObj;
            OfflineSessionModel model;
            List<Object> ol;
            Timestamp ts = (Timestamp)o;
            boolean loadSuper = false;
            if (this._currentPeriodStartTime == null || this._currentPeriodEndTime == null) {
                loadSuper = true;
            }
            if (!(loadSuper || ts.getTime() >= this._currentPeriodStartTime.getTime() && ts.getTime() <= this._currentPeriodEndTime.getTime())) {
                loadSuper = true;
            }
            if (loadSuper && (ol = (model = (OfflineSessionModel)this._treeTable.getTreeTableModel()).getObjectPathForSampleTime(ts)).size() > 0 && (parentObj = ol.get(ol.size() - 2)) instanceof OfflineSessionModel.SessionLevel) {
                this.loadSessionLevel(reader, (OfflineSessionModel.SessionLevel)parentObj);
            }
            reader.loadSessionCmIndicators(ts);
            reader.loadSummaryCm(ts);
        }
    }

    public void doActionShowAseConfig() {
        int row = this._treeTable.getSelectedRow();
        Object o = this._treeTable.getValueAt(row, 0);
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        if (o instanceof OfflineSessionModel.SessionLevel) {
            OfflineSessionModel.SessionLevel sl = (OfflineSessionModel.SessionLevel)o;
            AseConfig.getInstance().initialize(reader.getConnection(), true, true, sl.getPeriodStartTime());
            AseConfigText.initializeAll(reader.getConnection(), true, true, sl.getPeriodStartTime());
        }
        AseConfigViewDialog.showDialog(this);
    }

    public void doActionShowPcsDbInfo() {
        OfflineSessionModel.SessionLevel sl;
        PersistReader.MonVersionInfo monVersionInfo;
        int row = this._treeTable.getSelectedRow();
        Object o = this._treeTable.getValueAt(row, 0);
        PersistReader reader = PersistReader.getInstance();
        if (reader == null) {
            throw new RuntimeException("The 'PersistReader' has not been initialized.");
        }
        if (o instanceof OfflineSessionModel.SessionLevel && (monVersionInfo = reader.getMonVersionInfo((sl = (OfflineSessionModel.SessionLevel)o).getPeriodStartTime())) != null) {
            String msg = "<HTML><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=1>   <TR> <TD><B>Name:            <B>&nbsp;</TD> <TD>" + monVersionInfo._productString + "</TD> </TR>" + "   <TR> <TD><B>                 <B>&nbsp;</TD> <TD></TD> </TR>" + "   <TR> <TD><B>Version:         <B>&nbsp;</TD> <TD>" + monVersionInfo._versionString + "</TD> </TR>" + "   <TR> <TD><B>Build:           <B>&nbsp;</TD> <TD>" + monVersionInfo._buildString + "</TD> </TR>" + "   <TR> <TD><B>                 <B>&nbsp;</TD> <TD></TD> </TR>" + "   <TR> <TD><B>Source Date:     <B>&nbsp;</TD> <TD>" + monVersionInfo._sourceDate + "</TD> </TR>" + "   <TR> <TD><B>Source Revision: <B>&nbsp;</TD> <TD>" + monVersionInfo._sourceRev + "</TD> </TR>" + "</TABLE>" + "</HTML>";
            SwingUtils.showInfoMessage(this, Version.getAppName() + " Version used when storing counters", msg);
        }
    }

    public void setCurrentSampleTimeView(Timestamp ts) {
        if (this._linkSliderTree_chk.isSelected()) {
            System.out.println("FIXME: Get the correct node in the list, and show it in the tree view... ts='" + ts + "'.");
        }
    }

    private void saveProps() {
        Configuration tmpConf = Configuration.getInstance("USER_TEMP");
        String base = "offlineSessionViewer.";
        if (tmpConf != null) {
            tmpConf.setProperty(base + "window.width", this.getSize().width);
            tmpConf.setProperty(base + "window.height", this.getSize().height);
            tmpConf.setProperty(base + "window.pos.x", this.getLocationOnScreen().x);
            tmpConf.setProperty(base + "window.pos.y", this.getLocationOnScreen().y);
            tmpConf.setProperty(base + "colSessionsPrefSize", this._colSessionsPrefSize);
            tmpConf.setProperty(base + "colSessionsActSize", this._colSessionsActSize);
            tmpConf.setProperty(base + "dayLevel", this._dayLevel);
            tmpConf.setProperty(base + "hourLevel", this._hourLevel);
            tmpConf.setProperty(base + "minuteLevel", this._minuteLevel);
            tmpConf.setProperty(base + "option.showCounterInfo", this._showCounterInfo_chk.isSelected());
            tmpConf.setProperty(base + "option.linkSliderTree", this._linkSliderTree_chk.isSelected());
            tmpConf.save();
        }
    }

    private void loadProps() {
        int width = 600;
        int height = 350;
        int x = -1;
        int y = -1;
        Configuration tmpConf = Configuration.getCombinedConfiguration();
        String base = "offlineSessionViewer.";
        this.setSize(width, height);
        if (tmpConf == null) {
            return;
        }
        this._colSessionsPrefSize = tmpConf.getIntProperty(base + "colSessionsPrefSize", this._colSessionsPrefSize);
        this._colSessionsActSize = tmpConf.getIntProperty(base + "colSessionsActSize", this._colSessionsActSize);
        this._dayLevel = tmpConf.getIntProperty(base + "dayLevel", this._dayLevel);
        this._hourLevel = tmpConf.getIntProperty(base + "hourLevel", this._hourLevel);
        this._minuteLevel = tmpConf.getIntProperty(base + "minuteLevel", this._minuteLevel);
        this.setLevelCbx();
        boolean bool = tmpConf.getBooleanProperty(base + "option.showCounterInfo", this._showCounterInfo_chk.isSelected());
        this._showCounterInfo_chk.setSelected(bool);
        bool = tmpConf.getBooleanProperty(base + "option.linkSliderTree", this._linkSliderTree_chk.isSelected());
        this._linkSliderTree_chk.setSelected(bool);
        width = tmpConf.getIntProperty(base + "window.width", width);
        height = tmpConf.getIntProperty(base + "window.height", height);
        x = tmpConf.getIntProperty(base + "window.pos.x", -1);
        y = tmpConf.getIntProperty(base + "window.pos.y", -1);
        if (width != -1 && height != -1) {
            this.setSize(width, height);
        }
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            SwingUtils.centerWindow(this);
        }
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Configuration conf = new Configuration("c:\\OfflineSessionsViewer.tmp.deleteme.properties");
        Configuration.setInstance("USER_TEMP", conf);
        OfflineSessionVeiwer view = new OfflineSessionVeiwer(null);
        view.setDefaultCloseOperation(3);
        view.setVisible(true);
    }

    public void setWatermarkText(String str) {
        this._watermark.setWatermarkText(str);
    }

    public void setWatermark() {
        this.setWatermarkText(null);
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String[] _textBr;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._textBr = null;
            this.g = null;
            this.r = null;
            if (text == null) {
                text = "";
            }
            this._textBr = text.split("\n");
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._textBr == null || this._textBr != null && this._textBr.length < 0) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 2.0f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int maxStrWidth = 0;
            int maxStrHeight = fm.getHeight();
            for (int i = 0; i < this._textBr.length; ++i) {
                int CurLineStrWidth = fm.stringWidth(this._textBr[i]);
                maxStrWidth = Math.max(maxStrWidth, CurLineStrWidth);
            }
            int xPos = (this.r.width - maxStrWidth) / 2;
            int yPos = (int)((double)this.r.height - (double)((this.r.height - fm.getHeight()) / 2) * 0.6);
            for (int i = 0; i < this._textBr.length; ++i) {
                this.g.drawString(this._textBr[i], xPos, yPos + maxStrHeight * i);
            }
        }

        public void setWatermarkText(String text) {
            if (text == null) {
                text = "";
            }
            this._textBr = text.split("\n");
            _logger.debug((Object)("setWatermarkText: to '" + text + "'."));
            this.repaint();
        }
    }

    public class TreeTableNavigationEnhancer
    implements KeyListener {
        private JXTreeTable _treeTable;

        public TreeTableNavigationEnhancer(JXTreeTable treeTable) {
            this._treeTable = treeTable;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public synchronized void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                int row = this._treeTable.getSelectedRow();
                _logger.info((Object)("<---RETURN---> was pressed, currentRow=" + row + ", value='" + this._treeTable.getValueAt(row, 0) + "'."));
                OfflineSessionVeiwer.this.doActionShow();
            }
            if (e.getKeyCode() == 39) {
                if (this._treeTable.isExpanded(this._treeTable.getSelectedRow())) {
                    Object o = this._treeTable.getPathForRow(this._treeTable.getSelectedRow()).getLastPathComponent();
                    if (o instanceof TreeNode && ((TreeNode)o).getChildCount() > 0) {
                        this._treeTable.getSelectionModel().setSelectionInterval(this._treeTable.getSelectedRow() + 1, this._treeTable.getSelectedRow() + 1);
                    }
                } else {
                    this._treeTable.expandRow(this._treeTable.getSelectedRow());
                }
            } else if (e.getKeyCode() == 37) {
                if (this._treeTable.isExpanded(this._treeTable.getSelectedRow())) {
                    this._treeTable.collapseRow(this._treeTable.getSelectedRow());
                } else {
                    int parentRow = this.getParentRow(this._treeTable.getSelectedRow());
                    this._treeTable.getSelectionModel().setSelectionInterval(parentRow, parentRow);
                }
            }
        }

        protected int getParentRow(int row) {
            for (int i = row - 1; i >= 0; --i) {
                if (!this._treeTable.isExpanded(i)) continue;
                return i;
            }
            return row;
        }
    }

    public class TreeTableNavigationEnhancerXXX
    implements KeyListener {
        private JXTreeTable _treeTable;

        public TreeTableNavigationEnhancerXXX(JXTreeTable treeTable) {
            this._treeTable = treeTable;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public synchronized void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 39) {
                int col = this._treeTable.getSelectedColumn();
                if (col != 0) {
                    return;
                }
                int row = this._treeTable.getSelectedRow();
                this._treeTable.expandRow(row);
                this._treeTable.setRowSelectionInterval(row + 1, row + 1);
                this._treeTable.setColumnSelectionInterval(0, 0);
                e.consume();
            } else if (keyCode == 37) {
                int col = this._treeTable.getSelectedColumn();
                if (col != 0) {
                    return;
                }
                int row = this._treeTable.getSelectedRow();
                if (this._treeTable.isExpanded(row)) {
                    this._treeTable.collapseRow(row);
                    this._treeTable.setRowSelectionInterval(row, row);
                } else {
                    int parentRow = this.getParentRow(row);
                    this._treeTable.setRowSelectionInterval(parentRow, parentRow);
                }
                this._treeTable.setColumnSelectionInterval(0, 0);
                e.consume();
            }
        }

        protected int getParentRow(int row) {
            TreeTableModel m = this._treeTable.getTreeTableModel();
            Object childValue = this._treeTable.getValueAt(row, 0);
            for (int i = row - 1; i >= 0; --i) {
                if (!this._treeTable.isExpanded(i)) continue;
                Object p = this._treeTable.getValueAt(i, 0);
                int x = m.getChildCount(p);
                for (int j = 0; j < x; ++j) {
                    if (!m.getChild(p, j).equals(childValue)) continue;
                    return i;
                }
                if (m.getIndexOfChild(this._treeTable.getValueAt(i, 0), childValue) < 0) continue;
                return i;
            }
            return 0;
        }
    }

    private static class CmSummaryFieldHighlighter
    extends AbstractHighlighter {
        public CmSummaryFieldHighlighter(HighlightPredicate predicate) {
            super(predicate);
        }

        protected Component doHighlight(Component comp, ComponentAdapter adapter) {
            Object value = adapter.getFilteredValueAt(adapter.row, adapter.convertColumnIndexToModel(adapter.column));
            if (comp instanceof JLabel) {
                ((JLabel)comp).setHorizontalAlignment(4);
            }
            if ("---".equals(value)) {
                comp.setForeground(Color.BLUE);
            }
            comp.setBackground(TAB_CMNAMESUM_COL_BG);
            return comp;
        }
    }

    public static class IconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        ImageIcon sessionIcon = SwingUtils.readImageIcon(Version.class, "images/sample_session.png");
        ImageIcon dayIcon = SwingUtils.readImageIcon(Version.class, "images/sample_day.png");
        ImageIcon hourIcon = SwingUtils.readImageIcon(Version.class, "images/sample_hour.png");
        ImageIcon minuteIcon = SwingUtils.readImageIcon(Version.class, "images/sample_minute.png");
        ImageIcon sampleIcon = SwingUtils.readImageIcon(Version.class, "images/sample_item.png");

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component scomp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof OfflineSessionModel.MinuteLevel) {
                this.setIcon(this.minuteIcon);
                this.setText(((OfflineSessionModel.SessionLevel)value).getDisplayString());
            } else if (value instanceof OfflineSessionModel.HourLevel) {
                this.setIcon(this.hourIcon);
                this.setText(((OfflineSessionModel.SessionLevel)value).getDisplayString());
            } else if (value instanceof OfflineSessionModel.DayLevel) {
                this.setIcon(this.dayIcon);
                this.setText(((OfflineSessionModel.SessionLevel)value).getDisplayString());
            } else if (value instanceof OfflineSessionModel.SessionLevel) {
                this.setIcon(this.sessionIcon);
                this.setText(((OfflineSessionModel.SessionLevel)value).getDisplayString());
            } else {
                this.setIcon(this.sampleIcon);
            }
            return scomp;
        }
    }
}

