/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Version;
import asemon.gui.AsePlanViewer;
import asemon.gui.ResultSetTableModel;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.ConnectionFactory;
import asemon.utils.SwingUtils;
import asemon.utils.SwingWorker;
import asemon.xmenu.TablePopupFactory;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingx.JXTable;

public class QueryWindow
implements SybMessageHandler,
ConnectionFactory {
    private static Logger _logger = Logger.getLogger(QueryWindow.class);
    private static final long serialVersionUID = 1L;
    private Connection _conn = null;
    private JTextArea _query = new JTextArea();
    private JScrollPane _queryScroll = new JScrollPane(this._query);
    private JButton _exec = new JButton("Exec");
    private JButton _copy = new JButton("Copy");
    private JCheckBox _showplan = new JCheckBox("GUI Showplan", false);
    private JCheckBox _rsInTabs = new JCheckBox("Resultsets in Tabbed Panel", false);
    private JComboBox _dbs_cobx = new JComboBox();
    private JPanel _resPanel = new JPanel();
    private JScrollPane _resPanelScroll = new JScrollPane(this._resPanel);
    private JLabel _msgline = new JLabel("");
    private JSplitPane _splitPane = new JSplitPane(0);
    private int _lastTabIndex = -1;
    private boolean _closeConnOnExit = true;
    private Font _aseMsgFont = null;
    private ArrayList<JComponent> _resultCompList = null;
    private Window _window = null;
    private JFrame _jframe = null;
    private JDialog _jdialog = null;

    public QueryWindow(Connection conn, WindowType winType) {
        this(conn, null, true, winType);
    }

    public QueryWindow(Connection conn, boolean closeConnOnExit, WindowType winType) {
        this(conn, null, closeConnOnExit, winType);
    }

    public QueryWindow(Connection conn, String sql, WindowType winType) {
        this(conn, sql, true, winType);
    }

    public QueryWindow(Connection conn, String sql, boolean closeConnOnExit, WindowType winType) {
        if (winType == WindowType.JFRAME) {
            this._jframe = new JFrame("ASEMon Query");
            this._window = this._jframe;
        }
        if (winType == WindowType.JDIALOG) {
            this._jdialog = new JDialog((Dialog)null, "ASEMon Query");
            this._window = this._jdialog;
        }
        if (winType == WindowType.JDIALOG_MODAL) {
            this._jdialog = new JDialog((Dialog)null, "ASEMon Query", true);
            this._window = this._jdialog;
        }
        if (this._window == null) {
            throw new RuntimeException("_window is null, this should never happen.");
        }
        ImageIcon icon = SwingUtils.readImageIcon(Version.class, "images/sql_query_window.png");
        this._window.setIconImage(icon.getImage());
        this._closeConnOnExit = closeConnOnExit;
        this._window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (QueryWindow.this._closeConnOnExit) {
                    QueryWindow.this.close();
                }
            }
        });
        this._conn = conn;
        ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)this);
        int aseVersion = AseConnectionUtils.getAseVersionNumber(conn);
        this._exec.setToolTipText("Executes the select sql statement above (Ctrl-e)(Alt+e)(F5)(F9).");
        this._exec.setMnemonic('e');
        this._showplan.setToolTipText("Show Graphical showplan for the sql statement (work with ASE 15.x).");
        this._dbs_cobx.setToolTipText("Change database context.");
        this._rsInTabs.setToolTipText("Check this if you want to have multiple result sets in individual tabs.");
        this._query.setToolTipText("Put your SQL query here.\n'go' statements is not allowed.\nIf you select text and press 'exec' only the highlighted text will be sent to the ASE.");
        this._copy.setToolTipText("Copy All resultsets to clipboard, tables will be into ascii format.");
        Container contentPane = this._jframe != null ? this._jframe.getContentPane() : this._jdialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        JPanel bottom = new JPanel((LayoutManager)new MigLayout());
        this._splitPane.setTopComponent(top);
        this._splitPane.setBottomComponent(bottom);
        this._splitPane.setContinuousLayout(true);
        contentPane.add(this._splitPane);
        top.add((Component)this._queryScroll, "Center");
        top.setMinimumSize(new Dimension(300, 100));
        bottom.add((Component)this._exec, "split 4");
        bottom.add((Component)this._dbs_cobx, "");
        bottom.add((Component)this._rsInTabs, "");
        bottom.add((Component)this._showplan, "");
        bottom.add((Component)this._copy, "right, wrap");
        bottom.add((Component)this._resPanelScroll, "span 4, width 100%, height 100%");
        bottom.add((Component)this._msgline, "dock south");
        this._resPanelScroll.getVerticalScrollBar().setUnitIncrement(16);
        this._showplan.setEnabled(aseVersion >= 15000);
        this._query.getInputMap().put(KeyStroke.getKeyStroke(69, 128), "execute");
        this._query.getInputMap().put(KeyStroke.getKeyStroke(120, 0), "execute");
        this._query.getInputMap().put(KeyStroke.getKeyStroke(116, 0), "execute");
        this._query.getActionMap().put("execute", new AbstractAction("execute"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryWindow.this._exec.doClick();
            }
        });
        this._exec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryWindow.this.actionExecute(e);
            }
        });
        this._dbs_cobx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryWindow.this.useDb((String)QueryWindow.this._dbs_cobx.getSelectedItem());
            }
        });
        this.setDbNames();
        this._copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryWindow.this.actionCopy(e);
            }
        });
        if (sql != null && !sql.equals("")) {
            this._query.setText(sql);
            this.displayQueryResults(sql);
        } else {
            String helper = "Write your SQL query here";
            this._query.setText(helper);
            this._query.setSelectionStart(0);
            this._query.setSelectionEnd(helper.length());
        }
    }

    public void setSize(int width, int height) {
        this._window.setSize(width, height);
    }

    public void setLocationRelativeTo(Component comp) {
        this._window.setLocationRelativeTo(comp);
    }

    public void setVisible(boolean b) {
        this._window.setVisible(b);
    }

    private void actionExecute(ActionEvent e) {
        this._lastTabIndex = -1;
        for (int i = 0; i < this._resPanel.getComponentCount(); ++i) {
            Component comp = this._resPanel.getComponent(i);
            if (!(comp instanceof JTabbedPane)) continue;
            JTabbedPane tp = (JTabbedPane)comp;
            this._lastTabIndex = tp.getSelectedIndex();
            _logger.trace((Object)("Save last tab index pos as " + this._lastTabIndex + ", tp=" + tp));
        }
        String q = this._query.getSelectedText();
        if (q != null && !q.equals("")) {
            this.displayQueryResults(q);
        } else {
            this.displayQueryResults(this._query.getText());
        }
    }

    private void actionCopy(ActionEvent e) {
        System.out.println("-------COPY---------");
        StringBuilder sb = this.getResultPanelAsText(this._resPanel);
        if (sb != null) {
            StringSelection data = new StringSelection(sb.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(data, data);
        }
    }

    private StringBuilder getResultPanelAsText(JComponent panel) {
        StringBuilder sb = new StringBuilder();
        String terminatorStr = "\n";
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            JTextComponent text;
            Component comp = panel.getComponent(i);
            if (comp instanceof JPanel) {
                sb.append((CharSequence)this.getResultPanelAsText((JPanel)comp));
                continue;
            }
            if (comp instanceof JTabbedPane) {
                JTabbedPane tp = (JTabbedPane)comp;
                for (int t = 0; t < tp.getTabCount(); ++t) {
                    Component tabComp = tp.getComponentAt(t);
                    if (!(tabComp instanceof JComponent)) continue;
                    sb.append((CharSequence)this.getResultPanelAsText((JComponent)tabComp));
                }
                continue;
            }
            if (comp instanceof JTable) {
                JTable table = (JTable)comp;
                String textTable = SwingUtils.tableToString(table.getModel());
                sb.append(textTable);
                sb.append(terminatorStr);
                continue;
            }
            if (comp instanceof JEditorPane) {
                String strFromClipboard;
                text = (JEditorPane)comp;
                text.selectAll();
                text.copy();
                text.select(0, 0);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(this);
                try {
                    strFromClipboard = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception ee) {
                    strFromClipboard = ee.toString();
                }
                sb.append(strFromClipboard);
                sb.append("\n");
                sb.append(terminatorStr);
                continue;
            }
            if (comp instanceof JTextArea) {
                text = (JTextArea)comp;
                sb.append(text.getText());
                sb.append("\n");
                sb.append(terminatorStr);
                continue;
            }
            if (comp instanceof JTableHeader) continue;
            sb.append(comp.toString());
            sb.append("\n");
            sb.append(terminatorStr);
        }
        return sb;
    }

    public void openTheWindow() {
        this.openTheWindow(600, 400);
    }

    public void openTheWindow(int width, int height) {
        this._window.setSize(width, width);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryWindow.this.openTheWindowAsThread();
                _logger.debug((Object)"openTheWindowAsThread() AFTER... tread is terminating...");
            }
        });
    }

    public void setSql(String sql) {
        this._query.setText(sql);
    }

    public String getSql() {
        return this._query.getText();
    }

    private void openTheWindowAsThread() {
        this._window.setVisible(true);
    }

    private void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._conn = null;
    }

    protected void finalize() {
        if (this._closeConnOnExit) {
            this.close();
        }
    }

    private boolean useDb(String dbname) {
        if (dbname == null || dbname != null && dbname.trim().equals("")) {
            return false;
        }
        try {
            this._conn.createStatement().execute("use " + dbname);
            return true;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this._window, "Error Number: " + e.getErrorCode() + "\n" + e.getMessage(), "Error", 0);
            this.getCurrentDb();
            return false;
        }
    }

    private String getCurrentDb() {
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery("select db_name()");
            String cwdb = "";
            while (rs.next()) {
                cwdb = rs.getString(1);
            }
            this._dbs_cobx.setSelectedItem(cwdb);
            return cwdb;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this._window, "Problems getting current Working Database:\nError Number: " + e.getErrorCode() + "\n" + e.getMessage(), "Error", 0);
            return null;
        }
    }

    private void setDbNames() {
        try {
            Statement stmnt = this._conn.createStatement();
            ResultSet rs = stmnt.executeQuery("select name, db_name() from master..sysdatabases order by name");
            DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
            String cwdb = "";
            while (rs.next()) {
                cbm.addElement(rs.getString(1));
                cwdb = rs.getString(2);
            }
            this._dbs_cobx.setModel(cbm);
            this._dbs_cobx.setSelectedItem(cwdb);
        }
        catch (SQLException e) {
            DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>();
            cbm.addElement("Problems getting dbnames");
            this._dbs_cobx.setModel(cbm);
        }
    }

    @Override
    public Connection getConnection(String appname) {
        try {
            return AseConnectionFactory.getConnection(null, appname, null);
        }
        catch (Exception e) {
            _logger.error((Object)"Problems getting a new Connection", (Throwable)e);
            return null;
        }
    }

    private JPopupMenu createDataTablePopupMenu(JTable table) {
        _logger.debug((Object)"createDataTablePopupMenu(): called.");
        JPopupMenu popup = new JPopupMenu();
        TablePopupFactory.createCopyTable(popup);
        TablePopupFactory.createMenu(popup, "table.menu.", Configuration.getCombinedConfiguration(), table, this);
        TablePopupFactory.createMenu(popup, "QueryWindow.table.menu.", Configuration.getCombinedConfiguration(), table, this);
        if (popup.getComponentCount() == 0) {
            return null;
        }
        return popup;
    }

    public void displayQueryResults(final String sql) {
        SwingWorker w = new SwingWorker(){

            @Override
            public Object construct() {
                if (QueryWindow.this._showplan.isSelected()) {
                    new AsePlanViewer(QueryWindow.this._conn, sql);
                } else {
                    QueryWindow.this.displayQueryResults(QueryWindow.this._conn, sql);
                }
                return null;
            }
        };
        w.start();
    }

    private void putSqlWarningMsgs(ResultSet rs, ArrayList<JComponent> resultCompList, String debugStr) {
        if (rs == null) {
            return;
        }
        try {
            this.putSqlWarningMsgs(rs.getWarnings(), resultCompList, debugStr);
            rs.clearWarnings();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void putSqlWarningMsgs(Statement stmnt, ArrayList<JComponent> resultCompList, String debugStr) {
        if (stmnt == null) {
            return;
        }
        try {
            this.putSqlWarningMsgs(stmnt.getWarnings(), resultCompList, debugStr);
            stmnt.clearWarnings();
        }
        catch (SQLException e) {
            // empty catch block
        }
    }

    private void putSqlWarningMsgs(SQLException sqe, ArrayList<JComponent> resultCompList, String debugStr) {
        while (sqe != null) {
            StringBuilder sb = new StringBuilder();
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() > 10) {
                    boolean firstOnLine = true;
                    sb.append("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + ":\n");
                    if (eedi.getServerName() != null) {
                        sb.append("Server '" + eedi.getServerName() + "'");
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        sb.append((firstOnLine ? "" : ", ") + "Procedure '" + eedi.getProcedureName() + "'");
                        firstOnLine = false;
                    }
                    sb.append((firstOnLine ? "" : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + ":\n");
                }
                sb.append(sqe.getMessage() + "\n");
            } else if (!sqe.getSQLState().equals("010P4")) {
                sb.append("Unexpected exception : SqlState: " + sqe.getSQLState() + " " + sqe.toString() + ", ErrorCode: " + sqe.getErrorCode() + "\n");
            }
            if (sb.length() > 0) {
                if (sb.charAt(sb.length() - 1) == '\n') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                String aseMsg = sb.toString();
                resultCompList.add(new JAseMessage(aseMsg));
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("ASE Msg(" + debugStr + "): " + aseMsg));
                }
            }
            sqe = sqe.getNextException();
        }
    }

    private void displayQueryResults(Connection conn, String sql) {
        this._msgline.setText("Sending SQL to ASE...");
        try {
            if (conn == null) {
                throw new IllegalStateException("Connection already closed.");
            }
            Statement stmnt = conn.createStatement();
            ResultSet rs = null;
            int rowsAffected = 0;
            this._resultCompList = new ArrayList();
            _logger.debug((Object)("Executing SQL statement: " + sql));
            boolean hasRs = stmnt.execute(sql);
            this._msgline.setText("Waiting for ASE to deliver first resultset.");
            int rsCount = 0;
            do {
                this.putSqlWarningMsgs(stmnt, this._resultCompList, "-before-hasRs-");
                if (hasRs) {
                    this._msgline.setText("Reading resultset " + ++rsCount + ".");
                    rs = stmnt.getResultSet();
                    this.putSqlWarningMsgs(stmnt, this._resultCompList, "-after-getResultSet()-Statement-");
                    this.putSqlWarningMsgs(rs, this._resultCompList, "-after-getResultSet()-ResultSet-");
                    ResultSetTableModel tm = new ResultSetTableModel(rs, true);
                    for (SQLWarning sqlw : tm.getSQLWarningList()) {
                        this.putSqlWarningMsgs(sqlw, this._resultCompList, "-after-ResultSetTableModel()-tm.getSQLWarningList()-");
                    }
                    JXTable tab = new JXTable((TableModel)tm);
                    tab.setSortable(true);
                    tab.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
                    tab.packAll();
                    tab.setColumnControlVisible(true);
                    tab.setSelectionMode(0);
                    tab.setAutoResizeMode(0);
                    tab.setComponentPopupMenu(this.createDataTablePopupMenu((JTable)tab));
                    this._resultCompList.add((JComponent)tab);
                    this.putSqlWarningMsgs(stmnt, this._resultCompList, "-before-rs.close()-");
                    rs.close();
                }
                if ((rowsAffected = stmnt.getUpdateCount()) >= 0) {
                    // empty if block
                }
                hasRs = stmnt.getMoreResults();
                _logger.trace((Object)("--hasRs=" + hasRs + ", rowsAffected=" + rowsAffected));
            } while (hasRs || rowsAffected != -1);
            this.putSqlWarningMsgs(stmnt, this._resultCompList, "-before-stmnt.close()-");
            stmnt.close();
            this._resPanel.removeAll();
            int numOfTables = this.countTables(this._resultCompList);
            if (numOfTables == 1) {
                int msgCount = 0;
                int rowCount = 0;
                _logger.trace((Object)"Only 1 RS");
                this._resPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, gap 0 0, wrap 1"));
                for (JComponent jcomp : this._resultCompList) {
                    if (jcomp instanceof JTable) {
                        JTable tab = (JTable)jcomp;
                        JPanel p = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0, gap 0 0, wrap 1"));
                        p.add((Component)tab.getTableHeader(), "wrap");
                        p.add((Component)tab, "wrap");
                        _logger.trace((Object)"1-RS: add: JTable");
                        this._resPanel.add((Component)p, "");
                        rowCount = tab.getRowCount();
                        continue;
                    }
                    if (!(jcomp instanceof JAseMessage)) continue;
                    JAseMessage msg = (JAseMessage)jcomp;
                    _logger.trace((Object)("1-RS: JAseMessage: " + msg.getText()));
                    this._resPanel.add((Component)msg, "growx, pushx");
                    ++msgCount;
                }
                this._msgline.setText(" " + rowCount + " rows, and " + msgCount + " messages.");
            } else if (numOfTables > 1) {
                int msgCount = 0;
                int rowCount = 0;
                _logger.trace((Object)("Several RS: " + this._resultCompList.size()));
                if (this._rsInTabs.isSelected()) {
                    JTabbedPane tabPane = new JTabbedPane();
                    _logger.trace((Object)"JTabbedPane: add: JTabbedPane");
                    this._resPanel.add((Component)tabPane, "");
                    int i = 1;
                    for (JComponent jcomp : this._resultCompList) {
                        if (jcomp instanceof JTable) {
                            JTable tab = (JTable)jcomp;
                            JPanel p = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0, gap 0 0"));
                            p.add((Component)tab.getTableHeader(), "wrap");
                            p.add((Component)tab, "wrap");
                            _logger.trace((Object)("JTabbedPane: add: JTable(" + i + ")"));
                            tabPane.addTab("Result " + i++, p);
                            rowCount += tab.getRowCount();
                            continue;
                        }
                        if (!(jcomp instanceof JAseMessage)) continue;
                        JAseMessage msg = (JAseMessage)jcomp;
                        this._resPanel.add((Component)msg, "growx, pushx");
                        _logger.trace((Object)("JTabbedPane: JAseMessage: " + msg.getText()));
                        ++msgCount;
                    }
                    if (this._lastTabIndex > 0 && this._lastTabIndex < tabPane.getTabCount()) {
                        tabPane.setSelectedIndex(this._lastTabIndex);
                        _logger.trace((Object)("Restore last tab index pos to " + this._lastTabIndex));
                    }
                    this._msgline.setText(" " + numOfTables + " ResultSet with totally " + rowCount + " rows, and " + msgCount + " messages.");
                } else {
                    this._resPanel.setLayout((LayoutManager)new MigLayout("gapy 1, insets 0 0 0 0, wrap 1"));
                    int i = 1;
                    for (JComponent jcomp : this._resultCompList) {
                        if (jcomp instanceof JTable) {
                            JTable tab = (JTable)jcomp;
                            JPanel p = new JPanel((LayoutManager)new MigLayout("insets 0 0, gap 0 0"));
                            TitledBorder border = BorderFactory.createTitledBorder("ResultSet " + i++);
                            p.setBorder(border);
                            p.add((Component)tab.getTableHeader(), "wrap");
                            p.add((Component)tab, "wrap");
                            _logger.trace((Object)("JPane: add: JTable(" + i + ")"));
                            this._resPanel.add((Component)p, "");
                            rowCount += tab.getRowCount();
                            continue;
                        }
                        if (!(jcomp instanceof JAseMessage)) continue;
                        JAseMessage msg = (JAseMessage)jcomp;
                        _logger.trace((Object)("JPane: JAseMessage: " + msg.getText()));
                        this._resPanel.add((Component)msg, "growx, pushx");
                        ++msgCount;
                    }
                    this._msgline.setText(" " + numOfTables + " ResultSet with totally " + rowCount + " rows, and " + msgCount + " messages.");
                }
            } else {
                _logger.trace((Object)("NO RS: " + this._resultCompList.size()));
                this._resPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, wrap 1"));
                int msgCount = 0;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append("<head>");
                sb.append("<style type=\"text/css\">");
                sb.append("<!-- body {font-family: Courier New; margin: 0px} -->");
                sb.append("<!-- pre  {font-family: Courier New; margin: 0px} -->");
                sb.append("</style>");
                sb.append("</head>");
                sb.append("<body>");
                sb.append("<pre>");
                for (JComponent jcomp : this._resultCompList) {
                    if (!(jcomp instanceof JAseMessage)) continue;
                    JAseMessage msg = (JAseMessage)jcomp;
                    sb.append(msg.getText()).append("\n");
                    ++msgCount;
                }
                sb.append("</pre>");
                sb.append("</body>");
                sb.append("</html>");
                JEditorPane textPane = new JEditorPane("text/html", sb.toString());
                textPane.setEditable(false);
                textPane.setOpaque(false);
                this._resPanel.add((Component)textPane, "");
                this._msgline.setText("NO ResultSet, but " + msgCount + " messages.");
            }
        }
        catch (SQLException ex) {
            this._msgline.setText("Error: " + ex.getMessage());
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this._window, new String[]{ex.getClass().getName() + ": ", ex.getMessage()}, "Error", 0);
        }
        this._resPanel.repaint();
    }

    private int countTables(ArrayList<JComponent> list) {
        int count = 0;
        for (JComponent jcomp : list) {
            if (!(jcomp instanceof JTable)) continue;
            ++count;
        }
        return count;
    }

    public SQLException messageHandler(SQLException sqe) {
        if (sqe instanceof SQLWarning) {
            return sqe;
        }
        this.putSqlWarningMsgs(sqe, this._resultCompList, "-from-messageHandler()-");
        return null;
    }

    public static void main(String[] args) throws Exception {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "TRACE, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf = new Configuration("c:\\projects\\asemon\\asemon.properties");
        Configuration.setInstance("SYSTEM_CONF", conf);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String server = "GORAN_1_DS";
        String hostPortStr = AseConnectionFactory.getIHostPortStr(server);
        System.out.println("Connectiong to server='" + server + "'. Which is located on '" + hostPortStr + "'.");
        Connection conn = null;
        try {
            Properties props = new Properties();
            props.put("CHARSET", "iso_1");
            conn = AseConnectionFactory.getConnection(hostPortStr, null, "sa", "", Version.getAppName() + "-QueryWindow", null, props, null);
        }
        catch (SQLException e) {
            System.out.println("Problems connecting: " + AseConnectionUtils.sqlExceptionToString(e));
            throw e;
        }
        QueryWindow qf = new QueryWindow(conn, "print 'a very long string that starts here.......................and continues,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,with some more characters------------------------and some more++++++++++++++++++++++++++++++++++++ yes even more 00000 0 0 0 0 0 000000000 0 00000000 00000, lets do some more.......................... end it ends here. -END-'\nprint '11111111'\nselect getdate()\nexec sp_whoisw2\nselect \"ServerName\" = @@servername\nraiserror 123456 'A dummy message by raiserror'\nexec sp_help sysobjects\nselect \"Current Date\" = getdate()\nprint '222222222'\nselect * from master..sysdatabases\nprint '|3-33333333'\nprint '|4-33333333'\nprint '|5-33333333'\nprint '|6-33333333'\nprint '|7-33333333'\nprint '|8-33333333'\nprint '|9-33333333'\nprint '|10-33333333'\n                             exec sp_opentran \nprint '|11-33333333'\nprint '|12-33333333'\nprint '|13-33333333'\nprint '|14-33333333'\nprint '|15-33333333'\nprint '|16-33333333'\nprint '|17-33333333'\nselect * from sysobjects \nselect * from sysprocesses ", true, WindowType.JFRAME);
        qf.openTheWindow();
    }

    private class JAseMessage
    extends JTextArea {
        private static final long serialVersionUID = 1L;

        public JAseMessage(String s) {
            super(s);
            this._init();
        }

        private void _init() {
            super.setEditable(false);
            if (QueryWindow.this._aseMsgFont == null) {
                QueryWindow.this._aseMsgFont = new Font("Courier", 0, 12);
            }
            this.setFont(QueryWindow.this._aseMsgFont);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }

    public static enum WindowType {
        JFRAME,
        JDIALOG,
        JDIALOG_MODAL;

    }
}

