/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Asemon;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.cm.CountersModel;
import asemon.gui.ChangeToJTabDialog;
import asemon.gui.MainFrame;
import asemon.gui.TrendGraph;
import asemon.gui.TrendGraphDashboardPanel;
import asemon.gui.swing.AbstractComponentDecorator;
import asemon.utils.AseConnectionUtils;
import asemon.utils.Configuration;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class SummaryPanel
extends JPanel
implements TableModelListener {
    static Logger _logger = Logger.getLogger(SummaryPanel.class);
    private static final long serialVersionUID = 7555710440479350306L;
    private ChangeToJTabDialog _focusToBlockingTab = null;
    private ChangeToJTabDialog _focusToDatabasesTab = null;
    private Watermark _watermark;
    private JPanel _clusterInfoPanel;
    private JPanel _serverInfoPanel;
    private JPanel _dataPanel;
    private JScrollPane _dataPanelScroll;
    private TrendGraphDashboardPanel _graphPanel;
    private JScrollPane _graphPanelScroll;
    private JLabel _title_lbl = new JLabel();
    private JButton _trendGraphs_but = new JButton();
    private JTextField _clusterBootTime_txt = new JTextField();
    private JLabel _clusterBootTime_lbl = new JLabel();
    private JTextField _clusterName_txt = new JTextField();
    private JLabel _clusterName_lbl = new JLabel();
    private JLabel _clusterInstance_lbl = new JLabel();
    private JTextField _clusterInstanceName_txt = new JTextField();
    private JTextField _clusterInstanceId_txt = new JTextField();
    private JLabel _clusterCoordinator_lbl = new JLabel();
    private JTextField _clusterCoordinatorName_txt = new JTextField();
    private JTextField _clusterCoordinatorId_txt = new JTextField();
    private JComboBox _clusterView_cbx = new JComboBox<String>(new String[]{"cluster", "instance"});
    private JLabel _clusterView_lbl = new JLabel();
    private JTextField _localServerName_txt = new JTextField();
    private JLabel _localServerName_lbl = new JLabel();
    private JTextField _atAtServerName_txt = new JTextField();
    private JLabel _atAtServerName_lbl = new JLabel();
    private JTextField _listeners_txt = new JTextField();
    private JLabel _listeners_lbl = new JLabel();
    private JTextField _aseVersion_txt = new JTextField();
    private JLabel _aseVersion_lbl = new JLabel();
    private JTextField _lastSampleTime_txt = new JTextField();
    private JLabel _lastSampleTime_lbl = new JLabel();
    private JTextField _startDate_txt = new JTextField();
    private JLabel _startDate_lbl = new JLabel();
    private JTextField _daysRunning_txt = new JTextField();
    private JLabel _daysRunning_lbl = new JLabel();
    private JTextField _countersCleared_txt = new JTextField();
    private JLabel _countersCleared_lbl = new JLabel();
    private JTextField _checkPoints_txt = new JTextField();
    private JLabel _checkPoints_lbl = new JLabel();
    private JTextField _numDeadlocks_txt = new JTextField();
    private JTextField _numDeadlocksDiff_txt = new JTextField();
    private JLabel _numDeadlocks_lbl = new JLabel();
    private JTextField _diagnosticDumps_txt = new JTextField();
    private JLabel _diagnosticDumps_lbl = new JLabel();
    private JTextField _connectionsDiff_txt = new JTextField();
    private JTextField _connections_txt = new JTextField();
    private JLabel _connections_lbl = new JLabel();
    private JTextField _distinctLoginsDiff_txt = new JTextField();
    private JTextField _distinctLoginsAbs_txt = new JTextField();
    private JLabel _distinctLogins_lbl = new JLabel();
    private JTextField _lockWaitThreshold_txt = new JTextField();
    private JLabel _lockWaitThreshold_lbl = new JLabel();
    private JTextField _lockWaits_txt = new JTextField();
    private JTextField _lockWaitsDiff_txt = new JTextField();
    private JLabel _lockWaits_lbl = new JLabel();
    private JTextField _maxRecovery_txt = new JTextField();
    private JLabel _maxRecovery_lbl = new JLabel();
    private JLabel _transactions_lbl = new JLabel();
    private JTextField _transactions_txt = new JTextField();
    private JTextField _transactionsDiff_txt = new JTextField();
    private JTextField _transactionsRate_txt = new JTextField();
    private JLabel _fullTranslog_lbl = new JLabel();
    private JTextField _fullTranslog_txt = new JTextField();
    private JLabel _bootcount_lbl = new JLabel();
    private JTextField _bootcount_txt = new JTextField();
    private JLabel _recoveryState_lbl = new JLabel();
    private JTextField _recoveryState_txt = new JTextField();
    private JLabel _cpuTime_lbl = new JLabel();
    private JTextField _cpuTime_txt = new JTextField();
    private JLabel _cpuUser_lbl = new JLabel();
    private JTextField _cpuUser_txt = new JTextField();
    private JLabel _cpuSystem_lbl = new JLabel();
    private JTextField _cpuSystem_txt = new JTextField();
    private JLabel _cpuIdle_lbl = new JLabel();
    private JTextField _cpuIdle_txt = new JTextField();
    private JLabel _ioTotalRead_lbl = new JLabel();
    private JTextField _ioTotalRead_txt = new JTextField();
    private JTextField _ioTotalReadDiff_txt = new JTextField();
    private JLabel _ioTotalWrite_lbl = new JLabel();
    private JTextField _ioTotalWrite_txt = new JTextField();
    private JTextField _ioTotalWriteDiff_txt = new JTextField();
    private JLabel _aaConnections_lbl = new JLabel();
    private JTextField _aaConnectionsAbs_txt = new JTextField();
    private JTextField _aaConnectionsDiff_txt = new JTextField();
    private JTextField _aaConnectionsRate_txt = new JTextField();
    private JLabel _packReceived_lbl = new JLabel();
    private JTextField _packReceived_txt = new JTextField();
    private JTextField _packReceivedDiff_txt = new JTextField();
    private JLabel _packSent_lbl = new JLabel();
    private JTextField _packSent_txt = new JTextField();
    private JTextField _packSentDiff_txt = new JTextField();
    private JLabel _packetErrors_lbl = new JLabel();
    private JTextField _packetErrors_txt = new JTextField();
    private JTextField _packetErrorsDiff_txt = new JTextField();
    private JLabel _totalErrors_lbl = new JLabel();
    private JTextField _totalErrors_txt = new JTextField();
    private JTextField _totalErrorsDiff_txt = new JTextField();
    private static SummaryPanel _instance = null;
    public static final String CM_NAME = "CMsummary";

    @Override
    public String getName() {
        return CM_NAME;
    }

    public static SummaryPanel getInstance() {
        if (_instance == null) {
            _instance = new SummaryPanel();
        }
        return _instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public static void setInstance(SummaryPanel sumPanel) {
        _instance = sumPanel;
    }

    public SummaryPanel() {
        _instance = this;
        try {
            this.initComponents();
        }
        catch (Exception ex) {
            _logger.error((Object)"Cant create the summary panel", (Throwable)ex);
        }
    }

    private void initComponents() throws Exception {
        this.setLayout(new BorderLayout());
        this._graphPanel = this.createGraphPanel();
        this._dataPanel = this.createDataPanel();
        this._graphPanelScroll = new JScrollPane(this._graphPanel);
        this._dataPanelScroll = new JScrollPane(this._dataPanel, 20, 31);
        this._graphPanelScroll.getVerticalScrollBar().setUnitIncrement(16);
        this._dataPanelScroll.getVerticalScrollBar().setUnitIncrement(16);
        JSplitPane split = new JSplitPane(1, this._dataPanelScroll, this._graphPanelScroll);
        this.add((Component)split, "Center");
        this._watermark = new Watermark(this._graphPanelScroll, "Not Connected...");
        this.loadProps();
        this.initComponentActions();
    }

    private void initComponentActions() throws Exception {
        this._clusterView_cbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String choice = (String)SummaryPanel.this._clusterView_cbx.getSelectedItem();
                int systemView = 0;
                systemView = choice != null && choice.equalsIgnoreCase("instance") ? 2 : 1;
                if (Asemon.getCounterCollector().isMonConnected()) {
                    AseConnectionUtils.setClusterEditionSystemView(Asemon.getCounterCollector().getMonConnection(), systemView);
                }
                SummaryPanel.this.saveProps();
            }
        });
    }

    private JPanel createDataPanel() {
        JPanel panel = SwingUtils.createPanel("title", false);
        panel.setLayout((LayoutManager)new MigLayout("", "5[grow]5", ""));
        this._title_lbl.setFont(new Font("Dialog", 1, 16));
        this._title_lbl.setText("Summary panel");
        this._clusterInfoPanel = this.createClusterInfoPanel();
        this._serverInfoPanel = this.createServerInfoPanel();
        TrendGraph.createGraphAccessButton(this._trendGraphs_but, CM_NAME);
        panel.add((Component)this._title_lbl, "pushx, growx, left, split");
        panel.add((Component)this._trendGraphs_but, "top, wrap");
        panel.add((Component)this._clusterInfoPanel, "growx, width 275lp, hidemode 3, wrap");
        panel.add((Component)this._serverInfoPanel, "growx, width 275lp,             wrap");
        return panel;
    }

    private JPanel createClusterInfoPanel() {
        JPanel panel = SwingUtils.createPanel("Cluster Information", true);
        panel.setLayout((LayoutManager)new MigLayout("", "[] [grow]", ""));
        String tooltip = "";
        tooltip = "The ASE Cluster was booted/started at this time. (select @@clusterboottime)";
        this._clusterBootTime_lbl.setText("Cluster Boot Time");
        this._clusterBootTime_lbl.setToolTipText(tooltip);
        this._clusterBootTime_txt.setToolTipText(tooltip);
        this._clusterBootTime_txt.setEditable(false);
        tooltip = "The ASE Cluster Name we are connected to. (select @@clustername)";
        this._clusterName_lbl.setText("Cluster Name");
        this._clusterName_lbl.setToolTipText(tooltip);
        this._clusterName_txt.setToolTipText(tooltip);
        this._clusterName_txt.setEditable(false);
        tooltip = "The ASE Cluster Instance Name and ID we are connected to. (select @@instancename, @@instanceid)";
        this._clusterInstance_lbl.setText("Instance Name, Id");
        this._clusterInstance_lbl.setToolTipText(tooltip);
        this._clusterInstanceName_txt.setToolTipText(tooltip);
        this._clusterInstanceName_txt.setEditable(false);
        this._clusterInstanceId_txt.setToolTipText(tooltip);
        this._clusterInstanceId_txt.setEditable(false);
        tooltip = "The ASE Cluster Coordinator Name and ID. (select instance_name(@@clustercoordid), @@clustercoordid)";
        this._clusterCoordinator_lbl.setText("Coordinator Name, Id");
        this._clusterCoordinator_lbl.setToolTipText(tooltip);
        this._clusterCoordinatorName_txt.setToolTipText(tooltip);
        this._clusterCoordinatorName_txt.setEditable(false);
        this._clusterCoordinatorId_txt.setToolTipText(tooltip);
        this._clusterCoordinatorId_txt.setEditable(false);
        tooltip = "<html>View counters for the whole Cluster or just the instance we connected to. (set system_view cluster|instance)<ul><li>cluster - Show Counters for <b>all instances</b> within the cluster.</li><li>instance - Only Counters for the <b>local instance</b> is showed.</li></ul></html>";
        this._clusterView_lbl.setText("System View");
        this._clusterView_lbl.setToolTipText(tooltip);
        this._clusterView_cbx.setToolTipText(tooltip);
        panel.add((Component)this._clusterBootTime_lbl, "");
        panel.add((Component)this._clusterBootTime_txt, "growx, wrap");
        panel.add((Component)this._clusterName_lbl, "");
        panel.add((Component)this._clusterName_txt, "growx, wrap");
        panel.add((Component)this._clusterInstance_lbl, "");
        panel.add((Component)this._clusterInstanceName_txt, "growx, split");
        panel.add((Component)this._clusterInstanceId_txt, "growx, wrap");
        panel.add((Component)this._clusterCoordinator_lbl, "");
        panel.add((Component)this._clusterCoordinatorName_txt, "growx, split");
        panel.add((Component)this._clusterCoordinatorId_txt, "growx, wrap");
        panel.add((Component)this._clusterView_lbl, "");
        panel.add((Component)this._clusterView_cbx, "growx, wrap");
        panel.setVisible(false);
        return panel;
    }

    private JPanel createServerInfoPanel() {
        JPanel panel = SwingUtils.createPanel("Server Information", true);
        panel.setLayout((LayoutManager)new MigLayout("", "[] [grow]", ""));
        String tooltip = "";
        tooltip = "The name we used when ASEmon connected to the server, meaning name in sql.ini or inetfaces ";
        this._localServerName_lbl.setText("Local server name");
        this._localServerName_lbl.setToolTipText(tooltip);
        this._localServerName_txt.setToolTipText(tooltip);
        this._localServerName_txt.setEditable(false);
        tooltip = "This is the internal server name in the ASE, taken from the global variable @@servername";
        this._atAtServerName_lbl.setText("@@servername");
        this._atAtServerName_lbl.setToolTipText(tooltip);
        this._atAtServerName_txt.setToolTipText(tooltip);
        this._atAtServerName_txt.setEditable(false);
        tooltip = "Hostname that the ASE server has listener services on, this makes it easier to see what physical machine we have connected to.";
        this._listeners_lbl.setText("ASE Port listeners");
        this._listeners_lbl.setToolTipText(tooltip);
        this._listeners_txt.setToolTipText(tooltip);
        this._listeners_txt.setEditable(false);
        tooltip = "The version string taken from @@version";
        this._aseVersion_lbl.setText("ASE Version");
        this._aseVersion_lbl.setToolTipText(tooltip);
        this._aseVersion_txt.setToolTipText(tooltip);
        this._aseVersion_txt.setEditable(false);
        tooltip = "Time of list sample.";
        this._lastSampleTime_lbl.setText("Sample time");
        this._lastSampleTime_lbl.setToolTipText(tooltip);
        this._lastSampleTime_txt.setToolTipText(tooltip);
        this._lastSampleTime_txt.setEditable(false);
        tooltip = "Date and time that the ASE was started.";
        this._startDate_lbl.setText("Start date");
        this._startDate_lbl.setToolTipText(tooltip);
        this._startDate_txt.setToolTipText(tooltip);
        this._startDate_txt.setEditable(false);
        tooltip = "Number of days that the ASE has been running for.";
        this._daysRunning_lbl.setText("Days running");
        this._daysRunning_lbl.setToolTipText(tooltip);
        this._daysRunning_txt.setToolTipText(tooltip);
        this._daysRunning_txt.setEditable(false);
        tooltip = "Date and time at which the monitor counters were last cleared.";
        this._countersCleared_lbl.setText("Counters clear date");
        this._countersCleared_lbl.setToolTipText(tooltip);
        this._countersCleared_txt.setToolTipText(tooltip);
        this._countersCleared_txt.setEditable(false);
        tooltip = "Whether any checkpoint is currently running.";
        this._checkPoints_lbl.setText("Running checkpoint");
        this._checkPoints_lbl.setToolTipText(tooltip);
        this._checkPoints_txt.setToolTipText(tooltip);
        this._checkPoints_txt.setEditable(false);
        tooltip = "Total number of deadlocks that have occurred.";
        this._numDeadlocks_lbl.setText("Number of deadlock");
        this._numDeadlocks_lbl.setToolTipText(tooltip);
        this._numDeadlocks_txt.setToolTipText(tooltip);
        this._numDeadlocks_txt.setEditable(false);
        this._numDeadlocksDiff_txt.setEditable(false);
        this._numDeadlocksDiff_txt.setToolTipText("The difference since previous sample.");
        tooltip = "Whether the Sybmon diagnostic utility is performing a shared memory dump.";
        this._diagnosticDumps_lbl.setText("Diagnostics Dumps");
        this._diagnosticDumps_lbl.setToolTipText(tooltip);
        this._diagnosticDumps_txt.setToolTipText(tooltip);
        this._diagnosticDumps_txt.setEditable(false);
        tooltip = "Number of active inbound connections.";
        this._connections_lbl.setText("Connections");
        this._connections_lbl.setToolTipText(tooltip);
        this._connections_txt.setToolTipText(tooltip);
        this._connections_txt.setEditable(false);
        this._connectionsDiff_txt.setEditable(false);
        this._connectionsDiff_txt.setToolTipText("The difference since previous sample.");
        tooltip = "Number of distinct User Names that is logged in to ASE.";
        this._distinctLogins_lbl.setText("Distinct Logins");
        this._distinctLogins_lbl.setToolTipText(tooltip);
        this._distinctLoginsAbs_txt.setToolTipText(tooltip);
        this._distinctLoginsAbs_txt.setEditable(false);
        this._distinctLoginsDiff_txt.setEditable(false);
        this._distinctLoginsDiff_txt.setToolTipText("The difference since previous sample.");
        tooltip = "Time (in seconds) that processes must have waited for locks in order to be reported.";
        this._lockWaitThreshold_lbl.setText("Lock wait threshold");
        this._lockWaitThreshold_lbl.setToolTipText(tooltip);
        this._lockWaitThreshold_txt.setToolTipText(tooltip);
        this._lockWaitThreshold_txt.setEditable(false);
        tooltip = "Number of processes that have waited longer than LockWaitThreshold seconds.";
        this._lockWaits_lbl.setText("Lock waits");
        this._lockWaits_lbl.setToolTipText(tooltip);
        this._lockWaits_txt.setToolTipText(tooltip);
        this._lockWaits_txt.setEditable(false);
        this._lockWaitsDiff_txt.setEditable(false);
        this._lockWaitsDiff_txt.setToolTipText("The difference since previous sample.");
        tooltip = "The maximum time (in minutes), per database, that ASE uses to complete its recovery procedures in case of a system failure, the current 'Run Value' for the 'recovery interval in minutes' configuration option.";
        this._maxRecovery_lbl.setText("Max recovery");
        this._maxRecovery_lbl.setToolTipText(tooltip);
        this._maxRecovery_txt.setToolTipText(tooltip);
        this._maxRecovery_txt.setEditable(false);
        tooltip = "Number of transactions executed (abs, diff, rate), Only available from 15.0.3 CE or 15.5 (not to be trusted in a Cluster Server).";
        this._transactions_lbl.setText("Transactions");
        this._transactions_lbl.setToolTipText(tooltip);
        this._transactions_txt.setToolTipText(tooltip);
        this._transactions_txt.setEditable(false);
        this._transactionsDiff_txt.setEditable(false);
        this._transactionsDiff_txt.setToolTipText(tooltip);
        this._transactionsRate_txt.setEditable(false);
        this._transactionsRate_txt.setToolTipText(tooltip);
        tooltip = "Number of databases that has a full transaction log, which probably means suspended SPID's.";
        this._fullTranslog_lbl.setText("Full Transaction Logs");
        this._fullTranslog_lbl.setToolTipText(tooltip);
        this._fullTranslog_txt.setToolTipText(tooltip);
        this._fullTranslog_txt.setEditable(false);
        tooltip = "How many times has this ASE been rebooted.";
        this._bootcount_lbl.setText("Boot Count");
        this._bootcount_lbl.setToolTipText(tooltip);
        this._bootcount_txt.setToolTipText(tooltip);
        this._bootcount_txt.setEditable(false);
        tooltip = "If the ASE is in-recovery, this would be the reason.";
        this._recoveryState_lbl.setText("Recovery State");
        this._recoveryState_lbl.setToolTipText(tooltip);
        this._recoveryState_txt.setToolTipText(tooltip);
        this._recoveryState_txt.setEditable(false);
        tooltip = "CPU Time. Global variable @@cpu_busy + @@io_busy.";
        this._cpuTime_lbl.setText("CPU Time/User/Sys");
        this._cpuTime_lbl.setToolTipText(tooltip);
        this._cpuTime_txt.setToolTipText(tooltip);
        this._cpuTime_txt.setEditable(false);
        tooltip = "CPU Busy. Global variable @@cpu_busy.";
        this._cpuUser_lbl.setText("CPU User");
        this._cpuUser_lbl.setToolTipText(tooltip);
        this._cpuUser_txt.setToolTipText(tooltip);
        this._cpuUser_txt.setEditable(false);
        tooltip = "CPU spent in IO. Global variable @@io_busy.";
        this._cpuSystem_lbl.setText("CPU System");
        this._cpuSystem_lbl.setToolTipText(tooltip);
        this._cpuSystem_txt.setToolTipText(tooltip);
        this._cpuSystem_txt.setEditable(false);
        tooltip = "CPU Idle. Global variable @@idle.";
        this._cpuIdle_lbl.setText("CPU Idle");
        this._cpuIdle_lbl.setToolTipText(tooltip);
        this._cpuIdle_txt.setToolTipText(tooltip);
        this._cpuIdle_txt.setEditable(false);
        tooltip = "Total Read IO's. Global variable @@total_read.";
        this._ioTotalRead_lbl.setText("IO Read");
        this._ioTotalRead_lbl.setToolTipText(tooltip);
        this._ioTotalRead_txt.setToolTipText(tooltip);
        this._ioTotalRead_txt.setEditable(false);
        this._ioTotalReadDiff_txt.setEditable(false);
        this._ioTotalReadDiff_txt.setToolTipText(tooltip);
        tooltip = "Total Write IO's. Global variable @@total_write.";
        this._ioTotalWrite_lbl.setText("IO Write");
        this._ioTotalWrite_lbl.setToolTipText(tooltip);
        this._ioTotalWrite_txt.setToolTipText(tooltip);
        this._ioTotalWrite_txt.setEditable(false);
        this._ioTotalWriteDiff_txt.setEditable(false);
        this._ioTotalWriteDiff_txt.setToolTipText(tooltip);
        tooltip = "Total Connection that was attemped to make to the ASE Server, even those that failes. Global variable @@connections. (abs/diff/rate)";
        this._aaConnections_lbl.setText("Connections Tried");
        this._aaConnections_lbl.setToolTipText(tooltip);
        this._aaConnectionsAbs_txt.setEditable(false);
        this._aaConnectionsAbs_txt.setToolTipText(tooltip);
        this._aaConnectionsDiff_txt.setEditable(false);
        this._aaConnectionsDiff_txt.setToolTipText(tooltip);
        this._aaConnectionsRate_txt.setEditable(false);
        this._aaConnectionsRate_txt.setToolTipText(tooltip);
        tooltip = "Total Network Packets Received. Global variable @@pack_received.";
        this._packReceived_lbl.setText("NW Packet Received");
        this._packReceived_lbl.setToolTipText(tooltip);
        this._packReceived_txt.setToolTipText(tooltip);
        this._packReceived_txt.setEditable(false);
        this._packReceivedDiff_txt.setEditable(false);
        this._packReceivedDiff_txt.setToolTipText(tooltip);
        tooltip = "Total Network Packets Sent. Global variable @@pack_sent.";
        this._packSent_lbl.setText("NW Packet Sent");
        this._packSent_lbl.setToolTipText(tooltip);
        this._packSent_txt.setToolTipText(tooltip);
        this._packSent_txt.setEditable(false);
        this._packSentDiff_txt.setEditable(false);
        this._packSentDiff_txt.setToolTipText(tooltip);
        tooltip = "Total Network Packets Errors. Global variable @@packet_errors.";
        this._packetErrors_lbl.setText("NW Packet Errors");
        this._packetErrors_lbl.setToolTipText(tooltip);
        this._packetErrors_txt.setToolTipText(tooltip);
        this._packetErrors_txt.setEditable(false);
        this._packetErrorsDiff_txt.setEditable(false);
        this._packetErrorsDiff_txt.setToolTipText(tooltip);
        tooltip = "Total Errors. Global variable @@total_errors.";
        this._totalErrors_lbl.setText("Total Errors");
        this._totalErrors_lbl.setToolTipText(tooltip);
        this._totalErrors_txt.setToolTipText(tooltip);
        this._totalErrors_txt.setEditable(false);
        this._totalErrorsDiff_txt.setEditable(false);
        this._totalErrorsDiff_txt.setToolTipText(tooltip);
        panel.add((Component)this._localServerName_lbl, "");
        panel.add((Component)this._localServerName_txt, "growx, wrap");
        panel.add((Component)this._atAtServerName_lbl, "");
        panel.add((Component)this._atAtServerName_txt, "growx, wrap");
        panel.add((Component)this._listeners_lbl, "");
        panel.add((Component)this._listeners_txt, "growx, wrap");
        panel.add((Component)this._aseVersion_lbl, "");
        panel.add((Component)this._aseVersion_txt, "growx, wrap");
        panel.add((Component)this._lastSampleTime_lbl, "");
        panel.add((Component)this._lastSampleTime_txt, "growx, wrap");
        panel.add((Component)this._startDate_lbl, "gapy 20");
        panel.add((Component)this._startDate_txt, "growx, wrap");
        panel.add((Component)this._daysRunning_lbl, "");
        panel.add((Component)this._daysRunning_txt, "growx, wrap");
        panel.add((Component)this._countersCleared_lbl, "");
        panel.add((Component)this._countersCleared_txt, "growx, wrap");
        panel.add((Component)this._checkPoints_lbl, "");
        panel.add((Component)this._checkPoints_txt, "growx, wrap");
        panel.add((Component)this._numDeadlocks_lbl, "");
        panel.add((Component)this._numDeadlocks_txt, "growx, split");
        panel.add((Component)this._numDeadlocksDiff_txt, "growx, wrap");
        panel.add((Component)this._diagnosticDumps_lbl, "");
        panel.add((Component)this._diagnosticDumps_txt, "growx, wrap");
        panel.add((Component)this._connections_lbl, "");
        panel.add((Component)this._connections_txt, "growx, split");
        panel.add((Component)this._connectionsDiff_txt, "growx, wrap");
        panel.add((Component)this._distinctLogins_lbl, "");
        panel.add((Component)this._distinctLoginsAbs_txt, "growx, split");
        panel.add((Component)this._distinctLoginsDiff_txt, "growx, wrap");
        panel.add((Component)this._lockWaitThreshold_lbl, "");
        panel.add((Component)this._lockWaitThreshold_txt, "growx, wrap");
        panel.add((Component)this._lockWaits_lbl, "");
        panel.add((Component)this._lockWaits_txt, "growx, split");
        panel.add((Component)this._lockWaitsDiff_txt, "growx, wrap");
        panel.add((Component)this._maxRecovery_lbl, "");
        panel.add((Component)this._maxRecovery_txt, "growx, wrap");
        panel.add((Component)this._transactions_lbl, "");
        panel.add((Component)this._transactions_txt, "growx, split");
        panel.add((Component)this._transactionsDiff_txt, "growx, split");
        panel.add((Component)this._transactionsRate_txt, "growx, wrap");
        panel.add((Component)this._fullTranslog_lbl, "");
        panel.add((Component)this._fullTranslog_txt, "growx, wrap");
        panel.add((Component)this._bootcount_lbl, "gapy 20");
        panel.add((Component)this._bootcount_txt, "growx, wrap");
        panel.add((Component)this._recoveryState_lbl, "");
        panel.add((Component)this._recoveryState_txt, "growx, wrap");
        panel.add((Component)this._cpuTime_lbl, "");
        panel.add((Component)this._cpuTime_txt, "growx, split");
        panel.add((Component)this._cpuUser_txt, "growx, split");
        panel.add((Component)this._cpuSystem_txt, "growx, wrap");
        panel.add((Component)this._cpuIdle_lbl, "");
        panel.add((Component)this._cpuIdle_txt, "growx, wrap");
        panel.add((Component)this._ioTotalRead_lbl, "");
        panel.add((Component)this._ioTotalRead_txt, "growx, split");
        panel.add((Component)this._ioTotalReadDiff_txt, "growx, wrap");
        panel.add((Component)this._ioTotalWrite_lbl, "");
        panel.add((Component)this._ioTotalWrite_txt, "growx, split");
        panel.add((Component)this._ioTotalWriteDiff_txt, "growx, wrap");
        panel.add((Component)this._aaConnections_lbl, "");
        panel.add((Component)this._aaConnectionsAbs_txt, "growx, split");
        panel.add((Component)this._aaConnectionsDiff_txt, "growx, split");
        panel.add((Component)this._aaConnectionsRate_txt, "growx, wrap");
        panel.add((Component)this._packReceived_lbl, "");
        panel.add((Component)this._packReceived_txt, "growx, split");
        panel.add((Component)this._packReceivedDiff_txt, "growx, wrap");
        panel.add((Component)this._packSent_lbl, "");
        panel.add((Component)this._packSent_txt, "growx, split");
        panel.add((Component)this._packSentDiff_txt, "growx, wrap");
        panel.add((Component)this._packetErrors_lbl, "");
        panel.add((Component)this._packetErrors_txt, "growx, split");
        panel.add((Component)this._packetErrorsDiff_txt, "growx, wrap");
        panel.add((Component)this._totalErrors_lbl, "");
        panel.add((Component)this._totalErrors_txt, "growx, split");
        panel.add((Component)this._totalErrorsDiff_txt, "growx, wrap");
        return panel;
    }

    private TrendGraphDashboardPanel createGraphPanel() {
        return new TrendGraphDashboardPanel();
    }

    public TrendGraphDashboardPanel getGraphPanel() {
        return this._graphPanel;
    }

    public void clearGraph() {
        this._graphPanel.clearGraph();
    }

    public void addTrendGraph(TrendGraph tg) {
        this._graphPanel.add(tg);
    }

    public void setLocalServerName(String name) {
        this._localServerName_txt.setText(name);
        this._localServerName_txt.setCaretPosition(0);
    }

    public String getLocalServerName() {
        return this._localServerName_txt.getText();
    }

    public String getCountersCleared() {
        return this._countersCleared_txt.getText();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Object source = e.getSource();
        int column = e.getColumn();
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        int type = e.getType();
        if (column != -1 || firstRow != -1 || lastRow == -1) {
            // empty if block
        }
        if (MainFrame.isInMemoryViewOn()) {
            return;
        }
        CountersModel cm = GetCounters.getCmByName(CM_NAME);
        if (cm != null && cm.hasAbsData()) {
            this.setSummaryData(cm);
        }
    }

    private void refreshClusterInfo() {
        Connection conn = Asemon.getCounterCollector().getMonConnection();
        int clusterView = AseConnectionUtils.getClusterEditionSystemView(conn);
        if (clusterView == 1) {
            this._clusterView_cbx.setSelectedItem("cluster");
        }
        if (clusterView == 2) {
            this._clusterView_cbx.setSelectedItem("instance");
        }
        String sql = "select @@clusterboottime, @@clustername, @@instanceid, @@instancename, @@clustercoordid, instance_name(@@clustercoordid)";
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                this._clusterBootTime_txt.setText(rs.getString(1));
                this._clusterName_txt.setText(rs.getString(2));
                this._clusterInstanceId_txt.setText(rs.getString(3));
                this._clusterInstanceName_txt.setText(rs.getString(4));
                this._clusterCoordinatorId_txt.setText(rs.getString(5));
                this._clusterCoordinatorName_txt.setText(rs.getString(6));
            }
            rs.close();
            stmnt.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql: " + sql), (Throwable)e);
        }
        if (!"".equals(this._clusterName_txt.getText())) {
            this._clusterInfoPanel.setVisible(true);
        }
    }

    public void setSummaryData(CountersModel cm) {
        this.setWatermark();
        String clusterId = cm.getAbsString(0, "clusterInstanceId");
        String currClusterName = this._clusterInstanceName_txt.getText();
        if (clusterId != null && currClusterName.equals("") && MonTablesDictionary.getInstance() != null && MonTablesDictionary.getInstance().isClusterEnabled) {
            this.refreshClusterInfo();
        }
        this._atAtServerName_txt.setText(cm.getAbsString(0, "atAtServerName"));
        this._listeners_txt.setText(cm.getAbsString(0, "NetworkAddressInfo"));
        this._listeners_txt.setCaretPosition(0);
        this._aseVersion_txt.setText(cm.getAbsString(0, "aseVersion").replaceFirst("Adaptive Server Enterprise/", ""));
        this._aseVersion_txt.setCaretPosition(0);
        this._lastSampleTime_txt.setText(cm.getAbsString(0, "timeIsNow"));
        this._startDate_txt.setText(cm.getAbsString(0, "StartDate"));
        this._daysRunning_txt.setText(cm.getAbsString(0, "DaysRunning"));
        this._countersCleared_txt.setText(cm.getAbsString(0, "CountersCleared"));
        this._checkPoints_txt.setText(cm.getAbsString(0, "CheckPoints"));
        this._numDeadlocks_txt.setText(cm.getAbsString(0, "NumDeadlocks"));
        this._numDeadlocksDiff_txt.setText(cm.getDiffString(0, "NumDeadlocks"));
        this._diagnosticDumps_txt.setText(cm.getAbsString(0, "DiagnosticDumps"));
        this._connections_txt.setText(cm.getAbsString(0, "Connections"));
        this._connectionsDiff_txt.setText(cm.getDiffString(0, "Connections"));
        this._distinctLoginsAbs_txt.setText(cm.getAbsString(0, "distinctLogins"));
        this._distinctLoginsDiff_txt.setText(cm.getDiffString(0, "distinctLogins"));
        this._lockWaitThreshold_txt.setText(cm.getAbsString(0, "LockWaitThreshold"));
        this._lockWaits_txt.setText(cm.getAbsString(0, "LockWaits"));
        this._lockWaitsDiff_txt.setText(cm.getDiffString(0, "LockWaits"));
        this._maxRecovery_txt.setText(cm.getAbsString(0, "MaxRecovery"));
        if (cm.findColumn("Transactions") >= 0) {
            this._transactions_txt.setText(cm.getAbsString(0, "Transactions"));
            this._transactionsDiff_txt.setText(cm.getDiffString(0, "Transactions"));
            this._transactionsRate_txt.setText(cm.getRateString(0, "Transactions"));
        } else {
            this._transactions_txt.setText("Not available");
            this._transactionsDiff_txt.setText("");
            this._transactionsRate_txt.setText("");
        }
        this._fullTranslog_txt.setText(cm.getAbsString(0, "fullTranslogCount"));
        this._bootcount_txt.setText(cm.getAbsString(0, "bootcount"));
        this._recoveryState_txt.setText(cm.getAbsString(0, "recovery_state"));
        this._ioTotalRead_txt.setText(cm.getAbsString(0, "io_total_read"));
        this._ioTotalReadDiff_txt.setText(cm.getRateString(0, "io_total_read"));
        this._ioTotalWrite_txt.setText(cm.getAbsString(0, "io_total_write"));
        this._ioTotalWriteDiff_txt.setText(cm.getRateString(0, "io_total_write"));
        this._aaConnectionsAbs_txt.setText(cm.getAbsString(0, "aaConnections"));
        this._aaConnectionsDiff_txt.setText(cm.getDiffString(0, "aaConnections"));
        this._aaConnectionsRate_txt.setText(cm.getRateString(0, "aaConnections"));
        this._packReceived_txt.setText(cm.getAbsString(0, "pack_received"));
        this._packReceivedDiff_txt.setText(cm.getRateString(0, "pack_received"));
        this._packSent_txt.setText(cm.getAbsString(0, "pack_sent"));
        this._packSentDiff_txt.setText(cm.getRateString(0, "pack_sent"));
        this._packetErrors_txt.setText(cm.getAbsString(0, "packet_errors"));
        this._packetErrorsDiff_txt.setText(cm.getDiffString(0, "packet_errors"));
        this._totalErrors_txt.setText(cm.getAbsString(0, "total_errors"));
        this._totalErrorsDiff_txt.setText(cm.getDiffString(0, "total_errors"));
        Double cpuUser = cm.getDiffValueAsDouble(0, "cpu_busy");
        Double cpuSystem = cm.getDiffValueAsDouble(0, "cpu_io");
        Double cpuIdle = cm.getDiffValueAsDouble(0, "cpu_idle");
        if (cpuUser != null && cpuSystem != null && cpuIdle != null) {
            double CPUTime = cpuUser + cpuSystem + cpuIdle;
            double CPUUser = cpuUser;
            double CPUSystem = cpuSystem;
            double CPUIdle = cpuIdle;
            BigDecimal calcCPUTime = new BigDecimal(1.0 * (CPUUser + CPUSystem) / CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcUserCPUTime = new BigDecimal(1.0 * CPUUser / CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcSystemCPUTime = new BigDecimal(1.0 * CPUSystem / CPUTime * 100.0).setScale(1, 6);
            BigDecimal calcIdleCPUTime = new BigDecimal(1.0 * CPUIdle / CPUTime * 100.0).setScale(1, 6);
            this._cpuTime_txt.setText(calcCPUTime.toString());
            this._cpuUser_txt.setText(calcUserCPUTime.toString());
            this._cpuSystem_txt.setText(calcSystemCPUTime.toString());
            this._cpuIdle_txt.setText(calcIdleCPUTime.toString());
        }
        int lockWaits = 0;
        try {
            lockWaits = Integer.parseInt(this._lockWaits_txt.getText());
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        _logger.debug((Object)("LOCK-WAITS=" + lockWaits + ", TEXT='" + this._lockWaits_txt.getText() + "'."));
        if (lockWaits > 0) {
            MainFrame.getInstance().setBlockingLocks(true, lockWaits);
            String toTabName = "Blocking";
            if (this._focusToBlockingTab == null) {
                this._focusToBlockingTab = new ChangeToJTabDialog((Frame)MainFrame.getInstance(), "Found Blocking Locks in the ASE Server", MainFrame.getTabbedPane(), toTabName);
            }
            this._focusToBlockingTab.setVisible(true);
        } else {
            MainFrame.getInstance().setBlockingLocks(false, 0);
        }
        int fullLogs = 0;
        try {
            fullLogs = Integer.parseInt(this._fullTranslog_txt.getText());
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        _logger.debug((Object)("FULL-LOG=" + lockWaits + ", TEXT='" + this._fullTranslog_txt.getText() + "'."));
        if (fullLogs > 0) {
            MainFrame.getInstance().setFullTransactionLog(true, fullLogs);
            String toTabName = "Databases";
            if (this._focusToDatabasesTab == null) {
                this._focusToDatabasesTab = new ChangeToJTabDialog((Frame)MainFrame.getInstance(), "Found Full Database Transaction Logs in the ASE Server", MainFrame.getTabbedPane(), toTabName);
            }
            this._focusToDatabasesTab.setVisible(true);
        } else {
            MainFrame.getInstance().setFullTransactionLog(false, 0);
        }
    }

    public synchronized void clearSummaryData() {
        this.setWatermark();
        this._clusterBootTime_txt.setText("");
        this._clusterName_txt.setText("");
        this._clusterInstanceName_txt.setText("");
        this._clusterInstanceId_txt.setText("");
        this._clusterCoordinatorName_txt.setText("");
        this._clusterCoordinatorId_txt.setText("");
        this._clusterInfoPanel.setVisible(false);
        this._localServerName_txt.setText("");
        this._atAtServerName_txt.setText("");
        this._listeners_txt.setText("");
        this._aseVersion_txt.setText("");
        this._lastSampleTime_txt.setText("");
        this._startDate_txt.setText("");
        this._daysRunning_txt.setText("");
        this._countersCleared_txt.setText("");
        this._checkPoints_txt.setText("");
        this._numDeadlocks_txt.setText("");
        this._numDeadlocksDiff_txt.setText("");
        this._diagnosticDumps_txt.setText("");
        this._connections_txt.setText("");
        this._connectionsDiff_txt.setText("");
        this._distinctLoginsAbs_txt.setText("");
        this._distinctLoginsDiff_txt.setText("");
        this._lockWaitThreshold_txt.setText("");
        this._lockWaits_txt.setText("");
        this._lockWaitsDiff_txt.setText("");
        this._maxRecovery_txt.setText("");
        this._transactions_txt.setText("");
        this._transactionsDiff_txt.setText("");
        this._transactionsRate_txt.setText("");
        this._bootcount_txt.setText("");
        this._recoveryState_txt.setText("");
        this._cpuTime_txt.setText("");
        this._cpuUser_txt.setText("");
        this._cpuSystem_txt.setText("");
        this._cpuIdle_txt.setText("");
        this._ioTotalRead_txt.setText("");
        this._ioTotalReadDiff_txt.setText("");
        this._ioTotalWrite_txt.setText("");
        this._ioTotalWriteDiff_txt.setText("");
        this._aaConnectionsAbs_txt.setText("");
        this._aaConnectionsDiff_txt.setText("");
        this._aaConnectionsRate_txt.setText("");
        this._packReceived_txt.setText("");
        this._packReceivedDiff_txt.setText("");
        this._packSent_txt.setText("");
        this._packSentDiff_txt.setText("");
        this._packetErrors_txt.setText("");
        this._packetErrorsDiff_txt.setText("");
        this._totalErrors_txt.setText("");
        this._totalErrorsDiff_txt.setText("");
    }

    public void saveLayoutProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        conf.setProperty("summaryPanel.serverInfo.width", this._dataPanelScroll.getSize().width);
        conf.setProperty("summaryPanel.serverInfo.height", this._dataPanelScroll.getSize().height);
        conf.save();
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (this._clusterView_cbx.getSelectedItem() != null) {
            String clusterView = this._clusterView_cbx.getSelectedItem().toString();
            conf.setProperty("cluster.system_view", clusterView);
        }
        conf.save();
    }

    private void loadProps() {
        Configuration conf = Configuration.getCombinedConfiguration();
        String clusterView = conf.getProperty("cluster.system_view", "cluster");
        this._clusterView_cbx.setSelectedItem(clusterView);
        int width = conf.getIntProperty("summaryPanel.serverInfo.width", -1);
        int height = conf.getIntProperty("summaryPanel.serverInfo.height", -1);
        if (width != -1 && height != -1) {
            this._dataPanelScroll.setPreferredSize(new Dimension(width, height));
        }
    }

    public int getClusterView() {
        String choice = (String)this._clusterView_cbx.getSelectedItem();
        int systemView = 0;
        systemView = choice != null && choice.equalsIgnoreCase("instance") ? 2 : 1;
        return systemView;
    }

    public void setWatermark() {
        if (MainFrame.isOfflineConnected()) {
            String offlineSamplePeriod = MainFrame.getOfflineSamplePeriodText();
            if (offlineSamplePeriod == null) {
                this.setWatermarkText("Choose sample period");
            } else {
                this.setWatermarkText(offlineSamplePeriod);
            }
        } else if (!Asemon.getCounterCollector().isMonConnected()) {
            this.setWatermarkText("Not Connected...");
        } else {
            this.setWatermarkText(null);
        }
    }

    public void setWatermarkText(String str) {
        this._watermark.setWatermarkText(str);
    }

    class Watermark
    extends AbstractComponentDecorator {
        private String _text;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._text = "";
            this.g = null;
            this.r = null;
            if (text != null) {
                this._text = text;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._text == null || this._text != null && this._text.equals("")) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Font f = this.g.getFont();
            this.g.setFont(f.deriveFont(1, (float)f.getSize() * 4.0f));
            this.g.setColor(new Color(128, 128, 128, 128));
            FontMetrics fm = this.g.getFontMetrics();
            int strWidth = fm.stringWidth(this._text);
            int xPos = (this.r.width - strWidth) / 2;
            int yPos = (int)((float)this.r.height - (float)(this.r.height - fm.getHeight()) / 2.0f);
            this.g.translate(xPos, yPos);
            double theta = -0.5235987755982988;
            this.g.rotate(theta);
            this.g.translate(-xPos, -yPos);
            this.g.drawString(this._text, xPos, yPos);
        }

        public void setWatermarkText(String text) {
            this._text = text;
            this.repaint();
        }
    }
}

