/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.gui.wizard.WizardOfflinePage0verview;
import asemon.gui.wizard.WizardOfflinePage1;
import asemon.gui.wizard.WizardOfflinePage2;
import asemon.gui.wizard.WizardOfflinePage3;
import asemon.gui.wizard.WizardOfflinePage4;
import asemon.gui.wizard.WizardOfflinePage5;
import asemon.gui.wizard.WizardOfflinePage6;
import asemon.gui.wizard.WizardOfflinePage7;
import asemon.gui.wizard.WizardOffllinePageSummary;
import asemon.utils.Configuration;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;

public class WizardOffline {
    private static Logger _logger = Logger.getLogger(WizardOffline.class);
    private static final long serialVersionUID = 1L;
    protected static final String MigLayoutHelpConstraints = "wmin 100, span, growx, gapbottom 15, wrap";
    protected static final String MigLayoutConstraints1 = "";
    protected static final String MigLayoutConstraints2 = "[] [grow] []";
    protected static final String MigLayoutConstraints3 = "";
    protected static final Dimension preferredSize = new Dimension(450, 350);

    public WizardOffline() {
        System.clearProperty("wizard.sidebar.image");
        System.setProperty("wizard.sidebar.image", "asemon/gui/wizard/WizardOffline.png");
        Class[] wca = new Class[]{WizardOfflinePage0verview.class, WizardOfflinePage1.class, WizardOfflinePage2.class, WizardOfflinePage3.class, WizardOfflinePage4.class, WizardOfflinePage5.class, WizardOfflinePage6.class, WizardOfflinePage7.class};
        Wizard wiz = WizardPage.createWizard((String)"Create an offline sample session.", (Class[])wca, (WizardPage.WizardResultProducer)new WizardOffllinePageSummary());
        Map gatheredSettings = (Map)WizardDisplayer.showWizard((Wizard)wiz);
        try {
            this.finish(gatheredSettings);
        }
        catch (WizardException e) {
            e.printStackTrace();
        }
        System.clearProperty("wizard.sidebar.image");
    }

    private void fixProp(Map<String, String> settings, String prefix, String key, boolean alwaysAdd, boolean encrypt) {
        String newKey = prefix + key;
        String originVal = "";
        String val = "";
        try {
            originVal = val = settings.get(key);
        }
        catch (ClassCastException e) {
            for (String k : settings.keySet()) {
                String o = settings.get(k);
                if (o instanceof String) continue;
                _logger.error((Object)("Internal ERROR: ClassCastException from settingsMap with key='" + k + "', val='" + o + "', type='" + o.getClass().getName() + "'."));
            }
            throw e;
        }
        if (encrypt) {
            val = Configuration.encryptPropertyValue(newKey, val + "");
        }
        if (alwaysAdd) {
            settings.put(newKey, val);
        } else if (settings.containsKey(key) && originVal != null && !originVal.trim().equals("")) {
            settings.put(newKey, val);
        }
        settings.remove(key);
    }

    protected Object finish(Map<String, String> settings) throws WizardException {
        if (settings == null) {
            return null;
        }
        Configuration offlineProps = new Configuration();
        Configuration aseMonProps = Configuration.getCombinedConfiguration();
        offlineProps.setFilename(settings.get("storeFile"));
        offlineProps.setEmbeddedMessage("File generated by Offline Wizard.");
        this.fixProp(settings, "PersistWriterJdbc.", "jdbcDriver", true, false);
        this.fixProp(settings, "PersistWriterJdbc.", "jdbcUrl", true, false);
        this.fixProp(settings, "PersistWriterJdbc.", "jdbcUser", true, false);
        this.fixProp(settings, "PersistWriterJdbc.", "jdbcPasswd", true, true);
        this.fixProp(settings, "PersistWriterJdbc.", "startH2NetworkServer", true, false);
        this.fixProp(settings, "conn.", "aseHost", true, false);
        this.fixProp(settings, "conn.", "aseName", true, false);
        this.fixProp(settings, "conn.", "asePassword", true, true);
        this.fixProp(settings, "conn.", "asePort", true, false);
        this.fixProp(settings, "conn.", "aseUsername", true, false);
        this.fixProp(settings, "conn.", "sshHostname", false, false);
        this.fixProp(settings, "conn.", "sshPort", false, false);
        this.fixProp(settings, "conn.", "sshUsername", false, false);
        this.fixProp(settings, "conn.", "sshPassword", false, true);
        this.fixProp(settings, "offline.", "sampleTime", true, false);
        this.fixProp(settings, "offline.", "shutdownAfterXHours", false, false);
        this.fixProp(settings, "offline.", "storeFile", true, false);
        String writerClass = aseMonProps.getProperty("PersistentCounterHandler.WriterClass");
        if (writerClass == null) {
            writerClass = "asemon.pcs.PersistWriterJdbc";
        }
        settings.put("PersistentCounterHandler.WriterClass", writerClass);
        for (String key : settings.keySet()) {
            String val = settings.get(key).toString();
            if (key.startsWith("to-be-discarded.")) {
                String udcVal;
                String udcPrefix;
                String cmName = val;
                if (this.getUdcConfigName(cmName) != null) {
                    udcPrefix = "udc." + this.getUdcConfigName(cmName);
                    for (String udcKey : aseMonProps.getKeys(udcPrefix)) {
                        udcVal = aseMonProps.getProperty(udcKey);
                        offlineProps.put(udcKey, udcVal);
                    }
                }
                if (this.getHostMonUdcConfigName(cmName) == null) continue;
                udcPrefix = "hostmon.udc." + this.getHostMonUdcConfigName(cmName);
                for (String udcKey : aseMonProps.getKeys(udcPrefix)) {
                    udcVal = aseMonProps.getProperty(udcKey);
                    offlineProps.put(udcKey, udcVal);
                }
                continue;
            }
            offlineProps.put(key, val);
        }
        offlineProps.save();
        return settings;
    }

    private String getUdcConfigName(String name) {
        String udcConfigName = null;
        String udcPrefix = "udc.";
        Configuration aseMonProps = Configuration.getCombinedConfiguration();
        for (String udcKey : aseMonProps.getKeys(udcPrefix)) {
            String udcName = udcKey.substring(udcPrefix.length(), udcKey.indexOf(".", udcPrefix.length()));
            if (!udcKey.equals(udcPrefix + name + ".name")) continue;
            udcConfigName = udcName;
            return udcConfigName;
        }
        return udcConfigName;
    }

    private String getHostMonUdcConfigName(String name) {
        String udcConfigName = null;
        String udcPrefix = "hostmon.udc.";
        Configuration aseMonProps = Configuration.getCombinedConfiguration();
        for (String udcKey : aseMonProps.getKeys(udcPrefix)) {
            String udcName = udcKey.substring(udcPrefix.length(), udcKey.indexOf(".", udcPrefix.length()));
            if (!udcKey.equals(udcPrefix + name + ".osCommand")) continue;
            udcConfigName = udcName;
            return udcConfigName;
        }
        return udcConfigName;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new WizardOffline();
    }
}

