/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.netbeans.spi.wizard.WizardPage;

public class WizardUserDefinedCmPage1
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "Name-info";
    private static final String WIZ_DESC = "Name information";
    private static final String WIZ_HELP1 = "Name of the Counter Model, without spaces or special characters.";
    private static final String WIZ_HELP2 = "A short description of the Counter Model, use only 2 or 3 words, this will be the text on the GUI tab.";
    private static final String WIZ_HELP3 = "The long description, which will be used as a tooltip on the GUI tab.";
    private boolean _firtsTimeRender = true;
    private JLabel _name_lbl = new JLabel("Name");
    private JTextField _name_txt = new JTextField("");
    private JLabel _shortDesc_lbl = new JLabel("Short Description");
    private JTextField _shortDesc_txt = new JTextField("");
    private JLabel _longDesc_lbl = new JLabel("Long Description");
    private JTextField _longDesc_txt = new JTextField("");

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPage1() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._name_txt.setName("name");
        this._shortDesc_txt.setName("displayName");
        this._longDesc_txt.setName("description");
        this.add(new MultiLineLabel(WIZ_HELP1), "wmin 100, span, pushx, growx, wrap");
        this.add(this._name_lbl);
        this.add(this._name_txt, "growx, pushx, split");
        JButton button = new JButton("...");
        button.setToolTipText("Use one of the current Counter Models as a template.");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_TEMPLATE");
        this.add(button, "wrap 30");
        this.add(new MultiLineLabel(WIZ_HELP2), "wmin 100, span, pushx, growx, wrap");
        this.add(this._shortDesc_lbl);
        this.add(this._shortDesc_txt, "growx, pushx, wrap 30");
        this.add(new MultiLineLabel(WIZ_HELP3), "wmin 100, span, pushx, growx, wrap");
        this.add(this._longDesc_lbl);
        this.add(this._longDesc_txt, "growx, pushx, wrap 30");
        this.initData();
    }

    private void initData() {
    }

    protected void renderingPage() {
        if (this._firtsTimeRender) {
            // empty if block
        }
        this._firtsTimeRender = false;
    }

    protected String validateContents(Component comp, Object event) {
        String cmName = this._name_txt.getText().trim();
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm != null) {
            return "There is alraedy a CM named '" + cmName + "'.";
        }
        String cmDesc = this._shortDesc_txt.getText().trim();
        cm = GetCounters.getCmByDisplayName(cmDesc);
        if (cm != null) {
            return "The Short Description '" + cmDesc + "' is already used.";
        }
        String problem = "";
        if (this._name_txt.getText().trim().length() <= 0) {
            problem = problem + "Name, ";
        }
        if (this._shortDesc_txt.getText().trim().length() <= 0) {
            problem = problem + "Short Desc, ";
        }
        if (this._longDesc_txt.getText().trim().length() <= 0) {
            problem = problem + "Long Desc, ";
        }
        if (problem.length() > 0) {
            problem = problem.substring(0, problem.length() - 2);
        }
        if (problem.length() > 0) {
            problem = "Following fields cant be empty: " + problem;
        }
        if (this._name_txt.getText().trim().indexOf(" ") >= 0) {
            problem = "The field 'Name' cant contain spaces.";
        }
        if (this._name_txt.getText().trim().length() > 0 && !CountersModel.isValidCmName(this._name_txt.getText())) {
            problem = CountersModel.checkForValidCmName(this._name_txt.getText());
        }
        if (problem.length() > 0) {
            return problem;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        CmChooserDialog cmChooser;
        String cmName;
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (name.equals("BUTTON_TEMPLATE") && (cmName = (cmChooser = new CmChooserDialog(null)).chooseOne()) != null) {
            this.putWizardData("cmTemplate", cmName);
            CountersModel cm = GetCounters.getCmByName(cmName);
            if (cm != null) {
                this._name_txt.setText(cm.getName() + "Copy");
                this._shortDesc_txt.setText(cm.getDisplayName() + " Copy");
                this._longDesc_txt.setText(cm.getDescription());
                this._longDesc_txt.setCaretPosition(0);
            } else {
                this._name_txt.setText("NoLuck-" + cmName);
            }
        }
    }

    protected class CmChooserDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private final String[] TAB_HEADER;
        private static final int TAB_POS_CHECK = 0;
        private static final int TAB_POS_COL_ICON = 1;
        private static final int TAB_POS_COL_NAME = 2;
        private static final int TAB_POS_COL_SHORT_DESC = 3;
        private static final int TAB_POS_COL_LONG_DESC = 4;
        private JXTable _table;
        private JButton _tableSelectAll_but;
        private JButton _tableDeSelectAll_but;
        private JButton _ok;
        private JButton _cancel;

        public String chooseOne() {
            this._tableSelectAll_but.setVisible(false);
            this._tableDeSelectAll_but.setVisible(false);
            this._table.removeColumn(this._table.getColumn(0));
            this._table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CmChooserDialog.this.setVisible(false);
                    }
                }
            });
            this.setVisible(true);
            int row = this._table.getSelectedRow();
            if (row == -1) {
                return null;
            }
            row = this._table.convertRowIndexToModel(row);
            TableModel tm = this._table.getModel();
            return (String)tm.getValueAt(row, 2);
        }

        public List<String> chooseList() {
            this.setVisible(true);
            LinkedList<String> list = new LinkedList<String>();
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 0)).booleanValue()) continue;
                list.add((String)tm.getValueAt(r, 2));
            }
            if (list.size() > 0) {
                return list;
            }
            return null;
        }

        public CmChooserDialog(Frame owner) {
            super(owner, "Choose a Counter Model", true);
            this.TAB_HEADER = new String[]{"Choose", "Cm", "Name", "Short Desc", "Long Description"};
            this._table = new JXTable();
            this._tableSelectAll_but = new JButton("Select All");
            this._tableDeSelectAll_but = new JButton("Deselect All");
            this._ok = new JButton("OK");
            this._cancel = new JButton("Cancel");
            this.initComponents();
            this.pack();
            Dimension size = this.getPreferredSize();
            size.height = 500;
            size.width = 500;
            this.setSize(size);
            this.setLocationRelativeTo(owner);
        }

        protected void initComponents() {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, wrap 1", "", ""));
            panel.add((Component)this.createCmTablePanel(), "height 100%, grow, push, wrap");
            panel.add((Component)this.createOkCancelPanel(), "shrinkprio 0, bottom, right");
            this.setContentPane(panel);
        }

        private JPanel createOkCancelPanel() {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout("", "", ""));
            panel.add((Component)this._ok, "tag ok, right");
            panel.add((Component)this._cancel, "tag cancel");
            this._ok.addActionListener(this);
            this._cancel.addActionListener(this);
            return panel;
        }

        private JPanel createCmTablePanel() {
            JPanel panel = SwingUtils.createPanel("Available Counter Models", false);
            panel.setLayout((LayoutManager)new MigLayout("", "", ""));
            Vector<String> tabHead = new Vector<String>();
            tabHead.add(this.TAB_HEADER[0]);
            tabHead.add(this.TAB_HEADER[1]);
            tabHead.add(this.TAB_HEADER[2]);
            tabHead.add(this.TAB_HEADER[3]);
            tabHead.add(this.TAB_HEADER[4]);
            Vector<Vector<Object>> tabData = this.populateCmTable();
            DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
                private static final long serialVersionUID = 1L;

                @Override
                public Class<?> getColumnClass(int column) {
                    if (column == 0) {
                        return Boolean.class;
                    }
                    if (column == 1) {
                        return Icon.class;
                    }
                    return Object.class;
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 0;
                }
            };
            this._table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TableModel tm;
                        int row = CmChooserDialog.this._table.getSelectedRow();
                        if (row == -1) {
                            return;
                        }
                        row = CmChooserDialog.this._table.convertRowIndexToModel(row);
                        boolean choosen = (Boolean)(tm = CmChooserDialog.this._table.getModel()).getValueAt(row, 0);
                        tm.setValueAt(new Boolean(!choosen), row, 0);
                    }
                }
            });
            this._table.setModel((TableModel)defaultTabModel);
            this._table.setShowGrid(false);
            this._table.setSortable(true);
            this._table.setSelectionMode(0);
            this._table.setAutoResizeMode(0);
            this._table.packAll();
            this._table.setSortable(true);
            this._table.setColumnControlVisible(true);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView((Component)this._table);
            panel.add((Component)jScrollPane, "push, grow, height 100%, wrap");
            panel.add((Component)this._tableSelectAll_but, "hidemode 3, split");
            panel.add((Component)this._tableDeSelectAll_but, "hidemode 3");
            this._tableSelectAll_but.addActionListener(this);
            this._tableDeSelectAll_but.addActionListener(this);
            return panel;
        }

        private Vector<Vector<Object>> populateCmTable() {
            Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
            Vector<Object> row = new Vector<Object>();
            for (CountersModel cm : GetCounters.getCmList()) {
                if (cm == null) continue;
                row = new Vector();
                row.add(new Boolean(false));
                row.add(cm.getTabPanel() == null ? null : cm.getTabPanel().getIcon());
                row.add(cm.getName());
                row.add(cm.getDisplayName());
                row.add(cm.getDescription().replaceAll("\\<.*?\\>", ""));
                tab.add(row);
                if (!cm.getName().equals("CMsummary")) continue;
                row.set(1, SwingUtils.readImageIcon(Version.class, "images/summary_tab.png"));
            }
            if (tab.size() == 0) {
                for (int i = 0; i < 40; ++i) {
                    row = new Vector();
                    row.add(new Boolean(false));
                    row.add(SwingUtils.readImageIcon(Version.class, "images/ud_counter_activity.png"));
                    row.add("cmDummy" + i);
                    row.add("Dummy Tab " + i);
                    row.add(UUID.randomUUID().toString() + " : " + UUID.randomUUID().toString());
                    tab.add(row);
                }
            }
            return tab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int r;
            TableModel tm;
            Object source = e.getSource();
            if (this._tableSelectAll_but.equals(source)) {
                tm = this._table.getModel();
                for (r = 0; r < tm.getRowCount(); ++r) {
                    tm.setValueAt(new Boolean(true), r, 0);
                }
            }
            if (this._tableDeSelectAll_but.equals(source)) {
                tm = this._table.getModel();
                for (r = 0; r < tm.getRowCount(); ++r) {
                    tm.setValueAt(new Boolean(false), r, 0);
                }
            }
            if (this._cancel.equals(source)) {
                this.setVisible(false);
            }
            if (this._ok.equals(source)) {
                this.setVisible(false);
            }
        }
    }
}

