/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.QueryWindow;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.utils.AseConnectionFactory;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class WizardUserDefinedCmPage2
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "SQL-Statements";
    private static final String WIZ_DESC = "SQL Statement(s)";
    private static final String WIZ_HELP1 = "SQL Statements that will be executed on init.";
    private static final String WIZ_HELP2 = "SQL Statements that will be executed on refresh.";
    private static final String WIZ_HELP3 = "SQL Statements that will be executed on close.";
    private static final String NEED_VERSION_DEFAULT = "Works on all ASE versions";
    private static final String NEED_VERSION_TOOLTIP = "<html>Lowest ASE Version where this Counter Model works on.<br>Specify this as a number/integer.<br>Example 1: 15030, which is 15.0.3<br>Example 2: 15031, which is 15.0.3 ESD#1<br>Note: always use 5 digits as the version number. Or 0 if you mean 'any version'<br></html>";
    private static final String NEED_ROLE_DEFAULT = "<mon_role, sa_role, xxx_role, ...>";
    private static final String NEED_ROLE_TOOLTIP = "<html>A ',' separated list of role(s) that needs to be granted for this User Definde Counter.<br>Syntax: xxx_role, yyy_role, zzz_role<br>Example: sa_role, mon_role.</i><br>Here is a list of System roles: sa_role, sso_role, oper_role, sybase_ts_role, navigator_role, replication_role, dtm_tm_role, ha_role, mon_role, js_admin_role, messaging_role, js_client_role, js_user_role, webservices_role, keycustodian_role<br></html>";
    private static final String NEED_CONFIG_DEFAULT = "<enable monitoring, config option 2, ...>";
    private static final String NEED_CONFIG_TOOLTIP = "<html>A ',' separated list of sp_configure parameters that needs to be configured for this User Definde Counter.<br>Syntax: config option 1[=defValue], config option 2[=defValue]<br>Note: do not use \" surounding the configuration name.<br>Example: deadlock pipe active=1, deadlock pipe max=500 <i>Use default values during no-gui initialization.</i><br>Example: statement cache size, enable stmt cache monitoring=1 <i>for 'statement cache size' do <b>NOT</b> use default values. If you do it will be enabled by \"mistake\".</i><br></html>";
    private static final String MON_TABLES_DEFAULT = "<monXXX, monYYY>";
    private static final String MON_TABLES_TOOLTIP = "A ',' separated list of monXXX tables, used for tooltip to describe what the columns represents.";
    private boolean _firtsTimeRender = true;
    private JTextArea _sqlOpen_txt = new JTextArea();
    private JTextArea _sql_txt = new JTextArea();
    private JLabel _needVersion_lbl = new JLabel("Min ASE Version");
    private JTextField _needVersion_txt = new JTextField("Works on all ASE versions");
    private JLabel _needRole_lbl = new JLabel("Needs Role");
    private JTextField _needRole_txt = new JTextField("<mon_role, sa_role, xxx_role, ...>");
    private JLabel _needConfig_lbl = new JLabel("Needs Config");
    private JTextField _needConfig_txt = new JTextField("<enable monitoring, config option 2, ...>");
    private JLabel _monTables_lbl = new JLabel("Monitor Tables");
    private JTextField _monTables_txt = new JTextField("<monXXX, monYYY>");
    private JCheckBox _negDiffCntToZero_chk = new JCheckBox("If Difference Calculation renders a negative number, set to Zero", true);
    private JTextArea _sqlClose_txt = new JTextArea();

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPage2() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", ""));
        this._sqlOpen_txt.setName("sqlOpen");
        this._sql_txt.setName("sql");
        this._sqlClose_txt.setName("sqlClose");
        this._needVersion_txt.setName("needVersion");
        this._needRole_txt.setName("needRole");
        this._needConfig_txt.setName("needConfig");
        this._monTables_txt.setName("toolTipMonTables");
        this._negDiffCntToZero_chk.setName("negativeDiffCountersToZero");
        this._needVersion_txt.setToolTipText(NEED_VERSION_TOOLTIP);
        this._needRole_txt.setToolTipText(NEED_ROLE_TOOLTIP);
        this._needConfig_txt.setToolTipText(NEED_CONFIG_TOOLTIP);
        this._monTables_txt.setToolTipText(MON_TABLES_TOOLTIP);
        this._negDiffCntToZero_chk.setToolTipText("<html>If Difference Calculation renders a negative number, between two counter samples, set the counter to Zero<ul><li>Uncheck this if you have counters that increments and then decremets and you want to know how much the value decreased by.<li>Check this is the counters have a tendency to be reset (for example by sp_sysmon) or similar<br>    Or if the counter is set to zero when it wraps over the max values of a integer or other number.<br>    But if the counters just wraps around the max boundary into a negative value, the diff calculation still works.</ul></html>");
        this.add(new MultiLineLabel(WIZ_HELP1), "wmin 100, span, pushx, growx, wrap");
        this.add(this._sqlOpen_txt, "growx, pushx, wrap");
        JButton button = new JButton("Test SQL");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_TEST_SQL_OPEN");
        this.add(button, "span, align right, wrap 10");
        this.add(new MultiLineLabel(WIZ_HELP2), "wmin 100, span, pushx, growx, wrap");
        this.add(new JScrollPane(this._sql_txt), "growx, pushx, height 100%, wrap");
        this.add(this._needVersion_lbl, "split, width 80lp!");
        this.add(this._needVersion_txt, "split, growx, pushx");
        button = new JButton("Test SQL");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_TEST_SQL_REFRESH");
        this.add(button, "align right, wrap");
        this.add(this._needRole_lbl, "split, width 80lp!");
        this.add(this._needRole_txt, "split, growx, wrap");
        this.add(this._needConfig_lbl, "split, width 80lp!");
        this.add(this._needConfig_txt, "split, growx, wrap");
        this.add(this._monTables_lbl, "split, width 80lp!");
        this.add(this._monTables_txt, "split, growx, wrap");
        this.add(this._negDiffCntToZero_chk, "wrap 30");
        this.add(new MultiLineLabel(WIZ_HELP3), "wmin 100, span, pushx, growx, wrap");
        this.add(this._sqlClose_txt, "growx, pushx, wrap");
        button = new JButton("Test SQL");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_TEST_SQL_CLOSE");
        this.add(button, "span, align right, wrap 10");
    }

    private void applyFromTemplate() {
        String cmName = (String)this.getWizardData("cmTemplate");
        if (cmName == null) {
            return;
        }
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm != null) {
            this._sqlOpen_txt.setText(cm.getSqlInit());
            this._sql_txt.setText(cm.getSql());
            this._sqlClose_txt.setText(cm.getSqlClose());
            this._needVersion_txt.setText(cm.getDependsOnVersion() + "");
            this._needConfig_txt.setText(StringUtil.toCommaStr(cm.getDependsOnRole()));
            this._needConfig_txt.setText(StringUtil.toCommaStr(cm.getDependsOnConfig()));
            this._monTables_txt.setText(StringUtil.toCommaStr(cm.getMonTablesInQuery()));
            this._negDiffCntToZero_chk.setSelected(cm.isNegativeDiffCountersToZero());
        }
    }

    protected void renderingPage() {
        if (this._firtsTimeRender) {
            this.applyFromTemplate();
        }
        this._firtsTimeRender = false;
    }

    protected String validateContents(Component comp, Object event) {
        String aseVersionStr;
        String problem = "";
        if (this._sql_txt.getText().trim().length() <= 0) {
            problem = problem + "SQL refresh ";
        }
        if (problem.length() > 0 && problem.endsWith(", ")) {
            problem = problem.substring(0, problem.length() - 2);
        }
        if (problem.length() > 0) {
            return "Following fields cant be empty: " + problem;
        }
        if (!this._needVersion_txt.getText().equals(NEED_VERSION_DEFAULT) && !(aseVersionStr = this._needVersion_txt.getText()).equals("")) {
            int aseVersionInt = -1;
            try {
                aseVersionInt = Integer.parseInt(aseVersionStr);
            }
            catch (NumberFormatException ignore) {
                return "ASE Version needs to be a number.";
            }
            if (aseVersionInt > 0 && aseVersionStr.length() != "15031".length()) {
                return "ASE Version needs to be a number, Example 15031 (15.0.3 ESD#1).";
            }
        }
        if (this._needRole_txt.getText().equals(NEED_ROLE_DEFAULT)) {
            return "Substitute '<mon_role, sa_role, xxx_role, ...>' to something usefull. Or make it empty";
        }
        if (this._needRole_txt.getText().indexOf("<") >= 0 || this._needRole_txt.getText().indexOf(">") >= 0) {
            return "Take away the '<' and/or '>' chars in 'needs role'.";
        }
        if (this._needConfig_txt.getText().equals(NEED_CONFIG_DEFAULT)) {
            return "Substitute '<enable monitoring, config option 2, ...>' to something usefull. Or make it empty";
        }
        if (this._needConfig_txt.getText().indexOf("<") >= 0 || this._needConfig_txt.getText().indexOf(">") >= 0) {
            return "Take away the '<' and/or '>' chars in 'needs config'.";
        }
        if (this._needConfig_txt.getText().indexOf("\"") >= 0) {
            return "Take away any \" quote chars in 'needs config'.";
        }
        if (this._monTables_txt.getText().equals(MON_TABLES_DEFAULT)) {
            return "Substitute '<monXXX, monYYY>' to something usefull. Or make it empty";
        }
        if (this._monTables_txt.getText().indexOf("<") >= 0 || this._monTables_txt.getText().indexOf(">") >= 0) {
            return "Take away the '<' and/or '>' chars in 'monitor tables'.";
        }
        if (problem.length() > 0) {
            return problem;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        String sql = null;
        if (name.equals("BUTTON_TEST_SQL_OPEN")) {
            sql = this._sqlOpen_txt.getText();
        }
        if (name.equals("BUTTON_TEST_SQL_REFRESH")) {
            sql = this._sql_txt.getText();
        }
        if (name.equals("BUTTON_TEST_SQL_CLOSE")) {
            sql = this._sqlClose_txt.getText();
        }
        if (sql != null) {
            try {
                Connection conn = AseConnectionFactory.getConnection(null, Version.getAppName() + "-wiz-udc", null);
                QueryWindow qw = new QueryWindow(conn, sql, true, QueryWindow.WindowType.JDIALOG_MODAL);
                qw.setSize(500, 500);
                qw.setLocationRelativeTo((Component)((Object)this));
                qw.setVisible(true);
                String retSql = qw.getSql();
                if (name.equals("BUTTON_TEST_SQL_OPEN")) {
                    this._sqlOpen_txt.setText(retSql);
                }
                if (name.equals("BUTTON_TEST_SQL_REFRESH")) {
                    this._sql_txt.setText(retSql);
                }
                if (name.equals("BUTTON_TEST_SQL_CLOSE")) {
                    this._sqlClose_txt.setText(retSql);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Problems open SQL Query Window\n" + ex.getMessage(), "Error", 0);
            }
        }
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        this.putWizardData("SamplingCnt", null);
        try {
            Connection conn = AseConnectionFactory.getConnection(null, Version.getAppName() + "-wiz-udc", null);
            CountersModel cm = new CountersModel();
            SamplingCnt sample = new SamplingCnt("asemon-wiz-udc-test", true, null);
            sample.getCnt(cm, conn, this._sql_txt.getText(), null);
            if (sample.getColumnCount() <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Problems when validating SQL 'refresh' statement\nNO Columns were returned from the SQL statement.", "Error", 0);
                return WizardPanelNavResult.REMAIN_ON_PAGE;
            }
            this.putWizardData("SamplingCnt", sample);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Problems when validating SQL 'refresh' statement\n" + ex.getMessage(), "Error", 0);
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        if (this._needVersion_txt.getText().equals(NEED_VERSION_DEFAULT)) {
            this._needVersion_txt.setText("0");
        }
        return WizardPanelNavResult.PROCEED;
    }
}

