/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class WizardUserDefinedCmPage3
extends WizardPage
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "PKCols";
    private static final String WIZ_DESC = "Primary Key Columns";
    private static final String WIZ_HELP = "If you want to do data difference calculation on counter data samples, you need to specify a Primary Key for the counter data. If this is not specified the counter data is just expected to contain 1 row.";
    private static final String[] TAB_HEADER = new String[]{"PK", "Column Name", "Column Num"};
    private static final int TAB_POS_CHECK = 0;
    private static final int TAB_POS_COL_NAME = 1;
    private static final int TAB_POS_COL_NUM = 2;
    private boolean _firtsTimeRender = true;
    private String[] _toolTipMonTables = new String[0];
    private JCheckBox _data_chk = new JCheckBox("Specify Primary Key(s)", true);
    private JXTable _table = null;
    private JButton _selectAll_but = new JButton("Select All");
    private JButton _deSelectAll_but = new JButton("Deselect All");

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPage3() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, pushx, growx, wrap");
        this.add(this._data_chk, "grow, span");
        Vector<String> tabHead = new Vector<String>();
        tabHead.add(TAB_HEADER[0]);
        tabHead.add(TAB_HEADER[1]);
        tabHead.add(TAB_HEADER[2]);
        Vector tabData = new Vector();
        DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        defaultTabModel.addTableModelListener(this);
        this._table = new JXTable(){
            private static final long serialVersionUID = 0L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                if (row > 0 && col > 0) {
                    TableModel model;
                    Object cellVal;
                    col = this.convertColumnIndexToModel(col);
                    row = this.convertRowIndexToModel(row);
                    if (col == 1 && (cellVal = (model = this.getModel()).getValueAt(row, col)) instanceof String) {
                        tip = MonTablesDictionary.getInstance().getDescription(WizardUserDefinedCmPage3.this._toolTipMonTables, (String)cellVal);
                    }
                }
                return tip;
            }
        };
        this._table.setModel((TableModel)defaultTabModel);
        this._table.setShowGrid(false);
        this._table.setSortable(true);
        this._table.setSelectionMode(0);
        this._table.setAutoResizeMode(0);
        this._table.packAll();
        this._table.setSortable(true);
        this._table.setColumnControlVisible(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        this.add(jScrollPane, "push, grow, height 100%, wrap");
        this.add(this._selectAll_but, "split");
        this.add(this._deSelectAll_but, "");
        this._data_chk.addActionListener(this);
        this._selectAll_but.addActionListener(this);
        this._deSelectAll_but.addActionListener(this);
    }

    private void refreshTable() {
        Vector<Object> row = new Vector<Object>();
        DefaultTableModel tm = (DefaultTableModel)this._table.getModel();
        SamplingCnt sc = (SamplingCnt)this.getWizardData("SamplingCnt");
        if (sc != null) {
            int r;
            List<String> names = sc.getColNames();
            if (names == null) {
                return;
            }
            boolean refresh = false;
            if (tm.getRowCount() == names.size()) {
                for (r = 0; r < tm.getRowCount(); ++r) {
                    String cntName;
                    String colName = (String)tm.getValueAt(r, 1);
                    if (colName.equals(cntName = names.get(r))) continue;
                    refresh = true;
                    break;
                }
            } else {
                refresh = true;
            }
            if (refresh) {
                while (tm.getRowCount() > 0) {
                    tm.removeRow(0);
                }
                r = 0;
                for (String col : names) {
                    ++r;
                    if (col == null) continue;
                    row = new Vector();
                    row.add(new Boolean(false));
                    row.add(col);
                    row.add(new Integer(r));
                    tm.addRow(row);
                }
            }
            String pkStr = (String)this.getWizardData("pk") + ", ";
            for (int r2 = 0; r2 < tm.getRowCount(); ++r2) {
                String colName = (String)tm.getValueAt(r2, 1);
                boolean colIsPk = pkStr.indexOf(colName + ", ") != -1;
                tm.setValueAt(new Boolean(colIsPk), r2, 0);
            }
        }
        this._table.packAll();
    }

    private void applyFromTemplate() {
        String cmName = (String)this.getWizardData("cmTemplate");
        if (cmName == null) {
            return;
        }
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm != null) {
            List<String> pklist = cm.getPk();
            if (pklist == null || pklist != null && pklist.size() == 0) {
                this._data_chk.setSelected(false);
            } else {
                TableModel tm = this._table.getModel();
                for (int r = 0; r < tm.getRowCount(); ++r) {
                    String colName = (String)tm.getValueAt(r, 1);
                    if (!pklist.contains(colName)) continue;
                    tm.setValueAt(new Boolean(true), r, 0);
                }
            }
        }
    }

    protected void renderingPage() {
        this.refreshTable();
        if (this._firtsTimeRender) {
            this.applyFromTemplate();
        }
        this._toolTipMonTables = StringUtil.commaStrToArray((String)this.getWizardData("toolTipMonTables"));
        this._firtsTimeRender = false;
    }

    protected String validateContents(Component comp, Object event) {
        boolean enable = this._data_chk.isSelected();
        this._table.setEnabled(enable);
        this._selectAll_but.setEnabled(enable);
        this._deSelectAll_but.setEnabled(enable);
        if (this._data_chk.isSelected()) {
            int rows = 0;
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 0)).booleanValue()) continue;
                ++rows;
            }
            return rows > 0 ? null : "Atleast one session needs to be checked.";
        }
        SamplingCnt sc = (SamplingCnt)this.getWizardData("SamplingCnt");
        if (sc.getRowCount() > 1) {
            return "The current SQL statement DOES return more than one row, then we need a PrimaryKey.";
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int r;
        TableModel tm;
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (this._selectAll_but.equals(src)) {
            tm = this._table.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                tm.setValueAt(new Boolean(true), r, 0);
            }
        }
        if (this._deSelectAll_but.equals(src)) {
            tm = this._table.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                tm.setValueAt(new Boolean(false), r, 0);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setProblem(this.validateContents(null, null));
    }

    private void saveWizardData() {
        if (this._data_chk.isSelected()) {
            String pkStr = "";
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 0)).booleanValue()) continue;
                pkStr = pkStr + tm.getValueAt(r, 1) + ", ";
            }
            if (pkStr.length() > 0) {
                pkStr = pkStr.substring(0, pkStr.length() - 2);
            }
            this.putWizardData("pk", pkStr);
        }
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }
}

