/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.utils.Configuration;
import asemon.utils.MandatoryPropertyException;
import asemon.utils.PropPropEntry;
import asemon.utils.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class HostMonitorMetaData
implements ResultSetMetaData {
    private static Logger _logger = Logger.getLogger(HostMonitorMetaData.class);
    public static final String REGEXP_IS_SPACE = "\\s+";
    public static final int STATUS_COL_SUB_SAMPLE = 1;
    public static final int STATUS_COL_SAMPLE_TIME = 2;
    private Map<String, Integer> _skipRowsList = null;
    private Map<String, Integer> _allowRowsList = null;
    private String _schemaName = "";
    private String _tableName = "";
    private String _catalogName = "";
    private String _osCommand = null;
    private boolean _osCommandIsStreaming = true;
    private String _regexpOnParse = "\\s+";
    private int _maxQueueSize = 1000;
    private ArrayList<ColumnEntry> _columns = new ArrayList();
    private ArrayList<String> _columnNames = new ArrayList();
    private int _numOfSqlCols = 0;
    private int _numOfParseCols = 0;

    public String getParseRegexp() {
        return this._regexpOnParse;
    }

    public void setParseRegexp(String regexp) {
        this._regexpOnParse = regexp == null || regexp != null && regexp.equalsIgnoreCase("DEFAULT") ? REGEXP_IS_SPACE : regexp;
    }

    public int getMaxQueueSize() {
        return this._maxQueueSize;
    }

    public void setMaxQueueSixe(int maxQueueSize) {
        this._maxQueueSize = maxQueueSize;
    }

    public List<ColumnEntry> getColumns() {
        return this._columns;
    }

    protected ColumnEntry getColumn(String name) {
        for (ColumnEntry e : this._columns) {
            if (!e._colName.equals(name)) continue;
            return e;
        }
        throw new RuntimeException("The getColumn(" + name + ") could not be found.");
    }

    public ColumnEntry getSqlColumn(int col) {
        for (ColumnEntry e : this._columns) {
            if (e._sqlColNum != col) continue;
            return e;
        }
        throw new RuntimeException("The getSqlColumn(" + col + ") could not be found.");
    }

    public ColumnEntry getParseColumn(int col) {
        for (ColumnEntry e : this._columns) {
            if (e._parseColNum != col) continue;
            return e;
        }
        throw new RuntimeException("The getParseColumn(" + col + ") could not be found.");
    }

    protected int getParseColumnArrayPos(String colname) {
        ColumnEntry ce = this.getColumn(colname);
        return ce._parseColNum - 1;
    }

    private void checkColumnEntry(ColumnEntry entry) throws RuntimeException {
        if (entry._colName == null) {
            throw new RuntimeException("Column name can't be null");
        }
        if (entry._colName.equalsIgnoreCase("")) {
            throw new RuntimeException("Column name can't be empty, named ''.");
        }
        if (entry._colName.equalsIgnoreCase("SessionStartTime")) {
            throw new RuntimeException("Column name 'SessionStartTime' is reserved by the PCS, Persistence Counter Storage.");
        }
        if (entry._colName.equalsIgnoreCase("SessionSampleTime")) {
            throw new RuntimeException("Column name 'SessionSampleTime' is reserved by the PCS, Persistence Counter Storage.");
        }
        if (entry._colName.equalsIgnoreCase("CmSampleTime")) {
            throw new RuntimeException("Column name 'CmSampleTime' is reserved by the PCS, Persistence Counter Storage.");
        }
        if (entry._colName.equalsIgnoreCase("CmSampleMs")) {
            throw new RuntimeException("Column name 'CmSampleMs' is reserved by the PCS, Persistence Counter Storage.");
        }
    }

    private void addColumn(ColumnEntry entry) {
        this.checkColumnEntry(entry);
        if (entry._schemaName == null) {
            entry._schemaName = this.getSchemaName();
        }
        if (entry._tableName == null) {
            entry._tableName = this.getTableName();
        }
        if (entry._catalogName == null) {
            entry._catalogName = this.getCatalogName();
        }
        this._columns.add(entry);
        this._numOfSqlCols = 0;
        this._numOfParseCols = 0;
        for (ColumnEntry e : this._columns) {
            this._numOfSqlCols = Math.max(e._sqlColNum, this._numOfSqlCols);
            this._numOfParseCols = Math.max(e._parseColNum, this._numOfParseCols);
        }
        Collections.sort(this._columns);
        this._columnNames = new ArrayList();
        for (ColumnEntry e : this._columns) {
            this._columnNames.add(e._colName);
        }
    }

    public void addStrColumn(String colName, int sqlColumnNumber, int parseColumnNumber, boolean isNullable, int length, String description) {
        ColumnEntry entry = new ColumnEntry();
        entry._colName = colName;
        entry._sqlColNum = sqlColumnNumber;
        entry._parseColNum = parseColumnNumber;
        entry._isPartOfPk = false;
        entry._isNullable = isNullable;
        entry._sqlType = 12;
        entry._sqlDataType = "varchar";
        entry._javaClass = String.class;
        entry._isNumber = false;
        entry._displayLength = length;
        entry._precision = -1;
        entry._scale = -1;
        entry._description = description;
        this.addColumn(entry);
    }

    public void addIntColumn(String colName, int sqlColumnNumber, int parseColumnNumber, boolean isNullable, String description) {
        ColumnEntry entry = new ColumnEntry();
        entry._colName = colName;
        entry._sqlColNum = sqlColumnNumber;
        entry._parseColNum = parseColumnNumber;
        entry._isPartOfPk = false;
        entry._isNullable = isNullable;
        entry._sqlType = 4;
        entry._sqlDataType = "int";
        entry._javaClass = Integer.class;
        entry._isNumber = true;
        entry._displayLength = Math.max(colName.length(), Integer.toString(Integer.MAX_VALUE).length());
        entry._precision = -1;
        entry._scale = -1;
        entry._description = description;
        this.addColumn(entry);
    }

    public void addDatetimeColumn(String colName, int sqlColumnNumber, int parseColumnNumber, boolean isNullable, String description) {
        ColumnEntry entry = new ColumnEntry();
        entry._colName = colName;
        entry._sqlColNum = sqlColumnNumber;
        entry._parseColNum = parseColumnNumber;
        entry._isPartOfPk = false;
        entry._isNullable = isNullable;
        entry._sqlType = 93;
        entry._sqlDataType = "datetime";
        entry._javaClass = Timestamp.class;
        entry._isNumber = false;
        entry._displayLength = Math.max(colName.length(), "2011-01-01 22:22:22.333".length());
        entry._precision = -1;
        entry._scale = -1;
        entry._description = description;
        this.addColumn(entry);
    }

    public void addStatColumn(String colName, int sqlColumnNumber, int parseColumnNumber, boolean isNullable, int precision, int scale, String description) {
        ColumnEntry entry = new ColumnEntry();
        entry._colName = colName;
        entry._sqlColNum = sqlColumnNumber;
        entry._parseColNum = parseColumnNumber;
        entry._isPartOfPk = false;
        entry._isNullable = isNullable;
        entry._isStatColumn = true;
        entry._sqlType = 2;
        entry._sqlDataType = "numeric";
        entry._javaClass = BigDecimal.class;
        entry._isNumber = true;
        entry._displayLength = Math.max(colName.length(), precision + 1);
        entry._precision = precision;
        entry._scale = scale;
        entry._description = description;
        this.addColumn(entry);
    }

    public void setSkipRows(String colname, String valueToSkip) {
        if (this._skipRowsList == null) {
            this._skipRowsList = new HashMap<String, Integer>();
        }
        ColumnEntry entry = this.getColumn(colname);
        this._skipRowsList.put(valueToSkip, entry._parseColNum - 1);
    }

    public Map<String, Integer> getSkipRowsMap() {
        return this._skipRowsList;
    }

    public void setAllowRows(String colname, String valueToAllow) {
        if (this._allowRowsList == null) {
            this._allowRowsList = new HashMap<String, Integer>();
        }
        ColumnEntry entry = this.getColumn(colname);
        this._allowRowsList.put(valueToAllow, entry._parseColNum - 1);
    }

    public Map<String, Integer> getAllowRowsMap() {
        return this._allowRowsList;
    }

    public void setPkCol(String ... colNames) {
        for (ColumnEntry entry : this._columns) {
            entry._isPartOfPk = false;
        }
        for (String colname : colNames) {
            ColumnEntry entry = this.getColumn(colname);
            entry._isPartOfPk = true;
            entry._isNullable = false;
        }
    }

    public void setStatusCol(String colname, int status) {
        ColumnEntry entry = this.getColumn(colname);
        entry._status |= status;
    }

    public void setPercentCol(String ... colNames) {
        for (String colname : colNames) {
            ColumnEntry entry = this.getColumn(colname);
            entry._isPct = true;
        }
    }

    public boolean isPctColumn(int column) {
        return this.getSqlColumn((int)column)._isPct;
    }

    public void setDateParseFormatCol(String colname, String pattern) {
        SimpleDateFormat sdf;
        ColumnEntry entry = this.getColumn(colname);
        entry._dateParseFormat = sdf = new SimpleDateFormat(pattern);
    }

    public int getParseColumnCount() {
        return this._numOfParseCols;
    }

    public String getDescription(String colname) {
        ColumnEntry entry = this.getColumn(colname);
        return entry._description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newObject(ColumnEntry ce, String val) {
        Object newObject = null;
        if (ce._sqlType == 93 || ce._sqlType == 91 || ce._sqlType == 92) {
            if (ce._dateParseFormat == null) {
                throw new RuntimeException("The column '" + ce._colName + "' has not set the date parsing format.");
            }
            try {
                Date date = ce._dateParseFormat.parse(val);
                if (ce._sqlType == 93) {
                    newObject = new Timestamp(date.getTime());
                }
                if (ce._sqlType == 91) {
                    newObject = new Date(date.getTime());
                }
                if (ce._sqlType != 92) return newObject;
                return new Time(date.getTime());
            }
            catch (ParseException e) {
                throw new RuntimeException("The column '" + ce._colName + "' can't parsing using the format '" + ce._dateParseFormat + "'.", e);
            }
        }
        try {
            return this.createJavaObject(ce, val);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problems when creating a new Object for the column '" + ce._colName + "'. Caught: " + e.getMessage(), e);
        }
    }

    private Object createJavaObject(ColumnEntry ce, Object val) {
        int scale;
        int sqlType = ce._sqlType;
        int n = scale = ce._scale < 0 ? 0 : ce._scale;
        if (val == null) {
            return this.getDefaultValForNull(sqlType, val, scale);
        }
        String strVal = val.toString();
        try {
            switch (sqlType) {
                case -7: {
                    return new Boolean(strVal);
                }
                case -6: {
                    return new Byte(Byte.parseByte(strVal));
                }
                case 5: {
                    return new Short(Short.parseShort(strVal));
                }
                case 4: {
                    return new Integer(strVal);
                }
                case -5: {
                    return new Long(strVal);
                }
                case 6: {
                    return new Float(strVal);
                }
                case 7: {
                    return new Float(strVal);
                }
                case 8: {
                    return new Double(strVal);
                }
                case 2: {
                    return new BigDecimal(strVal).setScale(scale, 6);
                }
                case 3: {
                    return new BigDecimal(strVal).setScale(scale, 6);
                }
                case 1: {
                    return new String(strVal);
                }
                case 12: {
                    return new String(strVal);
                }
                case -1: {
                    return new String(strVal);
                }
                case 91: {
                    return new Date(SimpleDateFormat.getInstance().parse(strVal).getTime());
                }
                case 92: {
                    return new Time(SimpleDateFormat.getInstance().parse(strVal).getTime());
                }
                case 93: {
                    return new Timestamp(SimpleDateFormat.getInstance().parse(strVal).getTime());
                }
                case -2: {
                    return new byte[0];
                }
                case -3: {
                    return new byte[0];
                }
                case -4: {
                    return new byte[0];
                }
                case 0: {
                    return null;
                }
                case 1111: {
                    return new Object();
                }
                case 2000: {
                    return new Object();
                }
                case 2004: {
                    return val;
                }
                case 2005: {
                    return val;
                }
                case 16: {
                    return new Boolean(strVal);
                }
            }
            throw new RuntimeException("Unsupported data type was found in the dictionary java.sql.Types '" + sqlType + "', value='" + val + "'.");
        }
        catch (NumberFormatException e) {
            _logger.warn((Object)("When creating a new Object for column '" + ce._colName + "' with value '" + val + "', a NumberFormatException was thrown, which implies that the value is not a number. Creating the object with a zero value instead."));
            return this.createJavaObject(ce, null);
        }
        catch (ParseException e) {
            throw new RuntimeException("Problems parsing value '" + strVal + "' of java.sql.Types '" + sqlType + "'. Caught: " + e.getMessage(), e);
        }
    }

    private Object getDefaultValForNull(int sqlType, Object val, int scale) {
        if (val != null) {
            return val;
        }
        if (scale < 0) {
            scale = 0;
        }
        switch (sqlType) {
            case -7: {
                return new Boolean(false);
            }
            case -6: {
                return new Byte(Byte.parseByte("0"));
            }
            case 5: {
                return new Short(Short.parseShort("0"));
            }
            case 4: {
                return new Integer(0);
            }
            case -5: {
                return new Long(0L);
            }
            case 6: {
                return new Float(0.0f);
            }
            case 7: {
                return new Float(0.0f);
            }
            case 8: {
                return new Double(0.0);
            }
            case 2: {
                return new BigDecimal(0).setScale(scale, 6);
            }
            case 3: {
                return new BigDecimal(0).setScale(scale, 6);
            }
            case 1: {
                return "";
            }
            case 12: {
                return "";
            }
            case -1: {
                return "";
            }
            case 91: {
                return new Date(0L);
            }
            case 92: {
                return new Time(0L);
            }
            case 93: {
                return new Timestamp(0L);
            }
            case -2: {
                return new byte[0];
            }
            case -3: {
                return new byte[0];
            }
            case -4: {
                return new byte[0];
            }
            case 0: {
                return null;
            }
            case 1111: {
                return null;
            }
            case 2000: {
                return new Object();
            }
            case 2004: {
                return "";
            }
            case 2005: {
                return "";
            }
            case 16: {
                return new Boolean(false);
            }
        }
        throw new RuntimeException("Unsupported data type was found in the dictionary java.sql.Types '" + sqlType + "', value='" + val + "'.");
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public void setCatalogName(String catalogName) {
        this._catalogName = catalogName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getCatalogName() {
        return this._catalogName;
    }

    public void setOsCommand(String osCommand) {
        this._osCommand = osCommand;
    }

    public String getOsCommand() {
        return this._osCommand;
    }

    public void setOsCommandStreaming(boolean isStreaming) {
        this._osCommandIsStreaming = isStreaming;
    }

    public boolean isOsCommandStreaming() {
        return this._osCommandIsStreaming;
    }

    public List<String> getColumnNames() {
        return this._columnNames;
    }

    public String toTraceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ModuleName/TabName       = '").append(this.getTableName()).append("'\n");
        sb.append("OS Command               = '").append(this.getOsCommand()).append("'\n");
        sb.append("OS Command is streaming  = '").append(this.isOsCommandStreaming()).append("'\n");
        sb.append("Split Regular Expression = '").append(this.getParseRegexp()).append("'\n");
        sb.append("SQL Column Count         = '").append(this.getColumnCount()).append("'\n");
        sb.append("Parse Column Count       = '").append(this.getParseColumnCount()).append("'\n");
        sb.append("Max Queue Size           = '").append(this.getMaxQueueSize()).append("'\n");
        sb.append("Skip Rows Map            = '").append(this.getSkipRowsMap()).append("'\n");
        int e = 0;
        for (ColumnEntry ce : this.getColumns()) {
            sb.append("entry ").append(StringUtil.right(++e + "", 2)).append(": ");
            sb.append("colName='").append(StringUtil.left(ce._colName + "', ", 33));
            sb.append("isPartOfPk='").append(StringUtil.left(ce._isPartOfPk + "', ", 8));
            sb.append("isStatColumn='").append(StringUtil.left(ce._isStatColumn + "', ", 8));
            sb.append("sqlDataType='").append(StringUtil.left(ce._sqlDataType + "', ", 13));
            sb.append("dispLength='").append(StringUtil.left(ce._displayLength + "', ", 5));
            sb.append("precision='").append(StringUtil.left(ce._precision + "', ", 5));
            sb.append("scale='").append(StringUtil.left(ce._scale + "', ", 5));
            sb.append("isNullable='").append(StringUtil.left(ce._isNullable + "', ", 8));
            sb.append("sqlColNum='").append(StringUtil.left(ce._sqlColNum + "', ", 5));
            sb.append("parseColNum='").append(StringUtil.left(ce._parseColNum + "', ", 5));
            sb.append("isNumber='").append(StringUtil.left(ce._isNumber + "', ", 8));
            sb.append("isPct='").append(StringUtil.left(ce._isPct + "', ", 8));
            sb.append("status='").append(StringUtil.left(ce._status + "', ", 5));
            sb.append("schemaName='").append(StringUtil.left(ce._schemaName + "', ", 33));
            sb.append("tableName='").append(StringUtil.left(ce._tableName + "', ", 33));
            sb.append("catalogName='").append(StringUtil.left(ce._catalogName + "', ", 33));
            sb.append("description='").append(ce._description).append("'");
            sb.append(".\n");
        }
        return sb.toString();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this._numOfSqlCols;
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return this.getSqlColumn((int)column)._isNullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.getSqlColumn((int)column)._displayLength;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getSqlColumn((int)column)._colName;
    }

    @Override
    public String getColumnName(int column) {
        return this.getSqlColumn((int)column)._colName;
    }

    @Override
    public String getSchemaName(int column) {
        return this.getSqlColumn((int)column)._schemaName;
    }

    @Override
    public int getPrecision(int column) {
        return this.getSqlColumn((int)column)._precision;
    }

    @Override
    public int getScale(int column) {
        return this.getSqlColumn((int)column)._scale;
    }

    @Override
    public String getTableName(int column) {
        return this.getSqlColumn((int)column)._tableName;
    }

    @Override
    public String getCatalogName(int column) {
        return this.getSqlColumn((int)column)._catalogName;
    }

    @Override
    public int getColumnType(int column) {
        return this.getSqlColumn((int)column)._sqlType;
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getSqlColumn((int)column)._sqlDataType;
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        Class<?> clazz = this.getSqlColumn((int)column)._javaClass;
        if (clazz != null) {
            return clazz.getName();
        }
        return null;
    }

    public static HostMonitorMetaData create(Configuration conf, String moduleName) throws MandatoryPropertyException {
        return HostMonitorMetaData.create(conf, moduleName, null);
    }

    public static HostMonitorMetaData create(Configuration conf, String moduleName, String osname) throws MandatoryPropertyException {
        if (conf == null) {
            throw new IllegalArgumentException("The passed Configuration can't be null");
        }
        if (osname != null && osname.trim().equals("")) {
            osname = null;
        }
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(moduleName);
        String prefix = "hostmon.udc." + moduleName + "." + (osname == null ? "-THIS-key-WILL-never-BE-found-" : osname);
        int methodArrPos = 4;
        int optionArrPos = 5;
        List<String> keyList = conf.getKeys(prefix);
        if (keyList.isEmpty()) {
            String osIndependentPrefix = "hostmon.udc." + moduleName;
            if (osname != null) {
                _logger.info((Object)("No Operating System specific property entries for '" + prefix + "' can be found, revering to OS independent settings by using the prefix '" + osIndependentPrefix + "'."));
            }
            --methodArrPos;
            --optionArrPos;
            prefix = osIndependentPrefix;
            keyList = conf.getKeys(prefix);
            if (keyList.isEmpty()) {
                throw new MandatoryPropertyException("No property entries for '" + prefix + "' can be found.");
            }
        }
        for (String key : keyList) {
            String propValue = conf.getProperty(key);
            _logger.debug((Object)("READING: key=" + StringUtil.left(key, 60) + " val='" + propValue + "'."));
            String[] keySplit = key.split("\\.");
            for (int i = 0; i < keySplit.length; ++i) {
                keySplit[i] = keySplit[i].trim();
            }
            String method = null;
            String option = null;
            if (keySplit.length >= methodArrPos + 1) {
                method = keySplit[methodArrPos];
            }
            if (keySplit.length >= optionArrPos + 1) {
                option = keySplit[optionArrPos];
            }
            String columnName = option;
            int sqlColumnNumber = -1;
            int parseColumnNumber = -1;
            boolean isNullable = true;
            String description = "";
            PropPropEntry ppe = null;
            if (propValue.startsWith("{")) {
                ppe = new PropPropEntry("DUMMY=" + propValue);
                columnName = ppe.getProperty("DUMMY", "columnName", option);
                sqlColumnNumber = ppe.getIntProperty("DUMMY", "sqlColumnNumber", -1);
                parseColumnNumber = ppe.getIntProperty("DUMMY", "parseColumnNumber", -1);
                isNullable = ppe.getBooleanProperty("DUMMY", "isNullable", true);
                description = ppe.getProperty("DUMMY", "description", "");
            }
            if (method.equals("osCommand") && option == null) {
                md.setOsCommand(propValue);
                continue;
            }
            if (method.equals("osCommand") && option != null && option.equals("isStreaming")) {
                boolean isStreaming = propValue.equalsIgnoreCase("true");
                md.setOsCommandStreaming(isStreaming);
                continue;
            }
            if (method.equals("addStrColumn")) {
                if (columnName.equals("")) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "columnName" + "' for method '" + method + "' which is mandatory.");
                }
                if (sqlColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "sqlColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                if (parseColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "parseColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                int length = ppe.getIntProperty("DUMMY", "length", -1);
                if (length < 0) {
                    length = 30;
                    _logger.warn((Object)("In '" + moduleName + "', the 'length' for String column " + columnName + " was not specified, setting this to '" + length + "'."));
                }
                md.addStrColumn(columnName, sqlColumnNumber, parseColumnNumber, isNullable, length, description);
                continue;
            }
            if (method.equals("addIntColumn")) {
                if (columnName.equals("")) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "columnName" + "' for method '" + method + "' which is mandatory.");
                }
                if (sqlColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "sqlColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                if (parseColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "parseColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                md.addIntColumn(columnName, sqlColumnNumber, parseColumnNumber, isNullable, description);
                continue;
            }
            if (method.equals("addDatetimeColumn")) {
                if (columnName.equals("")) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "columnName" + "' for method '" + method + "' which is mandatory.");
                }
                if (sqlColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "sqlColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                if (parseColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "parseColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                md.addIntColumn(columnName, sqlColumnNumber, parseColumnNumber, isNullable, description);
                continue;
            }
            if (method.equals("addStatColumn")) {
                if (columnName.equals("")) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "columnName" + "' for method '" + method + "' which is mandatory.");
                }
                if (sqlColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "sqlColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                if (parseColumnNumber == -1) {
                    throw new MandatoryPropertyException("Checking property for '" + moduleName + "': Can't find parameter '" + "parseColumnNumber" + "' for method '" + method + "' which is mandatory.");
                }
                int precision = ppe.getIntProperty("DUMMY", "precision", -1);
                int scale = ppe.getIntProperty("DUMMY", "scale", -1);
                if (precision < 0) {
                    precision = 10;
                    _logger.warn((Object)("In '" + moduleName + "', the 'precision' for Statistics column " + columnName + " was not specified, setting this to '" + precision + "'."));
                }
                if (scale < 0) {
                    scale = 1;
                    _logger.warn((Object)("In '" + moduleName + "', the 'scale' for column " + columnName + " was not specified, setting this to '" + scale + "'."));
                }
                md.addStatColumn(columnName, sqlColumnNumber, parseColumnNumber, isNullable, precision, scale, description);
                continue;
            }
            if (method.equals("setPkColumns")) {
                String[] cols = propValue.split(",");
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = cols[i].trim();
                }
                md.setPkCol(cols);
                continue;
            }
            if (method.equals("setPercentColumns")) {
                String[] cols = propValue.split(",");
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = cols[i].trim();
                }
                md.setPercentCol(cols);
                continue;
            }
            if (method.equals("setSubSampleColumn")) {
                md.setStatusCol(propValue, 1);
                continue;
            }
            if (method.equals("setParseRegexp")) {
                md.setParseRegexp(propValue);
                continue;
            }
            if (method.equals("skipRows")) {
                String colNameToSkipValueFor = option;
                String valueToSkip = propValue;
                md.setSkipRows(colNameToSkipValueFor, valueToSkip);
                continue;
            }
            if (method.equals("allowRows")) {
                String colNameToAllowValueFor = option;
                String valueToAllow = propValue;
                md.setAllowRows(colNameToAllowValueFor, valueToAllow);
                continue;
            }
            if (method.equals("displayName") || method.equals("description") || method.equals("graph")) continue;
            _logger.warn((Object)("Unknown method type '" + method + "' when creating MetaData for module '" + moduleName + "'."));
        }
        if (md.getOsCommand() == null) {
            throw new MandatoryPropertyException("The property 'hostmon.udc." + moduleName + ".osCommand' is mandatory.");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("HostMonitorMetaData create() method returns: \n" + md.toTraceString()));
        }
        return md;
    }

    public void setSkipAndAllowRows(String prefix, Configuration conf) {
        if (prefix == null) {
            prefix = "hostmon." + this.getTableName() + ".";
        }
        if (conf == null) {
            conf = Configuration.getCombinedConfiguration();
        }
        for (String key : conf.getKeys(prefix)) {
            String propValue = conf.getProperty(key);
            String[] keySplit = key.split("\\.");
            for (int i = 0; i < keySplit.length; ++i) {
                keySplit[i] = keySplit[i].trim();
            }
            int methodArrPos = 2;
            int optionArrPos = 3;
            String method = null;
            String option = null;
            if (keySplit.length >= methodArrPos + 1) {
                method = keySplit[methodArrPos];
            }
            if (keySplit.length >= optionArrPos + 1) {
                option = keySplit[optionArrPos];
            }
            if (method.equals("skipRows")) {
                String colNameToSkipValueFor = option;
                String valueToSkip = propValue;
                this.setSkipRows(colNameToSkipValueFor, valueToSkip);
                continue;
            }
            if (!method.equals("allowRows")) continue;
            String colNameToAllowValueFor = option;
            String valueToAllow = propValue;
            this.setAllowRows(colNameToAllowValueFor, valueToAllow);
        }
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "DEBUG, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        Configuration conf = new Configuration();
        conf.setProperty("hostmon.udc.TestXXX.osCommand", "iostat -xdzk 3");
        conf.setProperty("hostmon.udc.TestXXX.osCommand.isStreaming", "true");
        conf.setProperty("hostmon.udc.TestXXX.addStrColumn.device", "{length=30,             sqlColumnNumber=1,  parseColumnNumber=1,  isNullable=false, description=Disk device name}");
        conf.setProperty("hostmon.udc.TestXXX.addIntColumn.numOfSamples", "{                       sqlColumnNumber=2,  parseColumnNumber=0,  isNullable=true,  description=Number of 'sub' sample entries of iostat this value is based on}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.rrqmPerSec", "{precision=10, scale=1, sqlColumnNumber=3,  parseColumnNumber=2,  isNullable=true,  description=The number of read requests merged per second that were queued to the device}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.wrqmPerSec", "{precision=10, scale=1, sqlColumnNumber=4,  parseColumnNumber=3,  isNullable=true,  description=The number of write requests merged per second that were queued to the device.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.readsPerSec", "{precision=10, scale=1, sqlColumnNumber=5,  parseColumnNumber=4,  isNullable=true,  description=The number of read requests that were issued to the device per second.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.writesPerSec", "{precision=10, scale=1, sqlColumnNumber=6,  parseColumnNumber=5,  isNullable=true,  description=The number of write requests that were issued to the device per second.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.kbReadPerSec", "{precision=10, scale=1, sqlColumnNumber=7,  parseColumnNumber=6,  isNullable=true,  description=The number of kilobytes read from the device per second.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.kbWritePerSec", "{precision=10, scale=1, sqlColumnNumber=8,  parseColumnNumber=7,  isNullable=true,  description=The number of kilobytes writ to the device per second.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.avgrq-sz", "{precision=10, scale=1, sqlColumnNumber=9,  parseColumnNumber=8,  isNullable=true,  description=The average size (in  sectors) of the requests that were issued to the device.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.avgqu-sz", "{precision=10, scale=1, sqlColumnNumber=10, parseColumnNumber=9,  isNullable=true,  description=The average queue length of the requests that were issued to the device.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.await", "{precision=10, scale=1, sqlColumnNumber=11, parseColumnNumber=10, isNullable=true,  description=The average time (in milliseconds) for I/O requests issued to the device to be served. This includes the time spent by the requests in queue and the time spent servicing them.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.svctm", "{precision=10, scale=1, sqlColumnNumber=12, parseColumnNumber=11, isNullable=true,  description=The average service time (in milliseconds) for I/O requests that were issued to the device.}");
        conf.setProperty("hostmon.udc.TestXXX.addStatColumn.utilPct", "{precision=10, scale=1, sqlColumnNumber=13, parseColumnNumber=12, isNullable=true,  description=Percentage of CPU time during which I/O requests were issued to the device (bandwidth utilization for the device). Device saturation occurs when this value is close to 100%.}");
        conf.setProperty("hostmon.udc.TestXXX.setPkColumns", "device");
        conf.setProperty("hostmon.udc.TestXXX.setPercentColumns", "utilPct, await,svctm");
        conf.setProperty("hostmon.udc.TestXXX.setSubSampleColumn", "numOfSamples");
        conf.setProperty("hostmon.udc.TestXXX.setParseRegexp", "theRegExp");
        conf.setProperty("hostmon.udc.TestXXX.skipRows.device", "Device:");
        try {
            HostMonitorMetaData md = HostMonitorMetaData.create(conf, "TestXXX");
            System.out.println("====================================================");
            System.out.println("MD=\n" + md.toTraceString());
            System.out.println("----------------------------------------------------");
        }
        catch (MandatoryPropertyException e) {
            e.printStackTrace();
        }
    }

    public static class ColumnEntry
    implements Comparable<ColumnEntry> {
        int _sqlColNum = -1;
        int _parseColNum = -1;
        String _colName = null;
        int _sqlType = 0;
        String _sqlDataType = null;
        Class<?> _javaClass = null;
        boolean _isNumber = false;
        int _displayLength = 0;
        boolean _isNullable = true;
        boolean _isPartOfPk = false;
        boolean _isStatColumn = false;
        boolean _isPct = false;
        String _schemaName = null;
        String _tableName = null;
        String _catalogName = null;
        int _precision = -1;
        int _scale = -1;
        String _description = "";
        int _status = 0;
        SimpleDateFormat _dateParseFormat = null;

        @Override
        public int compareTo(ColumnEntry ce) {
            return this._sqlColNum < ce._sqlColNum ? -1 : (this._sqlColNum == ce._sqlColNum ? 0 : 1);
        }
    }
}

