/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.utils.Configuration;

public class MonitorIoSolaris
extends MonitorIo {
    @Override
    public String getModuleName() {
        return "MonitorIoSolaris";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "iostat -xdz " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("device", 1, 1, false, 30, "Disk device name");
        md.addIntColumn("samples", 2, 0, true, "Number of 'sub' sample entries of iostat this value is based on");
        md.addStatColumn("readsPerSec", 3, 2, true, 5, 1, "Reads per second");
        md.addStatColumn("writesPerSec", 4, 3, true, 5, 1, "Writes per second");
        md.addStatColumn("kbReadPerSec", 5, 4, true, 10, 1, "KB read per second");
        md.addStatColumn("kbWritePerSec", 6, 5, true, 10, 1, "KB written per second");
        md.addStatColumn("wait", 7, 6, true, 5, 1, "Average number of transactions waiting for service (Q length)");
        md.addStatColumn("actv", 8, 7, true, 5, 1, "Average number of transactions actively being serviced (removed from the queue but not yet completed)");
        md.addStatColumn("svc_t", 9, 8, true, 5, 1, "Service time (ms). Includes everything: wait time, active queue time, seek rotation, transfer time");
        md.addStatColumn("waitPct", 10, 9, true, 4, 1, "Percent of time there are transactions waiting for service (queue non-empty)");
        md.addStatColumn("busyPct", 11, 10, true, 4, 1, "Percent of time the disk is busy (transactions in progress)");
        md.setPkCol("device");
        md.setStatusCol("samples", 1);
        md.setPercentCol("waitPct");
        md.setPercentCol("busyPct");
        md.setParseRegexp("\\s+");
        md.setSkipRows("device", "device");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorIo.", Configuration.getCombinedConfiguration());
        return md;
    }
}

