/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorVmstat;
import asemon.utils.Configuration;

public class MonitorMpstatAix
extends MonitorVmstat {
    private int _pos_S0rd;
    private int _pos_S1rd;
    private int _pos_S2rd;
    private int _pos_S3rd;
    private int _pos_S4rd;
    private int _pos_S5rd;

    @Override
    public String getModuleName() {
        return "MonitorMpstatAix";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "mpstat -a " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("cpu", 1, 1, false, 5, "Without the -a option, mpstat reports CPU statistics for a processor ID. With the -a option, mpstat reports SET statistics for a processor set ID.");
        md.addIntColumn("samples", 2, 0, true, "Number of 'sub' sample entries of iostat this value is based on");
        md.addStatColumn("min", 3, 2, true, 7, 1, "The minor page faults (page faults with no IO).");
        md.addStatColumn("maj", 4, 3, true, 7, 1, "The major page faults (page faults with disk IO).");
        md.addStatColumn("mpcs", 5, 4, true, 7, 1, "The number of mpc send interrupts.");
        md.addStatColumn("mpcr", 6, 5, true, 7, 1, "The number of mpc receive interrupts.");
        md.addStatColumn("dev", 7, 6, true, 7, 1, "The number of device interrupts.");
        md.addStatColumn("soft", 8, 7, true, 7, 1, "The number of software interrupts.");
        md.addStatColumn("dec", 9, 8, true, 7, 1, "The number of decrementer interrupts.");
        md.addStatColumn("ph", 10, 9, true, 7, 1, "The number of phantom interrupts.");
        md.addStatColumn("cs", 11, 10, true, 7, 1, "The total number of context switches.");
        md.addStatColumn("ics", 12, 12, true, 7, 1, "The total number of involuntary context switches.");
        md.addStatColumn("bound", 13, 12, true, 7, 1, "The total number of threads that are bound.");
        md.addStatColumn("rq", 14, 13, true, 7, 1, "The run queue size.");
        md.addStatColumn("push", 15, 14, true, 7, 1, "The number of migrations due to starvation load balancing.");
        md.addStatColumn("S3pull", 16, 15, true, 7, 1, "The number of migrations outside the scheduling affinity domain 3 due to idle stealing.");
        md.addStatColumn("S3grd", 17, 16, true, 7, 1, "The number of dispatches from global runqueue, outside the scheduling affinity domain 3.");
        md.addStatColumn("S0rd", 18, 17, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 0.");
        md.addStatColumn("S1rd", 19, 18, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 1.");
        md.addStatColumn("S2rd", 20, 19, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 2.");
        md.addStatColumn("S3rd", 21, 20, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 3.");
        md.addStatColumn("S4rd", 22, 21, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 4.");
        md.addStatColumn("S5rd", 23, 22, true, 7, 1, "The percentage of thread redispatches within the scheduling affinity domain 5.");
        md.addStatColumn("sysc", 24, 23, true, 7, 1, "The number of system calls.");
        md.addStatColumn("us", 25, 24, true, 7, 1, "The percentage of physical processor utilization that occurred while executing at the user level (application).");
        md.addStatColumn("sy", 26, 25, true, 7, 1, "The percentage of physical processor utilization that occurred while executing at the system level (kernel).");
        md.addStatColumn("wt", 27, 26, true, 7, 1, "The percentage of time that the logical processor was idle and it did not have an outstanding disk I/O request.");
        md.addStatColumn("id", 28, 27, true, 7, 1, "The percentage of time that the logical processor was idle during which it had an outstanding disk I/O request.");
        md.addStatColumn("pc", 29, 28, true, 7, 1, "The fraction of physical processor consumed. It is displayed in both shared partition and dedicated partition. For the default flag in the dedicated partition, it is not displayed when both donation and simultaneous multithreading are disabled. The pc of the cpuid U row represents the number of unused physical processors.");
        md.addStatColumn("ilcs", 30, 29, true, 7, 1, "The number of involuntary logical CPU context switches, displayed only in shared partition. For the -h and -a flags, it is also displayed in dedicated partition.");
        md.addStatColumn("vlcs", 31, 30, true, 7, 1, "The number of voluntary logical CPU context switches. Displayed only in shared partition. For the -h and -a flags, it is also displayed in dedicated partition.");
        md.addStatColumn("istol", 32, 31, true, 7, 1, "The percentage of physical processor utilization that occurs while the Hypervisor is stealing idle cycles. Displayed only in dedicated partition.");
        md.addStatColumn("bstol", 33, 32, true, 7, 1, "The percentage of physical processor utilization that occurs while the Hypervisor is stealing busy cycles. Displayed only in dedicated partition.");
        md.setPercentCol("S0rd");
        md.setPercentCol("S1rd");
        md.setPercentCol("S2rd");
        md.setPercentCol("S3rd");
        md.setPercentCol("S4rd");
        md.setPercentCol("S5rd");
        md.setPercentCol("us");
        md.setPercentCol("sy");
        md.setPercentCol("wt");
        md.setPercentCol("id");
        md.setPercentCol("istol");
        md.setPercentCol("bstol");
        md.setPkCol("cpu");
        md.setStatusCol("samples", 1);
        md.setParseRegexp("\\s+");
        md.setSkipRows("cpu", "cpu");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorMpstat.", Configuration.getCombinedConfiguration());
        this._pos_S0rd = md.getParseColumnArrayPos("S0rd");
        this._pos_S1rd = md.getParseColumnArrayPos("S1rd");
        this._pos_S2rd = md.getParseColumnArrayPos("S2rd");
        this._pos_S3rd = md.getParseColumnArrayPos("S3rd");
        this._pos_S4rd = md.getParseColumnArrayPos("S4rd");
        this._pos_S5rd = md.getParseColumnArrayPos("S5rd");
        return md;
    }

    @Override
    public String[] parseRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        if (preParsed.length == md.getParseColumnCount()) {
            if (this.skipRow(md, row, preParsed, type)) {
                return null;
            }
            if (!this.allowRow(md, row, preParsed, type)) {
                return null;
            }
            if ("-".equals(preParsed[this._pos_S0rd])) {
                preParsed[this._pos_S0rd] = "0.0";
            }
            if ("-".equals(preParsed[this._pos_S1rd])) {
                preParsed[this._pos_S1rd] = "0.0";
            }
            if ("-".equals(preParsed[this._pos_S2rd])) {
                preParsed[this._pos_S2rd] = "0.0";
            }
            if ("-".equals(preParsed[this._pos_S3rd])) {
                preParsed[this._pos_S3rd] = "0.0";
            }
            if ("-".equals(preParsed[this._pos_S4rd])) {
                preParsed[this._pos_S4rd] = "0.0";
            }
            if ("-".equals(preParsed[this._pos_S5rd])) {
                preParsed[this._pos_S5rd] = "0.0";
            }
            return preParsed;
        }
        return null;
    }
}

