/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorVmstat;
import asemon.utils.Configuration;

public class MonitorVmstatLinux
extends MonitorVmstat {
    @Override
    public String getModuleName() {
        return "MonitorVmstatLinux";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "vmstat " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addDatetimeColumn("sampleTime", 1, 0, true, "Approximately when this record was samples");
        md.addIntColumn("procs_r", 2, 1, true, "The number of processes waiting for run time.");
        md.addIntColumn("procs_b", 3, 2, true, "The number of processes in uninterruptible sleep.");
        md.addIntColumn("memory_swpd", 4, 3, true, "the amount of virtual memory used.");
        md.addIntColumn("memory_free", 5, 4, true, "the amount of idle memory.");
        md.addIntColumn("memory_buff", 6, 5, true, "the amount of memory used as buffers.");
        md.addIntColumn("memory_cache", 7, 6, true, "the amount of memory used as cache.");
        md.addIntColumn("swap_si", 8, 7, true, "Amount of memory swapped in from disk (/s).");
        md.addIntColumn("swap_so", 9, 8, true, "Amount of memory swapped to disk (/s).");
        md.addIntColumn("io_bi", 10, 9, true, "Blocks received from a block device (blocks/s).");
        md.addIntColumn("io_bo", 11, 10, true, "Blocks sent to a block device (blocks/s).");
        md.addIntColumn("system_in", 12, 11, true, "The number of interrupts per second, including the clock.");
        md.addIntColumn("system_cs", 13, 12, true, "The number of context switches per second.");
        md.addIntColumn("cpu_us", 14, 13, true, "Time spent running non-kernel code. (user time, including nice time)");
        md.addIntColumn("cpu_sy", 15, 14, true, "Time spent running kernel code. (system time)");
        md.addIntColumn("cpu_id", 16, 15, true, "Time spent idle. Prior to Linux 2.5.41, this includes IO-wait time.");
        md.addIntColumn("cpu_wa", 17, 16, true, "Time spent waiting for IO. Prior to Linux 2.5.41, included in idle.");
        md.addIntColumn("cpu_st", 18, 17, true, "Time stolen from a virtual machine. Prior to Linux 2.6.11, unknown.");
        md.setPercentCol("cpu_us");
        md.setPercentCol("cpu_sy");
        md.setPercentCol("cpu_id");
        md.setPercentCol("cpu_wa");
        md.setPercentCol("cpu_st");
        md.setStatusCol("sampleTime", 2);
        md.setParseRegexp("\\s+");
        md.setSkipRows("memory_swpd", "swpd");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorVmstat.", Configuration.getCombinedConfiguration());
        return md;
    }

    @Override
    public String[] parseRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        if (preParsed.length + 1 == md.getParseColumnCount()) {
            String[] tmp = new String[preParsed.length + 1];
            System.arraycopy(preParsed, 0, tmp, 0, preParsed.length);
            tmp[tmp.length - 1] = "0";
            preParsed = tmp;
        }
        return super.parseRow(md, row, preParsed, type);
    }
}

