/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.OsTableRow;

public class OsTableRowSummary
extends OsTableRow {
    private int _numOfSamples = 0;

    public OsTableRowSummary(HostMonitorMetaData md, String pk) {
        this._md = md;
        int sqlCols = this._md.getColumnCount();
        this._pkStr = pk;
        this._values = new Object[sqlCols];
        String[] pkStrPart = pk.split(":");
        int pkPos = 0;
        for (HostMonitorMetaData.ColumnEntry ce : this._md.getColumns()) {
            if (ce._parseColNum <= 0) continue;
            String val = null;
            if (ce._isPartOfPk) {
                val = pkStrPart[pkPos++];
            }
            int dp = ce._sqlColNum - 1;
            this._values[dp] = this._md.newObject(ce, val);
        }
        if (this._pkStr.endsWith(":")) {
            this._pkStr = this._pkStr.substring(0, this._pkStr.length() - 1);
        }
    }

    public void addToSummary(OsTableRow entryToAdd) {
        ++this._numOfSamples;
        for (HostMonitorMetaData.ColumnEntry ce : this._md.getColumns()) {
            Object addVal;
            int dp = ce._sqlColNum - 1;
            if (ce._isStatColumn) {
                Object thisVal = this._values[dp];
                Object addVal2 = entryToAdd._values[dp];
                if (thisVal instanceof Number && addVal2 instanceof Number) {
                    Number nThisVal = (Number)this._values[dp];
                    Number nAddVal = (Number)entryToAdd._values[dp];
                    String nStr = Double.toString(nThisVal.doubleValue() + nAddVal.doubleValue());
                    this._values[dp] = this._md.newObject(ce, nStr);
                    continue;
                }
                throw new RuntimeException("Unsupported data type for column '" + ce._colName + "' when adding to summary currentValue('" + thisVal + "')=" + thisVal.getClass().getName() + ", addValue('" + addVal2 + "')=" + addVal2.getClass().getName() + ".");
            }
            this._values[dp] = addVal = entryToAdd._values[dp];
        }
    }

    public void calcAverage() {
        for (HostMonitorMetaData.ColumnEntry ce : this._md.getColumns()) {
            int dp = ce._sqlColNum - 1;
            if (ce._status == 1) {
                this._values[dp] = this._md.newObject(ce, Integer.toString(this._numOfSamples));
            }
            if (this._numOfSamples == 0 || !ce._isStatColumn) continue;
            Object thisVal = this._values[dp];
            if (thisVal instanceof Number) {
                Number nThisVal = (Number)this._values[dp];
                String nStr = Double.toString(nThisVal.doubleValue() / (double)this._numOfSamples);
                this._values[dp] = this._md.newObject(ce, nStr);
                continue;
            }
            throw new RuntimeException("Unsupported data type for column '" + ce._colName + "' when calculating average on value='" + thisVal + "' of type '" + thisVal.getClass().getName() + "'.");
        }
    }
}

