/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class SshConnection {
    private static Logger _logger = Logger.getLogger(SshConnection.class);
    private String _username = null;
    private String _password = null;
    private String _hostname = null;
    private int _port = 22;
    private Connection _conn = null;
    private boolean _isConnected = false;
    private String _uname = null;
    private String _osName = null;
    private String _osCharset = null;
    private boolean _isAuthenticated = false;
    public static final int STDOUT_DATA = 4;
    public static final int STDERR_DATA = 8;

    public SshConnection() {
    }

    public SshConnection(String hostname, String username, String password) {
        this(hostname, 22, username, password);
    }

    public SshConnection(String hostname, int port, String username, String password) {
        this._hostname = hostname;
        this._port = port;
        this._username = username;
        this._password = password;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setHost(String host) {
        this._hostname = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getHost() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public boolean connect() throws IOException {
        if (this._username == null || this._username != null && this._username.trim().equals("")) {
            throw new IllegalArgumentException("Trying to connect to a SSH host, but 'username' fields is net yet given.");
        }
        if (this._password == null || this._password != null && this._password.trim().equals("")) {
            throw new IllegalArgumentException("Trying to connect to a SSH host, but 'password' fields is net yet given.");
        }
        if (this._hostname == null || this._hostname != null && this._hostname.trim().equals("")) {
            throw new IllegalArgumentException("Trying to connect to a SSH host, but 'hostname' fields is net yet given.");
        }
        if (this._conn == null) {
            this._conn = new Connection(this._hostname, this._port);
        }
        this._conn.connect();
        this._isAuthenticated = this._conn.authenticateWithPassword(this._username, this._password);
        if (!this._isAuthenticated) {
            throw new IOException("Authentication failed to host='" + this._hostname + "', on port='" + this._port + "', with username='" + this._username + "'.");
        }
        _logger.info((Object)("Just Connected to SSH host '" + this._hostname + "' on port '" + this._port + "' with user '" + this._username + "'."));
        this.getOsInfo();
        _logger.info((Object)("The host SSH host '" + this._hostname + "' has '" + this.getOsName() + "' as it's Operating System. My guess is that it's using character set '" + this.getOsCharset() + "'."));
        this._isConnected = true;
        return true;
    }

    public boolean reconnect() throws IOException {
        if (!this._isAuthenticated) {
            throw new IOException("Cant't do reconnect yet, you need to have a valid connection first. This means that you need to caoonect with a successful authentication first.");
        }
        this._conn.close();
        _logger.info((Object)("Trying to reconnect to SSH host '" + this._hostname + "' on port '" + this._port + "' with user '" + this._username + "'."));
        return this.connect();
    }

    public void close() {
        if (this._conn != null) {
            _logger.debug((Object)("Closing the connection to SSH host '" + this._hostname + "' on port '" + this._port + "' with user '" + this._username + "'."));
            this._conn.close();
        }
        this._conn = null;
        this._isConnected = false;
    }

    public boolean isConnected() {
        if (this._conn == null) {
            this._isConnected = false;
        }
        return this._isConnected;
    }

    public boolean isClosed() {
        return !this.isConnected();
    }

    public Session openSession() throws IOException {
        return this._conn.openSession();
    }

    public synchronized Session execCommand(String command) throws IOException {
        if (this._conn == null) {
            throw new IOException("The SSH connection to the host '" + this._hostname + "' was null. The connection has not been initialized OR someone has closed the connection.");
        }
        try {
            Session sess = this._conn.openSession();
            _logger.debug((Object)("Executing command '" + command + "' on connection: " + this.toString()));
            sess.execCommand(command);
            return sess;
        }
        catch (IllegalStateException e) {
            if (this._isAuthenticated) {
                _logger.info((Object)("The Connection to SSH host '" + this._hostname + "' on port '" + this._port + "' seems to be lost/closed. I will try reconnect and, execute the command '" + command + "' again. Caught: " + e));
                this.reconnect();
                Session sess = this._conn.openSession();
                _logger.info((Object)("Re-Executing command '" + command + "' after the reconnect."));
                sess.execCommand(command);
                return sess;
            }
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("connection is closed") >= 0 && this._isAuthenticated) {
                _logger.info((Object)("The Connection to SSH host '" + this._hostname + "' on port '" + this._port + "' seems to be lost/closed. I will try reconnect and, execute the command '" + command + "' again."));
                this.reconnect();
                Session sess = this._conn.openSession();
                _logger.info((Object)("Re-Executing command '" + command + "' after the reconnect."));
                sess.execCommand(command);
                return sess;
            }
            throw e;
        }
    }

    public String getOsCharset() {
        return this._osCharset;
    }

    public String getOsName() {
        return this._osName;
    }

    public String getOsInfo() throws IOException {
        String line;
        if (this._uname != null) {
            return this._uname;
        }
        Session sess = this._conn.openSession();
        sess.execCommand("uname -a");
        StreamGobbler stdout = new StreamGobbler(sess.getStdout());
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout));
        String output = "";
        while ((line = br.readLine()) != null) {
            output = output + line;
        }
        sess.close();
        this._uname = output;
        if (this._uname != null) {
            String[] sa = this._uname.split(" ");
            this._osName = sa[0];
            this._osCharset = this._osName.equals("Linux") ? "UTF-8" : (this._osName.equals("SunOS") ? "ISO-8859-1" : (this._osName.equals("AIX") ? "ISO-8859-1" : (this._osName.equals("HP-UX") ? "ISO-8859-1" : null)));
        }
        _logger.debug((Object)("OS Info: 'uname -a' produced '" + this._uname + "'."));
        return output;
    }

    public boolean hasVeritas() throws IOException {
        String line;
        Session sess = this._conn.openSession();
        sess.execCommand("vxstat");
        StreamGobbler stdout = new StreamGobbler(sess.getStdout());
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout));
        while ((line = br.readLine()) != null) {
            _logger.debug((Object)("hasVeritas(): " + line));
        }
        boolean retStatus = true;
        Integer exitCode = sess.getExitStatus();
        if (exitCode == null || exitCode != null && exitCode != 0) {
            retStatus = false;
        }
        sess.close();
        _logger.debug((Object)("hasVeritas(): returned " + retStatus));
        return retStatus;
    }

    public String toString() {
        return "host='" + this._hostname + ":" + this._port + "', " + "user='" + this._username + "', " + "osName='" + this._osName + "', " + "osCharset='" + this._osCharset + "', " + "isConnected='" + this._isConnected + "'.";
    }
}

