/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.AseConfig;
import asemon.TrendGraphDataPoint;
import asemon.cm.CountersModel;
import asemon.pcs.IPersistWriter;
import asemon.pcs.PersistContainer;
import asemon.utils.Configuration;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class PersistWriterBase
implements IPersistWriter {
    private static Logger _logger = Logger.getLogger(PersistWriterBase.class);
    public static final int VERSION_INFO = 0;
    public static final int SESSIONS = 1;
    public static final int SESSION_PARAMS = 2;
    public static final int SESSION_SAMPLES = 3;
    public static final int SESSION_SAMPLE_SUM = 4;
    public static final int SESSION_SAMPLE_DETAILES = 5;
    public static final int SESSION_MON_TAB_DICT = 6;
    public static final int SESSION_MON_TAB_COL_DICT = 7;
    public static final int SESSION_ASE_CONFIG = 8;
    public static final int SESSION_ASE_CONFIG_TEXT = 9;
    public static final int ABS = 100;
    public static final int DIFF = 101;
    public static final int RATE = 102;
    public static String qic = "\"";
    private String _databaseProductName = "";
    public static String DB_PROD_NAME_ASE = "Adaptive Server Enterprise";
    public static String DB_PROD_NAME_ASA = "SQL Anywhere";
    public static String DB_PROD_NAME_H2 = "H2";
    private List<String> _saveDdlIsCalled = new LinkedList<String>();
    private int _inserts = 0;
    private int _updates = 0;
    private int _deletes = 0;
    private int _createTables = 0;
    private int _alterTables = 0;
    private int _dropTables = 0;
    private boolean _isSessionStarted = false;
    private Timestamp _sessionStartTime = null;

    @Override
    public abstract String getName();

    @Override
    public abstract void init(Configuration var1) throws Exception;

    @Override
    public void incInserts() {
        ++this._inserts;
    }

    @Override
    public void incUpdates() {
        ++this._updates;
    }

    @Override
    public void incDeletes() {
        ++this._deletes;
    }

    @Override
    public void incInserts(int cnt) {
        this._inserts += cnt;
    }

    @Override
    public void incUpdates(int cnt) {
        this._updates += cnt;
    }

    @Override
    public void incDeletes(int cnt) {
        this._deletes += cnt;
    }

    @Override
    public void incCreateTables() {
        ++this._createTables;
    }

    @Override
    public void incAlterTables() {
        ++this._alterTables;
    }

    @Override
    public void incDropTables() {
        ++this._dropTables;
    }

    @Override
    public void incCreateTables(int cnt) {
        this._createTables += cnt;
    }

    @Override
    public void incAlterTables(int cnt) {
        this._alterTables += cnt;
    }

    @Override
    public void incDropTables(int cnt) {
        this._dropTables += cnt;
    }

    @Override
    public int getInserts() {
        return this._inserts;
    }

    @Override
    public int getUpdates() {
        return this._updates;
    }

    @Override
    public int getDeletes() {
        return this._deletes;
    }

    @Override
    public int getCreateTables() {
        return this._createTables;
    }

    @Override
    public int getAlterTables() {
        return this._alterTables;
    }

    @Override
    public int getDropTables() {
        return this._dropTables;
    }

    @Override
    public void resetCounters() {
        this._inserts = 0;
        this._updates = 0;
        this._deletes = 0;
        this._createTables = 0;
        this._alterTables = 0;
        this._dropTables = 0;
    }

    @Override
    public void beginOfSample(PersistContainer cont) {
    }

    @Override
    public void endOfSample(PersistContainer cont, boolean caughtErrors) {
    }

    @Override
    public boolean isSessionStarted() {
        return this._isSessionStarted;
    }

    @Override
    public void setSessionStarted(boolean isSessionStarted) {
        this._isSessionStarted = isSessionStarted;
    }

    @Override
    public void startSession(PersistContainer cont) {
    }

    @Override
    public void setSessionStartTime(Timestamp sessionStartTime) {
        this._sessionStartTime = sessionStartTime;
    }

    @Override
    public Timestamp getSessionStartTime() {
        return this._sessionStartTime;
    }

    @Override
    public void saveCounters(CountersModel cm) {
    }

    @Override
    public boolean saveDdl(CountersModel cm) {
        return true;
    }

    public void clearIsDdlCreatedCache() {
        _logger.info((Object)"Clearing the in-memory cache, which tells us if a specific table has been created or not.");
        this._saveDdlIsCalled.clear();
    }

    @Override
    public boolean isDdlCreated(CountersModel cm) {
        String tabName = cm.getName();
        return this._saveDdlIsCalled.contains(tabName);
    }

    public boolean isDdlCreated(String tabName) {
        return this._saveDdlIsCalled.contains(tabName);
    }

    @Override
    public void markDdlAsCreated(CountersModel cm) {
        String tabName = cm.getName();
        this._saveDdlIsCalled.add(tabName);
    }

    public void markDdlAsCreated(String tabName) {
        this._saveDdlIsCalled.add(tabName);
    }

    public void setDatabaseProductName(String databaseProductName) {
        this._databaseProductName = databaseProductName;
    }

    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    public String fill(String str, int fill) {
        if (str.length() < fill) {
            String fillStr = "                                                              ";
            return (str + fillStr).substring(0, fill);
        }
        return str;
    }

    public String getDatatype(String type, int length, int prec, int scale) {
        if (type.equals("char") || type.equals("varchar")) {
            type = type + "(" + length + ")";
        }
        if (type.equals("numeric") || type.equals("decimal")) {
            type = type + "(" + prec + "," + scale + ")";
        }
        return type;
    }

    public String getDatatype(int col, ResultSetMetaData rsmd, boolean isDeltaOrPct) throws SQLException {
        String type = null;
        int length = -1;
        int prec = -1;
        int scale = -1;
        if (isDeltaOrPct) {
            type = "numeric";
            length = -1;
            prec = 10;
            scale = 1;
        } else {
            type = rsmd.getColumnTypeName(col);
            if (type.equals("char") || type.equals("varchar")) {
                length = rsmd.getColumnDisplaySize(col);
                prec = -1;
                scale = -1;
            }
            if (type.equals("numeric") || type.equals("decimal")) {
                length = -1;
                prec = rsmd.getPrecision(col);
                scale = rsmd.getScale(col);
            }
        }
        return this.getDatatype(type, length, prec, scale);
    }

    public String getNullable(boolean nullable) {
        return nullable ? "    null" : "not null";
    }

    public String getNullable(int col, ResultSetMetaData rsmd, boolean isDeltaOrPct) throws SQLException {
        String type = rsmd.getColumnTypeName(col);
        if (type != null && type.equalsIgnoreCase("bit")) {
            return this.getNullable(false);
        }
        return this.getNullable(true);
    }

    public static String getTableName(int type, CountersModel cm, boolean addQuotedIdentifierChar) {
        String q = "";
        if (addQuotedIdentifierChar) {
            q = qic;
        }
        switch (type) {
            case 0: {
                return q + "MonVersionInfo" + q;
            }
            case 1: {
                return q + "MonSessions" + q;
            }
            case 2: {
                return q + "MonSessionParams" + q;
            }
            case 3: {
                return q + "MonSessionSamples" + q;
            }
            case 4: {
                return q + "MonSessionSampleSum" + q;
            }
            case 5: {
                return q + "MonSessionSampleDetailes" + q;
            }
            case 6: {
                return q + "MonSessionMonTablesDict" + q;
            }
            case 7: {
                return q + "MonSessionMonTabColumnsDict" + q;
            }
            case 8: {
                return q + "MonSessionAseConfig" + q;
            }
            case 9: {
                return q + "MonSessionAseConfigText" + q;
            }
            case 100: {
                return q + cm.getName() + "_abs" + q;
            }
            case 101: {
                return q + cm.getName() + "_diff" + q;
            }
            case 102: {
                return q + cm.getName() + "_rate" + q;
            }
        }
        throw new RuntimeException("Unknown type of '" + type + "' in getTableName().");
    }

    public static String getTableName(CountersModel cm, TrendGraphDataPoint tgdp, boolean addQuotedIdentifierChar) {
        String q = "";
        if (addQuotedIdentifierChar) {
            q = qic;
        }
        String tabName = q + cm.getName() + "_" + tgdp.getName() + q;
        return tabName;
    }

    public String getTableDdlString(int type, CountersModel cm) throws SQLException {
        StringBuffer sbSql;
        block19: {
            String tabName = PersistWriterBase.getTableName(type, cm, true);
            sbSql = new StringBuffer();
            try {
                if (type == 0) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ProductString" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "VersionString" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "BuildString" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "SourceDate" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "SourceRev" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("\n");
                    sbSql.append("   ,PRIMARY KEY (" + qic + "SessionStartTime" + qic + ")\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 1) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ServerName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "NumOfSamples" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "LastSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("\n");
                    sbSql.append("   ,PRIMARY KEY (" + qic + "SessionStartTime" + qic + ")\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 2) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Type" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 10, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ParamName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 255, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ParamValue" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 4096, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("\n");
                    sbSql.append("   ,PRIMARY KEY (" + qic + "SessionStartTime" + qic + ", " + qic + "ParamName" + qic + ")\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 3) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "SessionSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("\n");
                    sbSql.append("   ,PRIMARY KEY (" + qic + "SessionSampleTime" + qic + ", " + qic + "SessionStartTime" + qic + ")\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 4) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "CmName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "absSamples" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "diffSamples" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "rateSamples" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("\n");
                    sbSql.append("   ,PRIMARY KEY (" + qic + "SessionStartTime" + qic + ", " + qic + "CmName" + qic + ")\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 5) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "SessionSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "CmName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "type" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "graphCount" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "absRows" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "diffRows" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "rateRows" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "sqlRefreshTime" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "guiRefreshTime" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "lcRefreshTime" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 6) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TableID" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Columns" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Parameters" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Indicators" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Size" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TableName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Description" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 1800, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 7) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TableID" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ColumnID" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TypeID" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Precision" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Scale" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Length" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Indicators" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TableName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "ColumnName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "TypeName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append("   ," + this.fill(qic + "Description" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 1800, -1, -1), 20) + " " + this.getNullable(true) + "\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 8) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    AseConfig aseCfg = AseConfig.getInstance();
                    for (int i = 0; i < aseCfg.getColumnCount(); ++i) {
                        sbSql.append("   ," + this.fill(qic + aseCfg.getColumnName(i) + qic, 40) + " " + this.fill(aseCfg.getSqlDataType(i), 20) + " " + this.getNullable(!aseCfg.getSqlDataType(i).equalsIgnoreCase("bit")) + "\n");
                    }
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 9) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "configName" + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "configText" + qic, 40) + " " + this.fill(this.getDatatype("text", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append(") \n");
                    break block19;
                }
                if (type == 100 || type == 101 || type == 102) {
                    sbSql.append("create table " + tabName + "\n");
                    sbSql.append("( \n");
                    sbSql.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "SessionSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "CmSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("   ," + this.fill(qic + "CmSampleMs" + qic, 40) + " " + this.fill(this.getDatatype("int", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
                    sbSql.append("\n");
                    ResultSetMetaData rsmd = cm.getResultSetMetaData();
                    if (rsmd == null) {
                        throw new SQLException("ResultSetMetaData for CM '" + cm.getName() + "' was null.");
                    }
                    if (rsmd.getColumnCount() == 0) {
                        throw new SQLException("NO Columns was found for CM '" + cm.getName() + "'.");
                    }
                    int cols = rsmd.getColumnCount();
                    for (int c = 1; c <= cols; ++c) {
                        boolean isDeltaOrPct = false;
                        if (type == 101 && cm.isPctColumn(c - 1)) {
                            isDeltaOrPct = true;
                        }
                        if (type == 102 && (cm.isDiffColumn(c - 1) || cm.isPctColumn(c - 1))) {
                            isDeltaOrPct = true;
                        }
                        String colName = this.fill(qic + rsmd.getColumnLabel(c) + qic, 40);
                        String dtName = this.fill(this.getDatatype(c, rsmd, isDeltaOrPct), 20);
                        String nullable = this.getNullable(c, rsmd, isDeltaOrPct);
                        sbSql.append("   ," + colName + " " + dtName + " " + nullable + "\n");
                    }
                    sbSql.append(") \n");
                    break block19;
                }
                return null;
            }
            catch (SQLException e) {
                _logger.warn((Object)"SQLException, Error generating DDL to Persistent Counter DB.", (Throwable)e);
            }
        }
        return sbSql.toString();
    }

    public String getTableInsertStr(int type, CountersModel cm, boolean addPrepStatementQuestionMarks) throws SQLException {
        String tabName = PersistWriterBase.getTableName(type, cm, true);
        StringBuffer sbSql = new StringBuffer();
        if (type == 0) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("ProductString").append(qic).append(", ");
            sbSql.append(qic).append("VersionString").append(qic).append(", ");
            sbSql.append(qic).append("BuildString").append(qic).append(", ");
            sbSql.append(qic).append("SourceDate").append(qic).append(", ");
            sbSql.append(qic).append("SourceRev").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ?, ?) \n");
            }
        } else if (type == 1) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("ServerName").append(qic).append(", ");
            sbSql.append(qic).append("NumOfSamples").append(qic).append(", ");
            sbSql.append(qic).append("LastSampleTime").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?) \n");
            }
        } else if (type == 2) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("Type").append(qic).append(", ");
            sbSql.append(qic).append("ParamName").append(qic).append(", ");
            sbSql.append(qic).append("ParamValue").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?) \n");
            }
        } else if (type == 3) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("SessionSampleTime").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?) \n");
            }
        } else if (type == 4) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("CmName").append(qic).append(", ");
            sbSql.append(qic).append("absSamples").append(qic).append(", ");
            sbSql.append(qic).append("diffSamples").append(qic).append(", ");
            sbSql.append(qic).append("rateSamples").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ?) \n");
            }
        } else if (type == 5) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("SessionSampleTime").append(qic).append(", ");
            sbSql.append(qic).append("CmName").append(qic).append(", ");
            sbSql.append(qic).append("type").append(qic).append(", ");
            sbSql.append(qic).append("graphCount").append(qic).append(", ");
            sbSql.append(qic).append("absRows").append(qic).append(", ");
            sbSql.append(qic).append("diffRows").append(qic).append(", ");
            sbSql.append(qic).append("rateRows").append(qic).append(", ");
            sbSql.append(qic).append("sqlRefreshTime").append(qic).append(", ");
            sbSql.append(qic).append("guiRefreshTime").append(qic).append(", ");
            sbSql.append(qic).append("lcRefreshTime").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) \n");
            }
        } else if (type == 6) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("TableID").append(qic).append(", ");
            sbSql.append(qic).append("Columns").append(qic).append(", ");
            sbSql.append(qic).append("Parameters").append(qic).append(", ");
            sbSql.append(qic).append("Indicators").append(qic).append(", ");
            sbSql.append(qic).append("Size").append(qic).append(", ");
            sbSql.append(qic).append("TableName").append(qic).append(", ");
            sbSql.append(qic).append("Description").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ?, ?, ?, ?) \n");
            }
        } else if (type == 7) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("TableID").append(qic).append(", ");
            sbSql.append(qic).append("ColumnID").append(qic).append(", ");
            sbSql.append(qic).append("TypeID").append(qic).append(", ");
            sbSql.append(qic).append("Precision").append(qic).append(", ");
            sbSql.append(qic).append("Scale").append(qic).append(", ");
            sbSql.append(qic).append("Length").append(qic).append(", ");
            sbSql.append(qic).append("Indicators").append(qic).append(", ");
            sbSql.append(qic).append("TableName").append(qic).append(", ");
            sbSql.append(qic).append("ColumnName").append(qic).append(", ");
            sbSql.append(qic).append("TypeName").append(qic).append(", ");
            sbSql.append(qic).append("Description").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) \n");
            }
        } else if (type == 8) {
            int i;
            sbSql.append("insert into ").append(tabName).append("(");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            AseConfig aseCfg = AseConfig.getInstance();
            for (i = 0; i < aseCfg.getColumnCount(); ++i) {
                sbSql.append(qic).append(aseCfg.getColumnName(i)).append(qic).append(", ");
            }
            sbSql.delete(sbSql.length() - 2, sbSql.length());
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ");
                for (i = 0; i < aseCfg.getColumnCount(); ++i) {
                    sbSql.append("?, ");
                }
                sbSql.delete(sbSql.length() - 2, sbSql.length());
                sbSql.append(") \n");
            }
        } else if (type == 9) {
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("configName").append(qic).append(", ");
            sbSql.append(qic).append("configText").append(qic).append("");
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?) \n");
            }
        } else if (type == 100 || type == 101 || type == 102) {
            int c;
            sbSql.append("insert into ").append(tabName).append(" (");
            sbSql.append(qic).append("SessionStartTime").append(qic).append(", ");
            sbSql.append(qic).append("SessionSampleTime").append(qic).append(", ");
            sbSql.append(qic).append("CmSampleTime").append(qic).append(", ");
            sbSql.append(qic).append("CmSampleMs").append(qic).append(", ");
            int cols = cm.getColumnCount();
            for (c = 0; c < cols; ++c) {
                sbSql.append(qic).append(cm.getColumnName(c)).append(qic).append(", ");
            }
            sbSql.delete(sbSql.length() - 2, sbSql.length());
            sbSql.append(") \n");
            if (addPrepStatementQuestionMarks) {
                sbSql.append("values(?, ?, ?, ?, ");
                for (c = 0; c < cols; ++c) {
                    sbSql.append("?, ");
                }
                sbSql.delete(sbSql.length() - 2, sbSql.length());
                sbSql.append(") \n");
            }
        } else {
            return null;
        }
        String retStr = sbSql.toString();
        return retStr;
    }

    public String getTableInsertStr(CountersModel cm, TrendGraphDataPoint tgdp, boolean addPrepStatementQuestionMarks) {
        int d;
        String tabName = cm.getName() + "_" + tgdp.getName();
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(qic).append(tabName).append(qic).append(" (");
        sb.append(qic).append("SessionStartTime").append(qic).append(", ");
        sb.append(qic).append("SessionSampleTime").append(qic).append(", ");
        sb.append(qic).append("CmSampleTime").append(qic).append(", ");
        Double[] dataArr = tgdp.getData();
        if (dataArr == null) {
            return null;
        }
        for (d = 0; d < dataArr.length; ++d) {
            sb.append(qic).append("label_").append(d).append(qic).append(", ");
            sb.append(qic).append("data_").append(d).append(qic).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(") \n");
        if (addPrepStatementQuestionMarks) {
            sb.append("values(?, ?, ?, ");
            for (d = 0; d < dataArr.length; ++d) {
                sb.append("?, ?, ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(") \n");
        }
        String retStr = sb.toString();
        return retStr;
    }

    public String getIndexDdlString(int type, CountersModel cm) {
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return null;
        }
        if (type == 2) {
            return null;
        }
        if (type == 3) {
            return null;
        }
        if (type == 4) {
            return null;
        }
        if (type == 5) {
            String tabName = PersistWriterBase.getTableName(type, null, false);
            if (DB_PROD_NAME_ASE.equals(this.getDatabaseProductName())) {
                return "create index " + tabName + "_ix1" + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
            }
            return "create index " + qic + tabName + "_ix1" + qic + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
        }
        if (type == 6) {
            return null;
        }
        if (type == 7) {
            return null;
        }
        if (type == 8) {
            return null;
        }
        if (type == 9) {
            return null;
        }
        if (type == 100 || type == 101 || type == 102) {
            String tabName = PersistWriterBase.getTableName(type, cm, false);
            if (DB_PROD_NAME_ASE.equals(this.getDatabaseProductName())) {
                return "create index " + tabName + "_ix1" + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
            }
            return "create index " + qic + tabName + "_ix1" + qic + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
        }
        return null;
    }

    public String getGraphTableDdlString(String tabName, TrendGraphDataPoint tgdp) {
        StringBuilder sb = new StringBuilder();
        sb.append("create table " + qic + tabName + qic + "\n");
        sb.append("( \n");
        sb.append("    " + this.fill(qic + "SessionStartTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
        sb.append("   ," + this.fill(qic + "SessionSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
        sb.append("   ," + this.fill(qic + "CmSampleTime" + qic, 40) + " " + this.fill(this.getDatatype("datetime", -1, -1, -1), 20) + " " + this.getNullable(false) + "\n");
        sb.append("\n");
        Double[] dataArr = tgdp.getData();
        for (int d = 0; d < dataArr.length; ++d) {
            sb.append("   ," + this.fill(qic + "label_" + d + qic, 40) + " " + this.fill(this.getDatatype("varchar", 60, -1, -1), 20) + " " + this.getNullable(true) + "\n");
            sb.append("   ," + this.fill(qic + "data_" + d + qic, 40) + " " + this.fill(this.getDatatype("numeric", -1, 10, 1), 20) + " " + this.getNullable(true) + "\n");
        }
        sb.append(") \n");
        return sb.toString();
    }

    public String getGraphIndexDdlString(String tabName, TrendGraphDataPoint tgdp) {
        if (DB_PROD_NAME_ASE.equals(this.getDatabaseProductName())) {
            return "create index " + tgdp.getName() + "_ix1" + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
        }
        return "create index " + qic + tgdp.getName() + "_ix1" + qic + " on " + qic + tabName + qic + "(" + qic + "SessionSampleTime" + qic + ")\n";
    }

    public String getGraphAlterTableDdlString(Connection conn, String tabName, TrendGraphDataPoint tgdp) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        int colCounter = 0;
        ResultSet rs = dbmd.getColumns(null, null, tabName, "%");
        while (rs.next()) {
            ++colCounter;
        }
        rs.close();
        if (colCounter > 0) {
            colCounter -= 3;
            Double[] dataArr = tgdp.getData();
            if ((colCounter /= 2) < dataArr.length) {
                StringBuilder sb = new StringBuilder();
                sb.append("alter table " + qic + tabName + qic + "\n");
                for (int d = colCounter; d < dataArr.length; ++d) {
                    sb.append("   add  " + this.fill(qic + "label_" + d + qic, 40) + " " + this.fill(this.getDatatype("varchar", 30, -1, -1), 20) + " " + this.getNullable(true) + ",\n");
                    sb.append("        " + this.fill(qic + "data_" + d + qic, 40) + " " + this.fill(this.getDatatype("numeric", -1, 10, 1), 20) + " " + this.getNullable(true) + " \n");
                }
                return sb.toString();
            }
        }
        return "";
    }
}

