/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.AseConfig;
import asemon.AseConfigText;
import asemon.MonTablesDictionary;
import asemon.TrendGraphDataPoint;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.cm.CountersModelAppend;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistWriterBase;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.h2.tools.Server;

public class PersistWriterJdbc
extends PersistWriterBase {
    private static Logger _logger = Logger.getLogger(PersistWriterJdbc.class);
    protected Connection _conn = null;
    private boolean _keepConnOpen = true;
    protected String _jdbcDriver = "org.h2.Driver";
    protected String _jdbcUrl = "jdbc:h2:pcdb_yyy";
    protected String _jdbcUser = "sa";
    protected String _jdbcPasswd = "";
    private boolean _startH2NetworkServer = false;
    protected String _name = "PersistWriterJdbc";
    protected boolean _jdbcDriverInfoHasBeenWritten = false;
    private Server _h2ServerTcp = null;
    private Server _h2ServerWeb = null;
    private boolean _h2NewDbOnDateChange = false;
    private String _h2LastDateChange = null;
    private String _h2DbDateParseFormat = "yyyy-MM-dd";

    @Override
    public void beginOfSample(PersistContainer cont) {
        this.open(cont);
    }

    @Override
    public void endOfSample(PersistContainer cont, boolean caughtErrors) {
        this.close();
    }

    @Override
    public void startServices() throws Exception {
        if (this._jdbcDriver.equals("org.h2.Driver") && this._startH2NetworkServer) {
            _logger.info((Object)"Starting a H2 TCP server.");
            String[] args = new String[]{"-tcpAllowOthers"};
            this._h2ServerTcp = Server.createTcpServer((String[])args);
            this._h2ServerTcp.start();
            _logger.info((Object)("H2 TCP server, url='" + this._h2ServerTcp.getURL() + "', service='" + this._h2ServerTcp.getService() + "'."));
            _logger.info((Object)"Starting a H2 WEB server.");
            String[] argsWeb = new String[]{""};
            this._h2ServerWeb = Server.createWebServer((String[])argsWeb);
            this._h2ServerWeb.start();
            _logger.info((Object)("H2 WEB server, url='" + this._h2ServerWeb.getURL() + "', service='" + this._h2ServerWeb.getService() + "'."));
        }
    }

    @Override
    public void stopServices() {
        if (this._h2ServerTcp != null) {
            _logger.info((Object)"Stopping H2 TCP Service.");
            this._h2ServerTcp.stop();
        }
        if (this._h2ServerWeb != null) {
            _logger.info((Object)"Stopping H2 WEB Service.");
            this._h2ServerWeb.stop();
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(Configuration props) throws Exception {
        String propPrefix = "PersistWriterJdbc.";
        String propname = null;
        propname = propPrefix + "name";
        this._name = props.getProperty(propname, this._name);
        _logger.info((Object)("Initializing the PersistentCounterHandler.WriterClass component named '" + this._name + "'."));
        this._jdbcDriver = props.getPropertyRaw(propPrefix + "jdbcDriver", "");
        this._jdbcUrl = props.getPropertyRaw(propPrefix + "jdbcUrl", "");
        this._jdbcUser = props.getPropertyRaw(propPrefix + "jdbcUser", this._jdbcUser);
        this._jdbcPasswd = props.getProperty(propPrefix + "jdbcPasswd", "");
        if (this._jdbcPasswd.equalsIgnoreCase("null")) {
            this._jdbcPasswd = "";
        }
        this._keepConnOpen = props.getBooleanProperty(propPrefix + "jdbcKeepConnOpen", this._keepConnOpen);
        this._h2NewDbOnDateChange = props.getBooleanProperty(propPrefix + "h2NewDbOnDateChange", this._h2NewDbOnDateChange);
        this._h2DbDateParseFormat = props.getPropertyRaw(propPrefix + "h2DateParseFormat", this._h2DbDateParseFormat);
        this._startH2NetworkServer = props.getBooleanProperty(propPrefix + "startH2NetworkServer", this._startH2NetworkServer);
        this.urlSubstitution(null, this._jdbcUrl);
        _logger.info((Object)("Configuration for PersistentCounterHandler.WriterClass component named '" + this._name + "'."));
        _logger.info((Object)("                  " + propPrefix + "jdbcDriver           = " + this._jdbcDriver));
        _logger.info((Object)("                  " + propPrefix + "jdbcUrl              = " + this._jdbcUrl));
        _logger.info((Object)("                  " + propPrefix + "jdbcUser             = " + this._jdbcUser));
        _logger.info((Object)("                  " + propPrefix + "jdbcPasswd           = " + "*hidden*"));
        _logger.debug((Object)(" *not-encrypted*  " + propPrefix + "jdbcPasswd           = " + this._jdbcPasswd));
        _logger.info((Object)("                  " + propPrefix + "jdbcKeepConnOpen     = " + this._keepConnOpen));
        _logger.info((Object)("                  " + propPrefix + "h2NewDbOnDateChange  = " + this._h2NewDbOnDateChange));
        _logger.info((Object)("                  " + propPrefix + "h2DateParseFormat    = " + this._h2DbDateParseFormat));
        _logger.info((Object)("                  " + propPrefix + "startH2NetworkServer = " + this._startH2NetworkServer));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close(true);
    }

    public void close(boolean force) {
        if (this._conn == null) {
            return;
        }
        if (!this._keepConnOpen || force) {
            try {
                this._conn.close();
                this._conn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    private String urlSubstitution(PersistContainer cont, String inputUrl) {
        Timestamp newDate = cont != null ? cont.getMainSampleTime() : new Timestamp(System.currentTimeMillis());
        String val = inputUrl;
        _logger.debug((Object)("urlSubstitution(): INPUT: inputUrl='" + val + "'."));
        Pattern compiledRegex = Pattern.compile("\\$\\{.+\\}");
        while (compiledRegex.matcher(val).find()) {
            String varStr;
            String varVal = null;
            String varName = varStr = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
            Configuration varConf = null;
            if (varStr.indexOf(58) >= 0) {
                int firstColon = varStr.indexOf(58);
                varName = varStr.substring(0, firstColon);
                String varModifier = varStr.substring(firstColon + 1);
                try {
                    varConf = Configuration.parse(varModifier, ";");
                }
                catch (ParseException pe) {
                    _logger.error((Object)("Problems parsing variables in the H2 URL '" + inputUrl + "' at the variable '" + varName + "' with the modifier '" + varModifier + "'. Caught: " + pe));
                }
            }
            _logger.debug((Object)("urlSubstitution(): varName='" + varName + "', varModifyer='" + varConf + "'."));
            if ("DATE".equals(varName)) {
                String dateFormat = this._h2DbDateParseFormat;
                boolean roll = this._h2NewDbOnDateChange;
                if (varConf != null) {
                    dateFormat = varConf.getProperty("format", dateFormat);
                    roll = varConf.getBooleanProperty("roll", roll);
                }
                varVal = new SimpleDateFormat(dateFormat).format(newDate);
                if (!this._h2DbDateParseFormat.equals(dateFormat)) {
                    _logger.info((Object)("Changing Property: 'h2DateParseFormat' from '" + this._h2DbDateParseFormat + "' to '" + dateFormat + "'. The URL Variable '${DATE}' modifier 'format' overrides the default value."));
                    this._h2DbDateParseFormat = dateFormat;
                }
                if (this._h2NewDbOnDateChange != roll) {
                    _logger.info((Object)("Changing Property: 'h2NewDbOnDateChange' from '" + this._h2NewDbOnDateChange + "' to '" + roll + "'. The URL Variable '${DATE}' modifier 'roll' overrides the default value."));
                    this._h2NewDbOnDateChange = roll;
                }
            } else if ("SERVERNAME".equals(varName)) {
                varVal = "";
                if (cont != null) {
                    varVal = cont.getServerName();
                }
            } else if ("ASEHOSTNAME".equals(varName)) {
                varVal = "";
                if (cont != null) {
                    varVal = cont.getOnHostname();
                }
            } else if ("ASEMON_HOME".equals(varName)) {
                varVal = System.getProperty("ASEMON_HOME", "");
            } else if ("ASEMON_SAVE_DIR".equals(varName)) {
                varVal = System.getProperty("ASEMON_SAVE_DIR", "");
            } else {
                _logger.warn((Object)("urlSubstitution(): WARNING: Unknown variable '" + varName + "', simply removing it from the output."));
                varVal = "";
            }
            _logger.debug((Object)("urlSubstitution(): Substituting varName '${" + varStr + "}' with value '" + varVal + "'."));
            val = val.replace("${" + varStr + "}", varVal);
        }
        _logger.debug((Object)("urlSubstitution(): AFTER: val='" + val + "'."));
        return val;
    }

    private Connection open(PersistContainer cont) {
        String dateStr;
        Timestamp newDate;
        Timestamp timestamp = newDate = cont != null ? cont.getMainSampleTime() : new Timestamp(System.currentTimeMillis());
        if (this._h2NewDbOnDateChange && this._conn != null && !(dateStr = new SimpleDateFormat(this._h2DbDateParseFormat).format(newDate)).equals(this._h2LastDateChange)) {
            if (this._h2LastDateChange != null) {
                _logger.info((Object)("Closing the old database with ${DATE} marked as '" + this._h2LastDateChange + "', a new database will be opened using ${DATE} marker '" + dateStr + "'."));
            }
            this.close(true);
        }
        if (this._keepConnOpen && this._conn != null) {
            try {
                if (!this._conn.isClosed()) {
                    return this._conn;
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        try {
            Class.forName(this._jdbcDriver).newInstance();
            _logger.debug((Object)"Try getConnection to counterStore");
            String localJdbcUrl = this._jdbcUrl;
            if (localJdbcUrl.indexOf("${") >= 0) {
                String dateStr2;
                localJdbcUrl = this.urlSubstitution(cont, localJdbcUrl);
                _logger.info((Object)("Found variables in the URL '" + this._jdbcUrl + "', the new URL will be '" + localJdbcUrl + "'."));
                if (this._h2NewDbOnDateChange) {
                    _logger.info((Object)("When a new ${DATE} of the format '" + this._h2DbDateParseFormat + "' has been reached, a new database will be opened using that timestamp."));
                }
                this._h2LastDateChange = dateStr2 = new SimpleDateFormat(this._h2DbDateParseFormat).format(newDate);
                this.clearIsDdlCreatedCache();
                this.setSessionStarted(false);
            }
            this._conn = DriverManager.getConnection(localJdbcUrl, this._jdbcUser, this._jdbcPasswd);
            _logger.info((Object)("A Database connection to URL '" + localJdbcUrl + "' has been opened, using driver '" + this._jdbcDriver + "'."));
            _logger.debug((Object)("The connection has property auto-commit set to '" + this._conn.getAutoCommit() + "'."));
            if (!this._jdbcDriverInfoHasBeenWritten) {
                DatabaseMetaData dbmd;
                this._jdbcDriverInfoHasBeenWritten = true;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"The following drivers have been loaded:");
                    Enumeration<Driver> drvEnum = DriverManager.getDrivers();
                    while (drvEnum.hasMoreElements()) {
                        _logger.debug((Object)("    " + drvEnum.nextElement().toString()));
                    }
                }
                if ((dbmd = this._conn.getMetaData()) != null) {
                    String getDriverName = "-";
                    String getDriverVersion = "-";
                    int getDriverMajorVersion = -1;
                    int getDriverMinorVersion = -1;
                    int getJDBCMajorVersion = -1;
                    int getJDBCMinorVersion = -1;
                    String getDatabaseProductName = "-";
                    String getDatabaseProductVersion = "-";
                    int getDatabaseMajorVersion = -1;
                    int getDatabaseMinorVersion = -1;
                    try {
                        getDriverName = dbmd.getDriverName();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDriverVersion = dbmd.getDriverVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDriverMajorVersion = dbmd.getDriverMajorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDriverMinorVersion = dbmd.getDriverMinorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getJDBCMajorVersion = dbmd.getJDBCMajorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getJDBCMinorVersion = dbmd.getJDBCMinorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDatabaseProductName = dbmd.getDatabaseProductName();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDatabaseProductVersion = dbmd.getDatabaseProductVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDatabaseMajorVersion = dbmd.getDatabaseMajorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        getDatabaseMinorVersion = dbmd.getDatabaseMinorVersion();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    _logger.info((Object)("Connected using JDBC driver Name='" + getDriverName + "', Version='" + getDriverVersion + "', MajorVersion='" + getDriverMajorVersion + "', MinorVersion='" + getDriverMinorVersion + "', JdbcMajorVersion='" + getJDBCMajorVersion + "', JdbcMinorVersion='" + getJDBCMinorVersion + "'."));
                    _logger.info((Object)("Connected to Database Product Name='" + getDatabaseProductName + "', Version='" + getDatabaseProductVersion + "', MajorVersion='" + getDatabaseMajorVersion + "', MinorVersion='" + getDatabaseMinorVersion + "'."));
                    this.setDatabaseProductName(getDatabaseProductName == null ? "" : getDatabaseProductName);
                }
            }
            if (DB_PROD_NAME_ASE.equals(this.getDatabaseProductName())) {
                _logger.debug((Object)"Connected to ASE, do some specific settings 'set arithabort numeric_truncation off'.");
                this.dbExec("set arithabort numeric_truncation off ");
            }
        }
        catch (SQLException ev) {
            StringBuffer sb = new StringBuffer();
            while (ev != null) {
                sb.append("\n");
                sb.append(ev.getMessage());
                ev = ev.getNextException();
            }
            _logger.error((Object)("Problems when connecting to a datastore Server. " + sb.toString()));
            this._conn = null;
        }
        catch (Exception ev) {
            _logger.error((Object)"openConnection", (Throwable)ev);
            this._conn = null;
        }
        return this._conn;
    }

    private boolean dbExec(String sql) throws SQLException {
        return this.dbExec(sql, true);
    }

    private boolean dbExec(String sql, boolean printErrors) throws SQLException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("SEND SQL: " + sql));
        }
        try {
            Statement s = this._conn.createStatement();
            s.execute(sql);
            s.close();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing sql statement: " + sql));
            throw e;
        }
        return true;
    }

    private boolean dbDdlExec(String sql) throws SQLException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("SEND DDL SQL: " + sql));
        }
        try {
            boolean autoCommitWasChanged = false;
            if (!this._conn.getAutoCommit()) {
                autoCommitWasChanged = true;
                this._conn.commit();
                this._conn.setAutoCommit(true);
            }
            Statement s = this._conn.createStatement();
            s.execute(sql);
            s.close();
            if (autoCommitWasChanged) {
                this._conn.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            _logger.warn((Object)("Problems when executing DDL sql statement: " + sql));
            throw e;
        }
        return true;
    }

    private boolean checkAndCreateTable(int tabId) throws SQLException {
        String tabName = PersistWriterJdbc.getTableName(tabId, null, false);
        if (!this.isDdlCreated(tabName)) {
            DatabaseMetaData dbmd = this._conn.getMetaData();
            ResultSet rs = dbmd.getColumns(null, null, tabName, "%");
            boolean tabExists = rs.next();
            rs.close();
            if (tabExists) {
                if (tabId == 0) {
                    // empty if block
                }
            } else {
                _logger.info((Object)("Creating table '" + tabName + "'."));
                this.incCreateTables();
                String sql = this.getTableDdlString(tabId, null);
                this.dbDdlExec(sql);
                sql = this.getIndexDdlString(tabId, null);
                if (sql != null) {
                    this.dbDdlExec(sql);
                }
            }
            this.markDdlAsCreated(tabName);
            return true;
        }
        return false;
    }

    private void insertSessionParam(Timestamp sessionsStartTime, String type, String key, String val) throws SQLException {
        try {
            String sql = this.getTableInsertStr(2, null, true);
            PreparedStatement pst = this._conn.prepareStatement(sql);
            pst.setString(1, sessionsStartTime.toString());
            pst.setString(2, type);
            pst.setString(3, key);
            pst.setString(4, val);
            pst.executeUpdate();
            pst.close();
            this.incInserts();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Error in insertSessionParam() writing to Persistent Counter Store. insertSessionParam(sessionsStartTime='" + sessionsStartTime + "', type='" + type + "', key='" + key + "', val='" + val + "')"), (Throwable)e);
        }
    }

    @Override
    public void startSession(PersistContainer cont) {
        this.open(cont);
        if (this._conn == null) {
            _logger.error((Object)"No database connection to Persistent Storage DB.'");
            return;
        }
        if (cont._counterObjects == null) {
            _logger.error((Object)"Input parameter PersistContainer._counterObjects can't be null. Can't continue startSession()...");
            return;
        }
        try {
            String val;
            _logger.info((Object)("Starting a new Storage Session with the start date '" + cont._sessionStartTime + "'."));
            this.checkAndCreateTable(0);
            this.checkAndCreateTable(1);
            this.checkAndCreateTable(2);
            this.checkAndCreateTable(3);
            this.checkAndCreateTable(4);
            this.checkAndCreateTable(5);
            this.checkAndCreateTable(6);
            this.checkAndCreateTable(7);
            this.checkAndCreateTable(8);
            this.checkAndCreateTable(9);
            StringBuffer sbSql = new StringBuffer();
            sbSql.append(this.getTableInsertStr(0, null, false));
            sbSql.append(" values(");
            sbSql.append("  '").append(cont.getSessionStartTime()).append("'");
            sbSql.append(", '").append(Version.getAppName()).append("'");
            sbSql.append(", '").append(Version.getVersionStr()).append("'");
            sbSql.append(", '").append(Version.getBuildStr()).append("'");
            sbSql.append(", '").append(Version.getSourceDate()).append("'");
            sbSql.append(",  ").append(Version.getSourceRev()).append(" ");
            sbSql.append(" )");
            this.dbExec(sbSql.toString());
            this.incInserts();
            sbSql = new StringBuffer();
            sbSql.append(this.getTableInsertStr(1, null, false));
            sbSql.append(" values('").append(cont.getSessionStartTime()).append("', '").append(cont.getServerName()).append("', 0, null)");
            this.dbExec(sbSql.toString());
            this.incInserts();
            _logger.info((Object)("Storing CounterModel information in table " + PersistWriterJdbc.getTableName(2, null, false)));
            Timestamp ts = cont.getSessionStartTime();
            for (CountersModel cm : cont._counterObjects) {
                String string = cm.getName();
                this.insertSessionParam(ts, "cm", string + ".name", cm.getName());
                this.insertSessionParam(ts, "cm", string + ".sqlInit", cm.getSqlInit());
                this.insertSessionParam(ts, "cm", string + ".sql", cm.getSql());
                this.insertSessionParam(ts, "cm", string + ".sqlClose", cm.getSqlClose());
                this.insertSessionParam(ts, "cm", string + ".pk", cm.getPk() == null ? null : cm.getPk().toString());
                this.insertSessionParam(ts, "cm", string + ".diff", Arrays.deepToString(cm.getDiffColumns()));
                this.insertSessionParam(ts, "cm", string + ".diffDiss", Arrays.deepToString(cm.getDiffDissColumns()));
                this.insertSessionParam(ts, "cm", string + ".pct", Arrays.deepToString(cm.getPctColumns()));
                this.insertSessionParam(ts, "cm", string + ".graphNames", Arrays.deepToString(cm.getTrendGraphNames()));
            }
            _logger.info((Object)("Storing AseMon configuration information in table " + PersistWriterJdbc.getTableName(2, null, false)));
            Configuration conf = Configuration.getCombinedConfiguration();
            for (String string : conf.keySet()) {
                val = conf.getPropertyRaw(string);
                this.insertSessionParam(ts, "config", string, val);
            }
            conf = Configuration.getCombinedConfiguration();
            for (String string : conf.keySet()) {
                val = conf.getPropertyRaw(string);
                this.insertSessionParam(ts, "tmpConfig", string, val);
            }
            if (MonTablesDictionary.hasInstance()) {
                _logger.info((Object)("Storing monTables & monTableColumns dictionary in table " + PersistWriterJdbc.getTableName(6, null, false) + " and " + PersistWriterJdbc.getTableName(7, null, false)));
                this.saveMonTablesDictionary(MonTablesDictionary.getInstance(), cont._sessionStartTime);
            }
            _logger.info((Object)("Storing ASE Configuration in table " + PersistWriterJdbc.getTableName(8, null, false)));
            this.saveAseConfig(AseConfig.getInstance(), cont._sessionStartTime);
            _logger.info((Object)("Storing Various ASE Configuration in table " + PersistWriterJdbc.getTableName(9, null, false)));
            this.saveAseConfigText(cont._sessionStartTime);
            this.setSessionStarted(true);
        }
        catch (SQLException e) {
            _logger.warn((Object)"Error when startSession() writing to Persistent Counter Store.", (Throwable)e);
        }
        this.close();
    }

    public void loadMonTablesDictionary(MonTablesDictionary mtd) {
        throw new RuntimeException("NOT IMPLEMENTED: loadMonTablesDictionary()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAseConfigText(Timestamp sessionStartTime) {
        if (this._conn == null) {
            _logger.error((Object)"No database connection to Persistent Storage DB.'");
            return;
        }
        StringBuffer sbSql = null;
        try {
            if (this._conn.getAutoCommit()) {
                this._conn.setAutoCommit(false);
            }
            for (AseConfigText.ConfigType t : AseConfigText.ConfigType.values()) {
                AseConfigText aseConfigText = AseConfigText.getInstance(t);
                _logger.info((Object)("Storing ASE Configuration Text for '" + aseConfigText.getConfigType().toString() + "' in table " + PersistWriterJdbc.getTableName(9, null, false)));
                sbSql = new StringBuffer();
                sbSql.append(this.getTableInsertStr(9, null, false));
                sbSql.append(" values('").append(sessionStartTime).append("' \n");
                sbSql.append("       ,'" + aseConfigText.getConfigType().toString() + "' \n");
                sbSql.append("       ,").append(PersistWriterJdbc.safeStr(aseConfigText.getConfig())).append(" \n");
                sbSql.append("       )\n");
                this.dbExec(sbSql.toString());
                this.incInserts();
            }
            this._conn.commit();
        }
        catch (SQLException e) {
            try {
                if (this._conn.getAutoCommit()) {
                    this._conn.rollback();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
        finally {
            try {
                this._conn.setAutoCommit(true);
            }
            catch (SQLException e2) {
                _logger.error((Object)"Problems when setting AutoCommit to true.", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAseConfig(AseConfig aseCfg, Timestamp sessionStartTime) {
        if (this._conn == null) {
            _logger.error((Object)"No database connection to Persistent Storage DB.'");
            return;
        }
        StringBuffer sbSql = null;
        try {
            if (this._conn.getAutoCommit()) {
                this._conn.setAutoCommit(false);
            }
            for (int r = 0; r < aseCfg.getRowCount(); ++r) {
                sbSql = new StringBuffer();
                sbSql.append(this.getTableInsertStr(8, null, false));
                sbSql.append(" values('").append(sessionStartTime).append("' \n");
                for (int c = 0; c < aseCfg.getColumnCount(); ++c) {
                    Object o = aseCfg.getValueAt(r, c);
                    if (o instanceof String) {
                        o = PersistWriterJdbc.safeStr((String)o);
                    }
                    if (o instanceof Boolean) {
                        o = (Boolean)o != false ? "1" : "0";
                    }
                    sbSql.append("        ,").append(o).append(" \n");
                }
                sbSql.append("       )\n");
                this.dbExec(sbSql.toString());
                this.incInserts();
            }
            this._conn.commit();
        }
        catch (SQLException e) {
            try {
                if (this._conn.getAutoCommit()) {
                    this._conn.rollback();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
        finally {
            try {
                this._conn.setAutoCommit(true);
            }
            catch (SQLException e2) {
                _logger.error((Object)"Problems when setting AutoCommit to true.", (Throwable)e2);
            }
        }
    }

    public static String safeStr(String str) {
        if (str == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(str.replaceAll("'", "''"));
        sb.append("'");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMonTablesDictionary(MonTablesDictionary mtd, Timestamp sessionStartTime) {
        if (this._conn == null) {
            _logger.error((Object)"No database connection to Persistent Storage DB.'");
            return;
        }
        StringBuffer sbSql = null;
        try {
            if (this._conn.getAutoCommit()) {
                this._conn.setAutoCommit(false);
            }
            Map<String, MonTablesDictionary.MonTableEntry> monTablesDictMap = mtd.getMonTablesDictionaryMap();
            for (MonTablesDictionary.MonTableEntry mte : monTablesDictMap.values()) {
                sbSql = new StringBuffer();
                sbSql.append(this.getTableInsertStr(6, null, false));
                sbSql.append(" values('").append(sessionStartTime).append("', \n");
                sbSql.append("         ").append(mte._tableID).append(", \n");
                sbSql.append("         ").append(mte._columns).append(", \n");
                sbSql.append("         ").append(mte._parameters).append(", \n");
                sbSql.append("         ").append(mte._indicators).append(", \n");
                sbSql.append("         ").append(mte._size).append(", \n");
                sbSql.append("         ").append(PersistWriterJdbc.safeStr(mte._tableName)).append(", \n");
                sbSql.append("         ").append(PersistWriterJdbc.safeStr(mte._description)).append("\n");
                sbSql.append("       )\n");
                this.dbExec(sbSql.toString());
                this.incInserts();
                for (MonTablesDictionary.MonTableColumnsEntry mtce : mte._monTableColumns.values()) {
                    sbSql = new StringBuffer();
                    sbSql.append(this.getTableInsertStr(7, null, false));
                    sbSql.append(" values('").append(sessionStartTime).append("', \n");
                    sbSql.append("         ").append(mtce._tableID).append(", \n");
                    sbSql.append("         ").append(mtce._columnID).append(", \n");
                    sbSql.append("         ").append(mtce._typeID).append(", \n");
                    sbSql.append("         ").append(mtce._precision).append(", \n");
                    sbSql.append("         ").append(mtce._scale).append(", \n");
                    sbSql.append("         ").append(mtce._length).append(", \n");
                    sbSql.append("         ").append(mtce._indicators).append(", \n");
                    sbSql.append("         ").append(PersistWriterJdbc.safeStr(mtce._tableName)).append(", \n");
                    sbSql.append("         ").append(PersistWriterJdbc.safeStr(mtce._columnName)).append(", \n");
                    sbSql.append("         ").append(PersistWriterJdbc.safeStr(mtce._typeName)).append(", \n");
                    sbSql.append("         ").append(PersistWriterJdbc.safeStr(mtce._description)).append(" \n");
                    sbSql.append("       )\n");
                    this.dbExec(sbSql.toString());
                    this.incInserts();
                }
            }
            this._conn.commit();
        }
        catch (SQLException e) {
            try {
                if (this._conn.getAutoCommit()) {
                    this._conn.rollback();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
        finally {
            try {
                this._conn.setAutoCommit(true);
            }
            catch (SQLException e2) {
                _logger.error((Object)"Problems when setting AutoCommit to true.", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSample(PersistContainer cont) {
        if (this._conn == null) {
            _logger.error((Object)"No database connection to Persistent Storage DB.'");
            return;
        }
        Timestamp sessionStartTime = cont.getSessionStartTime();
        Timestamp sessionSampleTime = cont.getMainSampleTime();
        StringBuffer sbSql = null;
        try {
            if (this._conn.getAutoCommit()) {
                this._conn.setAutoCommit(false);
            }
            sbSql = new StringBuffer();
            sbSql.append(this.getTableInsertStr(3, null, false));
            sbSql.append(" values('").append(sessionStartTime).append("', '").append(sessionSampleTime).append("')");
            this.dbExec(sbSql.toString());
            this.incInserts();
            String tabName = PersistWriterJdbc.getTableName(1, null, true);
            sbSql = new StringBuffer();
            sbSql.append(" update ").append(tabName);
            sbSql.append("    set ").append(qic).append("NumOfSamples").append(qic).append(" = ").append(qic).append("NumOfSamples").append(qic).append(" + 1,");
            sbSql.append("        ").append(qic).append("LastSampleTime").append(qic).append(" = '").append(sessionSampleTime).append("'");
            sbSql.append("  where ").append(qic).append("SessionStartTime").append(qic).append(" = '").append(sessionStartTime).append("'");
            this.dbExec(sbSql.toString());
            this.incUpdates();
            for (CountersModel cm : cont._counterObjects) {
                this.saveCounterData(cm, sessionStartTime, sessionSampleTime);
            }
            this._conn.commit();
        }
        catch (SQLException e) {
            try {
                if (this._conn.getAutoCommit()) {
                    this._conn.rollback();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
        finally {
            try {
                this._conn.setAutoCommit(true);
            }
            catch (SQLException e2) {
                _logger.error((Object)"Problems when setting AutoCommit to true.", (Throwable)e2);
            }
        }
    }

    private void saveDdl(int type, CountersModel cm) throws SQLException {
        ResultSet rs = null;
        DatabaseMetaData dbmd = this._conn.getMetaData();
        String tabName = PersistWriterJdbc.getTableName(type, cm, false);
        rs = dbmd.getColumns(null, null, tabName, "%");
        boolean tabExists = rs.next();
        rs.close();
        if (!tabExists) {
            _logger.info((Object)("Persistent Counter DB: Creating table " + StringUtil.left("'" + tabName + "'", 32, true) + " for CounterModel '" + cm.getName() + "'."));
            String sqlTable = this.getTableDdlString(type, cm);
            String sqlIndex = this.getIndexDdlString(type, cm);
            this.dbDdlExec(sqlTable);
            this.dbDdlExec(sqlIndex);
            this.incCreateTables();
        }
    }

    @Override
    public boolean saveDdl(CountersModel cm) {
        if (cm == null) {
            _logger.debug((Object)"saveDdl: cm == null.");
            return false;
        }
        ResultSetMetaData rsmd = cm.getResultSetMetaData();
        if (rsmd == null) {
            _logger.debug((Object)"saveDdl: rsmd == null.");
            return false;
        }
        if (this._conn == null) {
            _logger.debug((Object)"saveDdl: _conn == null.");
            return false;
        }
        try {
            this.saveDdl(100, cm);
            this.saveDdl(101, cm);
            this.saveDdl(102, cm);
        }
        catch (SQLException e) {
            _logger.warn((Object)"SQLException, Error writing DDL to Persistent Counter DB.", (Throwable)e);
            throw new RuntimeException("SQLException, Error writing DDL to Persistent Counter DB. Caught: " + e);
        }
        return true;
    }

    private void saveCounterData(CountersModel cm, Timestamp sessionStartTime, Timestamp sessionSampleTime) {
        if (cm == null) {
            _logger.debug((Object)"saveCounterData: cm == null.");
            return;
        }
        if (cm instanceof CountersModelAppend) {
            return;
        }
        if (!cm.hasDiffData() && (cm.isPersistCountersDiffEnabled() || cm.isPersistCountersRateEnabled())) {
            _logger.info((Object)("No diffData is available, skipping writing Counters for name='" + cm.getName() + "'."));
            return;
        }
        _logger.debug((Object)("Persisting Counters for CounterModel='" + cm.getName() + "'."));
        int counterType = 0;
        int absRows = 0;
        int diffRows = 0;
        int rateRows = 0;
        if (cm.hasAbsData() && cm.isPersistCountersAbsEnabled()) {
            ++counterType;
            absRows = this.save(cm, 100, sessionStartTime, sessionSampleTime);
        }
        if (cm.hasDiffData() && cm.isPersistCountersDiffEnabled()) {
            counterType += 2;
            diffRows = this.save(cm, 101, sessionStartTime, sessionSampleTime);
        }
        if (cm.hasRateData() && cm.isPersistCountersRateEnabled()) {
            counterType += 4;
            rateRows = this.save(cm, 102, sessionStartTime, sessionSampleTime);
        }
        int graphCount = 0;
        Map<String, TrendGraphDataPoint> tgdMap = cm.getTrendGraphData();
        if (tgdMap != null) {
            for (Map.Entry<String, TrendGraphDataPoint> entry : tgdMap.entrySet()) {
                TrendGraphDataPoint tgdp = entry.getValue();
                this.saveGraphData(cm, tgdp, sessionStartTime, sessionSampleTime);
                ++graphCount;
            }
        }
        StringBuilder sbSql = new StringBuilder();
        try {
            sbSql.append(this.getTableInsertStr(5, null, false));
            sbSql.append(" values('").append(sessionStartTime).append("'");
            sbSql.append(", '").append(sessionSampleTime).append("'");
            sbSql.append(", '").append(cm.getName()).append("'");
            sbSql.append(", ").append(counterType);
            sbSql.append(", ").append(graphCount);
            sbSql.append(", ").append(absRows);
            sbSql.append(", ").append(diffRows);
            sbSql.append(", ").append(rateRows);
            sbSql.append(", ").append(cm.getSqlRefreshTime());
            sbSql.append(", ").append(cm.getGuiRefreshTime());
            sbSql.append(", ").append(cm.getLcRefreshTime());
            sbSql.append(")");
            this.dbExec(sbSql.toString());
            this.incInserts();
        }
        catch (SQLException e) {
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
        String tabName = PersistWriterJdbc.getTableName(4, null, true);
        sbSql = new StringBuilder();
        sbSql.append(" update ").append(tabName);
        sbSql.append(" set \"absSamples\"  = \"absSamples\"  + ").append(absRows > 0 ? 1 : 0).append(", ");
        sbSql.append("     \"diffSamples\" = \"diffSamples\" + ").append(diffRows > 0 ? 1 : 0).append(", ");
        sbSql.append("     \"rateSamples\" = \"rateSamples\" + ").append(rateRows > 0 ? 1 : 0).append("");
        sbSql.append(" where \"SessionStartTime\" = '").append(sessionStartTime).append("'");
        sbSql.append("   and \"CmName\" = '").append(cm.getName()).append("'");
        try {
            Statement stmnt = this._conn.createStatement();
            int updCount = stmnt.executeUpdate(sbSql.toString());
            if (updCount == 0) {
                sbSql = new StringBuilder();
                sbSql.append(this.getTableInsertStr(4, null, false));
                sbSql.append(" values('").append(sessionStartTime).append("'");
                sbSql.append(", '").append(cm.getName()).append("', 1, 1, 1)");
                updCount = stmnt.executeUpdate(sbSql.toString());
                this.incInserts();
            } else {
                this.incUpdates();
            }
        }
        catch (SQLException e) {
            _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sbSql.toString()), (Throwable)e);
        }
    }

    private int save(CountersModel cm, int whatData, Timestamp sessionStartTime, Timestamp sessionSampleTime) {
        if (this._conn == null) {
            return -1;
        }
        Object colObj = null;
        int cmWhatData = -99;
        if (whatData == 100) {
            cmWhatData = 1;
        } else if (whatData == 101) {
            cmWhatData = 2;
        } else if (whatData == 102) {
            cmWhatData = 3;
        } else {
            _logger.error((Object)"Type of data is unknown, only 'ABS', 'DIFF' and 'RATE' is handled.");
            return -1;
        }
        List<List<Object>> rows = cm.getDataCollection(cmWhatData);
        List<String> cols = cm.getColNames(cmWhatData);
        if (rows == null || cols == null) {
            _logger.error((Object)("Rows or Columns can't be null. rows='" + rows + "', cols='" + cols + "'"));
            return -1;
        }
        String tabName = PersistWriterJdbc.getTableName(whatData, cm, false);
        int rowsCount = rows.size();
        int colsCount = cols.size();
        try {
            String sql = this.getTableInsertStr(whatData, cm, true);
            PreparedStatement pstmt = this._conn.prepareStatement(sql);
            for (int r = 0; r < rowsCount; ++r) {
                int col = 1;
                pstmt.setString(col++, sessionStartTime.toString());
                pstmt.setString(col++, sessionSampleTime.toString());
                pstmt.setString(col++, cm.getTimestamp().toString());
                pstmt.setInt(col++, cm.getLastSampleInterval());
                for (int c = 0; c < colsCount; ++c) {
                    colObj = rows.get(r).get(c);
                    if (colObj != null && colObj instanceof Timestamp) {
                        Timestamp ts = (Timestamp)colObj;
                        String dateStr = colObj.toString();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(ts);
                        int year = cal.get(1);
                        if (year > 9999) {
                            String colName = cm.getColumnName(c);
                            _logger.warn((Object)("Date problems for table '" + tabName + "', column '" + colName + "', Timestamp value '" + dateStr + "', Year seems to be out of whack, replacing this with NULL."));
                            pstmt.setString(col++, null);
                            continue;
                        }
                        pstmt.setString(col++, dateStr);
                        continue;
                    }
                    pstmt.setObject(col++, colObj);
                }
                pstmt.addBatch();
                this.incInserts();
            }
            pstmt.executeBatch();
            pstmt.close();
            return rowsCount;
        }
        catch (SQLException e) {
            _logger.warn((Object)("Error writing to Persistent Counter Store. to table name '" + tabName + "'."), (Throwable)e);
            return -1;
        }
    }

    private void saveGraphData(CountersModel cm, TrendGraphDataPoint tgdp, Timestamp sessionStartTime, Timestamp sessionSampleTime) {
        if (cm == null) {
            throw new IllegalArgumentException("The passed CM can't be null");
        }
        if (tgdp == null) {
            throw new IllegalArgumentException("The passed TGDP can't be null");
        }
        String tabName = PersistWriterJdbc.getTableName(cm, tgdp, false);
        StringBuilder sb = new StringBuilder();
        String tabInsStr = this.getTableInsertStr(cm, tgdp, false);
        if (tabInsStr == null) {
            _logger.info((Object)("Problems writing Graph '" + tgdp.getName() + "' information to table '" + tabName + "', Problems when generating insert SQL statement, the graph data array might be empty for this sample time."));
            return;
        }
        sb.append(tabInsStr);
        sb.append(" values(");
        sb.append("'").append(sessionStartTime).append("', ");
        sb.append("'").append(sessionSampleTime).append("', ");
        sb.append("'").append(tgdp.getDate()).append("', ");
        Double[] dataArr = tgdp.getData();
        String[] labelArr = tgdp.getLabel();
        if (dataArr == null) {
            throw new IllegalArgumentException("The CM '" + cm.getName() + "', graph '" + tgdp.getName() + "' has a null pointer for it's DATA array.");
        }
        if (labelArr == null) {
            throw new IllegalArgumentException("The CM '" + cm.getName() + "', graph '" + tgdp.getName() + "' has a null pointer for it's LABEL array.");
        }
        for (int d = 0; d < dataArr.length; ++d) {
            Double data = dataArr[d];
            String label = null;
            if (d < labelArr.length) {
                label = labelArr[d];
            }
            if (label == null) {
                sb.append("NULL, ");
            } else {
                sb.append("'").append(label).append("', ");
            }
            if (data == null) {
                sb.append("NULL");
            } else {
                sb.append(data);
            }
            if (d + 1 == dataArr.length) {
                sb.append(")");
                continue;
            }
            sb.append(", ");
        }
        try {
            if (!this.isDdlCreated(tabName)) {
                this.saveGraphDataDdl(tabName, tgdp);
            }
            this.markDdlAsCreated(tabName);
        }
        catch (SQLException e) {
            _logger.info((Object)("Problems writing Graph '" + tgdp.getName() + "' information to table '" + tabName + "', Problems when creating the table or checked if it existed. Caught: " + e));
        }
        try {
            this.dbExec(sb.toString(), false);
            this.incInserts();
        }
        catch (SQLException e) {
            _logger.info((Object)("Problems writing Graph '" + tgdp.getName() + "' information to table '" + tabName + "', This probably happens if series has been added to the graph, I will checking/create/alter the table and try again."));
            try {
                this.saveGraphDataDdl(tabName, tgdp);
                this.dbExec(sb.toString());
                this.incInserts();
            }
            catch (SQLException e2) {
                _logger.warn((Object)("Error writing to Persistent Counter Store. SQL: " + sb.toString()), (Throwable)e2);
            }
        }
    }

    private void saveGraphDataDdl(String tabName, TrendGraphDataPoint tgdp) throws SQLException {
        ResultSet rs = null;
        DatabaseMetaData dbmd = this._conn.getMetaData();
        boolean inTransaction = !this._conn.getAutoCommit();
        try {
            if (inTransaction) {
                _logger.debug((Object)"Looks like we are in a transaction, temporary committing it, then create the table and start a new transaction.");
                this._conn.commit();
                this._conn.setAutoCommit(true);
            }
            rs = dbmd.getColumns(null, null, tabName, "%");
            boolean tabExists = rs.next();
            rs.close();
            if (!tabExists) {
                _logger.info((Object)("Persistent Counter DB: Creating table " + StringUtil.left("'" + tabName + "'", 32, true) + " for CounterModel graph '" + tgdp.getName() + "'."));
                String sqlTable = this.getGraphTableDdlString(tabName, tgdp);
                String sqlIndex = this.getGraphIndexDdlString(tabName, tgdp);
                this.dbDdlExec(sqlTable);
                this.dbDdlExec(sqlIndex);
                this.incCreateTables();
            } else {
                String sqlAlterTable = this.getGraphAlterTableDdlString(this._conn, tabName, tgdp);
                if (!sqlAlterTable.trim().equals("")) {
                    _logger.info((Object)("Persistent Counter DB: Altering table '" + tabName + "' for CounterModel graph '" + tgdp.getName() + "'."));
                    this.dbDdlExec(sqlAlterTable);
                    this.incAlterTables();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (inTransaction) {
                _logger.debug((Object)"Looks like we are in a transaction. Done with creating the table, so starting a transaction again.");
                this._conn.setAutoCommit(false);
            }
        }
    }
}

