/*
 * Decompiled with CFR 0.152.
 */
package asemon.perftest;

import asemon.Version;
import asemon.cm.CountersModel;
import asemon.perftest.PerfDemoSwingWorker;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.SwingUtils;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jdesktop.swingx.JXMultiSplitPane;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.MultiSplitLayout;

public class PerfDemo
extends JFrame
implements ActionListener {
    private static Logger _logger = Logger.getLogger(PerfDemo.class);
    private static final long serialVersionUID = 1L;
    private Connection _qProdGenConn = null;
    private Connection _qProdInfoConn = null;
    private Connection _qCntrlConn = null;
    private Connection _qConsInfoConn = null;
    private Connection _qStatInfoConn = null;
    private String _initialDbname = "";
    JXMultiSplitPane _multiSplitPane = new JXMultiSplitPane();
    String _splitPaneLayoutFilename = Version.APP_STORE_DIR + "/perfDemo.layout.save.xml";
    private JComboBox _aseName = new JComboBox();
    private JTextField _aseHost = new JTextField("");
    private JTextField _asePort = new JTextField("");
    private JTextField _aseUsername = new JTextField("");
    private JTextField _asePassword = new JPasswordField();
    private JTextField _aseDbname = new JTextField();
    private JButton _aseConnect = new JButton("Connect");
    private SyInterfacesDriver _interfacesDriver = null;
    private JTextField _qProdQSize = new JTextField();
    private JTextField _qProdQSizeRate = new JTextField();
    private int _qProdQSizeSave = 0;
    private long _qProdQSizeTime = 0L;
    private final String QTYPE_ALL = "All Types";
    private final String QTYPE_1 = "dest1";
    private final String QTYPE_2 = "dest2";
    private final String QTYPE_3 = "dest3";
    private JTextField _qProdGenType = new JTextField();
    private JTextField _qProdGenNum = new JTextField();
    private JComboBox _qProdGenHow_cbx = new JComboBox<String>(new String[]{"<Choose Type>", "All Types", "dest1", "dest2", "dest3"});
    private JButton _qProdGen_but = new JButton("Generate new values");
    private final String RESUME_CONSUMERS = "Resume All Consumers";
    private final String PAUSE_CONSUMERS_WAIT = "Pause All Consumers, Wait";
    private final String PAUSE_CONSUMERS_NOW = "Pause All Consumers, NOW";
    private final String STOP_CONSUMERS_WAIT = "Stop All Consumers";
    private final String Q_CONS_PARAM_DEFAULT = "<Use Default parameters>";
    private final String Q_CONS_PARAM_SET1 = "Batch Size=10, Update Queue Status=1, Use Transaction=1";
    private final String Q_CONS_PARAM_SET2 = "Batch Size=10, Update Queue Status=0, Use Transaction=1";
    private final String Q_CONS_PARAM_SET3 = "Batch Size=10, Update Queue Status=0, Use Transaction=0";
    private final String Q_CONS_PARAM_SET4 = "Batch Size=1, Update Queue Status=0, Use Transaction=0";
    private Vector<String> _qConsTableCols = new Vector<String>(Arrays.asList("spid", "status", "cmd", "qThreadInState", "msgToOther"));
    private JXTable _qConsTable = null;
    private GTableModel _qConsTableModel = null;
    private JTextField _qConsExecCount = new JTextField();
    private JTextField _qConsExecParams = new JTextField();
    private JComboBox _qConsExecParams_cbx = new JComboBox<String>(new String[]{"<Use Default parameters>", "Batch Size=10, Update Queue Status=1, Use Transaction=1", "Batch Size=10, Update Queue Status=0, Use Transaction=1", "Batch Size=10, Update Queue Status=0, Use Transaction=0", "Batch Size=1, Update Queue Status=0, Use Transaction=0"});
    private JButton _qConsStart_but = new JButton("Start a new Consumer");
    private JComboBox _qConsStatus_cbx = new JComboBox<String>(new String[]{"<Choose Status>", "Resume All Consumers", "Pause All Consumers, Wait", "Pause All Consumers, NOW", "Stop All Consumers"});
    private JButton _qConsStop_but = new JButton("Stop last Consumer");
    private List<QueueConsumer> _qConsThreadList = new LinkedList<QueueConsumer>();
    private final String STAT_QUEUE_INFO = "Queue Info Statistics";
    private final String STAT_TAB_ROWS = "Destination Table Row Count";
    private String _qStatCurrentType = "Queue Info Statistics";
    private JComboBox _qStatType_cbx = new JComboBox<String>(new String[]{"Queue Info Statistics", "Destination Table Row Count"});
    private Vector<String> _qStatTableCols = new Vector<String>(Arrays.asList("operation", "execCounter", "lastExecTime", "lastExecTimeMs", "avgExecTimeMs", "minExecTimeMs", "maxExecTimeMs"));
    private JXTable _qStatTable = null;
    private GTableModel _qStatTmDefault = null;
    private CountersModel _qStatTmRowCount = null;
    private JTextPane _logArea = new JTextPane();

    public PerfDemo(String dbname) {
        this.setTitle("Performance Demo");
        this.setDefaultCloseOperation(3);
        this._initialDbname = dbname;
        this.initComponents();
        this.pack();
        QueueProducerInfoThread qProdInfo = new QueueProducerInfoThread("qProducerInfo", this);
        qProdInfo.start();
        QueueConsumerInfoThread qConsInfo = new QueueConsumerInfoThread("qConsumerInfo", this);
        qConsInfo.start();
        QueueStatisticsInfoThread qStatInfo = new QueueStatisticsInfoThread("qStatisticsInfo", this);
        qStatInfo.start();
        this.setSize(1000, 800);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        String layoutDef = "(COLUMN (ROW weight=0.5               (COLUMN weight=0.0 (LEAF name=jdbc       weight=0.0)                                 (LEAF name=qProdInfo  weight=0.0)                                 (LEAF name=qProdGen   weight=1.0)              )               (COLUMN weight=1.0 (LEAF name=qCons  weight=0.8)                                 (LEAF name=qStats weight=0.2)              )         )  (LEAF name=bottom  weight=0.5))";
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(this._splitPaneLayoutFilename)));
            MultiSplitLayout.Node model = (MultiSplitLayout.Node)d.readObject();
            this._multiSplitPane.getMultiSplitLayout().setModel(model);
            this._multiSplitPane.getMultiSplitLayout().setFloatingDividers(false);
            d.close();
        }
        catch (Exception exc) {
            MultiSplitLayout.Node model = MultiSplitLayout.parseModel((String)layoutDef);
            this._multiSplitPane.getMultiSplitLayout().setModel(model);
        }
        this._multiSplitPane.add((Component)this.createJdbcPanel(), (Object)"jdbc");
        this._multiSplitPane.add((Component)this.createQueueInfoPanel(), (Object)"qProdInfo");
        this._multiSplitPane.add((Component)this.createQueueGeneratePanel(), (Object)"qProdGen");
        this._multiSplitPane.add((Component)this.createQueueConsumerPanel(), (Object)"qCons");
        this._multiSplitPane.add((Component)this.createQueueStatisticsPanel(), (Object)"qStats");
        this._multiSplitPane.add((Component)this.createLogPanel(), (Object)"bottom");
        this._multiSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this._multiSplitPane, "Center");
    }

    private JPanel createJdbcPanel() {
        JPanel panel = SwingUtils.createPanel("JDBC Info", true);
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add(new JLabel("ASE Name"));
        panel.add((Component)this._aseName, "pushx, growx, wrap");
        this._aseName.addActionListener(this);
        panel.add(new JLabel("Host Name"));
        panel.add((Component)this._aseHost, "pushx, growx, wrap");
        panel.add(new JLabel("Port Number"));
        panel.add((Component)this._asePort, "pushx, growx, wrap");
        panel.add(new JLabel("DB Name"));
        panel.add((Component)this._aseDbname, "pushx, growx, wrap");
        panel.add(new JLabel("Username"));
        panel.add((Component)this._aseUsername, "pushx, growx, wrap");
        panel.add(new JLabel("Password"));
        panel.add((Component)this._asePassword, "pushx, growx, wrap");
        panel.add((Component)this._aseConnect, "span, align right");
        this._aseConnect.addActionListener(this);
        this.initJdbcData();
        return panel;
    }

    private void initJdbcData() {
        try {
            this._interfacesDriver = new SyInterfacesDriver();
            this._interfacesDriver.open();
        }
        catch (Exception ex) {
            _logger.error((Object)"Problems reading interfaces or sql.ini file.", (Throwable)ex);
        }
        if (this._interfacesDriver != null) {
            _logger.debug((Object)("Just opened the interfaces file '" + this._interfacesDriver.getBundle() + "'."));
            this._aseName.addItem("<-Choose a server->");
            Object[] servers = this._interfacesDriver.getServers();
            Arrays.sort(servers);
            for (int i = 0; i < servers.length; ++i) {
                _logger.debug((Object)("Adding server '" + (String)servers[i] + "' to serverListCB."));
                this._aseName.addItem(servers[i]);
            }
        }
        this._aseHost.setText("localhost");
        this._asePort.setText("5000");
        this._aseUsername.setText("sa");
        this._aseDbname.setText(this._initialDbname);
    }

    private JPanel createQueueInfoPanel() {
        JPanel panel = SwingUtils.createPanel("Queue Producer Info", true);
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add(new JLabel("Current Queue Size"));
        panel.add((Component)this._qProdQSize, "pushx, growx, wrap");
        this._qProdQSize.setEditable(false);
        this._qProdQSize.setText("Unknown");
        panel.add(new JLabel("Current Queue Rate"));
        panel.add((Component)this._qProdQSizeRate, "pushx, growx, wrap");
        this._qProdQSizeRate.setEditable(false);
        this._qProdQSizeRate.setText("Unknown");
        return panel;
    }

    private JPanel createQueueGeneratePanel() {
        JPanel panel = SwingUtils.createPanel("Queue Producer Generator", true);
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add(new JLabel("Type of entries to generate"));
        panel.add((Component)this._qProdGenType, "pushx, growx, wrap");
        panel.add(new JLabel("Number of entries to generate"));
        panel.add((Component)this._qProdGenNum, "pushx, growx, wrap");
        panel.add(new JLabel("How to generate"));
        panel.add((Component)this._qProdGenHow_cbx, "pushx, growx, wrap");
        this._qProdGenHow_cbx.addActionListener(this);
        panel.add((Component)this._qProdGen_but, "span, split, tag right");
        this._qProdGen_but.addActionListener(this);
        this._qProdGen_but.setEnabled(false);
        return panel;
    }

    private JPanel createQueueConsumerPanel() {
        JPanel panel = SwingUtils.createPanel("Queue Consumer Info", true);
        panel.setLayout((LayoutManager)new MigLayout());
        this.initQueueConsumerPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._qConsTable);
        panel.add((Component)jScrollPane, "height 100%, span, grow, wrap");
        panel.add((Component)new JLabel("Current Running Queue Consumers"), "");
        panel.add((Component)this._qConsExecCount, "grow, push, wrap");
        this._qConsExecCount.setEditable(false);
        panel.add((Component)new JLabel("Parameters passed to Procedure 'qConsumer' on Startup"), "");
        panel.add((Component)this._qConsExecParams, "grow, push, wrap");
        panel.add((Component)new JLabel("Pre Configured parameters to 'qConsumer'"), "");
        panel.add((Component)this._qConsExecParams_cbx, "grow, push, wrap");
        this._qConsExecParams_cbx.addActionListener(this);
        panel.add((Component)this._qConsStart_but, "span, split, tag left");
        this._qConsStart_but.addActionListener(this);
        this._qConsStart_but.setEnabled(false);
        panel.add((Component)this._qConsStatus_cbx, "tag other");
        this._qConsStatus_cbx.addActionListener(this);
        this._qConsStatus_cbx.setEnabled(false);
        panel.add((Component)this._qConsStop_but, "tag right");
        this._qConsStop_but.addActionListener(this);
        this._qConsStop_but.setEnabled(false);
        return panel;
    }

    private void initQueueConsumerPanel() {
        this._qConsTableModel = new GTableModel(this._qConsTableCols);
        this._qConsTable = new JXTable((TableModel)this._qConsTableModel);
        this._qConsTable.setAutoResizeMode(0);
    }

    private JPanel createQueueStatisticsPanel() {
        JPanel panel = SwingUtils.createPanel("Statistics Info", true);
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)new JLabel("Statistics about"), "split");
        panel.add((Component)this._qStatType_cbx, "wrap");
        this._qStatType_cbx.addActionListener(this);
        this.initQueueStatisticsPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._qStatTable);
        panel.add((Component)jScrollPane, "height 100%, grow, push, wrap");
        return panel;
    }

    private void initQueueStatisticsPanel() {
        this._qStatTmDefault = new GTableModel(this._qStatTableCols);
        this._qStatTable = new JXTable((TableModel)this._qStatTmDefault);
        this._qStatTable.setAutoResizeMode(0);
        String dbname = "perfdemo";
        String tabname = "DestTab%";
        String sql = " select tabName          = name, \n        rowsInTable      = row_count (db_id('" + dbname + "'), id), \n" + "        dataSizeInKB     = used_pages(db_id('" + dbname + "'), id) * (@@maxpagesize / 1024), \n" + "        rowsInTableRate  = row_count (db_id('" + dbname + "'), id), \n" + "        dataSizeInKBRate = used_pages(db_id('" + dbname + "'), id) * (@@maxpagesize / 1024)\n" + " from " + dbname + "..sysobjects  \n" + " where type = 'U'  \n" + "   and name like '" + tabname + "' \n" + " order by name ";
        int needVersion = 0;
        int needCeVersion = 0;
        String[] monTables = new String[]{};
        String[] needRole = new String[]{};
        String[] needConfig = new String[]{};
        String[] colsCalcDiff = new String[]{"rowsInTableRate", "dataSizeInKBRate"};
        String[] colsCalcPCT = new String[]{};
        LinkedList<String> pkList = new LinkedList<String>();
        pkList.add("tabName");
        this._qStatTmRowCount = new CountersModel("StatRowCount", sql, pkList, colsCalcDiff, colsCalcPCT, monTables, needRole, needConfig, needVersion, needCeVersion, false, false);
    }

    private JPanel createLogPanel() {
        JPanel panel = SwingUtils.createPanel("Log", true);
        panel.setLayout((LayoutManager)new MigLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._logArea);
        panel.add((Component)jScrollPane, "height 100%, grow, push, wrap");
        return panel;
    }

    private void saveLayout() {
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this._splitPaneLayoutFilename)));
            MultiSplitLayout.Node model = this._multiSplitPane.getMultiSplitLayout().getModel();
            e.writeObject(model);
            e.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String str;
        String dbname;
        String port;
        String host;
        String pass;
        String user;
        JComponent source = (JComponent)ae.getSource();
        String name = (String)source.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (this._aseName.equals(source)) {
            String srv = (String)this._aseName.getSelectedItem();
            this._aseHost.setText(AseConnectionFactory.getIHosts(srv));
            this._asePort.setText(AseConnectionFactory.getIPorts(srv));
        }
        if (this._aseConnect.equals(source)) {
            user = this._aseUsername.getText();
            pass = this._asePassword.getText();
            host = this._aseHost.getText();
            port = this._asePort.getText();
            dbname = this._aseDbname.getText();
            this._qCntrlConn = this.aseConnection(false, false, "qController", dbname, user, pass, host, port);
            if (this._qCntrlConn != null) {
                this.qControllerAction("RESUME");
                this._qProdGen_but.setEnabled(true);
                this._qConsStart_but.setEnabled(true);
                this._qConsStatus_cbx.setEnabled(true);
                this._qConsStop_but.setEnabled(true);
                this._qProdGenConn = this.aseConnection(false, false, "qProducer", dbname, user, pass, host, port);
                this._qProdInfoConn = this.aseConnection(false, false, "qProducerInfo", dbname, user, pass, host, port);
                this._qStatInfoConn = this.aseConnection(false, false, "qStatisticsInfo", dbname, user, pass, host, port);
                this._qConsInfoConn = this.aseConnection(false, false, "qConsumerInfo", dbname, user, pass, host, port);
            }
            this.saveLayout();
        }
        if (this._qConsStart_but.equals(source)) {
            if (this._qCntrlConn == null) {
                JOptionPane.showMessageDialog(this, "NOT Connected.\nPlease Connect first.", "PerfDemo - No Connection", 0);
                return;
            }
            user = this._aseUsername.getText();
            pass = this._asePassword.getText();
            host = this._aseHost.getText();
            port = this._asePort.getText();
            dbname = this._aseDbname.getText();
            int consumerId = this._qConsThreadList.size();
            Connection conn = this.aseConnection(false, false, "qConsumer-" + consumerId, dbname, user, pass, host, port);
            String qConsExecParams = this._qConsExecParams.getText();
            QueueConsumer qc = new QueueConsumer(this, conn, consumerId, qConsExecParams);
            this._qConsThreadList.add(qc);
            qc.execute();
        }
        if (this._qConsExecParams_cbx.equals(source)) {
            str = (String)this._qConsExecParams_cbx.getSelectedItem();
            if ("<Use Default parameters>".equals(str)) {
                this._qConsExecParams.setText("");
            } else if ("Batch Size=10, Update Queue Status=1, Use Transaction=1".equals(str)) {
                this._qConsExecParams.setText("@batchSize=10, @updQueueStat=1, @useTrans=1");
            } else if ("Batch Size=10, Update Queue Status=0, Use Transaction=1".equals(str)) {
                this._qConsExecParams.setText("@batchSize=10, @updQueueStat=0, @useTrans=1");
            } else if ("Batch Size=10, Update Queue Status=0, Use Transaction=0".equals(str)) {
                this._qConsExecParams.setText("@batchSize=10, @updQueueStat=0, @useTrans=0");
            } else if ("Batch Size=1, Update Queue Status=0, Use Transaction=0".equals(str)) {
                this._qConsExecParams.setText("@batchSize=1, @updQueueStat=0, @useTrans=0");
            }
        }
        if (this._qConsStatus_cbx.equals(source)) {
            str = (String)this._qConsStatus_cbx.getSelectedItem();
            if ("Resume All Consumers".equals(str)) {
                this.qControllerAction("RESUME");
            } else if ("Pause All Consumers, Wait".equals(str)) {
                this.qControllerAction("PAUSE_WAIT");
            } else if ("Pause All Consumers, NOW".equals(str)) {
                this.qControllerAction("PAUSE_NOW");
            } else if ("Stop All Consumers".equals(str)) {
                this.qControllerAction("STOP_WAIT");
            }
        }
        if (this._qConsStop_but.equals(source)) {
            int consumerId = this._qConsThreadList.size() - 1;
            QueueConsumer qc = this._qConsThreadList.get(consumerId);
            qc.cancel(true);
        }
        if (this._qProdGenHow_cbx.equals(source)) {
            String str2 = (String)this._qProdGenHow_cbx.getSelectedItem();
            if ("All Types".equals(str2)) {
                this._qProdGenType.setText("");
            } else {
                this._qProdGenType.setText(str2);
            }
        }
        if (this._qProdGen_but.equals(source)) {
            int number = -1;
            try {
                number = Integer.parseInt(this._qProdGenNum.getText());
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            String type = this._qProdGenType.getText();
            if (type.trim().equals("")) {
                type = null;
            }
            final String fType = type;
            final int fNumber = number;
            PerfDemoInfoThread doIt = new PerfDemoInfoThread("qProducerGenerate", this){

                @Override
                public boolean doWork() {
                    this._perfDemo.qProducerGenerate(fType, fNumber);
                    return false;
                }
            };
            doIt.start();
        }
        if (this._qStatType_cbx.equals(source)) {
            String str3 = (String)this._qStatType_cbx.getSelectedItem();
            if ("Queue Info Statistics".equals(str3)) {
                this._qStatCurrentType = "Queue Info Statistics";
                this._qStatTable.setModel((TableModel)this._qStatTmDefault);
            } else if ("Destination Table Row Count".equals(str3)) {
                this._qStatCurrentType = "Destination Table Row Count";
                this._qStatTable.setModel((TableModel)this._qStatTmRowCount);
            }
        }
    }

    protected void qProducerGenerate(String type, int batchSize) {
        String typeStr = type == null ? "@type=null" : "@type='" + type + "'";
        String batchSizeStr = batchSize <= 0 ? "@batchSize=null" : "@batchSize=" + batchSize;
        Connection conn = this._qProdGenConn;
        String sql = "exec qGenerate " + batchSizeStr + ", " + typeStr;
        System.out.println("BEGIN: qProducerGenerate() sql: " + sql);
        try {
            Statement stmnt = conn.createStatement();
            stmnt.executeUpdate(sql);
            stmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)("qProducerGenerate(): problems exec sql: " + sql));
        }
        System.out.println("END: qProducerGenerate() sql: " + sql);
    }

    private void qControllerAction(String action) {
        Connection conn = this._qCntrlConn;
        String sql = "exec setAppStatus 'qController', null, '" + action + "'";
        try {
            Statement stmnt = conn.createStatement();
            stmnt.executeUpdate(sql);
            stmnt.close();
        }
        catch (SQLException e) {
            _logger.error((Object)("qControllerAction(" + action + "): problems exec sql: " + sql));
        }
    }

    private int getProducerQueueSize() {
        int rows = -1;
        Connection conn = this._qProdInfoConn;
        String sql = "select row_count(db_id(), object_id('TestQueue'))";
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            while (rs.next()) {
                rows = rs.getInt(1);
            }
            rs.close();
            stmnt.close();
            return rows;
        }
        catch (SQLException e) {
            _logger.error((Object)("getProducerQueueSize(): problems exec sql '" + sql + "'. Caught " + e));
            return -1;
        }
    }

    protected void refreshQProducerInfo() {
        int size = this.getProducerQueueSize();
        this._qProdQSize.setText(size + "");
        if (this._qProdQSizeTime != 0L) {
            int sizeDiff = this._qProdQSizeSave - size;
            long timeDiff = System.currentTimeMillis() - this._qProdQSizeTime;
            if (timeDiff / 1000L > 0L) {
                double rate = (long)sizeDiff / (timeDiff / 1000L);
                this._qProdQSizeRate.setText(rate + " per second");
            }
        }
        this._qProdQSizeTime = System.currentTimeMillis();
        this._qProdQSizeSave = size;
    }

    protected void refreshQConsumerInfo() {
        Connection conn = this._qConsInfoConn;
        String sql = "select spid, status, cmd, clienthostname, clientname from master..sysprocesses where clientapplname = 'qConsumer'";
        try {
            Statement stmnt = conn.createStatement();
            ResultSet rs = stmnt.executeQuery(sql);
            Vector<Vector<Object>> rows = new Vector<Vector<Object>>();
            while (rs.next()) {
                Vector<Object> row = new Vector<Object>();
                row.add(rs.getObject(1));
                row.add(rs.getObject(2));
                row.add(rs.getObject(3));
                row.add(rs.getObject(4));
                row.add(rs.getObject(5));
                rows.add(row);
            }
            rs.close();
            stmnt.close();
            this._qConsTableModel.setDataVector(rows);
            if (this._qConsTableModel.timeToPackAll()) {
                this._qConsTable.packAll();
            }
            this._qConsExecCount.setText("" + this._qConsTableModel.getRowCount());
        }
        catch (SQLException e) {
            _logger.error((Object)("getQConsumerInfo(): problems exec sql '" + sql + "'. Caught " + e));
        }
    }

    protected void refreshQStatInfo() {
        Connection conn = this._qStatInfoConn;
        if (this._qStatCurrentType.equals("Queue Info Statistics")) {
            String sql = "select * from qStatInfo";
            try {
                Statement stmnt = conn.createStatement();
                ResultSet rs = stmnt.executeQuery(sql);
                Vector<Vector<Object>> rows = new Vector<Vector<Object>>();
                while (rs.next()) {
                    Vector<Object> row = new Vector<Object>();
                    row.add(rs.getObject(1));
                    row.add(rs.getObject(2));
                    row.add(rs.getObject(3));
                    row.add(rs.getObject(4));
                    row.add(rs.getObject(5));
                    row.add(rs.getObject(6));
                    row.add(rs.getObject(7));
                    rows.add(row);
                }
                rs.close();
                stmnt.close();
                this._qStatTmDefault.setDataVector(rows);
                if (this._qStatTmDefault.timeToPackAll()) {
                    this._qStatTable.packAll();
                }
            }
            catch (SQLException e) {
                _logger.error((Object)("refreshQStatInfo(): problems exec sql '" + sql + "'. Caught " + e));
            }
        }
        if (this._qStatCurrentType.equals("Destination Table Row Count")) {
            try {
                this._qStatTmRowCount.refresh(conn);
            }
            catch (Exception e) {
                _logger.error((Object)("refreshQStatInfo(): problems exec CounterModel. Caught " + e));
            }
        }
    }

    public void appendToLog(String str) {
        if (str != null && !str.endsWith("\n")) {
            str = str + "\n";
        }
        JTextPane screen = this._logArea;
        Document doc = screen.getDocument();
        try {
            doc.insertString(doc.getLength(), str, null);
            screen.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException ble) {
            System.out.println("Couldn't insert text");
        }
    }

    private Connection aseConnection(boolean showInfo, boolean closeConn, String appname, String dbname, String user, String passwd, String host, String port) {
        try {
            Connection conn = AseConnectionFactory.getConnection(host, port, dbname, user, passwd, appname, "", null);
            if (conn instanceof SybConnection) {
                ((SybConnection)conn).setSybMessageHandler((SybMessageHandler)new PerfDemoSybMessageHandler(appname + ": ", this, null));
            }
            String aseVersionStr = "unknown";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@version");
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            if (showInfo) {
                JOptionPane.showMessageDialog(this, "Connection succeeded.\n\n" + aseVersionStr, "PerfDemo - connect check", 1);
            } else {
                this.appendToLog("Connection succeeded: " + aseVersionStr);
            }
            if (closeConn) {
                conn.close();
                conn = null;
                return null;
            }
            if (dbname != null && !dbname.trim().equals("")) {
                AseConnectionUtils.useDbname(conn, dbname);
            }
            String currentDbname = AseConnectionUtils.getCurrentDbname(conn);
            if (dbname != null && !dbname.trim().equals("") && !currentDbname.equals(dbname)) {
                JOptionPane.showMessageDialog(this, "Connection FAILED.\n\nCurrent dbname is '" + currentDbname + "'.\n" + "But you requested to be in '" + dbname + "'.", "PerfDemo - connect check", 0);
                conn.close();
                conn = null;
            }
            return conn;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + sb.toString(), "PerfDemo - connect check", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Connection FAILED.\n\n" + e.toString(), "PerfDemo - connect check", 0);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        PerfDemo perfDemo = new PerfDemo("perfdemo");
        perfDemo.setVisible(true);
    }

    private class GTableModel
    extends AbstractTableModel {
        protected Vector<Vector<Object>> _rows = new Vector();
        protected Vector<String> _head = new Vector();
        protected long _packAllTime = 0L;
        protected long _timeBetweenPackAll = 10000L;

        public GTableModel(Vector<String> columnHeader) {
            this._head = columnHeader;
        }

        public boolean timeToPackAll() {
            boolean doPackAll;
            boolean bl = doPackAll = System.currentTimeMillis() - this._packAllTime > this._timeBetweenPackAll;
            if (doPackAll) {
                this._packAllTime = System.currentTimeMillis();
            }
            return doPackAll;
        }

        public void setDataVector(Vector<Vector<Object>> rows) {
            if (this._rows.size() == 0 && rows.size() > 0) {
                this._packAllTime = 0L;
            }
            this._rows = rows;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            return this._head.get(column);
        }

        @Override
        public int getColumnCount() {
            return this._head.size();
        }

        @Override
        public int getRowCount() {
            return this._rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Vector<Object> row = this._rows.get(rowIndex);
            return row.get(columnIndex);
        }
    }

    public class PerfDemoSybMessageHandler
    implements SybMessageHandler {
        private PerfDemo _perfDemo = null;
        private QueueConsumer _qConsW = null;
        private String _logPrefix = "";
        private List<Integer> _discardMsgNum = new LinkedList<Integer>();
        private List<String> _discardMsgStr = new LinkedList<String>();

        public PerfDemoSybMessageHandler(String logPrefix, PerfDemo perfDemo2, QueueConsumer qCons) {
            this._perfDemo = perfDemo2;
            this._qConsW = qCons;
            this.setLogPrefix(logPrefix);
            this.addDiscardMsgNum(10351);
            this.addDiscardMsgNum(969);
            this.addDiscardMsgStr("Cluster wide monitor command succeeded.");
        }

        public void resetDiscardMsgNum() {
            this._discardMsgNum.clear();
        }

        public List<Integer> getDiscardMsgNum() {
            return this._discardMsgNum;
        }

        public void addDiscardMsgNum(int msgNum) {
            Integer msgNumInt = new Integer(msgNum);
            if (!this._discardMsgNum.contains(msgNumInt)) {
                this._discardMsgNum.add(msgNumInt);
            }
        }

        public void resetDiscardMsgStr() {
            this._discardMsgStr.clear();
        }

        public List<String> getDiscardMsgStr() {
            return this._discardMsgStr;
        }

        public void addDiscardMsgStr(String regexp) {
            if (!this._discardMsgStr.contains(regexp)) {
                this._discardMsgStr.add(regexp);
            }
        }

        public void setLogPrefix(String msgPrefix) {
            this._logPrefix = msgPrefix;
            if (this._logPrefix == null) {
                this._logPrefix = "";
            }
            if (!this._logPrefix.endsWith(": ")) {
                this._logPrefix = this._logPrefix + ": ";
            }
        }

        public String getLogPrefix() {
            return this._logPrefix;
        }

        public SQLException messageHandler(SQLException sqle) {
            int code = sqle.getErrorCode();
            Integer codeInt = new Integer(code);
            String msgStr = sqle.getMessage();
            StringBuilder sb = new StringBuilder();
            StringBuilder logMsg = new StringBuilder();
            StringBuilder isqlMsg = new StringBuilder();
            if (sqle instanceof EedInfo) {
                EedInfo m = (EedInfo)sqle;
                logMsg.append("Server='").append(m.getServerName()).append("', ");
                logMsg.append("MsgNum='").append(sqle.getErrorCode()).append("', ");
                logMsg.append("Severity='").append(m.getSeverity()).append("', ");
                logMsg.append("Proc='").append(m.getProcedureName()).append("', ");
                logMsg.append("Line='").append(m.getLineNumber()).append("', ");
                logMsg.append("Msg: ").append(sqle.getMessage());
                if (logMsg.charAt(logMsg.length() - 1) == '\n') {
                    logMsg.deleteCharAt(logMsg.length() - 1);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)(this.getLogPrefix() + logMsg.toString()));
                }
                if (m.getSeverity() <= 10) {
                    sb.append(sqle.getMessage());
                    String str = sb.toString();
                    if (str == null || str != null && str.trim().equals("")) {
                        return null;
                    }
                } else {
                    isqlMsg.append("Msg ").append(sqle.getErrorCode()).append(", Level ").append(m.getSeverity()).append(", State ").append(m.getState()).append(":\n");
                    boolean addComma = false;
                    String str = m.getServerName();
                    if (str != null && !str.equals("")) {
                        addComma = true;
                        isqlMsg.append("Server '").append(str).append("'");
                    }
                    if ((str = m.getProcedureName()) != null && !str.equals("")) {
                        if (addComma) {
                            isqlMsg.append(", ");
                        }
                        addComma = true;
                        isqlMsg.append("Procedure '").append(str).append("'");
                    }
                    if ((str = m.getLineNumber() + "") != null && !str.equals("")) {
                        if (addComma) {
                            isqlMsg.append(", ");
                        }
                        addComma = true;
                        isqlMsg.append("Line ").append(str).append(":");
                        addComma = false;
                        isqlMsg.append("\n");
                    }
                    isqlMsg.append(sqle.getMessage());
                }
                if (isqlMsg.length() > 0 && isqlMsg.charAt(isqlMsg.length() - 1) == '\n') {
                    isqlMsg.deleteCharAt(isqlMsg.length() - 1);
                }
            }
            if (code == 3604) {
                // empty if block
            }
            if (code == 921 || code == 950) {
                // empty if block
            }
            if (code == 1205 && this._qConsW != null) {
                this._qConsW._deadlock = true;
            }
            if (code == 12205) {
                // empty if block
            }
            if (code == 208 || code == 504 || code == 2501 || code == 2812 || code == 9938 || code == 10303 || code == 10337 || code == 11901 || code == 11910 || code == 18826) {
                // empty if block
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(this.getLogPrefix() + "INFO Discard message number list: " + this._discardMsgNum));
            }
            if (this._discardMsgNum.contains(codeInt)) {
                _logger.debug((Object)(this.getLogPrefix() + ">>>>> Discarding message: " + logMsg.toString()));
                return null;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(this.getLogPrefix() + "INFO Discard message text list: " + this._discardMsgStr));
            }
            for (String regexp : this._discardMsgStr) {
                if (msgStr.indexOf(regexp) < 0) continue;
                _logger.debug((Object)(this.getLogPrefix() + ">>>>> Discarding message: " + logMsg.toString()));
                return null;
            }
            String msg = null;
            msg = logMsg.toString();
            if (this._qConsW != null) {
                LinkedList<String> logList = new LinkedList<String>();
                logList.add(msg);
                this._qConsW.process((List<String>)logList);
            } else if (this._perfDemo != null) {
                this._perfDemo.appendToLog(msg);
            } else {
                System.out.println(msg);
            }
            return sqle;
        }
    }

    private class QueueConsumer
    extends PerfDemoSwingWorker<String, String> {
        private PerfDemo _perfDemo = null;
        private Connection _conn = null;
        private int _consumerId = -1;
        private boolean _deadlock = false;
        private String _qConsParams = "";

        public QueueConsumer(PerfDemo perfDemo2, Connection conn, int consumerId, String qConsParams) {
            this._perfDemo = perfDemo2;
            this._conn = conn;
            this._consumerId = consumerId;
            this._qConsParams = qConsParams;
        }

        @Override
        protected String doInBackground() throws Exception {
            Thread.currentThread().setName("QueueConsumer-" + this._consumerId);
            System.out.println(Thread.currentThread().getName() + ": Start.");
            if (this._conn instanceof SybConnection) {
                ((SybConnection)this._conn).setSybMessageHandler((SybMessageHandler)new PerfDemoSybMessageHandler(Thread.currentThread().getName(), this._perfDemo, this));
            }
            boolean running = true;
            while (running) {
                running = false;
                this._deadlock = false;
                String exitStatus = null;
                String sql = "exec qConsumer " + this._qConsParams;
                try {
                    Statement stmnt = this._conn.createStatement();
                    ResultSet rs = stmnt.executeQuery(sql);
                    while (rs.next()) {
                        exitStatus = rs.getString(1);
                    }
                    rs.close();
                    stmnt.close();
                }
                catch (SQLException e) {
                    _logger.error((Object)("refreshQStatInfo(): problems exec sql '" + sql + "'. Caught " + e));
                }
                if (this._deadlock) {
                    running = true;
                    this.publish("ThreadName='" + Thread.currentThread().getName() + "', UPS... Caught a DEADLOCK, lets RETRY...");
                    continue;
                }
                if (exitStatus != null) {
                    if (exitStatus.equals("STOPPED")) {
                        running = false;
                    }
                    if (exitStatus.equals("NORMAL_EXIT")) {
                        running = false;
                    }
                } else {
                    running = false;
                }
                this.publish("ThreadName='" + Thread.currentThread().getName() + "', -end-of-exec-do-new-one-");
            }
            this._conn.close();
            this.publish("ThreadName='" + Thread.currentThread().getName() + "', STOPPING, at end of the run() method.");
            return null;
        }

        @Override
        protected void done() {
        }

        @Override
        protected void process(List<String> chunks) {
            for (String str : chunks) {
                this._perfDemo.appendToLog(Thread.currentThread().getName() + ": process() = '" + str + "'.\n");
            }
        }
    }

    private class QueueStatisticsInfoThread
    extends PerfDemoInfoThread {
        public QueueStatisticsInfoThread(String name, PerfDemo perfDemo2) {
            super(name, perfDemo2);
        }

        @Override
        public boolean doWork() {
            try {
                if (this._perfDemo._qStatInfoConn != null) {
                    this._perfDemo.refreshQStatInfo();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                System.out.println(Thread.currentThread().getName() + ": was interrupted..");
                return false;
            }
            return true;
        }
    }

    private class QueueConsumerInfoThread
    extends PerfDemoInfoThread {
        public QueueConsumerInfoThread(String name, PerfDemo perfDemo2) {
            super(name, perfDemo2);
        }

        @Override
        public boolean doWork() {
            try {
                if (this._perfDemo._qConsInfoConn != null) {
                    this._perfDemo.refreshQConsumerInfo();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                System.out.println(Thread.currentThread().getName() + ": was interrupted..");
                return false;
            }
            return true;
        }
    }

    private class QueueProducerInfoThread
    extends PerfDemoInfoThread {
        public QueueProducerInfoThread(String name, PerfDemo perfDemo2) {
            super(name, perfDemo2);
        }

        @Override
        public boolean doWork() {
            try {
                if (this._perfDemo._qProdInfoConn != null) {
                    this._perfDemo.refreshQProducerInfo();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                System.out.println(Thread.currentThread().getName() + ": was interrupted..");
                return false;
            }
            return true;
        }
    }

    private abstract class PerfDemoInfoThread
    extends Thread {
        protected String _name = null;
        protected PerfDemo _perfDemo = null;

        public PerfDemoInfoThread(String name, PerfDemo perfDemo2) {
            this._name = name;
            this._perfDemo = perfDemo2;
        }

        public abstract boolean doWork();

        @Override
        public void run() {
            Thread.currentThread().setName(this._name);
            System.out.println(Thread.currentThread().getName() + ": Start.");
            boolean running = true;
            while (running) {
                try {
                    running = this.doWork();
                }
                catch (Throwable t) {
                    _logger.error((Object)(Thread.currentThread().getName() + " Thread had problems, which will be retried. Caught " + t), t);
                }
            }
            System.out.println(Thread.currentThread().getName() + ": Stopped.");
        }
    }
}

