/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.KnownHosts;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SwingShell {
    static final String knownHostPath = "~/.ssh/known_hosts";
    static final String idDSAPath = "~/.ssh/id_dsa";
    static final String idRSAPath = "~/.ssh/id_rsa";
    JFrame loginFrame = null;
    JLabel hostLabel;
    JLabel userLabel;
    JTextField hostField;
    JTextField userField;
    JButton loginButton;
    KnownHosts database = new KnownHosts();

    public SwingShell() {
        File knownHostFile = new File(knownHostPath);
        if (knownHostFile.exists()) {
            try {
                this.database.addHostkeys(knownHostFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void loginPressed() {
        String hostname = this.hostField.getText().trim();
        String username = this.userField.getText().trim();
        if (hostname.length() == 0 || username.length() == 0) {
            JOptionPane.showMessageDialog(this.loginFrame, "Please fill out both fields!");
            return;
        }
        this.loginButton.setEnabled(false);
        this.hostField.setEnabled(false);
        this.userField.setEnabled(false);
        ConnectionThread ct = new ConnectionThread(hostname, username);
        ct.start();
    }

    void showGUI() {
        this.loginFrame = new JFrame("Ganymed SSH2 SwingShell");
        this.hostLabel = new JLabel("Hostname:");
        this.userLabel = new JLabel("Username:");
        this.hostField = new JTextField("", 20);
        this.userField = new JTextField("", 10);
        this.loginButton = new JButton("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingShell.this.loginPressed();
            }
        });
        JPanel loginPanel = new JPanel();
        loginPanel.add(this.hostLabel);
        loginPanel.add(this.hostField);
        loginPanel.add(this.userLabel);
        loginPanel.add(this.userField);
        loginPanel.add(this.loginButton);
        this.loginFrame.getRootPane().setDefaultButton(this.loginButton);
        this.loginFrame.getContentPane().add((Component)loginPanel, "First");
        this.loginFrame.setDefaultCloseOperation(3);
        this.loginFrame.pack();
        this.loginFrame.setResizable(false);
        this.loginFrame.setLocationRelativeTo(null);
        this.loginFrame.setVisible(true);
    }

    void startGUI() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingShell.this.showGUI();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public static void main(String[] args) {
        SwingShell client = new SwingShell();
        client.startGUI();
    }

    class ConnectionThread
    extends Thread {
        String hostname;
        String username;

        public ConnectionThread(String hostname, String username) {
            this.hostname = hostname;
            this.username = username;
        }

        @Override
        public void run() {
            Connection conn = new Connection(this.hostname);
            try {
                block16: {
                    String[] hostkeyAlgos = SwingShell.this.database.getPreferredServerHostkeyAlgorithmOrder(this.hostname);
                    if (hostkeyAlgos != null) {
                        conn.setServerHostKeyAlgorithms(hostkeyAlgos);
                    }
                    conn.connect((ServerHostKeyVerifier)new AdvancedVerifier());
                    boolean enableKeyboardInteractive = true;
                    boolean enableDSA = true;
                    boolean enableRSA = true;
                    String lastError = null;
                    while (true) {
                        if ((enableDSA || enableRSA) && conn.isAuthMethodAvailable(this.username, "publickey")) {
                            boolean res;
                            EnterSomethingDialog esd;
                            File key;
                            if (enableDSA) {
                                key = new File(SwingShell.idDSAPath);
                                if (key.exists()) {
                                    esd = new EnterSomethingDialog(SwingShell.this.loginFrame, "DSA Authentication", new String[]{lastError, "Enter DSA private key password:"}, true);
                                    esd.setVisible(true);
                                    res = conn.authenticateWithPublicKey(this.username, key, esd.answer);
                                    if (res) break block16;
                                    lastError = "DSA authentication failed.";
                                }
                                enableDSA = false;
                            }
                            if (!enableRSA) continue;
                            key = new File(SwingShell.idRSAPath);
                            if (key.exists()) {
                                esd = new EnterSomethingDialog(SwingShell.this.loginFrame, "RSA Authentication", new String[]{lastError, "Enter RSA private key password:"}, true);
                                esd.setVisible(true);
                                res = conn.authenticateWithPublicKey(this.username, key, esd.answer);
                                if (res) break block16;
                                lastError = "RSA authentication failed.";
                            }
                            enableRSA = false;
                            continue;
                        }
                        if (enableKeyboardInteractive && conn.isAuthMethodAvailable(this.username, "keyboard-interactive")) {
                            InteractiveLogic il = new InteractiveLogic(lastError);
                            boolean res = conn.authenticateWithKeyboardInteractive(this.username, (InteractiveCallback)il);
                            if (!res) {
                                if (il.getPromptCount() == 0) {
                                    lastError = "Keyboard-interactive does not work.";
                                    enableKeyboardInteractive = false;
                                    continue;
                                }
                                lastError = "Keyboard-interactive auth failed.";
                                continue;
                            }
                        } else {
                            if (!conn.isAuthMethodAvailable(this.username, "password")) break;
                            EnterSomethingDialog esd = new EnterSomethingDialog(SwingShell.this.loginFrame, "Password Authentication", new String[]{lastError, "Enter password for " + this.username}, true);
                            esd.setVisible(true);
                            if (esd.answer == null) {
                                throw new IOException("Login aborted by user");
                            }
                            boolean res = conn.authenticateWithPassword(this.username, esd.answer);
                            if (!res) {
                                lastError = "Password authentication failed.";
                                continue;
                            }
                        }
                        break block16;
                        break;
                    }
                    throw new IOException("No supported authentication methods available.");
                }
                Session sess = conn.openSession();
                int x_width = 90;
                int y_width = 30;
                sess.requestPTY("dumb", x_width, y_width, 0, 0, null);
                sess.startShell();
                TerminalDialog td = new TerminalDialog(SwingShell.this.loginFrame, this.username + "@" + this.hostname, sess, x_width, y_width);
                td.setVisible(true);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(SwingShell.this.loginFrame, "Exception: " + e.getMessage());
            }
            conn.close();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SwingShell.this.loginFrame.dispose();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    class InteractiveLogic
    implements InteractiveCallback {
        int promptCount = 0;
        String lastError;

        public InteractiveLogic(String lastError) {
            this.lastError = lastError;
        }

        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws IOException {
            String[] result = new String[numPrompts];
            for (int i = 0; i < numPrompts; ++i) {
                String[] content = new String[]{this.lastError, name, instruction, prompt[i]};
                if (this.lastError != null) {
                    this.lastError = null;
                }
                EnterSomethingDialog esd = new EnterSomethingDialog(SwingShell.this.loginFrame, "Keyboard Interactive Authentication", content, !echo[i]);
                esd.setVisible(true);
                if (esd.answer == null) {
                    throw new IOException("Login aborted by user");
                }
                result[i] = esd.answer;
                ++this.promptCount;
            }
            return result;
        }

        public int getPromptCount() {
            return this.promptCount;
        }
    }

    class AdvancedVerifier
    implements ServerHostKeyVerifier {
        AdvancedVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            String message;
            String host = hostname;
            String algo = serverHostKeyAlgorithm;
            int result = SwingShell.this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
            switch (result) {
                case 0: {
                    return true;
                }
                case 1: {
                    message = "Do you want to accept the hostkey (type " + algo + ") from " + host + " ?\n";
                    break;
                }
                case 2: {
                    message = "WARNING! Hostkey for " + host + " has changed!\nAccept anyway?\n";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String hexFingerprint = KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            String bubblebabbleFingerprint = KnownHosts.createBubblebabbleFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
            message = message + "Hex Fingerprint: " + hexFingerprint + "\nBubblebabble Fingerprint: " + bubblebabbleFingerprint;
            int choice = JOptionPane.showConfirmDialog(SwingShell.this.loginFrame, message);
            if (choice == 0) {
                String hashedHostname = KnownHosts.createHashedHostname((String)hostname);
                SwingShell.this.database.addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
                try {
                    KnownHosts.addHostkeyToFile((File)new File(SwingShell.knownHostPath), (String[])new String[]{hashedHostname}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                return true;
            }
            if (choice == 2) {
                throw new Exception("The user aborted the server hostkey verification.");
            }
            return false;
        }
    }

    class TerminalDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        JPanel botPanel;
        JButton logoffButton;
        JTextArea terminalArea;
        Session sess;
        InputStream in;
        OutputStream out;
        int x;
        int y;

        public TerminalDialog(JFrame parent, String title, Session sess, int x, int y) throws IOException {
            super(parent, title, true);
            this.sess = sess;
            this.in = sess.getStdout();
            this.out = sess.getStdin();
            this.x = x;
            this.y = y;
            this.botPanel = new JPanel(new FlowLayout(0));
            this.logoffButton = new JButton("Logout");
            this.botPanel.add(this.logoffButton);
            this.logoffButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TerminalDialog.this.dispose();
                }
            });
            Font f = new Font("Monospaced", 0, 16);
            this.terminalArea = new JTextArea(y, x);
            this.terminalArea.setFont(f);
            this.terminalArea.setBackground(Color.BLACK);
            this.terminalArea.setForeground(Color.ORANGE);
            this.terminalArea.setCaretColor(Color.BLACK);
            KeyAdapter kl = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    try {
                        TerminalDialog.this.out.write(c);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    e.consume();
                }
            };
            this.terminalArea.addKeyListener(kl);
            this.getContentPane().add((Component)this.terminalArea, "Center");
            this.getContentPane().add((Component)this.botPanel, "Last");
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(parent);
            new RemoteConsumer().start();
        }

        public void setContent(String lines) {
            this.terminalArea.setText(lines);
        }

        class RemoteConsumer
        extends Thread {
            char[][] lines;
            int posy;
            int posx;

            RemoteConsumer() {
                this.lines = new char[TerminalDialog.this.y][];
                this.posy = 0;
                this.posx = 0;
            }

            private void addText(byte[] data, int len) {
                for (int i = 0; i < len; ++i) {
                    int k;
                    char c = (char)(data[i] & 0xFF);
                    if (c == '\b') {
                        if (this.posx < 0) continue;
                        --this.posx;
                        continue;
                    }
                    if (c == '\r') {
                        this.posx = 0;
                        continue;
                    }
                    if (c == '\n') {
                        ++this.posy;
                        if (this.posy < TerminalDialog.this.y) continue;
                        for (k = 1; k < TerminalDialog.this.y; ++k) {
                            this.lines[k - 1] = this.lines[k];
                        }
                        --this.posy;
                        this.lines[TerminalDialog.this.y - 1] = new char[TerminalDialog.this.x];
                        for (k = 0; k < TerminalDialog.this.x; ++k) {
                            this.lines[TerminalDialog.this.y - 1][k] = 32;
                        }
                        continue;
                    }
                    if (c < ' ') continue;
                    if (this.posx >= TerminalDialog.this.x) {
                        this.posx = 0;
                        ++this.posy;
                        if (this.posy >= TerminalDialog.this.y) {
                            --this.posy;
                            for (k = 1; k < TerminalDialog.this.y; ++k) {
                                this.lines[k - 1] = this.lines[k];
                            }
                            this.lines[TerminalDialog.this.y - 1] = new char[TerminalDialog.this.x];
                            for (k = 0; k < TerminalDialog.this.x; ++k) {
                                this.lines[TerminalDialog.this.y - 1][k] = 32;
                            }
                        }
                    }
                    if (this.lines[this.posy] == null) {
                        this.lines[this.posy] = new char[TerminalDialog.this.x];
                        for (k = 0; k < TerminalDialog.this.x; ++k) {
                            this.lines[this.posy][k] = 32;
                        }
                    }
                    this.lines[this.posy][this.posx] = c;
                    ++this.posx;
                }
                StringBuffer sb = new StringBuffer(TerminalDialog.this.x * TerminalDialog.this.y);
                for (int i = 0; i < this.lines.length; ++i) {
                    if (i != 0) {
                        sb.append('\n');
                    }
                    if (this.lines[i] == null) continue;
                    sb.append(this.lines[i]);
                }
                TerminalDialog.this.setContent(sb.toString());
            }

            @Override
            public void run() {
                byte[] buff = new byte[8192];
                try {
                    while (true) {
                        int len;
                        if ((len = TerminalDialog.this.in.read(buff)) == -1) {
                            return;
                        }
                        this.addText(buff, len);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    class EnterSomethingDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        JTextField answerField;
        JPasswordField passwordField;
        final boolean isPassword;
        String answer;

        public EnterSomethingDialog(JFrame parent, String title, String content, boolean isPassword) {
            this(parent, title, new String[]{content}, isPassword);
        }

        public EnterSomethingDialog(JFrame parent, String title, String[] content, boolean isPassword) {
            super(parent, title, true);
            this.isPassword = isPassword;
            JPanel pan = new JPanel();
            pan.setLayout(new BoxLayout(pan, 1));
            for (int i = 0; i < content.length; ++i) {
                if (content[i] == null || content[i] == "") continue;
                JLabel contentLabel = new JLabel(content[i]);
                pan.add(contentLabel);
            }
            this.answerField = new JTextField(20);
            this.passwordField = new JPasswordField(20);
            if (isPassword) {
                pan.add(this.passwordField);
            } else {
                pan.add(this.answerField);
            }
            KeyAdapter kl = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        EnterSomethingDialog.this.finish();
                    }
                }
            };
            this.answerField.addKeyListener(kl);
            this.passwordField.addKeyListener(kl);
            this.getContentPane().add("Center", pan);
            this.setResizable(false);
            this.pack();
            this.setLocationRelativeTo(null);
        }

        private void finish() {
            this.answer = this.isPassword ? new String(this.passwordField.getPassword()) : this.answerField.getText();
            this.dispose();
        }
    }
}

