/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import asemon.test.SpringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class TableFilterDemo
extends JPanel
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private boolean DEBUG = false;
    private JXTable table;
    private JTextField filterText;
    private JTextField statusText;
    private HighlightPredicate _highligtIfDelta = new HighlightPredicate(){

        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.convertColumnIndexToModel(adapter.column) == 3;
        }
    };
    private Highlighter[] _highliters = new Highlighter[]{new HighlighterDiffData(this._highligtIfDelta)};

    @Override
    public void tableChanged(TableModelEvent e) {
        this.table.tableChanged(e);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.packAll();
    }

    public TableFilterDemo() {
        this.setLayout(new BoxLayout(this, 1));
        final MyTableModel model = new MyTableModel();
        this.table = new JXTable((TableModel)model);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 700));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.packAll();
        this.table.setSortable(true);
        this.table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this.table.setColumnControlVisible(true);
        this.table.setHighlighters(this._highliters);
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String str = (String)adapter.getValue(adapter.getColumnIndex((Object)"FirstName"));
                return "".equals(str) || "xxx".equals(str);
            }
        }, Color.RED, null));
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String str = (String)adapter.getValue(adapter.getColumnIndex((Object)"LastName"));
                return "".equals(str) || "xxx".equals(str);
            }
        }, Color.GREEN, null));
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String str = (String)adapter.getValue(adapter.getColumnIndex((Object)"Sport"));
                return "".equals(str) || "xxx".equals(str);
            }
        }, Color.CYAN, null));
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Boolean bool = (Boolean)adapter.getValue(adapter.getColumnIndex((Object)"Vegetarian"));
                return bool != null && bool != false;
            }
        }, Color.YELLOW, null));
        this.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Integer years = (Integer)adapter.getValue(adapter.getColumnIndex((Object)"# of Years"));
                return years != null && years % 3 == 0;
            }
        }, Color.PINK, null));
        model.removeTableModelListener((TableModelListener)this.table);
        model.addTableModelListener(this);
        Thread changeTableThread = new Thread(){

            @Override
            public void run() {
                int count = 0;
                while (true) {
                    System.out.println("Adding: " + ++count);
                    model.addRow("goran-" + count, "Schwarz-" + count, "any-" + count, count, false);
                    model.addRow("h\u00e5kan-" + count, "Schwarz-" + count, "all-" + count, count, false);
                    System.out.println(" - Sleeping ");
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    System.out.println(" - Deleting ");
                    model.deleteRow(-1);
                    System.out.println(" - Sleeping ");
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        changeTableThread.setName("changeTableThread");
        changeTableThread.setDaemon(true);
        changeTableThread.start();
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int viewRow = TableFilterDemo.this.table.getSelectedRow();
                if (viewRow < 0) {
                    TableFilterDemo.this.statusText.setText("");
                } else {
                    int modelRow = TableFilterDemo.this.table.convertRowIndexToModel(viewRow);
                    TableFilterDemo.this.statusText.setText(String.format("Selected Row in view: %d. Selected Row in model: %d.", viewRow, modelRow));
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add(scrollPane);
        JPanel form = new JPanel(new SpringLayout());
        JLabel l1 = new JLabel("Filter Text:", 11);
        form.add(l1);
        this.filterText = new JTextField();
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableFilterDemo.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableFilterDemo.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableFilterDemo.this.newFilter();
            }
        });
        l1.setLabelFor(this.filterText);
        form.add(this.filterText);
        JLabel l2 = new JLabel("Status:", 11);
        form.add(l2);
        this.statusText = new JTextField();
        l2.setLabelFor(this.statusText);
        form.add(this.statusText);
        SpringUtilities.makeCompactGrid(form, 2, 2, 6, 6, 6, 6);
        this.add(form);
    }

    private void newFilter() {
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter(this.filterText.getText(), 0);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.table.setRowFilter(rf);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("TableFilterDemo");
        frame.setDefaultCloseOperation(3);
        TableFilterDemo newContentPane = new TableFilterDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableFilterDemo.createAndShowGUI();
            }
        });
    }

    public void addHighlighter(Highlighter highlighter) {
        this.table.addHighlighter(highlighter);
    }

    private static class HighlighterDiffData
    extends AbstractHighlighter {
        public HighlighterDiffData(HighlightPredicate predicate) {
            super(predicate);
        }

        protected Component doHighlight(Component comp, ComponentAdapter adapter) {
            Object value = adapter.getFilteredValueAt(adapter.row, adapter.convertColumnIndexToModel(adapter.column));
            if (value instanceof Number) {
                comp.setForeground(Color.BLUE);
                if (((Number)value).doubleValue() != 0.0) {
                    comp.setFont(comp.getFont().deriveFont(1));
                }
            }
            return comp;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"FirstName", "LastName", "Sport", "# of Years", "Vegetarian"};
        private List<List<Object>> data = new ArrayList<List<Object>>();

        public void printTableModelListeners() {
            int i = 0;
            for (TableModelListener tml : this.getTableModelListeners()) {
                System.out.println("       - tml(" + i++ + "): " + tml);
            }
        }

        private void fireXXX(final ModelOperation op, final int row) {
            Runnable doWork = new Runnable(){

                @Override
                public void run() {
                    if (op == ModelOperation.DELETE) {
                        MyTableModel.this.fireTableRowsDeleted(row, row);
                    }
                    MyTableModel.this.fireTableDataChanged();
                    MyTableModel.this.printTableModelListeners();
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                System.out.println(" --FIRE: LATER in EventDispatchThread, I'm not EDT (" + Thread.currentThread().getName() + ").");
                SwingUtilities.invokeLater(doWork);
            } else {
                System.out.println(" --FIRE: NOW i must be EDT (" + Thread.currentThread().getName() + ").");
                doWork.run();
            }
        }

        public void addRow(String firstName, String lastName, String sport, Integer numYears, Boolean vegeterian) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(firstName);
            row.add(lastName);
            row.add(sport);
            row.add(numYears);
            row.add(vegeterian);
            this.data.add(row);
            this.fireXXX(ModelOperation.INSERT, -1);
        }

        public void deleteRow(int row) {
            if (this.data.size() == 0) {
                System.out.println("Table is EMPTY.");
                return;
            }
            if (row < 0) {
                this.data.remove(this.data.size() - 1);
            } else {
                this.data.remove(row);
            }
            this.fireXXX(ModelOperation.DELETE, row);
        }

        public MyTableModel() {
            this.init();
        }

        public void init() {
            this.addRow("Kathy2", "Smith", "Snowboarding", 5, false);
            this.addRow("John2", "Doe", "Rowing", 3, true);
            this.addRow("Sue2", "Black", "Knitting", 2, false);
            this.addRow("Jane2", "White", "Speed reading", 20, true);
            this.addRow("Joe2", "Brown", "Pool", 10, false);
            System.out.println("DONE: init()");
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.data.size()) {
                try {
                    this.data.get(row);
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("ERROR: row=" + row + ", col=" + col + ", model.rows=" + (this.data.size() - 1) + ", Exception=" + e);
                    e.printStackTrace();
                }
                return null;
            }
            return this.data.get(row).get(col);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (TableFilterDemo.this.DEBUG) {
                System.out.println("Setting value at " + row + "," + col + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            this.data.get(row).set(col, value);
            this.fireTableCellUpdated(row, col);
            if (TableFilterDemo.this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        private void printDebugData() {
            int numRows = this.getRowCount();
            int numCols = this.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < numCols; ++j) {
                    System.out.print("  " + this.data.get(i).get(j));
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }

    private static enum ModelOperation {
        INSERT,
        UPDATE,
        DELETE;

    }
}

