/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import asemon.test.ExampleTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TableMenu
extends JFrame {
    private static final String PROP_CHANGE_QUANTITY = "CHANGE_QUANTITY";
    private JPanel jContentPane;
    private JScrollPane jScrollPane;
    private JTable jTable;
    private ExampleTableModel tableModel;

    public static void main(String[] args) {
        TableMenu app = new TableMenu();
        app.getTableModel().addItem("Apple", 1.39, 3);
        app.getTableModel().addItem("Pear", 2.19, 2);
        app.getTableModel().addItem("Banana", 1.52, 4);
        app.setVisible(true);
    }

    private static String getClipboardContents(Object requestor) {
        DataFlavor df;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(requestor);
        if (t != null && (df = DataFlavor.stringFlavor) != null) {
            try {
                int n;
                Reader r = df.getReaderForText(t);
                char[] charBuf = new char[512];
                StringBuffer buf = new StringBuffer();
                while ((n = r.read(charBuf, 0, charBuf.length)) > 0) {
                    buf.append(charBuf, 0, n);
                }
                r.close();
                return buf.toString();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (UnsupportedFlavorException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isClipboardContainingText(Object requestor) {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(requestor);
        return t != null && (t.isDataFlavorSupported(DataFlavor.stringFlavor) || t.isDataFlavorSupported(DataFlavor.plainTextFlavor));
    }

    private static void setClipboardContents(String s) {
        StringSelection selection = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    public TableMenu() {
        this.initialize();
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setModel(this.getTableModel());
            this.jTable.addMouseListener(new MouseAdapter(){

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger() && TableMenu.this.jTable.isEnabled()) {
                        Point p = new Point(e.getX(), e.getY());
                        int col = TableMenu.this.jTable.columnAtPoint(p);
                        int row = TableMenu.this.jTable.rowAtPoint(p);
                        int mcol = TableMenu.this.jTable.getColumn(TableMenu.this.jTable.getColumnName(col)).getModelIndex();
                        if (row >= 0 && row < TableMenu.this.jTable.getRowCount()) {
                            TableMenu.this.cancelCellEditing();
                            JPopupMenu contextMenu = TableMenu.this.createContextMenu(row, mcol);
                            if (contextMenu != null && contextMenu.getComponentCount() > 0) {
                                contextMenu.show(TableMenu.this.jTable, p.x, p.y);
                            }
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }
            });
        }
        return this.jTable;
    }

    private void cancelCellEditing() {
        TableCellEditor ce = this.getJTable().getCellEditor();
        if (ce != null) {
            ce.cancelCellEditing();
        }
    }

    private JPopupMenu createContextMenu(final int rowIndex, final int columnIndex) {
        JPopupMenu contextMenu = new JPopupMenu();
        JMenuItem copyMenu = new JMenuItem();
        copyMenu.setText("Copy");
        copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = TableMenu.this.getTableModel().getValueAt(rowIndex, columnIndex);
                TableMenu.setClipboardContents(value == null ? "" : value.toString());
            }
        });
        contextMenu.add(copyMenu);
        JMenuItem pasteMenu = new JMenuItem();
        pasteMenu.setText("Paste");
        if (TableMenu.isClipboardContainingText(this) && this.getTableModel().isCellEditable(rowIndex, columnIndex)) {
            pasteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = TableMenu.getClipboardContents(TableMenu.this);
                    TableMenu.this.getTableModel().setValueAt(value, rowIndex, columnIndex);
                }
            });
        } else {
            pasteMenu.setEnabled(false);
        }
        contextMenu.add(pasteMenu);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                contextMenu.addSeparator();
                ActionListener changer = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem sourceItem = (JMenuItem)e.getSource();
                        Object value = sourceItem.getClientProperty(TableMenu.PROP_CHANGE_QUANTITY);
                        if (value instanceof Integer) {
                            Integer changeValue = (Integer)value;
                            Integer currentValue = (Integer)TableMenu.this.getTableModel().getValueAt(rowIndex, columnIndex);
                            TableMenu.this.getTableModel().setValueAt(new Integer(currentValue + changeValue), rowIndex, columnIndex);
                        }
                    }
                };
                JMenuItem changeItem = new JMenuItem();
                changeItem.setText("+1");
                changeItem.putClientProperty(PROP_CHANGE_QUANTITY, new Integer(1));
                changeItem.addActionListener(changer);
                contextMenu.add(changeItem);
                changeItem = new JMenuItem();
                changeItem.setText("-1");
                changeItem.putClientProperty(PROP_CHANGE_QUANTITY, new Integer(-1));
                changeItem.addActionListener(changer);
                contextMenu.add(changeItem);
                changeItem = new JMenuItem();
                changeItem.setText("+10");
                changeItem.putClientProperty(PROP_CHANGE_QUANTITY, new Integer(10));
                changeItem.addActionListener(changer);
                contextMenu.add(changeItem);
                changeItem = new JMenuItem();
                changeItem.setText("-10");
                changeItem.putClientProperty(PROP_CHANGE_QUANTITY, new Integer(-10));
                changeItem.addActionListener(changer);
                contextMenu.add(changeItem);
                changeItem = null;
                break;
            }
            case 3: {
                break;
            }
        }
        return contextMenu;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private ExampleTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ExampleTableModel();
        }
        return this.tableModel;
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Application");
    }
}

