/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

public class JavaVersion {
    public static final int VERSION_NOTFOUND = -1;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int VERSION_1_7 = 170;
    private static int _major = -1;
    private static int _minor = -1;
    private static int _maint = 0;

    public static int getVersion() {
        String verStr = System.getProperty("java.version");
        if (verStr == null) {
            return -1;
        }
        String[] ver = verStr.split("\\.");
        if (ver.length < 2) {
            return -1;
        }
        try {
            _major = Integer.parseInt(ver[0]);
            _minor = Integer.parseInt(ver[1]);
            if (ver.length >= 3) {
                String[] maint_bugfix_arr = ver[2].split("_");
                _maint = Integer.parseInt(maint_bugfix_arr[0]);
            }
            return _major * 100 + _minor * 10 + _maint;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public static int getMajor() {
        if (_major == -1 && _minor == -1) {
            JavaVersion.getVersion();
        }
        return _major;
    }

    public static int getMinor() {
        if (_major == -1 && _minor == -1) {
            JavaVersion.getVersion();
        }
        return _minor;
    }

    public static int getMaint() {
        if (_major == -1 && _minor == -1) {
            JavaVersion.getVersion();
        }
        return _maint;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("");
            System.out.println("Usage: JavaVersion verInt");
            System.out.println("       verInt: should be the main java version you check for.");
            System.out.println("               - 4 for Java 1.4");
            System.out.println("               - 5 for Java 1.5");
            System.out.println("               - 6 for Java 1.6");
            System.out.println("               - 7 for Java 1.7");
            System.out.println("");
            System.exit(1);
        }
        int checkForVersion = Integer.parseInt(args[0]);
        int javaVer = JavaVersion.getMinor();
        if (javaVer >= checkForVersion) {
            System.exit(0);
        } else {
            System.out.println("");
            System.out.println("===============================================================");
            System.out.println(" This application needs a runtime JVM 1." + checkForVersion + " or higher.");
            System.out.println(" Current 'java.version' = " + System.getProperty("java.version"));
            System.out.println(" which is parsed into the Java Version Number: " + JavaVersion.getMinor());
            System.out.println("---------------------------------------------------------------");
            System.out.println("");
            System.exit(1);
        }
    }
}

