/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import org.apache.log4j.Logger;

public class PlatformUtils {
    private static Logger _logger = Logger.getLogger(PlatformUtils.class);
    public static final int Platform_WIN = 0;
    public static final int Platform_LINUX = 1;
    public static final int Platform_MAC_OS = 2;
    public static final int Platform_SOLARIS = 3;
    public static final int Platform_OTHER = 4;
    public static final int Desktop_WIN = 10;
    public static final int Desktop_KDE = 11;
    public static final int Desktop_GNOME = 12;
    public static final int Desktop_MAC_OS = 13;
    public static final int Desktop_OTHER = 14;
    public static final int Browser_IE = 20;
    public static final int Browser_FIREFOX = 21;

    public static int getCurrentPlattform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            _logger.trace((Object)("Detected Windows platform '" + osName + "'."));
            return 0;
        }
        if (osName.startsWith("Linux")) {
            _logger.trace((Object)("Detected Linux platform '" + osName + "'."));
            return 1;
        }
        if (osName.startsWith("MacOS")) {
            _logger.trace((Object)("Detected Mac OS platform '" + osName + "'."));
            return 2;
        }
        if (osName.startsWith("Solaris")) {
            _logger.trace((Object)("Detected Solaris platform '" + osName + "'."));
            return 3;
        }
        return 4;
    }

    public static int getDefaultBrowser() {
        if (PlatformUtils.getCurrentPlattform() == 0) {
            _logger.trace((Object)"Detected Browser is InternetExplorer.");
            return 20;
        }
        _logger.trace((Object)"Detected Browser Firefox. (or possible just: Fallback?)");
        return 21;
    }

    public static int getCurrentDesktop() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            _logger.trace((Object)"Detected Windows desktop.");
            return 10;
        }
        if (osName.startsWith("MacOS")) {
            _logger.trace((Object)"Detected Mac OS desktop.");
            return 13;
        }
        if (osName.startsWith("Linux") || osName.contains("Unix") || osName.startsWith("Solaris")) {
            if (PlatformUtils.isKDE()) {
                _logger.trace((Object)"Detected KDE desktop.");
                return 11;
            }
            if (PlatformUtils.isGnome()) {
                _logger.trace((Object)"Detected Gnome desktop.");
                return 12;
            }
        }
        _logger.trace((Object)"Detected Unknown desktop (fallback).");
        return 14;
    }

    private static boolean isGnome() {
        return System.getenv("GNOME_DESKTOP_SESSION_ID") != null;
    }

    private static boolean isKDE() {
        return System.getenv("KDE_SESSION_VERSION") != null;
    }
}

