/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StringUtil {
    private static Logger _logger = Logger.getLogger(StringUtil.class);

    public static <T> String toCommaStr(Collection<T> list) {
        return StringUtil.toCommaStr(list, ", ");
    }

    public static <T> String toCommaStr(Collection<T> list, String entrySep) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T val = it.next();
            sb.append(val);
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static <K, V> String toCommaStr(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ");
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", true, false);
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, true, false);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", false, true);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, false, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStr(map, keyValSep, entrySep, true, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<K> it = map.keySet().iterator();
        while (it.hasNext()) {
            K key = it.next();
            V val = map.get(key);
            if (useKey) {
                sb.append(key);
            }
            if (useKey && useValue) {
                sb.append(keyValSep);
            }
            if (useValue) {
                sb.append(val);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ");
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", true, false);
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, true, false);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", false, true);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, false, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, keyValSep, entrySep, true, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            List<String> list = map.get(key);
            Iterator<String> listIt = list.iterator();
            while (listIt.hasNext()) {
                String listVal = listIt.next();
                if (useKey) {
                    sb.append(key);
                }
                if (useKey && useValue) {
                    sb.append(keyValSep);
                }
                if (useValue) {
                    sb.append(listVal);
                }
                if (!listIt.hasNext()) continue;
                sb.append(entrySep);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static List<String> parseCommaStrToList(String str) {
        String[] sa;
        ArrayList<String> list = new ArrayList<String>();
        for (String se : sa = str.split(",")) {
            list.add(se.trim());
        }
        return list;
    }

    public static Map<String, String> parseCommaStrToMap(String source) {
        return StringUtil.parseCommaStrToMap(source, "=", ",");
    }

    public static Map<String, String> parseCommaStrToMap(String source, String keyValSep, String entrySep) {
        if (source == null) {
            return new LinkedHashMap<String, String>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String val;
            String key;
            String oldVal;
            String keyVal = parser.next().trim();
            String[] sa = StringUtil.split(keyValSep, keyVal);
            if (sa.length != 2 || (oldVal = map.put(key = sa[0], val = sa[1])) == null) continue;
            _logger.warn((Object)("Found an already existing value for the key '" + key + "'. The existing value '" + oldVal + "' is replaced with the new value '" + val + "'."));
        }
        return map;
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source) {
        return StringUtil.parseCommaStrToMultiMap(source, "=", ",");
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source, String keyValSep, String entrySep) {
        if (source == null) {
            return new LinkedHashMap<String, List<String>>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String keyVal = parser.next().trim();
            String[] sa = StringUtil.split(keyValSep, keyVal);
            if (sa.length != 2) continue;
            String key = sa[0];
            String val = sa[1];
            List<String> list = map.get(key);
            if (list == null) {
                list = new LinkedList<String>();
            }
            list.add(val);
            map.put(key, list);
        }
        return map;
    }

    public static String toCommaStr(Object[] oa) {
        return StringUtil.toCommaStr(oa, ", ");
    }

    public static String toCommaStr(Object[] oa, String sep) {
        StringBuffer sb = new StringBuffer();
        if (oa == null) {
            return "";
        }
        for (int i = 0; i < oa.length; ++i) {
            sb.append(oa[i]);
            if (i >= oa.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String[] commaStrToArray(String str) {
        if (str == null) {
            return new String[0];
        }
        String[] sa = str.split(",");
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
        }
        return sa;
    }

    public static boolean arrayContains(Object[] oa, Object o) {
        if (oa == null) {
            return false;
        }
        for (int i = 0; i < oa.length; ++i) {
            if (!oa[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static int count(String occurs, String s) {
        int count = 0;
        int current = -1;
        int next = 0;
        next = s.indexOf(occurs);
        while (next > -1) {
            ++count;
            current = next;
            next = s.indexOf(occurs, current + 1);
        }
        return count;
    }

    public static String[] split(String splitAt, String s) {
        int noOfLines = StringUtil.count(splitAt, s) + 1;
        String[] stringArray = new String[noOfLines];
        String remaining = s;
        int splitLen = splitAt.length();
        for (int i = 0; i < noOfLines - 1; ++i) {
            int pos = remaining.indexOf(splitAt);
            stringArray[i] = remaining.substring(0, pos);
            remaining = remaining.substring(pos + splitLen, remaining.length());
        }
        stringArray[noOfLines - 1] = remaining;
        return stringArray;
    }

    public static String word(String str, int number) {
        String[] stra = str.split("[ \t\n\f\r]");
        if (stra.length < number) {
            return null;
        }
        return stra[number];
    }

    public static String lastWord(String str) {
        String[] stra = str.split("[ \t\n\f\r]");
        return stra[stra.length - 1];
    }

    public static String left(String str, int num) {
        return StringUtil.left(str, num, true);
    }

    public static String left(String str, int num, boolean allowGrow) {
        if (allowGrow && str.length() > num) {
            num = str.length();
        }
        int maxPadSize = num - str.length();
        String space = "                                                                                                                                                                                                                                                               ";
        while (space.length() < maxPadSize) {
            space = space + "                                                                                                                                                                                                                                                               ";
        }
        return (str + space).substring(0, num);
    }

    public static String right(String str, int num) {
        int len = num - str.length();
        if (len < 0) {
            len = 0;
        }
        String space = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ";
        return (space.substring(0, len) + str).substring(0, num);
    }

    public static String envVariableSubstitution(String val) {
        Pattern compiledRegex = Pattern.compile("\\$\\{.*\\}");
        while (compiledRegex.matcher(val).find()) {
            String envName;
            String envVal;
            block4: {
                envVal = null;
                envName = val.substring(val.indexOf("${") + 2, val.indexOf("}"));
                try {
                    envVal = System.getenv(envName);
                }
                catch (Throwable t) {
                    envVal = System.getProperty(envName);
                    if (envVal != null) break block4;
                    System.out.println("System.getenv(): Is not supported on this platform or version of Java. Please pass '-D" + envName + "=value' when starting the JVM.");
                }
            }
            if (envVal == null) {
                System.out.println("The Environment variable '" + envName + "' cant be found, replacing it with an empty string ''.");
                envVal = "";
            }
            envVal = envVal.replace('\\', '/');
            val = val.replaceFirst("\\$\\{" + envName + "\\}", envVal);
        }
        return val;
    }

    public static String replicate(String str, int size) {
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String fill(String str, int fill) {
        if (str.length() >= fill) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() < fill) {
            sb.append("                                                           ");
        }
        return sb.substring(0, fill);
    }

    public static String stripHtml(String in) {
        if (in == null) {
            return null;
        }
        return in.replaceAll("\\<.*?\\>", "");
    }

    public static String makeApproxLineBreak(String str, int rowLength, int wordCountHysteresis, String lineBreak) {
        if (str.length() <= rowLength) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] ca = str.toCharArray();
        int c = 0;
        int car = 0;
        while (c < ca.length) {
            sb.append(ca[c]);
            car = ca[c] == '\n' ? 0 : ++car;
            ++c;
            if (car < rowLength) continue;
            int nextSpacePos = str.substring(c).trim().indexOf(32);
            if (nextSpacePos > 0 && nextSpacePos < Math.max(15, rowLength / 4)) {
                while (c < ca.length && ca[c] != ' ') {
                    sb.append(ca[c]);
                    ++c;
                }
                if (str.substring(c).split("\\s", wordCountHysteresis + 1).length <= wordCountHysteresis) {
                    while (c < ca.length) {
                        sb.append(ca[c]);
                        ++c;
                    }
                } else {
                    sb.append(lineBreak);
                }
            } else {
                sb.append(lineBreak);
            }
            car = 0;
        }
        return sb.toString();
    }

    public static String getHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isNullOrBlank(String str) {
        if (str == null) {
            return true;
        }
        if (str.equals("")) {
            return true;
        }
        return str.trim().equals("");
    }

    public static void main(String[] args) {
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("aaa=11\\,11,bbbbb=2222, cccc=3333") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111,bbbbb=2222, cccc=3333}") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111, bbbbb=2222, cccc=3333,}") + "|.");
        String t1Str = "{aaa=1111, bbb=2222, bbb=3333,}";
        Map<String, List<String>> t1Map = StringUtil.parseCommaStrToMultiMap(t1Str);
        System.out.println("MMAP=|" + t1Map + "|.");
        System.out.println("MMAP.toCommaStrMultiMap=|" + StringUtil.toCommaStrMultiMap(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useKey)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", true, false) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useVal)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", false, true) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapKey=|" + StringUtil.toCommaStrMultiMapKey(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapVal=|" + StringUtil.toCommaStrMultiMapVal(t1Map) + "|.");
        System.exit(0);
        System.out.println("TEST: StringUtil BEGIN.");
        if (!StringUtil.lastWord(" 1 2 3 ").equals("3")) {
            System.out.println("FAILED:  test-1: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord("").equals("")) {
            System.out.println("FAILED:  test-2: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2\t 3 ").equals("3")) {
            System.out.println("FAILED:  test-3: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2 \n3").equals("3")) {
            System.out.println("FAILED:  test-4: StringUtil.lastWord()");
        }
        if (!StringUtil.left("123", 5).equals("123  ")) {
            System.out.println("FAILED:  test-1: StringUtil.left()");
        }
        if (!StringUtil.right("  123", 5).equals("  123")) {
            System.out.println("FAILED:  test-1: StringUtil.right()");
        }
        if (StringUtil.fill("123", 1).length() != 3) {
            System.out.println("FAILED:  test-1: StringUtil.fill()");
        }
        if (StringUtil.fill("123", 50).length() != 50) {
            System.out.println("FAILED:  test-2: StringUtil.fill(\"123\", 50)");
        }
        if (StringUtil.fill("123", 5000).length() != 5000) {
            System.out.println("FAILED:  test-3: StringUtil.fill(\"123\", 5000)");
        }
        if (StringUtil.stripHtml("123<html>-<b>B</b>.<xml xx=xxx, z=z>").indexOf("<") != -1) {
            System.out.println("FAILED:  test-1: StringUtil.stripHtml()");
        }
        System.out.println("TEST: StringUtil END.");
    }
}

