/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import asemon.utils.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

public class SwingUtils {
    private static Logger _logger = Logger.getLogger(SwingUtils.class);

    public static void printComponents(JComponent c, String text) {
        Component[] comp = c.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            System.out.println(text + ".comp[" + i + "].type=" + comp[i].getClass().getName());
        }
    }

    public static void printParents(Component c, String text) {
        int i = 0;
        while (c != null) {
            Container parent = c.getParent();
            if (parent != null) {
                System.out.println(text + " .depth[" + i + "].parentClassName=" + parent.getClass().getName());
            }
            c = parent;
            ++i;
        }
    }

    public static void showInfoMessage(String title, String msg) {
        SwingUtils.showMessage(null, Level.INFO, title, msg, null);
    }

    public static void showInfoMessage(Component owner, String title, String msg) {
        SwingUtils.showMessage(owner, Level.INFO, title, msg, null);
    }

    public static void showWarnMessage(String title, String msg, Throwable exception) {
        SwingUtils.showMessage(null, Level.WARNING, title, msg, exception);
    }

    public static void showWarnMessage(Component owner, String title, String msg, Throwable exception) {
        SwingUtils.showMessage(owner, Level.WARNING, title, msg, exception);
    }

    public static void showErrorMessage(String title, String msg, Throwable exception) {
        SwingUtils.showMessage(null, Level.SEVERE, title, msg, exception);
    }

    public static void showErrorMessage(Component owner, String title, String msg, Throwable exception) {
        SwingUtils.showMessage(owner, Level.SEVERE, title, msg, exception);
    }

    public static void showMessage(Component owner, Level errorLevel, String title, String msg, Throwable exception) {
        if (owner != null && !(owner instanceof JFrame)) {
            owner = JOptionPane.getFrameForComponent(owner);
        }
        String category = null;
        category = errorLevel.equals(Level.INFO) ? "Information" : (errorLevel.equals(Level.WARNING) ? "Warning" : "Error");
        JXErrorPane.setDefaultLocale((Locale)Locale.ENGLISH);
        JXErrorPane errorPane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(title, msg, null, category, exception, errorLevel, null);
        errorPane.setErrorInfo(info);
        JDialog dialog = JXErrorPane.createDialog((Component)owner, (JXErrorPane)errorPane);
        dialog.pack();
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    public static void centerWindow(Component frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void setLocationNearTopLeft(Component parent, Component child) {
        SwingUtils.setLocationNearTopLeft(parent, child, 20, 40);
    }

    public static void setLocationNearTopLeft(Component parent, Component child, int x, int y) {
        if (parent != null) {
            Point p = parent.getLocationOnScreen();
            p.x += x;
            p.y += y;
            child.setLocation(p);
        } else {
            SwingUtils.centerWindow(child);
        }
    }

    public static JButton makeToolbarButton(Class<?> clazz, String imageName, String actionCommand, ActionListener al, String toolTipText, String altText) {
        String imgLocation = "images/" + imageName;
        URL imageURL = clazz.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        if (al != null) {
            button.addActionListener(al);
        }
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            _logger.error((Object)("Toolbar Resource not found '" + imgLocation + "', url='" + imageURL + "'."));
        }
        return button;
    }

    public static ImageIcon readImageIcon(Class<?> clazz, String filename) {
        URL url = clazz.getResource(filename);
        if (url == null) {
            _logger.error((Object)("Cant find the resource for class='" + clazz + "', filename='" + filename + "'."));
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
    }

    public static JPanel createPanel(String title, boolean createBorder) {
        JPanel panel = new JPanel();
        if (createBorder) {
            TitledBorder border = BorderFactory.createTitledBorder(title);
            panel.setBorder(border);
        }
        return panel;
    }

    public static void calcColumnWidths(JTable table) {
        SwingUtils.calcColumnWidths(table, 0, false);
    }

    public static void calcColumnWidths(JTable table, int onlyXLastRows, boolean onlyIncreaseWith) {
        JTableHeader header = table.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = null;
        if (header != null) {
            defaultHeaderRenderer = header.getDefaultRenderer();
        }
        TableColumnModel columns = table.getColumnModel();
        TableModel data = table.getModel();
        int margin = columns.getColumnMargin();
        int totalRowCount = data.getRowCount();
        int stopAtRow = 0;
        if (onlyXLastRows > 0) {
            stopAtRow = Math.max(stopAtRow, totalRowCount - onlyXLastRows);
        }
        int totalWidth = 0;
        for (int i = columns.getColumnCount() - 1; i >= 0; --i) {
            TableColumn column = columns.getColumn(i);
            int columnIndex = column.getModelIndex();
            int width = -1;
            TableCellRenderer h = column.getHeaderRenderer();
            if (h == null) {
                h = defaultHeaderRenderer;
            }
            Component columnHeader = null;
            if (h != null) {
                columnHeader = h.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, -1, i);
                width = columnHeader.getPreferredSize().width;
            }
            for (int row = totalRowCount - 1; row >= stopAtRow; --row) {
                TableCellRenderer r = table.getCellRenderer(row, i);
                Component c = r.getTableCellRendererComponent(table, data.getValueAt(row, columnIndex), false, false, row, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            if (width >= 0) {
                column.setPreferredWidth(width + margin);
            }
            totalWidth += column.getPreferredWidth();
        }
    }

    public static void setCaretToLineNumber(JTextArea text, int linenumber) {
        String s;
        text.setCaretPosition(0);
        if (linenumber < 2) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int count = 0;
        int countRowAfter = 0;
        while (st.hasMoreTokens() & linenumber > 1) {
            s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            --linenumber;
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            countRowAfter = count + s.length();
        }
        text.setCaretPosition(count);
        text.select(count, countRowAfter);
    }

    public static boolean isEventQueueThread() {
        String threadName = Thread.currentThread().getName();
        return threadName.startsWith("AWT-EventQueue");
    }

    public static Color parseColor(String colorStr, Color defaultColor) {
        try {
            return SwingUtils.parseColor(colorStr);
        }
        catch (ParseException e) {
            _logger.debug((Object)e.toString());
            return defaultColor;
        }
    }

    public static Color parseColor(String colorStr) throws ParseException {
        if (colorStr == null) {
            throw new ParseException("Color string is null.", -1);
        }
        if ((colorStr = colorStr.trim()).equals("")) {
            throw new ParseException("Color string is empty.", -1);
        }
        try {
            int colorInt = Integer.parseInt(colorStr);
            return new Color(colorInt);
        }
        catch (NumberFormatException ignore) {
            if (colorStr.indexOf(".") >= 0 || colorStr.indexOf(",") >= 0) {
                String[] sa = null;
                int[] ia = new int[4];
                sa = colorStr.indexOf(".") >= 0 ? colorStr.split("\\.") : colorStr.split(",");
                if (sa.length != 3 && sa.length != 4) {
                    throw new ParseException("Color string '" + colorStr + "' does not have two or three divider characters of '.' or ','", -1);
                }
                ia[3] = 255;
                for (int i = 0; i < sa.length; ++i) {
                    sa[i] = sa[i].trim();
                    try {
                        ia[i] = Integer.parseInt(sa[i]);
                    }
                    catch (NumberFormatException ignore2) {
                        throw new ParseException("Color string '" + colorStr + "' has a non number in the " + (i + 1) + " field.", i);
                    }
                    if (ia[i] <= 255) continue;
                    throw new ParseException("Color string '" + colorStr + "' has a 'to big' number in the " + (i + 1) + " field. max is 255.", i);
                }
                return new Color(ia[0], ia[1], ia[2], ia[3]);
            }
            if (colorStr.startsWith("#") || colorStr.startsWith("0x")) {
                if ((colorStr = colorStr.startsWith("#") ? colorStr.substring(1) : colorStr.substring(2)).length() != 6 && colorStr.length() != 8) {
                    throw new ParseException("Color string '" + colorStr + "' has to be of the length 6 (or 8 if you want to have alpha).", -1);
                }
                try {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int a = 255;
                    r = Integer.parseInt(colorStr.substring(0, 2), 16);
                    g = Integer.parseInt(colorStr.substring(2, 4), 16);
                    b = Integer.parseInt(colorStr.substring(4, 6), 16);
                    if (colorStr.length() > 6) {
                        a = Integer.parseInt(colorStr.substring(6, 8), 16);
                    }
                    return new Color(r, g, b, a);
                }
                catch (NumberFormatException ignore3) {
                    throw new ParseException("Color string '" + colorStr + "' has a non number in the field.", -1);
                }
            }
            if (colorStr.equalsIgnoreCase("WHITE")) {
                return Color.WHITE;
            }
            if (colorStr.equalsIgnoreCase("LIGHT_GRAY")) {
                return Color.LIGHT_GRAY;
            }
            if (colorStr.equalsIgnoreCase("GRAY")) {
                return Color.GRAY;
            }
            if (colorStr.equalsIgnoreCase("DARK_GRAY")) {
                return Color.DARK_GRAY;
            }
            if (colorStr.equalsIgnoreCase("BLACK")) {
                return Color.BLACK;
            }
            if (colorStr.equalsIgnoreCase("RED")) {
                return Color.RED;
            }
            if (colorStr.equalsIgnoreCase("PINK")) {
                return Color.PINK;
            }
            if (colorStr.equalsIgnoreCase("ORANGE")) {
                return Color.ORANGE;
            }
            if (colorStr.equalsIgnoreCase("YELLOW")) {
                return Color.YELLOW;
            }
            if (colorStr.equalsIgnoreCase("GREEN")) {
                return Color.GREEN;
            }
            if (colorStr.equalsIgnoreCase("MAGENTA")) {
                return Color.MAGENTA;
            }
            if (colorStr.equalsIgnoreCase("CYAN")) {
                return Color.CYAN;
            }
            if (colorStr.equalsIgnoreCase("BLUE")) {
                return Color.BLUE;
            }
            throw new ParseException("Color string '" + colorStr + "' can't be parsed. I tried 'int' & 'r,g,b[,a]|r.g.b[.a]' & '#rrggbb[aa]|0xrrggbb[aa]' & 'java colors' (out of parser implementations).", -1);
        }
    }

    public static String tableToString(TableModel model, int justRowNumber) {
        return SwingUtils.tableToString(model, false, null, null, justRowNumber, justRowNumber + 1);
    }

    public static String tableToString(TableModel model) {
        return SwingUtils.tableToString(model, false, null, null, -1, -1);
    }

    public static String tableToString(TableModel model, boolean stripHtml, String[] prefixColName, Object[] prefixColData) {
        return SwingUtils.tableToString(model, stripHtml, prefixColName, prefixColData, -1, -1);
    }

    public static String tableToString(TableModel model, boolean stripHtml, String[] prefixColName, Object[] prefixColData, int firstRow, int lastRow) {
        int c;
        int c2;
        String colSepOther = "+";
        String colSepData = "|";
        String lineSpace = "-";
        String newLine = "\n";
        ArrayList<String> tableHead = new ArrayList<String>();
        ArrayList tableData = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean doPrefix = false;
        if (prefixColName != null && prefixColData != null) {
            if (prefixColName.length != prefixColData.length) {
                throw new IllegalArgumentException("tableToString(): prefixColName.length=" + prefixColName.length + " is NOT equal prefixColData.length=" + prefixColData.length);
            }
            doPrefix = true;
        }
        int cols = model.getColumnCount();
        if (firstRow < 0) {
            firstRow = 0;
        }
        if (lastRow < 0) {
            lastRow = model.getRowCount();
        }
        int copiedRows = 0;
        if (doPrefix) {
            for (c2 = 0; c2 < prefixColName.length; ++c2) {
                tableHead.add(prefixColName[c2]);
            }
        }
        for (c2 = 0; c2 < cols; ++c2) {
            tableHead.add(model.getColumnName(c2));
        }
        for (int r = firstRow; r < lastRow; ++r) {
            int c3;
            ArrayList<Object> row = new ArrayList<Object>();
            if (doPrefix) {
                for (c3 = 0; c3 < prefixColData.length; ++c3) {
                    row.add(prefixColData[c3]);
                }
            }
            for (c3 = 0; c3 < cols; ++c3) {
                String str;
                Object obj = model.getValueAt(r, c3);
                if (obj != null && obj instanceof String && (str = (String)obj).endsWith("\n")) {
                    obj = str.subSequence(0, str.length() - 1);
                }
                row.add(obj);
            }
            tableData.add(row);
            ++copiedRows;
        }
        if (doPrefix) {
            cols += prefixColName.length;
        }
        int[] colLength = new int[cols];
        for (c = 0; c < cols; ++c) {
            int maxLen = 0;
            String cellName = (String)tableHead.get(c);
            maxLen = Math.max(maxLen, cellName.length());
            for (int r = 0; r < copiedRows; ++r) {
                Object cellObj = ((List)tableData.get(r)).get(c);
                String cellStr = cellObj == null ? "" : cellObj.toString();
                maxLen = Math.max(maxLen, cellStr.length());
            }
            colLength[c] = maxLen;
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (c = 0; c < cols; ++c) {
            String cellName = (String)tableHead.get(c);
            String data = StringUtil.fill(cellName, colLength[c]);
            sb.append(colSepData).append(data);
        }
        sb.append(colSepData).append(newLine);
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (int r = 0; r < copiedRows; ++r) {
            for (int c4 = 0; c4 < cols; ++c4) {
                String cellStr;
                Object cellObj = ((List)tableData.get(r)).get(c4);
                String string = cellStr = cellObj == null ? "" : cellObj.toString();
                if (stripHtml) {
                    cellStr = StringUtil.stripHtml(cellStr);
                }
                String data = StringUtil.fill(cellStr, colLength[c4]);
                sb.append(colSepData).append(data);
            }
            sb.append(colSepData).append(newLine);
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        sb.append("Rows ").append(copiedRows).append(newLine);
        return sb.toString();
    }

    public static boolean isDataChanged(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    public static boolean isUpdate(TableModelEvent e) {
        if (SwingUtils.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    public static boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public static DefaultTableModel copyTableModel(TableModel copyFrom) {
        if (copyFrom == null) {
            throw new RuntimeException("copyTableModel(), Input parameter copyFrom can't be null.");
        }
        DefaultTableModel newModel = new DefaultTableModel();
        newModel.setRowCount(copyFrom.getRowCount());
        newModel.setColumnCount(copyFrom.getColumnCount());
        Vector<String> colHeader = new Vector<String>();
        for (int c = 0; c < copyFrom.getColumnCount(); ++c) {
            colHeader.add(copyFrom.getColumnName(c));
        }
        newModel.setColumnIdentifiers(colHeader);
        for (int r = 0; r < copyFrom.getRowCount(); ++r) {
            for (int c = 0; c < copyFrom.getColumnCount(); ++c) {
                newModel.setValueAt(copyFrom.getValueAt(r, c), r, c);
            }
        }
        return newModel;
    }
}

