/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import java.text.ParseException;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class SybVersion
implements Comparable<SybVersion> {
    private int _major = 0;
    private int _minor = 0;
    private int _maint = 0;
    private int _esd = 0;
    private int _ebf = 0;

    public SybVersion(int major, int minor, int maintenance, int esd) {
        this._major = major;
        this._minor = minor;
        this._maint = maintenance;
        this._esd = esd;
    }

    public SybVersion(int majorMinorMaintEsd) {
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getMaintenance() {
        return this._maint;
    }

    public int getEsd() {
        return this._esd;
    }

    public int getEbf() {
        return this._ebf;
    }

    public int toInt(int major, int minor, int maint, int esd) {
        if (major > 99) {
            major = 99;
        }
        if (minor > 99) {
            minor = 99;
        }
        if (maint > 99) {
            maint = 99;
        }
        if (esd > 99) {
            esd = 99;
        }
        return major * 1000000 + minor * 10000 + maint * 100 + esd;
    }

    public int toInt() {
        return this.toInt(this._major, this._minor, this._maint, this._esd);
    }

    public int toSmallInt() {
        int major = this._major;
        int minor = this._minor;
        int maint = this._maint;
        int esd = this._esd;
        if (major > 99) {
            major = 99;
        }
        if (minor > 9) {
            minor = 9;
        }
        if (maint > 9) {
            maint = 9;
        }
        if (esd > 9) {
            esd = 9;
        }
        return major * 1000 + minor * 100 + maint * 10 + esd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._major).append(".").append(this._minor);
        if (this._maint > 0) {
            sb.append(".").append(this._maint);
        }
        if (this._esd > 0) {
            sb.append(" ESD#").append(this._esd);
        }
        if (this._ebf > 0) {
            sb.append(" (EBF ").append(this._ebf).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SybVersion) {
            return this.compareTo((SybVersion)obj) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(SybVersion sybVersion) {
        int paramVerNum;
        int thisVerNum = this.toInt();
        if (thisVerNum == (paramVerNum = sybVersion.toInt())) {
            return 0;
        }
        if (thisVerNum < paramVerNum) {
            return -1;
        }
        return 1;
    }

    public boolean gte(int major, int minor, int maint, int esd) {
        return this.toInt() >= this.toInt(major, minor, maint, esd);
    }

    public boolean greaterThanOrEqual(int major, int minor, int maint, int esd) {
        return this.gte(major, minor, maint, esd);
    }

    public boolean gt(int major, int minor, int maint, int esd) {
        return this.toInt() > this.toInt(major, minor, maint, esd);
    }

    public boolean greaterThan(int major, int minor, int maint, int esd) {
        return this.gt(major, minor, maint, esd);
    }

    public boolean lte(int major, int minor, int maint, int esd) {
        return this.toInt() <= this.toInt(major, minor, maint, esd);
    }

    public boolean lessThanOrEqual(int major, int minor, int maint, int esd) {
        return this.lte(major, minor, maint, esd);
    }

    public boolean lt(int major, int minor, int maint, int esd) {
        return this.toInt() < this.toInt(major, minor, maint, esd);
    }

    public boolean lessThan(int major, int minor, int maint, int esd) {
        return this.lt(major, minor, maint, esd);
    }

    public boolean between(int lowMajor, int lowMinor, int lowMaint, int lowEsd, int highMajor, int highMinor, int highMaint, int highEsd) {
        return this.between(lowMajor, lowMinor, lowMaint, lowEsd, highMajor, highMinor, highMaint, highEsd, Between.GTE_LTE);
    }

    public boolean between(int lowMajor, int lowMinor, int lowMaint, int lowEsd, int highMajor, int highMinor, int highMaint, int highEsd, Between type) {
        if (type == Between.GTE_LTE) {
            return this.gte(lowMajor, lowMinor, lowMaint, lowEsd) && this.lte(highMajor, highMinor, highMaint, highEsd);
        }
        if (type == Between.GTE_LT) {
            return this.gte(lowMajor, lowMinor, lowMaint, lowEsd) && this.lt(highMajor, highMinor, highMaint, highEsd);
        }
        if (type == Between.GT_LTE) {
            return this.gt(lowMajor, lowMinor, lowMaint, lowEsd) && this.lte(highMajor, highMinor, highMaint, highEsd);
        }
        if (type == Between.GT_LT) {
            return this.gt(lowMajor, lowMinor, lowMaint, lowEsd) && this.lt(highMajor, highMinor, highMaint, highEsd);
        }
        throw new RuntimeException("Unknown type of Between type " + (Object)((Object)type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SybVersion parse(String sybVersionString) throws ParseException {
        SybVersion sybVersion = new SybVersion(0, 0, 0, 0);
        String[] sybVersionParts = sybVersionString.split("/");
        if (sybVersionParts.length > 0) {
            String sybVersionNumberStr = null;
            String sybEsdStr = null;
            String sybEbfStr = null;
            for (int i = 0; i < sybVersionParts.length; ++i) {
                if (sybVersionParts[i].matches("^[0-9][0-9][.][0-9].*") && sybVersionNumberStr == null) {
                    sybVersionNumberStr = sybVersionParts[i];
                }
                if (sybVersionParts[i].indexOf("ESD#") >= 0 && sybEsdStr == null) {
                    sybEsdStr = sybVersionParts[i];
                }
                if (sybVersionParts[i].indexOf("EBF ") < 0 || sybEbfStr != null) continue;
                sybEbfStr = sybVersionParts[i];
            }
            if (sybVersionNumberStr == null) {
                String msg = "There Sybase version string seems to be faulty, cant find any '##.#' in the version number string '" + sybVersionString + "'.";
                throw new ParseException(msg, 0);
            }
            String[] sybVersionNumberParts = sybVersionNumberStr.split("\\.");
            if (sybVersionNumberParts.length > 1) {
                try {
                    int end;
                    int start;
                    String versionPart = null;
                    if (sybVersionNumberParts.length >= 1) {
                        versionPart = sybVersionNumberParts[0].trim();
                        sybVersion._major = Integer.parseInt(versionPart);
                    }
                    if (sybVersionNumberParts.length >= 2) {
                        versionPart = sybVersionNumberParts[1].trim();
                        sybVersion._minor = Integer.parseInt(versionPart);
                    }
                    if (sybVersionNumberParts.length >= 3) {
                        versionPart = sybVersionNumberParts[2].trim();
                        sybVersion._maint = Integer.parseInt(versionPart);
                    }
                    if (sybVersionNumberParts.length >= 4) {
                        versionPart = sybVersionNumberParts[3].trim();
                        sybVersion._esd = Integer.parseInt(versionPart);
                    } else if (sybEsdStr != null) {
                        start = sybEsdStr.indexOf("ESD#");
                        if (start >= 0) {
                            start += "ESD#".length();
                        }
                        if ((end = sybEsdStr.indexOf(" ", start)) == -1) {
                            end = sybEsdStr.indexOf(".", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.indexOf(",", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.indexOf(":", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.indexOf(";", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.indexOf("-", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.indexOf("_", start);
                        }
                        if (end == -1) {
                            end = sybEsdStr.length();
                        }
                        if (start != -1) {
                            try {
                                versionPart = sybEsdStr.trim().substring(start, end);
                                sybVersion._esd = Integer.parseInt(versionPart);
                            }
                            catch (RuntimeException e) {
                                String msg = "Problems converting some part(s) of the ESD# in the version string '" + sybVersionNumberStr + "' into a number. ESD# string was '" + versionPart + "'.";
                                throw new ParseException(msg, 0);
                            }
                        }
                    }
                    if (sybEbfStr == null) return sybVersion;
                    start = sybEbfStr.indexOf("EBF ");
                    if (start >= 0) {
                        start += "EBF ".length();
                    }
                    if ((end = sybEbfStr.indexOf(" ", start)) == -1) {
                        end = sybEbfStr.length();
                    }
                    if (start == -1) return sybVersion;
                    try {
                        versionPart = sybEbfStr.trim().substring(start, end);
                        sybVersion._ebf = Integer.parseInt(versionPart);
                        return sybVersion;
                    }
                    catch (RuntimeException e) {
                        String msg = "Problems converting some part(s) of the EBF in the version string '" + sybVersionNumberStr + "' into a number. EBF string was '" + versionPart + "'..";
                        throw new ParseException(msg, 0);
                    }
                }
                catch (RuntimeException e) {
                    String msg = "Problems converting some part(s) of the version string '" + sybVersionNumberStr + "' into a number. The version number could be set to " + sybVersion;
                    throw new ParseException(msg, 0);
                }
            }
            String msg = "There Sybase version string seems to be faulty, cant find any '.' in the version number subsection '" + sybVersionNumberStr + "'.";
            throw new ParseException(msg, 0);
        }
        String msg = "There Sybase version string seems to be faulty, cant find any / in the string '" + sybVersionString + "'.";
        throw new ParseException(msg, 0);
    }

    private static void test(String versionStr) {
        System.out.println("==================================================================");
        System.out.println("Input str           '" + versionStr + "'.");
        SybVersion sybVer = null;
        try {
            sybVer = SybVersion.parse(versionStr);
            System.out.println("SybVer.toString()   '" + sybVer.toString() + "'.");
            System.out.println("SybVer.toInt()      '" + sybVer.toInt() + "'.");
            System.out.println("SybVer.toSmallInt() '" + sybVer.toSmallInt() + "'.");
            System.out.println("compareTo(15.5.0.0) '" + sybVer.compareTo(new SybVersion(15, 5, 0, 0)) + "'.");
            System.out.println("is above 15.5.0.0   '" + (sybVer.compareTo(new SybVersion(15, 5, 0, 0)) > 0) + "'.");
            System.out.println("is    >= 15.5.0.0   '" + (sybVer.compareTo(new SybVersion(15, 5, 0, 0)) >= 0) + "'.");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println("------------------------------------------------------------------");
        System.out.println("");
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "TRACE, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        SybVersion.test("Adaptive Server Enterprise/15.0.3/EBF 16748 Cluster Edition/P/x86_64/Enterprise Linux/asepyxis/2837/64-bit/FBO/Mon Jun  1 08:38:39 2009");
        SybVersion.test("Adaptive Server Enterprise/15.5/EBF 18157 SMP ESD#2/P/NT (IX86)/Windows 2003/asear155/2514/32-bit/OPT/Wed Aug 25 05:31:40 2010");
        SybVersion.test("15.5/18157/P/NT (IX86)/Windows 2003/asear155/2514/32-bit/OPT/Wed Aug 25 05:22:07 2010");
        SybVersion.test("jConnect (TM) for JDBC(TM)/7.00(Build 26502)/P/EBF17821/JDK16/Tue Apr  6 11:59:33 2010");
        SybVersion.test("15.5.0.1012.1000/Tue 04-06-2010 20:23:52.35");
        SybVersion.test("Replication Server/15.2/P/NT (IX86)/Windows 2003/1/OPT/Thu Feb 05 18:34:37 2009");
        SybVersion.test("Adaptive Server Enterprise/12.5.4/EBF 15400 ESD#7.1/P/Sun_svr4/OS 5.8/ase1254/2097/64-bit/FBO/Thu Jan 17 07:42:59 2008");
    }

    public static enum Between {
        GTE_LTE,
        GTE_LT,
        GT_LTE,
        GT_LT;

    }
}

