/*
 * Decompiled with CFR 0.152.
 */
package asemon.xmenu;

import asemon.gui.LineNumberedPaper;
import asemon.xmenu.XmenuActionBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProcedureText
extends XmenuActionBase {
    private Connection _conn = null;
    private String _dbname = null;
    private String _procname = null;
    private int _linenum = -1;
    private boolean _closeConnOnExit;
    private JPopupMenu _rightClickPopupMenu = null;
    private JComponent _rightClickComponent = null;

    @Override
    public void doWork() {
        this._conn = this.getConnection();
        this._dbname = this.getParamValue(0);
        this._procname = this.getParamValue(1);
        this._linenum = Integer.parseInt(this.getParamValue(2, "0"));
        this._closeConnOnExit = this.isCloseConnOnExit();
        this.showText(this._conn, this._dbname, this._procname, this._linenum);
    }

    public void showText(Connection conn, String dbname, String procName, int line) {
        JPanel textPanel = new JPanel();
        LineNumberedPaper procText = new LineNumberedPaper(0, 0);
        final JFrame textFrame = new JFrame(procName);
        textFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProcedureText.this._closeConnOnExit) {
                    try {
                        ProcedureText.this._conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        });
        this.createRightClickMenyPopup(procText);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textFrame.dispose();
            }
        };
        JScrollPane scrollPane = new JScrollPane(procText);
        textPanel.setLayout(new BorderLayout());
        procText.setBackground(Color.white);
        procText.setEnabled(true);
        procText.setEditable(false);
        String sqlStatement = "select c.text from " + dbname + "..sysobjects o, " + dbname + "..syscomments c" + " where o.name = '" + procName + "'" + "   and o.id = c.id" + " order by c.number, c.colid2, c.colid";
        boolean found = false;
        try {
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlStatement);
            while (rs.next()) {
                found = true;
                String textPart = rs.getString(1);
                procText.append(textPart);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Executing SQL command '" + sqlStatement + "'. Found the following error:\n." + e, "Error", 0);
        }
        textPanel.add("Center", scrollPane);
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(action);
        buttonPanel.add(closeButton);
        textPanel.add("South", buttonPanel);
        textFrame.getContentPane().add("Center", textPanel);
        textFrame.setSize(1000, 600);
        if (!found) {
            JOptionPane.showMessageDialog(null, "The stored procedure '" + procName + "' cant be found in database '" + dbname + "'.", "Error", 0);
        } else {
            this.setCaretToLineNumber(procText, line);
            textFrame.setVisible(true);
        }
    }

    public void setCaretToLineNumber(JTextArea text, int linenumber) {
        String s;
        text.setCaretPosition(0);
        if (linenumber < 2) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int count = 0;
        int countRowAfter = 0;
        while (st.hasMoreTokens() & linenumber > 1) {
            s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            --linenumber;
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            countRowAfter = count + s.length();
        }
        text.setCaretPosition(count);
        text.select(count, countRowAfter);
    }

    private void createRightClickMenyPopup(JComponent jcomp) {
        this._rightClickPopupMenu = new JPopupMenu();
        this._rightClickComponent = jcomp;
        JMenuItem menuItem = null;
        menuItem = new JMenuItem("Procedure Text");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent comp = ProcedureText.this._rightClickComponent;
                if (comp instanceof JTextArea) {
                    JTextArea text = (JTextArea)comp;
                    String selectedText = text.getSelectedText();
                    String dbname = ProcedureText.this._dbname;
                    String procname = selectedText;
                    int linenum = 0;
                    String[] ss = selectedText.split("\\.");
                    if (ss.length == 3) {
                        dbname = ss[0];
                        procname = ss[2];
                    }
                    ProcedureText.this.showText(ProcedureText.this._conn, dbname, procname, linenum);
                }
            }
        });
        this._rightClickPopupMenu.add(menuItem);
        menuItem = new JMenuItem("Table Information");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dbname = "sybsystemprocs";
                String tabname = "sysobjects";
                System.out.println("SHOW:Table Information:dbname='" + dbname + "', tablename='" + tabname + "'.");
            }
        });
        this._rightClickPopupMenu.add(menuItem);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    System.out.println("_popup.show(e.getComponent()='" + e.getComponent() + "', e.getX()='" + e.getX() + "', e.getY()='" + e.getY() + "')");
                    if (ProcedureText.this._rightClickPopupMenu != null) {
                        ProcedureText.this._rightClickPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        jcomp.addMouseListener(ma);
    }
}

