/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.displayer.WizardDisplayerImpl;
import org.netbeans.modules.wizard.MergeMap;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardObserver;
import org.netbeans.spi.wizard.WizardPanel;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class NavButtonManager
implements ActionListener {
    static final String NAME_NEXT = "next";
    static final String NAME_PREV = "prev";
    static final String NAME_FINISH = "finish";
    static final String NAME_CANCEL = "cancel";
    static final String NAME_CLOSE = "close";
    static final String DEFERRED_FAILED = "FAILED_";
    private static final Logger logger = Logger.getLogger(NavButtonManager.class.getName());
    JButton next = null;
    JButton prev = null;
    JButton finish = null;
    JButton cancel = null;
    JButton help = null;
    JPanel buttons = null;
    private Window window;
    WizardDisplayerImpl parent;
    String closeString = NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Close");
    boolean suppressMessageDialog = false;
    String deferredStatus = null;

    NavButtonManager(WizardDisplayerImpl impl) {
        this.parent = impl;
    }

    protected void buildButtons(Action helpAction) {
        this.next = new JButton(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Next_>"));
        this.next.setName(NAME_NEXT);
        this.next.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Next_mnemonic").charAt(0));
        this.prev = new JButton(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "<_Prev"));
        this.prev.setName(NAME_PREV);
        this.prev.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Prev_mnemonic").charAt(0));
        this.finish = new JButton(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Finish"));
        this.finish.setName(NAME_FINISH);
        this.finish.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Finish_mnemonic").charAt(0));
        this.cancel = new JButton(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Cancel"));
        this.cancel.setName(NAME_CANCEL);
        this.cancel.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Cancel_mnemonic").charAt(0));
        this.help = new JButton();
        if (helpAction != null) {
            this.help.setAction(helpAction);
            if (helpAction.getValue("Name") == null) {
                this.help.setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Help"));
                this.help.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Help_mnemonic").charAt(0));
            }
        } else {
            this.help.setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Help"));
            this.help.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Help_mnemonic").charAt(0));
        }
        this.next.setDefaultCapable(true);
        this.prev.setDefaultCapable(true);
        this.help.setVisible(helpAction != null);
        final boolean aqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        this.buttons = new JPanel(){

            public void doLayout() {
                Insets ins = this.getInsets();
                JButton b = aqua ? NavButtonManager.this.finish : NavButtonManager.this.cancel;
                Dimension n = b.getPreferredSize();
                int y = (this.getHeight() - (ins.top + ins.bottom)) / 2 - n.height / 2;
                int gap = 5;
                int x = this.getWidth() - (12 + ins.right + n.width);
                b.setBounds(x, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.next : NavButtonManager.this.finish;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.prev : NavButtonManager.this.next;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.cancel : NavButtonManager.this.prev;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = NavButtonManager.this.help;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap * 2, y, n.width, n.height);
            }
        };
        this.buttons.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("textText")));
        this.buttons.add(this.prev);
        this.buttons.add(this.next);
        this.buttons.add(this.finish);
        this.buttons.add(this.cancel);
        this.buttons.add(this.help);
        this.next.addActionListener(this);
        this.prev.addActionListener(this);
        this.finish.addActionListener(this);
        this.cancel.addActionListener(this);
    }

    void connectListener() {
        NavWizardObserver l = new NavWizardObserver();
        Wizard wizard = this.parent.getWizard();
        l.stepsChanged(wizard);
        l.navigabilityChanged(wizard);
        l.selectionChanged(wizard);
        wizard.addWizardObserver(l);
    }

    private static void configureNavigationButtons(Wizard wizard, JButton prev, JButton next, JButton finish) {
        String nextStep = wizard.getNextStep();
        int fwdNavMode = wizard.getForwardNavigationMode();
        WizardDisplayerImpl.checkLegalNavMode(fwdNavMode);
        String problem = wizard.getProblem();
        boolean canContinue = (fwdNavMode & 1) != 0;
        boolean canFinish = (fwdNavMode & 2) != 0;
        boolean enableFinish = canFinish && problem == null;
        boolean enableNext = nextStep != null && canContinue && problem == null;
        next.setEnabled(enableNext);
        prev.setEnabled(wizard.getPreviousStep() != null);
        finish.setEnabled(enableFinish);
        JRootPane root = next.getRootPane();
        if (root != null) {
            if (next.isEnabled()) {
                root.setDefaultButton(next);
            } else if (finish.isEnabled()) {
                root.setDefaultButton(finish);
            } else if (prev.isEnabled()) {
                root.setDefaultButton(prev);
            } else {
                root.setDefaultButton(null);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.deferredStatus != null) {
            this.deferredResultFinished(event);
            return;
        }
        JButton button = (JButton)event.getSource();
        String name = button.getName();
        if (NAME_NEXT.equals(name)) {
            this.processNext();
        } else if (NAME_PREV.equals(name)) {
            this.processPrev();
        } else if (NAME_FINISH.equals(name)) {
            this.processFinish(event);
        } else if (NAME_CANCEL.equals(name)) {
            this.processCancel(event, true);
        } else if (NAME_CLOSE.equals(name)) {
            this.processClose(event);
        }
        this.parent.updateProblem();
    }

    void deferredResultFailed(boolean canGoBack) {
        if (!canGoBack) {
            this.getCancel().setText(this.closeString);
        }
        this.getPrev().setEnabled(true);
        this.getNext().setEnabled(false);
        this.getCancel().setEnabled(true);
        this.getFinish().setEnabled(false);
        if (!NAME_CLOSE.equals(this.deferredStatus)) {
            this.deferredStatus = DEFERRED_FAILED + this.deferredStatus;
        }
    }

    void deferredResultFinished(Object o) {
        String name = this.deferredStatus;
        this.deferredStatus = null;
        if (name.startsWith(DEFERRED_FAILED)) {
            JButton button;
            if (o instanceof ActionEvent && NAME_CANCEL.equals(name = (button = (JButton)((ActionEvent)o).getSource()).getName())) {
                this.processCancel(o instanceof ActionEvent ? (ActionEvent)o : null, false);
                return;
            }
            String currentStep = this.parent.getCurrentStep();
            this.parent.navigateTo(currentStep);
            return;
        }
        if (NAME_NEXT.equals(name)) {
            this.processNextProceed(o);
        } else if (NAME_PREV.equals(name)) {
            this.processPrevProceed(o);
        } else if (NAME_CANCEL.equals(name)) {
            this.processCancel(o instanceof ActionEvent ? (ActionEvent)o : null, false);
        } else if (NAME_FINISH.equals(name)) {
            this.processFinishProceed(o);
        } else if (NAME_CLOSE.equals(name)) {
            Window dlg = this.getWindow();
            dlg.setVisible(false);
            dlg.dispose();
        }
        this.parent.updateProblem();
    }

    protected void processNext() {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowNext(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_NEXT;
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processNextProceed(proceed);
    }

    protected void processNextProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        String nextId = wizard.getNextStep();
        settings.push(nextId);
        this.parent.navigateTo(nextId);
        this.parent.setInSummary(false);
    }

    protected void processPrev() {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowBack(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_PREV;
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processPrevProceed(proceed);
    }

    protected void processPrevProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        String prevId = wizard.getPreviousStep();
        settings.popAndCalve();
        this.parent.setDeferredResult(null);
        this.parent.navigateTo(prevId);
        this.parent.setInSummary(false);
    }

    protected void processFinish(ActionEvent event) {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowFinish(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_FINISH;
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processFinishProceed(proceed);
    }

    protected void processFinishProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        try {
            Object o = wizard.finish(settings);
            boolean closeWindow = true;
            if (o instanceof DeferredWizardResult) {
                DeferredWizardResult r = (DeferredWizardResult)o;
                this.finish.setEnabled(false);
                this.cancel.setEnabled(r.canAbort());
                this.prev.setEnabled(false);
                this.next.setEnabled(false);
                this.deferredStatus = NAME_CANCEL;
                this.parent.handleDeferredWizardResult(r, true);
                closeWindow = false;
            } else if (o instanceof Summary) {
                this.parent.handleSummary((Summary)o);
                this.parent.setWizardResult(((Summary)o).getResult());
                closeWindow = false;
            } else {
                this.parent.setWizardResult(o);
            }
            if (closeWindow) {
                this.processCancel(null, false);
            }
        }
        catch (WizardException we) {
            if (!this.suppressMessageDialog) {
                JOptionPane.showMessageDialog(this.next, we.getLocalizedMessage());
            }
            String id = we.getStepToReturnTo();
            String curr = settings.currID();
            try {
                while (id != null && !id.equals(curr)) {
                    curr = settings.popAndCalve();
                }
                settings.push(id);
                this.parent.navigateTo(id);
                return;
            }
            catch (NoSuchElementException ex) {
                IllegalStateException e = new IllegalStateException("Exception said to return to " + id + " but no such " + "step found");
                e.initCause(ex);
                throw e;
            }
        }
    }

    protected void processCancel(ActionEvent event, boolean reallyCancel) {
        DeferredWizardResult deferredResult = this.parent.getDeferredResult();
        if (deferredResult != null && deferredResult.canAbort()) {
            deferredResult.abort();
        }
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        boolean closeWindow = false;
        if (reallyCancel && this.parent.cancel()) {
            logger.fine("calling wizard cancel method on " + wizard);
            wizard.cancel(settings);
            return;
        }
        boolean bl = reallyCancel ? wizard.cancel(settings) : (closeWindow = this.parent.receiver == null);
        if (closeWindow) {
            Window win = event != null ? (Window)((JComponent)event.getSource()).getTopLevelAncestor() : this.getWindow();
            win.setVisible(false);
            win.dispose();
        }
    }

    protected void processClose(ActionEvent event) {
        Window win = (Window)((JComponent)event.getSource()).getTopLevelAncestor();
        win.setVisible(false);
        win.dispose();
    }

    void updateButtons() {
        Wizard wizard = this.parent.getWizard();
        if (!wizard.isBusy()) {
            NavButtonManager.configureNavigationButtons(wizard, this.prev, this.next, this.finish);
        }
    }

    void setSummaryShowingMode() {
        this.next.setEnabled(false);
        this.prev.setEnabled(false);
        this.cancel.setEnabled(true);
        this.finish.setEnabled(false);
        if (this.window != null && this.parent.receiver == null && this.window instanceof JDialog) {
            ((JDialog)this.window).getRootPane().setDefaultButton(this.cancel);
        }
        this.cancel.setText(this.closeString);
        this.cancel.setMnemonic(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayer.class, "Close_mnemonic").charAt(0));
        this.cancel.setName(NAME_CLOSE);
        this.deferredStatus = null;
    }

    void setWindow(Window dlg) {
        this.window = dlg;
    }

    public JPanel getButtons() {
        return this.buttons;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public String getCloseString() {
        return this.closeString;
    }

    public Window getWindow() {
        return this.window;
    }

    public JButton getFinish() {
        return this.finish;
    }

    public JButton getHelp() {
        return this.help;
    }

    public JButton getNext() {
        return this.next;
    }

    public WizardDisplayerImpl getParent() {
        return this.parent;
    }

    public JButton getPrev() {
        return this.prev;
    }

    public void initializeNavigation() {
        Wizard wizard = this.parent.getWizard();
        this.prev.setEnabled(false);
        this.next.setEnabled(wizard.getNextStep() != null);
        int fwdNavMode = wizard.getForwardNavigationMode();
        WizardDisplayerImpl.checkLegalNavMode(fwdNavMode);
        this.finish.setEnabled((fwdNavMode & 2) != 0);
        this.connectListener();
    }

    class NavWizardObserver
    implements WizardObserver {
        boolean wasBusy = false;

        NavWizardObserver() {
        }

        public void stepsChanged(Wizard wizard) {
        }

        public void navigabilityChanged(Wizard wizard) {
            if (wizard.isBusy()) {
                NavButtonManager.this.next.setEnabled(false);
                NavButtonManager.this.prev.setEnabled(false);
                NavButtonManager.this.finish.setEnabled(false);
                NavButtonManager.this.cancel.setEnabled(false);
                NavButtonManager.this.parent.getOuterPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.wasBusy = true;
                return;
            }
            if (this.wasBusy) {
                NavButtonManager.this.cancel.setEnabled(true);
                NavButtonManager.this.parent.getOuterPanel().setCursor(Cursor.getPredefinedCursor(0));
            }
            NavButtonManager.configureNavigationButtons(wizard, NavButtonManager.this.prev, NavButtonManager.this.next, NavButtonManager.this.finish);
            NavButtonManager.this.parent.updateProblem();
        }

        public void selectionChanged(Wizard wizard) {
        }
    }
}

