/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import java.awt.Color;
import java.awt.Graphics;

public class ColorMutable {
    private int m_alpha = -1;
    private int m_blue = -1;
    private Color m_color;
    private int m_green = -1;
    private int m_red = -1;

    public synchronized Color applyColorIfChange(Graphics g) {
        Color gColor;
        Color result = null;
        if (this.m_color != null && !(gColor = g.getColor()).equals(this.m_color)) {
            result = gColor;
            g.setColor(this.m_color);
        }
        return result;
    }

    private void assertColorValue(int value) {
        if (value < 0 || value > 255) {
            throw new RuntimeException("Argument has to be between 0 and 255. It is " + value);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorMutable other = (ColorMutable)obj;
        if (this.m_alpha != other.m_alpha) {
            return false;
        }
        if (this.m_blue != other.m_blue) {
            return false;
        }
        if (this.m_color == null ? other.m_color != null : !this.m_color.equals(other.m_color)) {
            return false;
        }
        if (this.m_green != other.m_green) {
            return false;
        }
        return this.m_red == other.m_red;
    }

    public int getAlpha() {
        return this.m_alpha;
    }

    public int getBlue() {
        return this.m_blue;
    }

    public Color getColor() {
        return this.m_color;
    }

    public int getGreen() {
        return this.m_green;
    }

    public int getRed() {
        return this.m_red;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_alpha;
        result = 31 * result + this.m_blue;
        result = 31 * result + (this.m_color == null ? 0 : this.m_color.hashCode());
        result = 31 * result + this.m_green;
        result = 31 * result + this.m_red;
        return result;
    }

    public synchronized int setAlpha(int alpha) {
        int orgTransparencyInt;
        int result = this.m_alpha;
        this.assertColorValue(alpha);
        this.m_alpha = alpha;
        if (this.m_color != null && alpha != (orgTransparencyInt = this.m_color.getAlpha())) {
            Color transparentColor = new Color(this.m_color.getRed(), this.m_color.getGreen(), this.m_color.getBlue(), alpha);
            this.setColor(transparentColor);
        }
        return result;
    }

    public synchronized int setBlue(int blue) {
        int orgvalue;
        int result = this.m_blue;
        this.assertColorValue(blue);
        this.m_blue = blue;
        if (this.m_color != null && blue != (orgvalue = this.m_color.getBlue())) {
            Color newColor = new Color(this.m_color.getRed(), this.m_color.getGreen(), blue, this.m_color.getAlpha());
            this.setColor(newColor);
        }
        return result;
    }

    public synchronized Color setColor(Color color) {
        Color result = this.m_color;
        Color use = color;
        if (this.m_color == null) {
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            int alpha = color.getAlpha();
            boolean change = false;
            if (this.m_red != -1) {
                red = this.m_red;
                change = true;
            }
            if (this.m_green != -1) {
                green = this.m_green;
                change = true;
            }
            if (this.m_blue != -1) {
                blue = this.m_blue;
                change = true;
            }
            if (this.m_alpha != -1) {
                alpha = this.m_alpha;
                change = true;
            }
            if (change) {
                use = new Color(red, green, blue, alpha);
            }
        }
        this.m_color = use;
        return result;
    }

    public synchronized int setGreen(int green) {
        int orgvalue;
        int result = this.m_green;
        this.assertColorValue(green);
        this.m_green = green;
        if (this.m_color != null && green != (orgvalue = this.m_color.getGreen())) {
            Color newColor = new Color(this.m_color.getRed(), green, this.m_color.getBlue(), this.m_color.getAlpha());
            this.setColor(newColor);
        }
        return result;
    }

    public synchronized int setRed(int red) {
        int orgvalue;
        int result = this.m_red;
        this.assertColorValue(red);
        this.m_red = red;
        if (this.m_color != null && red != (orgvalue = this.m_color.getRed())) {
            Color newColor = new Color(this.m_red, this.m_color.getGreen(), this.m_color.getBlue(), this.m_color.getAlpha());
            this.setColor(newColor);
        }
        return result;
    }
}

