/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.JdbcDataObject;
import com.sybase.jdbc4.jdbc.ProtocolResultSet;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.Cacheable;
import com.sybase.jdbc4.utils.Debug;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected int _state = 2;
    private Hashtable n = null;
    private Hashtable m = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;
    protected boolean _usedForParams = false;
    protected SQLWarning _savedWarnings = null;
    protected int _currentStatus = 1;

    public SybResultSet(SybStatement sybStatement, ProtocolResultSet protocolResultSet) throws SQLException {
        this._statement = sybStatement;
        this._prs = protocolResultSet;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkResultSet();
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this.checkRowIndexBeforeProtocolNext()) {
            return false;
        }
        boolean bl = this._prs.next();
        if (!bl) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            this.adjustRowIndexesAfterProtocolNext();
        }
        this._currentColumn = null;
        return bl;
    }

    protected boolean checkRowIndexBeforeProtocolNext() {
        boolean bl = false;
        switch (this._rowIndex) {
            case -2: {
                bl = true;
                break;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex <= 0) break;
                ++this._rowIndex;
            }
        }
        return bl;
    }

    protected void adjustRowIndexesAfterProtocolNext() {
        if (this._rowIndex == 1) {
            this._lastRowIndex = 0;
            this._rowIndex = -1;
        } else {
            this._lastRowIndex = this._rowIndex - 1;
            this._rowIndex = -2;
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(false);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }

    @Override
    public String getString(int n2) throws SQLException {
        return this.getColumn(n2).getString();
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        return this.getColumn(n2).getBoolean();
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        return this.getColumn(n2).getByte();
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        return this.getColumn(n2).getBytes();
    }

    @Override
    public TextPointer getSybTextPointer(int n2) throws SQLException {
        return this.getColumn(n2).getTextPtr();
    }

    @Override
    public short getShort(int n2) throws SQLException {
        return this.getColumn(n2).getShort();
    }

    @Override
    public int getInt(int n2) throws SQLException {
        return this.getColumn(n2).getInt();
    }

    @Override
    public long getLong(int n2) throws SQLException {
        return this.getColumn(n2).getLong();
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        return this.getColumn(n2).getFloat();
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        return this.getColumn(n2).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getColumn(n2).getBigDecimal(n3);
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.getBigDecimal(n2, -1);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return Convert.objectToDate(this.getColumn(n2).getDateObject(91, null));
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return Convert.objectToTime(this.getColumn(n2).getDateObject(92, null));
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n2).getDateObject(93, null));
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        return this.getColumn(n2).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        return this.getColumn(n2).getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        return this.getColumn(n2).getBinaryStream();
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this.getColumn(n2).getObject();
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(string, -1);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public TextPointer getSybTextPointer(String string) throws SQLException {
        return this.getSybTextPointer(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        Debug.notImplemented(this, "getURL(int)");
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        Debug.notImplemented(this, "getURL(String)");
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        if (this._prs != null) {
            if (this._savedWarnings != null) {
                this._savedWarnings.setNextWarning(this._prs.getWarnings());
                this._prs.clearWarnings();
                sQLWarning = this._savedWarnings;
            } else {
                sQLWarning = this._prs.getWarnings();
            }
        } else if (this._savedWarnings != null) {
            sQLWarning = this._savedWarnings;
        }
        return sQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this._prs != null) {
            this._prs.clearWarnings();
        }
        this._savedWarnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this._prs.getMetaData();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n2;
        if (this._statement._context._conn._props.getBoolean(40)) {
            Integer n3;
            if (this.m == null) {
                this.m = new Hashtable();
            }
            if ((n3 = (Integer)this.m.get(string)) != null) {
                return n3;
            }
            int n4 = this._prs.findColumnByLabel(string);
            this.m.put(string, new Integer(n4));
            return n4;
        }
        if (this.n == null) {
            this.n = new Hashtable();
        }
        if ((n2 = (Integer)this.n.get(string)) != null) {
            return n2;
        }
        int n5 = this._prs.findColumn(string);
        this.n.put(string, new Integer(n5));
        return n5;
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        return this.getColumn(n2).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        if (this._rowIndex <= 0) {
            return 0;
        }
        return this._rowIndex;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._rowIndex == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._rowIndex == -2;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._rowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        Debug.notImplemented(this, "isLast()");
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkForScrollability("previous()");
        this.clearWarnings();
        boolean bl = true;
        switch (this._rowIndex) {
            case -1: {
                return false;
            }
            case 1: {
                this._rowIndex = -1;
                bl = false;
                break;
            }
            case -2: {
                this._rowIndex = this._lastRowIndex;
                break;
            }
            default: {
                --this._rowIndex;
            }
        }
        this._prs.previous();
        return bl;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        int n3;
        this.checkForScrollability("absolute(int)");
        this.clearWarnings();
        if (this._lastRowIndex == 0) {
            return false;
        }
        if (n2 == 0) {
            ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "absolute(int)");
        }
        if (n2 < 0) {
            if (this._lastRowIndex == -4 && !this.last()) {
                return false;
            }
            if ((n2 += this._lastRowIndex + 1) <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n2 <= (n3 = this._prs.getNumRowsCached())) {
            this._rowIndex = n2;
            this._prs.absolute(n2);
            return true;
        }
        if (n3 > 0) {
            this._rowIndex = n3;
            this._prs.absolute(this._rowIndex);
        }
        while (this._rowIndex < n2 && this.next()) {
        }
        return this._rowIndex == n2;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkForScrollability("afterLast()");
        this.clearWarnings();
        if (this.last()) {
            this.next();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkForScrollability("beforeFirst()");
        this.clearWarnings();
        if (this.first()) {
            this.previous();
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkForScrollability("first()");
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this._rowIndex == 1) {
            return true;
        }
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        this.checkForScrollability("last()");
        this.clearWarnings();
        this.moveToCurrentRow();
        if (this._lastRowIndex == -4) {
            if (this._prs.getNumRowsCached() > 0) {
                this._rowIndex = this._prs.getNumRowsCached();
                this._prs.absolute(this._rowIndex);
            }
            while (this.next()) {
            }
            this.previous();
        } else if (this._lastRowIndex != 0) {
            this._rowIndex = this._lastRowIndex;
            this._prs.absolute(this._rowIndex);
        }
        return this._lastRowIndex != 0;
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.checkForScrollability("relative(int)");
        this.clearWarnings();
        this.moveToCurrentRow();
        boolean bl = false;
        if (this._rowIndex != -1 && this._rowIndex != -2) {
            int n3 = this._rowIndex + n2;
            if (n3 <= 0) {
                this.beforeFirst();
            } else {
                bl = this.absolute(n3);
            }
        }
        return bl;
    }

    @Override
    public void refreshRow() throws SQLException {
        switch (this._scrollType) {
            case 1003: 
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        block0 : switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: 
            case 1005: {
                switch (n2) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this._fetchDirection = n2;
                        break block0;
                    }
                }
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n2), "setFetchDirection(int)");
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        if (n2 == 0) {
            return;
        }
        int n3 = this._statement.getMaxRows();
        if (n2 < 0 || n3 > 0 && n2 > n3) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._fetchSize = n2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this._scrollType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._concurType;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    @Override
    public void insertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    @Override
    public void updateRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    @Override
    public void deleteRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        Debug.notSupported(this, "updateBlob(int, Blob)");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        Debug.notSupported(this, "updateBlob(String, Blob)");
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        Debug.notSupported(this, "updateClob(int, Clob)");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        Debug.notSupported(this, "updateClob(String, Clob)");
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        Debug.notSupported(this, "updateArray(int, Array)");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        Debug.notSupported(this, "updateArray(String, Array)");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        Debug.notSupported(this, "updateRef(int, Ref)");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        Debug.notSupported(this, "updateRef(String, Ref)");
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToDate(this.getColumn(n2).getDateObject(91, calendar));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTime(this.getColumn(n2).getDateObject(92, calendar));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(n2).getDateObject(93, calendar));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public void clear() throws IOException {
        try {
            this.close(false);
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
    }

    @Override
    public void setManager(CacheManager cacheManager) {
        this._cm = cacheManager;
    }

    @Override
    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    @Override
    public void resetInputStream(InputStream inputStream) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cache() throws IOException {
        try {
            switch (this._currentStatus) {
                case 2: {
                    if (this._rowIndex == -2) return;
                    if (this._scrollType != 1004) {
                        this._prs.setType(1004);
                    }
                    while (this._prs.next()) {
                    }
                    if (this._rowIndex == -1) {
                        this._prs.absolute(1);
                        this._prs.previous();
                    } else {
                        this._prs.absolute(this._rowIndex);
                    }
                    this._statement._currentOpenRS.addElement(this);
                    return;
                }
                case 3: {
                    Enumeration enumeration = this._statement._currentOpenRS.elements();
                    while (enumeration.hasMoreElements()) {
                        ((SybResultSet)enumeration.nextElement()).close();
                    }
                    this._statement._currentOpenRS.clear();
                }
                case 1: {
                    this.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
            return;
        }
        finally {
            if (this._cm != null) {
                this._cm.doneReading();
                this._cm.dead(this);
                this._cm = null;
            }
        }
    }

    @Override
    public void open(boolean bl) {
    }

    @Override
    public int getState() {
        if (this._state == 4) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void markDead(boolean bl) throws SQLException {
        block9: {
            if (this._state == 4) {
                return;
            }
            this._state = 4;
            try {
                if (this._prs == null) break block9;
                this._prs.close(bl);
                if (this._statement == null) break block9;
                try {
                    SQLWarning sQLWarning = this._prs.getWarnings();
                    if (sQLWarning != null) {
                        this._statement.handleSQLE(sQLWarning);
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._statement.setRowCount(this._prs.getCount());
            }
            finally {
                if (this._cm != null) {
                    this._cm.doneReading();
                    this._cm.dead(this);
                    this._cm = null;
                }
                if (this._statement != null) {
                    this._statement._currentRS = null;
                    this._statement = null;
                }
                this.n = null;
                this._prs = null;
            }
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != 2) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    protected void close(boolean bl) throws SQLException {
        this.markDead(bl);
    }

    protected JdbcDataObject getColumn(int n2) throws SQLException {
        this.checkResultSet();
        this.checkIfReadableRow();
        this._currentColumn = this._prs.getColumn(n2);
        return this._currentColumn;
    }

    protected void checkIfReadableRow() throws SQLException {
        if (this._rowIndex == -1 && !this._usedForParams) {
            ErrorMessage.raiseError("JZ0R1");
        } else if (this._rowIndex == -2) {
            ErrorMessage.raiseError("JZ0R5");
        }
    }

    public void setHoldsParams(boolean bl) {
        this._usedForParams = bl;
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal, int n3, int n4) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    protected void checkForScrollability(String string) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", string, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                Debug.notImplemented(this, string + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._statement.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getColumn(n2).getCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(int)");
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "getNClob(String)");
        return null;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getColumn(n2).getString();
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._state == 4;
    }

    public Object getObject(int n2, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int columnIndex, Map<String, Class<?>> map)");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(String columnLabel, Map<String, Class<?>> map)");
        return null;
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        Debug.notImplemented(this, "getRowId(int columnIndex)");
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        Debug.notImplemented(this, "getRowId(String columnLabel)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        Debug.notImplemented(this, "getSQLXML(int columnIndex)");
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        Debug.notImplemented(this, "getSQLXML(String columnLabel)");
        return null;
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateAsciiStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateAsciiStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateAsciiStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateAsciiStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateBinaryStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateBinaryStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateBinaryStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateBinaryStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateBlob(int columnIndex, InputStream inputStream)");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        Debug.notImplemented(this, "updateBlob(String columnLabel, InputStream inputStream)");
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateBlob(int columnIndex, InputStream inputStream, long length)");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        Debug.notImplemented(this, "updateBlob(String columnLabel, InputStream inputStream, long length)");
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        Debug.notImplemented(this, "updateCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        Debug.notImplemented(this, "updateCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        Debug.notImplemented(this, "updateCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        Debug.notImplemented(this, "updateCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        Debug.notImplemented(this, "updateClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        Debug.notImplemented(this, "updateClob(String columnLabel, Reader reader)");
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        Debug.notImplemented(this, "updateClob(int columnIndex, Reader reader, long length)");
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        Debug.notImplemented(this, "updateClob(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(int, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNCharacterStream(String, java.io.Reader, long)", this._concurTypeString);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(String, NClob)");
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(String, Reader)");
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "updateNClob(String, Reader, long)");
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNString(int, String)", this._concurTypeString);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNString(String, String)", this._concurTypeString);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        Debug.notImplemented(this, "updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        Debug.notImplemented(this, "updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        Debug.notImplemented(this, "updateSQLXML(int columnIndex, SQLXML xmlObject)");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        Debug.notImplemented(this, "updateSQLXML(String columnLabel, SQLXML xmlObject)");
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        Object var2_2 = null;
        try {
            var2_2 = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return var2_2;
    }
}

