/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public class ParamFormatToken
extends RowFormatToken {
    public static final int MAX_PARAMFMT_LENGTH = 65535;
    protected DataFormat[] _param;
    protected ParamManager _paramMgr;
    protected int _numParams;

    public ParamFormatToken() {
    }

    public ParamFormatToken(ParamManager paramManager) throws IOException, SQLException {
        this._numParams = paramManager.makeFormats();
        this._paramMgr = paramManager;
    }

    public ParamFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    protected long getLength() {
        int n2 = 2;
        return n2 += this._paramMgr.getLength();
    }

    public int getFormatCount() {
        return this._numParams;
    }

    @Override
    public void send(TdsOutputStream tdsOutputStream) throws IOException {
        if (this.getLength() > 65535L) {
            ErrorMessage.raiseIOException("JZ0PC");
        } else {
            tdsOutputStream.writeByte(236);
            tdsOutputStream.writeShort((int)this.getLength());
            tdsOutputStream.writeShort(this.getFormatCount());
            this.sendFormat(tdsOutputStream);
        }
    }

    protected void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
        this._paramMgr.sendFormats(tdsOutputStream);
    }
}

