/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class TdsInputStream
extends FilterInputStream
implements DataInput {
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    protected byte[] _buf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected int _next = -1;
    protected int _last = -1;
    private boolean a = false;

    public TdsInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.in.read(byArray, n2, n3);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        for (int i2 = 0; i2 < n2; i2 += (int)this.in.skip(n2 - i2)) {
        }
        return n2;
    }

    public void setBigEndian(boolean bl) {
        this.a = !bl;
    }

    public boolean getBigEndian() {
        return !this.a;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public short readShort() throws IOException {
        int n2 = this.read(this._buf, 0, 2);
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)(this.a ? (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 8 | 0xFF & this._buf[1]);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n2 = this.read(this._buf, 0, 2);
        if (n2 < 0) {
            throw new EOFException();
        }
        return this.a ? (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 8 | 0xFF & this._buf[1];
    }

    @Override
    public int readInt() throws IOException {
        int n2 = this.read(this._buf, 0, 4);
        if (n2 < 0) {
            throw new EOFException();
        }
        return this.a ? (0xFF & this._buf[3]) << 24 | (0xFF & this._buf[2]) << 16 | (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 24 | (0xFF & this._buf[1]) << 16 | (0xFF & this._buf[2]) << 8 | 0xFF & this._buf[3];
    }

    public int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = inputStream.read(byArray, 0, 4);
        if (n2 < 0) {
            throw new EOFException();
        }
        return this.a ? (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
    }

    public long readUnsignedIntAsLong() throws IOException {
        int n2 = this.read(this._buf, 0, 4);
        if (n2 != 4) {
            throw new EOFException();
        }
        return this.a ? (0xFFL & (long)this._buf[3]) << 24 | (0xFFL & (long)this._buf[2]) << 16 | (0xFFL & (long)this._buf[1]) << 8 | 0xFFL & (long)this._buf[0] : (0xFFL & (long)this._buf[0]) << 24 | (0xFFL & (long)this._buf[1]) << 16 | (0xFFL & (long)this._buf[2]) << 8 | 0xFFL & (long)this._buf[3];
    }

    public int readUnsignedShortAsInt() throws IOException {
        int n2 = this.read(this._buf, 0, 2);
        if (n2 != 2) {
            throw new EOFException();
        }
        return this.a ? (0xFF & this._buf[1]) << 8 | 0xFF & this._buf[0] : (0xFF & this._buf[0]) << 8 | 0xFF & this._buf[1];
    }

    public BigDecimal readUnsignedLongAsBigDecimal() throws IOException {
        int n2;
        int n3 = this.read(this._buf, 0, 8);
        if (n3 != 8) {
            throw new EOFException();
        }
        byte[] byArray = new byte[8];
        if (this.a) {
            for (n2 = 0; n2 < 8; ++n2) {
                byArray[n2] = this._buf[7 - n2];
            }
        } else {
            for (n2 = 0; n2 < 8; ++n2) {
                byArray[n2] = this._buf[n2];
            }
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(1, byArray), 0);
        return bigDecimal;
    }

    @Override
    public long readLong() throws IOException {
        int n2 = this.read(this._buf, 0, 8);
        if (n2 < 0) {
            throw new EOFException();
        }
        return this.a ? (0xFFL & (long)this._buf[7]) << 56 | (0xFFL & (long)this._buf[6]) << 48 | (0xFFL & (long)this._buf[5]) << 40 | (0xFFL & (long)this._buf[4]) << 32 | (0xFFL & (long)this._buf[3]) << 24 | (0xFFL & (long)this._buf[2]) << 16 | (0xFFL & (long)this._buf[1]) << 8 | 0xFFL & (long)this._buf[0] : (0xFFL & (long)this._buf[0]) << 56 | (0xFFL & (long)this._buf[1]) << 48 | (0xFFL & (long)this._buf[2]) << 40 | (0xFFL & (long)this._buf[3]) << 32 | (0xFFL & (long)this._buf[4]) << 24 | (0xFFL & (long)this._buf[5]) << 16 | (0xFFL & (long)this._buf[6]) << 8 | 0xFFL & (long)this._buf[7];
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readString(int n2) throws IOException {
        return null;
    }

    public String readUnicodeString(int n2) throws IOException {
        return null;
    }

    public String convertBytesToString(byte[] byArray) throws IOException {
        return null;
    }

    public String convertUnicodeBytesToString(byte[] byArray) throws IOException {
        return null;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int available() throws IOException {
        return this._last - this._next + this.in.available();
    }

    public void flush() {
        this._next = -1;
        this._last = -1;
    }

    @Override
    public void close() throws IOException {
        this._buf = null;
        this.in.close();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.read(byArray, n2, n3);
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public char readChar() throws IOException {
        throw new IOException("Not implemented");
    }

    public abstract String getCharset();
}

