/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.desktop.win;

import com.btr.proxy.search.desktop.win.Win32IESettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Win32ProxyUtils {
    public static final int WINHTTP_AUTO_DETECT_TYPE_DHCP = 1;
    public static final int WINHTTP_AUTO_DETECT_TYPE_DNS_A = 2;
    private static String LIB_NAME_BASE = "proxy_util_";

    public native String winHttpDetectAutoProxyConfigUrl(int var1);

    native String winHttpGetDefaultProxyConfiguration();

    public native Win32IESettings winHttpGetIEProxyConfigForCurrentUser();

    public native String readUserHomedir();

    static {
        try {
            String libDir;
            String LIB_NAME = LIB_NAME_BASE + "w32.dll";
            if (!System.getProperty("os.arch").equals("x86")) {
                LIB_NAME = LIB_NAME_BASE + System.getProperty("os.arch") + ".dll";
            }
            if ((libDir = System.getProperty("proxy_vole_lib_dir")) != null && new File(libDir, LIB_NAME).exists()) {
                System.load(new File(libDir, LIB_NAME).getAbsolutePath());
            } else if (new File("lib", LIB_NAME).exists()) {
                System.load(new File("lib", LIB_NAME).getAbsolutePath());
            } else {
                InputStream source = Win32ProxyUtils.class.getResourceAsStream("/lib/" + LIB_NAME);
                File tempFile = File.createTempFile("proxy_vole", ".dll");
                tempFile.deleteOnExit();
                FileOutputStream fout = new FileOutputStream(tempFile);
                byte[] buffer = new byte[1024];
                int read = 0;
                while (read >= 0) {
                    fout.write(buffer, 0, read);
                    read = source.read(buffer);
                }
                fout.flush();
                fout.close();
                source.close();
                System.load(tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading dll" + e.getMessage(), e);
        }
    }
}

