/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.java;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.fixed.FixedSocksSelector;
import com.btr.proxy.selector.misc.ProtocolDispatchSelector;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.btr.proxy.util.Logger;
import java.net.ProxySelector;

public class JavaProxySearchStrategy
implements ProxySearchStrategy {
    public ProxySelector getProxySelector() {
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Using settings from Java System Properties", new Object[0]);
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort", "80");
        String whiteList = System.getProperty("http.nonProxyHosts", "").replace('|', ',');
        if (host == null || host.trim().length() == 0) {
            return null;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "HTTP(S) proxy {0}:{1} found using whitelist: {2}", host, port, whiteList);
        if (whiteList.trim().length() > 0) {
            ps.setSelector("http", new ProxyBypassListSelector(whiteList, (ProxySelector)new FixedProxySelector(host, Integer.parseInt(port))));
            ps.setSelector("https", new ProxyBypassListSelector(whiteList, (ProxySelector)new FixedProxySelector(host, Integer.parseInt(port))));
        } else {
            ps.setSelector("http", new FixedProxySelector(host, Integer.parseInt(port)));
            ps.setSelector("https", new FixedProxySelector(host, Integer.parseInt(port)));
        }
        host = System.getProperty("ftp.proxyHost");
        port = System.getProperty("ftp.proxyPort", "80");
        whiteList = System.getProperty("ftp.nonProxyHosts", "").replace('|', ',');
        if (host != null && host.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Ftp proxy {0}:{1} found using whitelist: {2}", host, port, whiteList);
            if (whiteList.trim().length() > 0) {
                ps.setSelector("ftp", new ProxyBypassListSelector(whiteList, (ProxySelector)new FixedProxySelector(host, Integer.parseInt(port))));
                ps.setSelector("ftps", new ProxyBypassListSelector(whiteList, (ProxySelector)new FixedProxySelector(host, Integer.parseInt(port))));
            } else {
                ps.setSelector("ftp", new FixedProxySelector(host, Integer.parseInt(port)));
                ps.setSelector("ftps", new FixedProxySelector(host, Integer.parseInt(port)));
            }
        }
        host = System.getProperty("socksProxyHost");
        port = System.getProperty("socksProxyPort", "1080");
        if (host != null && host.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Socks proxy {0}:{1} found", host, port);
            ps.setSelector("socks", new FixedSocksSelector(host, Integer.parseInt(port)));
        }
        return ps;
    }
}

