/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.pac;

import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class UrlPacScriptSource
implements PacScriptSource {
    private final String scriptUrl;
    private String scriptContent;
    private long expireAtMillis = 0L;

    public UrlPacScriptSource(String url) {
        this.scriptUrl = url;
    }

    public synchronized String getScriptContent() throws IOException {
        if (this.scriptContent == null || this.expireAtMillis > 0L && this.expireAtMillis > System.currentTimeMillis()) {
            try {
                this.scriptContent = this.scriptUrl.startsWith("file:/") || this.scriptUrl.indexOf(":/") == -1 ? this.readPacFileContent(this.scriptUrl) : this.downloadPacContent(this.scriptUrl);
            }
            catch (IOException e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Loading script failed.", e);
                this.scriptContent = "";
                throw e;
            }
        }
        return this.scriptContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPacFileContent(String scriptUrl) throws IOException {
        try {
            File file = null;
            file = scriptUrl.indexOf(":/") == -1 ? new File(scriptUrl) : new File(new URL(scriptUrl).toURI());
            BufferedReader r = new BufferedReader(new FileReader(file));
            StringBuilder result = new StringBuilder();
            try {
                String line;
                while ((line = r.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            finally {
                r.close();
            }
            return result.toString();
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "File reading error.", e);
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadPacContent(String url) throws IOException {
        if (url == null) {
            throw new IOException("Invalid PAC script URL: null");
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        con.setInstanceFollowRedirects(true);
        con.setRequestProperty("accept", "application/x-ns-proxy-autoconfig, */*;q=0.8");
        if (con.getResponseCode() != 200) {
            throw new IOException("Server returned: " + con.getResponseCode() + " " + con.getResponseMessage());
        }
        this.expireAtMillis = con.getExpiration();
        String charsetName = this.parseCharsetFromHeader(con.getContentType());
        BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream(), charsetName));
        try {
            StringBuilder result = new StringBuilder();
            try {
                String line;
                while ((line = r.readLine()) != null) {
                    result.append(line).append("\n");
                }
            }
            finally {
                r.close();
                con.disconnect();
            }
            String string = result.toString();
            return string;
        }
        finally {
            r.close();
        }
    }

    String parseCharsetFromHeader(String contentType) {
        String result = "ISO-8859-1";
        if (contentType != null) {
            String[] paramList;
            for (String param : paramList = contentType.split(";")) {
                if (!param.toLowerCase().trim().startsWith("charset") || param.indexOf("=") == -1) continue;
                result = param.substring(param.indexOf("=") + 1).trim();
            }
        }
        return result;
    }

    public String toString() {
        return this.scriptUrl;
    }
}

