/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyAbsoluteSummation;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import info.monitorenter.gui.chart.events.AxisActionSetFormatter;
import info.monitorenter.gui.chart.events.AxisActionSetGrid;
import info.monitorenter.gui.chart.events.AxisActionSetRange;
import info.monitorenter.gui.chart.events.AxisActionSetRangePolicy;
import info.monitorenter.gui.chart.events.AxisActionSetTitle;
import info.monitorenter.gui.chart.events.AxisActionSetTitleFont;
import info.monitorenter.gui.chart.events.Chart2DActionEnableAntialiasing;
import info.monitorenter.gui.chart.events.Chart2DActionEnableHighlighting;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSaveEpsSingletonApacheFop;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetAxis;
import info.monitorenter.gui.chart.events.Chart2DActionSetCustomGridColorSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetGridColor;
import info.monitorenter.gui.chart.events.ChartActionSetToolTipType;
import info.monitorenter.gui.chart.events.ChartPanelActionAddAnnotation;
import info.monitorenter.gui.chart.events.ErrorBarPolicyMultiAction;
import info.monitorenter.gui.chart.events.JComponentActionSetBackground;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomBackgroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomForegroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetForeground;
import info.monitorenter.gui.chart.events.PopupListener;
import info.monitorenter.gui.chart.events.Trace2DActionAddRemoveHighlighter;
import info.monitorenter.gui.chart.events.Trace2DActionAddRemoveTracePainter;
import info.monitorenter.gui.chart.events.Trace2DActionRemove;
import info.monitorenter.gui.chart.events.Trace2DActionSetColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetCustomColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetName;
import info.monitorenter.gui.chart.events.Trace2DActionSetPhysicalUnits;
import info.monitorenter.gui.chart.events.Trace2DActionSetStroke;
import info.monitorenter.gui.chart.events.Trace2DActionSetVisible;
import info.monitorenter.gui.chart.events.Trace2DActionSetZindex;
import info.monitorenter.gui.chart.events.Trace2DActionZindexDecrease;
import info.monitorenter.gui.chart.events.Trace2DActionZindexIncrease;
import info.monitorenter.gui.chart.events.ZoomableChartZoomOutAction;
import info.monitorenter.gui.chart.labelformatters.ALabelFormatter;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterAutoUnits;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterNumber;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyForcedPoint;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyHighestValues;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.traces.painters.TracePainterFill;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LayoutFactory {
    private static LayoutFactory instance;
    private boolean m_showAnnotationMenu = false;
    private boolean m_showAntialiasingMenu = true;
    private boolean m_showAxisFormatterMenu = true;
    private boolean m_showAxisXGridMenu = true;
    private boolean m_showAxisXMenu = true;
    private boolean m_showAxisXRangePolicyMenu = true;
    private boolean m_showAxisXTitleMenu = true;
    private boolean m_showAxisXTypeMenu = true;
    private boolean m_showAxisYGridMenu = true;
    private boolean m_showAxisYMenu = true;
    private boolean m_showAxisYRangePolicyMenu = true;
    private boolean m_showAxisYTitleMenu = true;
    private boolean m_showAxisYTypeMenu = true;
    private boolean m_showChartBackgroundMenu = true;
    private boolean m_showChartForegroundMenu = true;
    private boolean m_showChartHighlighterMenu = true;
    private boolean m_showErrorBarWizardMenu = true;
    private boolean m_showGridColorMenu = true;
    private boolean m_showGridMenu = true;
    private boolean m_showHighlightMenu = true;
    private boolean m_showPhysicalUnitsMenu = true;
    private boolean m_showPrintMenu = true;
    private boolean m_showRemoveTraceMenu = false;
    private boolean m_showSaveEpsMenu = true;
    private boolean m_showSaveMenu = true;
    private boolean m_showToolTipMenu = true;
    private boolean m_showToolTipTypeMenu = true;
    private boolean m_showTraceColorMenu = true;
    private boolean m_showTraceHighlighterMenu = true;
    private boolean m_showTraceNameMenu = true;
    private boolean m_showTracePainterMenu = true;
    private boolean m_showTraceStrokeMenu = true;
    private boolean m_showTraceVisibleMenu = true;
    private boolean m_showTraceZindexMenu = true;
    private boolean m_showZoomOutMenu = true;
    private String[] m_strokeNames;
    private Stroke[] m_strokes = new Stroke[6];

    public static LayoutFactory getInstance() {
        if (instance == null) {
            instance = new LayoutFactory();
        }
        return instance;
    }

    private static Font[] getSystemFonts(float pointSize) {
        Font[] result = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = result.length - 1; i > -1; --i) {
            result[i] = result[i].deriveFont(pointSize);
        }
        return result;
    }

    private LayoutFactory() {
        this.m_strokeNames = new String[6];
        this.m_strokes[0] = new BasicStroke();
        this.m_strokeNames[0] = "basic";
        this.m_strokes[1] = new BasicStroke(2.0f);
        this.m_strokeNames[1] = "thick";
        this.m_strokes[2] = new BasicStroke(6.0f, 1, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[2] = "round caps";
        this.m_strokes[3] = new BasicStroke(1.0f, 0, 0, 1.5f, new float[]{5.0f, 5.0f}, 2.5f);
        this.m_strokeNames[3] = "dashed";
        this.m_strokes[4] = new BasicStroke(6.0f, 2, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[4] = "square caps";
        this.m_strokes[5] = new BasicStroke(3.0f, 0, 2, 1.5f, new float[]{10.0f, 2.0f}, 1.0f);
        this.m_strokeNames[5] = "dashed thick";
    }

    public JMenu createAnnoationsMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        JMenu result;
        Chart2D chart = chartPanel.getChart();
        if (adaptUI2Chart) {
            result = new PropertyChangeMenu(chart, "Annotate", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            PropertyChangeMenuItem item = new PropertyChangeMenuItem(chart, new ChartPanelActionAddAnnotation(chartPanel, "Annotation 1"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            result.add(item);
        } else {
            result = new JMenu("Annotate");
            JMenuItem item = new JMenuItem(new ChartPanelActionAddAnnotation(chartPanel, "Annotation 1"));
            result.add(item);
        }
        return result;
    }

    private Component createAxisFormatterMenu(Chart2D chart, IAxis axis, int axisDimension, boolean adaptUI2Chart) {
        IAxisLabelFormatter presetFormatter = axis.getFormatter();
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu formatterMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Label formatter", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Label formatter");
        JMenu numberMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Numbers", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Numbers");
        formatterMenu.add(numberMenu);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        ALabelFormatter formatter = new LabelFormatterNumber(nf);
        AxisActionSetFormatter action = new AxisActionSetFormatter(chart, "Whole numbers", axisDimension, formatter);
        boolean selected = ((Object)formatter).equals(presetFormatter);
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        numberMenu.add(item);
        nf = new DecimalFormat("#.#");
        formatter = new LabelFormatterNumber(nf);
        action = new AxisActionSetFormatter(chart, "1 fraction digit", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        numberMenu.add(item);
        nf = new DecimalFormat("#.##");
        formatter = new LabelFormatterNumber(nf);
        action = new AxisActionSetFormatter(chart, "2 fraction digits", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        numberMenu.add(item);
        JMenu dateMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Date/Time", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Date/Time");
        formatterMenu.add(dateMenu);
        String dateTooltip = "This works only if your values are milliseconds since January 1st 1970 (System.currentTimeMillis()).";
        dateMenu.setToolTipText(dateTooltip);
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date (short)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        df = (SimpleDateFormat)DateFormat.getDateInstance(2);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date (medium)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        df = (SimpleDateFormat)DateFormat.getDateInstance(1);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date (long)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date & Time (short)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date & Time (medium)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        df = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        formatter = new LabelFormatterDate(df);
        action = new AxisActionSetFormatter(chart, "Date & Time (long)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        item.setToolTipText(dateTooltip);
        buttonGroup.add(item);
        dateMenu.add(item);
        formatter = new LabelFormatterAutoUnits();
        action = new AxisActionSetFormatter(chart, "Automatic unit (pico,nano,femto...)", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        formatterMenu.add(item);
        nf = NumberFormat.getPercentInstance();
        formatter = new LabelFormatterNumber(nf);
        action = new AxisActionSetFormatter(chart, "Percent", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        formatterMenu.add(item);
        nf = NumberFormat.getCurrencyInstance();
        formatter = new LabelFormatterNumber(nf);
        action = new AxisActionSetFormatter(chart, "Currency (" + nf.getCurrency().getSymbol() + ")", axisDimension, formatter);
        selected = ((Object)formatter).equals(presetFormatter);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, action, selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(action, selected);
        buttonGroup.add(item);
        formatterMenu.add(item);
        return formatterMenu;
    }

    public JMenuItem createAxisMenuItem(IAxis axis, int axisDimension, boolean adaptUI2Chart) {
        Chart2D chart = axis.getAccessor().getChart();
        JMenu axisMenuItem = adaptUI2Chart ? new PropertyChangeMenu(chart, "Axis" + axis.getAccessor().toString(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Axis" + axis.getAccessor().toString());
        if (this.m_showAxisXTypeMenu && axisDimension == 1 || this.m_showAxisYTypeMenu && axisDimension == 2) {
            ((Container)axisMenuItem).add(this.createAxisTypeMenu(chart, axis, axisDimension, adaptUI2Chart));
        }
        if (this.m_showAxisFormatterMenu) {
            ((Container)axisMenuItem).add(this.createAxisFormatterMenu(chart, axis, axisDimension, adaptUI2Chart));
        }
        if (this.m_showAxisXRangePolicyMenu && axisDimension == 1 || this.m_showAxisYRangePolicyMenu && axisDimension == 2) {
            ((Container)axisMenuItem).add(this.createAxisRangePolicyMenu(chart, axis, adaptUI2Chart));
            JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new AxisActionSetRange(chart, "Range", axisDimension), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new AxisActionSetRange(chart, "Range", axisDimension));
            if (!AxisActionSetRange.RANGE_CHOOSER_SUPPORTED) {
                item.setToolTipText("This is disabled as bislider.jar is missing on the class path.");
            }
            ((Container)axisMenuItem).add(item);
        }
        if (this.m_showAxisXTitleMenu && axisDimension == 1 || this.m_showAxisYTitleMenu && axisDimension == 2) {
            ((Container)axisMenuItem).add(this.createAxisTitleMenu(chart, axis, axisDimension, adaptUI2Chart));
        }
        return axisMenuItem;
    }

    public JMenu createAxisRangePolicyMenu(Chart2D chart, IAxis axis, boolean adaptUI2Chart) {
        JMenu axisRangePolicy = adaptUI2Chart ? new PropertyChangeMenu(chart, "Range policy", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Range policy");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> rangePolicyClass = axis.getRangePolicy().getClass();
        boolean selected = rangePolicyClass == RangePolicyFixedViewport.class;
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new AxisActionSetRangePolicy(chart, "Fixed viewport", axis.getDimension(), new RangePolicyFixedViewport()), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart, "Fixed viewport", axis.getDimension(), new RangePolicyFixedViewport()), selected);
        item.setToolTipText("Zooms or expands to the configured range without respect to the data to display. ");
        axisRangePolicy.add(item);
        buttonGroup.add(item);
        selected = rangePolicyClass == RangePolicyUnbounded.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new AxisActionSetRangePolicy(chart, "Minimum viewport", axis.getDimension(), new RangePolicyUnbounded()), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart, "Minimum viewport", axis.getDimension(), new RangePolicyUnbounded()), selected);
        axisRangePolicy.add(item);
        item.setToolTipText("Ensures all data is shown with minimal bounds.");
        buttonGroup.add(item);
        selected = rangePolicyClass == RangePolicyMinimumViewport.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new AxisActionSetRangePolicy(chart, "Minimum viewport with range", axis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0))), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart, "Minimum viewport with range", axis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0))), selected);
        item.setToolTipText("Ensures that all data is shown and expands if range is higher. ");
        axisRangePolicy.add(item);
        buttonGroup.add(item);
        selected = rangePolicyClass == RangePolicyForcedPoint.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new AxisActionSetRangePolicy(chart, "Ensure visible point", axis.getDimension(), new RangePolicyForcedPoint(0.0)), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart, "Ensure visible point", axis.getDimension(), new RangePolicyForcedPoint(0.0)), selected);
        item.setToolTipText("Only the minimum value of the axis' range will be ensured to be visible.");
        axisRangePolicy.add(item);
        buttonGroup.add(item);
        selected = rangePolicyClass == RangePolicyHighestValues.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new AxisActionSetRangePolicy(chart, "Highest points within max-50 to max.", axis.getDimension(), new RangePolicyHighestValues(50)), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart, "Highest points within max-50 to max.", axis.getDimension(), new RangePolicyHighestValues(50)), selected);
        item.setToolTipText("Shows the highest values from max-50 to max.");
        axisRangePolicy.add(item);
        buttonGroup.add(item);
        return axisRangePolicy;
    }

    public JMenu createAxisTitleMenu(Chart2D chart, IAxis axis, int axisDimension, boolean adaptUI2Chart) {
        JMenu axisTitle = adaptUI2Chart ? new PropertyChangeMenu(chart, "Title", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Title");
        JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new AxisActionSetTitle(chart, "Title", axisDimension), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new AxisActionSetTitle(chart, "Title", axisDimension));
        axisTitle.add(item);
        JMenu axisTitleFont = adaptUI2Chart ? new PropertyChangeMenu(chart, "Font", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Font");
        Font[] fonts = LayoutFactory.getSystemFonts(14.0f);
        for (int i = fonts.length - 1; i > -1; --i) {
            item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new AxisActionSetTitleFont(chart, fonts[i].getName(), axisDimension, fonts[i]), axisTitleFont, false, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new OrderingCheckBoxMenuItem(new AxisActionSetTitleFont(chart, fonts[i].getName(), axisDimension, fonts[i]), axisTitleFont, false);
            item.setFont(fonts[i]);
            axisTitleFont.add(item);
        }
        axisTitle.add(axisTitleFont);
        return axisTitle;
    }

    public JMenu createAxisTypeMenu(Chart2D chart, IAxis axis, int axisDimension, boolean adaptUI2Chart) {
        JMenu axisType = adaptUI2Chart ? new PropertyChangeMenu(chart, "Type", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Type");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> typeClass = axis.getClass();
        boolean selected = typeClass == AxisLinear.class;
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetAxis(chart, new AxisLinear(), "Linear", axisDimension), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart, new AxisLinear(), "Linear", axisDimension), selected);
        axisType.add(item);
        buttonGroup.add(item);
        selected = typeClass == AxisLogE.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetAxis(chart, new AxisLogE(), "Log E", axisDimension), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart, new AxisLogE(), "Log E", axisDimension), selected);
        axisType.add(item);
        buttonGroup.add(item);
        selected = typeClass == AxisLog10.class;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetAxis(chart, new AxisLog10(), "Log 10", axisDimension), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart, new AxisLog10(), "Log 10", axisDimension), selected);
        axisType.add(item);
        buttonGroup.add(item);
        return axisType;
    }

    public JMenu createBackgroundColorMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        Color backgroundColor = chartPanel.getBackground();
        boolean nonStandardColor = true;
        JMenu bgColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Background color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Background color");
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean selected = backgroundColor.equals(Color.WHITE);
        nonStandardColor &= !selected;
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "White", Color.WHITE), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "White", Color.WHITE), selected);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        selected = backgroundColor.equals(Color.GRAY);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Gray", Color.GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Gray", Color.GRAY), selected);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        selected = backgroundColor.equals(Color.LIGHT_GRAY);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Light gray", Color.LIGHT_GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Light gray", Color.LIGHT_GRAY), selected);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        selected = backgroundColor.equals(Color.BLACK);
        boolean bl = !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Black", Color.BLACK), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Black", Color.BLACK), selected);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, JComponentActionSetCustomBackgroundSingleton.getInstance(chart, "Custom Color"), nonStandardColor, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomBackgroundSingleton.getInstance(chart, "Custom Color"), nonStandardColor &= bl);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        return bgColorMenu;
    }

    public JMenuItem createChartGridMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        JCheckBoxMenuItem item;
        Chart2D chart = chartPanel.getChart();
        JMenu gridMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Grid", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Grid");
        if (this.m_showGridColorMenu) {
            gridMenu.add(this.createGridColorMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showAxisXGridMenu) {
            item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new AxisActionSetGrid(chart, "Grid X", 1), chart.getAxisX().isPaintGrid(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new AxisActionSetGrid(chart, "Grid X", 1), chart.getAxisX().isPaintGrid());
            gridMenu.add(item);
        }
        if (this.m_showAxisYGridMenu) {
            item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new AxisActionSetGrid(chart, "Grid Y", 2), chart.getAxisY().isPaintGrid(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new AxisActionSetGrid(chart, "Grid Y", 2), chart.getAxisX().isPaintGrid());
            gridMenu.add(item);
        }
        return gridMenu;
    }

    public JMenuItem createChartHighlightMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        JMenu highlightMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Highlighting", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Highlighting");
        boolean isEnabledHighlighting = chart.isEnabledPointHighlighting();
        JMenuItem item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new Chart2DActionEnableHighlighting(chart, "Enable"), isEnabledHighlighting, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionEnableHighlighting(chart, "Enable"), isEnabledHighlighting);
        highlightMenu.add(item);
        if (this.m_showChartHighlighterMenu) {
            highlightMenu.add(this.createChartTraceHighlighterMenu(chartPanel, adaptUI2Chart));
        }
        return highlightMenu;
    }

    public JMenu createChartMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        JMenuItem item;
        Chart2D chart = chartPanel.getChart();
        JMenu chartMenu = adaptUI2Chart ? new PropertyChangeMenu(chartPanel, "Chart", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Chart");
        if (this.m_showChartBackgroundMenu) {
            chartMenu.add(this.createBackgroundColorMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showChartForegroundMenu) {
            chartMenu.add(this.createForegroundColorMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showAntialiasingMenu) {
            item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new Chart2DActionEnableAntialiasing(chart, "Antialiasing"), chart.isUseAntialiasing(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new Chart2DActionEnableAntialiasing(chart, "Antialiasing"), chart.isUseAntialiasing());
            item.setToolTipText("Antialiasing causes smoother edges but costs performance. ");
            chartMenu.add(item);
        }
        if (this.m_showGridMenu) {
            chartMenu.add(this.createChartGridMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showToolTipMenu) {
            chartMenu.add(this.createChartToolTipMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showHighlightMenu) {
            chartMenu.add(this.createChartHighlightMenu(chartPanel, adaptUI2Chart));
        }
        if (this.m_showAxisXMenu || this.m_showAxisYMenu) {
            JMenu axisMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Axis", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Axis");
            if (this.m_showAxisXMenu) {
                JMenuItem xAxisMenuItem = this.createAxisMenuItem(chart.getAxisX(), 1, adaptUI2Chart);
                axisMenu.add(xAxisMenuItem);
            }
            if (this.m_showAxisYMenu) {
                JMenuItem yAxisMenuItem = this.createAxisMenuItem(chart.getAxisY(), 2, adaptUI2Chart);
                axisMenu.add(yAxisMenuItem);
            }
            chartMenu.add(axisMenu);
        }
        if (this.m_showSaveMenu) {
            item = this.createSaveMenu(chartPanel, adaptUI2Chart);
            chartMenu.add(item);
        }
        if (this.m_showPrintMenu) {
            item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, Chart2DActionPrintSingleton.getInstance(chart, "Print chart"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(Chart2DActionPrintSingleton.getInstance(chart, "Print chart"));
            chartMenu.add(item);
        }
        if (this.m_showAnnotationMenu) {
            item = this.createAnnoationsMenu(chartPanel, adaptUI2Chart);
            chartMenu.add(item);
        }
        if (chart instanceof ZoomableChart && this.m_showZoomOutMenu) {
            item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new ZoomableChartZoomOutAction((ZoomableChart)chart, "Zoom Out"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuItem(new ZoomableChartZoomOutAction((ZoomableChart)chart, "Zoom Out"));
            chartMenu.add(item);
        }
        return chartMenu;
    }

    public JMenuBar createChartMenuBar(ChartPanel chartPanel, boolean adaptUI2Chart) {
        JMenu chartMenu = this.createChartMenu(chartPanel, adaptUI2Chart);
        JMenuBar menubar = adaptUI2Chart ? new PropertyChangeJMenuBar(chartPanel, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenuBar();
        menubar.add(chartMenu);
        return menubar;
    }

    public void createChartPopupMenu(ChartPanel chartpanel, boolean adaptUI2Chart) {
        JPopupMenu popup = adaptUI2Chart ? new PropertyChangePopupMenu(chartpanel.getChart(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JPopupMenu();
        JMenu menu = this.createChartMenu(chartpanel, adaptUI2Chart);
        for (Component component : menu.getMenuComponents()) {
            menu.remove(component);
            popup.add(component);
        }
        PopupListener listener = new PopupListener(popup);
        chartpanel.getChart().addMouseListener(listener);
    }

    public JMenu createChartSetToolTipTypeMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        JMenu tooltipMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Type", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Type");
        IToolTipType actualType = chart.getToolTipType();
        ButtonGroup buttonGroup = new ButtonGroup();
        Chart2D.ToolTipType type = Chart2D.ToolTipType.NONE;
        boolean selected = actualType.getClass() == type.getClass();
        JMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new ChartActionSetToolTipType(chart, type.getDescription(), type), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart, type.getDescription(), type), selected);
        buttonGroup.add(item);
        tooltipMenu.add(item);
        type = Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS;
        selected = actualType.getClass() == type.getClass();
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new ChartActionSetToolTipType(chart, type.getDescription(), type), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart, type.getDescription(), type), selected);
        buttonGroup.add(item);
        tooltipMenu.add(item);
        type = Chart2D.ToolTipType.DATAVALUES;
        selected = actualType.getClass() == type.getClass();
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new ChartActionSetToolTipType(chart, type.getDescription(), type), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart, type.getDescription(), type), selected);
        buttonGroup.add(item);
        tooltipMenu.add(item);
        type = Chart2D.ToolTipType.PIXEL;
        selected = actualType.getClass() == type.getClass();
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new ChartActionSetToolTipType(chart, type.getDescription(), type), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJCheckBoxMenuItem(new ChartActionSetToolTipType(chart, type.getDescription(), type), selected);
        buttonGroup.add(item);
        tooltipMenu.add(item);
        return tooltipMenu;
    }

    public JMenuItem createChartToolTipMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        JMenu tooltipMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Tool tips", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Tool tips");
        if (this.m_showToolTipTypeMenu) {
            tooltipMenu.add(this.createChartSetToolTipTypeMenu(chartPanel, adaptUI2Chart));
        }
        return tooltipMenu;
    }

    public JMenu createChartTraceHighlighterMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        JMenu result = adaptUI2Chart ? new PropertyChangeMenu(chart, "Highlighter", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Highlighter");
        for (ITrace2D trace : chart.getTraces()) {
            JMenu traceMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, trace.getName(), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu(trace.getName());
            result.add(traceMenu);
            List<JMenuItem> highlighterItems = this.createTraceHighlighterItems(trace, adaptUI2Chart);
            for (JMenuItem item : highlighterItems) {
                traceMenu.add(item);
            }
        }
        return result;
    }

    public JMenu createErrorBarWizardMenu(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        JMenu errorBarMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "error bar policies", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("error bar policies");
        JMenu errorBarAddMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "+", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("+");
        errorBarMenu.add(errorBarAddMenu);
        JMenu errorBarRemoveMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "-", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("-");
        errorBarMenu.add(errorBarRemoveMenu);
        JMenu erroBarEditMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "edit", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("edit");
        errorBarMenu.add(erroBarEditMenu);
        LinkedList<JMenu> group1 = new LinkedList<JMenu>();
        group1.add(erroBarEditMenu);
        group1.add(errorBarRemoveMenu);
        LinkedList<JMenu> group2 = new LinkedList<JMenu>();
        group2.add(errorBarAddMenu);
        TreeSet<AErrorBarPolicyConfigurable> allErrorBarPolicies = new TreeSet<AErrorBarPolicyConfigurable>();
        allErrorBarPolicies.add(new ErrorBarPolicyRelative(0.02, 0.02));
        allErrorBarPolicies.add(new ErrorBarPolicyAbsoluteSummation(4.0, 4.0));
        Set<IErrorBarPolicy<?>> errorBarPolicies = trace.getErrorBarPolicies();
        for (IErrorBarPolicy<?> errorBarPolicy : errorBarPolicies) {
            JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu));
            erroBarEditMenu.add(item);
        }
        TreeSet addableErrorBarPolicies = new TreeSet(allErrorBarPolicies);
        for (IErrorBarPolicy<?> iErrorBarPolicy : errorBarPolicies) {
            addableErrorBarPolicies.remove(iErrorBarPolicy);
        }
        for (IErrorBarPolicy<Object> iErrorBarPolicy : addableErrorBarPolicies) {
            if (adaptUI2Chart) {
                errorBarAddMenu.add(new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)));
                continue;
            }
            errorBarAddMenu.add(new JMenuItem(new ErrorBarPolicyMultiAction(trace, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
        }
        for (IErrorBarPolicy<Object> iErrorBarPolicy : errorBarPolicies) {
            if (adaptUI2Chart) {
                errorBarRemoveMenu.add(new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)));
                continue;
            }
            errorBarRemoveMenu.add(new JMenuItem(new ErrorBarPolicyMultiAction(trace, iErrorBarPolicy.getClass().getName(), iErrorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
        }
        return errorBarMenu;
    }

    public JMenuItem createForegroundColorMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        Color foregroundColor = chart.getForeground();
        boolean nonStandardColor = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu fgColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Foreground color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Foreground color");
        boolean selected = foregroundColor.equals(Color.WHITE);
        nonStandardColor &= !selected;
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "White", Color.WHITE), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "White", Color.WHITE), selected);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        selected = foregroundColor.equals(Color.GRAY);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chartPanel.getChart(), "Gray", Color.GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Gray", Color.GRAY), selected);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        selected = foregroundColor.equals(Color.LIGHT_GRAY);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chartPanel.getChart(), "Light gray", Color.LIGHT_GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Light gray", Color.LIGHT_GRAY), selected);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        selected = foregroundColor.equals(Color.BLACK);
        boolean bl = !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "Black", Color.BLACK), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Black", Color.BLACK), selected);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chartPanel.getChart(), JComponentActionSetCustomForegroundSingleton.getInstance(chartPanel.getChart(), "Custom Color"), nonStandardColor, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomForegroundSingleton.getInstance(chartPanel.getChart(), "Custom Color"), nonStandardColor &= bl);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        return fgColorMenu;
    }

    public JMenu createGridColorMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        Chart2D chart = chartPanel.getChart();
        Color gridColor = chart.getGridColor();
        boolean nonStandardColor = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu gridColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Grid color", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new JMenu("Grid color");
        boolean selected = gridColor.equals(Color.GRAY);
        nonStandardColor &= !selected;
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Gray", Color.GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Gray", Color.GRAY), selected);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        selected = gridColor.equals(Color.LIGHT_GRAY);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Light gray", Color.LIGHT_GRAY), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Light gray", Color.LIGHT_GRAY), selected);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        selected = gridColor.equals(Color.BLACK);
        nonStandardColor &= !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Black", Color.BLACK), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Black", Color.BLACK), selected);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        selected = gridColor.equals(Color.WHITE);
        boolean bl = !selected;
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "White", Color.WHITE), selected, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "White", Color.WHITE), selected);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, Chart2DActionSetCustomGridColorSingleton.getInstance(chart, "Custom"), nonStandardColor, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance()) : new SelectionAdaptJRadioButtonMenuItem(Chart2DActionSetCustomGridColorSingleton.getInstance(chart, "Custom"), nonStandardColor &= bl);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        return gridColorMenu;
    }

    public JMenu createSaveMenu(ChartPanel chartPanel, boolean adaptUI2Chart) {
        JMenuItem item;
        JMenu result;
        Chart2D chart = chartPanel.getChart();
        Action action = Chart2DActionSaveEpsSingletonApacheFop.getInstance(chart, "Save eps");
        if (adaptUI2Chart) {
            result = new PropertyChangeMenu(chart, "Save", BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            item = new PropertyChangeMenuItem(chart, Chart2DActionSaveImageSingleton.getInstance(chart, "Save image"), BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            result.add(item);
            if (this.m_showSaveEpsMenu) {
                item = new PropertyChangeMenuItem(chart, action, BasicPropertyAdaptSupport.RemoveAsListenerFromComponentNever.getInstance());
            }
        } else {
            result = new JMenu("Save");
            item = new JMenuItem(Chart2DActionSaveImageSingleton.getInstance(chart, "Save image"));
            result.add(item);
            if (this.m_showSaveEpsMenu) {
                item = new JMenuItem(action);
            }
        }
        if (!Chart2DActionSaveEpsSingletonApacheFop.EPS_SUPPORTED) {
            item.setToolTipText("This is disabled as xmlgraphics-commons-<version>.jar is missing on the classpath.");
        }
        result.add(item);
        return result;
    }

    public JMenu createTraceColorMenu(Chart2D chart, ITrace2D trace, JComponent parent, boolean adaptUI2Chart) {
        JMenu colorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Color", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("Color");
        JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Red", Color.RED), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Red", Color.RED));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Green", Color.GREEN), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Green", Color.GREEN));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Blue", Color.BLUE), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Blue", Color.BLUE));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Gray", Color.GRAY), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Gray", Color.GRAY));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Magenta", Color.MAGENTA), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Magenta", Color.MAGENTA));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Pink", Color.PINK), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Pink", Color.PINK));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetColor(trace, "Black", Color.BLACK), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetColor(trace, "Black", Color.BLACK));
        colorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetCustomColor(trace, "Custom", parent), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetCustomColor(trace, "Custom", parent));
        colorMenu.add(item);
        return colorMenu;
    }

    public JLabel createTraceContextMenuLabel(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        String traceLabel = trace.getLabel();
        TraceJLabel ret = null;
        if (!StringUtil.isEmpty(traceLabel)) {
            JMenuItem item;
            ret = new TraceJLabel(trace);
            PropertyChangePopupMenu popup = new PropertyChangePopupMenu(chart, new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace));
            Color background = chart.getBackground();
            ret.setBackground(background);
            ret.setForeground(trace.getColor());
            if (this.m_showTraceVisibleMenu) {
                item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new Trace2DActionSetVisible(trace, "Visible"), trace.isVisible(), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new SelectionAdaptJCheckBoxMenuItem(new Trace2DActionSetVisible(trace, "Visible"), trace.isVisible());
                popup.add(item);
            }
            if (this.m_showTraceNameMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetName(trace, "Name", chart), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetName(trace, "Name", chart));
                popup.add(item);
            }
            if (this.m_showPhysicalUnitsMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetPhysicalUnits(trace, "Physical Units", chart), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetPhysicalUnits(trace, "Physical Units", chart));
                popup.add(item);
            }
            if (this.m_showTraceColorMenu) {
                popup.add(this.createTraceColorMenu(chart, trace, ret, adaptUI2Chart));
            }
            if (this.m_showTraceZindexMenu) {
                popup.add(this.createTraceZindexMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showTraceStrokeMenu) {
                popup.add(this.createTraceStrokesMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showTracePainterMenu) {
                popup.add(this.createTracePainterMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showTraceHighlighterMenu) {
                popup.add(this.createTraceHighlighterMenu(trace, adaptUI2Chart));
            }
            if (this.m_showRemoveTraceMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionRemove(trace, "Remove"), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionRemove(trace, "Remove"));
                popup.add(item);
            }
            if (this.m_showErrorBarWizardMenu) {
                popup.add(this.createErrorBarWizardMenu(chart, trace, adaptUI2Chart));
            }
            ret.addMouseListener(new PopupListener(popup));
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_COLOR", ret);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", ret);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", ret);
        }
        return ret;
    }

    private List<JMenuItem> createTraceHighlighterItems(ITrace2D trace, boolean adaptUI2Chart) {
        LinkedList<JMenuItem> result = new LinkedList<JMenuItem>();
        PointPainterDisc pointPainterFilledDisc = new PointPainterDisc(20);
        pointPainterFilledDisc.setColorFill(new Color(255, 254, 233, 136));
        pointPainterFilledDisc.setTransparencyFill(200);
        pointPainterFilledDisc.setColor(Color.BLACK);
        pointPainterFilledDisc.setTransparency(255);
        pointPainterFilledDisc.setStroke(new BasicStroke(3.0f));
        IPointPainter[] highlighters = new IPointPainter[]{new PointPainterDisc(10), new PointPainterDisc(20), pointPainterFilledDisc};
        String[] highlighterNames = new String[]{"Small disc", "Big disc", "Big disc filled yellow"};
        for (int i = 0; i < highlighters.length; ++i) {
            IPointPainter highlighter = highlighters[i];
            JCheckBoxMenuItem item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(trace.getRenderer(), new Trace2DActionAddRemoveHighlighter(trace, highlighterNames[i], highlighter), false, new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new SelectionAdaptJCheckBoxMenuItem(new Trace2DActionAddRemoveHighlighter(trace, highlighterNames[i], highlighter), false);
            result.add(item);
        }
        return result;
    }

    private JMenuItem createTraceHighlighterMenu(ITrace2D trace, boolean adaptUI2Chart) {
        JMenu result = adaptUI2Chart ? new PropertyChangeMenu(trace.getRenderer(), "Highlighting", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("Highlighting");
        List<JMenuItem> highlighterItems = this.createTraceHighlighterItems(trace, adaptUI2Chart);
        for (JMenuItem item : highlighterItems) {
            ((Container)result).add(item);
        }
        return result;
    }

    public JMenu createTracePainterMenu(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        JMenu painterMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "renderer", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("renderer");
        ATracePainter painter = new TracePainterDisc(4);
        OrderingCheckBoxMenuItem item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new Trace2DActionAddRemoveTracePainter(trace, "discs", painter), painterMenu, trace.containsTracePainter(painter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(trace, "discs", painter), painterMenu, trace.containsTracePainter(painter));
        painterMenu.add(item);
        painter = new TracePainterPolyline();
        item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new Trace2DActionAddRemoveTracePainter(trace, "line", painter), painterMenu, trace.containsTracePainter(painter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(trace, "line", painter), painterMenu, trace.containsTracePainter(painter));
        painterMenu.add(item);
        painter = new TracePainterFill(chart);
        item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new Trace2DActionAddRemoveTracePainter(trace, "fill", painter), painterMenu, trace.containsTracePainter(painter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(trace, "fill", painter), painterMenu, trace.containsTracePainter(painter));
        painterMenu.add(item);
        painter = new TracePainterVerticalBar(chart);
        item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new Trace2DActionAddRemoveTracePainter(trace, "bar", painter), painterMenu, trace.containsTracePainter(painter), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(trace, "bar", painter), painterMenu, trace.containsTracePainter(painter));
        painterMenu.add(item);
        if (trace.getTracePainters().contains(painter)) {
            item.setSelected(true);
        }
        return painterMenu;
    }

    public JMenu createTraceStrokesMenu(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        JMenu strokesMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Stroke", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("Stroke");
        for (int i = 0; i < this.m_strokes.length; ++i) {
            JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetStroke(trace, this.m_strokeNames[i], this.m_strokes[i]), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetStroke(trace, this.m_strokeNames[i], this.m_strokes[i]));
            strokesMenu.add(item);
        }
        return strokesMenu;
    }

    public JMenu createTraceZindexMenu(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        JMenu zIndexMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "layer", new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenu("layer");
        JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetZindex(trace, "bring to front", 0), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetZindex(trace, "bring to front", 0));
        zIndexMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetZindex(trace, "send to back", 100), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionSetZindex(trace, "send to back", 100));
        zIndexMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionZindexDecrease(trace, "forward", 2), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionZindexDecrease(trace, "forward", 2));
        zIndexMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionZindexIncrease(trace, "backwards", 2), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace)) : new JMenuItem(new Trace2DActionZindexIncrease(trace, "backwards", 2));
        zIndexMenu.add(item);
        return zIndexMenu;
    }

    public final boolean isShowAnnotationMenu() {
        return this.m_showAnnotationMenu;
    }

    public boolean isShowAntialiasingMenu() {
        return this.m_showAntialiasingMenu;
    }

    public boolean isShowAxisFormatterMenu() {
        return this.m_showAxisFormatterMenu;
    }

    public final boolean isShowAxisXGridMenu() {
        return this.m_showAxisXGridMenu;
    }

    public final boolean isShowAxisXMenu() {
        return this.m_showAxisXMenu;
    }

    public final boolean isShowAxisXRangePolicyMenu() {
        return this.m_showAxisXRangePolicyMenu;
    }

    public final boolean isShowAxisXTitleMenu() {
        return this.m_showAxisXTitleMenu;
    }

    public final boolean isShowAxisXTypeMenu() {
        return this.m_showAxisXTypeMenu;
    }

    public final boolean isShowAxisYGridMenu() {
        return this.m_showAxisYGridMenu;
    }

    public final boolean isShowAxisYMenu() {
        return this.m_showAxisYMenu;
    }

    public final boolean isShowAxisYRangePolicyMenu() {
        return this.m_showAxisYRangePolicyMenu;
    }

    public final boolean isShowAxisYTitleMenu() {
        return this.m_showAxisYTitleMenu;
    }

    public final boolean isShowAxisYTypeMenu() {
        return this.m_showAxisYTypeMenu;
    }

    public final boolean isShowChartBackgroundMenu() {
        return this.m_showChartBackgroundMenu;
    }

    public final boolean isShowChartForegroundMenu() {
        return this.m_showChartForegroundMenu;
    }

    public boolean isShowChartHighlighterMenu() {
        return this.m_showChartHighlighterMenu;
    }

    public final boolean isShowErrorBarWizardMenu() {
        return this.m_showErrorBarWizardMenu;
    }

    public final boolean isShowGridColorMenu() {
        return this.m_showGridColorMenu;
    }

    public boolean isShowGridMenu() {
        return this.m_showGridMenu;
    }

    public boolean isShowHighlightMenu() {
        return this.m_showHighlightMenu;
    }

    public final boolean isShowPhysicalUnitsMenu() {
        return this.m_showPhysicalUnitsMenu;
    }

    public final boolean isShowPrintMenu() {
        return this.m_showPrintMenu;
    }

    public final boolean isShowRemoveTraceMenu() {
        return this.m_showRemoveTraceMenu;
    }

    public final boolean isShowSaveEpsMenu() {
        return this.m_showSaveEpsMenu;
    }

    public final boolean isShowSaveMenu() {
        return this.m_showSaveMenu;
    }

    public boolean isShowToolTipMenu() {
        return this.m_showToolTipMenu;
    }

    public boolean isShowToolTipTypeMenu() {
        return this.m_showToolTipTypeMenu;
    }

    public final boolean isShowTraceColorMenu() {
        return this.m_showTraceColorMenu;
    }

    public boolean isShowTraceHighlighterMenu() {
        return this.m_showTraceHighlighterMenu;
    }

    public final boolean isShowTraceNameMenu() {
        return this.m_showTraceNameMenu;
    }

    public final boolean isShowTracePainterMenu() {
        return this.m_showTracePainterMenu;
    }

    public final boolean isShowTraceStrokeMenu() {
        return this.m_showTraceStrokeMenu;
    }

    public final boolean isShowTraceVisibleMenu() {
        return this.m_showTraceVisibleMenu;
    }

    public final boolean isShowTraceZindexMenu() {
        return this.m_showTraceZindexMenu;
    }

    public final boolean isShowZoomOutMenu() {
        return this.m_showZoomOutMenu;
    }

    public final boolean isZoomOutMenu() {
        return this.m_showZoomOutMenu;
    }

    public final void setShowAnnotationMenu(boolean showAnnotationMenu) {
        this.m_showAnnotationMenu = showAnnotationMenu;
    }

    public void setShowAntialiasingMenu(boolean showAntialiasingMenu) {
        this.m_showAntialiasingMenu = showAntialiasingMenu;
    }

    public void setShowAxisFormatterMenu(boolean showAxisFormatterMenu) {
        this.m_showAxisFormatterMenu = showAxisFormatterMenu;
    }

    public final void setShowAxisXGridMenu(boolean showAxisXGridMenu) {
        this.m_showAxisXGridMenu = showAxisXGridMenu;
    }

    public final void setShowAxisXMenu(boolean showAxisXMenu) {
        this.m_showAxisXMenu = showAxisXMenu;
    }

    public final void setShowAxisXRangePolicyMenu(boolean showAxisXRangePolicyMenu) {
        this.m_showAxisXRangePolicyMenu = showAxisXRangePolicyMenu;
    }

    public final void setShowAxisXTitleMenu(boolean showAxisXTitleMenu) {
        this.m_showAxisXTitleMenu = showAxisXTitleMenu;
    }

    public final void setShowAxisXTypeMenu(boolean showAxisXTypeMenu) {
        this.m_showAxisXTypeMenu = showAxisXTypeMenu;
    }

    public final void setShowAxisYGridMenu(boolean showAxisYGridMenu) {
        this.m_showAxisYGridMenu = showAxisYGridMenu;
    }

    public final void setShowAxisYMenu(boolean showAxisYMenu) {
        this.m_showAxisYMenu = showAxisYMenu;
    }

    public final void setShowAxisYRangePolicyMenu(boolean showAxisYRangePolicyMenu) {
        this.m_showAxisYRangePolicyMenu = showAxisYRangePolicyMenu;
    }

    public final void setShowAxisYTitleMenu(boolean showAxisYTitleMenu) {
        this.m_showAxisYTitleMenu = showAxisYTitleMenu;
    }

    public final void setShowAxisYTypeMenu(boolean showAxisYTypeMenu) {
        this.m_showAxisYTypeMenu = showAxisYTypeMenu;
    }

    public final void setShowChartBackgroundMenu(boolean showChartBackgroundMenu) {
        this.m_showChartBackgroundMenu = showChartBackgroundMenu;
    }

    public final void setShowChartForegroundMenu(boolean showChartForegroundMenu) {
        this.m_showChartForegroundMenu = showChartForegroundMenu;
    }

    public void setShowChartHighlighterMenu(boolean showChartHighlighterMenu) {
        this.m_showChartHighlighterMenu = showChartHighlighterMenu;
    }

    public final void setShowErrorBarWizardMenu(boolean showErrorBarWizardMenu) {
        this.m_showErrorBarWizardMenu = showErrorBarWizardMenu;
    }

    public final void setShowGridColorMenu(boolean showGridColorMenu) {
        this.m_showGridColorMenu = showGridColorMenu;
    }

    public void setShowGridMenu(boolean showGridMenu) {
        this.m_showGridMenu = showGridMenu;
    }

    public void setShowHighlightMenu(boolean showHighlightMenu) {
        this.m_showHighlightMenu = showHighlightMenu;
    }

    public final void setShowPhysicalUnitsMenu(boolean showPhysicalUnitsMenu) {
        this.m_showPhysicalUnitsMenu = showPhysicalUnitsMenu;
    }

    public final void setShowPrintMenu(boolean showPrintMenu) {
        this.m_showPrintMenu = showPrintMenu;
    }

    public final void setShowRemoveTraceMenu(boolean showRemoveTraceMenu) {
        this.m_showRemoveTraceMenu = showRemoveTraceMenu;
    }

    public final void setShowSaveEpsMenu(boolean showSaveEpsMenu) {
        this.m_showSaveEpsMenu = showSaveEpsMenu;
    }

    public final void setShowSaveMenu(boolean showSaveMenu) {
        this.m_showSaveMenu = showSaveMenu;
    }

    public void setShowTooltipEnableMenu(boolean showToolTipTypeMenu) {
        this.m_showToolTipTypeMenu = showToolTipTypeMenu;
    }

    public void setShowToolTipMenu(boolean showToolTipMenu) {
        this.m_showToolTipMenu = showToolTipMenu;
    }

    public final void setShowTraceColorMenu(boolean showTraceColorMenu) {
        this.m_showTraceColorMenu = showTraceColorMenu;
    }

    public void setShowTraceHighlighterMenu(boolean showTraceHighlighterMenu) {
        this.m_showTraceHighlighterMenu = showTraceHighlighterMenu;
    }

    public final void setShowTraceNameMenu(boolean showTraceNameMenu) {
        this.m_showTraceNameMenu = showTraceNameMenu;
    }

    public final void setShowTracePainterMenu(boolean showTracePainterMenu) {
        this.m_showTracePainterMenu = showTracePainterMenu;
    }

    public final void setShowTraceStrokeMenu(boolean showTraceStrokeMenu) {
        this.m_showTraceStrokeMenu = showTraceStrokeMenu;
    }

    public final void setShowTraceVisibleMenu(boolean showTraceVisibleMenu) {
        this.m_showTraceVisibleMenu = showTraceVisibleMenu;
    }

    public final void setShowTraceZindexMenu(boolean showTraceZindexMenu) {
        this.m_showTraceZindexMenu = showTraceZindexMenu;
    }

    public final void setShowZoomOutMenu(boolean showZoomOutMenu) {
        this.m_showZoomOutMenu = showZoomOutMenu;
    }

    public final void setZoomOutMenu(boolean showZoomOutMenu) {
        this.m_showZoomOutMenu = showZoomOutMenu;
    }

    final class TraceJLabel
    extends JLabel
    implements PropertyChangeListener {
        public TraceJLabel(ITrace2D trace) {
            super(trace.getLabel());
            new BasicPropertyAdaptSupport(this, trace.getRenderer(), new BasicPropertyAdaptSupport.RemoveAsListenerFromComponentIfTraceIsDropped(trace));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("ITrace2D.PROPERTY_COLOR")) {
                Color background;
                Color color = (Color)evt.getNewValue();
                if (color.equals(background = this.getBackground())) {
                    this.setBackground(this.getForeground());
                }
                this.setForeground(color);
            } else if (propertyName.equals("background")) {
                Color foreground;
                Color background = (Color)evt.getNewValue();
                if (background.equals(foreground = this.getForeground())) {
                    this.setForeground(this.getBackground());
                }
                this.setBackground(background);
            } else if (propertyName.equals("font")) {
                Font font = (Font)evt.getNewValue();
                this.setFont(font);
            } else if (propertyName.equals("ITrace2D.PROPERTY_NAME")) {
                ITrace2D source = (ITrace2D)evt.getSource();
                this.setText(source.getLabel());
            } else if (propertyName.equals("ITrace2D.PROPERTY_PHYSICALUNITS")) {
                ITrace2D source = (ITrace2D)evt.getSource();
                this.setText(source.getLabel());
            }
        }
    }

    public static class SelectionPropertyAdaptSupport
    implements PropertyChangeListener {
        protected WeakReference<AbstractButton> m_delegate;

        public SelectionPropertyAdaptSupport(AbstractButton delegate) {
            this.m_delegate = new WeakReference<AbstractButton>(delegate);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            AbstractButton button = (AbstractButton)this.m_delegate.get();
            if (button != null) {
                if (prop.equals("")) {
                    boolean state = (Boolean)evt.getNewValue();
                    button.setSelected(state);
                    button.invalidate();
                    button.repaint();
                }
            } else {
                ((Component)evt.getSource()).removePropertyChangeListener(this);
            }
        }
    }

    private static class SelectionAdaptJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        public SelectionAdaptJRadioButtonMenuItem(Action action, boolean selected) {
            super(action);
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class SelectionAdaptJCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public SelectionAdaptJCheckBoxMenuItem(Action action, boolean state) {
            super(action);
            this.setSelected(state);
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangePopupMenu
    extends JPopupMenu {
        public PropertyChangePopupMenu(JComponent component, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }
    }

    public static class PropertyChangeMenuItem
    extends JMenuItem {
        private WeakReference<JComponent> m_component;

        public PropertyChangeMenuItem(JComponent component, Action action, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            super(action);
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
            this.m_component = new WeakReference<JComponent>(component);
        }

        public JComponent getUIAdaptee() {
            return (JComponent)this.m_component.get();
        }
    }

    private static class PropertyChangeMenu
    extends JMenu {
        public PropertyChangeMenu(JComponent component, String name, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            super(name);
            this.setOpaque(true);
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }
    }

    private static class PropertyChangeJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        public PropertyChangeJRadioButtonMenuItem(JComponent component, Action action, boolean selected, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            super(action);
            this.setSelected(selected);
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangeJMenuBar
    extends JMenuBar {
        public PropertyChangeJMenuBar(JComponent component, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }
    }

    public static class PropertyChangeCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public static final String PROPERTY_SELECTED = "";

        public PropertyChangeCheckBoxMenuItem(JComponent component, Action action, boolean checked, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            super(action);
            this.setState(checked);
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class OrderingCheckBoxPropertyChangeMenuItem
    extends OrderingCheckBoxMenuItem {
        public OrderingCheckBoxPropertyChangeMenuItem(JComponent component, Action action, JMenu container, boolean checked, BasicPropertyAdaptSupport.IRemoveAsListenerFromComponentCondition quitListeningOnBasicPropertyChangesControl) {
            super(action, container, checked);
            new BasicPropertyAdaptSupport(this, component, quitListeningOnBasicPropertyChangesControl);
        }
    }

    private static class OrderingCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        protected JMenu m_menu;

        public OrderingCheckBoxMenuItem(Action action, JMenu container, boolean checked) {
            this.setSelected(checked);
            this.m_menu = container;
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
            super.setAction(new JMenuOrderingAction(action));
        }

        private final class JMenuOrderingAction
        extends AbstractAction {
            private Action m_action;

            protected JMenuOrderingAction(Action delegate) {
                this.m_action = delegate;
            }

            public void actionPerformed(ActionEvent e) {
                this.m_action.actionPerformed(e);
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                boolean state = item.getState();
                if (state) {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add((Component)OrderingCheckBoxMenuItem.this, 0);
                } else {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add(OrderingCheckBoxMenuItem.this);
                }
            }

            public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
                this.m_action.addPropertyChangeListener(listener);
            }

            public boolean equals(Object obj) {
                return this.m_action.equals(obj);
            }

            public Object getValue(String key) {
                return this.m_action.getValue(key);
            }

            public int hashCode() {
                return this.m_action.hashCode();
            }

            public boolean isEnabled() {
                return this.m_action.isEnabled();
            }

            public void putValue(String key, Object value) {
                this.m_action.putValue(key, value);
            }

            public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
                this.m_action.removePropertyChangeListener(listener);
            }

            public void setEnabled(boolean b) {
                this.m_action.setEnabled(b);
            }

            public String toString() {
                return this.m_action.toString();
            }
        }
    }

    public static class BasicPropertyAdaptSupport
    implements PropertyChangeListener {
        private final IRemoveAsListenerFromComponentCondition m_stopListeningControl;
        private Component m_adaptee;
        protected WeakReference<Component> m_delegate;

        public BasicPropertyAdaptSupport(Component delegate, Component adaptee, IRemoveAsListenerFromComponentCondition quitListeningControl) {
            this.m_delegate = new WeakReference<Component>(delegate);
            this.m_adaptee = adaptee;
            this.m_stopListeningControl = quitListeningControl;
            delegate.setFont(adaptee.getFont());
            delegate.setBackground(adaptee.getBackground());
            delegate.setForeground(adaptee.getForeground());
            this.startListening();
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            Object reference = this.m_delegate.get();
            if (reference != null) {
                Component component = (Component)reference;
                if (prop.equals("foreground")) {
                    Color foreground;
                    Color color = (Color)evt.getNewValue();
                    if (!color.equals(foreground = component.getForeground())) {
                        component.setForeground(color);
                    }
                    component.setBackground(color);
                    component.repaint();
                } else if (prop.equals("font")) {
                    Font font = (Font)evt.getNewValue();
                    component.setFont(font);
                } else if (prop.equals("background")) {
                    Color background;
                    Color color = (Color)evt.getNewValue();
                    if (!color.equals(background = component.getBackground())) {
                        component.setBackground(color);
                    }
                } else if (this.m_stopListeningControl.isRemoveMeAsListenerComponentEvent(evt)) {
                    this.stopListening();
                }
            } else {
                this.stopListening();
            }
        }

        private void startListening() {
            this.m_adaptee.addPropertyChangeListener("foreground", this);
            this.m_adaptee.addPropertyChangeListener("background", this);
            this.m_adaptee.addPropertyChangeListener("font", this);
            for (String removeAsListenerProperty : this.m_stopListeningControl.getPropertyChangePropertiesToListenForRemovalOn()) {
                this.m_adaptee.addPropertyChangeListener(removeAsListenerProperty, this);
            }
        }

        private void stopListening() {
            this.m_adaptee.removePropertyChangeListener("font", this);
            this.m_adaptee.removePropertyChangeListener("background", this);
            this.m_adaptee.removePropertyChangeListener("foreground", this);
            for (String property : this.m_stopListeningControl.getPropertyChangePropertiesToListenForRemovalOn()) {
                this.m_adaptee.removePropertyChangeListener(property, this);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class RemoveAsListenerFromComponentNever
        implements IRemoveAsListenerFromComponentCondition {
            private static IRemoveAsListenerFromComponentCondition INSTANCE;

            public static IRemoveAsListenerFromComponentCondition getInstance() {
                if (INSTANCE == null) {
                    INSTANCE = new RemoveAsListenerFromComponentNever();
                }
                return INSTANCE;
            }

            private RemoveAsListenerFromComponentNever() {
            }

            @Override
            public Set<String> getPropertyChangePropertiesToListenForRemovalOn() {
                return Collections.emptySet();
            }

            @Override
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent event) {
                return false;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class RemoveAsListenerFromComponentIfTraceIsDropped
        implements IRemoveAsListenerFromComponentCondition {
            private static final Set<String> PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART = new TreeSet<String>();
            private final ITrace2D m_traceToWatchForRemoval;

            public RemoveAsListenerFromComponentIfTraceIsDropped(ITrace2D quitIfRemoved) {
                this.m_traceToWatchForRemoval = quitIfRemoved;
            }

            @Override
            public Set<String> getPropertyChangePropertiesToListenForRemovalOn() {
                return PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART;
            }

            @Override
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent event) {
                ITrace2D oldTrace;
                boolean result = false;
                String property = event.getPropertyName();
                if (PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART.contains(property) && (oldTrace = (ITrace2D)event.getOldValue()) == this.m_traceToWatchForRemoval) {
                    result = true;
                }
                return result;
            }

            static {
                PROPERTIES_SENT_BY_CHART2D_TO_REMOVE_BASICPROPERTYADAPTSUPPORT_AS_LISTENER_ON_CHART.add("IAxis.PROPERTY_ADD_REMOVE_TRACE");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IRemoveAsListenerFromComponentCondition {
            public boolean isRemoveMeAsListenerComponentEvent(PropertyChangeEvent var1);

            public Set<String> getPropertyChangePropertiesToListenForRemovalOn();
        }
    }
}

