/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.pointpainters;

import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.util.ColorMutable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APointPainter<T extends IPointPainterConfigurableUI<T>>
implements IPointPainterConfigurableUI<T> {
    private final ColorMutable m_color = new ColorMutable();
    private final ColorMutable m_colorFill = new ColorMutable();
    private Stroke m_stroke = null;

    @Override
    public final int compareTo(T arg0) {
        return this.hashCode() - arg0.hashCode();
    }

    @Override
    public void endPaintIteration(Graphics g2d) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        APointPainter other = (APointPainter)obj;
        if (this.m_color == null ? other.m_color != null : !this.m_color.equals(other.m_color)) {
            return false;
        }
        if (this.m_colorFill == null ? other.m_colorFill != null : !this.m_colorFill.equals(other.m_colorFill)) {
            return false;
        }
        return !(this.m_stroke == null ? other.m_stroke != null : !this.m_stroke.equals(other.m_stroke));
    }

    @Override
    public Color getColor() {
        return this.m_color.getColor();
    }

    @Override
    public Color getColorFill() {
        return this.m_colorFill.getColor();
    }

    @Override
    public Stroke getStroke() {
        return this.m_stroke;
    }

    @Override
    public int getTransparency() {
        return this.m_color.getAlpha();
    }

    @Override
    public int getTransparencyFill() {
        return this.m_colorFill.getAlpha();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_color == null ? 0 : this.m_color.hashCode());
        result = 31 * result + (this.m_colorFill == null ? 0 : this.m_colorFill.hashCode());
        result = 31 * result + (this.m_stroke == null ? 0 : this.m_stroke.hashCode());
        return result;
    }

    protected Color installColor(Graphics g) {
        return this.m_color.applyColorIfChange(g);
    }

    protected Color installColorFill(Graphics g) {
        return this.m_colorFill.applyColorIfChange(g);
    }

    protected Stroke installStroke(Graphics g) {
        Stroke result = null;
        if (this.m_stroke != null) {
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                result = g2d.getStroke();
                g2d.setStroke(this.m_stroke);
            } else {
                System.out.println("Cannot use stroke as given graphic context is of wrong type: " + g.getClass().getName());
            }
        }
        return result;
    }

    @Override
    public Color setColor(Color color) {
        Color result = this.m_color.setColor(color);
        return result;
    }

    @Override
    public Color setColorFill(Color fillColor) {
        return this.m_colorFill.setColor(fillColor);
    }

    @Override
    public Stroke setStroke(Stroke stroke) {
        Stroke result = this.m_stroke;
        this.m_stroke = stroke;
        return result;
    }

    @Override
    public int setTransparency(int transparency0to255) {
        return this.m_color.setAlpha(transparency0to255);
    }

    @Override
    public int setTransparencyFill(int transparency0to255) {
        return this.m_colorFill.setAlpha(transparency0to255);
    }

    @Override
    public void startPaintIteration(Graphics g2d) {
    }
}

