/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.planviewer;

import com.sybase.ase.planviewer.ASEPlanViewer;
import com.sybase.ase.planviewer.AdvancedPanel;
import com.sybase.ase.planviewer.Constants;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class ProgressPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 13L;
    private JProgressBar _progressBar;
    private JLabel _lblTips;
    private JScrollPane _jspProgressInfo;
    private JLabel _lblProgressInfo;
    public static final int WIDTH = 200;
    private ASEPlanViewer _pv;
    private JLabel _lblCancel;

    public ProgressPanel(ASEPlanViewer aSEPlanViewer) {
        this._pv = aSEPlanViewer;
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._progressBar = new JProgressBar(0, 0, 100);
        this._progressBar.setIndeterminate(true);
        this._progressBar.setString(this._pv.getLocalizedMessage("PROGRESS_MSG"));
        this._progressBar.setStringPainted(true);
        this._lblTips = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("TIPS_AND_TRICKS")), Constants.UP_IMAGE, 2);
        this._lblTips.addMouseListener(this);
        this._lblCancel = new JLabel(AdvancedPanel.getBlueLabel(this._pv.getLocalizedMessage("CANCEL_PLAN_HINT")), Constants.CANCEL_PLAN_IMAGE, 2);
        this._lblCancel.addMouseListener(this);
        this._lblProgressInfo = new JLabel(this._pv.getLocalizedMessage("PROGRESS_HELP"));
        this._jspProgressInfo = new JScrollPane(this._lblProgressInfo);
        this._jspProgressInfo.setPreferredSize(new Dimension(200, 91));
        this._lblTips.setLabelFor(this._jspProgressInfo);
        this._lblProgressInfo.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._lblTips, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this._lblCancel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._jspProgressInfo, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this._progressBar, gridBagConstraints);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._lblTips) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            JScrollPane jScrollPane = (JScrollPane)jLabel.getLabelFor();
            if (jLabel.getIcon() == Constants.DOWN_IMAGE) {
                jLabel.setIcon(Constants.UP_IMAGE);
                this._lblProgressInfo.setVisible(false);
            } else {
                jLabel.setIcon(Constants.DOWN_IMAGE);
                this._lblProgressInfo.setVisible(true);
            }
            this.revalidate();
        } else if (mouseEvent.getSource() == this._lblCancel) {
            this._pv.cancelPlan();
        }
    }

    public void setShowHide(boolean bl, String string) {
        this.setVisible(bl);
        this._lblTips.setVisible(string == null);
        this._lblCancel.setVisible(string == null);
        this._progressBar.setVisible(string == null);
        this._lblProgressInfo.setVisible(string != null);
        this._lblProgressInfo.setText(string == null ? this._pv.getLocalizedMessage("PROGRESS_HELP") : string);
    }
}

