/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.uaf.SyUAF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public class DiscoverySetting {
    private static Preferences DISCOVERY_SETTING = null;
    private static final String DISCOVERY_SETTING_PATH = "/com/sybase/util/ds/uaf/DiscoverySetting";
    private static final String KEY_SERVICE = "Service";
    private static final String KEY_HOST = "Host";
    private static final String KEY_PORT = "Port";
    public String service;
    public String host;
    public String port;

    public DiscoverySetting() {
        this.service = SyUAF.DEFAULT_DISCOVERY_SERVICE;
        this.host = "";
        this.port = "";
    }

    public DiscoverySetting(String string, String string2, String string3) {
        this.service = string;
        if (string != null && string.equals(SyUAF.SERVICE_UDP)) {
            this.host = "";
            this.port = "";
        } else {
            this.host = string2;
            this.port = string3;
        }
    }

    private static void initDiscoverySetting() {
        DISCOVERY_SETTING = Preferences.userRoot().node(DISCOVERY_SETTING_PATH);
    }

    public static boolean hasDiscoverySettings() {
        String[] stringArray;
        if (DISCOVERY_SETTING == null) {
            DiscoverySetting.initDiscoverySetting();
        }
        return (stringArray = Utils.getChildrenNames(DISCOVERY_SETTING)).length > 0;
    }

    public static List getDiscoverySettings() {
        if (DISCOVERY_SETTING == null) {
            DiscoverySetting.initDiscoverySetting();
        }
        String[] stringArray = Utils.getChildrenNames(DISCOVERY_SETTING);
        ArrayList<DiscoverySetting> arrayList = new ArrayList<DiscoverySetting>();
        if (stringArray == null || stringArray.length == 0) {
            arrayList.add(new DiscoverySetting());
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                Preferences preferences = DISCOVERY_SETTING.node(String.valueOf(i));
                String string = preferences.get(KEY_SERVICE, SyUAF.DEFAULT_DISCOVERY_SERVICE);
                String string2 = preferences.get(KEY_HOST, "");
                String string3 = preferences.get(KEY_PORT, "");
                arrayList.add(new DiscoverySetting(string, string2, string3));
            }
        }
        return arrayList;
    }

    public static void saveDiscoverySettings(List list) {
        if (DISCOVERY_SETTING != null) {
            Utils.removeNode(DISCOVERY_SETTING);
        }
        DiscoverySetting.initDiscoverySetting();
        for (int i = 0; i < list.size(); ++i) {
            DiscoverySetting discoverySetting = (DiscoverySetting)list.get(i);
            Preferences preferences = DISCOVERY_SETTING.node(String.valueOf(i));
            preferences.put(KEY_SERVICE, discoverySetting.service);
            if (discoverySetting.host != null) {
                preferences.put(KEY_HOST, discoverySetting.host);
            }
            if (discoverySetting.port == null) continue;
            preferences.put(KEY_PORT, discoverySetting.port);
        }
    }

    public static String getDiscoverySettingsString(List list) {
        String string = "";
        String string2 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DiscoverySetting discoverySetting = (DiscoverySetting)iterator.next();
            string = string + string2 + discoverySetting.toString();
            string2 = ",";
        }
        return string;
    }

    public String getURL() {
        String string = this.service;
        if (this.host != null && this.host.length() > 0) {
            string = string + "://" + this.host;
        }
        if (this.port != null && this.port.length() > 0) {
            string = string + ":" + this.port;
        }
        return string;
    }

    public String toString() {
        return this.service + ":" + this.host + ":" + this.port;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

