/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASAButton;
import com.sybase.asa.ASACheckBox;
import com.sybase.asa.ASAMultiLineLabel;
import com.sybase.asa.ASAMultiListTableCellRenderer;
import com.sybase.asa.ASAMultiListTableHeaderRenderer;
import com.sybase.util.ds.Settings;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.lang.DSResourceBase;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.ui.BasePanel;
import com.sybase.util.ds.ui.DiscoveryFiltersDialog;
import com.sybase.util.ds.ui.EditDiscoverySettingDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ServerDiscoveryPage
extends BasePanel
implements ListSelectionListener {
    public ASAMultiLineLabel infoMultiLineLabel;
    public ASACheckBox discoveryCheckBox;
    public JTable serversList;
    public ASAButton addButton;
    public ASAButton editButton;
    public ASAButton removeButton;
    public ASAButton upButton;
    public ASAButton downButton;
    public ASAMultiLineLabel filtersMultiLineLabel;
    public ASAButton filtersButton;
    private DiscoveryFiltersDialog _discoveryFiltersDialog = null;
    private String _discoverySettings;
    private boolean _enableDiscovery;
    private String _filterId;

    public ServerDiscoveryPage(String string) {
        this._filterId = string;
        this.createGUI();
    }

    private void createGUI() {
        this.infoMultiLineLabel = new ASAMultiLineLabel(_res.get("DISCOVERY_CONFIG_INFO"));
        this.discoveryCheckBox = new ASACheckBox(_res.get("CHKB_ENABLE_SERVER_DISCOVERY"));
        this.discoveryCheckBox.setMnemonic(_res.get("MNEM_ENABLE_SERVER_DISCOVERY").charAt(0));
        this.serversList = new JTable(new MyTableModel());
        this.serversList.getTableHeader().setReorderingAllowed(false);
        this.serversList.setShowVerticalLines(false);
        this.serversList.setShowHorizontalLines(false);
        this.serversList.setSelectionMode(0);
        this.serversList.setDefaultRenderer(Object.class, (TableCellRenderer)new ASAMultiListTableCellRenderer());
        this.serversList.setDefaultRenderer(Number.class, (TableCellRenderer)new ASAMultiListTableCellRenderer());
        JTableHeader jTableHeader = this.serversList.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setDefaultRenderer((TableCellRenderer)new ASAMultiListTableHeaderRenderer(this.serversList));
        }
        JScrollPane jScrollPane = new JScrollPane(this.serversList);
        jScrollPane.setPreferredSize(new Dimension(320, 250));
        jScrollPane.getViewport().setBackground(this.serversList.getBackground());
        this.addButton = new ASAButton(_res.get("ADD"));
        this.editButton = new ASAButton(_res.get("EDIT"));
        this.removeButton = new ASAButton(_res.get("REMOVE"));
        this.upButton = new ASAButton(_res.get("UP"));
        this.downButton = new ASAButton(_res.get("DOWN"));
        this.filtersButton = new ASAButton(_res.get("FILTERS"));
        this.filtersMultiLineLabel = new ASAMultiLineLabel(DiscoveryFilter.hasDiscoveryFilters(this._filterId) ? _res.get("EXIST_FILTERS") : _res.get("NO_FILTERS"));
        int n = 0;
        this.add((Component)this.discoveryCheckBox, 0, n, 1, 1, 0.0, 0.0, 17, 0, INSETS, 0, 0);
        this.add((Component)this.infoMultiLineLabel, 0, ++n, 2, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add(jScrollPane, 0, ++n, 1, 6, 1.0, 1.0, 17, 1, INSETS, 0, 0);
        this.add((Component)this.addButton, 1, n, 1, 1, 0.0, 0.0, 12, 2, INSETS, 0, 0);
        this.add((Component)this.removeButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, INSETS, 0, 0);
        this.add((Component)this.editButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, INSETS, 0, 0);
        this.add((Component)this.upButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, INSETS, 0, 0);
        this.add((Component)this.downButton, 1, ++n, 1, 1, 0.0, 0.0, 12, 2, INSETS, 0, 0);
        this.add((Component)this.filtersMultiLineLabel, 0, 7, 1, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
        this.add((Component)this.filtersButton, 1, 7, 1, 1, 0.0, 0.0, 14, 2, INSETS, 0, 0);
    }

    public void init(ActionListener actionListener) {
        this.releaseResources(actionListener);
        this.serversList.getSelectionModel().removeListSelectionListener(this);
        this.discoveryCheckBox.removeActionListener(actionListener);
        this._enableDiscovery = Settings.getEnableServerDiscovery();
        this.discoveryCheckBox.setSelected(this._enableDiscovery);
        List list = DiscoverySetting.getDiscoverySettings();
        ((MyTableModel)this.serversList.getModel()).setDataArray(list);
        Utils.setInitialColumnWidths(this.serversList);
        this.addButton.addActionListener(actionListener);
        this.editButton.addActionListener(actionListener);
        this.removeButton.addActionListener(actionListener);
        this.upButton.addActionListener(actionListener);
        this.downButton.addActionListener(actionListener);
        this.filtersButton.addActionListener(actionListener);
        this.serversList.getSelectionModel().addListSelectionListener(this);
        this.discoveryCheckBox.addActionListener(actionListener);
        this._discoverySettings = this.getSettingsString();
    }

    public void releaseResources(ActionListener actionListener) {
        this.addButton.removeActionListener(actionListener);
        this.editButton.removeActionListener(actionListener);
        this.removeButton.removeActionListener(actionListener);
        this.upButton.removeActionListener(actionListener);
        this.downButton.removeActionListener(actionListener);
        this.filtersButton.removeActionListener(actionListener);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableComponents();
    }

    public void handleActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.discoveryCheckBox) {
            this.enableComponents();
        }
        if (object == this.addButton) {
            EditDiscoverySettingDialog editDiscoverySettingDialog = new EditDiscoverySettingDialog(this, null, false);
            DiscoverySetting discoverySetting = editDiscoverySettingDialog.create();
            if (discoverySetting != null) {
                ((MyTableModel)this.serversList.getModel()).addRowObject(discoverySetting);
            }
        } else if (object == this.removeButton) {
            int n = this.serversList.getSelectionModel().getMaxSelectionIndex();
            ((MyTableModel)this.serversList.getModel()).removeRowObject(n);
        } else if (object == this.editButton) {
            this.editDiscoverySetting();
        } else if (object == this.upButton) {
            int n = this.serversList.getSelectionModel().getMaxSelectionIndex();
            this.swapDiscoverySetting(n, n - 1);
        } else if (object == this.downButton) {
            int n = this.serversList.getSelectionModel().getMaxSelectionIndex();
            this.swapDiscoverySetting(n, n + 1);
        } else if (object == this.filtersButton) {
            this._discoveryFiltersDialog = new DiscoveryFiltersDialog(this, this._filterId);
            boolean bl = this._discoveryFiltersDialog.create();
            if (bl) {
                this.filtersMultiLineLabel.setText(DiscoveryFilter.hasDiscoveryFilters(this._filterId) ? _res.get("EXIST_FILTERS") : _res.get("NO_FILTERS"));
            }
        }
    }

    public boolean handleMouseClicked(MouseEvent mouseEvent) {
        if (this.discoveryCheckBox.isSelected() && mouseEvent.getClickCount() > 1 && this.editDiscoverySetting()) {
            this.enableComponents();
            return true;
        }
        return false;
    }

    private boolean editDiscoverySetting() {
        int n = this.serversList.getSelectionModel().getMaxSelectionIndex();
        DiscoverySetting discoverySetting = ((MyTableModel)this.serversList.getModel()).getRowObject(n);
        EditDiscoverySettingDialog editDiscoverySettingDialog = new EditDiscoverySettingDialog(this, discoverySetting, true);
        DiscoverySetting discoverySetting2 = editDiscoverySettingDialog.create();
        if (discoverySetting2 != null) {
            this.replaceDiscoverySetting(n, discoverySetting2);
            return true;
        }
        return false;
    }

    private void swapDiscoverySetting(int n, int n2) {
        DiscoverySetting discoverySetting = ((MyTableModel)this.serversList.getModel()).getRowObject(n);
        DiscoverySetting discoverySetting2 = ((MyTableModel)this.serversList.getModel()).getRowObject(n2);
        this.replaceDiscoverySetting(n, discoverySetting2);
        this.replaceDiscoverySetting(n2, discoverySetting);
        this.serversList.getSelectionModel().addSelectionInterval(n2, n2);
    }

    private void replaceDiscoverySetting(int n, DiscoverySetting discoverySetting) {
        ((MyTableModel)this.serversList.getModel()).removeRowObject(n);
        ((MyTableModel)this.serversList.getModel()).addRowObject(n, discoverySetting);
    }

    public void enableComponents() {
        boolean bl = this.discoveryCheckBox.isSelected();
        int n = this.serversList.getSelectedRowCount();
        boolean bl2 = n > 0;
        this.addButton.setEnabled(bl);
        this.editButton.setEnabled(bl && bl2);
        this.removeButton.setEnabled(bl && bl2);
        int n2 = this.serversList.getSelectionModel().getMaxSelectionIndex();
        int n3 = this.serversList.getSelectionModel().getMinSelectionIndex();
        this.upButton.setEnabled(bl && bl2 && n3 > 0);
        this.downButton.setEnabled(bl && bl2 && n2 < this.serversList.getRowCount() - 1);
        this.infoMultiLineLabel.setEnabled(bl);
        this.serversList.setEnabled(bl);
        JTableHeader jTableHeader = this.serversList.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.columnMarginChanged(new ChangeEvent(this));
        }
        this.filtersMultiLineLabel.setEnabled(bl);
        this.filtersButton.setEnabled(bl);
    }

    public boolean getEnableSave() {
        return this._enableDiscovery != this.discoveryCheckBox.isSelected() || !this._discoverySettings.equals(this.getSettingsString());
    }

    public String getSettingsString() {
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.serversList.getRowCount(); ++i) {
            DiscoverySetting discoverySetting = ((MyTableModel)this.serversList.getModel()).getRowObject(i);
            string = string + string2 + discoverySetting.toString();
            string2 = ",";
        }
        return string;
    }

    public boolean saveSettings() {
        boolean bl = this.discoveryCheckBox.isSelected();
        Settings.setEnableServerDiscovery(bl);
        ArrayList<DiscoverySetting> arrayList = new ArrayList<DiscoverySetting>();
        for (int i = 0; i < this.serversList.getRowCount(); ++i) {
            DiscoverySetting discoverySetting = ((MyTableModel)this.serversList.getModel()).getRowObject(i);
            arrayList.add(discoverySetting);
        }
        DiscoverySetting.saveDiscoverySettings(arrayList);
        return true;
    }

    public boolean containsDiscoverySetting(DiscoverySetting discoverySetting) {
        return ((MyTableModel)this.serversList.getModel()).containsObject(discoverySetting);
    }

    public boolean getFilterChanged() {
        if (this._discoveryFiltersDialog == null) {
            return false;
        }
        return this._discoveryFiltersDialog.getDiscoveryFiltersPageChanged();
    }

    static class MyTableModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private List _data;

        MyTableModel() {
            DSResourceBase dSResourceBase = BasePanel._res;
            this._data = new ArrayList();
            this._columnNames = new String[]{dSResourceBase.get("PROTOCOL"), dSResourceBase.get("getHostName"), dSResourceBase.get("getPortNumber")};
        }

        void setDataArray(List list) {
            this._data = list;
            this.fireTableChanged(new TableModelEvent(this));
        }

        public DiscoverySetting[] getDataArray() {
            return this._data.toArray(new DiscoverySetting[0]);
        }

        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        public int getRowCount() {
            return this._data.size();
        }

        public int getColumnCount() {
            return this._columnNames.length;
        }

        public void addRowObject(DiscoverySetting discoverySetting) {
            this._data.add(discoverySetting);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void addRowObject(int n, DiscoverySetting discoverySetting) {
            this._data.add(n, discoverySetting);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void removeRowObject(int n) {
            this._data.remove(n);
            this.fireTableChanged(new TableModelEvent(this));
        }

        public boolean containsObject(DiscoverySetting discoverySetting) {
            return this._data.contains(discoverySetting);
        }

        public DiscoverySetting getRowObject(int n) {
            return (DiscoverySetting)this._data.get(n);
        }

        public Object getValueAt(int n, int n2) {
            DiscoverySetting discoverySetting = this.getRowObject(n);
            if (n2 == 0) {
                return discoverySetting.service;
            }
            if (n2 == 1) {
                return this.getDisplayHost(discoverySetting);
            }
            return this.getDisplayPort(discoverySetting);
        }

        String getDisplayHost(DiscoverySetting discoverySetting) {
            if (discoverySetting.service.equals(SyUAF.SERVICE_UDP)) {
                return "(n/a)";
            }
            DSResourceBase dSResourceBase = BasePanel._res;
            return discoverySetting.host == null || discoverySetting.host.length() == 0 ? dSResourceBase.get("DEFAULT") : discoverySetting.host;
        }

        String getDisplayPort(DiscoverySetting discoverySetting) {
            if (discoverySetting.service.equals(SyUAF.SERVICE_UDP)) {
                return "(n/a)";
            }
            DSResourceBase dSResourceBase = BasePanel._res;
            return discoverySetting.port == null || discoverySetting.port.length() == 0 ? dSResourceBase.get("DEFAULT") : discoverySetting.port;
        }
    }
}

