/*
 * Decompiled with CFR 0.152.
 */
package asemon;

import asemon.utils.StringUtil;
import java.util.HashMap;

public class AseTraceFlagsDictionary {
    private static AseTraceFlagsDictionary _instance = null;
    private HashMap<Integer, TraceFlagRecord> _traceflags = new HashMap();

    public AseTraceFlagsDictionary() {
        this.init();
    }

    public static AseTraceFlagsDictionary getInstance() {
        if (_instance == null) {
            _instance = new AseTraceFlagsDictionary();
        }
        return _instance;
    }

    public String getDescription(int traceflag) {
        TraceFlagRecord rec = this._traceflags.get(traceflag);
        if (rec != null) {
            return rec.toString();
        }
        return "Trace flag '" + traceflag + "' not found in dictionary.";
    }

    private void set(TraceFlagRecord rec) {
        if (this._traceflags.containsKey(rec._id)) {
            System.out.println("Trace flag '" + rec._id + "' already exists. It will be overwritten.");
        }
        this._traceflags.put(rec._id, rec);
    }

    private void set(int id, String description) {
        this.set(new TraceFlagRecord(id, description));
    }

    private void init() {
        this.set(900, "Let OPER auth use a DBO USE ONLY database.");
        this.set(990, "Allow 'use db' to succeed, so that 'sa'-login can do some diagnostics in a database that was not, yet, onlined. This allows one to peek at data structures in an older version db to debug upgrade issues.");
        this.set(991, "Allow 'use db' to succeed, so that logins that do not have sa or operator roles can use database prior to upgrade.");
        this.set(1200, "Print process id and type of lock requested.");
        this.set(1201, "Obsolete.");
        this.set(1202, "Insert blocked lock requests into syslocks.");
        this.set(1203, "Check for leftover locks between commands");
        this.set(1204, "Print out deadlock chains and victim. See also 1205, 1218, 633, 12673.");
        this.set(1205, "Print out stack traces of deadlocked pids. Must be used in conjuction with 1204.");
        this.set(1206, "Disable Lock promotion. If this commandline trace flag is turned on, we will not attempt to escalate (promote) to a table lock by dispensing with page locks.");
        this.set(1207, "Disable lock requeueing. Obsolete in 11.2.");
        this.set(1208, "Disable multiple deadlock detection.");
        this.set(1211, "Trace lock unit test execution.");
        this.set(1212, "Trace every lock acquisition and release.");
        this.set(1213, "Enable object and user level lock statistics monitoring.");
        this.set(1214, "Acquire SH_PAGE locks on index pages even if the <for update> clause is specified for the cursor.");
        this.set(1215, "Enables code path for Gryphons lock unit tests. Warning: This trace flag disables multi-level Sufficiency check during anti-inheritance. It is meant for use only by the lock unit tests.");
        this.set(1216, "Force conditional lock requests (LOCK_NOQUEUE) to lock_logical() always fail (return LOCK_DIDNTQUEUE). Related to 12685 but broader. SANITY ONLY.");
        this.set(1217, "Trace every lock acquisition and release. USER TABLES ONLY. Like 1212 but only user tables.");
        this.set(1218, "Print out showplan on deadlock. Only works if 1204 is on. See also 1205.");
        this.set(1223, "Send deadlock information to errorlog in scerrlog format i.e. containing engine, spid, timestamp, etc. Works only if 1204 is also on. This traceflag is documented.");
        this.set(1230, "Print out craig's warnings.");
        this.set(1231, "Optimization to reduce the critical section in the lock_transfer code. If this traceflag is enabled, then just transfer the lock record without performing the compatibility check.");
        this.set(1232, "Print data that is written to the Deadlock Fast Pipe using TRACEPRINT in lock__print_deadlockchain().");
        this.set(1233, "Set Fast Pipe handle to NULL to test exception handling by simulating an uninitiatlized Deadlock pipe in lock__print_deadlockchain().");
        this.set(1234, "Set Fast Pipe handle to a bogus value to test exception handling by simulating an bad pipe handle in lock__print_deadlockchain().");
        this.set(1235, "When we release the last non granted blocking lock but lock requeue is not attempted (bit SEMA_OMIT_REQ is set in the next semawait), print the type of the lock being released and some semawait related information. Do the same when bit SEMA2_EVAL_REQ is set. Use traceflag 1235 ONLY IF NECESSARY.");
        this.set(1236, "Enable fix for CR 445676 in lock requeue logic.");
        this.set(1237, "Enable call stack reporting when error 1204 is hit.");
        this.set(1290, "Available for in-house testing of dbcc lock_release to attempt release a lock although the target task may not have been badly terminated. Don't use this trace flag in the field, unless instructed otherwise.");
        this.set(1299, "Prints the lock wait time in seconds and msecs if we were woken up because the lock timed out.");
        this.set(1301, "Trace PCD resource memory useage. Tracks each allocation and deallocation of memory from the PROC_HDR that is private to the Pss->pcxt_info resource structure for the task.");
        this.set(1302, "Trace PCD events as they happen. Current events are: garbage collection, nestlevel transition and session termination.");
        this.set(1303, "Trace PCD garbage collection statistics. Track counts of memory in use, free, allocated and remaining for the PCD PROC_HDR memory in the Pss->pcxt_info resource structure.");
        this.set(2000, "Enforce the 'no trojan horse' rule during procedure creation.");
        this.set(2001, "Enforce the DDL for an ESP to be saved 'as supplied'. So, do not extract the dll name.");
        this.set(3300, "Print log records and action taken in undo/redo Must use -T to force this at recovery time.");
        this.set(3304, "Display buffers as resource locks are released whenever an index split or shrink backout concludes.");
        this.set(3307, "Print process id waiting for a resource lock when in index split/shrink backout.");
        this.set(3308, "Print page number, objid, page timestamp and log old timestamp when we mask a timestamp mismatch error during redo. We mask this error only when the analysis pass has determined thatthis page will be deallocated later.");
        this.set(3309, "During redo/undo check for presence of XSTAT_EXPAGE/XSTAT_EXTABLE status in xchange log records.");
        this.set(3310, "Unconditionally redo changes to the extent allocation bitmap during redo of ALLOC, SALLOC, ALLOC_NOLINK and OAMCREATE and their associated CLRs.");
        this.set(3311, "Print out the log record, relevant pghdr fields and decision taken in do_AP_check_needed() on whether to redo or skip alloc bitmap changes.");
        this.set(3313, "During redo check if there is a mismatch with runtime in the type of expanding update performed, and print some diagnostics. ");
        this.set(3314, "Print redo undo actions on AP.");
        this.set(3315, "During run-time rollback, neither prefetch pages touched by the log records being undone, nor increase the process priority for the duration of the rollback.");
        this.set(3316, "When redoing or undoing changes to page linkage for the previous page, the previous page timestamp is allowed to be less than the old log timestamp (redo) or less than the new log timestamp (undo) if the previous page was allocated by LSA in a partially logged transaction. This trace flag can be used to override the less-stringent timestamp checks.");
        this.set(3317, "Perform less stringent timestamp checks (as described in 3316) when recovering database dumps that were not created on a server that made allowances for this situation. This switch was originally included for CR 438272. It must be used with care and only in situations where a bug (like CR 438272) is to be worked around.");
        this.set(3318, "Trace post-commit cleanup of reservations by recovery.");
        this.set(3319, "Disable post-commit cleanup of reservations by recovery. ");
        this.set(3320, "For all types of recovery, only use the post-commit deallocation mechanism that makes use of conditional destruction of buffers. Normally this is used only for node failover recovery. Only one of 3320 and 3321 should be used (else behaviour is that of 3321).");
        this.set(3321, "For all types of recovery, only use the post-commit deallocation mechanism that makes use of unconditional destruction of buffers. Normally this is used only for boottime, LOAD DATABASE and LOAD TRAN recovery. Only one of 3320 and 3321 should be used (else behaviour is that of 3321).");
        this.set(3322, "Redo allocation page changes for all dealloc and dealloc CLRs. Turns off CR 484828");
        this.set(3323, "In rec_undo_session(), checkpoint the database, under sanity only, for testing purposes.");
        this.set(4000, "Crash server at next loop for recovery testing");
        this.set(4001, "print out the login record supplied by host.");
        this.set(4002, "call dummy routine - used as NOP");
        this.set(4003, "intialize the profiling system");
        this.set(4004, "toggle profiling (on vs. off)");
        this.set(4005, "write a \"servmon.out\" file for use by Unix prof(1)");
        this.set(4006, "dump out buffer info after every command");
        this.set(4007, "fake login code");
        this.set(4008, "check for leftover open tables during recovery");
        this.set(4009, "Print TDS header of sendbuffer just before sending it to the front end. See 4031 also.");
        this.set(4010, "cause just connected process to become infected.");
        this.set(4012, "don't spawn ckptproc()");
        this.set(4013, "log loginrec in errorlog.");
        this.set(4014, "Unused.");
        this.set(4015, "infect the process");
        this.set(4016, "log an informational message to errorlog whenever an interrupt routine is interrupted (unix SIGURG and SIGALRM interaction)");
        this.set(4017, "Call prPSS and treeprint when in opencheck().");
        this.set(4019, "Measure overhead of trace flag 4039 and write measurements to the errorlog.");
        this.set(4020, "Boot without recovery");
        this.set(4021, "Used by security group");
        this.set(4030, "Print TDS header of recv buffer just after receiving it from the front end. See 4031 also.");
        this.set(4031, "Causes 4009, 4030, 4033 trace flags to print the entire TDS packet, and not just the header.");
        this.set(4032, "Reservation for 28875. Print out ASCII representation of recv buffer after usrfill() call NOTE: OBSOLETE.");
        this.set(4033, "Print TDS header of private buffer just before merging it to the shared buffer. See 4031 also. Note: compile qryproc/plltbmrg.c with SANITY.");
        this.set(4034, "Same as 4009 but specified on command line");
        this.set(4035, "Same as 4030 but specified on command line");
        this.set(4036, "Same as 4031 but specified on command line");
        this.set(4037, "Traceprint tds summary information on receipt of invalid packet");
        this.set(4038, "Used with 4037 to traceprint packet contents as well as summary (has no effect on its own)");
        this.set(4039, "Dump TDS packets to external file.");
        this.set(4040, "(7866) - inflict timeslice");
        this.set(4041, "(7866) - yield every five seconds");
        this.set(4042, "Force single-byte character set. (Sets Resource->rchar_attrib->cs_maxcharlen to 1 and Resource->rchar_attrib->cs_status to 0 which will cause fast path to be taken.)");
        this.set(4043, "Activate all of a user's available roles at login-time. This is the standard behaviour for the C2 server. For B1, however, the default behavior is to have *none* of the user's roles activated at login time. This trace flag will essentially make the B1 server behave like the C2 server in this regard.");
        this.set(4044, "Allow sa to login in even if account is locked");
        this.set(4045, "Enable trimming multi-byte trailing space character for fixed length char string comparison.");
        this.set(4046, "Disable CONST_NULL status setting for a NULL value parameter's constant node when a PARAMS TDS is received in tdsrecv_params().");
        this.set(4047, "(Bug fix of 123291) Allow trailing bank be defined inside a bracket in rule definition as a 492x server does.");
        this.set(4048, "Revert trailing space and datalength function behavior to pre-11.5 version. ");
        this.set(4049, "Activate a timer before waiting for the first login record. ");
        this.set(4050, "To disable Engine Monitor counters. (for testing with Monitor server etc.,)");
        this.set(4051, "Use alternative random number generation algorithm.");
        this.set(4052, "Obsoleted in 15.0. See trace.h in older servers for explanation of this traceflag.");
        this.set(4053, "Disable at boottime the fix for bugid 197267.");
        this.set(4054, "Print offline engines diagnostic messages.");
        this.set(4055, "(This trace flag is now obsolete.)");
        this.set(4056, "Obsoleted in 15.0. See trace.h in older servers for explanation of this traceflag.");
        this.set(4057, "UNUSED ");
        this.set(4058, "Switch from the prototype buildmaster code to the newly implemented buildmaster code.");
        this.set(4059, "Prepend the dump archive name with \"compress::\" This traceflag is used for testing compressed dumps");
        this.set(4060, "Drain all Async IO operations before doing a fork call. (Solaris only).");
        this.set(4061, "Disable asynchronous IO on devices that are regular files. THe configuration setting for asynchronous access will still be honoured when a raw device is used.");
        this.set(4062, "Enable new soundex() behaviour");
        this.set(4063, "Used by 12.0 server to turn on sqldbgr RPCs");
        this.set(4065, "Enable use of syb_atof() for ATOF() instead of default atof(). (388803) reverses (242790).");
        this.set(4066, "Defeat loginrec sanity checking");
        this.set(4067, "Disable VALIDATE_FLOAT() strong type checking");
        this.set(4068, "Enable P_FORCED_ERROR assertion check in senddone() to detect silent failures in ASE. This assertion is applicable only to the sanity server.");
        this.set(4069, "Disable batch I/O. TEMPORARY FIX");
        this.set(4070, "Disable usage of sa reserved connections.");
        this.set(4071, "Print disgnostic message if the remote password in the loginrec is incorrect.");
        this.set(4072, "Disable global login trigger.");
        this.set(4073, "Discontinued in 15.0.2. Enable EXPORT_OPTIONS in login triggers.");
        this.set(4074, "Skip the check for 32-64 bits architecture.");
        this.set(4075, "Traceprint all SyLAPI message with severity SYLAPI_LOG, SYLAPI_DBG. (Debug purpose only. Not for customers.)");
        this.set(4076, "Output all license information including pseudo lincenses and free/bundled licenses for sp_lmconfig. (Debug purpose only. Not for customers.)");
        this.set(4077, "Use debug license heartbeat interval value, 60 seconds. (Debug purpose only. Not for customers.)");
        this.set(4078, "Use SYLAPI_TEST_POLICY instead of SYLAPI_SERVER_POLICY_ID for sylapi_init(). (Debug purpose only. Not for customers.)");
        this.set(4079, "Traceprint detailed license info in license related routines. (Debug purpose only. Not for customers.)");
        this.set(4080, "When ON tsequal() invocation in the stored procedure will return new timestamp value as the return parameter. If OFF then nothing will be returned. Ad-hoc queries are not concerned by this flag.");
        this.set(4081, "Disables the fix for 408736 and therefore an extra TDS_DONE token is sent in send_ts() after sending the new timestamp.");
        this.set(4082, "Make console output blocking. Default is non-blocking.");
        this.set(4084, "Disable console logging if nonblocking setup fails.");
        this.set(4085, "In ueshutdown(), don't delete shared memory if enabled.");
        this.set(4087, "Print diagnostic information for login profile");
        this.set(4099, "Simulate that all licenses are not checked-out. (Unit Testing TF.)");
        this.set(3000, "Print DUMP DATABASE start and end times.");
        this.set(3001, "Print FLUSHEDPAGES runlists transmitted by DUMP DATABASE.");
        this.set(3002, "Print SCANLOGPAGES runlists transmitted by DUMP DATABASE or DUMP TRANSACTION.");
        this.set(3003, "Print all runlists transmitted by DUMP DATABASE.");
        this.set(3004, "If printing runlists, print only one run per line.");
        this.set(3010, "Shutdown the server before getting dumpinstant.");
        this.set(3011, "Shutdown the server after modifiying the dbinfo (and clearing the state info) but before writing the dump trailer.");
        this.set(3012, "Shutdown the server after writing the trailer");
        this.set(3013, "Shutdown the server, before copying the logptr. Activated only if logptr need to be copied.");
        this.set(3014, "Hang dump database before it releases reources.");
        this.set(3015, "To simulate 694 errors when create index runs together with dump database. Activated only under SANITY. This traceflag is used in quasr tests.");
        this.set(3016, "Postpone acquisition of dump instant until this same flag has been cleared, to stretch recovery interval for testing, and/or to give testing synchronous control over the end of dump.");
        this.set(3017, "To restrict ASE to not send 'iomode' options to Backup server. Usage of this trace flag is essential only if version of Backup server does not understand 'iomode' option.");
        this.set(4200, "Bypass PG_SERIALLOC optimization in dumping the log, perhaps because it's broken. Applies both to DUMP DATABASE and to DUMP TRANSACTION. Can be set as a \"-T\" SQLServer command line option as well as by the usual DBCC TRACEON.");
        this.set(4201, "Verify serial allocation of each log alloc piece taken as log sub-chain, be it extent or alloc unit. Applies both to DUMP DATABASE and to DUMP TRANSACTION. This same test logic is also invoked by the SANITY flag.");
        this.set(4202, "For each alloc unit in log scan, print each alloc page number and whether alloc-unit-sized piece or extent-sized pieces are to be used. Applies both to DUMP DATABASE and to DUMP TRANSACTION.");
        this.set(4203, "Print number of log pages dumped, with boundaries.");
        this.set(4204, "Abort DUMP TRAN just before it commits.");
        this.set(4205, "Print out traces when log runs are deallocated.");
        this.set(4206, "Disable the serial allocation verification. The reason we need a trace flag is the serial allocation check is ON by default in diagserver. We could have overloaded 4201. But, lets avoid the confusion and add a new trace flag. This trace flag is ignored in dataserver. Can be set as a \"-T\" SQLServer command line option as well as by the usual DBCC TRACEON.");
        this.set(4210, "To help in testing dump quiescent point. This will stop the dump tran command before it logs a beginxact log record.");
        this.set(4211, "To help in testing dump quiescent point. This will stop the dump tran command after it logs a beginxact log but before it logs a checkpoint record.");
        this.set(4212, "To help in testing dump quiescent point. This will stop the dump tran command after it logs beginxact and checkpoint record.");
        this.set(4213, "Shutdown the server after writing header but before writing any of the pages.");
        this.set(4214, "Shutdown the server after most of the pages but not all the pages are dumped.");
        this.set(4215, "Cause an exception after dumping the log pages and truncating the log but before updating the dbinfo and ending the xact.");
        this.set(4216, "Used to flush the PLC of the current process before causing an exception defined in 4215 trace flag.");
        this.set(4217, "Simulate a condition where the routine that finds the quiescent point returns an empty quiescent marker.");
        this.set(4218, "Print diagnostic message in routines that finds quiescent point during dump transaction.");
        this.set(4219, "For testing only: emulate a client attention during the truncation phase of DUMP TRAN WITH NO_LOG.");
        this.set(4220, "In dmpx__truncatemain(), for any user database, print the entire log before deallocating it. TERSE version: print log record headers only. Also applied in Online Database when log version is about to change. In either case, it's the last chance to print the log records correctly or at all.");
        this.set(4221, "In dmpx__truncatemain(), for any user database, print the entire log before deallocating it. VERBOSE version: Print data as well as headers. Also applied in Online Database when log version is about to change. In either case, it's the last chance to print the log records correctly or at all.");
        this.set(4222, "In functions which consider trace flags 4220 and 4221, apply that consideration to system databases as well as to user databases. This trace flag has no effect unless 4220 or 4221 is set.");
        this.set(2201, "Return SUCCESS status from all ha builtin's");
        this.set(2202, "HA advisory. Advisory on all attributes");
        this.set(2203, "HA advisory. Override on advisory.");
        this.set(2204, "Send embedded the ct_debug() call for sanity server. This enable to trace ctlib calls.");
        this.set(2205, "Print steps in platform-specific HA dll.");
        this.set(2206, "HA proxydb creation enabled by default");
        this.set(2207, "Allow dbshutdown debug messages to be printed");
        this.set(2208, "Allow dropping of the local database when the corresponding proxy db does not exist.");
        this.set(2209, "To allow existing databases in secondary to errorlog.");
        this.set(2210, "Print HA session handles during login, failover and failback. Show activity in SYSSESSIONS. This is useful for debugging failover connect timeout and authentication problems.");
        this.set(2211, "To rollback failover even if hastate is NCM or ASNC");
        this.set(2212, "To disable the 'state valid' bit. This forces all callers of ha_get_server_state() to read the state from the disk.");
        this.set(2213, "Enable sp_hasyncssn display of its intended work during resume.");
        this.set(2226, "HA advisory. Advisory exerciser");
        this.set(2227, "HA advisory. Advisory diagnostic trace.");
        this.set(2228, "HA advisory. All faults computed by the space estimator is logged as a soft fault.");
        this.set(2229, "To reserve connections of HA when 2201 is on.");
        this.set(2230, "When this turn on, we tolerant inconsistency in sp_drop!!!! (e.g. sp_dropuser, sp_dropgroup)");
        this.set(2231, "Allow use of a database when it is shutdown from external access. This is useful for debugging especially to see log records");
        this.set(2232, "Allow access to a database even if it has been shutdown (marked DBT3_DBSHUTDOWN_FROM_ACCESS )");
        this.set(2233, "Allow updates to a master_companion database.");
        this.set(2234, "To force proc recompile during mount database.");
        this.set(2235, "To disable dbshutdown timeouts.");
        this.set(2236, "To print stack when process exits without doing cleanup of dbt_keep.");
        this.set(2237, "For ha_admin(\"\",force_dbshutdown),continue cleanup even if dbt keep and per process keep count do not match.");
        this.set(2238, "Enable the scheduler changes that has been made for failover performance speedup.");
        this.set(2251, "Simulate spawn hanlder error when the quiesce database command tries to spawn a new thread to execute the command.");
        this.set(2252, "Simulate the error when the quiesce database process is trying to sleep.");
        this.set(2253, "Simulate the error when the quiesce database process is trying to allocate memory for the argument structure. See also (HAUTILS, 54) and (HAUTILS, 74).");
        this.set(2254, "Simulate the error when the quiesce database agent process is trying to allocate memory for the context structure. See also (HAUTILS, 53) and (HAUTILS, 74).");
        this.set(2255, "Simulate the error when the quiesce database agent process is trying to open a transaction.");
        this.set(2256, "Simulate the error when the quiesce database agent process is trying to open an xls connection.");
        this.set(2257, "Simulate the error when the quiesce database agent process is trying to get the dump lock. Make the result be DEADLOCK.");
        this.set(2258, "Simulate the error when the quiesce database agent process is trying to get the dump lock. Make the result be LOCK INTERRUPTED.");
        this.set(2259, "Simulate the error when the quiesce database agent process is trying to get the begin lock. Make the result be DEADLOCK.");
        this.set(2260, "Simulate the error when the quiesce database agent process is trying to get the begin lock. Make the result be LOCK INTERRUPTED.");
        this.set(2261, "Simulate the error when the quiesce database agent process is trying to get the prepare lock. Make the result be DEADLOCK.");
        this.set(2262, "Simulate the error when the quiesce database agent process is trying to get the prepare lock. Make the result be LOCK INTERRUPTED.");
        this.set(2263, "Simulate the error when the quiesce database agent process is trying to get the append log semaphore for the specified databases because of user abort the command.");
        this.set(2264, "Simulate the error when the quiesce database agent process is trying to get the append log semaphore for the specified databases because of DEADLOCK.");
        this.set(2265, "Make multi-database prepare transaction to wait. This is used to test the interaction between quiesce database and prepare transactions.");
        this.set(2266, "Make dump transaction to wait. This is used to test the interaction between quiesce database and dump transaction. This is also used to hang dump/load db/tran commands.");
        this.set(2267, "Write a des-checkpoint after getting appendlog semaphore while doing quiesce database with hold option.");
        this.set(2268, "Hold the quiesce hold process after init. This is for testing the synchronization.");
        this.set(2269, "Hold the quiesce hold process after freeze. This is for testing the synchronization.");
        this.set(2270, "Hold the quiesce release process after unfreeze. This is for testing the synchronization.");
        this.set(2271, "Hold the quiesce hold process in drain phase after the flag QDB_BLKBEGIN is set. This is for testing the blocking of begin tran when this flag is set.");
        this.set(2272, "When this trace flag is turned on, the Database command will not write checkpoint record, nor do any flushing of dirty buffers.");
        this.set(2273, "Hold the quiesce hold process after drain phase and before freeze phase. At this point QDB_BLKPREP is set, so no transaction may enter the prepare state.");
        this.set(2274, "Simulate the error when the quiesce database agent process is trying to allocate memory for the qdblist structure. See also (HAUTILS, 53) and (HAUTILS, 54).");
        this.set(2275, "Revert to the earlier strategy in which a QUIESCE of the master database waits only until _prepared_ transactions have drained before proceeding with the QUIESCE operation. The default behaviour for the master database is to wait until _all_ transactions have drained before proceeding with the QUIESCE operation.");
        this.set(2276, "Trace Quiesce Database code");
        this.set(2277, "Simulate the error on notified instances");
        this.set(2278, "Simulate the crash on initiator instance after initializing quiesce context structure. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_ADD_TAG PCM request.");
        this.set(2279, "Simulate the crash on initiator instance after performing the drain operations. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_BLOCKXACT PCM request.");
        this.set(2280, "Simulate the crash on initiator instance before freezing writes. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_BEFORE_BLKWRITES PCM request.");
        this.set(2281, "Simulate the crash on initiator instance after freezing writes. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_AFTER_BLKWRITES PCM request.");
        this.set(2282, "Simulate the crash on smallest notified instance while servicing QUIESCE_FORWARD_RELEASE PCM request.");
        this.set(2283, "Simulate the crash on initiator instance before unfreezing writes. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_CLR_BLKWRITES PCM request.");
        this.set(2284, "Simulate the crash on initiator instance before before releasing dump lock. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_UNBLOCK_XACTS PCM request.");
        this.set(2285, "Simulate the crash on initiator instance after releasing dump lock. If 2277 is enabled, crash is simulated on smallest notified instance while servicing QUIESCE_REMOVE_TAG PCM request.");
        this.set(2286, "Trace Database Shutdown and Mount/Unmount code");
        this.set(2287, "Hold the database shutdown process after calling DBSHUTDOWN_GETADDR_LOCK() and DBT3_DBSHUTDOWN_FROM_ACCESS has been set in the dbtable. This is for testing the synchronization.");
        this.set(2288, "Simulate the crash on initiator instance after finishing DBSHUTDOWN_WAITTASKS stage. If 2277 is enabled, crash is simulated on smallest notified instance when it is about to start DBSHUTDOWN_WASHDBT stage. ");
        this.set(2289, "Simulate the crash on initiator instance when all notified instances finish DBSHUTDOWN_WASHDBT stage. If 2277 is enabled, crash is simulated on smallest notified instance when it finishes DBSHUTDOWN_WASHDBT stage. ");
        this.set(1601, "show how far we're getting at startup time");
        this.set(1602, "open model db in dsinit()");
        this.set(1603, "for use with the DataBase Machine version (our modified unix with async i/o) - use only standard unix calls for all disk i/o, pretending that you are running on standard unix (turns on R_ASYNC_OFF bit in Resource->rflag1)");
        this.set(1604, "trace memory initialization on startup. This will show the number of times that we request memory and the size of the block finally allocated.");
        this.set(1605, "Startup secondary engines by hand. MP only. Single network engine. NOTE: Bring up engines by hand will cause socket migration failure. All network I/O will be handled by a single network engine, engine 0.");
        this.set(1606, "Allow debug engines to be used. MP only.");
        this.set(1607, "turn off debug symbol table loading at start up time.");
        this.set(1608, "Bring engines online one at a time with dbcc engine(online). See NOTE of 1605.");
        this.set(1609, "Write an informational message indicating the interfaces file pathname.");
        this.set(1610, "Turn on TCP_NODELAY to defeat normal TCP data batching. Expect increased network traffic.");
        this.set(1611, "Enable nailing of shared memory into physical memory (if supported).");
        this.set(1612, "Space out sybase data pages on MRU/LRU such that sybase pages on the same OS page are far apart. May be forced on for some system (see page.h).");
        this.set(1613, "Set engine affinity to cpu's. (if supported)");
        this.set(1614, "Show how far we go during multiple network engine startup");
        this.set(1615, "Fail the migration channel setup - for unit testing");
        this.set(1620, "SGI-specific flag to allow data to be synched in with disk for open().");
        this.set(1621, "SGI-specific flag to allow use of Kernel Async I/O in place of sprocs.");
        this.set(1622, "Allow user to configure any number of engines (less than maximum value of \"max online engine\") irrespective of how many CPUs are available on the system. This is used for testing only.");
        this.set(1623, "To disable the dsync and direct i/o options for the file system devices. To be used for testing only.");
        this.set(1624, "To disable the dsync and direct i/o options for the master and HA master_companion devices only. If 1623 is used, this flag is not needed. ");
        this.set(1625, "To disable the O_SYNC option for the filesystem devices. ");
        this.set(1626, "Do not attempt to create sybsystemdb. See also traceflag, (DROP, 4)");
        this.set(1627, "Set Kernel->kimaxfd to whatever the limit is set on machine. Used in uicalcmaxfd(). ** OBSOLETE since CR 314222-1 **");
        this.set(1628, "Use original version of string comparison routines which do not handle fixed CHAR arguments containing characters < 0x20 (blank). When this trace is off (by default), use modified version of string comparison routines which correctly handle them for special callers of SQLSTR_HILO macro.");
        this.set(1629, "Do not start a seperate signal handler thread on platforms supporting signal thread.");
        this.set(1630, "OBSOLETE. Previously this would force Posix Async I/O on Linx and Solaris. This traceflag is now obsolete.");
        this.set(1631, "Separate timer thread.");
        this.set(1632, "OBSOLETE. Used to be a hack to send SIGPOLLs.");
        this.set(1633, "OBSOLETE. Make connectivity polled");
        this.set(1634, "Attempt graceful shutdown on NT when OS is shutting down (default is panic shutdown)");
        this.set(1635, "Blocks and unblocks SIGPOLL logically. This is needed so that we don't get interrupted at odd times (such as when we are in malloc()), since the signal handler for SIGPOLL as defined in connectivity does network IO in the handler itself.");
        this.set(1636, "Yield cpu when polling for disk i/o and cschedspins exhausted");
        this.set(1637, "(This trace flag is now obsolete.)");
        this.set(1638, "Forces the server interrupt clock from conventional setitimer(2) to (RT) Posix timers timer_create(3). The former default under Solaris was based on Posix timers set since \"ha2\". Given ASE under Solaris often hangs, CR 267970 lost signals (SIGALRM) this change is to make us go back to setitimer(2).");
        this.set(1639, "OBSOLETE. Block all signals before calling aio_... calls for Linux as they occasionally block internally causing any SIGALRM to interrupt and time-out the async run-time system under Linux.");
        this.set(1640, "Enable error logging for server async disk i/o platform errors encountered and log the problem within the servers errorlog.");
        this.set(1641, "This trace flag is now obsolete. Allow the server to run KAIO without O_DIRECT on Linux. For correctness aio_read() or aio_write() calls, when KAIO is in effect without O_DIRECT set should return an error with EINVAL set. Such does already happen on some file-systems The linux-aio workgroup decidede to let the request now go but turn the i/o's synchronous and not make them go to the disk, even when the application sets O_SYNC to have them handled fast making the illusion of Asynchronous. Booting ASE with traceflag 1641 is _not_ preferrable!");
        this.set(1642, "Allocate sockets for HBC (default is no sockets)");
        this.set(1643, "Remove ACL protection from memory object on NT");
        this.set(1644, "Disable full allocation of master device at startup. Writing out zeroes completely will not be done.");
        this.set(1645, "To enable direct I/O strategy for all devices. To be used for testing purposes only.");
        this.set(1646, "Simulate delayed I/Os by randomly returning SDTRYAGIN from basis_dstart(). Sanity only.");
        this.set(1647, "Log information about the number of file descriptors at startup");
        this.set(1648, "This trace flag is now obsolete. Allow the server to run KAIO with O_DIRECT on Linux. This change was first done in ASE12.5.3 ESD#3.");
        this.set(1649, "Allow the server to run native KAIO. This is applicable for linuxamd64 platform only and enables native KAIO.");
        this.set(1650, "Disable signals during disk init close() system call to prevent hangs on NFS mounts on IBM AIX5. This addresses CR 392779-1.");
        this.set(1651, "Don't lock any Archive Database Device (one that is a database dump stripe). With this option the device is opened readonly so that multiple archive databases can simultaneously use the device. However, this does not prevent backup server from writing to the device so that this must be manually prevented from occuring.");
        this.set(1652, "Turn off set file api to OEM at startup (WINDOWS ONLY)");
        this.set(1653, "Enable the HUGETLB flag. This will enable the kernel to request huge pages early in the boot time.");
        this.set(1654, "Disable batch I/O.");
        this.set(1655, "In kpcheckio, one ct_poll is called per pending ct-lib io. If this flag is set, ct_poll will be called only once.");
        this.set(1658, "Disables SHM_SHARE_MMU for Sun Solaris. Issue with SHM_SHARE_MMU for ISM is that when applied the initiated shared memory segment is physically locked down where the O/S can not page or swap the memory in case memory resources on the machine get very low. This turns under certain test scenarios problematic for multiple ASE servers around at the same time.");
        this.set(1659, "Force shared memory sanity cleaning when bootstrapping the ASE. Under NORMAL/OPT servers the memory with this traceflag applied is cleaned using a <zero> pattern. Under DEBUG/SYM servers the memory with this traceflag applied is forced to a fixed <alternating> pattern. This is good to hunt uninitialized structures, ASE_PCI unrevealed many already. See $DBMS/generic/ksource/blkmem/opsmshmem.c");
        this.set(1660, "Let ASE manage shared memory mappings.");
        this.set(1661, "To disable blocking network poll check when engine has ctlib pending io.");
        this.set(1662, "When set, exceptions in windows kernel threads will panic the server. (When not set, those threads just exit)");
        this.set(1663, "When set, exceptions on Windows will generate a core dump");
        this.set(3100, "Allows the load of a master database which was dumped with a different sort order/charset to the sort order/charset currently in use on the server. See the section \"Tech Support Notes\" in the description of CR 187566 for the correct usage of this traceflag.");
        this.set(3101, "Print dbinfo after restore from dump header and trailer.");
        this.set(3102, "Ignore durability at load time.");
        this.set(3171, "Skip check and rebuild indexes on all system tables in the post xpload processing during ONLINE DATABASE. (Debug purpose only. Not for customers.)");
        this.set(3172, "Skip all the post xpload processing during ONLINE DATABASE. (Debug purpose only. Not for customers.)");
        this.set(3173, "Traceprint sql command for post xpload processing during ONLINE DATABASE. (Debug purpose only. Not for customers.)");
        this.set(3174, "Delete log records prior to the last checkpoint log record during syslogs translation. (Debug purpose only. Not for customers.)");
        this.set(3175, "Skip delete statistics on system tables in preparation for upgrade. (Debug purpose only. Not for customers.)");
        this.set(3176, "Available for future use.");
        this.set(3177, "Skip the strict checking for log record before the cross platform conversion. (This checking allows only one log record after the last checkpoint log record.) (Debug purpose only. Not for customers.)");
        this.set(3178, "Override the requirement for a quiescent dump when loading cross-platform by disallowing BEGINXACT, DOL_UPDATE and ENDXACT log records to follow the recovery checkpoint. This disallows a flush of SYSTABSTATS that may be done by DUMP DATABASE itself, to follow the recovery checkpoint. 3151 error is raised if such log records are found after the recovery checkpoint. By default, X-platform load is able to convert (and hence recover) these log records. (Debug purpose only. Not for customers.)");
        this.set(3179, "Available for future use.");
        this.set(3180, "Force to build translation dictionary from INDDEF global, if loading from modern version. (Debug purpose only. Not for customers.)");
        this.set(3181, "Do not translate colidarray in Sysstatistics' index(Csysstatistics). It is translated by default. By this flag, dbcc reindex(sysstatistics) will always trigger the rebuild of this index during ONLINE, because of the error of key mismatch between index and datarow. (Debug purpose only. Not for customers.)");
        this.set(3182, "Available for future use.");
        this.set(3183, "Available for future use.");
        this.set(3184, "Traceprint translation of unallocated page which pageno field in page header is non-zero. (Debug purpose only. Not for customers.)");
        this.set(3185, "Traceprint each log record header after the last checkpoint during syslogs translation. (Debug purpose only. Not for customers.)");
        this.set(3186, "Traceprint info about sysstatistics colidarray translation. (Debug purpose only. Not for customers.)");
        this.set(3187, "Traceprint info about processing page in lddb__unscr_phys_page(), page number, object id, indid, pstat for system tables including allocation page. (Debug purpose only. Not for customers.)");
        this.set(3188, "Traceprint info about processing page in lddb__unscr_phys_page(), page number, object id, indid, pstat for user tables. (Debug purpose only. Not for customers.)");
        this.set(3189, "Print translation dictionary for system tables. (Debug purpose only. Not for customers.)");
        this.set(3190, "Traceprint object id for user objects when building translation dictionary. (Debug purpose only. Not for customers.)");
        this.set(3191, "Available for future use.");
        this.set(3192, "Traceprint time during XPDL conversion for each phase. (Debug purpose only. Not for customers.)");
        this.set(3193, "Enable LOAD DATABASE of the master database for cross platform. (Debug purpose only. Not for customers.)");
        this.set(3194, "Traceprint memory page allocation for a translation dictionary for user objects in lddb__unscr_alloc_dictpage(). (Debug purpose only. Not for customers.)");
        this.set(3195, "Do not release translation dictionary pages for user objects. (Debug purpose only. Not for customers.)");
        this.set(3196, "Force large I/O for phase 1. This is slow. (Do not use regular IO for phase 1.) (Debug purpose only. Not for customers.)");
        this.set(3197, "Available for future use.");
        this.set(3198, "Force regular I/O for phase 2. This is slow. (Do not use large I/O for phase 2.) (Debug purpose only. Not for customers.)");
        this.set(3199, "Mark non-clustered indexes on system tables suspect during cross-platform load database. This flag needs to be used if an upgrade during the online failed, and needs to be turned on for both LOAD DATABASE and ONLINE DATABASE.");
        this.set(4301, "print out xact state at beginning and end of ldxact()");
        this.set(4302, "kill server in ldxact's DBI_LOADING state");
        this.set(4303, "kill server in ldxact's DBI_RECOVERY state");
        this.set(4304, "reserved for OS/2 4.2 SQL Server (d420s_os2).");
        this.set(4305, "kill server in DBI_RECOVERY just before post-recovery flush of buffer cache");
        this.set(4306, "kill server in DBI_RECOVERY just *after* post-recovery flush of buffer cache");
        this.set(4307, "kill server in DBI_RECOVERY just *after* post-recovery flush of buffer cache and just before flushing DBI_NOTLOADING state into DBINFO. Likely no different from 4306.");
        this.set(4308, "kill server in loadlog(), after loading the pages and patching the log start&end but before flushing the syslogs pages to disk.");
        this.set(4309, "Print information about endsort log records and dbi_lastsortredone as they are updated/ acted upon during the course of ldxact recovery.");
        this.set(4310, "kill server in loadlog(), after loading the pages but before patching the log start&end. Though can be used in all case, this is introduced especially for the case where a standby_access dump is voided because the checkpoint marker in the dump is earlier than the current Dump Instant Marker. In that case, server will be killed before the sequence number in the dbinfo is advanced.");
        this.set(3902, "Crash in xact_commit() after 1st phase (prepare) of 2-phase commit in multi-database transaction. Recovery should roll back changes.");
        this.set(3903, "Crash in xact_commit() after 2nd phase (commit) of 2-phase commit in multi-database transaction. Recovery should roll forward changes.");
        this.set(3904, "Dump transaction log for current db.");
        this.set(3905, "Print out transaction state at xact__beginxact() and xact__endxact() time.");
        this.set(3906, "Mode 1: Neither Dump DB nor Quiesce DB is active. Flush the log and crash the server just before the ENDXACT record would have been written. This mode allows a test of boot time recovery. Mode 2: Dump DB or Quiesce DB *is* active. Flush log and hang current transaction just before writing ENDXACT. When Dump or Quiesce completes, current transaction will proceed to commit. This mode allows a test of Load DB recovery. In either mode, both redo and then undo will have maximum work on the tested command's transaction before that transaction is finally left undone. If you don't want unexpected server crashes, turn this flag on only just before it's needed, or you may get a nasty surprise, especially if another connection might set a trace flag. The module that treats this trace flag turns it off upon exit. For this trace flag, there is no need to perform DBCC TRACEOFF as a follow-up to DBCC TRACEON().");
        this.set(3907, "Wrap the entire transaction as a Nested Top Action. xact_begin() invokes gettopaction() to begin the NTA and xact_commit() invokes puttopaction() to close it.");
        this.set(3911, "DTC/XACT - shutdown before prepare starts");
        this.set(3912, "DTC/XACT - Always fail the prepare request");
        this.set(3913, "DTC/XACT - shutdown after prepare is successful");
        this.set(3914, "DTC/XACT - shutdown after preparereqdone is sent to DTC proxy");
        this.set(3915, "DTC/XACT - shutdown in commit transaction");
        this.set(3916, "DTC/XACT - shutdown after commit is successful");
        this.set(3917, "DTC/XACT - shutdown in abort transaction");
        this.set(3918, "DTC/XACT - shutdown after xact_abort() is complete");
        this.set(3919, "DTC/XACT - Log all DTC activity in errorlog");
        this.set(3920, "Simulate an attention during ML-DML commands after a random number of row changes (between 5 and 5000). The latest incomplete sub-command should be rollbacked.");
        this.set(3921, "Simulate an attention during ML-DML commands after a fixed number of row changes as stipulated by the \"set rowcount\" command. Latest incomplete sub-command should be rollbacked.");
        this.set(3922, "ML-DML diagnostics : - print log records being put, discarded or retained in/from the PLC. - print text related log records for which logging is being skipped. - print log records being flushed to Syslogs. - print Post Commit processing related info.");
        this.set(3929, "Trace the execution of PROBE.");
        this.set(3930, "Print out return status from PROBE in the commit service.");
        this.set(3931, "Print out explicit information about execution of xactmgr.");
        this.set(3932, "Print out more detailed information about tracing the execution of xactmgr.");
        this.set(3940, "Force all XA transactions to have the \"tightly coupled\" property. This is equivalent to having both the \"implicit attach/detach\" and \"ignore BQUAL\" properties set (trace flags 3941 and 3942) and is included for backward compatibility.");
        this.set(3941, "Force the \"implicit attach/detach\" property on all XA transactions. Every thread taking part in the transaction will implicitly detach from the transaction as the end of every SQL batch and then re-attach at the start of a new batch.");
        this.set(3942, "Force all XA transactions to ignore BQUAL. See the FAQ in xactmgr.c for information on transactions which ignore BQUAL.");
        this.set(3943, "Force hashing of all XA transactions to be on the entire XID. Effectively, this prevents the \"ignore BQUAL\" attribute from doing anything useful.");
        this.set(3944, "Disable pss->plasterror setting in abortcmd() and xact_rollback(). This traceflag exists only to provide breathing room in case of problems in the field. Future releases such as 15.0 should remove this.");
        this.set(3945, "In xact_beginupdate(), turn on the check that the DBTABLEs in both the XDES and the SDES are the same. Report the error via ex_raise().");
        this.set(3946, "If an XA native RPC handler call returns an error to its caller, do not send the client status as a TDS parameter. Omit the client status altogether.");
        this.set(3947, "Enable delayed commit by default.");
        this.set(3950, "Commands such as REORG REBUILD, DISK INIT that are normally disallowed as part of a multi-statement transaction under BEGIN TRAN will be allowed under this flag. This is ONLY MEANT for INTERNAL TESTING PURPOSES and is available only under SYM servers.");
        this.set(3951, "In some cases for transactions in databases with a durability of NO_RECOVERY like temporary databases and in-memory databases, we skip flushing log records from plc to syslogs. This optimization is skipped if this traceflag is turned on. Thus, if this traceflag is turned on, plc of the transaction will always be flushed during commit.");
        this.set(3952, "In xact__postcommit_processing(), print the entire log that is processed during post-commit.");
        this.set(3953, "Disable the fix for CR 452815 i.e. use a single locks chain for PLOID and XLOID cases during s_push() and s_pop() calls, as well as don't release in the XLOID case the statement and level 3 locks from each seqframe during LOCK_TRANLOCKS_RELEASE() calls.");
        this.set(3955, "Do not raise an error when beginning a transaction (explicitly or implicitly) if the P6_EXT_XACT_REQUIRED bit is set in the Pss and there is no active external transaction");
        this.set(3956, "Display diagnostic information about post commit work. ");
        this.set(3957, "Display the transaction name for which the PLC is flushed. This traceflag is introduced for checking the pinning related changes by t_driver testing.");
        this.set(3958, "Testing purpose: Hang the exececution thread after getting cluster map before doing pcm_vmcall in xact_search owner instance.");
        this.set(3959, "Testing purpose: Shutdown the instance (with instanceid=2) before replying in xact_pcm_callback.(Available only in debug mode.)");
        this.set(3960, "Use PCM mechanism to commit/rollback the transaction when connection migration to owner instance fails. (Available only in debug mode.) Instance specific, need to update d_checktrace() while updating or removing this traceflg.");
        this.set(3961, "Make extenal transction begin request hang after doing reservation.(Available only in debug mode.) Instance specific, need to update d_checktrace() while updating or removing this traceflg. ");
        this.set(3962, "In redo__prefoxact_is_takencareof(), hang the process immediately after entering the function. This can be used for testing scenarios like... - Analysis found txn in prepare, but it completed This traceflag is meant for testing and is available only in diagserver");
        this.set(3963, "In redo__prefoxact_is_takencareof(), hang the process before returning the final decision. Not all return places are covered. This is to test the cases where the transactions state changed after decision is taken. Currently, this is effective only while re-instantiating subordinate transactions. This traceflag is meant for testing and is available only in diagserver");
        this.set(3964, "In redo__prefoxact_is_takencareof(), hang the process after XID search(local & remote). This is to test the cases where the transactions is completed after it is found in memory. This traceflag is meant for testing and is available only in diagserver");
        this.set(3965, "Print out explicit information about extra work done by xactmgr in SDC environment.");
        this.set(3966, "Allow IMDB to be coordinating database in multi-database transactions when the participant database is master database. This is needed by QA because lot of existing testcase are failing because of the restriction");
        this.set(3967, "Print message if the user's choice at the database/table level is overridden for any reason.");
        this.set(3400, "Trace major paths of recovery. Should be invoked from command line, since recovery is called before parser.");
        this.set(3401, "Call recovery exerciser on current db.");
        this.set(3402, "Do a alloc upgrade during loaddb recovery. This trace flag is now obsolete.");
        this.set(3403, "Crash during an upgrade of a user database.");
        this.set(3404, "Raise exception while recovering user db to test out opendb afterwards.");
        this.set(3405, "Raise exception while recovering master db");
        this.set(3406, "Call finish_xact to recover xact if connection was dropped and xact was run under commit service.");
        this.set(3407, "Upgrade a pre-MP database to MP alloc structures.");
        this.set(3408, "Do a Trial upgrade of a pre-MP database to MP alloc (must be used in combination with 3407).");
        this.set(3409, "Enable DBCC REINDEX functionality, and allow System indexes to be rebuilt after sortorder changes for production database.");
        this.set(3410, "Crash during an upgrade of the master database.");
        this.set(3419, "Complete xacts seen in recoovery phase 1 Currently this flag is for development testing only. Do not use at customer sites.");
        this.set(3420, "turns on PAGEM, 20 (see below)");
        this.set(3421, "Do not allocate memory for VBITMAP structure in vbit_mapcreate() during recovery.");
        this.set(3422, "Enable PFTS diagnostic in buffer manager.");
        this.set(3423, "Enable PFTS diagnostic in recovery.");
        this.set(3425, "Print diagnostic information during recovery. In addition to general information about recovery, statistical information relating to recovery scans and the usefulness of PFTS are reported. The output is similar to that generated by DBCC showrecovery.");
        this.set(3426, "Don't truncate the log at the start of each upgrade step. This is a command-line flag and is added to assist debugging.");
        this.set(3427, "During boot time recovery during reinstantiation of the coordinator recovery task goes to sleep");
        this.set(3428, "During boot time recovery during reinstantiation of the participant recovery task goes to sleep");
        this.set(3429, "Server crashes after prepare of a local transaction with remote participants");
        this.set(3430, "Server crashes after updating syscoordinations before writing the commit record for transactions with remote participants");
        this.set(3431, "Crash server before writing prepare record if transaction is an external transaction.");
        this.set(3432, "Crash server after writing prepare record and before replying to the prepare request, if transaction is an external transaction.");
        this.set(3433, "Crash server after writing prepare record and after replying to the prepare request, if transaction is an external transaction.");
        this.set(3434, "Crash server before dtx marked as committed.");
        this.set(3435, "Crash server after dtx marked as committed and BEFORE local participant has committed.");
        this.set(3436, "Crash server after dtx marked as committed and AFTER local participant has committed.");
        this.set(3437, "Crash server when a astc commit rpc is received.");
        this.set(3438, "Recover only the system databases and tempdb No user databases are recovered.");
        this.set(3439, "For external transactions with remote participants, crash the server after preparing the participants, but before updating syscoordinations.");
        this.set(3440, "Terminate process when astc commit / abort request comes in. For testing. Not applicable to probe login.");
        this.set(3441, "Return failure after remote participants have prepared. Used to test ability to rollback transactions after a successful prepare of remote participants. For testing.");
        this.set(3442, "For external transactions, recovery sleeps after incrementing the pss count and before obtaining the address lock on the xdes while recovering a participant database");
        this.set(3443, "Disable PFTS during recovery.");
        this.set(3444, "Disable PFTS during runtime.");
        this.set(3445, "Disable APF Lookahead during REDO pass");
        this.set(3447, "Enable server errorlog printing during boot-time for recovery performance numbers.");
        this.set(3448, "Simulate flushed pages table overflow during analysis pass for testing purposes.");
        this.set(3449, "Print the content of PFTS Flushed Pages table during analysis pass.");
        this.set(3450, "In a multidb transaction, crash the server after the coordinating database commits ");
        this.set(3451, "In a sort operation, hang the process right after sort__end is called.");
        this.set(3452, "To test how the post commit work is handled by dump/load. This is added in xact__endxact to hang the process after all the commit work and before the post commit.");
        this.set(3453, "During the redo pass, allow the page timestamp to fall between the log old timestamp and the log new timestamp and also for the page timestamp to be behind the log old timestamp. In such cases, fix up the page timestamp to be the log old timestamp so that the current log record will be redone. Used to compensate for bugs in the recovery of sort. This trace flag MUST only be used in exceptional cases, and only where it is known that modifying the page timestamp is the correct thing to do. If not used wisely, data corruptions can occur.");
        this.set(3454, "Kill task when a astc forget rpc is received.");
        this.set(3455, "This is for TESTING ONLY. When this trace flag is on, ensure that each of the parallel recovery threads are affinitied to a different engine");
        this.set(3456, "When this trace flag is on, print information related to tuning such as the statistics results collected by the parallel recovery tuning thread");
        this.set(3457, "When this trace flag is on, recovery will collect diagnostic information related to performance measurement, such as the number of readwaits encountered for data and log and the number of buffer writes, etc. and print out those information to errorlog at certain stage.");
        this.set(3458, "Parallel recovery will spawn as many threads as indicated by the config parameter without checking for the verification routines. Useful for debugging. For example we can have single engine runs with multiple recovery threads ** THIS IS USED FOR DEVELOPMENT TESTING ONLY **");
        this.set(3459, "Testing only. Simulate a fatal error in the analysis pass if the number of log records processed for an even numbered database id > 2 is 100. See 3485, 3486 and 3487.");
        this.set(3460, "(FOR TESTING ONLY) Simulate a performance degradation on the second spawned thread.");
        this.set(3461, "(FOR TESTING ONLY) Keep the first sample.");
        this.set(3462, "(FOR TESTING ONLY) Simulate error in allocation of memory for rec_order_info.");
        this.set(3463, "(FOR TESTING ONLY) Simulate error in reading special recovery order from sysattributes.");
        this.set(3464, "(FOR TESTING ONLY) To test out exception handling, raise a fatal error while filling the recovery item information.");
        this.set(3465, "(FOR TESTING ONLY) To test out exception handling, raise a non-fatal error (EX_RESOURCE) after spawned some recovery threads.");
        this.set(3466, "(FOR TESTING ONLY) To test out exception handling, raise a fatal error after a database is recovered, and before the status bits in sysdatabases are updated.");
        this.set(3467, "(FOR TESTING ONLY) To test out exception handling, raise a non-fatal error (EX_RESOURCE) after the db is recovered, and before it is onlined.");
        this.set(3468, "(FOR TESTING ONLY) To test out exception handling, raise a fatal error while recovering databases by dbid order.");
        this.set(3469, "(FOR TESTING ONLY) Simulate error in spawning the second recovery thread.");
        this.set(3470, "(FOR TESTING ONLY) To test out exception handling within recovery core routines, raise non-fatal error during recovery. ");
        this.set(3471, "(FOR TESTING ONLY) To test out exception handling on signals, simulate a seg fault after a database is recovered, and before it is onlined.");
        this.set(3472, "(FOR TESTING ONLY) To test out exception handling during buffer pool tuning, raise a fatal error after the sizes of the pools are tuned, but before apf is tuned.");
        this.set(3473, "If this trace flag is on, do not recalculate the new size for largest io pool based on the number of cachelets.");
        this.set(3474, "If this trace flag is on, do not tune buffer pools for recovery.");
        this.set(3475, "If this traceflag is on, during failover recovery, buffer pools will be created or made optimal with appropriate size and APF for using large I/O.");
        this.set(3476, "If this trace flag is on, print some more diagnostic information regarding buffer pool tunings.");
        this.set(3477, "If this trace flag is on, bypass and reset the 'bypass recovery' bit for the master database.");
        this.set(3478, "Trace internal upgrade dependencies as they are called.");
        this.set(3479, "Trace Post commit processing during recovery");
        this.set(3480, "(FOR TESTING ONLY) Hang server before GAM extension (either during CREATE or ALTER DATABASE) commits. This is added in pg_gamalloc() to test recovery in such a crash scenario, whether UNDO will properly rollback the CREATE or ALTER DATABASE command.");
        this.set(3482, "Trace Distributed Failover Recovery");
        this.set(3483, "Disable SDCluster Distributed Failover Recovery");
        this.set(3485, "Testing only. Simulate a fatal error in the redo pass if the number of log records left to process for an even numbered database id > 2 is 100. See 3459, 3486 and 3487.");
        this.set(3486, "Testing only. Simulate a fatal error in the undo pass if the number of log records left to process for an even numbered database id > 2 is 100. See 3459, 3485 and 3487.");
        this.set(3487, "Testing only. Simulate a fatal error at the end of the undo pass for an even numbered database id > 2 is 100. See 3459, 3485 and 3486.");
        this.set(3488, "(FOR TESTING ONLY) Hang a top action that has used LSA. The task is hung after commit but before post-commit processing.");
        this.set(3481, "If the traceflag is enabled, post commit optimization done under CR 422687 will be skipped.");
        this.set(3484, "Do not retain the XITEM in the transaction table if a committed transaction in the LOAD TRAN zone that did a sort is entirely within phase I. The implication of leaving the XITEM _in_ the transaction table is that other log records done as part of the sort transaction (notably deallocations) will be redone and that this could result in data corruption.");
        this.set(3489, "Prints information on reacquired transactional locks during redo pass and determination of log boundaries during instance failover recovery.");
        this.set(3490, "Emulate that an error occurred after undo is completed but before we had a chance to release the locks. The locks release is skipped. Only used internally for Quasr testing of dbcc lock_release().");
        this.set(3492, "This trace flag is used to check postcommit functionality of deallocating the extent at recovery time. This is used in pg__deal_ext_commit() so as to hang the server after clearing the dealloc bits and before deallocating the extent during run time post commit.");
        this.set(3494, "Put boot recovery process into sleep queue before starting recovery of the user databases.");
        this.set(3495, "This trace flag is used to make redo functions skip the do_needed check for log records before recovery checkpoint and belong to transactions that are incomplete before recovery checkpoint, except for log records that are after the remembered first_lr_to_redo in the corresponding xfamily_entry.");
        this.set(3496, "Avoid to check whether an AT_SHUTDOWN database was properly shutdown and proceed with recovery regardless.");
        this.set(3497, "Force parallel recovery no matter the number of engines. For internal use only.");
        this.set(3500, "Turn off ckptproc FOR TESTING PURPOSES only.");
        this.set(3501, "Interpret recovery interval in ticks instead of minutes. This is used to cause checkpoint to run at shorter intervals than the current minimum, which is 9000 ticks for recovery interval = 1.");
        this.set(3502, "Print a message to the console every time a checkpoint is written for a db.");
        this.set(3503, "When checkpoint is done for a db, print information about last log record and new checkpoint record if needed.");
        this.set(3504, "Raise log-out-of-space condition from checkpoint(). This is for testing the checkpoint() API.");
        this.set(3505, "For PFTS testing only. Flush all dirty pages w/o writing CHECKPOINT logrecord when checkpoint is issued.");
        this.set(3506, "Force ckptproc() to die to test checkpoint restart. Also see 3634.");
        this.set(3507, "Parallel checkpoint diagnostics");
        this.set(3508, "Force parallel checkpoint to use configured number of threads.");
        this.set(3509, "When checkpoint_all( )is called, print the databases being checkpointed and from those that are active, the ones that are skipped.");
        this.set(3510, "Simulate failure return from xls_get_oldestactive_mrkr");
        this.set(3511, "Print messages related to checkpoint marker and oldest active marker during dump tran with no_log.");
        this.set(3512, "Force checkpoint process to issue checkpoint on databases.");
        this.set(3513, "Suspend system task in ckpt_chores for database with dbid 7. This is for internal testing of setting a database in single user mode while another system task is using the database.");
        this.set(3514, "Suspend user task that is setting database to single user mode.");
        this.set(2700, "Print out the normalized gathered statistics for a table.");
        this.set(2701, "Print out the statistics information read from systabstats.");
        this.set(2702, "Also build the statistics for a clustered index if such an index exists, or calculate the data row length and data page count for the table, although only a non-clustered index is specified in the UPDATE STATISTICS command. (Back out the fix for CR 218141).");
        this.set(2703, "Gather sample density if set");
        this.set(2704, "Print out row by row information as statistics are gathered.");
        this.set(2705, "Print out messages when systabstats values are recalculated since they have been detected as being inaccurate.");
        this.set(2706, "Print out trace information for multiple tempdb bindings.");
        this.set(2707, "Disable the multiple tempdb feature. This assumes that all user-created tempdbs have been dropped by the user. This flag should only be used as a server boot commandline flag. ");
        this.set(2708, "Enable Async Log for new database as it gets created. This is for testing only.");
        this.set(2709, "Disable optimizations for temporary databases.");
        this.set(2710, "TRACE_SCAN_CTX");
        this.set(2711, "Print statistics descriptors after they are cached in st_getstats().");
        this.set(2712, "Pick a random partition during an utility to test partition level ddl operation. This is a temporary trace flag till partition level update stats syntax is added.");
        this.set(2713, "Print the various maps used during update stats. The maps are used to figure out which partition, which columns require statistics update.");
        this.set(2714, "Print diagnostic information on temp table in-memory statistics.");
        this.set(2715, "Enables fix for an UPDATE STATISTICS issue where the next-to-last step could have a weight of 0. This fixes a boundary condition problem and a problem in the \"predicted available_steps\" calculation.");
        this.set(2716, "Enable auto-generation of temp table stats for private temp tables and store it in memory");
        this.set(2717, "Do not check for temp table. This is only used for unit testing purpose under SANITY.");
        this.set(2720, "Reports error if update statistics is used in a transaction, and disables any side effects of allowing update statistics in a multi-statement transaction ");
        this.set(2750, "Mount database - Print disk mapping details");
        this.set(2751, "Unmount/Mount database - allow commands when not in master.");
        this.set(2752, "Mount database - simulate duplicate insert error to test cleanup");
        this.set(2753, "Unmount/Mount - Print stack trace from handler");
        this.set(2755, "Unmount- hang after creating manifest - for testing");
        this.set(2756, "Unmount command - hang after shutting down some random number of dbs - for testing");
        this.set(2757, "Unmount - Hang the command after dropping random number of dbs - for testing");
        this.set(2759, "Unmount - simulate deadlock for begin lock");
        this.set(2760, "Unmount - simulate lock interrupted for begin lock");
        this.set(2761, "Unmount - simulate deadlock for prepare lock");
        this.set(2762, "Unmount - simulate lock interrupted for prepare lock");
        this.set(2763, "Unmount command - hang after dropping some random number of devices - for testing");
        this.set(2764, "Print diagnostics when compressing extended histogram.");
        this.set(2765, "This traceflag is used to rollback the create index operation for testing purpose.");
        this.set(2766, "Delay the commit process to test concurrent DDL feature. The task that enables the trace flag will wait (kept in sleep) till another task turns off the flag (wakes up the sleeping task). See DDL_WAITFOR_TESTKNOB for the usage of the trace flag.");
        this.set(2767, "This trace flag is used to TURN OFF the 'concurrent ddl' feature. This is a boot time trace flag i.e this should be used with command line ONLY. If this is turned on /off using DBCC then the trace flag will be IGNORED.");
        this.set(2768, "This trace flag will provide detailed information about the scan on the system catalog. This information includes - Catalog name. - Type of lock record. - Return status of lock_logical(). - Lock context chain. - ...etc.");
        this.set(2769, "Rollback xact after rebuilding all the indexes");
        this.set(2770, "Rollback xact after deallocating the index pages in dbr_repairindex()");
        this.set(2771, "Rollback xact after building the new index pages in dbr_newindex()");
        this.set(2772, "Rollback xact after rebuilding Clustered index and before rebuilding Non-Clustered indexes.");
        this.set(2773, "Rollback xact after deallocating the index pages in cri_ncrebuild()");
        this.set(2774, "Rollback xact after updating the system catalogs while rebuilding NC index.");
        this.set(2775, "For QA, the output of MOUNT WITH LISTONLY returns only the device names. Otherwise both database and device names are returned.");
        this.set(2776, "Rollback the execution time create table");
        this.set(2777, "Rollback BCP IN operation.");
        this.set(2778, "Shutdown the server t the end of BCP IN operation.");
        this.set(2779, "Disable print diagnostics when error 290024 (USEFUL_INVCOLLEN) is reported.");
        this.set(2781, "Enable fix of 552227-1 to check if the supplied default value's type matches the column type during table creation time.");
        this.set(2792, "Enable fix of 475139-1 to sleep on the DES_CLONED_STATE of the DES.");
        this.set(2793, "Pause AMC rollback. ");
        this.set(2780, "Short circuit log_to_virt() for In-memory databases.");
        this.set(2782, "Rollback Create database transaction.");
        this.set(2783, "Rollback alter database transaction.");
        this.set(2784, "Simulate the crash on initiator instance before committing the unmout transaction. If 2277 is enabled, crash is simulated on smallest notified instance while servicing UMT_UNMT_DRAIN_PREP_XACTS PCM request.");
        this.set(2785, "Simulate the crash on initiator before commiting mount transaction. If 2277 is enabled, crash is simulated on smallest notified instance while servicing UMT_UNMT_RELEASE_XACTS PCM request.");
        this.set(2786, "Simulate the crash on initiator after commiting mount transaction. ");
        this.set(2787, "Unmount- hang before starting recovery of mounted database - for testing.");
        this.set(2788, "This trace flag will print the events associated with the free list manager in the inmemory_storage cache.");
        this.set(2789, "This trace flag will pause the transfer of the table being transfered. the transfer pauses after each allocation unit.");
        this.set(2790, "Rollback crdb_create_from_catalogs() after hashing the pages of in-memory database.");
        this.set(2791, "Rollback crdb_create_from_catalogs() at the end of operation. Return FALSE instead TRUE.");
        this.set(2800, "Print out procedure cache in procinstall().");
        this.set(2801, "Print out procedure cache in procrm().");
        this.set(2802, "Print out procedure cache in procdbrm().");
        this.set(2803, "Bypass cache lookup in procget(). Force db read.");
        this.set(2804, "Print tree in procread().");
        this.set(2805, "Print tree in procwrite().");
        this.set(2806, "Print allocation conflicts for proc exerciser in proc_get() and deallocation errors in proc__deallocmem() and procrm().");
        this.set(2807, "Print resolution tree in res_sendtree().");
        this.set(2808, "The traceflag to check the presence of text of a procedural object. Warning: This is an un-documented traceflag and should be used as a last resort.");
        this.set(2809, "Print a tree's TEMPOBJs when it is being read from or written to disk. Often run in conjunction with 2804 and/or 2805.");
        this.set(2810, "On every read from sysprocedures, behave as if upgrading compiled object.");
        this.set(2812, "Advise whenever procedure's tempdb id gets remapped to session's current tempdb id.");
        this.set(2813, "Checks PROC_HDR to ensure that multiple tempdb info is setup correctly.");
        this.set(2830, "Tell us when we use more than 6 pprochdrs[]");
        this.set(2831, "Print page allocation info for a PROC_HDR off disk and from memory in proc_read(). Available under diagserver. Only PROC_HDRs that have subordinates are tracked here.");
        this.set(2832, "Turn ON the logical lock synchrnoization across readers and writers of the Partition condition object.");
        this.set(2901, "Hang in uppause() loop on fatal error, so debugger can be attached. DO NOT DOCUMENT THIS TRACEFLAG ANYWHERE. FOR INTERNAL TESTING USE ONLY.");
        this.set(2902, "For interactive use only (via dbcc traceon). DO NOT USE ON SERVER COMMAND LINE. As soon as this trace flag is turned on, it causes server to hang (the function used to hang is the same as that in 2901)");
        this.set(2903, "Don't hang in T 2901 when printing a message from parallel dbcc.");
        this.set(2904, "Don't hang in T 2901 if the file where the assertion fired is a .cpp file. This is a temporary tcf flag. It should be removed after Galaxy assertions are cleaned up.");
        this.set(2905, "Dump the line no. and stmt no. when an exception or assertion is generated while processing a TSQL procedure.");
        this.set(2906, "Don't hang in T 2901 if the file where the assertion fired is an optimizer file. This is a temporary tcf flag. It should be removed after Galaxy assertions are cleaned up.");
        this.set(2907, "When this traceflag is ON, and if CSMD is configured, trap on the error being raised and rather than dumping the shared segment, invoke trace_hang_on_fatal_error(). This allows for one to conditionally hang on particular errors of interest using the CSMD infrastructure.");
        this.set(2908, "TCF to disable dumping the query statistics in semigraphical form when an assertion is raised. Dumping this graph has been found useful in reproducing problems in stress tests. ");
        this.set(2909, "ASE will suspend all threads using the internal machinery of dbcc thread(stop) when any of the CSMD configured errors is raised.");
        this.set(300, "Force Sort-Merge Join wherever possible irrespective of cost.");
        this.set(301, "If ON filtering of rows done by rejected OR path will be taken into account by the best search clause path.");
        this.set(302, "Print index selection msg.");
        this.set(303, "messages from or.c");
        this.set(304, "turn off or startegy for special orstrings");
        this.set(305, "Print tree after applying transitive closure on SARGs.");
        this.set(306, "Disable temporary evaluation of known constant expressions (193261-1).");
        this.set(307, "Enable the fix for 215040. This allows the scoring of correlation joins with inner nullable column in NOT IN subquery.");
        this.set(308, "************ DISABLED **************** During optimizer cost calculation, use physical io cost and logical io cost value which is specified by dbcc tune wphysical/ wlogical command, instead of hardcoded cost value.");
        this.set(309, "Print Galaxy histograms.");
        this.set(310, "Print info about join selection.");
        this.set(311, "Print estimated logical/physical reads for all tables in plan.");
        this.set(312, "Print out estimates from j_clustcost()");
        this.set(313, "do fake index selection");
        this.set(314, "Print out sort avert logic.");
        this.set(315, "Print out JOIN and SARG structures.");
        this.set(316, "messages from qry_substitute()");
        this.set(317, "Print out work plan in j_cost()");
        this.set(318, "Force reformatting.");
        this.set(319, "Print info about reformatting.");
        this.set(320, "Turn off join-order heuristic");
        this.set(321, "Print out info on target list and index for reformatted table.");
        this.set(322, "Disable at boottime the fix for known subquery problem #3 (bugid 17230). 17230 insures that subqueries under ORs are not unnested, thereby insuring that correct results are returned in all cases. Disabling 17230 may return query performance for these queries, but incorrect results are also possible. NOTE - This trace flag only has meaning with old style trees. (pre-11.0) It has no meaning with new style subqueries.");
        this.set(323, "Enables LIKE optimization under OR predicates. In ase15x, this is removed and LIKE optimizations are enabled by default");
        this.set(324, "Print new subtree added by LIKE optimization for OR predicates.");
        this.set(325, "Disable the fix 219080. The fix allows costing of reformat plans even if a join is covered by some index. However reformatting may be costed only if the worktable generated by the reformat step is relatively small - in consequence reformatting plans could be much cheaper than regular join.");
        this.set(326, "Use arithmetic average for calculating statistics. Use extreme caution when enabling this trace flag as it rewrites the statistics with severe performance implications if not used correctly.");
        this.set(327, "Disable at boot time the fix for 71058 which made NE and ISNOTNULL sargable but not indexable.");
        this.set(328, "Disable reformatting.");
        this.set(329, "Enable 'fast first rows fetch' for cursor queries. Trace recycled, previously used up to 11.5.");
        this.set(330, "Disable alternate formula for calculating index scan selectivity. See 260091-1 for detailed info.");
        this.set(331, "Print \"Parallel_degree\" and number of threads");
        this.set(332, "Disable the fixes 227240 and 213467. The fixes change the order of the update of variables in an update statement.");
        this.set(333, "Switch between full and simple MIN/MAX optimization. When this trace is ON, the full MIN/MAX optimization[ bugid#71859] is disabled.");
        this.set(334, "Enable Join Transitive Closure server wide. This overrides the config option which disables or enables sort-merge and jtc together server wide.");
        this.set(335, "Print DSS Performance join transitive closure debugging messages.");
        this.set(336, "Disable join enumeration costing optimization related to join transitive closure.");
        this.set(337, "Enable alternate formula for calculation of index scan selectivity.");
        this.set(338, "Kicks of the Parallel Scheduler's Exerciser");
        this.set(339, "Turns on Optimization in a cluster style environment where node ids are kept track of. Primarily, used to exercise cluster related optimization and code generation code in a non-clustered environment");
        this.set(340, "Print processing info during Optimizer");
        this.set(342, "Do not try to generate lava nary NLJ operators.");
        this.set(343, "Trace the code generation of nary NLJ ");
        this.set(344, "Disable fix 167863-1 for join sarg and non-join sarg costing in the join path");
        this.set(345, "Print when simulated statistics are read");
        this.set(346, "Disable unique index check for isolation level 0 scans and update cursors on #temp tables (disable CR 238629-2 for #temp tables).");
        this.set(347, "Print Pop's Compressed/Expanded status");
        this.set(348, "Command line flag for printing information on columns or sets of columns which could have improved estimates if stats were available");
        this.set(349, "temporary undocumented flag to disable bug 269681-1 fix which trims blanks on sargs prior to decrementing to convert a GE into a GT for costing ");
        this.set(350, "print messages for special orstrings");
        this.set(351, "force or_score() to choose or strategy");
        this.set(352, "whitebox testing for orderby opt.");
        this.set(353, "inhibits SARG transitive closure generation (available in rel110x only) ");
        this.set(354, "print semi-graphical tree output of best plan ");
        this.set(355, "inhibit parallel TDS buffer merge");
        this.set(356, "inhibit parallel work table merge");
        this.set(357, "inhibit parallel result buffer merge");
        this.set(358, "allow pll hash scans of table and clustered index");
        this.set(359, "Removed in 12.0. Used 11.9.x do not reuse");
        this.set(360, "Disable fix 141017 that protects unique, allkeys EQ indexes.");
        this.set(361, "Debug: find premature releases of TDS merge lock.");
        this.set(362, "Will disable delta project");
        this.set(363, "Will force delta project to be chosen, provided 362 is off");
        this.set(364, "Use the sarg density instead of the join density for expressions like colname=@unknown_value. ");
        this.set(365, "Will enable delta project for queries with aggregates.");
        this.set(366, "This will violate transitive closure rule in generating scalars for Outer Join. Only serve as a test traceflag and will be removed when LAVA CG support for OJ Boolean is there.");
        this.set(367, "Print join diagnostics in join.c.");
        this.set(368, "Print exhaustive optimizer tracing output");
        this.set(369, "When turned on, introduces a hard optimizer costing bug, for AP testing. If not constrained by an AP, the optimizer would select a very, very bad plan, thinking it's cheap. This flag is on purpouse 369, with 370 missing and the others in the range 371..376, to reduce the risc of accidental turning on. THIS TRACE FLAG IS DANGEROUS!!!");
        this.set(370, "Prohibit aggregate optimization.");
        this.set(371, "Enables server wide the AP LOAD mode, from the default AP group ap_stdin (GID 1).");
        this.set(372, "Enables server wide the AP DUMP mode, from the default AP group ap_stdout (GID 2).");
        this.set(373, "Enables server wide the AP REPLACE sub-mode of the currently enabled DUMP mode. Ineffective when 372 is off.");
        this.set(374, "Prints statement and AP texts at association and capture time.");
        this.set(375, "Prints AP generation actions at capture and AP parse time.");
        this.set(376, "Prints AP application actions at association time.");
        this.set(377, "Print CgpPop plan information");
        this.set(378, "This will let incomplete operators to go through to execution, so that engineers can work on the");
        this.set(379, "Diagnostics output for tcids related to predicates participating in its elimination phase.");
        this.set(380, "Print Histogram manipulations for distribution map generation for Parallel Merge Joins.");
        this.set(381, "Print Distribution map for Parallel Merge Joins.");
        this.set(382, "inhibit predicate factoring and transformation Can be activated at session level (dbcc traceon) and/or command line level (-T).");
        this.set(383, "print message when a new conjunct is added by predicate transformation");
        this.set(384, "Enable Sort-Merge Join server wide. This overrides the config option which disables or enables sort-merge and jtc together server wide.");
        this.set(385, "Disable Search space reduction fix. This trace flag will enable searching all paths.");
        this.set(386, "Disable Compile time distribution map generation for parallel merge join");
        this.set(387, "Print tree after predicate factoring and transformation.");
        this.set(388, "Force the worktable built as DOL style regardless of the number of variable length columns.");
        this.set(389, "Switch on to enable RID retrieval costs to be accounted for by dynamic index OR strategy.");
        this.set(390, "Switch on to enable enhanced min/max pattern recognition (222387-1).");
        this.set(391, "Disable fix 240794 that only uses magic number if we can not interpolate (e.g. non-binary sort orders).");
        this.set(392, "Trace print during predicate elimnation phase");
        this.set(393, "(Defunct after CR 323644-1) Enable fix 256647 that uses DOL worktable");
        this.set(394, "Disable at boottime the fix 275497. This fix adds the cost for insert in a work table in j_extra_sortcost().");
        this.set(395, "Disable newid() to generate new values for every row.");
        this.set(396, "Consider min/max optimization only for single table queries. This flag is used in 12.5, but the code has not been ported to the old optimizer code path in galaxy.");
        this.set(397, "Disable at boottime the fix 320979 that lowers PREFETCH_NCIDTPGS_THRESHOLD value and does not factor prefetch during logical I/O estimation. This flag is used in 12.5, but the code has not been ported to theold optimizer code path in galaxy.");
        this.set(398, "Disable 337405 that adjust j_rowestimate() for outer joins scenarios. This flag is used in 12.5, but the code has not been ported to the old optimizer code path in galaxy.");
        this.set(399, "Used by OMNI for equjoin tracing");
        this.set(4100, "Print tree at various times in aggregate.c");
        this.set(4101, "Print tree at various times in aggregate.c");
        this.set(4102, "Print tree at various times in aggregate.c");
        this.set(4103, "Print tree at various times in aggregate.c");
        this.set(4107, "Print aggregates just before outer join processing. Compare this to 4101 which prints aggregates after outer join processing.");
        this.set(4110, "Switch on to enable ORs to be preferred to min/max. Eg switch on to enable 319389 (via 350392).");
        this.set(100, "Print tree after parsing.");
        this.set(101, "Print hashvals");
        this.set(102, "TRACEPRINT yyerror messages");
        this.set(103, "Print info off of each QBLOCK in chain");
        this.set(104, "Enable T/SQL lightweight procedures");
        this.set(105, "Allow mjoin, nljoin, no_so, no_si keywords to be to force sort-merge join at object level.");
        this.set(106, "Disable the raise of the warning messages 11732 and 11733.");
        this.set(107, "Enable ALTER TABLE DROP column.");
        this.set(108, "Allow dynamic variable binding in DDL.");
        this.set(109, "*NO-OP* Formerly used to inhibit non-ASCII characters from being recognized in SQL keywords, numeric literals, and punctuation. As of ASE 15.0, this is now the default. To restore the former behavior, use -T114.");
        this.set(110, "DISABLE Unicode parser feature for testing purposes.");
        this.set(111, "ENABLE Unicode parser feature tracing.");
        this.set(112, "ENABLE features requested by Cisco: - 30+ bytes identifier support by truncating all characters after 30 bytes. - Trigger logical table access by JDBC queries");
        this.set(113, "Don't remove quotes nor trailing blanks when processing the database name in ALTER/CREATE/DROP/USE/DUMP/LOAD/GRANT DBCC ONLINE DATABASE commands, when SET QUOTED_IDENTIFIER is on.");
        this.set(114, "Allow non-ASCII characters to be recognized in SQL keywords, numeric literals, and punctuation. Formerly, this was the default, and -T109 was available to inhibit it. From ASE 15.0 onwards, the default is that *only* ASCII characters are recognized in SQL keywords, numeric literals, and punctuation.");
        this.set(115, "When ON skip early node ordering in mk_andor() in preparation for norm2.");
        this.set(116, "Print the Abstract Plan when we encounter a fatal error in the AP-lexer.");
        this.set(117, "Send back unlimited syntax errors (default is to limit the number sent to avoid network deadlock)");
        this.set(118, "Allow no deterministic builtins within scalar SQL UDF. ");
        this.set(119, "Turn off the fix for CR 488239-1: Allow identity functions in SELECT INTO statements containing the UNION operation.");
        this.set(120, "Turn on the fix for CR 536186-1: Delete the same rows for self join query independent of the order of tables in the FROM list.");
        this.set(121, "Turn on the fix for CR 496556-1: Check the correlation name(tabname.colname), when matching the order by columns with SELECT list columns");
        this.set(200, "Print tree before optimization.");
        this.set(201, "Print plan after code generation.");
        this.set(202, "Print the data segment allocation table. This trace flag only takes effect when printing the plan after code generation (201) or printing the plan after the procedure is loaded (207).");
        this.set(203, "Print tree before preprocess and optimization.");
        this.set(204, "Print EVAL instructions and result constant for computing compile-time constant expression.");
        this.set(205, "Print tree after optimization but before code generation.");
        this.set(206, "Print sizeof() for query processing related (tree space and plan space, session) structures.");
        this.set(207, "Print the plan and DSEG table after the buffer space has been allocated during procedure loading.");
        this.set(208, "Print locking strategy");
        this.set(209, "Print diagnostic information associated with remapping objids for LOCKREQUESTS in s_remap_lockid. Useful for interpreting 208 error, state 6.");
        this.set(210, "Print log for the tran after insert or update. This can also be used to debug the log records for ALTER TABLE [ADM] commands as they are internally run as SELECT INTO.");
        this.set(211, "Print TMPOBJs after normalization, but before definition time objects are dropped.");
        this.set(212, "Print current and all enclosing scope's TMPOBJs at the start of compiling a scope.");
        this.set(213, "Print the unsorted DSEG_TBL, sorted DSEG_TBL and global e_pre_dseg_alloc which will be used to pre_allocate memory during execution.");
        this.set(214, "Tracepoint used for renormalization/ recompilation analysis and testing. Prints when and why renormalizing or recompiling is required.");
        this.set(215, "Print qualification subtree before and after an AND transformation.");
        this.set(216, "Enables the use of virtual tempdb name \"#tempdb\" to dynamically access session's assigned tempdb. Introduced with mult. tempdb feature.");
        this.set(217, "Print the Warnings if the columns in the select list with aggregates but columns not in GROUP BY list or select list contains aggregate functions but GROUP BY clause not specified.");
        this.set(220, "Kill server in seq_execute");
        this.set(221, "Calls ex_raise SYS_XACTABORT during normalizaton");
        this.set(222, "Calls ex_raise SYS_XACTABORT during preprocess");
        this.set(223, "Calls ex_raise SYS_XACTABORT during execution");
        this.set(224, "Calls ex_raise SYS_XACTABORT after recompile");
        this.set(230, "Noop for activating breakpoint thru sql");
        this.set(231, "Allow distinct optimization on outer joins queries.");
        this.set(232, "Inhibit the fix 210688. The fix adds fake convert node around local variables/parameters if the same variable is assigned and used to calculate its new value.");
        this.set(233, "Print tree of (access) rules attached.");
        this.set(234, "Print tree after attaching rule for fine grain access control");
        this.set(240, "Force recompile in hadto_recompile()");
        this.set(241, "OBSOLETE. Used to turn on proc compression in 10.x. Leave as noop for Cougar. Remove or recycle after 11.x.");
        this.set(242, "Trace addition of CONVERT nodes during data type normalization. Under this flag, if such an implicit conversion happens on columns from catalogs that were upgraded to larger sized types (BYTE -> short, for large columns and short -> int, for large users support) print info in the errorlog.");
        this.set(243, "Disable column expansion of procedural objects in syscomments.");
        this.set(244, "Disable at boot time the fix for 286078 which uses SHORTTEXT instead of MAXSTRLEN for unknown result length of the space(), replicate(), str(), and replace() builtins and dynamic SQL '?' parameters.");
        this.set(245, "Disable at boot time the fix for 311734 which removes an existing unused plan from the des chain before installing a new plan generated by exec proc with recompile.");
        this.set(250, "Force bus error/seq fault");
        this.set(251, "Simulate engine crash in seq_execute");
        this.set(252, "Simulate an out-of-memory condition during procedure plan load time when the queries' data segment is being allocated.");
        this.set(261, "Print at end of successful parallel execution.");
        this.set(262, "Simulate a failed over connection");
        this.set(267, "Print OJ degeneration info.");
        this.set(269, "Trace the updating of rgdepends in oj_predicatemap().");
        this.set(271, "Show the SELECT INTO statement built for the data copy step of AMC.");
        this.set(272, "Display useful tree transformations that are being done in pre_alttab.c. Print the reordered list of RESDOMs input to ALTER TABLE. (This list should have all RESDOMs in increasing order of column ids, with any ADD RESDOMs tacked on at the end of the list). Generate the modified tree at the end of preprocess phase.");
        this.set(275, "Print the root before and after subquery attachment.");
        this.set(277, "Print the OJ root and JINFOPLAN info at the start of com_attach_qual().");
        this.set(278, "Disable 293974 fix in sqx__reorder_preds() that reverts the order of subqueries to 119x (and previous releases) behaviour.");
        this.set(279, "Print that type of and where a conjunct is attached from com_attach_qual()");
        this.set(280, "Print CMD tree input to subquery transformations module and transformed CMD tree output from module.");
        this.set(281, "Print high-level text descriptions of what transformations and optimizations are being done on each subquery node.");
        this.set(282, "Turn off flattening into an equijoin during transformations. (Do not search for UNIQUE ranges during flattening, but do flatten).");
        this.set(283, "Turn off MIN/MAX optimization for subqueries of ANY type. (Non-correlated ANY subqueries are transformed to use MIN/MAX aggregate. This trace flag will turn off that transformation which happens as part of subquery xformations).");
        this.set(284, "Turn off check to identify tables which are candidates for duplicate filtering optimization.");
        this.set(285, "Print query tree after adding constraint subtrees for referential integrity checks.");
        this.set(286, "Disable mid-level materialization of correlated subqueries (bugid 138367).");
        this.set(287, "Print OJ_RGINFO blocks for parent query before and after moving subquery range entries to parent during subquery flattening.");
        this.set(288, "Print when grab or free auxiliary SDESes.");
        this.set(289, "(Defunct as of ASE15.0) Allow text/image/ADT columns in case expressions, materialized views (bugid 172433) and worktables created for UNION ALL.");
        this.set(290, "Print a message if distinct elimination based on uniqueness conditions has been applied to statement.");
        this.set(291, "For conditions with a VAR node on one side of the condition and an expression on the other side whose datatype is higher than the VAR's datatype and whose value is unknown before run-time, if this traceflag is turned on, then the expression will be casted to VAR's datatype in order to keep a possible SARG (this casting is called retrograde cast).");
        this.set(292, "Do not send DONEINPROC for any statements if the config option 'send doneinproc tokens' is set to 0.");
        this.set(296, "Turn-off bugfix 167180. This fix makes the builtin CONVERT() converts implicitly the date style datatype to INT4.");
        this.set(297, "Turn-off bugfix 81683. This trace flag is provided to eliminate bugfix 81683, in case of some unexpected side effects. This trace flag should be removed in a couple of rollups if the bugfix does not have any unwanted side effects.");
        this.set(298, "Turn-on 125533 and 194304. This trace flag is provided to suppress error 11055 for correlated Sybase outer joins.");
        this.set(299, "Turn-off bugfix 55952. This trace flag is provided to nullify bugfix 55952, in case some unexpected side-effects show up. This trace flag should be removed later. NOTE: This flag is internally used by sp_depends which creates a #temp table and calls itself recursively. If we decide to desupport this flag, we will have to breakup sp_depends into two sub-sprocs. For ase15.0.3 and later release, if this trace flag on, the cached statement plan can be reused for different session even if the statement involves temp tables. If the schema of recreated temp tables is the same as the previous temp tables, the cache statement plan will be reused. ");
        this.set(7701, "In case of decryption failures on NT, dump any decrypted text to the client. See CR 206054-1 for the motivation for doing this.");
        this.set(7702, "Turn on bugfix 255696. This trace flag is to enable the wrapper codes for connectivity comnb conversion routines for NUMERIC datatype.");
        this.set(7703, "Turn off 210688. Do not protect local variables being on resdom and source/qualification side. WARNING : should not be removed without providing some other way to obtain pre-210688 functionality.");
        this.set(7704, "Disable fix introduced by 289413, so at compilation time isolevel set to compile is based on last \"set isolation level\" seen except for ISOLEVEL_CHANGE recompilation.");
        this.set(7705, "When this flag is ON some fields will be truncated in the TDS_ROWFMT2 protocol. his will help to reduce network traffic.");
        this.set(7706, "When ON alter table modifying/dropping column will trigger stored procedures recreation from the text, not simple renormalization. When OFF simple renormalization will be done.");
        this.set(7707, "Enable pre-208645 behaviour, re-adding join clauses unconditionally at the beginning of the ROOT node.");
        this.set(7708, "Turn off 327560-1 fix, so internally generated columns for some 'order by' or 'group by' clauses could be inserted when using an insert-select statement.");
        this.set(7709, "Enable pre-326477 behaviour. 326477 avoids adding convert nodes and in-place converts for INSERT,UPDATE resdoms for stored procedures and triggers. As a result the original query tree is not affected and may be correctly renormalized if necessary.");
        this.set(7710, "Disables 344403 that avoids the conversion in-place for NUMERIC constants when they are used inside stored procedures.");
        this.set(7711, "Testing functional indexes feature. This trace flag is enabled to print out all the expressions in a query that are recorginized as functional index keys.");
        this.set(7712, "metrics debugging");
        this.set(7713, "Testing : when ON all SELECT/INSERT/DELETE and UPDATE statements will be transformed and executed like execute immediate. Used to test 367546 changes.");
        this.set(7714, "When set, this prints debug information for literal parameterization");
        this.set(7715, "When set, prints statements before and after literal paramterization.");
        this.set(7716, "Turns paramterization for statement caching OFF, when set");
        this.set(7717, "When set, turn off the large identifier capability checks and could send long name to the pre-15.0 client.");
        this.set(7718, "Disable orphan tables' garbage collection done by HK.");
        this.set(7719, "For testing; Force a temp table to be orphaned so that we can test if HK Chores garbage collects the table.");
        this.set(7720, "This trace flag is used to know the various activities done on sysprocedures and procedure cache. The set of activities depends on the type of client like procedure, view, or constraints.");
        this.set(7721, "Insert convert node under AOPONCE to force conversion to nullable char types. This will change the result length as blanks will be trimmed.");
        this.set(7722, "When set, turn off caching statements other than singleton inserts.");
        this.set(7723, "For testing the p_ssql_recomp_plan_flushes monitor counter: when this traceflag is on, force-mark all the query plans associated with a cached statement to PROC_NOCACHE, so that they won't be reused.");
        this.set(7724, "This is used to disable/enable qpmetrics lazy dumping feature.");
        this.set(7725, "When set, during parameterization for AP load purpose, 15.0.1 style autoparam names will be generated for backward compatibility. ");
        this.set(7726, "This is used to disable/enable TPCC performance improvements of optimized permission checks.");
        this.set(7727, "Disable grouping of numerics for literal parameterization.");
        this.set(7730, "Switch OFF deferred compilation.");
        this.set(7731, "Apply deferred compilation for all possible cases. Used to test the feature. When OFF only selected class of statements is using the feature.");
        this.set(7732, "When ON apply deferred compilation even if the plan generated at runtime exists already. Used for testing.");
        this.set(7733, "When ON recompilation will be done using deferred mechanism. This maybe done only for statements already compiled in deferred mode. As a result only single statement will be recompiled not the whole procedure.");
        this.set(7734, "Tracing messages for deferred compilation. Internal only.");
        this.set(7735, "Skip deferred compilation for CIS.      ");
        this.set(7736, "Toggle between two modes of initial compilation for a statement marked for deferred compilation at runtime. When OFF initial compilation will stop after preprocessing. When ON initial compilation will generate first available plan.");
        this.set(7737, "Disable the fix for 466998 that adds a new phase at preprocessing which tags EQ nodes that will need NULL=NULL semantics with OP_MATCHNULL. This could be removed in the next release (15.0.3) if code behaves as expected.");
        this.set(7738, "Enable statement cache userid sharing. When it is on, a plan could be shared among different uids.");
        this.set(7739, "Enable literal parameterization for strings in LIKE pattern and escape clause");
        this.set(7740, "Enable the s_mustrecompile Optimization.");
        this.set(7741, "Enable the fix for 497118 so NULLs sent in host params are allowed even with incompatible datatypes and statement cache active. As a side effect, statements with NULL values in host params are not entered in the statement cache.");
        this.set(7742, "Apply deferred compilation for fastpath queries.");
        this.set(7743, "Disable deferred compilation for SELECT INTO.");
        this.set(7745, "Do not parameterize literal for the numeric literal in IN LIST and do not cache this statement also.");
        this.set(7746, "When resolving the result datatype of a relational operator or a binary operator, If the result datatype is SYB_VOID, do not set its result datatype to a specific datatype, let the casting function to handle it. Disable 571615 fix.");
        this.set(7747, "Parameterize literals inside isnull() builtin function if literal autoparam is turned on.");
        this.set(7748, "Do not cache parameterized language statements having parameters with numeric values that do not match the parameter format.");
        this.set(501, "Print rows before inserting/updating them.");
        this.set(502, "Print columns from sub list after getnext.");
        this.set(503, "Do not send TABNAME, COLINFO datastream");
        this.set(504, "Do not send TIMESTAMP");
        this.set(505, "Uses an adhoc mechanism to bind a tuple to range partitioning using a binary search");
        this.set(506, "This generates repartitioning scenario and is used for some lame testing for now.");
        this.set(507, "This generates hash based re-partitioning and is used for testing of JP Weinberger's hash fn");
        this.set(508, "This generates hash based re-partitioning and is used for testing of DBC-Low hash fn. But 507 has to be turned on too");
        this.set(509, "This generates hash based re-partitioning and is used for testing of DBC-high hash fn. But 507 has to be turned on too.");
        this.set(510, "Turn off subquery result caching.");
        this.set(511, "Fix subquery cache size at 1 row.");
        this.set(512, "Fix subquery cache size at 5 rows.");
        this.set(513, "Fix subquery cache size at 50 rows.");
        this.set(514, "Prints debug info for the hash buffer");
        this.set(515, "Prints debug info for the LeRIFilterOp and LeSQFilterOp.");
        this.set(516, "Print messaging information for LAVA thread management.");
        this.set(517, "Allow set_appcontext to overwrite a attrib value if the length are same.");
        this.set(518, "Print out LeCache metadata.");
        this.set(519, "Turn off streaming sort in the LeSortOp. When enabled, LeSortOp will first fill a worktable and then pass it to sort instead of streaming the rows to sort. The sort buffers are claimed/unclaimed by sort manager. The buildoption passed to sort() is GETSORTED for sort data and SORTBUILD for sort and build an index on worktable.");
        this.set(520, "Print the subquery cache when it's searched.");
        this.set(521, "Print subquery cache statistics when it get's adjusted.");
        this.set(522, "Does assertion checking to verify that pages are allocated from the correct MTDB. This traceflag is used only for MTDB unit testing.");
        this.set(523, "When an ESP has no parameter declaration list, send at exec time supplied parameters anyway. It will disable the fix for CR 280073.");
        this.set(524, "Prints needed stack size and available stack size when getting into internal sql.");
        this.set(525, "Prints the stats for sort-merge join");
        this.set(526, "Prints a semi graphical tree representing the query plan when showplan is also on.");
        this.set(527, "Make all LeCaches be single-row caches using the LEVTUPLE_ROWFORMAT cache storage format - for testing.");
        this.set(529, "Print diagnostic information for runtime partition elimination processing.");
        this.set(530, "Change RI checking semantic to MATCH FULL.");
        this.set(531, "Trace Thread management in Lava. Must be used with 3605 flag so child thread traces can be displayed.");
        this.set(532, "Trace Thread/Pipe management in Lava. ");
        this.set(533, "Place XCHG operator above SORT node for CgJPNode trees.");
        this.set(534, "Dump Lava pipes timings and sleep counts. ");
        this.set(535, "Turn off CR 426091-1. This CR lets the Alfa thread closed shared work tables for parallel reformatting plans.");
        this.set(540, "Print details of composite objects (e.g. Vtuples) of Lava operators. This is only done in conjunction with 560.");
        this.set(541, "Print group-sorted rows as they're being returned. This can also be enabled using trace 502.");
        this.set(543, "Trace flag to enable group-sorted vector aggregation through the CgJPNode path. This is ONLY for testing and will not be needed after the group-sorted operator is integrated with CgPops.");
        this.set(544, "Trace flag for analyzing problems with Lava engine compute clause implementation. This will probably go away once it's fully implemented and debugged.");
        this.set(545, "The cardinality (the number of tuples returned) for each operator is dumped when it is released. This is useful for debugging incorrect results and analyzing query performance issues.");
        this.set(546, "Trace flag to test RTA (runtime ajustment).");
        this.set(547, "Pause for 20 seconds in GenLava() after CgGenLava() is called, but execution context is completely setup.");
        this.set(548, "Trace flag to force RTA recompile.");
        this.set(550, "TF to dump Lava plans right before they've been opened. However, all resources have been acquired. Plans will be printed for each child as well. The disadvantage of this flag is that child output in parallel plans will be confusingly interleaved and the plan will be dumped for each execution (which may be too much in procedural loops). TF 201 is an alternative to this.");
        this.set(551, "If ON, calculate the pipe buffer size to make the buffer hold more rows in each buffer. (If trace flag 551 is on, allow lava code generation of magellan plans from the old optimizer.)");
        this.set(552, "If ON, allocate less pipe buffers than if it off. Hope this can catch more hang due to no more pipe buffers available.");
        this.set(553, "Force materializations in the CgJPNode path to lava execution - makes the lava plans look more like the old execution plans.");
        this.set(554, "If ON, don't build a CgJPNode tree from a JPLAN list (the old Optimizer) and code generate a Lava execution plan from this. This is a command line trace flag.");
        this.set(555, "Force subquery execution and comparison of results with cached value (sanity check).");
        this.set(556, "If on, call acquire at compile time for stored procedures with lava plans.");
        this.set(558, "Dump the pipe number that a thread is writing to or reading from when doing hash repartitioning.");
        this.set(559, "Print CgJPNode tree after translating old style JPLAN list into lava plan. (Print the Pop tree at the start of GenLava())");
        this.set(560, "Print CgSarg info during code generation. (only in a SANITY server). (Print the target list EVALs for both select and assignment statements), (Print CgJPNode tree with more detail than flag 559).");
        this.set(561, "Print result buffer merge.");
        this.set(562, "Print tuples being sent through pipe.");
        this.set(563, "Print work table merge. See 564 also.");
        this.set(564, "Causes 563 to print work table rows.");
        this.set(565, "Print when merge lock is acquired or released. Note: compile qryproc/plltbmrg.c with SANITY.");
        this.set(566, "Do not truncate CHAR/BINARY values when converting them to VARCHAR/VARBINARY in the LeHashOp and in worktable rows.");
        this.set(567, "Available for REUSE.");
        this.set(568, "Print out what the LeEmitop is sending.");
        this.set(569, "Generate some cases of partition parallelism REMOVE AFTER LAVA PROTOTYPE.");
        this.set(570, "Pause for 20 seconds between Phase I and II of RID based scan for concurrency testing.");
        this.set(571, "Force outer join processing in MergeJoins.");
        this.set(572, "Modify a MergeJoin to have semijoin behavior. of a NLJ operator. REMOVE AFTER LAVA PROTOTYPE. ");
        this.set(573, "Create a bushy tree with a single scan node on the left");
        this.set(574, "Debug Lava MergeJoin operator.");
        this.set(575, "Test Cloning in the Lava operators.");
        this.set(576, "Print LeVtuples when reading or writing data rows.");
        this.set(577, "Tf that will dump the rows returned by the MergeJoin operator.");
        this.set(578, "Mark XCHG operator as needing ordering");
        this.set(579, "Prints hashop's input's datasizes (for the first level of processing). This also suggests an appcontext setting to be used. However, these appcontexts are currently not supported and it may make more sense to support this through APs anyway. Good chance this TF will be deprecated.");
        this.set(580, "Print progress of parallel query execution.");
        this.set(581, "Print child thread object statistics after query execution.");
        this.set(582, "Print child thread subquery statistics after statement execution.");
        this.set(583, "Print child thread done packet after statement execution.");
        this.set(584, "Print copied query plan in cem_copy_plan().");
        this.set(585, "Print the new parallel degree after runtime adjustment.");
        this.set(586, "Print the new adjusted plan after runtime adjustment.");
        this.set(587, "No plan copy during runtime adjustment, for debugging purpose only.");
        this.set(588, "Print Parallel Exception Handling information");
        this.set(589, "Obsoleted. Used to be active for pre-1502 esd2 release to close a cursor implicitly during a cursor FETCH and after an error was hit. This is now the default behaviour.");
        this.set(590, "Print messages indicating the creation, partitioning, and population of partitioned work tables. This trace flag is used to support QuaSR testing of parallel query execution involving partitioned work tables.");
        this.set(591, "Print the create pipe, open pipe, close pipe, destroy pipe, grab pipe buffer, free pipe buffer infomation.");
        this.set(592, "Force run-time adjustment during parallel execution by simulating a session parallel degree smaller than a query parallel degree.");
        this.set(593, "Force run-time adjustment during parallel execution by simulating runnin out of worker threads.");
        this.set(594, "For debugging LeCache class and its methods.");
        this.set(595, "Used for cache testing. Emit operator sends the tuples to client and reinits cache when the row_number % 5 == 0.");
        this.set(596, "Print column offsets when reading/writing in pipe and number of PIPEBUFs allocated (LAVA engine only).");
        this.set(597, "(DEPRECATED) This flag is no longer used. However, we keep it reserved for now in case we can figure out how to hook up the \"set plan for show_exec_xml to message on\" behavior in an automated fashion under a TF for debugging purposes. Print an XML version of the Lava plan. This can then be viewed by the XML plan viewer.");
        this.set(598, "Enable bugfix 273692 (part 1). Obtain the first text page locks earlier that would normally be the case, by acquiring them in run()'s E_SROW or E_CURASSIGN action, instead of doing it later in the E_STEXT action. This will force any errors, for example a deadlock, before the client sees the TDS_ROW token, and will prevent messing up the TDS stream.");
        this.set(599, "Enable bugfix 273692 (part 2). Obtain the textptr home location exclusive lock earlier than would normally be the case, by acquiring it in updtext(), instead of doing it later in update(). This should reduce the likelihood of deadlocks produced when two tasks simultaneously UPDATE and SELECT text/image data from the same row. For APL tables, use of this trace flag may be counter-productive because deletion of any non-clustered index entries will be done with this lock held. The exclusive lock may therefore be held for an unacceptably long time, and may hence cause more deadlocks (see bugfix 74393).");
        this.set(2501, "Allow the execution of dbcc dbcacheremove even if the dbtable keep count is not off. This trace flag exists for in-house development testing, not for field support.");
        this.set(2502, "Unused");
        this.set(2503, "Unused");
        this.set(2504, "Unused");
        this.set(2505, "Print the name of of the database in match_dbname().");
        this.set(2506, "Force checkalloc() to use page reads, also disable the use of MRU extent prefetch in checktable().");
        this.set(2507, "Make \"NOFIX\" the default fix option.");
        this.set(2508, "Check when executing DBCC TRACEON() if a traceflag is internal. If so, perform some checks and raise messages accordingly.");
        this.set(8399, "This traceflag has been retired. Do not re-use this number. It was previously used by a number of applications to enable the field_name column in the sysmonitors table. The check for this traceflag has been removed from the code but existing apps may still be setting this traceflag.");
        this.set(2509, "Unused");
        this.set(2510, "Unused");
        this.set(2511, "Suppress reporting error message 15082 for 0 used/unused OAM entries when checkalloc(), tablealloc(), indexalloc() or textalloc() are invoked with the fix option disabled.");
        this.set(2512, "Bypass syslogs when doing checkalloc(). This will avoid spurious errors on syslogs.");
        this.set(2513, "Detect the 2558 error related conditions and print releated message when checkalloc() and tablealloc() are invoked.");
        this.set(2514, "Print diagnostic info from dbcc checkstorage parent thread. Work schedules and message traffic.");
        this.set(2515, "Perform UNIT tests for dbcc checkstorage.");
        this.set(2516, "Be persistent in checking page chains. Follow the chain as far as possible. This may generate many additional faults.");
        this.set(2517, "Tell dbcc checkstorage to not record counters. This is useful to speed up the operation when the counters will not be used.");
        this.set(2518, "Check for reserve bits when checking consistency of tables. Report error if found set. Note: MUST BE USED WHEN DATABASE IS IN A QUIESCENT STATE. dbcc checkalloc when used after invoking this trace flag will report any error if any reserve bits set. Otherwise, normal operation of dbcc checkalloc will SKIP extents/pages whose reserve bits are set.");
        this.set(2519, "Used as both a session and command line traceflag. Calls SYB_ASSERT during DBCC CHECKSTORAGE on encountering a hard fault. In SDC setups under dataserver it prints diags while checking text page chains, FTP or st-node, that result in error 100030 (TCV_PGFORM_ERR).");
        this.set(2520, "Hang on EX_CONTROL severity errors in parallel dbcc. This is a diagnostic flag for debugging some silent failures.");
        this.set(2521, "In SDC, enable cache coherency at checkstorage workspace scan phase.");
        this.set(2522, "In SMP and in SDC when running single node, disable cache coherency at checkstorage workspace scan phase.");
        this.set(2531, "allocinfo built-in is not exposed to the users so its functionality is available only when this traceflag turned ON, The built-in is for internal use only.");
        this.set(701, "Obsoleted. Do not reuse. See trace flag 752.");
        this.set(702, "Expected performance improvement in memalloc() for PROC_HDRs that have a lot of subordinate PROC_HDRs. This can typically happen during the parse and compile phases of large SQL batches. When we can't find free space in the last page of the last established PROC_HDR, then only search for free space in the previous pages of this PROC_HDR, instead of going back to the head of the chain of PROC_HDRs. Note that this trace flag doesn't apply to the PROC_DONTSEARCH clients.");
        this.set(710, "Prints message when allocating/freeing proc-hdr");
        this.set(711, "Initialize freed memory blocks. Useful for diagnosing memory corruption. It's the default behaviour under SANITY. ");
        this.set(712, "Turn off engine local memory optimization");
        this.set(716, "Turnoff the engine local cache in object pools");
        this.set(717, "Pre-12.5 only. Prints a message when a split 4K memory allocation is done by memalloc_2pgs().");
        this.set(718, "Commandline traceflag to turn on the heap memory tracking mechanism to store caller's filename and line number at the end of each memory fragment");
        this.set(719, "If this traceflag is on, server will ex_raise if the proc_hdr memory count stored in the pss->pmemusage and counts in proc_hdr mismatches or pss->pmemusage become negative.");
        this.set(720, "Turn off the proc_hdr memory mismatching warning to avoid it fills up the errorlog. ");
        this.set(721, "Dump the shared memory if ubfcleanup() failed.");
        this.set(722, "Enable heap memory checks to detect possible memory corruption. Automagically enables 718.");
        this.set(723, "Enable printing of diagnostics in the errorlog for memory manager errors.");
        this.set(750, "A tcf that tracks and prints the number of bytes allocated from the Lava runtime PROC_HDR by LeOpAcquire().");
        this.set(751, "enable stack trace for NOSYSMEM memory allocation failures.");
        this.set(752, "Disable procmem control structure mgmt and procmem statistics. Do not use this traceflag trivially as there are performance implications. The consumers of the memory allocation search hint in pre-15.0.1 servers now make usage of the lastphdr stored in pmctrl.");
        this.set(753, "Disable large allocation auto tune in memory manager.");
        this.set(755, "Validate the last prochdr setting by scanning all the sub prochdr to determine the lastphdr. This validation is only done in diagserver.");
        this.set(756, "In dataserver, print last chance cleanup information for procedure cache. The print is always on in diagserver.");
        this.set(757, "Reduce scale down for large allocation auto tune by replacing a procedure before scaling down. This is expected to reduce a performance drop in an ASE with a large procedure cache when it is almost full.");
        this.set(800, "Print err msg if buffer keep for already kept bp");
        this.set(801, "Print buf info every time buffer cleaned");
        this.set(802, "Print buf info for every read");
        this.set(803, "Print buf info for every write");
        this.set(804, "Print buf info for every buffer grabbed (i.e., info about the pg that was in buffer)");
        this.set(805, "Print buf info for dirty buffer being flushed by bufgrab");
        this.set(806, "Print page and buff status if cleaning a buffer that is dirty, rlocked, kept, etc.");
        this.set(807, "Double check BUF_SPECIAL processing in bufgrab");
        this.set(808, "Make failure in bufunhash a fatal error.");
        this.set(809, "Print some information when a deallocated page is brought into cache.");
        this.set(810, "check buffer async write events.");
        this.set(811, "trace buffer async write events.");
        this.set(812, "enable I/O greater than 16K. DANGER: you better know what you're doing if you enable this!");
        this.set(813, "Yield after unlatching a buffer. This flag is useful for generating MP like race conditions while running on UP machine.");
        this.set(820, "CLUSTER changes of disabling named caches multiple buffer pools are enclosed under this trace flag. Thus if this trace flag is enabled named caches and multiple buffer pools will be enabled. ");
        this.set(821, "Put the assertion that a buffer should be in BUF_NOT_VALIDATED or BUF_PG_IN_DEALLOC under this trace flag.");
        this.set(822, "Check for a possible negative keep count problem due to engine local caching.");
        this.set(823, "Diagnostics check to detect if a task has pre-dirtied a buffer and forgotten about it. Do not change this traceflag without looking at TRACE_BUFFER_23 macro.");
        this.set(825, "Force hk gc to die for testing restart. Also see 3634.");
        this.set(826, "Force hk chores to die for testing restart. Also see 3634.");
        this.set(827, "Force hk wash to die for testing restart. Also see 3634.");
        this.set(828, "Validate the cache after a dynamic cache operation.");
        this.set(829, "Perform a sanity check on a MASS after it has been read from disk. Print diagnostics on failure.");
        this.set(830, "Perform a sanity check on a MASS after it has been written to disk. Print diagnostics on failure.");
        this.set(831, "Perform a sanity check on a MASS before it is written to disk. Do *not* print diagnostics on failure. To be used when -T830 indicates MASS sanity failure after a write, to determine if the corruption was there before the write as well. In such cases, use both -T831 (to detect the pre-write failure) and -T830 (to print diagnostics after the failure).");
        this.set(832, "The checks done by the 829, 830 and 831 trace flags are only done on MASSes that are hashed and belong to a database that is in a fully useable state. If the checks are needed despite these restrictions, the 832 traceflag can be used to perform the checks regardless.");
        this.set(833, "Don't raise B_QDB_BLOCKS_WRITES message when this trace is on. This to prevent applications like Rep. Server to abort the transaction when a database is not available for a while because of a quiesce state on that database.");
        this.set(834, "Don't prefetch pages in a compressed block when the requested page is an allocation page.");
        this.set(835, "Disable APF on compressed blocks in Archive databases.");
        this.set(836, "Disable flushing dirty pages of tempdb by HK wash process.");
        this.set(837, "Skip I/Os if the cache is used for in-memory cache devices");
        this.set(899, "This is an internal traceflag to disable the fix by 480403-1. It is meant only for isolating the said fix, so that its performance impact can be measured. Enabling this traceflag may cause unnoticed corruptions. This traceflag should be removed after the performance measurement is complete.");
        this.set(402, "Print out order by optimization information.");
        this.set(403, "Galaxy development trace to enter old optimizer code path the previous usage of Disabling fix introduced by 319374 is not relevant for the galaxy optimizer");
        this.set(404, "Traceout messages when destroying objects");
        this.set(405, "This is to allow compression of degree in a pop");
        this.set(406, "Use the QP engine to do slow bcp. This is temporary and will be replaced.");
        this.set(408, "Print the partition condition tree passed to optimizer");
        this.set(410, "Enable calibration at server level. This allows for queries to calibrate tables/indexes they use. ");
        this.set(411, "Disable parallel execution for union in views.");
        this.set(412, "Used by the plan viewer to generate slightly modified version of the XML");
        this.set(413, "This sets the number of pages required for a table or index for parallel scan to be 20, which used to be the old default value ");
        this.set(414, "Used not to chose a hash based scan even if table index is very skewed");
        this.set(415, "Prevent generation of parallel query plans for SELECT INTO queries that copy or create identity columns - except for ALTER TABLE commands that copy an identity column.");
        this.set(420, "Used for optimization goals");
        this.set(421, "When a check plan option is specified, this dumps all query plans that get pruned out");
        this.set(422, "Disables Distinct-oriented TreeLogProps generation for semijoin costing");
        this.set(423, "This will disable some statistics related assertion for which defensive programming is an option. For example, if we need to have a selectivity between 0.0 and 1.0 and we get a selectivity value of 1.00001, we will not raise an assertion failure. Instead, we shall make the selectivity equal to 1.0");
        this.set(424, "Disables the index AND-ing for the parallel optimizer.");
        this.set(425, "If enabled, then generate store index (reformatting), over replicated partitioning. This is a boot time trace flag.");
        this.set(426, "If enabled, revert back to the old costing for timeout, which is right but causes some long queries to take too much compilation time.");
        this.set(427, "If enabled, disables the fix for CR 560331 and will turn on eager evaluation of expression virtual VARs that have TXTPTRs as inputs.");
        this.set(428, "If enabled, modifes the fix for CR 560331 to keep lazy evaluation of expressions with TXTPTRs but to skip using statement locking for improved concurrency at user's own risk.");
        this.set(429, "If enabled, turns off the fix for CR 561268 which makes the LeDMLOps call to acces to do deferred updates so that the resvar IO stats can be gathered.");
        this.set(431, "Turn off generation of row formats information at compile time.");
        this.set(432, "Avoid pruning special OR from index scans due to costing issues (sparse Special ORs i.e. not participating in the limiting sargs are still not included for semantic reasons due to orderings)");
        this.set(433, "Turn off very obscure fix for 429806-1 not normally would require a trace flag but we are so close to 15.0 ESD#2 release that this is an insurance policy");
        this.set(434, "If enabled, turns off fix for CR 575115 that added support to handle mixed datatype sargs under special OR.");
        this.set(435, "If enabled, turns off fix for 492688.");
        this.set(437, "Use legacy multi-attribute density costing technique that has errors with weak primary attribute and strong secondary attribute (inverts 337 costing)");
        this.set(438, "Use unique domain counts for densities");
        this.set(441, "If enabled, allow queries with parameterized literals to use the QP fastpath. If disabled, INSERT - VALUES is the only query type with parameterized literals that will be allowed to use the QP fastpath.");
        this.set(445, "If enabled, try to replace repartitioning LeXCHGOps with repartitioning scan ops in parallel lava query plans. Should be removed once the optimizer can choose betweeen repartitioning XCGHOp and ScanOp.");
        this.set(446, "If enabled, turns off the basic_optimization path for queries which are unable to go through QP fastpath.");
        this.set(449, "If enabled, turn off runtime partition elimination.");
        this.set(450, "If enabled, use group inserting for vector aggregation, yielding a predictable ordering. Group inserting will only be used if the number of grouping columns is less than 32.");
        this.set(451, "If enabled, treat host vars that have been converted to LWP parameters in the statement cache as procedure parameters for NULL_EQ_NULL sematics. By default, host vars in statements that are stored in the statement cache are treated like literals for NULL_EQ_NULL semantics.");
        this.set(452, "If enabled, turn off parallel repartitioned index scans");
        this.set(453, "If enabled, the elimination of redundant work tables (StoreIndex over GroupInserting) will not be performed (CR 471593). ");
        this.set(454, "If enabled, GroupInserting will not be forced for legacy abstract plans with grouping, and will thus not be implicit under basic_optimization (CR 480696).");
        this.set(455, "If enabled, turn off the fix for CR 481601. ");
        this.set(457, "If enabled, convert cursors that would have materialized their result sets in pre-ASE 15 and do not do so in ASE 15 into insensitive cursors to uncouple the result set data from the source tables as in ASE 12.5.");
        this.set(459, "If enabled, code generation will create an LeCache instead of a worktable for materialization steps in Lava query plans.");
        this.set(460, "If on, disable union (not union all) fix for 439391-1.");
        this.set(461, "If enabled disable the fix for Insert and Update which skips the replacement of the target scalars in the constraint predicates (481479-1).");
        this.set(462, "If on, consider aquiring from plan phdr for a statement in a stored procedure whose memory requirement is less than 2K (as implemented in CR 474624).");
        this.set(463, "If on, disable the fix for CR 548000-1. Will result in more deferred update mode queries.");
        this.set(466, "If on, print diagnostics during determination of the update mode for DML queries.");
        this.set(467, "If on, don't cache statements referencing temp table.");
        this.set(468, "If on disable the fix for 491806 so SELECT- INTO or INSERT-SELECT queries involving lob dataypes will run in parallel as before but the risk of undetected deadlocks.");
        this.set(469, "If on, turn off expression evaluation of LIKE pattern string.");
        this.set(477, "Turn on diagnostics output for Compatibility Mode processing.");
        this.set(478, "When ON the worktable creation for correlated subq reformatting will not be placed as early as as possible. con: worktable may be truncated and filled multiple times pro: may help with some obscure cases when worktable creation may be placed incorrectly breaking dependency on other worktables");
        this.set(489, "Turn on diagnostics to print row formats optimization related information.");
        this.set(499, "If on, do not streamline lop->Lava for simple inserts and 0 table queries.");
        this.set(1100, "Force a two page OAM.");
        this.set(1101, "Turn off large extent allocation.");
        this.set(1102, "Print error 1105 in errorlog.");
        this.set(1103, "Turn off OAM entries cleanup (CR 306573).");
        this.set(1109, "In pg_allocoam(), randomize the target page when creating a new OAM page. This provides an easy way to randomize the extents in different partitions of a table, so that diff partitions start on different allocation units. Mainly used for testing of Galaxy 'unpartition' feature.");
        this.set(1110, "Notification of pg__deal_ext_undo execution, which is the rollback DROPEXT.");
        this.set(1113, "Notification of pg__deal_allocpg_undo execution. Rollback of DROPEXTS");
        this.set(1114, "Try to allocate a different page on finding that the page we are attempting to allocate is already hashed. (WARNING: This flag is not for general use. It addresses a specific problem seen only at one particular site (lehman)).");
        this.set(1115, "Print diagnostics to the errorlog when 1129 error occurs.");
        this.set(1116, "Suppress runtime 1151, 1152 and 1153 errors which can result from running sp_spaceused (or other callers of OAM builtin functions) in a volatile database.");
        this.set(1117, "Force latch failure so page allocation is retried.");
        this.set(1118, "Force log failure so server is tested to fails gracefully.");
        this.set(1119, "Select a different AU other than the target page's AU while allocating a page.");
        this.set(1120, "Validate extents in allocation page after every pg__readalloc and pg__releasealloc");
        this.set(1121, "Validate and Dump allocation page after every pg__readalloc and pg__releasealloc.");
        this.set(1127, "Use page number stored in extent buddy field in secondary extent of target page as a candidate page with space to insert into. (used for inserting into DOL table with placement index).");
        this.set(1128, "Turn off reserve page gap feature. Always return respagegap as 0 so that we can test code by disabling this feature.");
        this.set(1133, "Get EX_LATCH on first oam page in pg__updateoam() to update the total used/ unused pages.");
        this.set(1134, "Suppress diagnostic message PAGEM, 57 raised when a DOL datapage header field insert-free-space has been detected as incorrect and is recalculated.");
        this.set(1135, "Do not reuse the APL pages used by LSA which have been 'pseudo' deallocated during an aborted command of a BCP insert due to a duplicate key condition at undo run time. Also, do not delay the logging of page deallocations chosen by the reservepagegap feature.");
        this.set(1136, "Internal testing only. It will set the sparse bit in the dbtable and the number of pages addressed by a gam will be set to 8 allocation units. The traceflag should be turned ON before \"create database\" and should be turned OFF after this.");
        this.set(1137, "Set the sparse bit for tempdb to force it to set the sparse bit in its dbtable.");
        this.set(1138, "Maintain two space states for tables that have variable length rows and no erl specified. During inserts this will be used to preferentially return hint pages with more space.");
        this.set(1140, "Print setting and resetting of allocator node");
        this.set(1141, "It is for internal testing only. It will trace dbtable->dbt_supergam related changes.");
        this.set(1142, "Disable attaching allocation sdes to the transaction. This will prevent allocation pages from being pinned to the log. Warning: Using this traceflag can cause corruption and recovery failure. It is only to be used for in-house testing to measure potential performance improvement.");
        this.set(1143, "Simulate error in allocating a new log page in log__newpage. This is only used in in-house testing of handling of 3475 error.");
        this.set(1144, "A new oampage is allocated after the number of free oamentries fall below a threshold. Use a high threshold under this traceflag.");
        this.set(1145, "Obsolute.");
        this.set(5000, "print diskmap");
        this.set(4901, "sleep after reformatting all the data pages during drop column, to allow server crash and to test recovery.");
        this.set(4902, "sleep after updating sysobjects, during drop column, to allow server crash and to test recovery.");
        this.set(4903, "sleep after updating sysindexes, during drop column, to allow server crash and to test recovery.");
        this.set(4904, "sleep after updating sysprotects, during drop column, to allow server crash and to test recovery.");
        this.set(4905, "sleep during drop column, after writing log record for 1st, 2nd, or 3rd data page, to allow server crash and to test recovery.");
        this.set(4906, "sleep after deleting text pages, during drop column, to allow server crash and to test recovery.");
        this.set(4907, "sleep during drop column, before calling alttab_end to release locks and close tables, to allow server crash and to test recovery.");
        this.set(4908, "force writing 1st, or 2nd data page, and don't call xact_commit, to allow server crash and to test recovery of drop cols on several tables at once.");
        this.set(4909, "Force the write of a page and flush the log without an ENDXACT record. This is done to test recovery of a specific page, in particular the page header in the case where there are no rows on a page during a drop col.");
        this.set(4912, "Trace the alter table lock change command");
        this.set(4913, "Trace the alter table lock change command indepth (In 119x)");
        this.set(4914, "Print the log records for the ALTER TABLE xact on completion (both after commit and rollback). This happens from altertab().");
        this.set(4915, "Obsoleted in ASE 15.0");
        this.set(4916, "SANITY ONLY TRACEFLAG FOR TESTING! Trace flag to force random rollbacks at various part of the alter table partition/unpartition code path. If you run DDL stress tests with this flag, you can test that undo during slice/unslice operations is not corrupting syspartitions catalogs or other user tables.");
        this.set(4920, "High-level traceflags to step through and show which stage of processing AMC is in. Display information about key pages allocated (e.g. first, root, new INDEX OAM pages etc.) during execution phase.");
        this.set(4921, "Print the log records just prior to causing an abort xact (under traceflags, listed below). This is useful to debug errors during rollback processing.");
        this.set(4922, "By-pass checks in AMC preprocess phase and desmgr.c to allow manual testing of AMC-based upgrade of system catalogs without going through the upgrade utility. (Only meant for internal consumption. Do *NOT* attempt to use this externally.) If you use this flag, you also should do: sp_configure 'allow updates', 1, in order to allow catalog updates.");
        this.set(4924, "Rollback AMC after setting up first (few) pages.");
        this.set(4925, "Rollback AMC after data copy phase.");
        this.set(4926, "Rollback AMC after update to SYSCOLUMNS.");
        this.set(4927, "Rollback AMC after deallocating old data page chains.");
        this.set(4928, "Rollback AMC after des_swap() operation.");
        this.set(4929, "Rollback AMC after updating system catalogs (SYSOBJECTS, SYSINDEXES, SYSPARTITIONS etc.) with info about new table.");
        this.set(4930, "Rollback AMC after index rebuild phase.");
        this.set(4931, "Rollback AMC after end of all phases, just prior to returning control to sequencer to commit the xact.");
        this.set(4932, "Rollback AMC after update partition condition. ");
        this.set(4936, "Enable Optimistic index locking for all objects.");
        this.set(4940, "Print PARTITION structs as they are being merged, under alter table unpartition. Gives quick high-level info of order in which partitions are being merged, and a summary output of statistics of run.");
        this.set(4941, "Print detailed info on which allocation unit is being processed, and how OAM entries are being merged/coalesced. High-volume output.");
        this.set(4942, "Print log records generated for the merge of two partitions at the end of unptn_merge_ptns().");
        this.set(4945, "Rollback unpartition after merging the first pair of partitions.");
        this.set(4949, "Rollback unpartition after merging all the partitions at the final end of the operation.");
        this.set(4950, "During runtime rollback, crash the server after logging the CLR for restamp, and after undoing the restamp for half of the pages. This is used for crash recovery testing. Used under SANITY.");
        this.set(4951, "During unpartition restamping, give multiple new timestamps for the pages involved in restamping. This is to mimic the behavior in 15.0 GA server. Used under SANITY.");
        this.set(4952, "During unpartition restamping, crash the server after writing the restamp log record and flushing the buffers. Used under SANITY.");
        this.set(14301, "Disable partition condition log space optimization implemented in CR 389887-1. In this CR, saving the partition condition text is avoided when storing the tree in sysprocedures; Also, for alter table command such as alter table lock change, add/drop partition, regenerate the ptncond object is avoided, only sysprocedures are rewritten with updated tree, syscomments are only updated when needed for entries specific to new partitions.");
        this.set(14303, "Test scenario where doing partition condition replacement and found the ptncond tree in use after tried to remove tree from cache (s_replace_proc()).");
        this.set(1801, "keep model open after the create of tempdb to consume deses, when testing opendb with fewer deses than required");
        this.set(1802, "disable writing clean unallocated pages on create db");
        this.set(1803, "allow create/alter database in failedover mode even when proxydb is enabaled.");
        this.set(1804, "Allow data fragments in a template database (or model) to be copied onto a data segment in the target database.");
        this.set(6301, "raise exception if rowsize > max possible for that page");
        this.set(6303, "print debugging information from generic stacktrace. Platform specific implementations for the new generic stacktrace make use of this flag.");
        this.set(6401, "print xactid of xact aborting");
        this.set(1501, "Print INDEX and PARTITION structures given to sort manager at top of startsort(). Terse dump of SORTDES contents.");
        this.set(1502, "print extent i/o statistics during sort, if any.");
        this.set(1503, "bypass calling check__read_ext if turned on. It is not recommended though.");
        this.set(1504, "Print Sort Environment (sortdesp). Verbose dump of SORTDES contents.");
        this.set(1505, "Print cache keys from Internal Sort Phase");
        this.set(1506, "Print cached keys from External Merge Phase ");
        this.set(1507, "Print entire rows from Internal Sort and External Merge Phase.");
        this.set(1509, "wait forever at unique trace point in cri_main().");
        this.set(1510, "wait forever at unique tracepoint in the presortindbuild().");
        this.set(1511, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1512, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1513, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1514, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1515, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1516, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1517, "wait forever at unique tracepoint in the routine presortindbuild().");
        this.set(1521, "wait forever at unique tracepoint in the the routine presortsplit().");
        this.set(1522, "wait forever at unique tracepoint in the");
        this.set(1523, "wait forever at unique tracepoint in the the routine presortsplit().");
        this.set(1524, "wait forever at unique tracepoint in the the routine presortsplit().");
        this.set(1525, "wait forever at unique tracepoint in the the routine presortsplit().");
        this.set(1526, "wait forever at unique tracepoint in the the routine xact_commit()");
        this.set(1527, "do xact_rollback at unique tracepoint in the the routine cri_main()");
        this.set(1530, "Print parallel/serial messages during sort");
        this.set(1531, "Print Distribution map after sampling");
        this.set(1532, "Print Sampling information during sort");
        this.set(1533, "Traceflag to enable parallel sort for work tables. This will bypass page count heuristics in psort_decision(). Useful for testing.");
        this.set(1534, "Print debug information on build buffers and data buffers in sopagealloc() and in sort_bufreserve(). Using this, you can watch the buffer swizzling that sort does through its lifetime.");
        this.set(1535, "Print debug information on extent allocation/deallocation during sort redo as well as during runtime sort.");
        this.set(1536, "Print debug information for solmproch PROC_HDR during the calls to lmalloc() and lminit().");
        this.set(1538, "Turn off two_timestamp sopagealloc() strategy. Without this trace flag, sort will manage a separate timestamp field in the sort desc to track clustered/placement index allocations. By tracking data and index page allocations separately, it is possible to maintain uniform timestamps in all pages of a data AEXTENT, which may or may not use large pools. This prevents 3474/6902 type errors when redoing a sort transaction with a different pool size than that used at runtime. Using this trace flag reverts to the old strategy using one timestamp to manage both index and data allocations, and thus exposes the possibility of 3474/6902 errors described. This is only a runtime trace flag. This traceflag is also made use in tests to test redo of transactions that do not use two-timestamp strategy (see bt__build_init()).");
        this.set(1539, "Force sort to not use large buffer pools.");
        this.set(1541, "Print out page number and row count per page in streaming sort.");
        this.set(1542, "In bufw_ts(), if a hashed buffer is found raise a 1514 error.");
        this.set(1543, "Print a message if the sampling scan return an OAM page, which we should skip for sampling sort and unkeep the buffer.");
        this.set(1544, "In bufw_ts(), print informational message if we evade a 1514 error. It will take no effect in case traceflag 1542 is turned on.");
        this.set(1550, "Temp TCF to use old-style contiguous memory reqs for bpa in case any problems arise in testing or initial release of non-contiguous memory reqs checkin. Should be able to deprecate after that.");
        this.set(1551, "Temp TF to debug/analyze any problems associated with the elimination of the bpa contiguous memory requirements.");
        this.set(1552, "Test hook (diagserver only): Hang sort just prior to its logging the ENDSORT log record until such time as another process turns the 1552 switch off.");
        this.set(1553, "Test hook (diagserver only): Hang redo of sort by LOAD TRAN just after the sort has completed until such time as another process turns the 1553 switch off.");
        this.set(1556, "Disable allocating pages from temp in-memory database to storing input streaming data.");
        this.set(1557, "Enable the traceprint message for unit testing allocating pages from temp in-memory database to storing input streaming data.");
        this.set(1545, "In sort_write, if MASS_DESTROY is on when trying to get EX_PHY lock, it will clear the destroy bits of the buffer in case 1545 is turned on.");
        this.set(1599, "print sorted rows returned by lmnext()");
        this.set(4401, "print query tree as view is being resolved");
        this.set(4402, "disable the fix for 76570 which introduced pushdown logic on views to improve performance. Internal use only. Should not be documented.");
        this.set(4403, "dump info about pushdowns");
        this.set(4404, "disable pushdown of join and non-join predicates for union views. Internal use only. Should not be documented.");
        this.set(4405, "print OJ expression tree before/after OJ normalization. also print OJ_RGINFO blocks after.");
        this.set(4406, "trace removal of inner nodes and VAR nodes during oj_leftjoin_only()");
        this.set(4407, "trace remapping of subquery ojids during OJ normalization and OJ xformation");
        this.set(4408, "enable usage of materialized views with text fields");
        this.set(4411, "Sybase OJ -> ANSI OJ conversion dump VOJ_ANSICONVERT and qualification conjuct after oj_syboj_mapojoins() is done for the conjunct");
        this.set(4412, "Sybase OJ -> ANSI OJ conversion trace qualification conjunct ON/WHERE clause decisions");
        this.set(4413, "Trace point to turn on for warning 11046 for join-order dependent queries for Sybase outer joins");
        this.set(4415, "dump outer join relabeling map during view merging and/or subquery flattening");
        this.set(4416, "Switch ON generation of the transitive closure on the materialized worktable.");
        this.set(4417, "Switch OFF new way of UIV materialization introduced by 416075.");
        this.set(4418, "Traceflag to turn off minimal projection for union all views");
        this.set(1701, "print query tree for create table command");
        this.set(1702, "disable the fix of 292784 which rejects views defined with unnamed columns.");
        this.set(1703, "Raise fake exception in crt_work() to simuilate running out of space while allocating space for a work table.");
        this.set(1704, "Print the SQL statements generated internally to create tables during bootstrap-upgrade and other upgrade steps which add tables/ indexes.");
        this.set(1705, "Create 4-way roundrobin partition as default if no partition is specified for create table statement or select into target table. This is for testing purpose only. If we use this trace flag, we need to use a config file that has appropriate parallel config options turned on, which is needed for create clustered index on these tables.");
        this.set(5301, "print query tree duing select into processing");
        this.set(5302, "skip unpartition step in parallel select into");
        this.set(5303, "select into temporary table will be executed without the table being sliced.");
        this.set(5304, "Disable the large io and large allocation changes done under 279883-1..");
        this.set(5310, "Enable full fix for 339590-1. Eg with this trace we ignore presence of aggregates in select into node from disabling identity inheritance. Without trace we disable identity inheritance if aggs are not in a subquery.");
        this.set(5390, "kill server during select into, before table is created");
        this.set(5391, "kill server during select into, after table is created, and before the transaction is committed");
        this.set(5392, "Rollback the entire xact after SELECT INTO has completed its operation. For ALTER TABLE ADM, which runs under the guise of a SELECT INTO, this traceflag will rollback the entire operation after indexes have also been rebuilt. ONLY AVAILABLE IN SANITY SERVER.");
        this.set(4799, "kill the server before truncate table transaction is committed");
        this.set(4801, "Print rows sent to bulk insert by bcp. Must be invoked with -T, or by modifying bcp, because bcp initiates its own sql session.");
        this.set(4802, "force bcp transaction to first stall forever waiting for this same traceflag to be turned off and then abort it. This traceflag is used in bcp quasr test.");
        this.set(4803, "Treat all bulk-inserts as arrayinserts");
        this.set(4804, "Activate fix introduced by 344713 to avoid the truncation of the default value to send to bulk library.");
        this.set(4805, "Restore pre-407169 behaviour i.e bulk insert is fully logged if the table has indexes or triggers.");
        this.set(4816, "Start bulk transaction and acquiring EX_INT only when the first row from the network is received.");
        this.set(4817, "Enable fast logged bcp.");
        this.set(2601, "Turn on check in put row routines for the PG_DEALLOC bit set by recovery when called at runtime");
        this.set(2602, "Force 2620 ex_raise");
        this.set(2603, "If enabled, then it enables the ascending insert optimization for APL table with clustered index. ");
        this.set(2604, "Print out diagnostic information for ascending insert optimization.");
        this.set(601, "Print out cursor scan fix up information");
        this.set(602, "Print out diagnostic information for deadlock prevention code changes in the access directory.");
        this.set(603, "print diagnostic info from lockindex_ds and cinsert() when we avoid deadlock by releasing our pagelock and calling srchindex with SRCH_DS mode.");
        this.set(604, "print diagnostic info prior to raising 12328 error in srchpage().");
        this.set(605, "Print out page dealloc info at commit time");
        this.set(606, "Flag ext_delete() call at commit time to track extent deallocs that occur at that time");
        this.set(607, "Print out log records being skipped by dodealloc because of an aborted command");
        this.set(608, "Print cursor fixup trace info.");
        this.set(609, "In cursor fixup code, check for error conditions, print errors to server log and skip the work in cursfix__reset() (i.e. return from call to cursfix__reset() ).");
        this.set(610, "In hkgc__garbagecollect(), print the housekeeper's garbage collection queues before yielding.");
        this.set(611, "Simulate 803 errors in level0 restart code for cursor fetches by forcibly invalidating the scan under diagserver. Also allows testing the restart mechanism for non QP level0 internal system catalog scans.");
        this.set(612, "Insert row in the wrong partition. (For testing dbcc checktable()).");
        this.set(613, "Disable DOL data page deallocation by either HKGC or a DML. This traceflags exists to support testing.");
        this.set(614, "Print destination partition id from lookup");
        this.set(615, "By default, diagnostic checks for a corrupted page being read from or written to disk are turned on when a 694 or some variants of a 697 error occur. These are the same checks that are done using the 829 and 830 trace flags. The 615 trace flag turns this checking off. In effect, turning this trace flag on turns the 829 and 830 trace flags off.");
        this.set(616, "Command-line trace to print trace info from scan_set_pvtscan(), scan_reset_pvtscan() and scan_set_sbufinfo().");
        this.set(622, "Check to see if inserting/deleting row from wrong type of page");
        this.set(623, "Check for uninitialized page in getpage()");
        this.set(624, "Trace asynchronous prefetch");
        this.set(625, "In fglk__promote(), if lock promotion fails, put the task into a loop of waiting for this same traceflag to be turned off.");
        this.set(626, "Used to test simulated deadlock during failover recovery undo of incomplete tested top action. This will suspend the the server before rollback of the nta, and turn on trace 627.");
        this.set(627, "Used to test simulated deadlock during failover recovery undo of incomplete tested top action. This will suspend the the server before ENDTOPACTION log record is logged.");
        this.set(628, "Turn off automatic offset table regeneration mechanism in srchpage()");
        this.set(630, "Verbose information on 605 errors.");
        this.set(631, "Trace qualification on dol tables.");
        this.set(632, "Force 5% of unconditional user table lock requests to fglock() to fail with LOCK_INTERRUPTED and 5% to fail with LOCK_DEADLOCKED. Only in effect for user queries (when SS2_QPSCAN is set). Only works for diagserver.");
        this.set(633, "Trace information about deadlocks in DOL qualification.");
        this.set(634, "Trace updates to cluster ratios");
        this.set(635, "Do not update index stats during index operations like insert/delete/split/shrink.");
        this.set(636, "Check for bad locking during recovery. Only valid for sanity server.");
        this.set(637, "Call SYB_ASSERT() when bad locking encountered (636,637,644,645). Normally only print to errorlog).");
        this.set(638, "Print stack trace when reporting bad locking error (636,637, 644, 645).");
        this.set(639, "call killserver() in put/stoptopaction() after a topaction is completed.");
        this.set(640, "Print verbose diagnostics when xls_close() found to have been bypassed.");
        this.set(641, "Check for validity of contents of data page in DOL tables after each operation that changes the page contents.");
        this.set(642, "Force an expanding update to cause row forwarding.");
        this.set(643, "Trace through the function calls for update on a DOL table.");
        this.set(644, "Check for bad locking on work and temp tables. Only valid for sanity server.");
        this.set(645, "Check for bad locking on system table scans. Only valid for sanity server.");
        this.set(646, "Turn off the strategy for two passes through the page manager for dol placement inserts into sliced tables.");
        this.set(650, "Print out DES info when releasing in localdes() and rel_desclosed()");
        this.set(651, "Print out DBTABLE info when in release_dbtable()");
        this.set(655, "Command line traceflag. Turn off optimizations to pick direct mode updates under certain conditions when the update/delete query is driven by a join, or on a table with RI constraints.");
        this.set(656, "Session specific traceflag. Turn off direct update optimizations (same as above).");
        this.set(665, "Print out diagnostic info in plc__flush() if no log space is available to flush the log Turn off the flag internally, after the first instance of the error is seen");
        this.set(666, "call killserver() in xact__endxact() before xact is logically completed.");
        this.set(667, "call killserver() in xact__endxact() after xact has logically completed, but before pg_commitdealloc(). Also write checkpoint record to guarantee xact is in rcvy Phase 1.");
        this.set(668, "Abortxact in xact__endxact() before xact logically completes.");
        this.set(669, "Set Resource->max_tries to 0. This disables the retry method in the access method. This retry is done when acquiring locks for a shrink or a split operation, or we are doing a datasplit, and need to have both parent and child exclusively locked.");
        this.set(670, "Generates random prefetch requests for every getpage request. Can only be used when server is compiled with sanity.");
        this.set(671, "Print out log records examined by apl_trig_getnext() -- when scanning log for trigger. SANITY only.");
        this.set(672, "Print the work table creation, drop, etc.");
        this.set(673, "Call ucbacktrace() when 671 traces are printed. This traceflag requires that 671 is set.");
        this.set(675, "Check consistency of all rowcounters during checktable and correct discrepancies.");
        this.set(676, "[ Free for use -- previous meaning retired in ASE version 15.0.1. ]");
        this.set(677, "xls_startscan() and xsc__handleplcflush() debugging.");
        this.set(678, "call xact_rollback() in puttopaction() before a topaction is completed, to allow testing of runtime rollbacks.");
        this.set(679, "call xact_rollback() in puttopaction after a topaction is completed, to allow testing of runtime rollbacks.");
        this.set(680, "Disable the fix for bug 74393. Server must be booted with -T680 to disable the fix.");
        this.set(681, "print the parallel scan information.");
        this.set(682, "Hash only on the extent part of the pageid.");
        this.set(683, "Change the hashing strategy for parallel non-clustered scan. Instead of hashing on the index entry of the leaf page, hash on the leaf page itself.");
        this.set(684, "Prints the page number and the bucket number for parallel hash scans.");
        this.set(685, "Use a different hash function.");
        this.set(686, "Print detailed info on partitioned work table.");
        this.set(687, "Print the hash success rate for each thread.");
        this.set(688, "Don't use the backward scan to find the last partition for parallel clustered index partition scan");
        this.set(689, "call killserver() in puttopaction() before a topaction is completed.");
        this.set(690, "Enable feature when rollback to a savepoint will close cursors that are open within the scope of that savepoint.");
        this.set(691, "PTN_RESOLVE (aditya/yangx): This needs to be revisited and finalized. Every time we do a stack search in ucfnname(), it is quite costly in terms of CPU usage. For now, turn on the function name scanning operation for UCFNNAME_ALL_NOTME() call only if 691 is on.");
        this.set(692, "Enable bug fix 95054. If 'set chained on', cursors would be closed when commit/rollback tran.");
        this.set(693, "Turn off some blocking optimizations in scan such as skipping uncommitted inserts and skipping or returning uncommitted updates based on info about what columns were updated.");
        this.set(694, "Trace the blocking optimizations of skipping uncommitted inserts and returning uncommitted updates that qualify if cols of interest were not updated. ");
        this.set(695, "Disable update_mode optimization completely for multi-row updates(Bugfix 97199).");
        this.set(696, "Used to test recovery of nested top actions. This will suspend the server just after the BEGINTOPACTION log record has been logged.");
        this.set(697, "Used to test recovery of nested top actions. This will suspend the server just before the ENDTOPACTION log record is logged.");
        this.set(698, "Avoid using nonclustered index for scan on sysattributes. This is used to avoid deadlock between threads doing proxy table creation which insert rows into sysattributes and threads dropping the proxy table, which does scan/updates on sysattributes rows. Currently only migration tool sybmigrate, is using this traceflag. NOTE: PLEASE DONOT MAKE CHANGES TO THIS TRACEFLAG WITHOUT CONSULTING THE MIGRATION TOOL TEAM.");
        this.set(699, "Disable logging for the entire server (some records still have to be logged, though).");
        this.set(12300, "Reserved for: Disable the optimization to use srchpage() to find the start position for a clustered index scan.");
        this.set(12301, "Disable the use of a separate PLC for session's temp db.");
        this.set(12302, "Call bufwrite() from linksplit() to write the new page after splitting index or data pages. This might cause drop in the performance when large volume of data is inserted into a table.");
        this.set(12303, "Print hash value calculation information and ordinal page to logical page mapping during search for virtually hashed table.");
        this.set(12304, "Flush the log and shutdown the server after issuing async write in linksplit().");
        this.set(12305, "Set IOERR on MASS in bwfinish() if the buffer contains APL split page. Used to verify that buffer is unkept and MASS_WRITING_SPLIT is cleared after hitting IOERR in buf__writewait() while waiting for write on APL split page. Available only in DEBUG mode binary");
        this.set(12306, "Enable finddif optimization to reduce the boundaries of comparison between new and old copies of the row being updated");
        this.set(12307, "In dol_update(), hang after logging DOL_UNOOP log record. Used for testing only.");
        this.set(12308, "In dol_delete(), hang after logging DOL_DNOOP log record. Used for testing only.");
        this.set(12309, "In dol_delete(), make delete aggressive to free pages. Helps in reducing pages used by object. could be used per-session");
        this.set(12310, "disable optimizations that skips btree traversal for dol nonclustered index deletes");
        this.set(12311, "Disable optimization for fast bcp insert on dol nonclustered indexes");
        this.set(12313, "This is applicable to SDC only. In some situations, asynchronous prefetch of log pages (APF) is disabled in order to protect against having stale log pages read into cache. This trace flag enables APF on the log in these cases. It should be used only when reading of stale log pages is unlikely to be a problem, and hence its use should be done with engineering approval only.");
        this.set(12600, "Unused");
        this.set(12601, "Trace btree creation");
        this.set(12602, "Trace sargs during btree create index.");
        this.set(12603, "Force create index to create nonleaf pages with only 1 entry. Good for testing high trees.");
        this.set(12604, "Force create index and inserts to not create suffix compressed rows.");
        this.set(12605, "Trace btree parallel create index.");
        this.set(12606, "Force creation of a new level for testing sub index merge during parallel create index.");
        this.set(12607, "Print subindex info. during parallel create index creation.");
        this.set(12608, "force bt__cr_from_sorted to treat as though keys were out of order and to call btree insert to create the nonunique placement index.");
        this.set(12609, "force create index code to use only 2 buffers to hold the index pages. This allows testing of create index to use the single buffer whenever the height is > 2.");
        this.set(12610, "Disable inserts thru placement index");
        this.set(12611, "Disable Index lookaside");
        this.set(12612, "Aggressively do index lookaside at parent level only");
        this.set(12613, "Trace index look aside");
        this.set(12614, "force create index to assume root has no space to hold key info. causing it to add a new level");
        this.set(12615, "A deadlock optimization. Clear POSSUNCT bit for all deleted rows on a page when doing delete from unique index as part of a datarow update");
        this.set(12616, "Some intrumentation to track 198757-1 ");
        this.set(12617, "Additional diagnostics for invalid shrinks.");
        this.set(12618, "Ensure leaf page is allocated before shrink is attempted.");
        this.set(12619, "Force retraversal in bt__lock_nextkey() by pretending page has changed with a probability of 1 in 3, until the sdes kept buffer array is almost full. Used for testing 803 error situations.");
        this.set(12620, "Trace btree traversal");
        this.set(12621, "Testing undo of rebuild index");
        this.set(12622, "Testing redo of rebuild index");
        this.set(12623, "Testing code paths that return errors in rebuild index");
        this.set(12624, "Disables sync flush at the end of xacts in online rebuild.");
        this.set(12625, "Do online rebuild as one xact");
        this.set(12626, "For btree leaf splits, try not to split the ridlist");
        this.set(12627, "Turn off fix for CR 317437");
        this.set(12628, "Disable PREPEND mode splits");
        this.set(12630, "Trace btree leaf inserts");
        this.set(12631, "Trace btree nonleaf inserts");
        this.set(12632, "Trace btree leaf deletes");
        this.set(12633, "Trace btree nonleaf deletes");
        this.set(12634, "Induce log allocation failure while splitting at level 0");
        this.set(12635, "Induce log allocation failure while splitting at level 1");
        this.set(12636, "Induce log allocation failure while splitting to add a new level");
        this.set(12637, "Force auxkeepbufs structure to be allocated early i.e even if shrink or split causes no non-leaf split or shrink.");
        this.set(12640, "Trace btree leaf splits");
        this.set(12641, "Trace btree nonleaf splits");
        this.set(12642, "Verify leaf/nonleaf page after every DML change to the page");
        this.set(12643, "Induce page allocation failure before splitting level 0 (leaf)");
        this.set(12644, "Induce page allocation failure before splitting level 1");
        this.set(12645, "Induce page allocation failure before splitting level 2");
        this.set(12646, "Induce page allocation failure before adding new level to the tree");
        this.set(12647, "Induce log allocation failure while inserting/deleting into level 0 page");
        this.set(12648, "Induce log allocation failure while inserting/deleting into level 1 page");
        this.set(12650, "Trace btree redo/undo insert/delete leaf");
        this.set(12651, "Trace btree redo/undo insert/delete nonleaf");
        this.set(12652, "Discard heuristically choosen split point and allow bt__getsplitdistr to find a split point");
        this.set(12653, "Some traceprints(diagnostics) which tell whether bt__maybe_adjustsplitpt got exercised. SANITY server only.");
        this.set(12654, "Don't put sidekey(Tests blocking logic in traversal). Sanity server only.");
        this.set(12660, "Trace btree redo/undo split");
        this.set(12661, "create corrupt index leaf page for dbcc testing");
        this.set(12662, "create corrupt index nonleaf for dbcc testing");
        this.set(12663, "Turn on diagnostics to assert that online index rebuild should not reorg rebuild pages that are already deallocated. Also output general information for the leaf rebuild phase.");
        this.set(12665, "Print out LOCK_DIDQUEUE message if we fail to get the address lock during our initial trial in getindexpage(). The lock request will be retried.");
        this.set(12666, "Disable fix in BT__ISROOT for testing.");
        this.set(12667, "Enable bufpredirty for APL OFFSET Table change");
        this.set(12670, "Pause splits to test concurrency");
        this.set(12671, "Printing out Look ahead lists");
        this.set(12672, "Trace bt__delkey_needtoblock");
        this.set(12673, "Restart information");
        this.set(12674, "Blocking information");
        this.set(12675, "Qualification info");
        this.set(12676, "Pause split after splitting leaf but BEFORE linking the next page. Then start scans to test if they handle broken chain. Note that split will leave the page linkage broken!");
        this.set(12677, "Pause split after splitting leaf is complete but BEFORE propagating up. Then start scans to test if tree traversal is ok.");
        this.set(12678, "Pause split after splitting nonleaf is complete but BEFORE propagating up. Then start scans to test if tree traversal is ok.");
        this.set(12679, "Pause scans for some testing");
        this.set(12680, "Trace queuing and processing of index pages by HK");
        this.set(12681, "Force restart in bt_getnext with a probability of approx 1 in 3.");
        this.set(12682, "Force restart in bt_getnext with a probability of approx 1 in 29.");
        this.set(12683, "Force traversal to search from root instead of using pages from search path");
        this.set(12685, "Force all conditional lock requests to return lock not granted. Related to 1216, but only for btree code.");
        this.set(12686, "Force conditional lock requests to return lock not granted with a probability of approx 1 in 7.");
        this.set(12687, "Force restart when unconditional lock is requested with a probability of approx 1 in 3");
        this.set(12688, "Force restart when unconditional lock is requested with a probability of approx 1 in 29.");
        this.set(12689, "Enable scan instrumentation");
        this.set(12690, "(Cmdline) Force backward scan");
        this.set(12691, "Force a backward scan");
        this.set(12692, "Force copying mode");
        this.set(12693, "Force copy from index page");
        this.set(12694, "Index manager can return pointer into page");
        this.set(12695, "Force copy from index row");
        this.set(12696, "Trace shrinks.");
        this.set(12697, "Trace flag to help in performance analysis. Turn off multi-column range scan opt.");
        this.set(12698, "Trace multi-column range scan opt");
        this.set(12699, "Aggressively queue pages for HKGC");
        this.set(3601, "print out backtrace each time ex_raise is called.");
        this.set(3602, "Send error messages to errorlog that would go to the network");
        this.set(3603, "?????");
        this.set(3604, "output traceprint to network");
        this.set(3605, "output traceprint to errorlog. See 3623 also.");
        this.set(3606, "check if memmove would cross a 2k boundary");
        this.set(3607, "boot without recovering anything");
        this.set(3608, "boot recovering master only.");
        this.set(3609, "recover all databases but do not clear temp");
        this.set(3610, "provide some pre system 10 arithabort compatibility: return a null and do not abort");
        this.set(3611, "new error message protocol for 4.0");
        this.set(3612, "reserve for Netware 4.2 SQL Server.");
        this.set(3613, "boot with a single 2k cache.");
        this.set(3614, "read the config block starting from virtual page zero when booting(used only on AIX)");
        this.set(3615, "(obsolete)");
        this.set(3620, "infect processes instead of killing them");
        this.set(3621, "This flag controls (stops/starts) the execution in dsinit() routine. For testing purposes only.");
        this.set(3623, "output traceprint to errorlog using scerrlog. Useful to get all the good stuff from scerrlog like engine id, spid, etc.");
        this.set(3624, "Used in um_mkpages.sh to indicate that a server is being booted during buildmaster generation. This traceflag can be used a flag to avoid doing certain work in this scenario.");
        this.set(3625, "Trace flag is retired now. It used to change 3606 error(Arithmetic overflow) and 3607 error(Divide by zero) severities from EX_INFO to EX_USER, to make @@error reflect the error code.");
        this.set(3626, "In kistartup, print out kbmempooldiag() info.");
        this.set(3627, "Print allocating and free for memory block pools.");
        this.set(3628, "Defeat function to reset 'Everyone' group access permissions (NT ONLY)");
        this.set(3629, "In dynmp.c, start the minsize to be really small to force grow to happen. This traceflag is ignore if 'dynamic allocation on demand' is set to 0.");
        this.set(3630, "Print diagnostics in dynmp.c");
        this.set(3631, "Disable resource statistics collection. Server collects resource statistics information by default. Boot with this traceflag on will stop this activity. See sp_monitorconfig for more information.");
        this.set(3632, "Turn off stats flushing performed by the chores housekeeper.");
        this.set(3633, "Turn off system task restart.");
        this.set(3634, "Tests the re-startability of a system task which has been forced to terminate by a module-specific trace flag (see the list given below ). If the 3634 trace flag is on, the re-started system task will be subjected to the same condition thereby testing the limit that is put on the number of re-starts. If the 3634 trace flag is off, then the a single re-start of the system task will be performed. See: (825, 826, 827, 5613, 3506)");
        this.set(3635, "PAM/LDAP User Authentication diagnostics");
        this.set(3636, "Enable PAM account management.");
        this.set(3637, "Print connection time averages for LDAPUA.");
        this.set(3638, "Password complexity/login option checks diagnostics.");
        this.set(3639, "LDAP UA Auto Failback diagnostic.");
        this.set(3640, "Enable Job Scheduler task logging engineering instrumentation. JSTASK_DEBUG() See $DBMS/generic/source/demo/jobscheduler.c");
        this.set(3641, "Enable Job Scheduler task 'log everything'");
        this.set(3645, "Enable Statement Cache. A trace flag is used instead of a config param pending usability enhancements to the code. Needed in ASE 12.5.1 only.");
        this.set(3646, "Disable column wise datachange counters ");
        this.set(3647, "Disable datachange counter maintenance");
        this.set(3649, "Force to use table scan for sysstatistics row deletion to minimize deadlocks");
        this.set(3650, "Collect monitoring information for system catalogs also.");
        this.set(3651, "Monitor system catalog locking activity. This data is reported via monRLCActivity.");
        this.set(3660, "Disable many of resource governor enhancements done under 360587-1.");
        this.set(3661, "Add tracing to resource governor for diagservers only.");
        this.set(3662, "Switch on to print sql text of RG query.");
        this.set(3663, "For resource governer exceptions, revert to the old behavior, prior CR 360587, of calling terminate_process() directly. Active under SANITY only.");
        this.set(3664, "Disable gathering object level monitoring data if a process is in backout processing.");
        this.set(3670, "361988-1. Disable silent rounding to 0 for float value parsing.");
        this.set(3671, "Disable HK Chores.");
        this.set(3676, "To print query context in case of stack over flow exception");
        this.set(3677, "Freeze the Job Scheduler task for a certain period of time during Job Scheduler bootup. For Internal testing purpose only. This should not be documented.");
        this.set(3678, "Pause the process for a certain period of time when switching to new errorlog. For internal testing. Not to be documented.");
        this.set(5801, "In config manager, disable the check of max memory not sufficient for total logical memory. This is to buy breathing room in field, in case server refuses to boot due to some error.");
        this.set(5802, "Force memory allocation during upgrade from version < 12.5 to use old code path. ");
        this.set(5803, "Trace the memory allocation failures");
        this.set(6901, "display info about databse timestamp when bumped");
        this.set(6903, "display page header and timestamp info. when get or put timestamp to/from page.");
        this.set(6904, "Display timestamp comparison results and values.");
        this.set(6906, "Print details when cluster high timestamp is obtained or set");
        this.set(6907, "Print messages related to database commit timestamp changes.");
        this.set(7001, "Used by the security group");
        this.set(7100, "Text Manager, display number pages, expected and actual counts during dbcc proccessing. See the TXTRACE_DBCC() macro in textmgr.h.");
        this.set(7101, "Text Manager, display pages still kept after insert/update/delete of text. See the TXTRACE_PGKEPT() macro in textmgr.h.");
        this.set(7102, "Text Manager, display incoming data from constant nodes. See the TXTRACE_CONST() macro in textmgr.h.");
        this.set(7103, "Text Manager, trace st-node creation.");
        this.set(7104, "Text Manager, trace st-node usage during read.");
        this.set(7105, "Text Manager, trace rebuild text.");
        this.set(7106, "Text Manager, trace text page pre-fetch.");
        this.set(7107, "Text Manager, skip building of st-nodes, in order to test out building of partial st-nodes during select. Used for testing. Since 12.0.0.3 ESD#1, this has been obsoleted by trace flag 7109, must never be re_used in the code.");
        this.set(7108, "Text Manager, don't do apf even if text value has a st-node. Since 12.0.0.3 ESD#1, this has been obsoleted by trace flag 7109, must never be re_used in the code.");
        this.set(7109, "Text Manager, ignore STNODEs altogether, and do not write any new STNODEs. This coalesces the functionality of 7107 and 7108, and enhances it to cover other areas. 7107 and 7108 are now defunct.");
        this.set(7110, "Text Manager, ignore the change made to avoid the locking of text pages in alloctext() when the process is parallel select into exising doing BCP.");
        this.set(7111, "Text Manager, trace when TXT_PGNOTEXIST is raised/caught. For debugging only.");
        this.set(7112, "Text Manager, allow manually creating/dropping indexes for replication.");
        this.set(7116, "Hang text insert process after logging the XREC_TEXTINSERT log records, but before doing the data page change.");
        this.set(7117, "Hang text insert process after logging the XREC_TEXTINSERT log records, and doing the data page change and logging another MODIFY record.");
        this.set(7188, "Trace the diagnositics information during compressing or decompressed text/image columns.");
        this.set(7201, "Distributed network exerciser");
        this.set(7202, "Set up remote password field in login record as one null universal password (useful until DBLIB sets up this field)");
        this.set(7203, "Used with -T7201 - test stream interpreter");
        this.set(7801, "Print the polling pattern of network polling routine (ncheck)");
        this.set(7802, "To cause network handler process to terminate");
        this.set(7803, "Print out messages about the use of the overflow buffer.");
        this.set(7804, "Print out network call trace. Currently done only by n_netlib.c.");
        this.set(7805, "Enable diagnostic information to be displayed for the syb_sndmsg() builtin function. This includes information about the errors and failures.");
        this.set(7806, "Fail \"send migration\" - for unit testing.");
        this.set(7807, "Fail \"receive migration\" - for unit testing.");
        this.set(7808, "Print the notification of outstanding i/o (nserver, ncheck etc.)");
        this.set(7809, "Enable dbcc engine(net, migrateall,...) option");
        this.set(7810, "Disable network affinity migration during login");
        this.set(7811, "Show network affinity migration status");
        this.set(7812, "Stay in \"in-migration\" by holding on SOMIGRATE - for unit testing.");
        this.set(7813, "Disable the internal interrupt clock mechanism when tli_nopen calls t_open. This is to avoid timeslices in network handler");
        this.set(7814, "Report endpoint IP addresses for the socket of a process that receives an out of band signal for which we can't locate the OOB mark in the socket stream. This arises from OS or network failures outside the server and this information may help in diagnosing the cause of the problem. (bugids 47129/81891)");
        this.set(7815, "Report connect attempts from an end-point falling into the connection handler accept() part. This traceflag is usefull tracing IPv4-mapped and IPv6 clients but also to spot denail of service attacks on ASE its network connection handling.");
        this.set(7820, "Traceprint calls to ctlib.");
        this.set(7821, "Don't initialize ctlib. This implies OMNI, ASTC, etc. will not work with this traceflag on.");
        this.set(7822, "Disable NETMNE.");
        this.set(7823, "Print diagnostic information if a callback exception occurs ");
        this.set(7824, "Disable master/query syntax in interfaces file");
        this.set(7825, "Verbose SSL activity, including packet dumps.");
        this.set(7826, "Trace memory alloc/free for SSL. Verbose.");
        this.set(7827, "Trace entry/exit for SSL.");
        this.set(7828, "Verbose HBC.");
        this.set(7829, "Trace certificate authentication for SSL.");
        this.set(7830, "This is a solaris only traceflag. This is used to determine the function to be used when checking the fds for IO readiness. When ON, soc_ncheck() uses select() otherwise it uses poll(). The reason for this traceflag is to provide a backup in case poll() strategy is not working all that well (poll() was introduced in 12.5 IR).");
        this.set(7831, "Enable ct_debug(CS_DBG_ALL) for new ctlib connections made from ASE.");
        this.set(7832, "Enable ct_debug(CS_DBG_ASYNC) for new ctlib connections made from ASE.");
        this.set(7833, "Enable ct_debug(CS_DBG_ERROR) for new ctlib connections made from ASE.");
        this.set(7834, "Enable ct_debug(CS_DBG_MEM) for new ctlib connections made from ASE.");
        this.set(7835, "Enable ct_debug(CS_DBG_PROTOCOL) for new ctlib connections made from ASE.");
        this.set(7836, "Enable ct_debug(CS_DBG_NETWORK) for new ctlib connections made from ASE.");
        this.set(7837, "Enable ct_debug(CS_DBG_API_LOGCALL) for new ctlib connections made from ASE.");
        this.set(7838, "special case instrumentation to allow ksctsuspend to return CS_QUIET instead of CS_SUCCESS on KILL.");
        this.set(7839, "instrumentation to have ksctsuspend() report verbose info for tracking ctlib return values and ATTENTION/KILL activity.");
        this.set(7840, "NT Specific: reverse changes of CR 326039 eg. when 7840 is SET ase uses conn reset on all sockets during shutdown");
        this.set(7842, "Log an errorlog message when an attention (cancel) is received");
        this.set(7843, "Back out changes from CR269372 for cases where customer app has problems with new behaviour");
        this.set(7844, "Limit concurrent SCL logins to one at a time per engine. This is required to avoid MIT Kerberos client library bugs.");
        this.set(7845, "Suppress printing of TDS invalid header messages");
        this.set(7846, "Force integrated login to use old style (pre-windows 2003) username lookup");
        this.set(7847, "To allow the network check more than once for faster CPUs in a single tick, because 100ms tick is large enough for the present faster CPUs. So there may be some pending I/Os to check.");
        this.set(7848, "Print CSI initialization information");
        this.set(7849, "Print SSL or Crypto diagnostic information");
        this.set(7850, "Timeout SCL connections during security session establishment.");
        this.set(7851, "Should be used for internal testing only. Used to simulate timeslice error for network listener ");
        this.set(7853, "Print external passwords encryption information");
        this.set(8001, "Print EXECUTE plan of RPC");
        this.set(8002, "Invoke exerrpc() exerciser");
        this.set(8003, "Print out the logical remote connections info");
        this.set(8004, "Raise (DDBNET, NET_DROPPED) exception");
        this.set(8005, "Search for an existing REMBUF to run RPC, instead of opening/closing a new connection.");
        this.set(8006, "Print internal RPC information in xpr routines.");
        this.set(8013, "Turn on bugfix 79777-2. In case of a RPC resource error like 7205, the transaction will not be rolled back and the batch will not be flushed.");
        this.set(8014, "Print contents of each native rpc received to errorlog.");
        this.set(8015, "Disable rpc alias lookup mechanism added by CR 71574");
        this.set(8016, "Test only. Block orever wating for probe connection to get terminated in a remote server.");
        this.set(8017, "Turn off login name switch when executing an rpc on behalf of an externally authenticated user.");
        this.set(8020, "Disable at boot time the fix for 127710 which checks DATETIME RPC parameter's value.");
        this.set(8021, "Disable 414943 fix so SYB_VOID constants are built in bconst() for NULL input params.");
        this.set(8101, "Turn off Chargeback Accounting");
        this.set(8201, "Display des's w. keep counts >1 for user tables");
        this.set(8202, "Display work descriptors being installed/removed");
        this.set(8203, "Display statement and transaction locks on a deadlock error in des__fill().");
        this.set(8204, "Disable using the DES pointer stored in rgdes field of a range table entry.");
        this.set(8205, "For testing purposes only. This is used to exercise the greedy page allocation scheme.");
        this.set(8206, "des manager does not scavenge those des/ides that have statistics cached and not flushed yet. When this traceflag is on, the above mentioned default behavior is changed and des/ides with unflushed statistics will be scavenged anyway. This traceflag exists to provide a work-around till flushing statistics is made more efficient by adding more daemons (CR#263433).");
        this.set(3701, "Allow droping of index on system table. This should be used only from sp_downgrade.");
        this.set(3703, "This is valid only when DDLRLC feature is OFF. temporary tables (tables with # character) will be like dropping of a normal user table. By resetting this traceflag(off) the dropping of temporary tables is done by truncating the table followed by the normal drop code. This second behaviour limits the duration of locks held on system catalogs during the post_commit processng time. Since the truncate and drop are two separate transactions failure of the drop can result in table being left behind with truncation. For more info. See bug 168400-2.");
        this.set(3704, "Allow sybsystemdb drop. See also, traceflag (INIT, 26).");
        this.set(3705, "For drop_with_retry() tracking purposes.");
        this.set(3706, "When not in ddl-in-tran mode, allow the catalog locks in tempdb to be released before doing the post commit work of a table drop. This optimization is allowed even if the 'ddl-in-tran' status is set in the tempdb database, as far as we are not dropping a temp table under a user's defined xact context. This trace flag is obsoleted by CR 370520. Do not reuse for other purposes. Refer to trace flag 3708.");
        this.set(3707, "[OBSOLETE - do not reuse] When not in ddl-in-tran mode, allow the catalog locks to be released before doing the post commit work of a definition-time table drop, in the manner of trace 3706. This is applicable for definition time tables in all user dbs. This trace flag is obsoleted by CR 370520. Do not reuse for other purposes. Refer to trace flag 3709.");
        this.set(3708, "The behaviour that was activated and is described by trace flag 3706 has become the default behaviour under CR 370520. This trace flag exists to revert back if needed.");
        this.set(3709, "The behaviour that was activated and is described by trace flag 3707 has become the default behaviour under CR 370520. This trace flag exists to revert back if needed.");
        this.set(3710, "When not in ddl-in-tran mode, allow the catalog locks to be released in any database before doing the post commit work of an index creation or index drop. This optimization is allowed even if the 'ddl-in-tran' status is set in the given database, as far as we are not creating or dropping an index under a user's defined xact context.");
        this.set(3790, "Emulate an external attention to test that the drop_with_retry() cleanup of a temporary table succeeds. Available under diagserver.");
        this.set(3791, "Emulate a deadlock to test that the drop_with_retry() cleanup of a temporary table succeeds. Available under diagserver.");
        this.set(3792, "Emulate an abort before 'DROP DATABASE' gets a chance to commit.");
        this.set(3793, "While dropping local user tempdb of other instance using 'dbcc dbrepair': wait (uppause) after acquiring EX_LOCK on sysdatabases row for the db.");
        this.set(4601, "Displays list of privileges revoked due to cascade");
        this.set(5101, "Toggle on UNIXAIO_AFFINITY.");
        this.set(5102, "Toggle on IO_ONLY_AFFINITY.");
        this.set(2401, "Display information about the Chatr Manager cache, and the entire chatr_grab() process.");
        this.set(2402, "Enable Hankaku conversion between Eucjis and Sjis character sets.");
        this.set(2403, "In sendchars(), trace out in errorlog the bytes count and pad count related to Hankaku conversion.");
        this.set(2404, "Trace out calls to macros SEND??CHARS SENDBYTE SENDHOST, SENDI?");
        this.set(2405, "Print actual bytes set to host. Useful for debugging TDS protocol errors.");
        this.set(2406, "Trace calls to UNICHAR (UTF16) conversion routines in cast.c");
        this.set(2407, "Trace calls to UNICHAR (UTF16) conversion routines in foucvt_fns.c");
        this.set(2408, "Trace Unicode normalization code.");
        this.set(2409, "Enable the speedup routine to perform unicode comparison, the default is using unilib comparison routine.");
        this.set(2410, "Enable both the speedup and unilib to perform unicode comparisons. If they get different results, print out the strings being compared for diagnosis.");
        this.set(2411, "Disable GB pinyin speedup.");
        this.set(2412, "Trace print GB pinyin for debugging purpose.");
        this.set(2413, "Enable comparison between GB pinyin speedup and the Unilib API. Strings are printed if the results are different.");
        this.set(2414, "Enable strict conversions, whereby illegal client characters cause FOUCVT_RECVERR (2402) to be raised.");
        this.set(2415, "Reserved for future use.");
        this.set(2416, "Disable fix for Unilib conversion of embedded nulls");
        this.set(7400, "Print the free-space information during upgrade. (can be activated through dbcc traceon and through command-line)");
        this.set(7401, "Simulate a logfull conditions in the threshold manager during upgrade. This added for testing purpose. [Available only under diagserver]");
        this.set(7402, "Intended for use with 7401. This trace flag pass the logfull condition without raising an error to test the server behaviour. [Available only under diagserver]");
        this.set(7403, "Force the server to scan *all* allocation pages to calculate *all* unreserved pages at the end of recovery.");
        this.set(7404, "Print information about the pages that are being reserved/unreserved in threshold manager.");
        this.set(7405, "Print a message whenever the status of dbt_threshstat changes.");
        this.set(7406, "Force the server to scan the OAM pages to calculate the unreserved pages at the end of recovery.");
        this.set(7407, "Print i/o and time statistics for freespace accounting.");
        this.set(7408, "Force the server to scan *log segment* allocation pages; to recalculate free log space rather than use saved counts.");
        this.set(7409, "Force the server to scan *data* segment allocation pages; to recalculate free data page space rather than use saved counts.");
        this.set(7410, "Force the server *not* to scan log segment allocation pages; to use log space saved count even if it's not reliable. Mutually exclusive with, and overridden by, (THRESHERR, 8).");
        this.set(7411, "Force the server *not* to scan data segment allocation pages; to use data space saved counts even if they're not reliable. Mutually exclusive with, and overridden by, (THRESHERR, 9).");
        this.set(7412, "Print log free space values at significant boundaries, excluding checkpoints.");
        this.set(7413, "Print log free space values at significant boundaries, including checkpoints. A verbose version of 7412.");
        this.set(7414, "[ available for use ]");
        this.set(7415, "Print diagnostic information for shared disk cluster threshold manager run time activities");
        this.set(7416, "Print diagnostic information for cluster thmgr rebuild.");
        this.set(7417, "Testing for INDOUBT handling of OCB dbt_ocb_th_init.");
        this.set(7418, "Testing failure while collecting unreserved counts from all the nodes.");
        this.set(7419, "Testing limit change synchronization between two processes.");
        this.set(7420, "Hang dbtable instantiation before th_join");
        this.set(7421, "Hang the process when th_accounting is holding ocm lock on dbt_ocb_mld_logspace ");
        this.set(7422, "Set SEG_FREEZE in logsegment before calling th_accounting in pg_th_reserve");
        this.set(7423, "Simulate failure in message allocation.");
        this.set(7424, "Simulate failure when sending messages.");
        this.set(7425, "Simulate failure when lock the log during thmgr rebuild.");
        this.set(7426, "Simulate failure when obtaining disk map lock");
        this.set(7427, "Simulate failure when allocating memory");
        this.set(7428, "Simulate failure when getting dbtable in PCM callback function. When this trace flag is turned on, the sender of the PCM request will get a failure in the reply and therefore it will simulate remote PCM failure.");
        this.set(7429, "Simulate failure to start thmgr daemon thread");
        this.set(7601, "If the audit process has terminated, report all events (which cannot be inserted into the audit log), in the error log. This trace flag may only be turned on and off by a user with sso_role.");
        this.set(7602, "To be used for testing ONLY. This will force an exception to be raised within the audit process in order to test the automatic restart mechanism. If it is left on for more than 5 (AUD_RESTARTS) auditable events, then the audit process will terminate to enable the manual restart through \"sp_audit restart\", to be tested. This trace flag may only be turned on and off by a user with sso_role.");
        this.set(7603, "Do not include IP address as part of LOGIN audit events. DECOMMISSIONED !!! Do not re-use this number lest we cause some confusion since this flag is still supported in 12.x.");
        this.set(7604, "Provide a means to avoid that the audit process has to get the audit lock. In case of running out of locks or similar situations, a user can handle the situation by skipping this lock.");
        this.set(9101, "PERFORMANCE ANALYSIS: Yield SQL/LTI thread after sending every log record.");
        this.set(9103, "FEATURE TESTING: Report when entering, exiting, sleeping and waking up in 'lt_get_last_flushed_logrid()'. Also report why the routine woke up.");
        this.set(9105, "FEATURE TESTING: Report when 'lt_mem_alloc()' has run out of memory in the current proc header and is forced to either allocate another proc header or re-cycle an existing proc header.");
        this.set(9106, "FEATURE TESTING: Report when the DB log is being locked and un-locked for exclusive access by the SQL/LTI thread.");
        this.set(9107, "FEATURE TESTING: Always build a new stored procedure for every log record being sent. Doing so will quickly exhaust SQL Server sproc memory and causes 'out of memory' code path to be taken.");
        this.set(9108, "FEATURE TESTING: Report return status of 'lt_get_ref_page()'.");
        this.set(9109, "PERFORMANCE ANALYSIS: Report number of log page buffers read by 'do_logtransfer()'.");
        this.set(9110, "FEATURE TESTING: Report which proc header (primary or auxillary) was released when removing a stored procedure from the stored procedure cache.");
        this.set(9111, "PERFORMANCE ANALYSIS: Only send log records associated with a table (ie. INSERT and DELETE log records). Do not send BEGINXACT, ENDXACT, CHECKPOINT, etc. log records.");
        this.set(9112, "PERFORMANCE ANALYSIS: Perform all stages of the log transfer process up to, but not including, the row construction stage ('lt_substitute_val()'). Used to establish baseline performance metrics when measuring performance costs of latter stages. Ignored if flag 13 is set.");
        this.set(9113, "PERFORMANCE ANALYSIS: Perform all stages of the log transfer process up to, but not including, the row sending stage ('lt_exec_proc()'). Used to establish baseline performance metrics when measuring performance costs of latter stages. Over-rides flag 12.");
        this.set(9114, "PERFORMANCE ANALYSIS: Perform all stages of the log transfer process up to, but not including, the row de-coding stage ('lt_send_logrec()'). Used to establish baseline performance metrics when measuring performance costs of latter stages.");
        this.set(9115, "PERFORMANCE ANALYSIS: Do not send BEGINXACT log records.");
        this.set(9116, "PERFORMANCE ANALYSIS: Perform all stages of the log transfer process up to, but not including, the sproc execution stage ('run()'). Used to establish baseline performance metrics when measuring performance costs of latter stages.");
        this.set(9121, "PERFORMANCE ANALYSIS: Do not send the old and new timestamp fields of an XCHANGE log record. Used to investigate possible performance improvements gained from not sending fields not used by the Replication Server.");
        this.set(9122, "PERFORMANCE ANALYSIS: Do not look up and send the table's owner name. Used to investigate possible performance improvements gained from caching owner name information in the Replication Server.");
        this.set(9123, "FEATURE TESTING: In addition to sending the log record using the SQL/LTI interface, print the log record to the error log with 'xlogprint()'.");
        this.set(9124, "PERFORMANCE ANALYSIS: Truncate all column names to a single character. Used to investigate possible performance improvements gained from abbreviating all column names.");
        this.set(9125, "LOG VERSION CHANGE LOG DRAINING: Trace the progress of log draining that occurs during a log version change.");
        this.set(9130, "PROGRESS OF SP_REPTOSTANDBY: Trace the progress of sp_reptostandby when replication is turned on/off for a database");
        this.set(9131, "DDL COMMAND LOGGING: Print the exact text of the log record that will be written for a DDL command.");
        this.set(9132, "FEATURE TESTING: Test whether or not we write replicated log records for DML inside subscribable procedures.");
        this.set(9133, "FEATURE TESTING: Return FAIL from logcommand() after writing all the CMDTEXT log records.");
        this.set(9134, "Do update (delete/insert) matching the old way (forwards). Should only be used for testing or for rescanning old logs.");
        this.set(9135, "When looking up the ownername of a table, use getsusername() instead of getusername(). For backwards compatibilty with an old bug.");
        this.set(9136, "Unused");
        this.set(9137, "FEATURE TESTING: Always force SQL replication no matter if the object is replicated or not. ONLY FOR TESTING!!!");
        this.set(9138, "Print values of @rs_* parameters generated for SQL Replication.");
        this.set(9139, "Log @rs_dbg parameter with the text of the original query being replicated.");
        this.set(9140, "Simulate syntax error on RS side during database re-sync.");
        this.set(9141, "FEATURE TESTING: Switch between single thread and multithread Rep Agent mode.");
        this.set(9143, "Do not replicate DDL in non-replicated user stored procedures. ");
        this.set(9301, "Used by the security group to control the use of the slidof() internal builtin function");
        this.set(9304, "Initialize Data_High and Data_Low in syslabels catalog. Needs to be done only when the server boots for the first time.");
        this.set(9305, "Skip the initial label checks when booting the server. Also, if initializing the datahi/datalo values with this trace flag ON, do not remove the marker row (row with db_slid = 0) which indicates that server is not initialized. This flag is used when booting the server in excercisor mode.");
        this.set(9500, "Dump estimated and actual statistics for each Lava operator. Stats include IO, CPU, and cardinalities.");
        this.set(9501, "Dump the query tree for diagnostic purposes. From this, we can regenerate a problematic query plan using APs.");
        this.set(9502, "Dump estimated and actual statistics for each Lava operator in XML format.");
        this.set(9503, "TCF to enable calling LeOpProcessIOStats(). in conjunction with \"set statistics io on.\"");
        this.set(9504, "Dump Child execution statistics to the errorlog. This is applicable when TF 9500, \"set statististics plancost\", or \"set statistics io\" is on.");
        this.set(9505, "Pll specific tf used for debugging the Alfa Stats collector code. It will dump the I/O for each thread/operator pair.");
        this.set(9507, "TF to invalidate all of the pages for table's referenced in a query.");
        this.set(9510, "Disable collection of operator execution metrics.");
        this.set(9511, "For hash aggregation and hash distinct, TCF to generate an assertion if the output row count > input row count");
        this.set(9520, "Print parallel degree calibration related information");
        this.set(9521, "TF to dump the number of buffers claimed and unclaimed for each query plan.");
        this.set(9525, "TCF to dump detailed execution statistics for the merge-join operator.");
        this.set(9526, "Dumps Lava operator execution statistics and resource use in a showplan-style format at the most basic level.");
        this.set(9527, "Dumps Lava operator execution statistics and resource use in a showplan-style format at intermediate level.");
        this.set(9528, "Dumps Lava operator execution statistics and resource use in a showplan-style format at advanced level.");
        this.set(9529, "Dumps Lava operator execution statistics and resource use in a showplan-style format at most detailed level. Note, this level of tracing could impact query performance.");
        this.set(9530, "TCF to revert \"private\" buffer allocations back to 50% per operator.");
        this.set(9531, "Trace the private buffer allocation/ management in the Lava sort and hash operators.");
        this.set(9532, "TF for debugging the hash op costing methods. Similar to 9531, but only prints during code generation (as oppossed to enumeration) so the output is not overwhelming.");
        this.set(9533, "TCF to establish a minimum of 10% of the private buffers are free for partition buffer lists. This is ONLY for developmental performance analysis.");
        this.set(9534, "TCF to disable dynamic buffer allocation. Note that this is a compile-time flag. Once a procedure is cached, it will have no impact.");
        this.set(9535, "TCF to disable dynamic buffer allocation when the session's tempdb is bound to the default data cache. This is checked in the allocation phase as different session's tempdbs will have different bindings.");
        this.set(9541, "Print LOB parameter cache diagnostics.");
        this.set(9550, "Dump operator execution stats at each level of recursion.");
        this.set(9551, "Dump operator execution stats at release time. This is useful when operator is opened/closed many times within a single acquire/release interval.");
        this.set(9552, "Always allocate value bufs for the hashgrouping's output vtuple.");
        this.set(9554, "Override hash based distinct with sort based.");
        this.set(9555, "Disable role-reversal (used only on joins that are not outer joins).");
        this.set(9556, "Disable partition bit-vector filtering");
        this.set(9557, "Disable bucket bit-vector filtering");
        this.set(9558, "Use PROC_HDRs for hash table memory");
        this.set(9559, "Use the \"integral\" value for hash value");
        this.set(9560, "In the hash operator, force the codepath for wide rows (i.e. rows that span pages). This flag is for testing only.");
        this.set(9561, "Enable entry block filtering");
        this.set(9562, "Use hashed-loops processing right away, even for the original inputs!");
        this.set(9563, "Always use hashed-loops processing for spilled partitions.");
        this.set(9564, "Never use hashed-loops processing for spilled partitions.");
        this.set(9565, "Debug the cost and ROC computations in the hash operator.");
        this.set(9566, "Dump HT & operator execution stats at end for the first input set which is the child operators (when the op is closed).");
        this.set(9567, "Display tuple-by-tuple processing inside the hash operator.");
        this.set(9568, "Dump hash table after 1st iteration");
        this.set(9569, "Dump HT execution stats as you move from input set to input set after 1st level of processing. See 9566 above.");
        this.set(9570, "Dump spilled partitions' info as they become new input sets.");
        this.set(9571, "Force left outer hash joins");
        this.set(9572, "Force right outer hash joins");
        this.set(9573, "Force full outer hash joins");
        this.set(9574, "Force left semi hash joins");
        this.set(9575, "Force right semi hash joins");
        this.set(9576, "Force left anti semi hash joins");
        this.set(9577, "Force right anti semi hash joins");
        this.set(9579, "Dump the data sizes for the hash op in a feedback format (set appcontext) that can be used in subsequent iterations of the query.");
        this.set(9580, "If on, ignore scans and self-joins of the resvar table under ScalarAggOps and SortOps when determining the update mode of DML queries - results in more direct updates.");
        this.set(9595, "Trace top rowcount limit checking");
        this.set(9596, "Rserved for providing the diagnostics for");
        this.set(9597, "pipe buffer management. 9596 provides minimal information where as 9597 provides full dump.");
        this.set(9598, "Trace SQL functions input parameters and results.");
        this.set(10301, "Invoke RVM debugging function from within the the dispatcher against the MPCR by calling rvm_mpcr_print().");
        this.set(10302, "Invoke RVM print/debug function from within the dispatcher. This is different from the trace- point above in that it dispatches specific printing routines through the PIA array and dumps info on an ipcr by ipcr basis.");
        this.set(10303, "Invoke set completion of object ownership methodology and object resolution from old procedural object ownership.");
        this.set(10304, "Used internally by Quasr team. It will soon be obsolete.");
        this.set(10305, "Audit creation of temporary tables.");
        this.set(10306, "Disable the fix for CR 231083. 1. Let a user become the object owner in rvm__check_objo() if the effective uid is the same as the owner uid. 2. Let the effective uid check apply in rvm__check_dbo() if checking for the current database and called from a stored procedure.");
        this.set(10307, "Enable fix 371540. It assigns extra privileges to replication role: - DML access to any user object - EXECUTE access to any procedure - LOAD/DUMP/ONLINE/QUIESCE/CHECKPOINT - SET IDENTITY_INSERT/UPDATE ");
        this.set(10308, "Print out information on predicated privileges for a given access.");
        this.set(14601, "For each dbinfo get and each dbinfo release, print a stack trace.");
        this.set(14602, "In dbinfoget(), raise non-fatal error to test exception handler.");
        this.set(14603, "In dbinfoget(), raise fatal error to test exception handler.");
        this.set(14604, "For testing. In anch_setup_usganchors(), after the anchor has been inserted, force a failure to test run-time undo where an anchor is deleted as part of run-time undo.");
        this.set(14605, "For testing. In anch_setup_usganchors(), after the anchor has been inserted, force a shutdown to test recovery undo where an anchor is deleted as part of recovery undo.");
        this.set(14606, "For testing. In anch_insert(), after the anchor has been inserted, do not flush the data page, so that we can test recovery redo wheer an anchor is inserted as part of recovery redo.");
        this.set(8401, "Used during sysindexes exerciser run");
        this.set(8402, "DBINFO (sub-)manager: for each dbinfo get and each dbinfo release, print a stack trace.");
        this.set(8403, "DBINFO (sub-)manager: in ind_dbinfoget(), raise non-fatal error to test exception handler.");
        this.set(8404, "DBINFO (sub-)manager: in ind_dbinfoget(), raise fatal error to test exception handler.");
        this.set(8601, "Mark a pss with open sdeses as sick only if this flag is on.");
        this.set(10601, "Display worker thread manager trace info.");
        this.set(10602, "Display worker thread manager memory trace info.");
        this.set(10603, "Display worker thread manager messages.");
        this.set(11901, "Print each page id visited by reorg");
        this.set(11902, "Report each row unforwarding");
        this.set(11903, "Print the first page id visited by reorg");
        this.set(11904, "Print the INDEX structure received by the routine rbld__rebuild_indexes() and print the various changes that the INDEX structures go through. Also print a high- level description of the changes as they occur in this routine. With this trace output, diagnosticians can match up the code and read the log records to get a fairly good idea of what changes were done to the different page chains.");
        this.set(11905, "In reorg_handler(), print stack for EX_CONTROL errors.");
        this.set(11906, "Suppress informational messages to errorlog for REORG.");
        this.set(5601, "Don't delete syscoordinations info after a dtx commits or aborts.");
        this.set(5602, "Disable new transactions, but just enable astc recovery.");
        this.set(5603, "Print astc rpc contents, to errorlog, before sending them.");
        this.set(5604, "Print information, to errorlog, when a dtx moves from one state to another.");
        this.set(5605, "Astc task prints information about each dtx participants during astc recovery.");
        this.set(5608, "Force a astc rpc request to block forever to test astc timeout feature.");
        this.set(5609, "Switch off astc timeout mechanism.");
        this.set(5610, "Turn on debug bit when astc task gets spawned.");
        this.set(5611, "To be used in extraordinary circumstances, to clear the ASTC_DTX_RESOLVE_PENDING as for some reason astcrec_resolve_dtx() is not able to complete its work preventing master's log from getting truncated.");
        this.set(5612, "Do not set ASTC_DTX_RESOLVE_PENDING bit during boot-time. Must be used only in extraordinary circumstances when we know what we are doing. This trace flag has been added to provide work-arounds.");
        this.set(5613, "Force astc task to die to test restart. Also see 3634.");
        this.set(5614, "Force astc task to die to test restart. Also see 3634. (Testing purpose)");
        this.set(5615, "Make ASTC_PCM_CALLBACK to always send ASTC_PCM_INVALID. (Testing purpose)");
        this.set(5616, "Make instanceid reset fail. (Testing purpose)");
        this.set(10701, "Trace host interface locking primitives.");
        this.set(10702, "Trace heap creation/destruction and garbage collection start and end.");
        this.set(10703, "Trace thread operations initiated by JVM");
        this.set(10704, "Reserved for network operations.");
        this.set(10705, "Reserved for remote debugging.");
        this.set(10706, "Trace all fragment allocations and frees.");
        this.set(10707, "Trace opening of system classes in files.");
        this.set(10708, "Trace file reads.");
        this.set(10709, "Initiate engine switching during system class loading by peer VM.");
        this.set(10710, "Cause access violation in jvmh_mem_alloc().");
        this.set(10711, "Cause access violation in jvmfini(). ");
        this.set(10712, "Do not trigger the GC periodically in getThreadJNIEnv().");
        this.set(10713, "Check for object validity in InstanceOf().");
        this.set(10720, "Instantiate the thread JVM without sharing the peer-VM namespace. Used for debugging.");
        this.set(10721, "Trace the lifetime of JNI references.");
        this.set(10722, "Trace loading of system and user classes.");
        this.set(10723, "Trace the lifetime of JNI ClassLoaderLites.");
        this.set(10724, "When set, make \"on row\" as the default for Java-SQL columns.");
        this.set(10725, "Trace method signatures for debugging method overloading.");
        this.set(10726, "Disable releasing of JNI references. Used to debug coding errors where references are being freed prematurely.");
        this.set(10727, "Disable caching of JNI references.");
        this.set(10728, "Make execudf() and execfieldref() print whether they are using cached jniref ids or calling the JVM.");
        this.set(10729, "Trace receipt of object serializations (objRecv)");
        this.set(10730, "Trace sending of object serializations (objSend)");
        this.set(10731, "Trace class loader management routines. All diagnostic info is directly sent to the errorlog using uterrlog(). We do not use TRACEPRINT() since we're under spinlock protection. Note: 3604/3605 *do not* have any impact on this flag.");
        this.set(10732, "Check consistency of class loader matrix during execution. This only applies for non-diagservers. Diagserver always check for matrix consistency (see jcs/jloadermgr.c).");
        this.set(10733, "Trace creation and destruction of VM instances.");
        this.set(10740, "Print out info on execution of JDBC batches.");
        this.set(10741, "Print out the values of JDBC parameters in ns_set_val() and ns_get_val().");
        this.set(10742, "Turn Java Threading off.");
        this.set(10743, "Trace java.net execution");
        this.set(10744, "Disable perVm pool shrink after garbage collection.");
        this.set(10745, "Trace creation and destruction of VM spinlocks.");
        this.set(10746, "Trace acquiring/releasing VM spinlocks.");
        this.set(10747, "Turn off validation functions in sym VM.");
        this.set(10748, "Do not de-serialize Java objects during migration.");
        this.set(10749, "Print values relevant to Java timezone property determination. Can be set when improper time values are generated in order to detemrine timezone conversion table values.");
        this.set(9400, "Force PCI PCA/KonaVM plugin support.");
        this.set(9401, "Report PCI Bridge ASE Task / PCA binding.");
        this.set(9402, "Disable engine affinity scope.");
        this.set(9403, "Do not force PCA/JVM-OMNI affinity scope.");
        this.set(9404, "Enable BRIDGE SYNCHRONIZATION insrumentation.");
        this.set(9410, "Report BRIDGE SANITY physical engine push and pop affinity requests.");
        this.set(9411, "Report PCI Bridge HWP push engine affinity stack backtraces.");
        this.set(9412, "Report PCI Bridge HWP recursing push engine affinity events and count.");
        this.set(9413, "Report PCI Bridge HWP recursing push engine affinity stack backtraces.");
        this.set(9414, "Report PCI udfbridge SCOPE instrumentation");
        this.set(14700, "XML_PP_CREATE_PATH_INDEX Trace the main steps in the creation of the path index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14701, "XML_PP_PRINT_PATH_INDEX Print the in-memory copy of the path index before writing it out. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14702, "XML_PP_PATH_INDEX_EXPANSION Trace the dynamic expansion of the path index at runtime. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14703, "XML_PP_GROW_PATH_INDEX Force path index to be grown dynamically to test that code path. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14704, "XML_PP_PATH_INDEX_DEBUG Trace the main steps in the instantiation of the path cache index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14705, "XML_PP_PRINT_PATH_CACHE_INDEX Print the path cache index after instantiating it at query time. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14706, "XML_PP_PP_SANITY Forcibly execute all Sanity Checks within the PP module. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14707, "XML_PP_PATH_INDEX_SIZE Print the size of path index as it exist on the output stream. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14708, "XML_PP_PATH_CACHE_INDEX_SIZE Print the size of path cache index as it exist in-memory. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14709, "XML_PP_VALUE_INDEX_DEBUG Print the value index as it is being created. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14710, "XML_PP_GET_ELEMENT_CHILDREN_DEBUG Print the contents of the SearchContext in. SybDompp.getElementChildren() (NOT CURRENTLY IMPLEMENTED) before returning to QP.");
        this.set(14711, "XML_PP_GET_ATTRIBUTE_CHILDREN_DEBUG Print the contents of the SearchContext in SybDompp.getAttributeChildren() before returning to QP. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14712, "XML_PP_GET_CHILDREN_NAMES_DEBUG Print the list of children names in SybDompp.getChildrenNames() before returning to QP. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14713, "XML_PP_INTERSECT_DEBUG Print the contents of the SearchContext in SybDompp.intersect() before returning to QP. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14714, "XML_PP_UNION_DEBUG Print the contents of the SearchContext in SybDompp.union() before returning to QP. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14715, "XML_PP_BINARY_SEARCH_DEBUG General trace for the execution of BsearchContext.binarySearch(). (NOT CURRENTLY IMPLEMENTED)");
        this.set(14716, "XML_PP_RAISE_IN_GETSYBDOMFROMPATHCACHE Force getSybDomFromPathCache() to raise SybXmlInvalidPathException. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14717, "XML_PP_RAISE_IN_INSERTPATHINDEX Force insertPathIndex() to raise SybXmlInternalException. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14718, "XML_PP_RAISE_IN_ADDNOIDOFFSET Force addNOIDOffset() to raise SybXmlInternalException after Expanding NOID/Offset array. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14719, "XML_PP_RAISE_IN_WRITEPATHINDEX Force writePathIndex() to raise IOException after writing the Path Index partially to test error handling. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14720, "XML_PP_RAISE_IN_CREATEVINDEX Force createVindex() to raise SybXmlInternalException at an arbitrary point to test error handling. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14721, "XML_PP_RAISE_IN_ITERATOR Force iterator() to raise SybXmlInternalException to test error handling. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14722, "XML_PP_RAISE_IN_RESULTXML Force resultXml() to raise SybXmlInternalException to test error handling. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14723, "XML_PP_RAISE_IN_BINARYSEARCH Force binarySearch() to raise SybXmlInternalException. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14724, "XML_PP_COMPARE_DEBUG Every time there is a request to compare OIDs from the upper layer, print the operands and the operators. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14725, "XML_PP_VALUEINDEX_NO_AUTOINDEXING Turn off autoindexing for ValueIndex creation. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14726, "XML_PP_VALUEINDEX_USE_PREDICATED_SCANS Trace predicated scans using valueindex. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14727, "XML_PP_PATHINDEX_BSEARCH_DEBUG Trace binary search for PATH INDEX. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14728, "XML_PP_PATHCACHEINDEX_BSEARCH_DEBUG Trace binary search for PATH CACHE INDEX. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14729, "XML_PP_VALUEINDEX_BSEARCH_DEBUG Trace binary search for VALUE INDEX. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14730, "XML_PP_SEARCHCONTEXT_BSEARCH_DEBUG Trace binary search for SearchContextArray object. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14731, "XML_PP_RESULTS_BSEARCH_DEBUG Trace binary search RESULTS before exiting binarySearch(). (NOT CURRENTLY IMPLEMENTED)");
        this.set(14732, "XML_PP_RESULT_BLOB_DEBUG Trace to track formation of the result BLOB. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14733, "XML_PP_PRINT_RESULT_SEARCH_CONTEXT Print out the result SearchContext. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14734, "XML_PP_INSERT_PATH_INDEX_DEBUG Trace Calls to insert path index from store. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14735, "XML_PP_TRACE_OID_PROCESSING_COUNTS Print How may OIDs have been processed in increments of 1000 OIDs. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14736, "XML_PP_RESTRICT_PRINT_PATH_INDEX If this traceflag is ON, the output of T14701 will be restricted to printing ONLY the paths and not the OIDs. This flag HAS NO EFFECT if T14701 is FALSE. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14737, "XML_STORE_NODEINFO_DEBUG Trace NodeInfo requests during execution. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14738, "XML_STORE_LINKINDEX_DEBUG Link Index calls. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14739, "XML_STORE_SYBNODE_DEBUG SybNode calls. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14740, "XML_STORE_PRINT_PATHINDEX Print the Path Index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14741, "XML_STORE_PRINT_LINKINDEX Print the Link Index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14742, "XML_STORE_PRINT_OIDOFFSETTABLE Print the Oid Offset table. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14743, "XML_STORE_PRINT_HEADER Print the header. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14744, "XML_STORE_PRINT_STORE Print the complete store. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14745, "XML_STORE_PRINT_SYBNODES Print SybNodes as they are read. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14746, "XML_STORE_RESOLVEDESCENDANT_DEBUG Trace calls to resolveDescendant(). (NOT CURRENTLY IMPLEMENTED)");
        this.set(14747, "XML_STORE_RESOLVECHILDREN_DEBUG Trace calls to resolveChildren(). (NOT CURRENTLY IMPLEMENTED)");
        this.set(14748, "XML_STORE_RESOLVEATTRIBUTES_DEBUG Trace calls to resolveAttributes(). (NOT CURRENTLY IMPLEMENTED)");
        this.set(14749, "XML_STORE_PRINT_INDEX_OFFSETS Print out the offsets to the indexes in SybStore.");
        this.set(14750, "XML_PP_PRINT_PATH_HIT Print out the path hit counter info.");
        this.set(14751, "XML_PP_PRINT_NUM_RESULT_NODES Print out the number of nodes in the result set and number of nodes visited during result materialization.");
        this.set(14800, "XML_QP_SWITCH_TRANSLATION Switch for translation of query operators to physical operators. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14801, "XML_QP_PRINT_SEARCH_CONTEXTS Switch to show all the scanned searchcontexts in XML format. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14802, "XML_QP_GROUP_DEBUG Print execution time details for Group operator. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14803, "XML_QP_INTERSECT_DEBUG Print execution time details for Intersect operator. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14804, "XML_QP_COMPARE_DEBUG Print execution time details for Compare operator. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14805, "XML_QP_PRINT_ANSWERS Print execution answers in iteration mode. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14806, "XML_QP_INDEX_DEBUG Print execution time details for Index operator. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14807, "XML_QP_PRINT_TREES Print XML query tree.");
        this.set(14808, "XML_QP_CHILD_OVERWRITTEN_WARNING Print a warning if a child is being overwritten through setLH() and setRH() methods in Tree Operators. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14809, "XML_QP_PREDICATED_SCANS_OFF Don't use predicated scans. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14810, "XML_QP_SETS_DEBUG Diagnostics for set difference operators. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14811, "XML_QP_EMPTY_SCAN_WARNING Warn user in case a scan returns EMPTY.");
        this.set(14812, "XML_QP_DESC_DEBUG Debug descdendant and wildcard translation.");
        this.set(14813, "XML_QP_EMPTYOP_DEBUG Debug EMPTY operator.");
        this.set(14814, "XML_QP_BINARYOP_DEBUG Debug BINARY operator.");
        this.set(14815, "XML_QP_PRINT_QUERY Print xpath Query.");
        this.set(14816, "XML_QP_NO_RESULT Query will be executed but result will not be generated.");
        this.set(14817, "XML_QP_COMPILE_ONLY Query will be parsed and translated but will not be executed.");
        this.set(14818, "XML_QP_PARSE_ONLY Query will be parsed but will not be translated and executed.");
        this.set(14819, "XML_QP_UNARY_DEBUG Debug unary operators.");
        this.set(14820, "XML_QP_XFORM_DEBUG Print transformation details.");
        this.set(14821, "XML_QP_NARYOP_DEBUG Debug NARY operator.");
        this.set(14822, "XML_QP_FUNCTIONOP_DEBUG Debug FUNCTION operator.");
        this.set(14823, "XML_QP_NODETOATOMVALOP_DEBUG Debug Node to atomiv value operator.");
        this.set(14824, "XML_QP_TRACE_PARSER Print XML query parser output.");
        this.set(14825, "XML_QP_PRINT_PLAN Print XML query plan.");
        this.set(14826, "XML_QP_FILTEROP_LEAD_DOUBLESLASH_RELATIVE Treat leading // as a relative path inside filter. This is a server level traceflag to be set using -T option at the server start-up.");
        this.set(14827, "XMLTABLE: Parsing in SQL layer.");
        this.set(14828, "XMLTABLE: Normalization in SQL layer.");
        this.set(14829, "XMLTABLE: SQL optimization.");
        this.set(14830, "XMLTABLE: Execution in the SQL context.");
        this.set(14831, "XMLTABLE: Parsing in XMLQP layer.");
        this.set(14832, "XMLTABLE: Normalization in XMLQP layer.");
        this.set(14833, "XMLTABLE: Optimization in XMLQP layer.");
        this.set(14834, "XMLTABLE: Execution in XMLQP layer.");
        this.set(14835, "XMLTABLE: Results set in XMLQP layer.");
        this.set(14836, "XMLTABLE: Trace insertion of LH and RH during transformation.");
        this.set(14837, "XMLTABLE: Disable complex row pattern XPath fix.");
        this.set(14838, "XMLTABLE: Enable complex XPath queries in row and column patterns.");
        this.set(14900, "XML_UTIL_NO_UNLINK_XMLSESSION Do not unlink XmlSession to test out session cleanup.");
        this.set(14901, "XML_UTIL_USE_MALLOC Use malloc()/free() for memory instead of server per process heap memory.");
        this.set(14902, "UNUSED");
        this.set(14903, "XML_UTIL_MEMORY_DEBUG Trace memory usage from XML/C++ layer. Display memory returned by new()/stl-allocate. Note, must be set with -T14903 only.");
        this.set(14904, "XML_UTIL_PRINT_PARSE_TIME Monitor the time required to parse the XML data. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14905, "XML_UTIL_PRINT_RESULT_GENERATION Monitor the time required to form the XML result fragment. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14906, "XML_UTIL_PRINT_QUERY_EXECUTION_TIME Trace the XQL query being executed. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14907, "XML_UTIL_PRINT_VALINDEX_CREATION_TIME Monitor the time required to form the ValueIndex. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14908, "XML_UTIL_PRINT_NOID_QUALIFICATION_TIME Monitor the time required to Qualify NOIDs using Value Index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14909, "XML_UTIL_PRINT_NOID_QUALIFICATION_TIME_NO_VI Monitor time required to Qualify NOIDs WITHOUT USING Value Index. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14910, "XML_UTIL_RESULT_IS_VALID_XML Monitor whether the result being generated is valid XML. (NOT CURRENTLY IMPLEMENTED)");
        this.set(14911, "XML_UTIL_DOM_VALID_CHECK Generate the XML in the form of a String from a DOM created as part of result set code. This is meant for internal testing of validity of the DOM.");
        this.set(14912, "UNUSED");
        this.set(14913, "XML_UTIL_RAISE_IN_TXT_READ Raise exception instead of calling txt_read() to test exceptions during read from InputSource.");
        this.set(14914, "XML_UTIL_RAISE_IN_TXT_SEEK Raise exception instead of calling txt_seek() to test exceptions during read from InputSource.");
        this.set(14915, "XML_UTIL_RAISE_IN_TXT_AVAILABLE Raise exception instead of calling txt_available() to test exceptions during read from InputSource.");
        this.set(14916, "XML_UTIL_RAISE_IN_TXT_SIZE Raise exception instead of calling txt_size() to test exceptions during read from InputSource.");
        this.set(14917, "XML_UTIL_ALLOW_TOSQLX Allows usage of the builtin to_sqlx to the user when turned on.");
        this.set(14918, "XML_UTIL_PRINT_DIAG_TIME Print out time diagnostic info.");
        this.set(14919, "XML_UTIL_PRINT_DIAG_MEM Print out memory allocation diagnostic info.");
        this.set(14920, "In function sybnew(), it is useful to keep track the caller function that requests the memory allocation/deallocation. This trace flag is TRACECMDLINE only.");
        this.set(14921, "XML_UTIL_SETXMLORD_DICT");
        this.set(14922, "XML_UTIL_SETXMLORD_NOCASE");
        this.set(14923, "XML_UTIL_SETXMLORD_NOACCENT");
        this.set(14924, "XML_UTIL_TEARDOWN_ORDER_VIOLATION trace whether getSession() is called after unRegisterSession()");
        this.set(14925, "XML_UTIL_ENABLE_FILE_PROTOCOL Support file protocol with xml schema in xerces");
        this.set(15101, "Allow user to set properties beginning with 'ASE_'.");
        this.set(15102, "Add DEBUG 'ASE_*' properties for msgsend().");
        this.set(15103, "Turn on DEBUG in RTMS kernel layer. TRACECMDLINE() only.");
        this.set(15104, "Don't use external engine to do MQ API calls.");
        this.set(15105, "Allow MQ API calls on NT386, even though the platform is not currently supported.");
        this.set(15301, "Reverse preference for sarg in place of sort avert order in j_tables_serial_nlj. This allows partial backout of 286862.");
        this.set(15302, "Turn on bugfix 362460. This allows non-inner tables of an outer join query to participate in subquery attachment considertation when determining join order.");
        this.set(15303, "Turn on bugfix 382241. This uses J_BIT_SELECTIVITY for BIT datatype instead of the default magic number.");
        this.set(15304, "Disable like optimization for escape characters");
        this.set(15305, "Turn on the strong compatibility mode, where the old optimizer is invoked nested within the Galaxy one and generates an AP to describe the old best plan. ");
        this.set(15306, "Turn on Replicated Partitioning.");
        this.set(15307, "Ignore forced join orders forced using FORCEPLAN.");
        this.set(15308, "Ignore index/prefetch/parallel/ /replacement forcings.");
        this.set(15309, "Model warm cache costing for all tables and indices by using 0 PIO costing note - this does not affect the PIO costing of sorts and hash operations");
        this.set(15310, "Turn off interpolation costing for workaround purpose.");
        this.set(15311, "Disable CR 552795's fix. This leaves duplicates rows in reformatted table even though they're not needed.");
        this.set(15312, "Turn off imdb_costing for in-memory DBs");
        this.set(15313, "Disable CR 575251's fix which adds the missing constant sarg predicate in the parent optblock. This could lead to wrong result.");
        this.set(15315, "TCF to disable opportunistic distinct handling for the DISTINCT view under EXISTS subquery. This will be deprecated once the more comprehensive fix (albeit more risky) for wrong results problem under CR 574724-1 is checked in.");
        this.set(15316, "If enabled, disables the fix made under CR 569947-1 and \"opens up\" the original fix 497066 to all ISNULL references. The fix 569947-1 was limiting the 497066 changes to only the ISNULLs under a SUBQOP transformed predicate under a subquery to avoid behavior regressions caused ");
        this.set(15317, "Reserved for disabling assertion raised in HistAdjustColLevelStats(). This is a temporary tcf flag. It should be removed after 452118-1 is fixed.");
        this.set(15318, "If enabled, this traceflag disables the fix made under CR 463716-1 which prevents additional joins at the nested parent aggregate level.");
        this.set(15319, "If enabled, this command line traceflag disables the fix made under CR 468692-1 which prevents transitive closures from being formed on join clauses involving [uni]char columns when non-binary sort orders are in effect.");
        this.set(15320, "If enabled, this will allow the creation of an order preserving merge xchg over a re-partitioned or replicated xchg with N consumers anywhere under the former's sub-tree");
        this.set(15321, "If enabled, this command line traceflag disables the fix made under CR 500736-1 which is a general fix for the issue where char columns could hold distinct values in the char domain but are considered equal.");
        this.set(15322, "If enabled, Select expression involving Subq is not pushed down to SubqFilter operator for update query.");
        this.set(15326, "Disable fix for 546737 which uses clustered pages when deciding to use large LIO for RID scans");
        this.set(15327, "Disable fix for 546737 which uses MRU costing in the buffer manager optimization ");
        this.set(15328, "Disable fix for 546125 which tries to use unique indexes for cursors which are not declared \"for read only\" or \"for update\"");
        this.set(15329, "Disable fix for 539440 which avoids row reduction if stats are not available for all columns in the projection");
        this.set(15330, "Disable fix for 486917-1 which introduces the GtqSubqs as don't care distinct tables during partial distinct group handling.");
        this.set(15334, "disable CR 561987 fix on the StoreInd pop parent needed useful ordering. Used as last resort to keep valid plan such as a mergejoin over storeind. It could lead to stacktrace or wrong result for other queries. Avoid using it at server level.");
        this.set(15335, "enable CR567317 that transforms tables in a DISTINCT to EXISTS joins where possible");
        this.set(15336, "Disable fix for 497066, which infers the nullability of isnull() builtin by looking at the nullability of its params");
        this.set(15337, "Enable Storeindex generation over a forced index (eager enforcement style).");
        this.set(15338, "Enable equijoin orders even when there's no MJ");
        this.set(15339, "Enable store_index over matching index scan with no sarg.");
        this.set(15340, "Enable server wide eager aggregation, opportunistic style on Ecq1/Gtt");
        this.set(15341, "Disable server wide eager aggregation");
        this.set(15342, "Reserved for eager aggregation");
        this.set(15343, "Reserved for eager aggregation");
        this.set(15344, "Reserved for eager aggregation");
        this.set(15345, "Reserved for eager aggregation");
        this.set(15346, "Reserved for eager aggregation");
        this.set(15347, "Reserved for eager aggregation");
        this.set(15348, "Reserved for eager aggregation");
        this.set(15349, "Reserved for eager aggregation");
        this.set(15350, "Turn off added cost of copying rows from data manager to QP");
        this.set(15351, "Turn off added CPU cost of hash join operator");
        this.set(15352, "Turn off expression optimization, in which single column expressions are used with histograms to estimate the selectivity of the expression");
        this.set(15353, "Turn off intelligent index scan costing.");
        this.set(15354, "Turn off reduced costs of DOL index lookaside optimization");
        this.set(15355, "Turn off out of range histogram adjustments");
        this.set(15356, "Turn on out of range histogram adjustments (for 15.0.2 ESD #2 only) ");
        this.set(15357, "Do not cost non-covered index scans which do not have limiting sargs and do not have stats on all sargs");
        this.set(15358, "Disable the recosting of deep pushdown transformation plan (CR 545771-1 fix).");
        this.set(15359, "Turn on outer join costing");
        this.set(15360, "Turn on the learning optimizer mode.");
        this.set(15361, "Disable using userid 0 for learning ap/qpm. This will reduce the sharing of sysqueryplans catalog space.");
        this.set(15362, "Allows certain attempts of legacy plan generation under ase125_primed mode. This is only used for debugging purpose.");
        this.set(15363, "Disable the alternative greedy algorithm in the search engine.");
        this.set(15364, "Diagserver will have assertion failure for compatibility mode failure. Used during testing only.");
        this.set(15365, "Diagserver will have assertion failure for compatibility AP application failure. Used during testing only.");
        this.set(15366, "Allows multi-ptn table query to go through legacy plan generation under ase125_primed mode. This is only used for debugging purpose.");
        this.set(15367, "enabling AQT won't take effect unless this cmdline traceflag is on");
        this.set(15368, "Allows error message to be printed from old optimizer under basic_optimization mode. This is only used for debugging purpose.");
        this.set(15369, "Reserved for the learning optimizer mode.");
        this.set(15370, "Turn off reformatting-based sunquery de-correlation. ");
        this.set(15371, "Use 100 as the outer for correlated subquery only. Right now, the default 100 is used for all subq with R3T_SUBQUERY. ");
        this.set(15372, "Turn on compensation of estimated PIO using the PIO compensation factor stored in systabstats");
        this.set(15373, "Keep the regular view materialization decision from the query tree during galaxy lop tree generation");
        this.set(15374, "reduce the cases that CgpPop codegen would need to call norm3_expr() again on a scalar");
        this.set(15375, "Disable the fix for 468310-1 in case the fix would cause unexpected regression. Should be removed once the fix is tested extensivly");
        this.set(15377, "If enabled, use the internal optgoal allrows_basic for allrows_oltp.");
        this.set(15378, "Print data points for optimizer procedure cache and compile/ optimization time distribution via the INSTRUMENT_OPTIMIZER_FOR_PRED_ELIM macro.");
        this.set(15379, "Turn off optimization done under 478692-1 for predicate elimination.");
        this.set(15380, "If enabled, search engine timeout based on procedure cache consumption is disabled.");
        this.set(15381, "If enabled, disables BAD_INDID warning msg.");
        this.set(15382, "If enabled, disables order-less special OR generation");
        this.set(15383, "Turn off fix to limit step count for default histogram tuning factor.");
        this.set(15384, "If enabled, disables RowLimit optimization.");
        this.set(15385, "If enabled, disables Min/Max optimization.");
        this.set(15386, "Disable the search engine rule of forcing the placement of a subquery under OR after the OR predicate is computable.");
        this.set(15387, "Disable join tcid with MATCHNULL semantics.");
        this.set(15388, "Enable \"set statistics resource on\"");
        this.set(15389, "Disable 531199-1 fix that stops the poplets from getting prunned");
        this.set(15390, "If enabled, turn off reading of statistics in basic_optimization in anticipation that a query plan will be successfully applied");
        this.set(15391, "If enabled, turn off internal heap inside OptPool (pheap_cpp) so some memory will not be reused during the optimization process.");
        this.set(15392, "If enabled do not add partial blocks (less than a full mempage) to the internal optimizer heap (pheap_cpp)");
        this.set(15393, "If Enabled, Turn off psuedo scan generation for large-IN lists during lop generation phase.");
        this.set(15394, "If enabled, turn on the AP Enumeration mode.");
        this.set(15395, "If enabled, turn on tracking of memory allocations/deallocations done by Optimizer through SybNew mechanism");
        this.set(15397, "Under 15399 on, switches to trace print *only* the known Memory Leaks");
        this.set(15398, "Turn off optimizer Memory Leak tracking");
        this.set(15399, "Trace print optimizer Memory Leaks (except the known ones)");
        this.set(15401, "Print Certicom Crypto API return values.");
        this.set(15402, "Trace column data, keys during encryption & decryption.");
        this.set(15403, "Determines if the drop command can be used to drop sysencryptkeys.");
        this.set(15404, "Trace Seeding data.");
        this.set(15405, "Use Fixed salt when encrypting & decrypting system password. Enabled for internal builds only (debug aid).");
        this.set(15406, "Print salt used to encrypt/decrypt system encryption key. ");
        this.set(15407, "Pad plain text buffer with fixed bytes instead of zeroes. This may be useful if we dealing with memory trashing. Identifying a pattern of bytes from a memory dump can help.");
        this.set(15408, "Avoid printing some encryption errors. Use when testing whether certain encryption capabilities are available.");
        this.set(15500, "turn off cluster wide heartbeat when one instance hangs under 2901");
        this.set(15501, "disable the heartbeat on a cluster server");
        this.set(15502, "enable cipc test daemon");
        this.set(15503, "trace cipc test code");
        this.set(15504, "trace cipc msg and msg queue");
        this.set(15505, "trace cipc service ");
        this.set(15506, "trace cipc netep and flow control");
        this.set(15507, "turn on cipc msg and msg pool check");
        this.set(15508, "turn on cms diagnostic message.");
        this.set(15509, "use unconnetced cipc udp sockets.");
        this.set(15510, "Trace BCM Thread's code. (global).");
        this.set(15511, "Trace cluster cache manager code client side (local).");
        this.set(15512, "Trace cluster cache manager code client side (global).");
        this.set(15513, "Turn off dirty page flush (global).");
        this.set(15514, "Turn off last log BAST. (global)");
        this.set(15515, "Turn off BUFFER BAST. (global)");
        this.set(15516, "Stop all Buffer Manager Thread requests after the buffer is searched kept. Do not lock or service the request. (global). ");
        this.set(15517, "Stop all Buffer Manager Thread requests after the buffer, is searched, kept and locked. Do not service the request. (global).");
        this.set(15518, "Stop the BCM thread from servicing release lock requests. (global).");
        this.set(15519, "Future BCM Thread trace.");
        this.set(15520, "BCM thread will release locks for Log pages also. (global).");
        this.set(15521, "Print physical lock acquisition/ release messages.");
        this.set(15522, "Trace physical lock acquistion/ release messages in a buffer.");
        this.set(15523, "Printing stack trace when we get dead lock during phsyiscal acquissition.");
        this.set(15524, "Diable the SANITY check on latches held on a buffer before it is unkep.");
        this.set(15525, "Unused.");
        this.set(15526, "Unused.");
        this.set(15527, "Trace Last log page optimization, in which appenders doesn't take PHYLOCK on the last log page.");
        this.set(15528, "Trace LLOL acquisition/release.");
        this.set(15529, "Trace PHY lock acquisition/release of log buffers.");
        this.set(15530, "Skip cleaning stale buffers at remote instances for operations which uses extent deallocation.");
        this.set(15531, "trace cluster rebuild");
        this.set(15532, "trace batched message during rebuild");
        this.set(15533, "trace lock directory uncache ");
        this.set(15534, "trace garbage collection");
        this.set(15535, "trace indoubt lock");
        this.set(15536, "trace lock release");
        this.set(15537, "trace range lock");
        this.set(15538, "trace dead lock search");
        this.set(15539, "trace BAST");
        this.set(15540, "trace object lock");
        this.set(15541, "trace physical lock");
        this.set(15542, "trace last log lock");
        this.set(15543, "turn on load balancing mode ");
        this.set(15544, "trace lock master");
        this.set(15545, "trace lock client");
        this.set(15546, "trace lock cancel request");
        this.set(15547, "trace logical lock");
        this.set(15548, "trace cluster rebuild in verbose mode");
        this.set(15549, "trace lock manager message cache");
        this.set(15550, "trace DES manager");
        this.set(15551, "(FOR TESTING ONLY) simulate cluster in failover before checkpoint ");
        this.set(15552, "(FOR TESTING ONLY) simulate master failing to send checkpoint request ");
        this.set(15553, "Timestamp column testing");
        this.set(15554, "(FOR TESTING ONLY) simulate cluster in failover during checkpoint");
        this.set(15555, "(FOR TESTING ONLY) simulate remote server raises exception or fails to do checkpoint ");
        this.set(15556, "Obsoleted in SDC GA. See trace flag 15557. This trace flag was documented in beta documentation. Do not reuse this trace flag.");
        this.set(15557, "Allow a node to join/leave when a dump database/dump tran is in progress. Not for customers. Test purpose only.");
        this.set(15558, "SDC identity cols debugging.");
        this.set(15559, "Cluster cache mgr");
        this.set(15560, "Trace OCM code");
        this.set(15561, "Trace OCM code - not too verbose");
        this.set(15562, "Trace OCM test client code");
        this.set(15563, "(Reserved for OCM/PCM)");
        this.set(15564, "(Reserved for OCM/PCM) ");
        this.set(15565, "(Reserved for OCM/PCM) ");
        this.set(15566, "(Reserved for OCM/PCM)");
        this.set(15567, "(Reserved for OCM/PCM)");
        this.set(15568, "Hang the spid in cm_dbclean if it is running under PCM callback function.");
        this.set(15569, "Hang the spid in cm_ptnclean if it is running under PCM callback function.");
        this.set(15570, "Trace PCM code");
        this.set(15571, "Enable PCM test client");
        this.set(15572, "Trace PCM test client code");
        this.set(15573, "Print data being (un)marshalled in hex");
        this.set(15574, "Invoke OCM client callback with SEND/RECV commands before returning from ocm_lock() - useful to test the callback on 1 node.");
        this.set(15575, "Trace DMM operations.");
        this.set(15576, "Disable OCMDIAG");
        this.set(15577, "Disable PCMDIAG");
        this.set(15578, "Enable Extensive OCMDIAG ");
        this.set(15579, "trace cluster database operation error ");
        this.set(15580, "trace cluster database operation");
        this.set(15581, "hang instantiation of dbtable before getting lastlog object lock");
        this.set(15582, "Disable spawning of Cipc Native Thread.");
        this.set(15585, "Trace Veritas Cluster Membership Plug- in (VCMP)");
        this.set(15587, "Trace connection migration");
        this.set(15588, "Cancel migration instead of confirming it (for testing purposes)");
        this.set(15591, "Prints msgs to the errorlog regarding the pages redone during node failover");
        this.set(15592, "Hangs the server before log segment goes to a seg_freeze state");
        this.set(15593, "(REC_FAILOVER_TRACE) Prints msgs regarding xdes reinstantiation and reclaiming of clr space during redo.");
        this.set(15594, "REC_TEST_FAILOVER1 crash server before finishing xact in database with dbid 4");
        this.set(15595, "REC_TEST_FAILOVER2 crash server before finishing xact in database with dbid 5");
        this.set(15596, "REC_TEST_FAILOVER3 crash server before finishing xact in database with dbid 6");
        this.set(15597, "REC_OAMCNT_TRACE diagnostic trace for oam counts recovery");
        this.set(15598, "REC_OAMCNT_SIMULATE_TRACE1 internal testing. crash node before pg__updateoam during allocation");
        this.set(15599, "REC_OAMCNT_SIMULATE_TRACE2 internal testing. crash node before pg__updateoam during deallocation");
        this.set(15800, "Traces single user mode tracking fields. Currently it is used to enable the tracing only under SANITY.");
        this.set(15802, "Used to disable page transfers in BCM during physical lock acquisition.");
        this.set(15803, "Used to enable timeout feature BCM-CLM integration.");
        this.set(15804, "trace the queueing and unqueueing from pending queue");
        this.set(15818, "set number of lock replication for user database to 0");
        this.set(15819, "MSF integration support. Under this traceflag lock replication value is also set to RCLM_NUM_CSVRS");
        this.set(15815, "force affinity master assignment");
        this.set(15816, "lock turn off proactive GC");
        this.set(15817, "lock turn off forced GC");
        this.set(15820, "lock multiple API trace");
        this.set(15821, "lock multiple master trace");
        this.set(15822, "lock multiple message trace");
        this.set(15823, "physical lock diagnostics");
        this.set(15824, "object lock diagnostics");
        this.set(15825, "logical lock disgnostics");
        this.set(15826, "physical lock timeout");
        this.set(15827, "for temporary CLM debug");
        this.set(15828, "To trace logical lock LOCK_NOQUEUE flow");
        this.set(15829, "for temporary CLM performance change");
        this.set(15830, "initiator failure");
        this.set(15831, "alter database failure testpoint1");
        this.set(15832, "alter database failure testpoint2");
        this.set(15833, "alter database failure testpoint3");
        this.set(15834, "create database failure testpoint1");
        this.set(15835, "create database failure testpoint2");
        this.set(15836, "create database failure testpoint3");
        this.set(15837, "drop database failure testpoint1");
        this.set(15838, "drop database failure testpoint2");
        this.set(15839, "online database failure testpoint1");
        this.set(15840, "online database failure testpoint2");
        this.set(15841, "load database failure testpoint1");
        this.set(15842, "load database failure testpoint2");
        this.set(15843, "load database failure testpoint3");
        this.set(15844, "load transaction failure testpoint1");
        this.set(15845, "load transaction failure testpoint2");
        this.set(15846, "load transaction failure testpoint3");
        this.set(15847, "disk init failure testpoint1");
        this.set(15850, "Enable fix for d_log to work from gdb in SDC. (ref:cr# 487099-1). Note that this solution is not a fullproof solution since this only handles d_log hang in ocm_lock.If d_log hangs in physical lock this fix will not work.");
        this.set(15851, "Trace the cluster notification code for multi-tempdb binding change.");
        this.set(15852, "(FOR TESTING ONLY) Cause the initiator instance to crash in the first phase before notification to other instances are sent.");
        this.set(15853, "(FOR TESTING ONLY) Cause the initiator instance to crash in the first phase after notification to other instances are sent.");
        this.set(15854, "(FOR TESTING ONLY) Cause the initiator instance to crash in the second phase before notification to other instances are sent.");
        this.set(15855, "(FOR TESTING ONLY) Cause the initiator instance to crash in the second phase after notification to other instances are sent.");
        this.set(15856, "(FOR TESTING ONLY) Cause one of the notified instance to crash during the first phase before sending the reply back.");
        this.set(15857, "(FOR TESTING ONLY) Cause one of the notified instance to crash during the second phase before sending the reply back.");
        this.set(15858, "(FOR TESTING ONLY) Cause one of the notified instance to crash during the first phase after sending the reply back.");
        this.set(15859, "(FOR TESTING ONLY) Cause one of the notified instance to crash during the second phase after sending the reply back.");
        this.set(15860, "(FOR TESTING ONLY) Cause the initiator instance to crash in the second phase after all the processing is done and MULTDB_GUID lock is released.");
        this.set(15861, "(FOR TESTING ONLY) Cause the multempdb service pcm multdb_svcpcm_checkreply() to fail for client side error handling test.");
        this.set(15879, "enable CIPC Direct send when CIPC thread is enable and disable direct send when CIPC thread disabled.");
        this.set(15881, "Trace marshall/unmarshall for specific ocbs used for replication agent.");
        this.set(15882, "Trace pcm calls for replication.");
        this.set(15883, "Trace sleeps/wake ups for xlog flushes.");
        this.set(15884, "Trace rep agent processing.");
        this.set(15885, "Trace marshall/unmarshall for specific OCBs used for text/image replication.");
        this.set(15886, "Testing initiator failure during dbcc dbrepair \"findstranded\" and dbcc findstranded.");
        this.set(15887, "Testing other node failure during dbcc dbrepair \"findstranded\" and dbcc findstranded.");
        this.set(15888, "print RA_CONTEXT structure.");
        this.set(15889, "Reserved for replication.");
        this.set(15891, "To trace control flow for \"iofence\" module (iofence.c)");
        this.set(15892, "(For testing only). This trace flag is used to switch on \"dbcc fence_admin()\" functionality. Find more details of \"dbcc fence_admin()\" in \"I/O fencing\" func. spec.");
        this.set(15893, "Disable IP Link Monitor in CIPC layer.");
        this.set(15894, "Enable TCP as a protocol for the CIPC transport");
        this.set(15895, "Enable printing of buffer allocation summary in CIPC when allocations fail");
        this.set(15896, "Temporarily reserved for diagnostics to catch open table failure");
        this.set(15897, "Simulating incomplete recovery");
        this.set(15898, "Simulating db disk I/O failure");
        this.set(15899, "Simulating internode disconnect.");
        this.set(16401, "This \"master\" traceflag turns on all but the most verbose workload manager trace hooks.");
        this.set(16402, "This \"master\" traceflag turns on ALL workload manager trace hooks, except for verbose load calculation. (see 16410)");
        this.set(16403, "Trace spid connection to and disconnection from logical clusters.");
        this.set(16404, "Trace routes and route resolution.");
        this.set(16405, "Trace interfaction with the directory control layer. This is useful to see redirect addresses being cached, etc. It also traces regeneration of logical cluster redirect lists.");
        this.set(16406, "Trace client redirection and migration. Use with 16405 to see the contents of the lists sent to clients.");
        this.set(16407, "Trace the publication of extended HA lists to clients. Use with 16405 to see the contents of the lists.");
        this.set(16408, "Trace events posted to / received in the wlmgr handler. This excludes events related to load recalcuation. (see 16409)");
        this.set(16409, "Trace activity related to load recalculation. Note: this is NOT active under 16401.");
        this.set(16410, "Display individual metrics and load scores during load recalculation. Note: this is NOT active under 16401 or 16402.");
        this.set(16411, "Trace activity and state transitions related to actions.");
        this.set(16412, "Trace activity during startup and shutdown.");
        this.set(16413, "Trace changes in the wlmgr configuration. This includes create, add, drop, and set commands, as well as wlmgr_admin() commands. This will also display boot time setup and run time config changes.");
        this.set(16414, "Trace changes in the logical cluster state machines. This includes transitions from online to offline, etc.");
        this.set(16415, "Trace the marking of connections for migration / lazy death. Note: this is not active under 16401.");
        this.set(16416, "Turn on OCM tracing for wlmgr OCBs. This flag must be on at ocb initialization. This means it must be on at boot time for existing logical clusters. It will be effective at run time for new logical clusters. Once the OCB is initialized with this trace flag set, it will remain in effect until the ocb is reinitialized, i.e. reboot. Note: this is not active under 16401.");
        this.set(16417, "Verbose tracing of ocm callback transfer, i.e. send and receive. Old and new structures are printed for receive, sending structures for send. Note: this is not active under 16401.");
        this.set(16418, "Terse tracing of ocm callback transer. Small messages are printed indicating a transfer is taking place, but structures are not displayed.");
        this.set(16450, "Allow ASE to boot even if the workload manager encounters a fatal error during initialization. This instance will act as if no wlmgr is present and all tasks will use the system logical cluster.");
        this.set(16451, "Use aggressive dynamic load distribution pacing. This means more DLDs will be allowed in a given load period, resulting in a faster redistribution of the load. On the downside, there is a greater chance of doing too much DLD, causing the load to swing back and forth until it stabilizes.");
        this.set(16497, "INTERNAL ONLY / TESTING: bypass early phase shutdown. This tests handling of early phase shutdown error in late phase and instance down / recovery.");
        this.set(16498, "INTERNAL ONLY / TESTING: Return failure for remote operations, only on even numbered instances. Used to simulate partial success / failure of remote op.");
        this.set(16499, "INTERNAL ONLY / TESTING: Return failure for remote operations.");
        this.set(15701, "Print information about page remapping.");
        this.set(15702, "Test exception handling in LOAD DB (1)");
        this.set(15703, "Test exception handling in LOAD DB (2)");
        this.set(15704, "During creation of a normal database, create a sysusages row for every 256 pages. This is useful to test disk map fragmentation.");
        this.set(15705, "Report diagnostics for information that is extracted from the database dump (runlists etc).");
        this.set(15706, "For debug purposes to see the contents of sysaltusages in LOAD DB (3)");
        this.set(15707, "Report a stack trace when attempting to remap a page and the authority to do this via adb_begin_update() has not been requested. This can be used to determine callers that are modifying pages in the database \"under the covers\". One symptom of this might be a 40239 error in the error log: \"Attempt to write to read-only device '%s'.\"");
        this.set(15708, "Test exception handling in adding stripe devices (LOAD TRAN and LOAD DB).");
        this.set(15709, "Test exception handling in LOAD TRAN (1)");
        this.set(15710, "Test exception handling in removing a segment, just after rows have been deleted from sysusages.");
        this.set(15711, "Test exception handling in LOAD TRAN (2)");
        this.set(15712, "Test exception handling in LOAD TRAN (3)");
        this.set(15713, "Test exception handling in LOAD TRAN (4)");
        this.set(15714, "Test exception handling in LOAD TRAN (5)");
        this.set(15715, "Before LOAD DATABASE and LOAD TRAN, do not absorb disk space used by the disposable changes segment into the permanent changes segment. This reduces the amount of logging in the master database since the disposable changes segment will be re-used and not re-created.");
        this.set(15716, "Convert the trace flags that test exception handling in LOAD TRAN into a server crash to test LOAD TRAN restartability.");
        this.set(9601, "trace flag reserved for Enhanced Thread Control functionality.");
    }

    public class TraceFlagRecord {
        private int _id = -1;
        private String _description = null;

        public TraceFlagRecord(int id, String description) {
            this._id = id;
            this._description = description;
        }

        public String toString() {
            return StringUtil.left(this._id + "", 5) + " - " + this._description;
        }
    }
}

