/*
 * Decompiled with CFR 0.152.
 */
package asemon.check;

import asemon.Asemon;
import asemon.Version;
import asemon.check.CheckForUpdates;
import asemon.gui.AboutBox;
import asemon.utils.Configuration;
import asemon.utils.PlatformUtils;
import asemon.utils.SwingUtils;
import asemon.utils.TimeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class CheckDialog
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static Logger _logger = Logger.getLogger(AboutBox.class);
    private static final long serialVersionUID = -2789087991515012041L;
    private JButton _ok_but = new JButton("OK");
    private JButton _resetProxy_but = new JButton("Reset Proxy Settings");
    private JLabel _proxyHost_lbl = new JLabel("HTTP Proxy Host");
    private JTextField _proxyHost_txt = new JTextField();
    private JLabel _proxyPort_lbl = new JLabel("HTTP Proxy Port");
    private JTextField _proxyPort_txt = new JTextField();
    private JCheckBox _doNotShow_chk = new JCheckBox("Do not show this again.");
    private JCheckBox _doNotShowFeedback_chk = new JCheckBox("Do not show this feedback again.");
    private CheckForUpdates _cfu = null;

    private CheckDialog(Frame owner, CheckForUpdates cfu) {
        super(owner, "", true);
        this.init(owner, cfu);
    }

    private CheckDialog(Dialog owner, CheckForUpdates cfu) {
        super(owner, "", true);
        this.init(owner, cfu);
    }

    private void init(Window owner, CheckForUpdates cfu) {
        this._cfu = cfu;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public static void showDialog(Component owner, CheckForUpdates cfu) {
        Configuration conf = Configuration.getCombinedConfiguration();
        boolean doNotShowOnFailure = conf.getBooleanProperty("CheckDialog.doNotShowOnFailure", false);
        long lastShowDate = conf.getLongProperty("CheckDialog.lastShowTime", System.currentTimeMillis());
        long msSinceLastShow = System.currentTimeMillis() - lastShowDate;
        long showTimeLimit = 2592000000L;
        if (_logger.isDebugEnabled()) {
            String lastShowDateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(lastShowDate));
            _logger.debug((Object)("Last show date for CheckForUpdate Dialog was '" + lastShowDateStr + "', Saved 'CheckDialog.doNotShowOnFailure' was '" + doNotShowOnFailure + "', msSinceLastShow=" + msSinceLastShow + "(" + TimeUtils.msToTimeStr(msSinceLastShow) + "), showTimeLimit=" + showTimeLimit + "(" + TimeUtils.msToTimeStr(showTimeLimit) + ")."));
        }
        if (msSinceLastShow > showTimeLimit) {
            doNotShowOnFailure = false;
        }
        if (cfu != null && !cfu._checkSucceed && doNotShowOnFailure) {
            return;
        }
        boolean doNotShowFeedback = conf.getBooleanProperty("CheckDialog.doNotShowFeedback", false);
        long lastFeedbackDate = conf.getLongProperty("CheckDialog.lastFeebackDate", 0L);
        if (cfu != null && cfu.hasFeedback() && doNotShowFeedback) {
            _logger.debug((Object)("This feedback date was '" + cfu.getFeedbackTime() + "', Saved 'CheckDialog.lastFeebackDate' was '" + lastFeedbackDate + "', doNotShowFeedback=" + doNotShowFeedback + "."));
            if (cfu.getFeedbackTime() > lastFeedbackDate) {
                _logger.debug((Object)"SHOW Feedback.");
            } else {
                _logger.debug((Object)"--- DO NOT SHOW Feedback.");
                return;
            }
        }
        CheckDialog dialog = null;
        dialog = owner instanceof Frame ? new CheckDialog((Frame)owner, cfu) : (owner instanceof Dialog ? new CheckDialog((Dialog)owner, cfu) : new CheckDialog((Dialog)null, cfu));
        dialog._doNotShow_chk.setToolTipText("Even if you check this option, a new question like this will popup after 30 days.");
        dialog._doNotShow_chk.setSelected(doNotShowOnFailure);
        dialog._doNotShowFeedback_chk.setToolTipText("<html>Do not show <b>this</b> feedback question again.<br>Future feedbacks questions will still show up!</html>");
        dialog._doNotShowFeedback_chk.setSelected(doNotShowFeedback);
        dialog.setVisible(true);
        dialog.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Configuration conf;
        if (this._resetProxy_but.equals(e.getSource())) {
            this._proxyHost_txt.setText("");
            this._proxyPort_txt.setText("");
            conf = Configuration.getInstance("USER_TEMP");
            conf.remove("http.proxyHost");
            conf.remove("http.proxyPort");
            conf.save();
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
        }
        if (this._ok_but.equals(e.getSource())) {
            conf = Configuration.getInstance("USER_TEMP");
            String proxyHost = this._proxyHost_txt.getText().trim();
            String proxyPort = this._proxyPort_txt.getText().trim();
            if (!proxyHost.equals("")) {
                if (proxyPort.equals("")) {
                    proxyPort = "80";
                }
                conf.setProperty("http.proxyHost", proxyHost);
                conf.setProperty("http.proxyPort", proxyPort);
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", proxyPort);
                this._proxyHost_txt.setText(proxyHost);
                this._proxyPort_txt.setText(proxyPort);
            }
            conf.setProperty("CheckDialog.doNotShowOnFailure", this._doNotShow_chk.isSelected());
            conf.setProperty("CheckDialog.lastShowTime", System.currentTimeMillis());
            if (this._cfu.hasFeedback()) {
                conf.setProperty("CheckDialog.doNotShowFeedback", this._doNotShowFeedback_chk.isSelected());
                conf.setProperty("CheckDialog.lastFeebackDate", this._cfu.getFeedbackTime());
            }
            conf.save();
            this.dispose();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hle) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
            URL url = hle.getURL();
            String urlStr = "" + hle.getURL();
            _logger.info((Object)("You clicked on '" + urlStr + "'. On Windows systems a mail client or http browser will be opened."));
            if (PlatformUtils.getCurrentPlattform() == 0) {
                if (urlStr.startsWith("file:/")) {
                    urlStr = urlStr.substring("file:/".length());
                }
                String oscmd = "cmd.exe /c start " + urlStr;
                try {
                    Runtime rt = Runtime.getRuntime();
                    rt.exec(oscmd);
                }
                catch (Exception e) {
                    SwingUtils.showErrorMessage("Problems executing command", "Problems when executing a Windows command to start '" + oscmd + "'.", e);
                }
            }
        }
    }

    protected void initComponents() {
        this.setTitle("Check For Updates");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("ins 0", "[fill]", ""));
        panel.add((Component)this.initCheckPanel(), "height 100%, wrap 15");
        panel.add((Component)this._ok_but, "tag ok, gapright 15, bottom, right, pushx, wrap 15");
        this.setContentPane(panel);
        this._ok_but.addActionListener(this);
        this._resetProxy_but.addActionListener(this);
    }

    protected JPanel initCheckPanel() {
        JScrollPane scrollpane;
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 20 20 20 20", "", ""));
        JLabel icon = new JLabel(SwingUtils.readImageIcon(Asemon.class, "images/asemon_icon_32.gif"));
        JLabel appName = new JLabel();
        appName.setText(Version.getAppName());
        appName.setFont(new Font("Dialog", 1, 20));
        String msg = "";
        boolean showWhatsNew = false;
        boolean showFeedback = false;
        if (this._cfu.checkSucceed()) {
            if (this._cfu.hasUpgrade()) {
                msg = "<b><center>New Upgrade is Available</center></b><br><br>Latest version is " + this._cfu.getNewAsemonVersionStr() + "<br><br>" + "And can be downloaded:<br>" + "<A HREF=\"" + this._cfu.getDownloadUrl() + "\">" + this._cfu.getDownloadUrl() + "</A>";
                showWhatsNew = true;
            } else {
                msg = "<b>You have got the latest release.</b><br><br>I sure hope you like it.<br>And don't forget to donate!";
                if (this._cfu.hasFeedback()) {
                    msg = "<b>You have got the latest release.</b><br>But please read the below messages.";
                    showFeedback = true;
                }
            }
        } else {
            msg = "<b>The Update Check failed.</b><br><br>This could happen for two reasons:<br>- You do <b>not</b> have internet access from this machine.<br>- You sit behind a proxy server.<br><br>If you do not have internet access from this machine,<br>please do manual checks for new releases at:<br><A HREF=\"http://www.asemon.se\">http://www.asemon.se</A><br><br>If you normally have internet access from this machine<br>I'm guessing you sit behind a Proxy Server and<br>you are using i PAC file for proxy lookups<br>Sorry! I do not support that right now.<br><br>Please fill in the Proxy Server and Port below and try again.";
        }
        String str = "<html><HEAD> <style type=\"text/css\"> <!-- body {font-family: Arial, Helvetica, sans-serif;} --> </style> </HEAD> " + msg + "</html>";
        JEditorPane feedback = new JEditorPane("text/html", str);
        feedback.setEditable(false);
        feedback.setOpaque(false);
        feedback.addHyperlinkListener(this);
        panel.add((Component)icon, "span, center, wrap");
        panel.add((Component)appName, "span, center, wrap 20");
        panel.add((Component)feedback, "span, pushx, grow, wrap 20");
        if (showWhatsNew) {
            String whatsNewUrl = this._cfu.getWhatsNewUrl();
            try {
                _logger.info((Object)("AseMon What's new page is '" + whatsNewUrl + "'."));
                JEditorPane whatsNew = new JEditorPane(new URL(whatsNewUrl));
                whatsNew.setEditable(false);
                whatsNew.addHyperlinkListener(this);
                scrollpane = new JScrollPane(whatsNew);
                scrollpane.setMinimumSize(new Dimension(200, 300));
                scrollpane.setPreferredSize(new Dimension(500, 300));
                panel.add((Component)scrollpane, "span, push, grow, wrap 10");
            }
            catch (Exception e) {
                _logger.warn((Object)("Problems opening What's new page '" + whatsNewUrl + "'. Caught: " + e.getMessage()));
            }
        }
        if (showFeedback) {
            String feedbackUrl = this._cfu.getFeedbackUrl();
            try {
                _logger.info((Object)("AseMon feedback page is '" + feedbackUrl + "'."));
                JEditorPane feedbackPane = new JEditorPane(new URL(feedbackUrl));
                feedbackPane.setEditable(false);
                feedbackPane.addHyperlinkListener(this);
                scrollpane = new JScrollPane(feedbackPane);
                scrollpane.setMinimumSize(new Dimension(200, 300));
                scrollpane.setPreferredSize(new Dimension(500, 300));
                panel.add((Component)scrollpane, "span, push, grow, wrap 10");
            }
            catch (Exception e) {
                _logger.warn((Object)("Problems opening feedback page '" + feedbackUrl + "'. Caught: " + e.getMessage()));
            }
        }
        if (this._cfu.checkSucceed()) {
            if (this._cfu.hasFeedback()) {
                panel.add((Component)this._doNotShowFeedback_chk, "wrap");
            }
        } else {
            this._proxyHost_txt.setText(System.getProperty("http.proxyHost", ""));
            this._proxyPort_txt.setText(System.getProperty("http.proxyPort", ""));
            panel.add((Component)this._proxyHost_lbl, "");
            panel.add((Component)this._proxyHost_txt, "pushx, growx, wrap");
            panel.add((Component)this._proxyPort_lbl, "");
            panel.add((Component)this._proxyPort_txt, "pushx, growx, wrap");
            panel.add((Component)this._resetProxy_but, "skip, right, pushx, wrap");
            panel.add((Component)this._doNotShow_chk, "wrap");
        }
        return panel;
    }

    public static void main(String[] args) {
        Properties log4jProps = new Properties();
        log4jProps.setProperty("log4j.rootLogger", "INFO, A1");
        log4jProps.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        log4jProps.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        log4jProps.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d - %-5p - %-30c{1} - %m%n");
        PropertyConfigurator.configure((Properties)log4jProps);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CheckForUpdates check = new CheckForUpdates();
        JFrame frame = new JFrame();
        check._asemonVersion = "1.0.0";
        check._downloadUrl = "http://www.asemon.se/download.html";
        check._checkSucceed = true;
        check._hasUpgrade = true;
        CheckDialog.showDialog(frame, check);
        check._checkSucceed = true;
        check._hasUpgrade = false;
        CheckDialog.showDialog(frame, check);
        check._checkSucceed = false;
        check._hasUpgrade = false;
        CheckDialog.showDialog(frame, check);
    }
}

