/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Asemon;
import asemon.Version;
import asemon.check.CheckForUpdates;
import asemon.utils.PlatformUtils;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class AboutBox
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static Logger _logger = Logger.getLogger(AboutBox.class);
    private static final long serialVersionUID = -2789087991515012041L;
    private JButton _ok_but = new JButton("OK");
    private JButton _checkForUpdate_but = new JButton("Check For Updates...");

    public AboutBox(Frame owner) {
        super(owner);
        this.initComponents();
        this.pack();
        Dimension size = this.getPreferredSize();
        size.width = 500;
        this.setPreferredSize(size);
        this.setSize(size);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._ok_but.equals(e.getSource())) {
            this.dispose();
        }
        if (this._checkForUpdate_but.equals(e.getSource())) {
            CheckForUpdates.noBlockCheck(this, true, true);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hle) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
            URL url = hle.getURL();
            String urlStr = "" + hle.getURL();
            _logger.info((Object)("You clicked on '" + urlStr + "'. On Windows systems a mail client or http browser will be opened."));
            if (PlatformUtils.getCurrentPlattform() == 0) {
                if (urlStr.startsWith("file:/")) {
                    urlStr = urlStr.substring("file:/".length());
                }
                String oscmd = "cmd.exe /c start " + urlStr;
                try {
                    Runtime rt = Runtime.getRuntime();
                    rt.exec(oscmd);
                }
                catch (Exception e) {
                    SwingUtils.showErrorMessage("Problems executing command", "Problems when executing a Windows command to start '" + oscmd + "'.", e);
                }
            }
        }
    }

    protected void initComponents() {
        this.setTitle("About");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("ins 0", "[fill]", ""));
        JTabbedPane tab = new JTabbedPane();
        tab.add("About", this.initTabAbout());
        tab.add("Todo", this.initTabTodo());
        tab.add("History", this.initTabHistory());
        tab.add("System Info", this.initTabSystemInfo());
        panel.add((Component)tab, "height 100%, wrap 15");
        panel.add((Component)this._checkForUpdate_but, "        gapleft  15, bottom, left, split");
        panel.add((Component)this._ok_but, "tag ok, gapright 15, bottom, right, pushx, wrap 15");
        this.setContentPane(panel);
        this._ok_but.addActionListener(this);
        this._checkForUpdate_but.addActionListener(this);
    }

    protected JPanel initTabAbout() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 20 20 20 20", "[grow]", ""));
        JLabel icon = new JLabel(SwingUtils.readImageIcon(Asemon.class, "images/asemon_icon_32.gif"));
        JLabel appName = new JLabel();
        appName.setText(Version.getAppName());
        appName.setFont(new Font("Dialog", 1, 20));
        String str = "<html><HEAD> <style type=\"text/css\"> <!-- body {font-family: Arial, Helvetica, sans-serif;} --> </style> </HEAD> Version: " + Version.getVersionStr() + "<br>" + "Build: " + Version.getBuildStr() + "<br>";
        if (Version.getVersionStr().endsWith(".dev")) {
            str = str + "<b>Note: This is a development version</b><br>";
        }
        str = str + "<br>Source Code Revision: " + Version.getSourceRev() + "<br>" + "Source Code Date: " + Version.getSourceDate() + "<br>" + "<br>" + "Send comments and suggestions to: <br>" + "<A HREF=\"mailto:goran_schwarz@hotmail.com\">goran_schwarz@hotmail.com</A><br>" + "<A HREF=\"mailto:gorans@sybase.com\">gorans@sybase.com</A><br>" + "<br>" + "Credits to:<br>" + "<UL>" + "<LI>Jean-Paul Martin  for initial version of AseMon.<br>" + "<LI>Reine Lindqvist   for various help.<br>" + "</UL>" + "<br>" + "If this application gave you better performance, <br>" + "<B>please</B> donate whatever you think it was worth: <br>" + "<A HREF=\"http://www.asemon.se\">http://www.asemon.se</A><br>" + "</html>";
        JEditorPane feedback = new JEditorPane("text/html", str);
        feedback.setEditable(false);
        feedback.setOpaque(false);
        feedback.addHyperlinkListener(this);
        panel.add((Component)icon, "center, wrap");
        panel.add((Component)appName, "center, wrap 20");
        panel.add((Component)feedback, "wrap 20");
        return panel;
    }

    protected JPanel initTabTodo() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.addHyperlinkListener(this);
        htmlPane.setEditable(false);
        htmlPane.setOpaque(false);
        URL url = Version.class.getResource("todo.html");
        if (url != null) {
            try {
                htmlPane.setPage(url);
            }
            catch (IOException e) {
                htmlPane.setText("Attempted to read a bad URL: " + url);
                _logger.error((Object)("Attempted to read a bad URL: " + url));
            }
        } else {
            htmlPane.setText("Couldn't find file: todo.html");
        }
        panel.add((Component)new JScrollPane(htmlPane), "Center");
        return panel;
    }

    protected JPanel initTabHistory() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.addHyperlinkListener(this);
        htmlPane.setEditable(false);
        htmlPane.setOpaque(false);
        URL url = Version.class.getResource("history.html");
        if (url != null) {
            try {
                htmlPane.setPage(url);
            }
            catch (IOException e) {
                htmlPane.setText("Attempted to read a bad URL: " + url);
                _logger.error((Object)("Attempted to read a bad URL: " + url));
            }
        } else {
            htmlPane.setText("Couldn't find file: history.html");
        }
        panel.add((Component)new JScrollPane(htmlPane), "Center");
        return panel;
    }

    protected JPanel initTabSystemInfo() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Properties sysProps = System.getProperties();
        Vector<String> cols = new Vector<String>();
        cols.add("Keys");
        cols.add("Values");
        Vector rows = new Vector();
        Enumeration<Object> e = sysProps.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            Vector<String> row = new Vector<String>();
            row.add(key);
            row.add(val);
            rows.add(row);
        }
        JXTable tab = new JXTable(rows, cols);
        tab.setAutoResizeMode(0);
        tab.packAll();
        tab.setSortable(true);
        tab.setColumnControlVisible(true);
        panel.add((Component)new JScrollPane((Component)tab), "Center");
        return panel;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new AboutBox(null);
    }
}

