/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.AseConfig;
import asemon.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class AseConfigPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(AseConfigPanel.class);
    private JXTable _table = null;
    private static final String SECTION_NOT_CONNECTED = "<NOT CONNECTED>";
    private static final String SECTION_ALL = "<SHOW ALL SECTIONS>";
    private JLabel _timestamp_lbl = new JLabel("Time");
    private JTextField _timestamp_txt = new JTextField("<NOT CONNECTED>");
    private JLabel _section_lbl = new JLabel("Section Name");
    private JComboBox _section_cbx = new JComboBox<String>(new String[]{"<NOT CONNECTED>"});
    private JLabel _config_lbl = new JLabel("Config Name");
    private JTextField _config_txt = new JTextField();
    private JCheckBox _showOnlyNonDefaults_chk = new JCheckBox("Show Only Non Default Values", false);

    public AseConfigPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        AseConfig aseConfig = AseConfig.getInstance();
        if (!aseConfig.isInitialized()) {
            JLabel notConnected = new JLabel("Not yet Initialized, please connect first.");
            notConnected.setFont(new Font("Dialog", 1, 16));
            this.add((Component)notConnected, "North");
            return;
        }
        this.add((Component)this.createFilterPanel(), "North");
        this.add((Component)this.createTablePanel(), "Center");
    }

    private JPanel createFilterPanel() {
        JPanel panel = SwingUtils.createPanel("Filter", true);
        panel.setLayout((LayoutManager)new MigLayout());
        this._timestamp_lbl.setToolTipText("When was the configuration snapshot taken");
        this._timestamp_txt.setToolTipText("When was the configuration snapshot taken");
        this._section_lbl.setToolTipText("Show only a specific Section");
        this._section_cbx.setToolTipText("Show only a specific Section");
        this._config_lbl.setToolTipText("Show only config name with this name.");
        this._config_txt.setToolTipText("Show only config name with this name.");
        this._showOnlyNonDefaults_chk.setToolTipText("Show only modified configuration values (same as sp_configure 'nondefault')");
        panel.add((Component)this._section_lbl, "");
        panel.add((Component)this._section_cbx, "");
        panel.add((Component)this._timestamp_lbl, "split 2, right, push");
        panel.add((Component)this._timestamp_txt, "wrap");
        panel.add((Component)this._config_lbl, "");
        panel.add((Component)this._config_txt, "span, push, grow, wrap");
        panel.add((Component)this._showOnlyNonDefaults_chk, "span, wrap");
        this._timestamp_txt.setEnabled(false);
        this._section_cbx.removeAllItems();
        this._section_cbx.addItem(SECTION_ALL);
        for (String section : AseConfig.getInstance().getSectionList()) {
            this._section_cbx.addItem(section);
        }
        this._timestamp_txt.setText(AseConfig.getInstance().getTimestamp() + "");
        this._section_cbx.addActionListener(this);
        this._config_txt.addActionListener(this);
        this._showOnlyNonDefaults_chk.addActionListener(this);
        AutoCompleteDecorator.decorate((JComboBox)this._section_cbx);
        Runnable deferredAction = new Runnable(){

            @Override
            public void run() {
                AseConfigPanel.this._showOnlyNonDefaults_chk.setSelected(true);
                AseConfigPanel.this.setTableFilter();
            }
        };
        SwingUtilities.invokeLater(deferredAction);
        return panel;
    }

    private JPanel createTablePanel() {
        JPanel panel = SwingUtils.createPanel("Actual Data Table", false);
        panel.setLayout(new BorderLayout());
        this._table = new LocalTable();
        this._table.setModel((TableModel)AseConfig.getInstance());
        this._table.setSelectionMode(0);
        this._table.setAutoResizeMode(0);
        this._table.packAll();
        this._table.setSortable(true);
        this._table.setColumnControlVisible(true);
        this._table.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this._table.addHighlighter((Highlighter)new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Object o_pending = adapter.getValue(adapter.getColumnIndex((Object)"Pending"));
                return Boolean.TRUE.equals(o_pending);
            }
        }, Color.RED, null));
        JScrollPane scroll = new JScrollPane((Component)this._table);
        panel.add(scroll);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._section_cbx.equals(source)) {
            this.setTableFilter();
        }
        if (this._config_txt.equals(source)) {
            this.setTableFilter();
        }
        if (this._showOnlyNonDefaults_chk.equals(source)) {
            this.setTableFilter();
        }
    }

    private void setTableFilter() {
        RowFilter<TableModel, Integer> filter;
        String str;
        int colIndex;
        String colName;
        ArrayList<RowFilter> filters = new ArrayList<RowFilter>();
        if (this._section_cbx.getSelectedIndex() != 0) {
            colName = "SectionName";
            colIndex = AseConfig.getInstance().findColumn(colName);
            str = this._section_cbx.getSelectedItem() + "";
            if (colIndex < 0) {
                _logger.warn((Object)("Column name '" + colName + "' can't be found in AseConfig table."));
            } else {
                filter = new RowFilter<TableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                        return entry.getStringValue(colIndex).equals(str);
                    }
                };
                filters.add(filter);
            }
        }
        if (!this._config_txt.getText().trim().equals("")) {
            colName = "ConfigName";
            colIndex = AseConfig.getInstance().findColumn(colName);
            str = this._config_txt.getText().trim();
            if (colIndex < 0) {
                _logger.warn((Object)("Column name '" + colName + "' can't be found in AseConfig table."));
            } else {
                filter = new RowFilter<TableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                        return entry.getStringValue(colIndex).indexOf(str) >= 0;
                    }
                };
                filters.add(filter);
            }
        }
        if (this._showOnlyNonDefaults_chk.isSelected()) {
            colName = "NonDefault";
            colIndex = AseConfig.getInstance().findColumn(colName);
            if (colIndex < 0) {
                _logger.warn((Object)("Column name '" + colName + "' can't be found in AseConfig table."));
            } else {
                RowFilter<TableModel, Integer> filter2 = new RowFilter<TableModel, Integer>(){

                    @Override
                    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                        Object o = entry.getValue(colIndex);
                        if (o instanceof Boolean) {
                            boolean isNonDefault = (Boolean)o;
                            return isNonDefault;
                        }
                        return true;
                    }
                };
                filters.add(filter2);
            }
        }
        if (filters.size() == 0) {
            this._table.setRowFilter(null);
        } else {
            this._table.setRowFilter(RowFilter.andFilter(filters));
        }
    }

    private class LocalTable
    extends JXTable {
        private static final long serialVersionUID = 1L;

        private LocalTable() {
        }

        protected JTableHeader createDefaultTableHeader() {
            return new JXTableHeader(this.getColumnModel()){
                private static final long serialVersionUID = 1L;

                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.getColumnModel().getColumnIndexAtX(p.x);
                    if (index < 0) {
                        return null;
                    }
                    Object colNameObj = this.getColumnModel().getColumn(index).getHeaderValue();
                    String toolTip = null;
                    if (colNameObj instanceof String) {
                        String colName = (String)colNameObj;
                        toolTip = AseConfig.getInstance().getColumnToolTip(colName);
                    }
                    return toolTip;
                }
            };
        }

        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row >= 0 && col >= 0) {
                col = super.convertColumnIndexToModel(col);
                row = super.convertRowIndexToModel(row);
                TableModel tm = this.getModel();
                AbstractTableModel atm = null;
                if (tm instanceof AbstractTableModel) {
                    atm = (AbstractTableModel)tm;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append("<b>Description:  </b>").append(atm.getValueAt(row, atm.findColumn("Description"))).append("<br>");
                    sb.append("<b>Section Name: </b>").append(atm.getValueAt(row, atm.findColumn("SectionName"))).append("<br>");
                    sb.append("<b>Config Name:  </b>").append(atm.getValueAt(row, atm.findColumn("ConfigName"))).append("<br>");
                    sb.append("<b>Run Value:    </b>").append(atm.getValueAt(row, atm.findColumn("ConfigValue"))).append("<br>");
                    sb.append("<b>Max Value:    </b>").append(atm.getValueAt(row, atm.findColumn("MaxValue"))).append("<br>");
                    sb.append("<b>Min Value:    </b>").append(atm.getValueAt(row, atm.findColumn("MinValue"))).append("<br>");
                    if (Boolean.TRUE.equals(atm.getValueAt(row, atm.findColumn("Pending")))) {
                        sb.append("<br>");
                        sb.append("<b>NOTE: ASE Needs to be rebooted for this option to take effect.</b>").append("<br>");
                    }
                    sb.append("</html>");
                    tip = sb.toString();
                }
            }
            if (tip != null) {
                return tip;
            }
            return this.getToolTipText();
        }
    }
}

